MONHASH = {
:BULBASAUR => {
	"Normal Form" => {
		:name => "Bulbasaur",
		:dexnum => 1,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [45, 49, 49, 65, 65, 45],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:OVERGROW, :CHLOROPHYLL],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 64,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:CHARM,:CURSE,:ENDURE,:GIGADRAIN,:GRASSWHISTLE,:GRASSYTERRAIN,:INGRAIN,:LEAFSTORM,:MAGICALLEAF,:NATUREPOWER,:PETALDANCE,:POWERWHIP,:SKULLBASH,:SLUDGE,],
		:Moveset => [
			[1,:TACKLE],
			[3,:GROWL],
			[7,:LEECHSEED],
			[9,:VINEWHIP],
			[13,:POISONPOWDER],
			[13,:SLEEPPOWDER],
			[15,:TAKEDOWN],
			[19,:RAZORLEAF],
			[21,:SWEETSCENT],
			[25,:GROWTH],
			[27,:DOUBLEEDGE],
			[31,:WORRYSEED],
			[33,:SYNTHESIS],
			[37,:SEEDBOMB]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BIND,:BLOCK,:BODYSLAM,:BULLETSEED,:CELEBRATE,:CHARM,:CURSE,:CUT,:DEFENSECURL,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FALSESWIPE,:FLASH,:FRENZYPLANT,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:KNOCKOFF,:LEAFSTORM,:LIGHTSCREEN,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:POWERWHIP,:RAGE,:RAZORWIND,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:STRENGTH,:STRINGSHOT,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:VENOSHOCK,:WEATHERBALL,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 7,
		:Weight => 69,
		:kind => "Seed",
		:dexentry => "Bulbasaur can be seen napping in bright sunlight. There is a seed on its back. By soaking up the sun's rays, the seed grows progressively larger.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:IVYSAUR,:Level,16]
		]
	},

	:OnCreation => {},
},

:IVYSAUR => {
	"Normal Form" => {
		:name => "Ivysaur",
		:dexnum => 2,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [60, 62, 63, 80, 80, 60],
		:EVs => [0, 0, 0, 1, 1, 0],
		:Abilities => [:OVERGROW, :CHLOROPHYLL],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BULBASAUR,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[1,:LEECHSEED],
			[3,:GROWL],
			[7,:LEECHSEED],
			[9,:VINEWHIP],
			[13,:POISONPOWDER],
			[13,:SLEEPPOWDER],
			[15,:TAKEDOWN],
			[20,:RAZORLEAF],
			[23,:SWEETSCENT],
			[28,:GROWTH],
			[31,:DOUBLEEDGE],
			[36,:WORRYSEED],
			[39,:SYNTHESIS],
			[44,:SOLARBEAM]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BIND,:BLOCK,:BODYSLAM,:BULLETSEED,:CELEBRATE,:CHARM,:CURSE,:CUT,:DEFENSECURL,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FALSESWIPE,:FLASH,:FRENZYPLANT,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:KNOCKOFF,:LEAFSTORM,:LIGHTSCREEN,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:POWERWHIP,:RAGE,:RAZORWIND,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:STRENGTH,:STRINGSHOT,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:VENOSHOCK,:WEATHERBALL,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 10,
		:Weight => 130,
		:kind => "Seed",
		:dexentry => "To support its bulb, Ivysaur's legs grow sturdy. If it spends more time lying in the sunlight, the bud will soon bloom into a large flower.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VENUSAUR,:Level,32]
		]
	},

	:OnCreation => {},
},

:VENUSAUR => {
	"Normal Form" => {
		:name => "Venusaur",
		:dexnum => 3,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [80, 82, 83, 100, 100, 80],
		:EVs => [0, 0, 0, 2, 1, 0],
		:Abilities => [:OVERGROW, :CHLOROPHYLL],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 236,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :IVYSAUR,
			:form => 0
		},
		:Moveset => [
			[0,:PETALDANCE],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:LEECHSEED],
			[1,:VINEWHIP],
			[3,:GROWL],
			[7,:LEECHSEED],
			[9,:VINEWHIP],
			[13,:POISONPOWDER],
			[13,:SLEEPPOWDER],
			[15,:TAKEDOWN],
			[20,:RAZORLEAF],
			[23,:SWEETSCENT],
			[28,:GROWTH],
			[31,:DOUBLEEDGE],
			[39,:WORRYSEED],
			[45,:SYNTHESIS],
			[50,:PETALBLIZZARD],
			[53,:SOLARBEAM]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BIND,:BLOCK,:BODYSLAM,:BULLDOZE,:BULLETSEED,:CELEBRATE,:CHARM,:CURSE,:CUT,:DEFENSECURL,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENERGYBALL,:FALSESWIPE,:FLASH,:FRENZYPLANT,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:KNOCKOFF,:LEAFSTORM,:LIGHTSCREEN,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:POWERWHIP,:RAGE,:RAZORWIND,:REFLECT,:ROAR,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:STRINGSHOT,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:TERRAINPULSE,:VENOSHOCK,:WEATHERBALL,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 20,
		:Weight => 1000,
		:kind => "Seed",
		:dexentry => "Venusaur's flower is said to take on vivid colors if it gets plenty of nutrition and sunlight. The flower's aroma soothes the emotions of people.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [80, 100, 123, 122, 120, 80],
		:Abilities => [:THICKFAT],
		:Height => 24,
		:Weight => 1555,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:VENUSAURITE => 1,
	},
},

:CHARMANDER => {
	"Normal Form" => {
		:name => "Charmander",
		:dexnum => 4,
		:Type1 => :FIRE,
		:BaseStats => [39, 52, 43, 60, 50, 65],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:BLAZE, :SOLARPOWER],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AIRCUTTER,:ANCIENTPOWER,:BEATUP,:BELLYDRUM,:BITE,:COUNTER,:CRUNCH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRUSH,:FLAREBLITZ,:FOCUSPUNCH,:METALCLAW,:OUTRAGE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[7,:EMBER],
			[10,:SMOKESCREEN],
			[16,:DRAGONRAGE],
			[19,:SCARYFACE],
			[25,:FIREFANG],
			[28,:FLAMEBURST],
			[34,:SLASH],
			[37,:FLAMETHROWER],
			[43,:FIRESPIN],
			[46,:INFERNO]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:ANCIENTPOWER,:BEATUP,:BIDE,:BLASTBURN,:BLOCK,:BODYSLAM,:BRICKBREAK,:CELEBRATE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:DYNAMICPUNCH,:ECHOEDVOICE,:FALSESWIPE,:FIREBLAST,:FIREFANG,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:POWERUPPUNCH,:RAGE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SEISMICTOSS,:SHADOWCLAW,:SKULLBASH,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THUNDERPUNCH,:WEATHERBALL,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Monster, :Dragon],
		:Height => 6,
		:Weight => 85,
		:kind => "Lizard",
		:dexentry => "The flame that burns at the tip of its tail is an indication of its emotions. The flame wavers when Charmander is happy, and blazes when it is enraged.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CHARMELEON,:Level,16]
		]
	},

	:OnCreation => {},
},

:CHARMELEON => {
	"Normal Form" => {
		:name => "Charmeleon",
		:dexnum => 5,
		:Type1 => :FIRE,
		:BaseStats => [58, 64, 58, 80, 65, 80],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:BLAZE, :SOLARPOWER],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHARMANDER,
			:form => 0
		},
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:EMBER],
			[7,:EMBER],
			[10,:SMOKESCREEN],
			[17,:DRAGONRAGE],
			[21,:SCARYFACE],
			[28,:FIREFANG],
			[32,:FLAMEBURST],
			[39,:SLASH],
			[43,:FLAMETHROWER],
			[50,:FIRESPIN],
			[54,:INFERNO]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:ANCIENTPOWER,:BEATUP,:BIDE,:BLASTBURN,:BLOCK,:BODYSLAM,:BRICKBREAK,:CELEBRATE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:DYNAMICPUNCH,:ECHOEDVOICE,:FALSESWIPE,:FIREBLAST,:FIREFANG,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:POWERUPPUNCH,:RAGE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SEISMICTOSS,:SHADOWCLAW,:SKULLBASH,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THUNDERPUNCH,:WEATHERBALL,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Monster, :Dragon],
		:Height => 11,
		:Weight => 190,
		:kind => "Flame",
		:dexentry => "Without pity, its sharp claws destroy foes. If it encounters a strong enemy, it becomes agitated, and the flame on its tail flares with a bluish white color.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CHARIZARD,:Level,36]
		]
	},

	:OnCreation => {},
},

:CHARIZARD => {
	"Normal Form" => {
		:name => "Charizard",
		:dexnum => 6,
		:Type1 => :FIRE,
		:Type2 => :FLYING,
		:BaseStats => [78, 84, 78, 109, 85, 100],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:BLAZE, :SOLARPOWER],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 240,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHARMELEON,
			:form => 0
		},
		:Moveset => [
			[0,:WINGATTACK],
			[1,:FLAREBLITZ],
			[1,:HEATWAVE],
			[1,:AIRSLASH],
			[1,:DRAGONCLAW],
			[1,:SHADOWCLAW],
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:SMOKESCREEN],
			[1,:EMBER],
			[7,:EMBER],
			[10,:SMOKESCREEN],
			[17,:DRAGONRAGE],
			[21,:SCARYFACE],
			[28,:FIREFANG],
			[32,:FLAMEBURST],
			[41,:SLASH],
			[47,:FLAMETHROWER],
			[56,:FIRESPIN],
			[62,:INFERNO],
			[71,:HEATWAVE],
			[77,:FLAREBLITZ]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:BEATUP,:BIDE,:BLASTBURN,:BLAZEKICK,:BLOCK,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CELEBRATE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DEFOG,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:DUALWINGBEAT,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:FALSESWIPE,:FIREBLAST,:FIREFANG,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FISSURE,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FLY,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HELPINGHAND,:HOLDHANDS,:HONECLAWS,:HURRICANE,:HYPERBEAM,:INCINERATE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OMINOUSWIND,:OUTRAGE,:OVERHEAT,:POWERUPPUNCH,:RAGE,:REFLECT,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SCALESHOT,:SCARYFACE,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SKULLBASH,:SKYDROP,:SOLARBEAM,:STEELWING,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAKEDOWN,:THUNDERPUNCH,:TWISTER,:WEATHERBALL,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Monster, :Dragon],
		:Height => 17,
		:Weight => 905,
		:kind => "Flame",
		:dexentry => "A Charizard flies about in search of strong opponents. It breathes intense flames that can melt any material. However, it will never torch a weaker foe.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 0,
	},

	"Mega X" => {
		:Type2 => :DRAGON,
		:BaseStats => [78, 130, 111, 130, 85, 100],
		:Abilities => [:TOUGHCLAWS],
		:Weight => 1105,
	},

	"Mega Y" => {
		:BaseStats => [78, 104, 78, 159, 115, 100],
		:Abilities => [:DROUGHT],
		:Weight => 1005,
	},

	:OnCreation => {},
	:DefaultForm => 0,
  	:MegaForm => {
		:CHARIZARDITEX => 1,
		:CHARIZARDITEY => 2
	},
},

:SQUIRTLE => {
	"Normal Form" => {
		:name => "Squirtle",
		:dexnum => 7,
		:Type1 => :WATER,
		:BaseStats => [44, 48, 65, 50, 64, 43],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:TORRENT, :RAINDISH],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUAJET,:AQUARING,:AURASPHERE,:BRINE,:DRAGONPULSE,:FAKEOUT,:FLAIL,:FORESIGHT,:HAZE,:MIRRORCOAT,:MIST,:MUDSPORT,:MUDDYWATER,:REFRESH,:WATERSPOUT,:YAWN,],
		:Moveset => [
			[1,:TACKLE],
			[4,:TAILWHIP],
			[7,:WATERGUN],
			[10,:WITHDRAW],
			[13,:BUBBLE],
			[16,:BITE],
			[19,:RAPIDSPIN],
			[22,:PROTECT],
			[25,:WATERPULSE],
			[28,:AQUATAIL],
			[31,:SKULLBASH],
			[34,:IRONDEFENSE],
			[37,:RAINDANCE],
			[40,:HYDROPUMP]],
		:compatiblemoves => [:AQUATAIL,:AURASPHERE,:BIDE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CELEBRATE,:COUNTER,:CURSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DRAGONPULSE,:DYNAMICPUNCH,:FAKEOUT,:FALSESWIPE,:FLING,:FLIPTURN,:FOCUSPUNCH,:GYROBALL,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROCANNON,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RAINDANCE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:TAKEDOWN,:WATERFALL,:WATERGUN,:WATERPLEDGE,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 5,
		:Weight => 90,
		:kind => "Tiny Turtle",
		:dexentry => "Its shell is not just for protection. Its rounded shape and the grooves on its surface minimize resistance in water, enabling Squirtle to swim at high speeds.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WARTORTLE,:Level,16]
		]
	},

	:OnCreation => {},
},

:WARTORTLE => {
	"Normal Form" => {
		:name => "Wartortle",
		:dexnum => 8,
		:Type1 => :WATER,
		:BaseStats => [59, 63, 80, 65, 80, 58],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:TORRENT, :RAINDISH],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SQUIRTLE,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:WATERGUN],
			[4,:TAILWHIP],
			[7,:WATERGUN],
			[10,:WITHDRAW],
			[13,:BUBBLE],
			[17,:BITE],
			[21,:RAPIDSPIN],
			[25,:PROTECT],
			[29,:WATERPULSE],
			[33,:AQUATAIL],
			[37,:SKULLBASH],
			[41,:IRONDEFENSE],
			[45,:RAINDANCE],
			[49,:HYDROPUMP]],
		:compatiblemoves => [:AQUATAIL,:AURASPHERE,:BIDE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CELEBRATE,:COUNTER,:CURSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DRAGONPULSE,:DYNAMICPUNCH,:FAKEOUT,:FALSESWIPE,:FLING,:FLIPTURN,:FOCUSPUNCH,:GYROBALL,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROCANNON,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RAINDANCE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:TAKEDOWN,:WATERFALL,:WATERGUN,:WATERPLEDGE,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 10,
		:Weight => 225,
		:kind => "Turtle",
		:dexentry => "Its large tail is covered with rich, thick fur that deepens in color with age. The scratches on its shell are evidence of this Pokémon's toughness in battle.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BLASTOISE,:Level,36]
		]
	},

	:OnCreation => {},
},

:BLASTOISE => {
	"Normal Form" => {
		:name => "Blastoise",
		:dexnum => 9,
		:Type1 => :WATER,
		:BaseStats => [79, 83, 100, 85, 105, 78],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:TORRENT, :RAINDISH],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WARTORTLE,
			:form => 0
		},
		:Moveset => [
			[1,:FLASHCANNON],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:WATERGUN],
			[1,:WITHDRAW],
			[4,:TAILWHIP],
			[7,:WATERGUN],
			[10,:WITHDRAW],
			[13,:BUBBLE],
			[17,:BITE],
			[21,:RAPIDSPIN],
			[25,:PROTECT],
			[29,:WATERPULSE],
			[33,:AQUATAIL],
			[40,:SKULLBASH],
			[47,:IRONDEFENSE],
			[54,:RAINDANCE],
			[60,:HYDROPUMP]],
		:compatiblemoves => [:AQUATAIL,:AURASPHERE,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:BULLDOZE,:CELEBRATE,:COUNTER,:CURSE,:DARKPULSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONTAIL,:DYNAMICPUNCH,:EARTHQUAKE,:FAKEOUT,:FALSESWIPE,:FISSURE,:FLASHCANNON,:FLING,:FLIPTURN,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GYROBALL,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROCANNON,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:IRONTAIL,:LIQUIDATION,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RAINDANCE,:REFLECT,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SEISMICTOSS,:SIGNALBEAM,:SKULLBASH,:SMACKDOWN,:STRENGTH,:SUBMISSION,:SURF,:TAKEDOWN,:TERRAINPULSE,:WATERFALL,:WATERGUN,:WATERPLEDGE,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 16,
		:Weight => 855,
		:kind => "Shellfish",
		:dexentry => "The waterspouts that protrude from its shell are highly accurate. Their bullets of water can precisely nail tin cans from a distance of over 160 feet.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [79, 103, 120, 135, 115, 78],
		:Abilities => [:MEGALAUNCHER],
		:Weight => 1011,
	},
	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:BLASTOISINITE => 1,
	},
},

:CATERPIE => {
	"Normal Form" => {
		:name => "Caterpie",
		:dexnum => 10,
		:Type1 => :BUG,
		:BaseStats => [45, 30, 35, 20, 20, 45],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SHIELDDUST, :RUNAWAY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 39,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:TACKLE],
			[1,:STRINGSHOT],
			[9,:BUGBITE]],
		:compatiblemoves => [:BUGBITE,:ELECTROWEB,:STRINGSHOT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 3,
		:Weight => 29,
		:kind => "Worm",
		:dexentry => "Its voracious appetite compels it to devour leaves bigger than itself without hesitation. It releases a terribly strong odor from its antennae.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:METAPOD,:Level,7]
		]
	},

	:OnCreation => {},
},

:METAPOD => {
	"Normal Form" => {
		:name => "Metapod",
		:dexnum => 11,
		:Type1 => :BUG,
		:BaseStats => [50, 20, 55, 25, 25, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :OVERCOAT],	# Overcoat added so the ability index is maintained on evolution, don't worry about it  - Fal
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 72,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :CATERPIE,
			:form => 0
		},
		:Moveset => [
			[0,:HARDEN],
			[1,:HARDEN]],
		:compatiblemoves => [:BUGBITE,:ELECTROWEB,:IRONDEFENSE,:STRINGSHOT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 7,
		:Weight => 99,
		:kind => "Cocoon",
		:dexentry => "Its shell is as hard as an iron slab. A Metapod does not move very much because it is preparing its soft innards for evolution inside the shell.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BUTTERFREE,:Level,10]
		]
	},

	:OnCreation => {},
},

:BUTTERFREE => {
	"Normal Form" => {
		:name => "Butterfree",
		:dexnum => 12,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [60, 45, 50, 90, 80, 70],
		:EVs => [0, 0, 0, 2, 1, 0],
		:Abilities => [:COMPOUNDEYES, :TINTEDLENS],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :METAPOD,
			:form => 0
		},
		:Moveset => [
			[0,:GUST],
			[1,:CONFUSION],
			[11,:CONFUSION],
			[13,:POISONPOWDER],
			[13,:STUNSPORE],
			[13,:SLEEPPOWDER],
			[17,:PSYBEAM],
			[19,:SILVERWIND],
			[23,:SUPERSONIC],
			[25,:SAFEGUARD],
			[29,:WHIRLWIND],
			[31,:BUGBUZZ],
			[35,:RAGEPOWDER],
			[37,:CAPTIVATE],
			[41,:TAILWIND],
			[43,:AIRSLASH],
			[47,:QUIVERDANCE]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:AIRSLASH,:BATONPASS,:BIDE,:BUGBITE,:BUGBUZZ,:CURSE,:DEFOG,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:DUALWINGBEAT,:ELECTROWEB,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HURRICANE,:HYPERBEAM,:INFESTATION,:IRONDEFENSE,:MEGADRAIN,:MIMIC,:NIGHTMARE,:OMINOUSWIND,:POLLENPUFF,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:ROOST,:SAFEGUARD,:SHADOWBALL,:SIGNALBEAM,:SILVERWIND,:SKILLSWAP,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWIFT,:TAILWIND,:TAKEDOWN,:TELEPORT,:THIEF,:TWISTER,:UTURN,:VENOSHOCK,:WHIRLWIND,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWMIST,],
		:Color => "White",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 11,
		:Weight => 320,
		:WildItemUncommon => :SILVERPOWDER,
		:kind => "Butterfly",
		:dexentry => "It has a superior ability to search for delicious honey from flowers. It can seek, extract, and carry honey from flowers blooming over six miles away.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 15,
	},

	:OnCreation => {},
},

:WEEDLE => {
	"Normal Form" => {
		:name => "Weedle",
		:dexnum => 13,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [40, 35, 30, 20, 20, 50],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SHIELDDUST, :RUNAWAY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 39,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:POISONSTING],
			[1,:STRINGSHOT],
			[9,:BUGBITE]],
		:compatiblemoves => [:BUGBITE,:ELECTROWEB,:STRINGSHOT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 3,
		:Weight => 32,
		:kind => "Hairy Bug",
		:dexentry => "A Weedle has an extremely acute sense of smell. It distinguishes its favorite kinds of leaves from those it dislikes by sniffing with its big red nose.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KAKUNA,:Level,7]
		]
	},

	:OnCreation => {},
},

:KAKUNA => {
	"Normal Form" => {
		:name => "Kakuna",
		:dexnum => 14,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [45, 25, 50, 25, 25, 35],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :OVERCOAT],	# Overcoat added so the ability index is maintained on evolution, don't worry about it  - Fal
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 72,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :WEEDLE,
			:form => 0
		},
		:Moveset => [
			[0,:HARDEN],
			[1,:HARDEN]],
		:compatiblemoves => [:BUGBITE,:ELECTROWEB,:IRONDEFENSE,:STRINGSHOT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 6,
		:Weight => 100,
		:kind => "Cocoon",
		:dexentry => "It remains virtually immobile while it clings to a tree. However, on the inside, it busily prepares for evolution. This is evident from how hot its shell becomes.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 11,
		:evolutions => [
			[:BEEDRILL,:Level,10]
		]
	},

	:OnCreation => {},
},

:BEEDRILL => {
	"Normal Form" => {
		:name => "Beedrill",
		:dexnum => 15,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [65, 90, 40, 45, 80, 75],
		:EVs => [0, 2, 0, 0, 1, 0],
		:Abilities => [:SWARM, :SNIPER],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :KAKUNA,
			:form => 0
		},
		:Moveset => [
			[0,:TWINEEDLE],
			[1,:FURYATTACK],
			[11,:FURYATTACK],
			[14,:RAGE],
			[17,:PURSUIT],
			[20,:FOCUSENERGY],
			[23,:VENOSHOCK],
			[26,:ASSURANCE],
			[29,:TOXICSPIKES],
			[32,:PINMISSILE],
			[35,:POISONJAB],
			[38,:AGILITY],
			[41,:ENDEAVOR],
			[44,:FELLSTINGER]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BATONPASS,:BEATUP,:BIDE,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BUGBUZZ,:CROSSPOISON,:CURSE,:CUT,:DEFOG,:DOUBLEEDGE,:DRILLRUN,:DUALWINGBEAT,:ELECTROWEB,:ENDEAVOR,:FALSESWIPE,:FLASH,:FOCUSENERGY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:INFESTATION,:KNOCKOFF,:LASERFOCUS,:MEGAHORN,:MIMIC,:OMINOUSWIND,:PAYBACK,:PINMISSILE,:POISONJAB,:RAGE,:ROCKSMASH,:ROOST,:SILVERWIND,:SKITTERSMACK,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAKEDOWN,:THIEF,:THROATCHOP,:TOXICSPIKES,:UTURN,:VENOMDRENCH,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWHOLD,],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 10,
		:Weight => 295,
		:WildItemUncommon => :POISONBARB,
		:kind => "Poison Bee",
		:dexentry => "A Beedrill is extremely territorial. For safety reasons, no one should ever approach its nest. If angered, they will attack in a swarm.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 11,
	},

	"Mega Form" => {
		:BaseStats => [65, 150, 40, 15, 80, 145],
		:Abilities => [:ADAPTABILITY],
		:Height => 14,
		:Weight => 405,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:BEEDRILLITE => 1,
	},
},

:PIDGEY => {
	"Normal Form" => {
		:name => "Pidgey",
		:dexnum => 16,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [40, 45, 40, 35, 35, 56],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:KEENEYE, :TANGLEDFEET],
		:HiddenAbilities => :BIGPECKS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AIRCUTTER,:AIRSLASH,:BRAVEBIRD,:DEFOG,:FEINTATTACK,:FORESIGHT,:PURSUIT,:STEELWING,:UPROAR,],
		:Moveset => [
			[1,:TACKLE],
			[5,:SANDATTACK],
			[9,:GUST],
			[13,:QUICKATTACK],
			[17,:WHIRLWIND],
			[21,:TWISTER],
			[25,:FEATHERDANCE],
			[29,:AGILITY],
			[33,:WINGATTACK],
			[37,:ROOST],
			[41,:TAILWIND],
			[45,:MIRRORMOVE],
			[49,:AIRSLASH],
			[53,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BIDE,:BRAVEBIRD,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:FEINTATTACK,:FLY,:HEADBUTT,:HEATWAVE,:HURRICANE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:ROOST,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THIEF,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 3,
		:Weight => 18,
		:kind => "Tiny Bird",
		:dexentry => "It has an extremely sharp sense of direction. It can unerringly return home to its nest, however far it may be removed from its familiar surroundings.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PIDGEOTTO,:Level,18]
		]
	},

	:OnCreation => {},
},

:PIDGEOTTO => {
	"Normal Form" => {
		:name => "Pidgeotto",
		:dexnum => 17,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [63, 60, 55, 50, 50, 71],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:KEENEYE, :TANGLEDFEET],
		:HiddenAbilities => :BIGPECKS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 122,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :PIDGEY,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:GUST],
			[5,:SANDATTACK],
			[9,:GUST],
			[13,:QUICKATTACK],
			[17,:WHIRLWIND],
			[22,:TWISTER],
			[27,:FEATHERDANCE],
			[32,:AGILITY],
			[37,:WINGATTACK],
			[42,:ROOST],
			[47,:TAILWIND],
			[52,:MIRRORMOVE],
			[57,:AIRSLASH],
			[62,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BIDE,:BRAVEBIRD,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FEINTATTACK,:FLY,:HEADBUTT,:HEATWAVE,:HURRICANE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:ROOST,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THIEF,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWPANIC,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 11,
		:Weight => 300,
		:kind => "Bird",
		:dexentry => "This Pokémon flies around, patrolling its large territory. If its living space is violated, it shows no mercy in thoroughly punishing the foe with its sharp claws.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PIDGEOT,:Level,36]
		]
	},

	:OnCreation => {},
},

:PIDGEOT => {
	"Normal Form" => {
		:name => "Pidgeot",
		:dexnum => 18,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [83, 80, 75, 70, 70, 101],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:KEENEYE, :TANGLEDFEET],
		:HiddenAbilities => :BIGPECKS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 211,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :PIDGEOTTO,
			:form => 0
		},
		:Moveset => [
			[1,:HURRICANE],
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:GUST],
			[1,:QUICKATTACK],
			[5,:SANDATTACK],
			[9,:GUST],
			[13,:QUICKATTACK],
			[17,:WHIRLWIND],
			[22,:TWISTER],
			[27,:FEATHERDANCE],
			[32,:AGILITY],
			[38,:WINGATTACK],
			[44,:ROOST],
			[50,:TAILWIND],
			[56,:MIRRORMOVE],
			[62,:AIRSLASH],
			[68,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BIDE,:BRAVEBIRD,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FEINTATTACK,:FLY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:LASERFOCUS,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:REFLECT,:ROOST,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THIEF,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 15,
		:Weight => 395,
		:kind => "Bird",
		:dexentry => "This Pokémon has gorgeous feathers. Many Trainers are so captivated by the feathers on its head, that they choose Pidgeot as their Pokémon.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 11,
	},

	"Mega Form" => {
		:BaseStats => [83, 80, 80, 135, 80, 121],
		:Abilities => [:NOGUARD],
		:Height => 22,
		:Weight => 505,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:PIDGEOTITE => 1,
	},
},

:RATTATA => {
	"Normal Form" => {
		:name => "Rattata",
		:dexnum => 19,
		:Type1 => :NORMAL,
		:BaseStats => [30, 56, 35, 25, 35, 72],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:RUNAWAY, :GUTS],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 51,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BITE,:COUNTER,:FINALGAMBIT,:FLAMEWHEEL,:FURYSWIPES,:LASTRESORT,:MEFIRST,:REVENGE,:REVERSAL,:SCREECH,:UPROAR,],
		:Moveset => [
			[1,:TACKLE],
			[1,:TAILWHIP],
			[4,:QUICKATTACK],
			[7,:FOCUSENERGY],
			[10,:BITE],
			[13,:PURSUIT],
			[16,:HYPERFANG],
			[19,:ASSURANCE],
			[22,:CRUNCH],
			[25,:SUCKERPUNCH],
			[28,:SUPERFANG],
			[31,:DOUBLEEDGE],
			[34,:ENDEAVOR]],
		:compatiblemoves => [:ASSURANCE,:BIDE,:BLIZZARD,:BODYSLAM,:BUBBLEBEAM,:CHARGEBEAM,:COUNTER,:COVET,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:ENDEAVOR,:FOCUSENERGY,:GRASSKNOT,:HEADBUTT,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:MIMIC,:MUDSLAP,:PLUCK,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKSMASH,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAKEDOWN,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:UPROAR,:UTURN,:WATERGUN,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 3,
		:Weight => 35,
		:kind => "Mouse",
		:dexentry => "A Rattata is cautious in the extreme. Even while it is asleep, it constantly moves its ears and listens for danger. It will make its nest anywhere.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RATICATE,:Level,20]
		]
	},

	"Alolan Form" => {
		:Type1 => :DARK,
		:Type2 => :NORMAL,
		:Abilities => [:GLUTTONY, :HUSTLE, :THICKFAT],
		:EggMoves => [:COUNTER,:FINALGAMBIT,:FURYSWIPES,:MEFIRST,:REVENGE,:REVERSAL,:SNATCH,:STOCKPILE,:SWALLOW,:SWITCHEROO,:UPROAR,],
		:Moveset => [
			[1,:TACKLE],
			[1,:TAILWHIP],
			[4,:QUICKATTACK],
			[7,:FOCUSENERGY],
			[10,:BITE],
			[13,:PURSUIT],
			[16,:HYPERFANG],
			[19,:ASSURANCE],
			[22,:CRUNCH],
			[25,:SUCKERPUNCH],
			[29,:SUPERFANG],
			[31,:DOUBLEEDGE],
			[34,:ENDEAVOR],
		],
		:compatiblemoves => [:ASSURANCE,:BLIZZARD,:COUNTER,:COVET,:CRUNCH,:DARKPULSE,:EMBARGO,:ENDEAVOR,:FOCUSENERGY,:GRASSKNOT,:HEADBUTT,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:QUASH,:RAINDANCE,:REVENGE,:REVERSAL,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SLUDGEBOMB,:SNARL,:SNATCH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAUNT,:THIEF,:TORMENT,:UPROAR,:UTURN,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Weight => 38,
		:WildItemUncommon => :PECHABERRY,
		:dexentry => "With its incisors, it gnaws through doors and infiltrates people's homes. Then, with a twitch of its whiskers, it steals whatever food it finds.",
		:evolutions => [
			[:RATICATE,:LevelNight,20]
		]
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Rattata.include?($game_map.map_id) ? 1 : 0
 },
},

:RATICATE => {
	"Normal Form" => {
		:name => "Raticate",
		:dexnum => 20,
		:Type1 => :NORMAL,
		:BaseStats => [55, 81, 60, 50, 70, 97],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:RUNAWAY, :GUTS],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 145,
		:CatchRate => 127,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :RATTATA,
			:form => 0
		},
		:Moveset => [
			[0,:SCARYFACE],
			[1,:SWORDSDANCE],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:QUICKATTACK],
			[1,:FOCUSENERGY],
			[4,:QUICKATTACK],
			[7,:FOCUSENERGY],
			[10,:BITE],
			[13,:PURSUIT],
			[16,:HYPERFANG],
			[19,:ASSURANCE],
			[24,:CRUNCH],
			[29,:SUCKERPUNCH],
			[34,:SUPERFANG],
			[39,:DOUBLEEDGE],
			[44,:ENDEAVOR]],
		:compatiblemoves => [:AGILITY,:ASSURANCE,:BIDE,:BLIZZARD,:BODYSLAM,:BUBBLEBEAM,:CHARGEBEAM,:COUNTER,:COVET,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:ENDEAVOR,:FOCUSENERGY,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:MIMIC,:MUDSLAP,:PLAYROUGH,:PLUCK,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROAR,:ROCKSMASH,:SCARYFACE,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:UTURN,:WATERGUN,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWDOWN,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 7,
		:Weight => 185,
		:kind => "Mouse",
		:dexentry => "A Raticate's sturdy fangs grow steadily. To keep them ground down, it gnaws on rocks and logs. It may even chew on the walls of houses.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type1 => :DARK,
		:Type2 => :NORMAL,
		:BaseStats => [75, 71, 70, 40, 80, 77],
		:Abilities => [:GLUTTONY, :HUSTLE, :THICKFAT],
		:preevo => {
			:species => :RATTATA,
			:form => 1
		},
		:Moveset => [
			[0,:SCARYFACE],
			[1,:SWORDSDANCE],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:QUICKATTACK],
			[1,:FOCUSENERGY],
			[4,:QUICKATTACK],
			[7,:FOCUSENERGY],
			[10,:BITE],
			[13,:PURSUIT],
			[16,:HYPERFANG],
			[19,:ASSURANCE],
			[24,:CRUNCH],
			[29,:SUCKERPUNCH],
			[34,:SUPERFANG],
			[39,:DOUBLEEDGE],
			[44,:ENDEAVOR],
		],
		:compatiblemoves => [:AGILITY,:ASSURANCE,:BEATUP,:BLIZZARD,:BULKUP,:COUNTER,:COVET,:CRUNCH,:DARKPULSE,:EMBARGO,:ENDEAVOR,:FIREFANG,:FOCUSENERGY,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:PLAYROUGH,:QUASH,:RAINDANCE,:REVENGE,:REVERSAL,:ROAR,:SCARYFACE,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SNARL,:SNATCH,:STOMPINGTANTRUM,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:UPROAR,:UTURN,:VENOSHOCK,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Weight => 255,
		:WildItemUncommon => :PECHABERRY,
		:dexentry => "It forms a group of Rattata, which it assumes command of. Each group has its own territory, and disputes over food happen often.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Rattata.include?($game_map.map_id) ? 1 : 0
 },
},

:SPEAROW => {
	"Normal Form" => {
		:name => "Spearow",
		:dexnum => 21,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [40, 60, 30, 31, 31, 70],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:KEENEYE, :SNIPER],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 52,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ASTONISH,:FEINTATTACK,:FEATHERDANCE,:QUICKATTACK,:RAZORWIND,:SCARYFACE,:SKYATTACK,:STEELWING,:TRIATTACK,:UPROAR,:WHIRLWIND,],
		:Moveset => [
			[1,:PECK],
			[1,:GROWL],
			[4,:LEER],
			[8,:PURSUIT],
			[11,:FURYATTACK],
			[15,:AERIALACE],
			[18,:MIRRORMOVE],
			[22,:ASSURANCE],
			[25,:AGILITY],
			[29,:FOCUSENERGY],
			[32,:ROOST],
			[36,:DRILLPECK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:ASSURANCE,:BATONPASS,:BIDE,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DRILLRUN,:ECHOEDVOICE,:FALSESWIPE,:FEINTATTACK,:FLY,:FOCUSENERGY,:HEADBUTT,:HEATWAVE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:ROOST,:SCARYFACE,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THIEF,:TRIATTACK,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWPANIC,],
		:Color => "Brown",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Flying],
		:Height => 3,
		:Weight => 20,
		:WildItemUncommon => :SHARPBEAK,
		:kind => "Tiny Bird",
		:dexentry => "Its loud cry can be heard over half a mile away. If its high, keening cry is heard echoing all around, it is a sign that they are warning of danger.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:FEAROW,:Level,20]
		]
	},

	:OnCreation => {},
},

:FEAROW => {
	"Normal Form" => {
		:name => "Fearow",
		:dexnum => 22,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [65, 90, 65, 61, 61, 100],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:KEENEYE, :SNIPER],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 155,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SPEAROW,
			:form => 0
		},
		:Moveset => [
			[1,:DRILLRUN],
			[1,:PLUCK],
			[1,:PECK],
			[1,:GROWL],
			[1,:LEER],
			[1,:PURSUIT],
			[4,:LEER],
			[8,:PURSUIT],
			[11,:FURYATTACK],
			[15,:AERIALACE],
			[18,:MIRRORMOVE],
			[23,:ASSURANCE],
			[27,:AGILITY],
			[32,:FOCUSENERGY],
			[36,:ROOST],
			[41,:DRILLPECK],
			[45,:DRILLRUN]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BATONPASS,:BIDE,:BRAVEBIRD,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DRILLRUN,:DUALWINGBEAT,:ECHOEDVOICE,:FALSESWIPE,:FEINTATTACK,:FLY,:FOCUSENERGY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:LASERFOCUS,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:ROOST,:SCARYFACE,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THIEF,:THROATCHOP,:TRIATTACK,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Flying],
		:Height => 12,
		:Weight => 380,
		:WildItemUncommon => :SHARPBEAK,
		:kind => "Beak",
		:dexentry => "Its long neck and elongated beak are ideal for catching prey in soil or water. It deftly moves this extended and skinny beak to pluck prey.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 8,
	},

	:OnCreation => {},
},

:EKANS => {
	"Normal Form" => {
		:name => "Ekans",
		:dexnum => 23,
		:Type1 => :POISON,
		:BaseStats => [35, 60, 44, 40, 54, 55],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :SHEDSKIN],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BEATUP,:DISABLE,:IRONTAIL,:POISONFANG,:POISONTAIL,:PURSUIT,:SCARYFACE,:SLAM,:SNATCH,:SPITE,:SUCKERPUNCH,:SWITCHEROO,],
		:Moveset => [
			[1,:WRAP],
			[1,:LEER],
			[4,:POISONSTING],
			[9,:BITE],
			[12,:GLARE],
			[17,:SCREECH],
			[20,:ACID],
			[25,:STOCKPILE],
			[25,:SPITUP],
			[25,:SWALLOW],
			[28,:ACIDSPRAY],
			[33,:MUDBOMB],
			[36,:GASTROACID],
			[38,:BELCH],
			[41,:HAZE],
			[44,:COIL],
			[49,:GUNKSHOT]],
		:compatiblemoves => [:AQUATAIL,:BEATUP,:BIDE,:BIND,:BODYSLAM,:BRUTALSWING,:BULLDOZE,:CRUNCH,:CURSE,:DARKPULSE,:DIG,:DOUBLEEDGE,:EARTHQUAKE,:FISSURE,:GASTROACID,:GIGADRAIN,:GUNKSHOT,:HEADBUTT,:INFESTATION,:IRONTAIL,:MIMIC,:PAYBACK,:POISONJAB,:RAGE,:RAINDANCE,:ROCKSLIDE,:ROCKTOMB,:SCARYFACE,:SCREECH,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:THIEF,:TORMENT,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Field, :Dragon],
		:Height => 20,
		:Weight => 69,
		:kind => "Snake",
		:dexentry => "An Ekans curls itself up in a spiral while it rests. This position allows it to quickly respond to an enemy from any direction with its upraised head.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ARBOK,:Level,22]
		]
	},

	:OnCreation => {},
},

:ARBOK => {
	"Normal Form" => {
		:name => "Arbok",
		:dexnum => 24,
		:Type1 => :POISON,
		:BaseStats => [60, 95, 69, 65, 79, 80],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :SHEDSKIN],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 153,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :EKANS,
			:form => 0
		},
		:Moveset => [
			[0,:CRUNCH],
			[1,:ICEFANG],
			[1,:THUNDERFANG],
			[1,:FIREFANG],
			[1,:WRAP],
			[1,:LEER],
			[1,:BITE],
			[1,:POISONSTING],
			[4,:POISONSTING],
			[9,:BITE],
			[12,:GLARE],
			[17,:SCREECH],
			[20,:ACID],
			[27,:STOCKPILE],
			[27,:SPITUP],
			[27,:SWALLOW],
			[32,:ACIDSPRAY],
			[39,:MUDBOMB],
			[44,:GASTROACID],
			[48,:BELCH],
			[51,:HAZE],
			[56,:COIL],
			[63,:GUNKSHOT]],
		:compatiblemoves => [:AQUATAIL,:BEATUP,:BIDE,:BIND,:BODYSLAM,:BRUTALSWING,:BULLDOZE,:CORROSIVEGAS,:CROSSPOISON,:CRUNCH,:CURSE,:DARKPULSE,:DIG,:DOUBLEEDGE,:DRAGONTAIL,:EARTHQUAKE,:FIREFANG,:FISSURE,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HYPERBEAM,:ICEFANG,:INFESTATION,:IRONTAIL,:MEGADRAIN,:MIMIC,:PAYBACK,:POISONJAB,:PSYCHICFANGS,:RAGE,:RAINDANCE,:ROCKSLIDE,:ROCKTOMB,:SCARYFACE,:SCREECH,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:THIEF,:THROATCHOP,:THUNDERFANG,:TORMENT,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWHALF,],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Field, :Dragon],
		:Height => 35,
		:Weight => 650,
		:kind => "Cobra",
		:dexentry => "This Pokémon has a terrifically strong constricting power. It can even flatten steel oil drums. Once it wraps its body around its foe, escaping is impossible.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PIKACHU => {
	"Normal Form" => {
		:name => "Pikachu",
		:dexnum => 25,
		:Type1 => :ELECTRIC,
		:BaseStats => [35, 55, 40, 50, 50, 90],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:STATIC, :LIGHTNINGROD],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 105,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :PICHU,
			:form => 0
		},
		:Moveset => [
			[1,:EXTREMESPEED],
			[1,:SING],
			[1,:YAWN],
			[1,:TAILWHIP],
			[1,:THUNDERSHOCK],
			[5,:GROWL],
			[7,:PLAYNICE],
			[10,:QUICKATTACK],
			[13,:ELECTROBALL],
			[18,:THUNDERWAVE],
			[21,:FEINT],
			[23,:DOUBLETEAM],
			[26,:SPARK],
			[29,:NUZZLE],
			[34,:DISCHARGE],
			[37,:SLAM],
			[42,:THUNDERBOLT],
			[45,:AGILITY],
			[50,:WILDCHARGE],
			[53,:LIGHTSCREEN],
			[58,:THUNDER]],
		:compatiblemoves => [:AGILITY,:BABYDOLLEYES,:BIDE,:BODYSLAM,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ECHOEDVOICE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:ENCORE,:ENDEAVOR,:EXTREMESPEED,:FAKEOUT,:FLASH,:FLING,:FOCUSPUNCH,:GRASSKNOT,:HAPPYHOUR,:HEADBUTT,:HELPINGHAND,:HOLDHANDS,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYDAY,:PLAYROUGH,:RAGE,:RAINDANCE,:REFLECT,:REVERSAL,:RISINGVOLTAGE,:ROCKSMASH,:ROLLOUT,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:SWEETSCENT,:SWIFT,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:VOLTTACKLE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Fairy],
		:Height => 4,
		:Weight => 60,
		:WildItemRare => :LIGHTBALL,
		:kind => "Mouse",
		:dexentry => "It stores electricity in the electric sacs on its cheeks. When it releases pent-up energy in a burst, the electric power is equal to a lightning bolt.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RAICHU,:Item,:THUNDERSTONE]
		]
	},

	:OnCreation => {},
},

:RAICHU => {
	"Normal Form" => {
		:name => "Raichu",
		:dexnum => 26,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 90, 55, 90, 80, 110],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:STATIC, :LIGHTNINGROD],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 214,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :PIKACHU,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERSHOCK],
			[1,:TAILWHIP],
			[1,:QUICKATTACK],
			[1,:THUNDERBOLT]],
		:compatiblemoves => [:AGILITY,:BABYDOLLEYES,:BIDE,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:CALMMIND,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ECHOEDVOICE,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:ENCORE,:ENDEAVOR,:EXTREMESPEED,:FAKEOUT,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:HAPPYHOUR,:HEADBUTT,:HELPINGHAND,:HOLDHANDS,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYDAY,:PLAYROUGH,:RAGE,:RAINDANCE,:REFLECT,:REVERSAL,:RISINGVOLTAGE,:ROCKSMASH,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SPEEDSWAP,:STRENGTH,:SUBMISSION,:SURF,:SWEETSCENT,:SWIFT,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:VOLTTACKLE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Fairy],
		:Height => 8,
		:Weight => 300,
		:kind => "Mouse",
		:dexentry => "If it stores too much electricity, its behavior turns aggressive. To avoid this, it occasionally discharges excess energy and calms itself down.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 85, 50, 95, 85, 110],
		:Abilities => [:SURGESURFER],
		:Moveset => [
			[0,:PSYCHIC],
			[1,:SPEEDSWAP],
			[1,:THUNDERSHOCK],
			[1,:TAILWHIP],
			[1,:QUICKATTACK],
			[1,:THUNDERBOLT],
		],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BABYDOLLEYES,:BIDE,:BODYSLAM,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ECHOEDVOICE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:ENCORE,:ENDEAVOR,:EXPANDINGFORCE,:EXTREMESPEED,:FAKEOUT,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HAPPYHOUR,:HEADBUTT,:HELPINGHAND,:HOLDHANDS,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYDAY,:PLAYROUGH,:PSYCHIC,:PSYSHOCK,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:REVERSAL,:RISINGVOLTAGE,:ROCKSMASH,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SPEEDSWAP,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SURF,:SWEETSCENT,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:VOLTTACKLE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Height => 7,
		:Weight => 210,
		:dexentry => "It uses psychokinesis to control electricity. It hops aboard its own tail, using psychic power to lift the tail and move about while riding it.",
	},

	:OnCreation => {},
},

:SANDSHREW => {
	"Normal Form" => {
		:name => "Sandshrew",
		:dexnum => 27,
		:Type1 => :GROUND,
		:BaseStats => [50, 75, 85, 20, 30, 40],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SANDVEIL, :SANDRUSH],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CHIPAWAY,:COUNTER,:CRUSHCLAW,:ENDURE,:FLAIL,:HONECLAWS,:METALCLAW,:MUDSHOT,:NIGHTSLASH,:RAPIDSPIN,:ROCKCLIMB,:ROTOTILLER,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:DEFENSECURL],
			[3,:SANDATTACK],
			[5,:POISONSTING],
			[7,:ROLLOUT],
			[9,:RAPIDSPIN],
			[11,:FURYCUTTER],
			[14,:MAGNITUDE],
			[17,:SWIFT],
			[20,:FURYSWIPES],
			[23,:SANDTOMB],
			[26,:SLASH],
			[30,:DIG],
			[34,:GYROBALL],
			[38,:SWORDSDANCE],
			[42,:SANDSTORM],
			[46,:EARTHQUAKE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AMNESIA,:BIDE,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:COVET,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:FISSURE,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GYROBALL,:HEADBUTT,:HONECLAWS,:IRONTAIL,:KNOCKOFF,:LEECHLIFE,:MIMIC,:MUDSHOT,:MUDSLAP,:POISONJAB,:RAGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SKULLBASH,:STEALTHROCK,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERFANG,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THROATCHOP,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 120,
		:WildItemUncommon => :GRIPCLAW,
		:kind => "Mouse",
		:dexentry => "When it curls up in a ball, it can make any attack bounce off harmlessly. Its hide has turned tough and solid as a result of living in the desert.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SANDSLASH,:Level,22]
		]
	},

	"Alolan Form" => {
		:Type1 => :ICE,
		:Type2 => :STEEL,
		:BaseStats => [50, 75, 90, 10, 35, 40],
		:Abilities => [:SNOWCLOAK, :SLUSHRUSH],
		:EggMoves => [:AMNESIA,:CHIPAWAY,:COUNTER,:CRUSHCLAW,:CURSE,:ENDURE,:FLAIL,:HONECLAWS,:ICICLECRASH,:ICICLESPEAR,:METALCLAW,:NIGHTSLASH,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:DEFENSECURL],
			[3,:BIDE],
			[5,:POWDERSNOW],
			[7,:ICEBALL],
			[9,:RAPIDSPIN],
			[11,:FURYCUTTER],
			[14,:METALCLAW],
			[17,:SWIFT],
			[20,:FURYSWIPES],
			[23,:IRONDEFENSE],
			[26,:SLASH],
			[30,:IRONHEAD],
			[34,:GYROBALL],
			[38,:SWORDSDANCE],
			[42,:HAIL],
			[46,:BLIZZARD],
		],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:AQUATAIL,:AURORAVEIL,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:COVET,:DEFENSECURL,:DIG,:EARTHQUAKE,:FLING,:FOCUSPUNCH,:FROSTBREATH,:FURYCUTTER,:GYROBALL,:HAIL,:HEADBUTT,:HONECLAWS,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LEECHLIFE,:POISONJAB,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWCLAW,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:SUNNYDAY,:SUPERFANG,:SWIFT,:SWORDSDANCE,:THIEF,:THROATCHOP,:TRIPLEAXEL,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Height => 6,
		:Weight => 400,
		:WildItemUncommon => :PECHABERRY,
		:dexentry => "It lives on snowy mountains. Its steel shell is very hard—so much so, it can't roll its body up into a ball.",
		:evolutions => [
			[:SANDSLASH,:Item,:ICESTONE]
		]
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Sandshrew.include?($game_map.map_id) ? 1 : 0
 },
},

:SANDSLASH => {
	"Normal Form" => {
		:name => "Sandslash",
		:dexnum => 28,
		:Type1 => :GROUND,
		:BaseStats => [75, 100, 110, 45, 55, 65],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SANDVEIL, :SANDRUSH],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SANDSHREW,
			:form => 0
		},
		:Moveset => [
			[0,:CRUSHCLAW],
			[1,:SCRATCH],
			[1,:DEFENSECURL],
			[1,:SANDATTACK],
			[1,:POISONSTING],
			[3,:SANDATTACK],
			[5,:POISONSTING],
			[7,:ROLLOUT],
			[9,:RAPIDSPIN],
			[11,:FURYCUTTER],
			[14,:MAGNITUDE],
			[17,:SWIFT],
			[20,:FURYSWIPES],
			[24,:SANDTOMB],
			[28,:SLASH],
			[33,:DIG],
			[38,:GYROBALL],
			[43,:SWORDSDANCE],
			[48,:SANDSTORM],
			[53,:EARTHQUAKE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AMNESIA,:BIDE,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:COVET,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRILLRUN,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:FISSURE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LEECHLIFE,:MIMIC,:MUDSHOT,:MUDSLAP,:PINMISSILE,:POISONJAB,:RAGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SKULLBASH,:SPIKES,:STEALTHROCK,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERFANG,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THROATCHOP,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 295,
		:WildItemUncommon => :GRIPCLAW,
		:kind => "Mouse",
		:dexentry => "It curls up in a ball to protect itself from enemy attacks. It also curls up to prevent heatstroke during the daytime when temperatures rise sharply.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type1 => :ICE,
		:Type2 => :STEEL,
		:BaseStats => [75, 100, 120, 25, 65, 65],
		:Abilities => [:SNOWCLOAK, :SLUSHRUSH],
		:preevo => {
			:species => :SANDSHREW,
			:form => 1
		},
		:Moveset => [
			[0,:ICICLESPEAR],
			[1,:METALBURST],
			[1,:ICICLECRASH],
			[1,:SLASH],
			[1,:DEFENSECURL],
			[1,:ICEBALL],
			[1,:METALCLAW],
		],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AMNESIA,:AQUATAIL,:AURORAVEIL,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:COVET,:DEFENSECURL,:DIG,:DRILLRUN,:EARTHQUAKE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FROSTBREATH,:FURYCUTTER,:GIGAIMPACT,:GYROBALL,:HAIL,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LEECHLIFE,:PINMISSILE,:POISONJAB,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWCLAW,:SPIKES,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:SUNNYDAY,:SUPERFANG,:SWIFT,:SWORDSDANCE,:THIEF,:THROATCHOP,:TRIPLEAXEL,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Height => 12,
		:Weight => 550,
		:WildItemUncommon => :PECHABERRY,
		:dexentry => "This Pokémon's steel spikes are sheathed in ice. Stabs from these spikes cause deep wounds and severe frostbite as well.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Sandshrew.include?($game_map.map_id) ? 1 : 0
 },
},

:NIDORANfE => {
	"Normal Form" => {
		:name => "Nidoran",
		:dexnum => 29,
		:Type1 => :POISON,
		:BaseStats => [55, 47, 52, 40, 40, 41],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 55,
		:CatchRate => 235,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BEATUP,:CHARM,:CHIPAWAY,:COUNTER,:DISABLE,:ENDURE,:FOCUSENERGY,:IRONTAIL,:POISONTAIL,:PURSUIT,:SKULLBASH,:SUPERSONIC,:TAKEDOWN,:VENOMDRENCH,],
		:Moveset => [
			[1,:GROWL],
			[1,:SCRATCH],
			[7,:TAILWHIP],
			[9,:DOUBLEKICK],
			[13,:POISONSTING],
			[19,:FURYSWIPES],
			[21,:BITE],
			[25,:HELPINGHAND],
			[31,:TOXICSPIKES],
			[33,:FLATTER],
			[37,:CRUNCH],
			[43,:CAPTIVATE],
			[45,:POISONFANG]],
		:compatiblemoves => [:AERIALACE,:BEATUP,:BIDE,:BLIZZARD,:BODYSLAM,:CHARM,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:ECHOEDVOICE,:FOCUSENERGY,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:ICEBEAM,:IRONTAIL,:MIMIC,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:ROCKSMASH,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 4,
		:Weight => 70,
		:kind => "Poison Pin",
		:dexentry => "Its highly toxic barbs are thought to have developed as protection for this small-bodied Pokémon. When enraged, it releases a horrible toxin from its horn.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NIDORINA,:Level,16]
		]
	},

	:OnCreation => {},
},

:NIDORINA => {
	"Normal Form" => {
		:name => "Nidorina",
		:dexnum => 30,
		:Type1 => :POISON,
		:BaseStats => [70, 62, 67, 55, 55, 56],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 128,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NIDORANfE,
			:form => 0
		},
		:Moveset => [
			[1,:GROWL],
			[1,:SCRATCH],
			[7,:TAILWHIP],
			[9,:DOUBLEKICK],
			[13,:POISONSTING],
			[20,:FURYSWIPES],
			[23,:BITE],
			[28,:HELPINGHAND],
			[35,:TOXICSPIKES],
			[38,:FLATTER],
			[43,:CRUNCH],
			[50,:CAPTIVATE],
			[58,:POISONFANG]],
		:compatiblemoves => [:AERIALACE,:BEATUP,:BIDE,:BLIZZARD,:BODYSLAM,:BUBBLEBEAM,:CHARM,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:ECHOEDVOICE,:FOCUSENERGY,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HORNDRILL,:ICEBEAM,:IRONTAIL,:MIMIC,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:ROCKSMASH,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:WATERGUN,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 8,
		:Weight => 200,
		:kind => "Poison Pin",
		:dexentry => "When it is with its friends or family, its barbs are tucked away to prevent injury. It appears to become nervous if separated from the others.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NIDOQUEEN,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:NIDOQUEEN => {
	"Normal Form" => {
		:name => "Nidoqueen",
		:dexnum => 31,
		:Type1 => :POISON,
		:Type2 => :GROUND,
		:BaseStats => [90, 92, 87, 75, 85, 76],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 223,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NIDORINA,
			:form => 0
		},
		:Moveset => [
			[1,:SUPERPOWER],
			[1,:SCRATCH],
			[1,:TAILWHIP],
			[1,:DOUBLEKICK],
			[1,:POISONSTING],
			[23,:CHIPAWAY],
			[35,:BODYSLAM],
			[43,:EARTHPOWER],
			[58,:SUPERPOWER]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:AVALANCHE,:BEATUP,:BIDE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:CHARM,:COUNTER,:CRUNCH,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HEX,:HIGHHORSEPOWER,:HONECLAWS,:HORNDRILL,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:OUTRAGE,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:QUASH,:RAGE,:RAINDANCE,:REFLECT,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:SURF,:TAKEDOWN,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 13,
		:Weight => 600,
		:kind => "Drill",
		:dexentry => "It is adept at sending foes flying with harsh tackles using its tough, scaly body. This Pokémon is at its strongest when it is defending its young.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:NIDORANmA => {
	"Normal Form" => {
		:name => "Nidoran",
		:dexnum => 32,
		:Type1 => :POISON,
		:BaseStats => [46, 57, 40, 40, 40, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemZero,
		:BaseEXP => 55,
		:CatchRate => 235,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:BEATUP,:CHIPAWAY,:CONFUSION,:COUNTER,:DISABLE,:ENDURE,:HEADSMASH,:IRONTAIL,:POISONTAIL,:SUCKERPUNCH,:SUPERSONIC,:TAKEDOWN,:VENOMDRENCH,],
		:Moveset => [
			[1,:LEER],
			[1,:PECK],
			[7,:FOCUSENERGY],
			[9,:DOUBLEKICK],
			[13,:POISONSTING],
			[19,:FURYATTACK],
			[21,:HORNATTACK],
			[25,:HELPINGHAND],
			[31,:TOXICSPIKES],
			[33,:FLATTER],
			[37,:POISONJAB],
			[43,:CAPTIVATE],
			[45,:HORNDRILL]],
		:compatiblemoves => [:AMNESIA,:BEATUP,:BIDE,:BLIZZARD,:BODYSLAM,:COUNTER,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRILLRUN,:EARTHPOWER,:ECHOEDVOICE,:FOCUSENERGY,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HORNDRILL,:ICEBEAM,:IRONTAIL,:MIMIC,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:ROCKSMASH,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SMARTSTRIKE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 5,
		:Weight => 90,
		:kind => "Poison Pin",
		:dexentry => "The male Nidoran has developed muscles that freely move its ears in any direction. Even the slightest sound does not escape this Pokémon's notice.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NIDORINO,:Level,16]
		]
	},

	:OnCreation => {},
},

:NIDORINO => {
	"Normal Form" => {
		:name => "Nidorino",
		:dexnum => 33,
		:Type1 => :POISON,
		:BaseStats => [61, 72, 57, 55, 55, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :HUSTLE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemZero,
		:BaseEXP => 128,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NIDORANmA,
			:form => 0
		},
		:Moveset => [
			[1,:LEER],
			[1,:PECK],
			[7,:FOCUSENERGY],
			[9,:DOUBLEKICK],
			[13,:POISONSTING],
			[20,:FURYATTACK],
			[23,:HORNATTACK],
			[28,:HELPINGHAND],
			[35,:TOXICSPIKES],
			[38,:FLATTER],
			[43,:POISONJAB],
			[50,:CAPTIVATE],
			[58,:HORNDRILL]],
		:compatiblemoves => [:AMNESIA,:BEATUP,:BIDE,:BLIZZARD,:BODYSLAM,:BUBBLEBEAM,:COUNTER,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRILLRUN,:EARTHPOWER,:ECHOEDVOICE,:FOCUSENERGY,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HORNDRILL,:ICEBEAM,:IRONTAIL,:MIMIC,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:ROCKSMASH,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SMARTSTRIKE,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:WATERGUN,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 9,
		:Weight => 195,
		:kind => "Poison Pin",
		:dexentry => "Its horn is harder than a diamond. If it senses a hostile presence, all the barbs on its back bristle up at once, and it challenges the foe with all its might.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NIDOKING,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:NIDOKING => {
	"Normal Form" => {
		:name => "Nidoking",
		:dexnum => 34,
		:Type1 => :POISON,
		:Type2 => :GROUND,
		:BaseStats => [81, 102, 77, 85, 75, 85],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :RIVALRY],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemZero,
		:BaseEXP => 223,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NIDORINO,
			:form => 0
		},
		:Moveset => [
			[1,:MEGAHORN],
			[1,:PECK],
			[1,:FOCUSENERGY],
			[1,:DOUBLEKICK],
			[1,:POISONSTING],
			[23,:CHIPAWAY],
			[35,:THRASH],
			[43,:EARTHPOWER],
			[58,:MEGAHORN]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:AVALANCHE,:BEATUP,:BIDE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:CUT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HEX,:HIGHHORSEPOWER,:HONECLAWS,:HORNDRILL,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:MEGAHORN,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:OUTRAGE,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:QUASH,:RAGE,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:SMARTSTRIKE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:SURF,:TAKEDOWN,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 14,
		:Weight => 620,
		:kind => "Drill",
		:dexentry => "A Nidoking's thick tail packs enormously destructive power capable of toppling a metal transmission tower. Once it goes on a rampage, there is no stopping it.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CLEFAIRY => {
	"Normal Form" => {
		:name => "Clefairy",
		:dexnum => 35,
		:Type1 => :FAIRY,
		:BaseStats => [70, 45, 48, 60, 65, 35],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:CUTECHARM, :MAGICGUARD],
		:HiddenAbilities => :FRIENDGUARD,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 113,
		:CatchRate => 150,
		:Happiness => 140,
		:EggSteps => 2805,
		:preevo => {
			:species => :CLEFFA,
			:form => 0
		},
		:Moveset => [
			[1,:SPOTLIGHT],
			[1,:DISARMINGVOICE],
			[1,:POUND],
			[1,:GROWL],
			[1,:ENCORE],
			[7,:SING],
			[10,:DOUBLESLAP],
			[13,:DEFENSECURL],
			[16,:FOLLOWME],
			[19,:BESTOW],
			[22,:WAKEUPSLAP],
			[25,:MINIMIZE],
			[28,:STOREDPOWER],
			[31,:METRONOME],
			[34,:COSMICPOWER],
			[37,:LUCKYCHANT],
			[40,:BODYSLAM],
			[43,:MOONLIGHT],
			[46,:MOONBLAST],
			[49,:GRAVITY],
			[50,:METEORMASH],
			[55,:HEALINGWISH],
			[58,:AFTERYOU]],
		:compatiblemoves => [:AFTERYOU,:ALLYSWITCH,:AMNESIA,:BABYDOLLEYES,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BUBBLEBEAM,:CALMMIND,:CHARGEBEAM,:CHARM,:COSMICPOWER,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DUALWINGBEAT,:DYNAMICPUNCH,:ECHOEDVOICE,:ENCORE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSPUNCH,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:METRONOME,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDSLAP,:MYSTICALFIRE,:NIGHTMARE,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKSMASH,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SNATCH,:SOFTBOILED,:SOLARBEAM,:STEALTHROCK,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:TRICK,:UPROAR,:WATERGUN,:WATERPULSE,:WONDERROOM,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Mountain",
		:EggGroups => [:Fairy],
		:Height => 6,
		:Weight => 75,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Fairy",
		:dexentry => "On every night of a full moon, they come out to play. When dawn arrives, the tired Clefairy go to sleep nestled up against each other in deep and quiet mountains.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CLEFABLE,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:CLEFABLE => {
	"Normal Form" => {
		:name => "Clefable",
		:dexnum => 36,
		:Type1 => :FAIRY,
		:BaseStats => [95, 70, 73, 95, 90, 60],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:CUTECHARM, :MAGICGUARD],
		:HiddenAbilities => :UNAWARE,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 213,
		:CatchRate => 25,
		:Happiness => 140,
		:EggSteps => 2805,
		:preevo => {
			:species => :CLEFAIRY,
			:form => 0
		},
		:Moveset => [
			[1,:SPOTLIGHT],
			[1,:DISARMINGVOICE],
			[1,:SING],
			[1,:DOUBLESLAP],
			[1,:MINIMIZE],
			[1,:METRONOME]],
		:compatiblemoves => [:AFTERYOU,:ALLYSWITCH,:AMNESIA,:BABYDOLLEYES,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BUBBLEBEAM,:CALMMIND,:CHARGEBEAM,:CHARM,:COSMICPOWER,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DUALWINGBEAT,:DYNAMICPUNCH,:ECHOEDVOICE,:ENCORE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:METRONOME,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDSLAP,:MYSTICALFIRE,:NIGHTMARE,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKSMASH,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SNATCH,:SOFTBOILED,:SOLARBEAM,:STEALTHROCK,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:TRICK,:UPROAR,:WATERGUN,:WATERPULSE,:WONDERROOM,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Mountain",
		:EggGroups => [:Fairy],
		:Height => 13,
		:Weight => 400,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Fairy",
		:dexentry => "A Clefable uses its wings to skip lightly as if it were flying. Its bouncy step lets it even walk on water. On quiet, moonlit nights, it strolls on lakes.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:VULPIX => {
	"Normal Form" => {
		:name => "Vulpix",
		:dexnum => 37,
		:Type1 => :FIRE,
		:BaseStats => [38, 41, 40, 50, 65, 65],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:FLASHFIRE, :DROUGHT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 60,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CAPTIVATE,:DISABLE,:EXTRASENSORY,:FEINTATTACK,:FLAIL,:FLAREBLITZ,:HEATWAVE,:HEX,:HOWL,:HYPNOSIS,:POWERSWAP,:SECRETPOWER,:SPITE,:TAILSLAP,],
		:Moveset => [
			[1,:EMBER],
			[4,:TAILWHIP],
			[7,:ROAR],
			[9,:BABYDOLLEYES],
			[10,:QUICKATTACK],
			[12,:CONFUSERAY],
			[15,:FIRESPIN],
			[18,:PAYBACK],
			[20,:WILLOWISP],
			[23,:FEINTATTACK],
			[26,:HEX],
			[28,:FLAMEBURST],
			[31,:EXTRASENSORY],
			[34,:SAFEGUARD],
			[36,:FLAMETHROWER],
			[39,:IMPRISON],
			[42,:FIREBLAST],
			[44,:GRUDGE],
			[47,:CAPTIVATE],
			[50,:INFERNO]],
		:compatiblemoves => [:AGILITY,:BABYDOLLEYES,:BIDE,:BODYSLAM,:BURNINGJEALOUSY,:CELEBRATE,:CHARM,:COVET,:CURSE,:DARKPULSE,:DIG,:DOUBLEEDGE,:ENCORE,:ENERGYBALL,:FEINTATTACK,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FOULPLAY,:HEADBUTT,:HEATWAVE,:HEX,:HYPNOSIS,:IMPRISON,:INCINERATE,:IRONTAIL,:MIMIC,:MYSTICALFIRE,:NASTYPLOT,:OMINOUSWIND,:OVERHEAT,:PAINSPLIT,:PAYBACK,:POWERSWAP,:PSYCHUP,:RAGE,:REFLECT,:ROAR,:ROLEPLAY,:SAFEGUARD,:SKULLBASH,:SPITE,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAKEDOWN,:WEATHERBALL,:WILLOWISP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWHOLD,:SHADOWWAVE,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 99,
		:WildItemUncommon => :CHARCOAL,
		:kind => "Fox",
		:dexentry => "At the time of its birth, Vulpix has one white tail. It separates into six if this Pokémon receives plenty of love. The six tails become magnificently curled.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NINETALES,:Item,:FIRESTONE]
		]
	},

	"Alolan Form" => {
		:Type1 => :ICE,
		:Abilities => [:SNOWCLOAK, :SNOWWARNING],
		:EggMoves => [:AGILITY,:CHARM,:DISABLE,:ENCORE,:EXTRASENSORY,:FLAIL,:FREEZEDRY,:HOWL,:HYPNOSIS,:MOONBLAST,:POWERSWAP,:SPITE,:SECRETPOWER,:TAILSLAP,],
		:Moveset => [
			[1,:POWDERSNOW],
			[4,:TAILWHIP],
			[7,:ROAR],
			[9,:BABYDOLLEYES],
			[10,:ICESHARD],
			[12,:CONFUSERAY],
			[15,:ICYWIND],
			[18,:PAYBACK],
			[20,:MIST],
			[23,:FEINTATTACK],
			[26,:HEX],
			[28,:AURORABEAM],
			[31,:EXTRASENSORY],
			[34,:SAFEGUARD],
			[36,:ICEBEAM],
			[39,:IMPRISON],
			[42,:BLIZZARD],
			[44,:GRUDGE],
			[47,:CAPTIVATE],
			[50,:SHEERCOLD],
		],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:AURORAVEIL,:BABYDOLLEYES,:BLIZZARD,:BODYSLAM,:CHARM,:COVET,:DARKPULSE,:DAZZLINGGLEAM,:DIG,:DRAININGKISS,:ENCORE,:ENERGYBALL,:FEINTATTACK,:FOULPLAY,:FROSTBREATH,:HAIL,:HEADBUTT,:HEALBELL,:HEX,:HYPNOSIS,:ICEBEAM,:ICEFANG,:ICYWIND,:IMPRISON,:IRONTAIL,:NASTYPLOT,:PAINSPLIT,:PAYBACK,:POWERSWAP,:PSYCHUP,:RAINDANCE,:REFLECT,:ROAR,:ROLEPLAY,:SAFEGUARD,:SPITE,:SWIFT,:TAILSLAP,:WEATHERBALL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:WildItemUncommon => :SNOWBALL,
		:dexentry => "In hot weather, this Pokémon makes ice shards with its six tails and sprays them around to cool itself off.",
		:evolutions => [
			[:NINETALES,:Item,:ICESTONE]
		]
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Vulpix.include?($game_map.map_id) ? 1 : 0
 },
},

:NINETALES => {
	"Normal Form" => {
		:name => "Ninetales",
		:dexnum => 38,
		:Type1 => :FIRE,
		:BaseStats => [73, 76, 75, 81, 100, 100],
		:EVs => [0, 0, 0, 0, 1, 1],
		:Abilities => [:FLASHFIRE, :DROUGHT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 177,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :VULPIX,
			:form => 0
		},
		:Moveset => [
			[1,:IMPRISON],
			[1,:NASTYPLOT],
			[1,:FLAMETHROWER],
			[1,:QUICKATTACK],
			[1,:CONFUSERAY],
			[1,:SAFEGUARD]],
		:compatiblemoves => [:AGILITY,:BABYDOLLEYES,:BIDE,:BODYSLAM,:BURNINGJEALOUSY,:CALMMIND,:CELEBRATE,:CHARM,:COVET,:CURSE,:DARKPULSE,:DIG,:DOUBLEEDGE,:DREAMEATER,:ENCORE,:ENERGYBALL,:FAKETEARS,:FEINTATTACK,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FOULPLAY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HEX,:HYPERBEAM,:HYPNOSIS,:IMPRISON,:INCINERATE,:IRONTAIL,:LASERFOCUS,:MIMIC,:MYSTICALFIRE,:NASTYPLOT,:OMINOUSWIND,:OVERHEAT,:PAINSPLIT,:PAYBACK,:POWERSWAP,:PSYCHUP,:PSYSHOCK,:RAGE,:REFLECT,:ROAR,:ROLEPLAY,:SAFEGUARD,:SCORCHINGSANDS,:SHADOWBALL,:SKULLBASH,:SOLARBEAM,:SPITE,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAKEDOWN,:WEATHERBALL,:WILLOWISP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 199,
		:WildItemUncommon => :CHARCOAL,
		:kind => "Fox",
		:dexentry => "It has long been said that each of the nine tails embody an enchanted power. A long-lived Ninetales will have fur that shines like gold.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type1 => :ICE,
		:Type2 => :FAIRY,
		:BaseStats => [73, 67, 75, 81, 100, 109],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SNOWCLOAK, :SNOWWARNING],
		:preevo => {
			:species => :VULPIX,
			:form => 1
		},
		:Moveset => [
			[0,:DAZZLINGGLEAM],
			[1,:IMPRISON],
			[1,:NASTYPLOT],
			[1,:ICEBEAM],
			[1,:ICESHARD],
			[1,:CONFUSERAY],
			[1,:SAFEGUARD],
		],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:AURORAVEIL,:AVALANCHE,:BABYDOLLEYES,:BLIZZARD,:BODYSLAM,:CALMMIND,:CHARM,:COVET,:DARKPULSE,:DAZZLINGGLEAM,:DIG,:DRAININGKISS,:DREAMEATER,:ENCORE,:ENERGYBALL,:FAKETEARS,:FEINTATTACK,:FOULPLAY,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HEX,:HYPERBEAM,:HYPNOSIS,:ICEBEAM,:ICEFANG,:ICYWIND,:IMPRISON,:IRONTAIL,:LASERFOCUS,:MISTYTERRAIN,:NASTYPLOT,:PAINSPLIT,:PAYBACK,:POWERSWAP,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROAR,:ROLEPLAY,:SAFEGUARD,:SOLARBEAM,:SPITE,:STOREDPOWER,:SWIFT,:TAILSLAP,:TRIPLEAXEL,:WEATHERBALL,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:WildItemUncommon => :SNOWBALL,
		:dexentry => "Possessing a calm demeanor, this Pokémon was revered as a deity incarnate before it was identified as a regional variant of Ninetales.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Vulpix.include?($game_map.map_id) ? 1 : 0
 },
},

:JIGGLYPUFF => {
	"Normal Form" => {
		:name => "Jigglypuff",
		:dexnum => 39,
		:Type1 => :NORMAL,
		:Type2 => :FAIRY,
		:BaseStats => [115, 45, 20, 45, 25, 20],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:CUTECHARM, :COMPETITIVE],
		:HiddenAbilities => :FRIENDGUARD,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 95,
		:CatchRate => 170,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :IGGLYBUFF,
			:form => 0
		},
		:Moveset => [
			[1,:SING],
			[3,:DEFENSECURL],
			[5,:POUND],
			[9,:PLAYNICE],
			[11,:DISARMINGVOICE],
			[14,:DISABLE],
			[17,:DOUBLESLAP],
			[20,:ROLLOUT],
			[22,:ROUND],
			[25,:STOCKPILE],
			[25,:SWALLOW],
			[25,:SPITUP],
			[27,:WAKEUPSLAP],
			[30,:REST],
			[32,:BODYSLAM],
			[35,:GYROBALL],
			[38,:MIMIC],
			[41,:HYPERVOICE],
			[45,:DOUBLEEDGE]],
		:compatiblemoves => [:ALLYSWITCH,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BUBBLEBEAM,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ECHOEDVOICE,:ENDEAVOR,:FAKETEARS,:FEINTATTACK,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSPUNCH,:GRASSKNOT,:GRAVITY,:GYROBALL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:KNOCKOFF,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SNATCH,:SOLARBEAM,:STEALTHROCK,:STEELROLLER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:UPROAR,:WATERGUN,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy],
		:Height => 5,
		:Weight => 55,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Balloon",
		:dexentry => "Nothing can avoid falling asleep hearing a Jigglypuff's song. The sound waves of its singing voice match the brain waves of someone in a deep sleep.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WIGGLYTUFF,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:WIGGLYTUFF => {
	"Normal Form" => {
		:name => "Wigglytuff",
		:dexnum => 40,
		:Type1 => :NORMAL,
		:Type2 => :FAIRY,
		:BaseStats => [140, 70, 45, 85, 50, 45],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:CUTECHARM, :COMPETITIVE],
		:HiddenAbilities => :FRISK,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 191,
		:CatchRate => 50,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :JIGGLYPUFF,
			:form => 0
		},
		:Moveset => [
			[1,:DOUBLEEDGE],
			[1,:SING],
			[1,:DISABLE],
			[1,:DEFENSECURL],
			[1,:DOUBLESLAP],
			[1,:PLAYROUGH]],
		:compatiblemoves => [:ALLYSWITCH,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BUBBLEBEAM,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ECHOEDVOICE,:ENDEAVOR,:EXPANDINGFORCE,:FAKETEARS,:FEINTATTACK,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GYROBALL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SNATCH,:SOLARBEAM,:STEALTHROCK,:STEELROLLER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:UPROAR,:WATERGUN,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy],
		:Height => 10,
		:Weight => 120,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Balloon",
		:dexentry => "Its fur is the ultimate in luxuriousness. Sleeping alongside a Wigglytuff is simply divine. Its body expands seemingly without end when it inhales.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ZUBAT => {
	"Normal Form" => {
		:name => "Zubat",
		:dexnum => 41,
		:Type1 => :POISON,
		:Type2 => :FLYING,
		:BaseStats => [40, 45, 35, 30, 40, 55],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:INNERFOCUS, :INFILTRATOR],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 49,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BRAVEBIRD,:CURSE,:DEFOG,:FEINTATTACK,:GIGADRAIN,:GUST,:HYPNOSIS,:NASTYPLOT,:PURSUIT,:QUICKATTACK,:STEELWING,:VENOMDRENCH,:WHIRLWIND,:ZENHEADBUTT,],
		:Moveset => [
			[1,:ABSORB],
			[5,:SUPERSONIC],
			[7,:ASTONISH],
			[11,:BITE],
			[13,:WINGATTACK],
			[17,:CONFUSERAY],
			[19,:AIRCUTTER],
			[23,:SWIFT],
			[25,:POISONFANG],
			[29,:MEANLOOK],
			[31,:LEECHLIFE],
			[35,:HAZE],
			[37,:VENOSHOCK],
			[41,:AIRSLASH],
			[43,:QUICKGUARD]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BIDE,:BRAVEBIRD,:CROSSPOISON,:CRUNCH,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FEINTATTACK,:FLY,:GIGADRAIN,:HEADBUTT,:HEATWAVE,:HYPNOSIS,:LEECHLIFE,:MEGADRAIN,:MIMIC,:NASTYPLOT,:OMINOUSWIND,:PAYBACK,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:ROOST,:SHADOWBALL,:SLUDGEBOMB,:SNATCH,:STEELWING,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAILWIND,:TAKEDOWN,:TAUNT,:THIEF,:TORMENT,:TWISTER,:UPROAR,:UTURN,:VENOMDRENCH,:VENOSHOCK,:WHIRLWIND,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Flying],
		:Height => 8,
		:Weight => 75,
		:kind => "Bat",
		:dexentry => "While living in pitch-black caverns, their eyes gradually grew shut and deprived them of vision. They use ultrasonic waves to detect obstacles.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 13,
		:evolutions => [
			[:GOLBAT,:Level,22]
		]
	},

	:OnCreation => {},
},

:GOLBAT => {
	"Normal Form" => {
		:name => "Golbat",
		:dexnum => 42,
		:Type1 => :POISON,
		:Type2 => :FLYING,
		:BaseStats => [75, 80, 70, 65, 75, 90],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:INNERFOCUS, :INFILTRATOR],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :ZUBAT,
			:form => 0
		},
		:Moveset => [
			[1,:SCREECH],
			[1,:ABSORB],
			[1,:SUPERSONIC],
			[1,:ASTONISH],
			[1,:BITE],
			[5,:SUPERSONIC],
			[7,:ASTONISH],
			[11,:BITE],
			[13,:WINGATTACK],
			[17,:CONFUSERAY],
			[19,:AIRCUTTER],
			[24,:SWIFT],
			[27,:POISONFANG],
			[32,:MEANLOOK],
			[35,:LEECHLIFE],
			[40,:HAZE],
			[43,:VENOSHOCK],
			[48,:AIRSLASH],
			[51,:QUICKGUARD]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BIDE,:BRAVEBIRD,:CROSSPOISON,:CRUNCH,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FEINTATTACK,:FLY,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HEADBUTT,:HEATWAVE,:HYPERBEAM,:HYPNOSIS,:LEECHLIFE,:MEGADRAIN,:MIMIC,:NASTYPLOT,:OMINOUSWIND,:PAYBACK,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:ROOST,:SCREECH,:SHADOWBALL,:SLUDGEBOMB,:SNATCH,:STEELWING,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAILWIND,:TAKEDOWN,:TAUNT,:THIEF,:TORMENT,:TWISTER,:UPROAR,:UTURN,:VENOMDRENCH,:VENOSHOCK,:WHIRLWIND,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Flying],
		:Height => 16,
		:Weight => 550,
		:kind => "Bat",
		:dexentry => "Its fangs puncture even thick hide. It loves to feast on the blood of people and Pokémon. It flits about in darkness and strikes from behind.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 12,
		:evolutions => [
			[:CROBAT,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:ODDISH => {
	"Normal Form" => {
		:name => "Oddish",
		:dexnum => 43,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [45, 50, 55, 75, 65, 30],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:CHLOROPHYLL, :RUNAWAY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 64,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AFTERYOU,:CHARM,:FLAIL,:INGRAIN,:NATUREPOWER,:RAZORLEAF,:SECRETPOWER,:STRENGTHSAP,:SYNTHESIS,:TEETERDANCE,:TICKLE,],
		:Moveset => [
			[1,:ABSORB],
			[1,:GROWTH],
			[5,:SWEETSCENT],
			[9,:ACID],
			[13,:POISONPOWDER],
			[14,:STUNSPORE],
			[15,:SLEEPPOWDER],
			[19,:MEGADRAIN],
			[23,:LUCKYCHANT],
			[27,:MOONLIGHT],
			[31,:GIGADRAIN],
			[35,:TOXIC],
			[39,:NATURALGIFT],
			[43,:MOONBLAST],
			[47,:GRASSYTERRAIN],
			[51,:PETALDANCE]],
		:compatiblemoves => [:AFTERYOU,:BIDE,:BULLETSEED,:CHARM,:CURSE,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:INFESTATION,:MEGADRAIN,:MIMIC,:NATUREPOWER,:RAGE,:REFLECT,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 5,
		:Weight => 54,
		:WildItemUncommon => :ABSORBBULB,
		:kind => "Weed",
		:dexentry => "This Pokémon grows by absorbing moonlight. During the daytime, it buries itself, leaving only its leaves exposed to avoid detection by its enemies.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GLOOM,:Level,21]
		]
	},

	:OnCreation => {},
},

:GLOOM => {
	"Normal Form" => {
		:name => "Gloom",
		:dexnum => 44,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [60, 65, 70, 85, 75, 40],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:CHLOROPHYLL, :STENCH],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 138,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :ODDISH,
			:form => 0
		},
		:Moveset => [
			[1,:ABSORB],
			[1,:GROWTH],
			[1,:SWEETSCENT],
			[1,:ACID],
			[5,:SWEETSCENT],
			[9,:ACID],
			[13,:POISONPOWDER],
			[14,:STUNSPORE],
			[15,:SLEEPPOWDER],
			[19,:MEGADRAIN],
			[24,:LUCKYCHANT],
			[29,:MOONLIGHT],
			[34,:GIGADRAIN],
			[39,:TOXIC],
			[44,:NATURALGIFT],
			[49,:PETALBLIZZARD],
			[54,:GRASSYTERRAIN],
			[59,:PETALDANCE]],
		:compatiblemoves => [:AFTERYOU,:BIDE,:BULLETSEED,:CHARM,:CURSE,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:ENERGYBALL,:FLASH,:FLING,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:INFESTATION,:MEGADRAIN,:MIMIC,:NATUREPOWER,:RAGE,:REFLECT,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 8,
		:Weight => 86,
		:WildItemUncommon => :ABSORBBULB,
		:kind => "Weed",
		:dexentry => "A horribly noxious honey drools from its mouth. One whiff of the honey can result in memory loss. Some fans are said to enjoy this overwhelming stink, however.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VILEPLUME,:Item,:LEAFSTONE],
			[:BELLOSSOM,:Item,:SUNSTONE]
		]
	},

	:OnCreation => {},
},

:VILEPLUME => {
	"Normal Form" => {
		:name => "Vileplume",
		:dexnum => 45,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [75, 80, 85, 110, 90, 50],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:CHLOROPHYLL, :EFFECTSPORE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 216,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GLOOM,
			:form => 0
		},
		:Moveset => [
			[1,:MEGADRAIN],
			[1,:AROMATHERAPY],
			[1,:STUNSPORE],
			[1,:POISONPOWDER],
			[49,:PETALBLIZZARD],
			[59,:PETALDANCE],
			[69,:SOLARBEAM]],
		:compatiblemoves => [:AFTERYOU,:BIDE,:BODYSLAM,:BULLETSEED,:CHARM,:CORROSIVEGAS,:CURSE,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:ENERGYBALL,:FLASH,:FLING,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:INFESTATION,:MEGADRAIN,:MIMIC,:NATUREPOWER,:POLLENPUFF,:RAGE,:REFLECT,:SAFEGUARD,:SEEDBOMB,:SLUDGEBOMB,:SLUDGEWAVE,:SOLARBEAM,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 12,
		:Weight => 186,
		:WildItemUncommon => :ABSORBBULB,
		:kind => "Flower",
		:dexentry => "In seasons when it produces more pollen, the air around a Vileplume turns yellow with the powder as it walks. The pollen is highly toxic and causes paralysis.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PARAS => {
	"Normal Form" => {
		:name => "Paras",
		:dexnum => 46,
		:Type1 => :BUG,
		:Type2 => :GRASS,
		:BaseStats => [35, 70, 55, 45, 55, 25],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:EFFECTSPORE, :DRYSKIN],
		:HiddenAbilities => :DAMP,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 57,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:BUGBITE,:COUNTER,:CROSSPOISON,:ENDURE,:FELLSTINGER,:FLAIL,:GRASSYTERRAIN,:LEECHSEED,:METALCLAW,:NATURALGIFT,:PSYBEAM,:PURSUIT,:ROTOTILLER,:SCREECH,:SWEETSCENT,:WIDEGUARD,],
		:Moveset => [
			[1,:SCRATCH],
			[6,:STUNSPORE],
			[6,:POISONPOWDER],
			[11,:ABSORB],
			[17,:FURYCUTTER],
			[22,:SPORE],
			[27,:SLASH],
			[33,:GROWTH],
			[38,:GIGADRAIN],
			[43,:AROMATHERAPY],
			[49,:RAGEPOWDER],
			[54,:XSCISSOR]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AGILITY,:BIDE,:BODYSLAM,:BRICKBREAK,:BUGBITE,:BULLETSEED,:COUNTER,:CROSSPOISON,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:ENERGYBALL,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HONECLAWS,:KNOCKOFF,:LEECHLIFE,:LIGHTSCREEN,:MEGADRAIN,:MIMIC,:NATUREPOWER,:RAGE,:ROCKSMASH,:SCREECH,:SEEDBOMB,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:VENOSHOCK,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug, :Grass],
		:Height => 3,
		:Weight => 54,
		:WildItemCommon => :TINYMUSHROOM,
		:WildItemUncommon => :BIGMUSHROOM,
		:kind => "Mushroom",
		:dexentry => "A Paras has parasitic tochukaso mushrooms growing on its back. They grow by drawing nutrients from the host. They are valued as medicine.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 35,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PARASECT,:Level,24]
		]
	},

	:OnCreation => {},
},

:PARASECT => {
	"Normal Form" => {
		:name => "Parasect",
		:dexnum => 47,
		:Type1 => :BUG,
		:Type2 => :GRASS,
		:BaseStats => [60, 95, 80, 60, 80, 30],
		:EVs => [0, 2, 1, 0, 0, 0],
		:Abilities => [:EFFECTSPORE, :DRYSKIN],
		:HiddenAbilities => :DAMP,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PARAS,
			:form => 0
		},
		:Moveset => [
			[1,:CROSSPOISON],
			[1,:SCRATCH],
			[1,:STUNSPORE],
			[1,:POISONPOWDER],
			[1,:ABSORB],
			[6,:STUNSPORE],
			[6,:POISONPOWDER],
			[11,:ABSORB],
			[17,:FURYCUTTER],
			[22,:SPORE],
			[29,:SLASH],
			[37,:GROWTH],
			[44,:GIGADRAIN],
			[51,:AROMATHERAPY],
			[59,:RAGEPOWDER],
			[66,:XSCISSOR]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AGILITY,:BIDE,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BUGBITE,:BUGBUZZ,:BULLETSEED,:COUNTER,:CROSSPOISON,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:ENERGYBALL,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:KNOCKOFF,:LEECHLIFE,:LIGHTSCREEN,:MEGADRAIN,:MIMIC,:NATUREPOWER,:PSYCHOCUT,:RAGE,:REFLECT,:ROCKSMASH,:SCREECH,:SEEDBOMB,:SKITTERSMACK,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:SOLARBLADE,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:THROATCHOP,:VENOSHOCK,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug, :Grass],
		:Height => 10,
		:Weight => 295,
		:WildItemCommon => :TINYMUSHROOM,
		:WildItemUncommon => :BIGMUSHROOM,
		:kind => "Mushroom",
		:dexentry => "Parasect are known to infest the roots of large trees en masse and drain nutrients. When an infested tree dies, they move onto another tree all at once.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:VENONAT => {
	"Normal Form" => {
		:name => "Venonat",
		:dexnum => 48,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [60, 55, 50, 40, 55, 45],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:COMPOUNDEYES, :TINTEDLENS],
		:HiddenAbilities => :RUNAWAY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 61,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:BATONPASS,:BUGBITE,:GIGADRAIN,:MORNINGSUN,:RAGEPOWDER,:SCREECH,:SECRETPOWER,:SIGNALBEAM,:SKILLSWAP,:TOXICSPIKES,],
		:Moveset => [
			[1,:TACKLE],
			[1,:DISABLE],
			[1,:FORESIGHT],
			[5,:SUPERSONIC],
			[11,:CONFUSION],
			[13,:POISONPOWDER],
			[17,:PSYBEAM],
			[23,:STUNSPORE],
			[25,:SIGNALBEAM],
			[29,:SLEEPPOWDER],
			[35,:LEECHLIFE],
			[37,:ZENHEADBUTT],
			[41,:POISONFANG],
			[47,:PSYCHIC]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BIDE,:BUGBITE,:CURSE,:DOUBLEEDGE,:FLASH,:GIGADRAIN,:HEADBUTT,:INFESTATION,:LEECHLIFE,:MEGADRAIN,:MIMIC,:PSYCHIC,:PSYWAVE,:RAGE,:REFLECT,:SCREECH,:SIGNALBEAM,:SKILLSWAP,:SKITTERSMACK,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWIFT,:TAKEDOWN,:THIEF,:TOXICSPIKES,:VENOSHOCK,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 10,
		:Weight => 300,
		:kind => "Insect",
		:dexentry => "Its coat of thin, stiff hair that covers its entire body is said to have evolved for protection. Its large eyes never fail to spot even miniscule prey.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VENOMOTH,:Level,31]
		]
	},

	:OnCreation => {},
},

:VENOMOTH => {
	"Normal Form" => {
		:name => "Venomoth",
		:dexnum => 49,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [70, 65, 60, 90, 75, 90],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:SHIELDDUST, :TINTEDLENS],
		:HiddenAbilities => :WONDERSKIN,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :VENONAT,
			:form => 0
		},
		:Moveset => [
			[0,:GUST],
			[1,:QUIVERDANCE],
			[1,:BUGBUZZ],
			[1,:SILVERWIND],
			[1,:TACKLE],
			[1,:DISABLE],
			[1,:FORESIGHT],
			[1,:SUPERSONIC],
			[5,:SUPERSONIC],
			[11,:CONFUSION],
			[13,:POISONPOWDER],
			[17,:PSYBEAM],
			[23,:STUNSPORE],
			[25,:SIGNALBEAM],
			[29,:SLEEPPOWDER],
			[37,:LEECHLIFE],
			[41,:ZENHEADBUTT],
			[47,:POISONFANG],
			[55,:PSYCHIC],
			[59,:BUGBUZZ],
			[63,:QUIVERDANCE]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BATONPASS,:BIDE,:BUGBITE,:BUGBUZZ,:CROSSPOISON,:CURSE,:DEFOG,:DOUBLEEDGE,:DREAMEATER,:ENERGYBALL,:FLASH,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:INFESTATION,:LEECHLIFE,:MEGADRAIN,:MIMIC,:OMINOUSWIND,:PSYCHIC,:PSYCHICFANGS,:PSYWAVE,:RAGE,:RAZORWIND,:REFLECT,:ROOST,:SCREECH,:SIGNALBEAM,:SILVERWIND,:SKILLSWAP,:SKITTERSMACK,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:SWIFT,:TAILWIND,:TAKEDOWN,:TELEPORT,:THIEF,:TOXICSPIKES,:TWISTER,:UTURN,:VENOSHOCK,:WHIRLWIND,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWMIST,],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 15,
		:Weight => 125,
		:WildItemUncommon => :SHEDSHELL,
		:kind => "Poison Moth",
		:dexentry => "Venomoth are nocturnal-- they only are active at night. Their favorite prey are insects that gather around streetlights, attracted by the light.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 15,
	},

	:OnCreation => {},
},

:DIGLETT => {
	"Normal Form" => {
		:name => "Diglett",
		:dexnum => 50,
		:Type1 => :GROUND,
		:BaseStats => [10, 55, 25, 35, 45, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SANDVEIL, :ARENATRAP],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 53,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:ASTONISH,:BEATUP,:ENDURE,:FEINTATTACK,:FINALGAMBIT,:HEADBUTT,:MEMENTO,:MUDBOMB,:PURSUIT,:REVERSAL,:SCREECH,:UPROAR,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:SANDATTACK],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:MUDSLAP],
			[14,:MAGNITUDE],
			[18,:BULLDOZE],
			[22,:SUCKERPUNCH],
			[25,:MUDBOMB],
			[28,:EARTHPOWER],
			[31,:DIG],
			[35,:SLASH],
			[39,:EARTHQUAKE],
			[43,:FISSURE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:ANCIENTPOWER,:ASSURANCE,:BEATUP,:BIDE,:BODYSLAM,:BULLDOZE,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FEINTATTACK,:FISSURE,:HEADBUTT,:HONECLAWS,:MIMIC,:MUDSLAP,:RAGE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCORCHINGSANDS,:SCREECH,:SHADOWCLAW,:SLUDGEBOMB,:STEALTHROCK,:STOMPINGTANTRUM,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:THIEF,:UPROAR,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Cave",
		:EggGroups => [:Field],
		:Height => 2,
		:Weight => 8,
		:WildItemUncommon => :SOFTSAND,
		:kind => "Mole",
		:dexentry => "Diglett are raised in most farms. The reason is simple-- wherever they burrow, the soil is left perfectly tilled for growing delicious crops.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DUGTRIO,:Level,26]
		]
	},

	"Alolan Form" => {
		:Type2 => :STEEL,
		:BaseStats => [10, 55, 30, 35, 40, 90],
		:Abilities => [:SANDVEIL, :TANGLINGHAIR, :SANDFORCE],
		:EggMoves => [:ANCIENTPOWER,:BEATUP,:ENDURE,:FEINTATTACK,:FINALGAMBIT,:HEADBUTT,:MEMENTO,:METALSOUND,:PURSUIT,:REVERSAL,:FLASH,],
		:Moveset => [
			[1,:SANDATTACK],
			[1,:METALCLAW],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:MUDSLAP],
			[14,:MAGNITUDE],
			[18,:BULLDOZE],
			[22,:SUCKERPUNCH],
			[25,:MUDBOMB],
			[28,:EARTHPOWER],
			[31,:DIG],
			[35,:IRONHEAD],
			[39,:EARTHQUAKE],
			[43,:FISSURE],
		],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:ANCIENTPOWER,:ASSURANCE,:BEATUP,:BODYSLAM,:BULLDOZE,:DIG,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FEINTATTACK,:FISSURE,:FLASHCANNON,:HEADBUTT,:HONECLAWS,:IRONDEFENSE,:IRONHEAD,:MUDSLAP,:REVERSAL,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:SCORCHINGSANDS,:SCREECH,:SHADOWCLAW,:SLUDGEBOMB,:STEALTHROCK,:STEELBEAM,:STOMPINGTANTRUM,:SUCKERPUNCH,:SUNNYDAY,:THIEF,:UPROAR,:WORKUP,],
		:moveexceptions => [],
		:Weight => 10,
		:dexentry => "Its head sports an altered form of whiskers made of metal. When in communication with its comrades, its whiskers wobble to and fro.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Diglett.include?($game_map.map_id) ? 1 : 0
 },
},

:DUGTRIO => {
	"Normal Form" => {
		:name => "Dugtrio",
		:dexnum => 51,
		:Type1 => :GROUND,
		:BaseStats => [35, 100, 50, 50, 70, 120],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SANDVEIL, :ARENATRAP],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 50,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :DIGLETT,
			:form => 0
		},
		:Moveset => [
			[0,:SANDTOMB],
			[1,:ROTOTILLER],
			[1,:NIGHTSLASH],
			[1,:TRIATTACK],
			[1,:SCRATCH],
			[1,:SANDATTACK],
			[1,:GROWL],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:MUDSLAP],
			[14,:MAGNITUDE],
			[18,:BULLDOZE],
			[22,:SUCKERPUNCH],
			[25,:MUDBOMB],
			[30,:EARTHPOWER],
			[35,:DIG],
			[41,:SLASH],
			[47,:EARTHQUAKE],
			[53,:FISSURE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:ANCIENTPOWER,:ASSURANCE,:BEATUP,:BIDE,:BODYSLAM,:BULLDOZE,:CHARM,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FEINTATTACK,:FISSURE,:GIGAIMPACT,:HEADBUTT,:HIGHHORSEPOWER,:HONECLAWS,:HYPERBEAM,:MIMIC,:MUDSLAP,:RAGE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SCREECH,:SHADOWCLAW,:SLUDGEBOMB,:SLUDGEWAVE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:THIEF,:TRIATTACK,:UPROAR,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBREAK,:SHADOWSHED,:SHADOWSKY,],
		:Color => "Brown",
		:Habitat => "Cave",
		:EggGroups => [:Field],
		:Height => 7,
		:Weight => 333,
		:WildItemUncommon => :SOFTSAND,
		:kind => "Mole",
		:dexentry => "Because the triplets originally split from one body, they think exactly alike. They work cooperatively to burrow endlessly through the ground.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type2 => :STEEL,
		:BaseStats => [35, 100, 60, 50, 70, 110],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SANDVEIL, :TANGLINGHAIR, :SANDFORCE],
		:preevo => {
			:species => :DIGLETT,
			:form => 1
		},
		:Moveset => [
			[0,:SANDTOMB],
			[1,:ROTOTILLER],
			[1,:NIGHTSLASH],
			[1,:TRIATTACK],
			[1,:SANDATTACK],
			[1,:METALCLAW],
			[1,:GROWL],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:MUDSLAP],
			[14,:MAGNITUDE],
			[18,:BULLDOZE],
			[22,:SUCKERPUNCH],
			[25,:MUDBOMB],
			[30,:EARTHPOWER],
			[35,:DIG],
			[41,:IRONHEAD],
			[47,:EARTHQUAKE],
			[53,:FISSURE],
		],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:ANCIENTPOWER,:ASSURANCE,:BEATUP,:BODYSLAM,:BULLDOZE,:DIG,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FEINTATTACK,:FISSURE,:FLASHCANNON,:GIGAIMPACT,:HEADBUTT,:HIGHHORSEPOWER,:HONECLAWS,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:MUDSLAP,:REVERSAL,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SCREECH,:SHADOWCLAW,:SLUDGEBOMB,:SLUDGEWAVE,:STEALTHROCK,:STEELBEAM,:STOMPINGTANTRUM,:STONEEDGE,:SUCKERPUNCH,:SUNNYDAY,:THIEF,:TRIATTACK,:UPROAR,:WORKUP,],
		:moveexceptions => [],
		:Weight => 666,
		:dexentry => "Its shining gold hair provides it with protection. It's reputed that keeping any of its fallen hairs will bring bad luck.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 next $game_map && Diglett.include?($game_map.map_id) ? 1 : 0
 },
},

:MEOWTH => {
	"Normal Form" => {
		:name => "Meowth",
		:dexnum => 52,
		:Type1 => :NORMAL,
		:BaseStats => [40, 45, 35, 40, 40, 90],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:PICKUP, :TECHNICIAN],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:ASSIST,:CHARM,:FLAIL,:FOULPLAY,:HYPNOSIS,:IRONTAIL,:LASTRESORT,:ODORSLEUTH,:PUNISHMENT,:SNATCH,:SPITE,:TAILWHIP,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[6,:BITE],
			[9,:FAKEOUT],
			[14,:FURYSWIPES],
			[17,:SCREECH],
			[22,:FEINTATTACK],
			[25,:TAUNT],
			[30,:PAYDAY],
			[33,:SLASH],
			[38,:NASTYPLOT],
			[41,:ASSURANCE],
			[46,:CAPTIVATE],
			[49,:NIGHTSLASH],
			[50,:FEINT]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ASSURANCE,:BIDE,:BODYSLAM,:BUBBLEBEAM,:CHARM,:COVET,:CURSE,:CUT,:DARKPULSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:FAKEOUT,:FEINTATTACK,:FLASH,:FOULPLAY,:GUNKSHOT,:HAPPYHOUR,:HEADBUTT,:HONECLAWS,:HYPERVOICE,:HYPNOSIS,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:TORMENT,:UPROAR,:UTURN,:WATERGUN,:WATERPULSE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,],
		:Color => "Yellow",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 42,
		:WildItemUncommon => :QUICKCLAW,
		:kind => "Scratch Cat",
		:dexentry => "Meowth withdraw their sharp claws into their paws to silently sneak about. For some reason, this Pokémon loves shiny coins that glitter with light.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PERSIAN,:Level,28]
		]
	},

	"Alolan Form" => {
		:Type1 => :DARK,
		:BaseStats => [40, 35, 35, 50, 40, 90],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:PICKUP, :TECHNICIAN, :RATTLED],
		:EggMoves => [:AMNESIA,:ASSIST,:CHARM,:COVET,:FLAIL,:FLATTER,:FOULPLAY,:HYPNOSIS,:PARTINGSHOT,:PUNISHMENT,:SNATCH,:SPITE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[6,:BITE],
			[9,:FAKEOUT],
			[14,:FURYSWIPES],
			[17,:SCREECH],
			[22,:FEINTATTACK],
			[25,:TAUNT],
			[30,:PAYDAY],
			[33,:SLASH],
			[38,:NASTYPLOT],
			[41,:ASSURANCE],
			[46,:CAPTIVATE],
			[49,:NIGHTSLASH],
			[50,:FEINT],
			[55,:DARKPULSE],
		],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ASSURANCE,:BODYSLAM,:CHARM,:COVET,:DARKPULSE,:DIG,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:FAKEOUT,:FEINTATTACK,:FOULPLAY,:GUNKSHOT,:HEADBUTT,:HYPERVOICE,:HYPNOSIS,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:NASTYPLOT,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHUP,:QUASH,:RAINDANCE,:RETALIATE,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:TORMENT,:UPROAR,:UTURN,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:dexentry => "When its delicate pride is wounded, or when the gold coin on its forehead is dirtied, it flies into a hysterical rage.",
		:evolutions => [
			[:PERSIAN,:Happiness,0]
		]
	},

	"Galarian Form" => {
		:Type1 => :STEEL,
		:BaseStats => [50, 65, 55, 40, 40, 40],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:PICKUP, :TOUGHCLAWS, :UNNERVE],
		:EggMoves => [:COVET,:FLAIL,:SPITE,:DOUBLEEDGE,:CURSE,:NIGHTSLASH,],
		:Moveset => [
			[1,:FAKEOUT],
			[1,:GROWL],
			[4,:HONECLAWS],
			[8,:SCRATCH],
			[12,:PAYDAY],
			[16,:METALCLAW],
			[20,:TAUNT],
			[24,:SWAGGER],
			[29,:FURYSWIPES],
			[32,:SCREECH],
			[36,:SLASH],
			[40,:METALSOUND],
			[44,:THRASH],
		],
		:compatiblemoves => [:AMNESIA,:ASSURANCE,:BODYSLAM,:COVET,:CRUNCH,:DARKPULSE,:DIG,:FAKEOUT,:FOULPLAY,:GUNKSHOT,:GYROBALL,:HONECLAWS,:HYPERVOICE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:LASHOUT,:NASTYPLOT,:PAYBACK,:PAYDAY,:PLAYROUGH,:RAINDANCE,:RETALIATE,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SPITE,:STEELBEAM,:SUNNYDAY,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:dexentry => "These daring Pokémon have coins on their foreheads. Darker coins are harder, and harder coins garner more respect among Meowth.",
		:evolutions => [
			[:PERRSERKER,:Level,28]
		]
	},

	:OnCreation => proc{
 # Map IDs for alolan and galarian forms respectively
 if $game_map && Rattata.include?($game_map.map_id) #rattata includes meowth
 next 1
 elsif $game_map && Meowth.include?($game_map.map_id)
 next 2
 else
 next 0
 end
 },
},

:PERSIAN => {
	"Normal Form" => {
		:name => "Persian",
		:dexnum => 53,
		:Type1 => :NORMAL,
		:BaseStats => [65, 70, 60, 65, 65, 115],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:LIMBER, :TECHNICIAN],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 154,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MEOWTH,
			:form => 0
		},
		:Moveset => [
			[0,:SWIFT],
			[1,:PLAYROUGH],
			[1,:SWITCHEROO],
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:BITE],
			[1,:FAKEOUT],
			[6,:BITE],
			[9,:FAKEOUT],
			[14,:FURYSWIPES],
			[17,:SCREECH],
			[22,:FEINTATTACK],
			[25,:TAUNT],
			[32,:POWERGEM],
			[37,:SLASH],
			[44,:NASTYPLOT],
			[49,:ASSURANCE],
			[56,:CAPTIVATE],
			[61,:NIGHTSLASH],
			[65,:FEINT]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ASSURANCE,:BIDE,:BODYSLAM,:BUBBLEBEAM,:CHARM,:COVET,:CURSE,:CUT,:DARKPULSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:FAKEOUT,:FEINTATTACK,:FLASH,:FOULPLAY,:GIGAIMPACT,:GUNKSHOT,:HAPPYHOUR,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:HYPNOSIS,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYBACK,:PAYDAY,:PLAYROUGH,:POWERGEM,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:ROAR,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKITTERSMACK,:SKULLBASH,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:TORMENT,:UPROAR,:UTURN,:WATERGUN,:WATERPULSE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 320,
		:WildItemUncommon => :QUICKCLAW,
		:kind => "Classy Cat",
		:dexentry => "A Persian's six bold whiskers sense air movements to determine what is in its vicinity. It becomes docile if grabbed by the whiskers.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type1 => :DARK,
		:BaseStats => [65, 60, 60, 75, 65, 115],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:FURCOAT, :TECHNICIAN, :RATTLED],
		:preevo => {
			:species => :MEOWTH,
			:form => 1
		},
		:Moveset => [
			[0,:SWIFT],
			[1,:QUASH],
			[1,:PLAYROUGH],
			[1,:SWITCHEROO],
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:BITE],
			[1,:FAKEOUT],
			[6,:BITE],
			[9,:FAKEOUT],
			[14,:FURYSWIPES],
			[17,:SCREECH],
			[22,:FEINTATTACK],
			[25,:TAUNT],
			[32,:POWERGEM],
			[37,:SLASH],
			[44,:NASTYPLOT],
			[49,:ASSURANCE],
			[56,:CAPTIVATE],
			[61,:NIGHTSLASH],
			[65,:FEINT],
			[69,:DARKPULSE],
		],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ASSURANCE,:BEATUP,:BODYSLAM,:BURNINGJEALOUSY,:CHARM,:COVET,:DARKPULSE,:DIG,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:FAKEOUT,:FAKETEARS,:FEINTATTACK,:FOULPLAY,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HYPERBEAM,:HYPERVOICE,:HYPNOSIS,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:NASTYPLOT,:PAYBACK,:PAYDAY,:PLAYROUGH,:POWERGEM,:PSYCHUP,:QUASH,:RAINDANCE,:RETALIATE,:ROAR,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKITTERSMACK,:SNARL,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:TORMENT,:UPROAR,:UTURN,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Height => 11,
		:Weight => 330,
		:dexentry => "It looks down on everyone other than itself. Its preferred tactics are sucker punches and blindside attacks.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Rattata.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:PSYDUCK => {
	"Normal Form" => {
		:name => "Psyduck",
		:dexnum => 54,
		:Type1 => :WATER,
		:BaseStats => [50, 52, 48, 65, 50, 55],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:DAMP, :CLOUDNINE],
		:HiddenAbilities => :SWIFTSWIM,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 64,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CLEARSMOG,:CONFUSERAY,:CROSSCHOP,:ENCORE,:FORESIGHT,:FUTURESIGHT,:HYPNOSIS,:MUDBOMB,:PSYBEAM,:REFRESH,:SECRETPOWER,:SIMPLEBEAM,:SLEEPTALK,:SYNCHRONOISE,:YAWN,],
		:Moveset => [
			[1,:WATERSPORT],
			[1,:SCRATCH],
			[4,:TAILWHIP],
			[7,:WATERGUN],
			[10,:CONFUSION],
			[13,:FURYSWIPES],
			[16,:WATERPULSE],
			[19,:DISABLE],
			[22,:SCREECH],
			[25,:ZENHEADBUTT],
			[28,:AQUATAIL],
			[31,:SOAK],
			[34,:PSYCHUP],
			[37,:AMNESIA],
			[40,:HYDROPUMP],
			[43,:WONDERROOM]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CALMMIND,:COUNTER,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:ENCORE,:FLASH,:FLING,:FOCUSPUNCH,:FUTURESIGHT,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPNOSIS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PAYDAY,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAGE,:RAINDANCE,:ROCKSMASH,:ROLEPLAY,:SCALD,:SCREECH,:SEISMICTOSS,:SHADOWCLAW,:SIGNALBEAM,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TRIATTACK,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WONDERROOM,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Field],
		:Height => 8,
		:Weight => 196,
		:kind => "Duck",
		:dexentry => "When its headache intensifies, it starts using strange powers. However, it has no recollection of its powers, so it always looks befuddled and bewildered.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GOLDUCK,:Level,33]
		]
	},

	:OnCreation => {},
},

:GOLDUCK => {
	"Normal Form" => {
		:name => "Golduck",
		:dexnum => 55,
		:Type1 => :WATER,
		:BaseStats => [80, 82, 78, 95, 80, 85],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:DAMP, :CLOUDNINE],
		:HiddenAbilities => :SWIFTSWIM,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PSYDUCK,
			:form => 0
		},
		:Moveset => [
			[1,:MEFIRST],
			[1,:AQUAJET],
			[1,:WATERSPORT],
			[1,:SCRATCH],
			[1,:TAILWHIP],
			[1,:WATERGUN],
			[4,:TAILWHIP],
			[7,:WATERGUN],
			[10,:CONFUSION],
			[13,:FURYSWIPES],
			[16,:WATERPULSE],
			[19,:DISABLE],
			[22,:SCREECH],
			[25,:ZENHEADBUTT],
			[28,:AQUATAIL],
			[31,:SOAK],
			[36,:PSYCHUP],
			[41,:AMNESIA],
			[46,:HYDROPUMP],
			[51,:WONDERROOM]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CALMMIND,:CHARM,:COUNTER,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:ENCORE,:FLASH,:FLING,:FLIPTURN,:FOCUSBLAST,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:HYPNOSIS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:PAYDAY,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAGE,:RAINDANCE,:ROCKCLIMB,:ROCKSMASH,:ROLEPLAY,:SCALD,:SCREECH,:SEISMICTOSS,:SHADOWCLAW,:SIGNALBEAM,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TRIATTACK,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WONDERROOM,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWMIST,],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Field],
		:Height => 17,
		:Weight => 766,
		:kind => "Duck",
		:dexentry => "A Golduck is an adept swimmer. It sometimes joins competitive swimmers in training. It uses psychic powers when its forehead shimmers with light.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MANKEY => {
	"Normal Form" => {
		:name => "Mankey",
		:dexnum => 56,
		:Type1 => :FIGHTING,
		:BaseStats => [40, 80, 35, 35, 45, 70],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:VITALSPIRIT, :ANGERPOINT],
		:HiddenAbilities => :DEFIANT,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 61,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BEATUP,:CLOSECOMBAT,:COUNTER,:ENCORE,:FOCUSPUNCH,:FORESIGHT,:MEDITATE,:NIGHTSLASH,:POWERTRIP,:REVENGE,:REVERSAL,:SLEEPTALK,:SMELLINGSALTS,],
		:Moveset => [
			[1,:COVET],
			[1,:SCRATCH],
			[1,:LOWKICK],
			[1,:LEER],
			[1,:FOCUSENERGY],
			[5,:FURYSWIPES],
			[8,:KARATECHOP],
			[12,:PURSUIT],
			[15,:SEISMICTOSS],
			[19,:SWAGGER],
			[22,:CROSSCHOP],
			[26,:ASSURANCE],
			[29,:PUNISHMENT],
			[33,:THRASH],
			[36,:CLOSECOMBAT],
			[40,:SCREECH],
			[43,:STOMPINGTANTRUM],
			[47,:OUTRAGE],
			[50,:FINALGAMBIT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:ASSURANCE,:BEATUP,:BIDE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COUNTER,:COVET,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:ENDEAVOR,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:ICEPUNCH,:IRONTAIL,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PAYBACK,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:SPITE,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:UTURN,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWRUSH,],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 280,
		:kind => "Pig Monkey",
		:dexentry => "When it starts shaking and its nasal breathing turns rough, it is a sure sign of anger. However, since this happens instantly, there is no time to flee.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PRIMEAPE,:Level,28]
		]
	},

	:OnCreation => {},
},

:PRIMEAPE => {
	"Normal Form" => {
		:name => "Primeape",
		:dexnum => 57,
		:Type1 => :FIGHTING,
		:BaseStats => [65, 105, 60, 60, 70, 95],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:VITALSPIRIT, :ANGERPOINT],
		:HiddenAbilities => :DEFIANT,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MANKEY,
			:form => 0
		},
		:Moveset => [
			[0,:RAGE],
			[1,:FINALGAMBIT],
			[1,:FLING],
			[1,:SCRATCH],
			[1,:LOWKICK],
			[1,:LEER],
			[1,:FOCUSENERGY],
			[5,:FURYSWIPES],
			[8,:KARATECHOP],
			[12,:PURSUIT],
			[15,:SEISMICTOSS],
			[19,:SWAGGER],
			[22,:CROSSCHOP],
			[26,:ASSURANCE],
			[30,:PUNISHMENT],
			[35,:THRASH],
			[39,:CLOSECOMBAT],
			[44,:SCREECH],
			[48,:STOMPINGTANTRUM],
			[53,:OUTRAGE],
			[57,:FINALGAMBIT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:ASSURANCE,:BEATUP,:BIDE,:BLAZEKICK,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:BURNINGJEALOUSY,:CLOSECOMBAT,:COACHING,:COUNTER,:COVET,:CURSE,:DARKESTLARIAT,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:ENDEAVOR,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:IRONTAIL,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PAYBACK,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:SPITE,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:UTURN,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWRUSH,],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 320,
		:kind => "Pig Monkey",
		:dexentry => "It has been known to become so angry that it dies as a result. Its face looks peaceful in death, however.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GROWLITHE => {
	"Normal Form" => {
		:name => "Growlithe",
		:dexnum => 58,
		:Type1 => :FIRE,
		:BaseStats => [55, 70, 45, 70, 50, 60],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :FLASHFIRE],
		:HiddenAbilities => :JUSTIFIED,
		:GrowthRate => :Slow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 70,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BODYSLAM,:BURNUP,:CLOSECOMBAT,:COVET,:CRUNCH,:DOUBLEKICK,:DOUBLEEDGE,:FIRESPIN,:FLAREBLITZ,:HEATWAVE,:HOWL,:IRONTAIL,:MORNINGSUN,:THRASH,],
		:Moveset => [
			[1,:BITE],
			[1,:ROAR],
			[6,:EMBER],
			[8,:LEER],
			[10,:ODORSLEUTH],
			[12,:HELPINGHAND],
			[17,:FLAMEWHEEL],
			[19,:REVERSAL],
			[21,:FIREFANG],
			[23,:TAKEDOWN],
			[28,:FLAMEBURST],
			[30,:AGILITY],
			[32,:RETALIATE],
			[34,:FLAMETHROWER],
			[39,:CRUNCH],
			[41,:HEATWAVE],
			[43,:OUTRAGE],
			[45,:FLAREBLITZ]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:BIDE,:BODYSLAM,:CHARM,:CLOSECOMBAT,:COVET,:CRUNCH,:CURSE,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONRAGE,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:INCINERATE,:IRONTAIL,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PLAYROUGH,:PSYCHICFANGS,:RAGE,:REFLECT,:RETALIATE,:REVERSAL,:ROAR,:ROCKSMASH,:SAFEGUARD,:SKULLBASH,:SNARL,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:THIEF,:WILDCHARGE,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWWAVE,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 7,
		:Weight => 190,
		:kind => "Puppy",
		:dexentry => "Its superb sense of smell ensures that this Pokémon won't forget any scent, no matter what. It uses its sense of smell to detect the emotions of others.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ARCANINE,:Item,:FIRESTONE]
		]
	},

	:OnCreation => {},
},

:ARCANINE => {
	"Normal Form" => {
		:name => "Arcanine",
		:dexnum => 59,
		:Type1 => :FIRE,
		:BaseStats => [90, 110, 80, 100, 80, 95],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :FLASHFIRE],
		:HiddenAbilities => :JUSTIFIED,
		:GrowthRate => :Slow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 194,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GROWLITHE,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERFANG],
			[1,:BITE],
			[1,:ROAR],
			[1,:ODORSLEUTH],
			[1,:FIREFANG],
			[34,:EXTREMESPEED]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:BIDE,:BODYSLAM,:BULLDOZE,:CHARM,:CLOSECOMBAT,:COVET,:CRUNCH,:CURSE,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONPULSE,:DRAGONRAGE,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PLAYROUGH,:PSYCHICFANGS,:RAGE,:REFLECT,:RETALIATE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SCARYFACE,:SCORCHINGSANDS,:SKULLBASH,:SNARL,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAKEDOWN,:TELEPORT,:THIEF,:THUNDERFANG,:WILDCHARGE,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 19,
		:Weight => 1550,
		:kind => "Legendary",
		:dexentry => "This fleet-footed Pokémon is said to run over 6,200 miles in a single day and night. The fire that blazes wildly within its body is its source of power.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:POLIWAG => {
	"Normal Form" => {
		:name => "Poliwag",
		:dexnum => 60,
		:Type1 => :WATER,
		:BaseStats => [40, 50, 40, 40, 40, 90],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:WATERABSORB, :DAMP],
		:HiddenAbilities => :SWIFTSWIM,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BUBBLEBEAM,:ENCORE,:ENDEAVOR,:ENDURE,:HAZE,:ICEBALL,:MINDREADER,:MIST,:MUDSHOT,:REFRESH,:SPLASH,:WATERPULSE,:WATERSPORT,],
		:Moveset => [
			[1,:WATERSPORT],
			[5,:WATERGUN],
			[8,:HYPNOSIS],
			[11,:BUBBLE],
			[15,:DOUBLESLAP],
			[18,:RAINDANCE],
			[21,:BODYSLAM],
			[25,:BUBBLEBEAM],
			[28,:MUDSHOT],
			[31,:BELLYDRUM],
			[35,:WAKEUPSLAP],
			[38,:HYDROPUMP],
			[41,:MUDBOMB]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BLIZZARD,:BODYSLAM,:BUBBLEBEAM,:BULLDOZE,:CURSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:ENCORE,:ENDEAVOR,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPNOSIS,:ICEBALL,:ICEBEAM,:ICYWIND,:LOWKICK,:MIMIC,:MUDDYWATER,:MUDSHOT,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:SCALD,:SKULLBASH,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1],
		:Height => 6,
		:Weight => 124,
		:kind => "Tadpole",
		:dexentry => "It is possible to see this Pokémon's spiral innards right through its thin skin. However, the skin is also very flexible. Even sharp fangs bounce off it.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:POLIWHIRL,:Level,25]
		]
	},

	:OnCreation => {},
},

:POLIWHIRL => {
	"Normal Form" => {
		:name => "Poliwhirl",
		:dexnum => 61,
		:Type1 => :WATER,
		:BaseStats => [65, 65, 65, 50, 50, 90],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:WATERABSORB, :DAMP],
		:HiddenAbilities => :SWIFTSWIM,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 135,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :POLIWAG,
			:form => 0
		},
		:Moveset => [
			[1,:WATERSPORT],
			[1,:WATERGUN],
			[1,:HYPNOSIS],
			[5,:WATERGUN],
			[8,:HYPNOSIS],
			[11,:BUBBLE],
			[15,:DOUBLESLAP],
			[18,:RAINDANCE],
			[21,:BODYSLAM],
			[27,:BUBBLEBEAM],
			[32,:MUDSHOT],
			[37,:BELLYDRUM],
			[43,:WAKEUPSLAP],
			[48,:HYDROPUMP],
			[53,:MUDBOMB]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENCORE,:ENDEAVOR,:FISSURE,:FLING,:FOCUSPUNCH,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPNOSIS,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:ROCKSMASH,:SCALD,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1],
		:Height => 10,
		:Weight => 200,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Tadpole",
		:dexentry => "Its body surface is always wet and slick with an oily fluid. Because of this greasy covering, it can easily slip and slide out of the clutches of any enemy in battle.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:POLIWRATH,:Item,:WATERSTONE],
			[:POLITOED,:TradeItem,:KINGSROCK]
		]
	},

	:OnCreation => {},
},

:POLIWRATH => {
	"Normal Form" => {
		:name => "Poliwrath",
		:dexnum => 62,
		:Type1 => :WATER,
		:Type2 => :FIGHTING,
		:BaseStats => [90, 95, 95, 70, 90, 70],
		:EVs => [0, 0, 3, 0, 0, 0],
		:Abilities => [:WATERABSORB, :DAMP],
		:HiddenAbilities => :SWIFTSWIM,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 225,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :POLIWHIRL,
			:form => 0
		},
		:Moveset => [
			[0,:SUBMISSION],
			[1,:CIRCLETHROW],
			[1,:BUBBLEBEAM],
			[1,:HYPNOSIS],
			[1,:DOUBLESLAP],
			[32,:DYNAMICPUNCH],
			[43,:MINDREADER],
			[53,:CIRCLETHROW]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:CURSE,:DARKESTLARIAT,:DEFENSECURL,:DETECT,:DIG,:DIVE,:DOUBLEEDGE,:DRAINPUNCH,:DUALCHOP,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ENCORE,:ENDEAVOR,:FISSURE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HELPINGHAND,:HIGHHORSEPOWER,:HYDROPUMP,:HYPERBEAM,:HYPNOSIS,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SUPERPOWER,:SURF,:TAKEDOWN,:THIEF,:THROATCHOP,:VACUUMWAVE,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWRUSH,:SHADOWSKY,],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1],
		:Height => 13,
		:Weight => 540,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Tadpole",
		:dexentry => "Its highly developed muscles never grow fatigued, however much it exercises. This Pokémon can swim back and forth across an entire ocean without effort.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ABRA => {
	"Normal Form" => {
		:name => "Abra",
		:dexnum => 63,
		:Type1 => :PSYCHIC,
		:BaseStats => [25, 20, 15, 105, 55, 90],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:SYNCHRONIZE, :INNERFOCUS],
		:HiddenAbilities => :MAGICGUARD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 62,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ALLYSWITCH,:BARRIER,:ENCORE,:FIREPUNCH,:GUARDSPLIT,:GUARDSWAP,:ICEPUNCH,:KNOCKOFF,:POWERTRICK,:PSYCHICTERRAIN,:PSYCHOSHIFT,:SKILLSWAP,:THUNDERPUNCH,],
		:Moveset => [
			[1,:TELEPORT]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:ENCORE,:ENERGYBALL,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:FOULPLAY,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPNOSIS,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:NIGHTMARE,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SPEEDSWAP,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 9,
		:Weight => 195,
		:WildItemUncommon => :TWISTEDSPOON,
		:kind => "Psi",
		:dexentry => "A Pokémon that sleeps 18 hours a day. Observation revealed that it uses Teleport to change its location once every hour.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KADABRA,:Level,16]
		]
	},

	:OnCreation => {},
},

:KADABRA => {
	"Normal Form" => {
		:name => "Kadabra",
		:dexnum => 64,
		:Type1 => :PSYCHIC,
		:BaseStats => [40, 35, 30, 120, 70, 105],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SYNCHRONIZE, :INNERFOCUS],
		:HiddenAbilities => :MAGICGUARD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 140,
		:CatchRate => 100,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :ABRA,
			:form => 0
		},
		:Moveset => [
			[0,:KINESIS],
			[1,:TELEPORT],
			[1,:CONFUSION],
			[16,:CONFUSION],
			[18,:DISABLE],
			[21,:PSYBEAM],
			[23,:MIRACLEEYE],
			[26,:REFLECT],
			[28,:PSYCHOCUT],
			[31,:RECOVER],
			[33,:TELEKINESIS],
			[36,:ALLYSWITCH],
			[38,:PSYCHIC],
			[41,:ROLEPLAY],
			[43,:FUTURESIGHT],
			[46,:TRICK]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPNOSIS,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:NIGHTMARE,:NIGHTSHADE,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SPEEDSWAP,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 13,
		:Weight => 565,
		:WildItemUncommon => :TWISTEDSPOON,
		:kind => "Psi",
		:dexentry => "It is rumored that a boy with psychic abilities suddenly transformed into Kadabra while he was assisting research into extrasensory powers.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ALAKAZAM,:Trade,0]
		]
	},

	:OnCreation => {},
},

:ALAKAZAM => {
	"Normal Form" => {
		:name => "Alakazam",
		:dexnum => 65,
		:Type1 => :PSYCHIC,
		:BaseStats => [55, 50, 45, 135, 95, 120],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:SYNCHRONIZE, :INNERFOCUS],
		:HiddenAbilities => :MAGICGUARD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 221,
		:CatchRate => 50,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :KADABRA,
			:form => 0
		},
		:Moveset => [
			[0,:KINESIS],
			[1,:TELEPORT],
			[1,:CONFUSION],
			[16,:CONFUSION],
			[18,:DISABLE],
			[21,:PSYBEAM],
			[23,:MIRACLEEYE],
			[26,:REFLECT],
			[28,:PSYCHOCUT],
			[31,:RECOVER],
			[33,:TELEKINESIS],
			[36,:ALLYSWITCH],
			[38,:PSYCHIC],
			[41,:CALMMIND],
			[43,:FUTURESIGHT],
			[46,:TRICK]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPERBEAM,:HYPNOSIS,:ICEPUNCH,:IMPRISON,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:NASTYPLOT,:NIGHTMARE,:NIGHTSHADE,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SPEEDSWAP,:STOREDPOWER,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 15,
		:Weight => 480,
		:WildItemUncommon => :TWISTEDSPOON,
		:kind => "Psi",
		:dexentry => "While it has strong psychic abilities and high intelligence, an Alakazam's muscles are very weak. It uses psychic power to move its body.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [55, 50, 65, 175, 105, 150],
		:Abilities => [:TRACE],
		:Weight => 480,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:ALAKAZITE => 1,
	},
},

:MACHOP => {
	"Normal Form" => {
		:name => "Machop",
		:dexnum => 66,
		:Type1 => :FIGHTING,
		:BaseStats => [70, 80, 50, 35, 35, 35],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:GUTS, :NOGUARD],
		:HiddenAbilities => :STEADFAST,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 61,
		:CatchRate => 180,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BULLETPUNCH,:CLOSECOMBAT,:COUNTER,:ENCORE,:FIREPUNCH,:HEAVYSLAM,:ICEPUNCH,:KNOCKOFF,:MEDITATE,:POWERTRICK,:QUICKGUARD,:ROLLINGKICK,:SMELLINGSALTS,:THUNDERPUNCH,:TICKLE,],
		:Moveset => [
			[1,:LOWKICK],
			[1,:LEER],
			[3,:FOCUSENERGY],
			[7,:KARATECHOP],
			[9,:FORESIGHT],
			[13,:LOWSWEEP],
			[15,:SEISMICTOSS],
			[19,:REVENGE],
			[21,:KNOCKOFF],
			[25,:VITALTHROW],
			[27,:WAKEUPSLAP],
			[31,:DUALCHOP],
			[33,:SUBMISSION],
			[37,:BULKUP],
			[39,:CROSSCHOP],
			[43,:SCARYFACE],
			[45,:DYNAMICPUNCH]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:HEADBUTT,:HEAVYSLAM,:HELPINGHAND,:ICEPUNCH,:INCINERATE,:KNOCKOFF,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THIEF,:THUNDERPUNCH,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 8,
		:Weight => 195,
		:WildItemUncommon => :FOCUSBAND,
		:kind => "Superpower",
		:dexentry => "It continually undertakes strenuous training to master all forms of martial arts. Its strength lets it easily hoist a sumo wrestler onto its shoulders.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MACHOKE,:Level,28]
		]
	},

	:OnCreation => {},
},

:MACHOKE => {
	"Normal Form" => {
		:name => "Machoke",
		:dexnum => 67,
		:Type1 => :FIGHTING,
		:BaseStats => [80, 100, 70, 50, 60, 45],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:GUTS, :NOGUARD],
		:HiddenAbilities => :STEADFAST,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 142,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MACHOP,
			:form => 0
		},
		:Moveset => [
			[1,:LOWKICK],
			[1,:LEER],
			[1,:FOCUSENERGY],
			[1,:KARATECHOP],
			[3,:FOCUSENERGY],
			[7,:KARATECHOP],
			[9,:FORESIGHT],
			[13,:LOWSWEEP],
			[15,:SEISMICTOSS],
			[19,:REVENGE],
			[21,:KNOCKOFF],
			[25,:VITALTHROW],
			[27,:WAKEUPSLAP],
			[33,:DUALCHOP],
			[37,:SUBMISSION],
			[43,:BULKUP],
			[47,:CROSSCHOP],
			[53,:SCARYFACE],
			[57,:DYNAMICPUNCH]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:HEADBUTT,:HEAVYSLAM,:HELPINGHAND,:ICEPUNCH,:INCINERATE,:KNOCKOFF,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THIEF,:THUNDERPUNCH,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 15,
		:Weight => 705,
		:WildItemUncommon => :FOCUSBAND,
		:kind => "Superpower",
		:dexentry => "A belt is worn by a Machoke to keep its overwhelming power under control. Because it is so dangerous, no one has ever removed the belt.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MACHAMP,:Trade,0]
		]
	},

	:OnCreation => {},
},

:MACHAMP => {
	"Normal Form" => {
		:name => "Machamp",
		:dexnum => 68,
		:Type1 => :FIGHTING,
		:BaseStats => [90, 130, 80, 65, 85, 55],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:GUTS, :NOGUARD],
		:HiddenAbilities => :STEADFAST,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 227,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MACHOKE,
			:form => 0
		},
		:Moveset => [
			[0,:STRENGTH],
			[1,:WIDEGUARD],
			[1,:LOWKICK],
			[1,:LEER],
			[1,:FOCUSENERGY],
			[1,:KARATECHOP],
			[3,:FOCUSENERGY],
			[7,:KARATECHOP],
			[9,:FORESIGHT],
			[13,:LOWSWEEP],
			[15,:SEISMICTOSS],
			[19,:REVENGE],
			[21,:KNOCKOFF],
			[25,:VITALTHROW],
			[27,:WAKEUPSLAP],
			[33,:DUALCHOP],
			[37,:SUBMISSION],
			[43,:BULKUP],
			[47,:CROSSCHOP],
			[53,:SCARYFACE],
			[57,:DYNAMICPUNCH]],
		:compatiblemoves => [:ASSURANCE,:BIDE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:CROSSPOISON,:CURSE,:DARKESTLARIAT,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEAVYSLAM,:HELPINGHAND,:HIGHHORSEPOWER,:HYPERBEAM,:ICEPUNCH,:INCINERATE,:KNOCKOFF,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKBLAST,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THIEF,:THROATCHOP,:THUNDERPUNCH,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 16,
		:Weight => 1300,
		:WildItemUncommon => :FOCUSBAND,
		:kind => "Superpower",
		:dexentry => "It is impossible to defend against punches and chops doled out by its four arms. Its fighting spirit flares up when it faces a tough opponent.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BELLSPROUT => {
	"Normal Form" => {
		:name => "Bellsprout",
		:dexnum => 69,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [50, 75, 35, 70, 30, 40],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :GLUTTONY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDSPRAY,:BELCH,:BULLETSEED,:CLEARSMOG,:ENCORE,:GIGADRAIN,:INGRAIN,:LEECHLIFE,:MAGICALLEAF,:NATURALGIFT,:POWERWHIP,:STRENGTHSAP,:SYNTHESIS,:TICKLE,:WEATHERBALL,:WORRYSEED,],
		:Moveset => [
			[1,:VINEWHIP],
			[7,:GROWTH],
			[11,:WRAP],
			[13,:SLEEPPOWDER],
			[15,:POISONPOWDER],
			[17,:STUNSPORE],
			[23,:ACID],
			[27,:KNOCKOFF],
			[29,:SWEETSCENT],
			[35,:GASTROACID],
			[39,:RAZORLEAF],
			[41,:POISONJAB],
			[47,:SLAM],
			[50,:WRINGOUT]],
		:compatiblemoves => [:BIDE,:BIND,:BULLETSEED,:CURSE,:CUT,:DOUBLEEDGE,:ENCORE,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:HEADBUTT,:INFESTATION,:KNOCKOFF,:LEECHLIFE,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:POISONJAB,:POWERWHIP,:RAGE,:REFLECT,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUCKERPUNCH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Grass],
		:Height => 7,
		:Weight => 40,
		:kind => "Flower",
		:dexentry => "A Bellsprout's thin and flexible body lets it bend and sway to avoid any attack, however strong it may be. Its mouth leaks a fluid that melts even iron.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WEEPINBELL,:Level,21]
		]
	},

	:OnCreation => {},
},

:WEEPINBELL => {
	"Normal Form" => {
		:name => "Weepinbell",
		:dexnum => 70,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [65, 90, 50, 85, 45, 55],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :GLUTTONY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 137,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BELLSPROUT,
			:form => 0
		},
		:Moveset => [
			[1,:VINEWHIP],
			[1,:GROWTH],
			[1,:WRAP],
			[7,:GROWTH],
			[11,:WRAP],
			[13,:SLEEPPOWDER],
			[15,:POISONPOWDER],
			[17,:STUNSPORE],
			[24,:ACID],
			[29,:KNOCKOFF],
			[32,:SWEETSCENT],
			[39,:GASTROACID],
			[44,:RAZORLEAF],
			[47,:POISONJAB],
			[54,:SLAM],
			[58,:WRINGOUT]],
		:compatiblemoves => [:BIDE,:BIND,:BUGBITE,:BULLETSEED,:CROSSPOISON,:CURSE,:CUT,:DOUBLEEDGE,:ENCORE,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:HEADBUTT,:INFESTATION,:KNOCKOFF,:LEAFBLADE,:LEECHLIFE,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:POISONJAB,:POWERWHIP,:RAGE,:REFLECT,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUCKERPUNCH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWHOLD,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Grass],
		:Height => 10,
		:Weight => 64,
		:kind => "Flycatcher",
		:dexentry => "At night, a Weepinbell hangs on to a tree branch with its hooked rear and sleeps. If it moves around in its sleep, it may wake up to find itself on the ground.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 10,
		:evolutions => [
			[:VICTREEBEL,:Item,:LEAFSTONE]
		]
	},

	:OnCreation => {},
},

:VICTREEBEL => {
	"Normal Form" => {
		:name => "Victreebel",
		:dexnum => 71,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [80, 105, 65, 100, 70, 70],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :GLUTTONY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 216,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WEEPINBELL,
			:form => 0
		},
		:Moveset => [
			[0,:LEAFTORNADO],
			[1,:STOCKPILE],
			[1,:SWALLOW],
			[1,:SPITUP],
			[1,:VINEWHIP],
			[1,:SLEEPPOWDER],
			[1,:RAZORLEAF],
			[1,:SWEETSCENT],
			[32,:LEAFSTORM],
			[44,:LEAFBLADE]],
		:compatiblemoves => [:BIDE,:BIND,:BODYSLAM,:BUGBITE,:BULLETSEED,:CROSSPOISON,:CURSE,:CUT,:DOUBLEEDGE,:ENCORE,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HYPERBEAM,:INFESTATION,:KNOCKOFF,:LEAFBLADE,:LEAFSTORM,:LEECHLIFE,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:POISONJAB,:POWERWHIP,:RAGE,:REFLECT,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SOLARBLADE,:SUCKERPUNCH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:VENOMDRENCH,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Grass],
		:Height => 17,
		:Weight => 155,
		:kind => "Flycatcher",
		:dexentry => "The long vine extending from its head is waved about as if it were a living thing to attract prey. When an unsuspecting victim approaches, it is swallowed whole.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:TENTACOOL => {
	"Normal Form" => {
		:name => "Tentacool",
		:dexnum => 72,
		:Type1 => :WATER,
		:Type2 => :POISON,
		:BaseStats => [40, 40, 35, 50, 100, 70],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:CLEARBODY, :LIQUIDOOZE],
		:HiddenAbilities => :RAINDISH,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 67,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACUPRESSURE,:AQUARING,:AURORABEAM,:BUBBLE,:CONFUSERAY,:HAZE,:KNOCKOFF,:MIRRORCOAT,:MUDDYWATER,:RAPIDSPIN,:TICKLE,],
		:Moveset => [
			[1,:POISONSTING],
			[4,:SUPERSONIC],
			[7,:CONSTRICT],
			[10,:ACID],
			[13,:TOXICSPIKES],
			[16,:WATERPULSE],
			[19,:WRAP],
			[22,:ACIDSPRAY],
			[25,:BUBBLEBEAM],
			[28,:BARRIER],
			[31,:POISONJAB],
			[34,:BRINE],
			[37,:SCREECH],
			[40,:HEX],
			[43,:SLUDGEWAVE],
			[46,:HYDROPUMP],
			[49,:WRINGOUT]],
		:compatiblemoves => [:BIDE,:BIND,:BLIZZARD,:BRINE,:BRUTALSWING,:BUBBLEBEAM,:CROSSPOISON,:CURSE,:CUT,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:GIGADRAIN,:HAIL,:HEADBUTT,:HEX,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INFESTATION,:KNOCKOFF,:MAGICCOAT,:MEGADRAIN,:MIMIC,:MUDDYWATER,:PAYBACK,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:SAFEGUARD,:SCALD,:SCREECH,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:TOXICSPIKES,:VENOSHOCK,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 9,
		:Weight => 455,
		:WildItemUncommon => :POISONBARB,
		:kind => "Jellyfish",
		:dexentry => "Its body is almost entirely composed of water. It ensnares its foe with its two long tentacles, then stabs with the poison stingers at their tips.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 8,
		:evolutions => [
			[:TENTACRUEL,:Level,30]
		]
	},

	:OnCreation => {},
},

:TENTACRUEL => {
	"Normal Form" => {
		:name => "Tentacruel",
		:dexnum => 73,
		:Type1 => :WATER,
		:Type2 => :POISON,
		:BaseStats => [80, 70, 65, 80, 120, 100],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:CLEARBODY, :LIQUIDOOZE],
		:HiddenAbilities => :RAINDISH,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 180,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TENTACOOL,
			:form => 0
		},
		:Moveset => [
			[1,:REFLECTTYPE],
			[1,:WRINGOUT],
			[1,:POISONSTING],
			[1,:SUPERSONIC],
			[1,:CONSTRICT],
			[1,:ACID],
			[4,:SUPERSONIC],
			[7,:CONSTRICT],
			[10,:ACID],
			[13,:TOXICSPIKES],
			[16,:WATERPULSE],
			[19,:WRAP],
			[22,:ACIDSPRAY],
			[25,:BUBBLEBEAM],
			[28,:BARRIER],
			[32,:POISONJAB],
			[36,:BRINE],
			[40,:SCREECH],
			[44,:HEX],
			[48,:SLUDGEWAVE],
			[52,:HYDROPUMP],
			[56,:WRINGOUT]],
		:compatiblemoves => [:BIDE,:BIND,:BLIZZARD,:BRINE,:BRUTALSWING,:BUBBLEBEAM,:CORROSIVEGAS,:CROSSPOISON,:CURSE,:CUT,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:GIGADRAIN,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEX,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INFESTATION,:KNOCKOFF,:MAGICCOAT,:MEGADRAIN,:MIMIC,:MUDDYWATER,:PAYBACK,:POISONJAB,:RAGE,:RAINDANCE,:REFLECT,:SAFEGUARD,:SCALD,:SCREECH,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 16,
		:Weight => 550,
		:WildItemUncommon => :POISONBARB,
		:kind => "Jellyfish",
		:dexentry => "It lives in complex rock formations on the ocean floor and traps prey using its 80 tentacles. Its red orbs glow when it grows excited or agitated.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 7,
	},

	:OnCreation => {},
},

:GEODUDE => {
	"Normal Form" => {
		:name => "Geodude",
		:dexnum => 74,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [40, 80, 100, 30, 30, 20],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :STURDY],
		:HiddenAbilities => :SANDVEIL,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AUTOTOMIZE,:BLOCK,:CURSE,:ENDURE,:FLAIL,:FOCUSPUNCH,:HAMMERARM,:MEGAPUNCH,:ROCKCLIMB,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[4,:MUDSPORT],
			[6,:ROCKPOLISH],
			[10,:ROLLOUT],
			[12,:MAGNITUDE],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:BULLDOZE],
			[24,:SELFDESTRUCT],
			[28,:STEALTHROCK],
			[30,:ROCKBLAST],
			[34,:EARTHQUAKE],
			[36,:EXPLOSION],
			[40,:DOUBLEEDGE],
			[42,:STONEEDGE]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GYROBALL,:HEADBUTT,:INCINERATE,:IRONDEFENSE,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:RAGE,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SEISMICTOSS,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THUNDERPUNCH,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Mineral],
		:Height => 4,
		:Weight => 200,
		:WildItemUncommon => :EVERSTONE,
		:kind => "Rock",
		:dexentry => "It climbs mountain paths using only the power of its arms. Because they look just like boulders lining paths, hikers may step on them without noticing.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 16,
		:evolutions => [
			[:GRAVELER,:Level,25]
		]
	},

	"Alolan Form" => {
		:Type2 => :ELECTRIC,
		:Abilities => [:MAGNETPULL, :STURDY, :GALVANIZE],
		:EggMoves => [:AUTOTOMIZE,:BLOCK,:COUNTER,:CURSE,:ENDURE,:FLAIL,:MAGNETRISE,:ROCKCLIMB,:SCREECH,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[4,:CHARGE],
			[6,:ROCKPOLISH],
			[10,:ROLLOUT],
			[12,:SPARK],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:THUNDERPUNCH],
			[24,:SELFDESTRUCT],
			[28,:STEALTHROCK],
			[30,:ROCKBLAST],
			[34,:DISCHARGE],
			[36,:EXPLOSION],
			[40,:DOUBLEEDGE],
			[42,:STONEEDGE],
		],
		:compatiblemoves => [:BLOCK,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DIG,:EARTHPOWER,:EARTHQUAKE,:ELECTROWEB,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GYROBALL,:HEADBUTT,:IRONDEFENSE,:MAGNETRISE,:NATUREPOWER,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:SUNNYDAY,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:VOLTSWITCH,],
		:moveexceptions => [],
		:Weight => 203,
		:WildItemUncommon => :CELLBATTERY,
		:dexentry => "If you accidentally step on a Geodude sleeping on the ground, you'll hear a crunching sound and feel a shock ripple through your entire body.",
	},

	:OnCreation => proc{
 maps=[]
 # Map IDs for alolan form
 if $game_map && Geodude.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:GRAVELER => {
	"Normal Form" => {
		:name => "Graveler",
		:dexnum => 75,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [55, 95, 115, 45, 45, 35],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :STURDY],
		:HiddenAbilities => :SANDVEIL,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 137,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :GEODUDE,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[1,:MUDSPORT],
			[1,:ROCKPOLISH],
			[4,:MUDSPORT],
			[6,:ROCKPOLISH],
			[10,:ROLLOUT],
			[12,:MAGNITUDE],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:BULLDOZE],
			[24,:SELFDESTRUCT],
			[30,:STEALTHROCK],
			[34,:ROCKBLAST],
			[40,:EARTHQUAKE],
			[44,:EXPLOSION],
			[50,:DOUBLEEDGE],
			[54,:STONEEDGE]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GYROBALL,:HEADBUTT,:INCINERATE,:IRONDEFENSE,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:RAGE,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SEISMICTOSS,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THUNDERPUNCH,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Mineral],
		:Height => 10,
		:Weight => 1050,
		:WildItemUncommon => :EVERSTONE,
		:kind => "Rock",
		:dexentry => "They descend from mountains by tumbling down steep slopes. They are so brutal, they smash aside trees and massive boulders with thunderous tackles.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GOLEM,:Trade,0]
		]
	},

	"Alolan Form" => {
		:Type2 => :ELECTRIC,
		:Abilities => [:MAGNETPULL, :STURDY, :GALVANIZE],
		:preevo => {
			:species => :GEODUDE,
			:form => 1
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[4,:CHARGE],
			[1,:ROCKPOLISH],
			[1,:CHARGE],
			[6,:ROCKPOLISH],
			[10,:ROLLOUT],
			[12,:SPARK],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:THUNDERPUNCH],
			[24,:SELFDESTRUCT],
			[30,:STEALTHROCK],
			[34,:ROCKBLAST],
			[40,:DISCHARGE],
			[44,:EXPLOSION],
			[50,:DOUBLEEDGE],
			[54,:STONEEDGE],
		],
		:compatiblemoves => [:BLOCK,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DIG,:EARTHPOWER,:EARTHQUAKE,:ELECTROWEB,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GYROBALL,:HEADBUTT,:IRONDEFENSE,:MAGNETRISE,:NATUREPOWER,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:SUNNYDAY,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:VOLTSWITCH,],
		:moveexceptions => [],
		:Weight => 1100,
		:WildItemUncommon => :CELLBATTERY,
		:dexentry => "They eat rocks and often get into a scrap over them. The shock of Graveler smashing together causes a flash of light and a booming noise.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Geodude.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:GOLEM => {
	"Normal Form" => {
		:name => "Golem",
		:dexnum => 76,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [80, 120, 130, 55, 65, 45],
		:EVs => [0, 0, 3, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :STURDY],
		:HiddenAbilities => :SANDVEIL,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 218,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :GRAVELER,
			:form => 0
		},
		:Moveset => [
			[1,:HEAVYSLAM],
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[1,:MUDSPORT],
			[1,:ROCKPOLISH],
			[4,:MUDSPORT],
			[6,:ROCKPOLISH],
			[10,:STEAMROLLER],
			[12,:MAGNITUDE],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:BULLDOZE],
			[24,:SELFDESTRUCT],
			[30,:STEALTHROCK],
			[34,:ROCKBLAST],
			[40,:EARTHQUAKE],
			[44,:EXPLOSION],
			[50,:DOUBLEEDGE],
			[54,:STONEEDGE],
			[60,:HEAVYSLAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:METRONOME,:MIMIC,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:POWERGEM,:POWERUPPUNCH,:RAGE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SEISMICTOSS,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:TAKEDOWN,:THUNDERPUNCH,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Mineral],
		:Height => 14,
		:Weight => 3000,
		:WildItemUncommon => :EVERSTONE,
		:kind => "Megaton",
		:dexentry => "It is said to live in volcanic craters on mountain peaks. Once a year, it sheds its hide and grows larger. The shed hide crumbles and returns to the soil.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type2 => :ELECTRIC,
		:Abilities => [:MAGNETPULL, :STURDY, :GALVANIZE],
		:preevo => {
			:species => :GRAVELER,
			:form => 1
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:DEFENSECURL],
			[4,:CHARGE],
			[1,:ROCKPOLISH],
			[1,:CHARGE],
			[6,:ROCKPOLISH],
			[10,:ROLLOUT],
			[12,:SPARK],
			[16,:ROCKTHROW],
			[18,:SMACKDOWN],
			[22,:THUNDERPUNCH],
			[24,:SELFDESTRUCT],
			[30,:STEALTHROCK],
			[34,:ROCKBLAST],
			[40,:DISCHARGE],
			[44,:EXPLOSION],
			[50,:DOUBLEEDGE],
			[54,:STONEEDGE],
		],
		:compatiblemoves => [:ALLYSWITCH,:BLOCK,:BODYPRESS,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DIG,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ELECTROWEB,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:MAGNETRISE,:MEGAPUNCH,:METEORBEAM,:NATUREPOWER,:POWERGEM,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:SUNNYDAY,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Height => 17,
		:Weight => 3160,
		:WildItemUncommon => :CELLBATTERY,
		:dexentry => "Because it can't fire boulders at a rapid pace, it's been known to seize nearby Geodude and fire them from its back.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Geodude.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:PONYTA => {
	"Normal Form" => {
		:name => "Ponyta",
		:dexnum => 77,
		:Type1 => :FIRE,
		:BaseStats => [50, 85, 55, 65, 65, 90],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:RUNAWAY, :FLASHFIRE],
		:HiddenAbilities => :FLAMEBODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 82,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ALLYSWITCH,:CAPTIVATE,:CHARM,:DOUBLEKICK,:DOUBLEEDGE,:FLAMEWHEEL,:HIGHHORSEPOWER,:HORNDRILL,:HYPNOSIS,:LOWKICK,:MORNINGSUN,:THRASH,],
		:Moveset => [
			[1,:GROWL],
			[1,:TACKLE],
			[4,:TAILWHIP],
			[9,:EMBER],
			[13,:FLAMEWHEEL],
			[17,:STOMP],
			[21,:FLAMECHARGE],
			[25,:FIRESPIN],
			[29,:TAKEDOWN],
			[33,:INFERNO],
			[37,:AGILITY],
			[41,:FIREBLAST],
			[45,:BOUNCE],
			[49,:FLAREBLITZ]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BIDE,:BODYSLAM,:BOUNCE,:CHARM,:CURSE,:DOUBLEEDGE,:ECHOEDVOICE,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:HEADBUTT,:HEATWAVE,:HIGHHORSEPOWER,:HORNDRILL,:HYPNOSIS,:INCINERATE,:IRONTAIL,:LOWKICK,:MIMIC,:MYSTICALFIRE,:OVERHEAT,:PLAYROUGH,:RAGE,:REFLECT,:SKULLBASH,:SOLARBEAM,:SOLARBLADE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:WILDCHARGE,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWSKY,:SHADOWDOWN,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 300,
		:kind => "Fire Horse",
		:dexentry => "A Ponyta is very weak at birth. It can barely stand up. Its legs become stronger as it stumbles and falls while trying to keep up with its parent.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RAPIDASH,:Level,40]
		]
	},

	"Galarian Form" => {
		:Type1 => :PSYCHIC,
		:Abilities => [:RUNAWAY, :PASTELVEIL, :ANTICIPATION],
		:Moveset => [
			[1,:GROWL],
			[1,:TACKLE],
			[5,:TAILWHIP],
			[10,:CONFUSION],
			[15,:FAIRYWIND],
			[20,:AGILITY],
			[25,:PSYBEAM],
			[30,:STOMP],
			[35,:HEALPULSE],
			[41,:TAKEDOWN],
			[45,:DAZZLINGGLEAM],
			[50,:PSYCHIC],
			[55,:HEALINGWISH],
		],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BODYSLAM,:BOUNCE,:CALMMIND,:CHARM,:DAZZLINGGLEAM,:EXPANDINGFORCE,:FUTURESIGHT,:HIGHHORSEPOWER,:HORNDRILL,:HYPNOSIS,:IMPRISON,:IRONTAIL,:LOWKICK,:MYSTICALFIRE,:PLAYROUGH,:PSYCHIC,:STOREDPOWER,:SWIFT,:WILDCHARGE,:ZENHEADBUTT,],
		:moveexceptions => [],
		:dexentry => "This Pokémon will look into your eyes and read the contents of your heart. If it finds evil there, it promptly hides away.",
	},

	:OnCreation => proc {
 # Map IDs for alt form
 if $game_map && Ponyta.include?($game_map.map_id) 
 next 1
 else
 next 0
 end
 },
},

:RAPIDASH => {
	"Normal Form" => {
		:name => "Rapidash",
		:dexnum => 78,
		:Type1 => :FIRE,
		:BaseStats => [65, 100, 70, 80, 80, 105],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:RUNAWAY, :FLASHFIRE],
		:HiddenAbilities => :FLAMEBODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PONYTA,
			:form => 0
		},
		:Moveset => [
			[0,:FURYATTACK],
			[1,:POISONJAB],
			[1,:MEGAHORN],
			[1,:GROWL],
			[1,:QUICKATTACK],
			[1,:EMBER],
			[1,:TAILWHIP],
			[4,:TAILWHIP],
			[9,:EMBER],
			[13,:FLAMEWHEEL],
			[17,:STOMP],
			[21,:FLAMECHARGE],
			[25,:FIRESPIN],
			[29,:TAKEDOWN],
			[33,:INFERNO],
			[37,:AGILITY],
			[41,:FIREBLAST],
			[45,:BOUNCE],
			[49,:FLAREBLITZ]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BATONPASS,:BIDE,:BODYSLAM,:BOUNCE,:CHARM,:CURSE,:DOUBLEEDGE,:DRILLRUN,:ECHOEDVOICE,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HIGHHORSEPOWER,:HORNDRILL,:HYPERBEAM,:HYPNOSIS,:INCINERATE,:IRONTAIL,:LOWKICK,:MEGAHORN,:MIMIC,:MYSTICALFIRE,:OVERHEAT,:PAYDAY,:PLAYROUGH,:POISONJAB,:RAGE,:REFLECT,:SCORCHINGSANDS,:SKULLBASH,:SMARTSTRIKE,:SOLARBEAM,:SOLARBLADE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THROATCHOP,:WILDCHARGE,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWSKY,:SHADOWDOWN,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 17,
		:Weight => 950,
		:kind => "Fire Horse",
		:dexentry => "It usually canters casually in the fields and plains. But once a Rapidash turns serious, its fiery manes flare and blaze as it gallops its way up to 150 mph.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:Abilities => [:RUNAWAY, :PASTELVEIL, :ANTICIPATION],
		:preevo => {
			:species => :PONYTA,
			:form => 1
		},
		:Moveset => [
			[0,:PSYCHOCUT],
			[1,:CONFUSION],
			[1,:MEGAHORN],
			[1,:GROWL],
			[1,:QUICKATTACK],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[15,:FAIRYWIND],
			[20,:AGILITY],
			[25,:PSYBEAM],
			[30,:STOMP],
			[35,:HEALPULSE],
			[43,:TAKEDOWN],
			[49,:DAZZLINGGLEAM],
			[56,:PSYCHIC],
			[63,:HEALINGWISH],
		],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BATONPASS,:BODYSLAM,:BOUNCE,:CALMMIND,:CHARM,:DAZZLINGGLEAM,:DRILLRUN,:EXPANDINGFORCE,:FUTURESIGHT,:GIGAIMPACT,:HIGHHORSEPOWER,:HORNDRILL,:HYPERBEAM,:HYPNOSIS,:IMPRISON,:IRONTAIL,:LOWKICK,:MAGICROOM,:MEGAHORN,:MISTYTERRAIN,:MYSTICALFIRE,:PAYDAY,:PLAYROUGH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:SMARTSTRIKE,:STOREDPOWER,:SWIFT,:SWORDSDANCE,:THROATCHOP,:TRICKROOM,:WILDCHARGE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:dexentry => "Brave and prideful, this Pokémon dashes airily through the forest, its steps aided by the psychic power stored in the fur on its fetlocks.",
	},

	:OnCreation => proc {
 # Map IDs for alt form
 if $game_map && Ponyta.include?($game_map.map_id) 
 next 1
 else
 next 0
 end
 },
},

:SLOWPOKE => {
	"Normal Form" => {
		:name => "Slowpoke",
		:dexnum => 79,
		:Type1 => :WATER,
		:Type2 => :PSYCHIC,
		:BaseStats => [90, 65, 65, 40, 40, 15],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :OWNTEMPO],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 63,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BELCH,:BELLYDRUM,:BLOCK,:FUTURESIGHT,:MEFIRST,:MUDSPORT,:SLEEPTALK,:SNORE,:STOMP,:WONDERROOM,:ZENHEADBUTT,],
		:Moveset => [
			[1,:CURSE],
			[1,:YAWN],
			[1,:TACKLE],
			[5,:GROWL],
			[9,:WATERGUN],
			[14,:CONFUSION],
			[19,:DISABLE],
			[23,:HEADBUTT],
			[28,:WATERPULSE],
			[32,:ZENHEADBUTT],
			[36,:SLACKOFF],
			[41,:AMNESIA],
			[45,:PSYCHIC],
			[49,:RAINDANCE],
			[54,:PSYCHUP],
			[58,:HEALPULSE]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:AQUATAIL,:BIDE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRINE,:BUBBLEBEAM,:BULLDOZE,:CALMMIND,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DREAMEATER,:EARTHQUAKE,:ECHOEDVOICE,:EXPANDINGFORCE,:FIREBLAST,:FISSURE,:FLAMETHROWER,:FLASH,:FUTURESIGHT,:GRASSKNOT,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IMPRISON,:INCINERATE,:IRONTAIL,:LIGHTSCREEN,:LIQUIDATION,:MAGICCOAT,:MIMIC,:MUDSHOT,:MUDSLAP,:NIGHTMARE,:PAYDAY,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 12,
		:Weight => 360,
		:WildItemUncommon => :LAGGINGTAIL,
		:kind => "Dopey",
		:dexentry => "It catches prey by dipping its tail in water at the side of a river. But it often forgets what its doing and spends days loafing at water's edge.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SLOWBRO,:Level,37],
			[:SLOWKING,:TradeItem,:KINGSROCK]
		]
	},

	"Galarian Form" => {
		:dexentry => "Although this Pokémon is normally zoned out, its expression abruptly sharpens on occasion. The cause for this seems to lie in Slowpoke’s diet.",
		:Type1 => :PSYCHIC,
		:Abilities => [:GLUTTONY, :OWNTEMPO, :REGENERATOR],
		:Moveset => [
		[1,:TACKLE],
		[1,:CURSE],
		[3,:GROWL],
		[6,:ACID],
		[9,:YAWN],
		[12,:CONFUSION],
		[15,:DISABLE],
		[18,:WATERPULSE],
		[21,:HEADBUTT],
		[24,:ZENHEADBUTT],
		[27,:AMNESIA],
		[30,:SURF],
		[33,:SLACKOFF],
		[36,:PSYCHIC],
		[39,:PSYCHUP],
		[42,:RAINDANCE],
		[45,:HEALPULSE]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:BATONPASS,:BODYSLAM,:BOUNCE,:CALMMIND,:CHARM,:DAZZLINGGLEAM,:DRILLRUN,:EXPANDINGFORCE,:FUTURESIGHT,:GIGAIMPACT,:HIGHHORSEPOWER,:HORNDRILL,:HYPERBEAM,:HYPNOSIS,:IMPRISON,:IRONTAIL,:LOWKICK,:MAGICROOM,:MEGAHORN,:MISTYTERRAIN,:MYSTICALFIRE,:PAYDAY,:PLAYROUGH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:SMARTSTRIKE,:STOREDPOWER,:SWIFT,:SWORDSDANCE,:THROATCHOP,:TRICKROOM,:WILDCHARGE,:WONDERROOM,:ZENHEADBUTT],
		:moveexceptions => [],
		:evolutions => [[:SLOWBRO,:Item,:GALARICACUFF],[:SLOWKING,:Item,:GALARICAWREATH]]	
	},

	:OnCreation => {},
},

:SLOWBRO => {
	"Normal Form" => {
		:name => "Slowbro",
		:dexnum => 80,
		:Type1 => :WATER,
		:Type2 => :PSYCHIC,
		:BaseStats => [95, 75, 110, 100, 80, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :OWNTEMPO],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 172,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SLOWPOKE,
			:form => 0
		},
		:Moveset => [
			[0,:WITHDRAW],
			[1,:HEALPULSE],
			[1,:CURSE],
			[1,:YAWN],
			[1,:TACKLE],
			[1,:GROWL],
			[5,:GROWL],
			[9,:WATERGUN],
			[14,:CONFUSION],
			[19,:DISABLE],
			[23,:HEADBUTT],
			[28,:WATERPULSE],
			[32,:ZENHEADBUTT],
			[36,:SLACKOFF],
			[43,:AMNESIA],
			[49,:PSYCHIC],
			[55,:RAINDANCE],
			[62,:PSYCHUP],
			[68,:HEALPULSE]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AMNESIA,:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:BULLDOZE,:CALMMIND,:COUNTER,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:EXPANDINGFORCE,:FIREBLAST,:FISSURE,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:INCINERATE,:IRONDEFENSE,:IRONTAIL,:LIGHTSCREEN,:LIQUIDATION,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYDAY,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RAZORSHELL,:RECYCLE,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 16,
		:Weight => 785,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Hermit Crab",
		:dexentry => "Its tail has a Shellder firmly attached with a bite. As a result, the tail can't be used for fishing anymore. This forces it to reluctantly swim and catch prey.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :POISON,
		:Type2 => :PSYCHIC,
		:BaseStats => [95, 100, 95, 100, 70, 30],
		:Abilities => [:QUICKDRAW, :OWNTEMPO, :REGENERATOR],
		:preevo => {
			:species => :SLOWPOKE,
			:form => 1
		},
		:Moveset => [
			[0,:SHELLSIDEARM],
			[1,:WITHDRAW],
			[1,:TACKLE],
			[1,:CURSE],
			[1,:GROWL],
			[1,:ACID],
			[9,:YAWN],
			[12,:CONFUSION],
			[15,:DISABLE],
			[18,:WATERPULSE],
			[21,:HEADBUTT],
			[24,:ZENHEADBUTT],
			[27,:AMNESIA],
			[30,:SURF],
			[33,:SLACKOFF],
			[36,:PSYCHIC],
			[39,:PSYCHUP],
			[42,:RAINDANCE],
			[45,:HEALPULSE],
		],
		:compatiblemoves => [:AMNESIA,:BLIZZARD,:BLOCK,:BODYSLAM,:BRINE,:BULLDOZE,:CALMMIND,:DIG,:DIVE,:EARTHQUAKE,:EXPANDINGFORCE,:FIREBLAST,:FLAMETHROWER,:FOULPLAY,:FUTURESIGHT,:GRASSKNOT,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IMPRISON,:IRONTAIL,:LIGHTSCREEN,:LIQUIDATION,:MUDSHOT,:PAYDAY,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:SAFEGUARD,:SCALD,:SHADOWBALL,:SKILLSWAP,:STOREDPOWER,:SUNNYDAY,:SURF,:SWIFT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Weight => 705,
		:dexentry => "A Shellder bite set off a chemical reaction with the spices inside Slowbro’s body, causing Slowbro to become a Poison-type Pokémon.",
	},

	"Mega Form" => {
		:BaseStats => [95, 75, 180, 130, 80, 30],
		:Abilities => [:SHELLARMOR],
		:Height => 20,
		:Weight => 1200,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SLOWBRONITE => 2,
	},
},

:MAGNEMITE => {
	"Normal Form" => {
		:name => "Magnemite",
		:dexnum => 81,
		:Type1 => :ELECTRIC,
		:Type2 => :STEEL,
		:BaseStats => [25, 35, 70, 95, 55, 45],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:MAGNETPULL, :STURDY],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 89,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:TACKLE],
			[1,:SUPERSONIC],
			[5,:THUNDERSHOCK],
			[7,:THUNDERWAVE],
			[11,:MAGNETBOMB],
			[13,:LIGHTSCREEN],
			[17,:SONICBOOM],
			[19,:SPARK],
			[23,:MIRRORSHOT],
			[25,:METALSOUND],
			[29,:ELECTROBALL],
			[31,:FLASHCANNON],
			[35,:SCREECH],
			[37,:DISCHARGE],
			[41,:LOCKON],
			[43,:MAGNETRISE],
			[47,:GYROBALL],
			[49,:ZAPCANNON]],
		:compatiblemoves => [:BIDE,:CHARGEBEAM,:CURSE,:DOUBLEEDGE,:ELECTROBALL,:ELECTROWEB,:EXPLOSION,:FLASH,:FLASHCANNON,:GRAVITY,:GYROBALL,:HEADBUTT,:IRONDEFENSE,:LIGHTSCREEN,:MAGICCOAT,:MAGNETRISE,:MIMIC,:PSYCHUP,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SHOCKWAVE,:SIGNALBEAM,:STEELBEAM,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 3,
		:Weight => 60,
		:WildItemUncommon => :METALCOAT,
		:kind => "Magnet",
		:dexentry => "The units at its sides are extremely powerful magnets. They generate enough magnetism to draw in iron objects from over 300 feet away.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 29,
		:BattlerAltitude => 19,
		:evolutions => [
			[:MAGNETON,:Level,30]
		]
	},

	:OnCreation => {},
},

:MAGNETON => {
	"Normal Form" => {
		:name => "Magneton",
		:dexnum => 82,
		:Type1 => :ELECTRIC,
		:Type2 => :STEEL,
		:BaseStats => [50, 60, 95, 120, 70, 70],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:MAGNETPULL, :STURDY],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 163,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MAGNEMITE,
			:form => 0
		},
		:Moveset => [
			[0,:TRIATTACK],
			[1,:ZAPCANNON],
			[1,:ELECTRICTERRAIN],
			[1,:TACKLE],
			[1,:SUPERSONIC],
			[1,:THUNDERSHOCK],
			[1,:MAGNETBOMB],
			[5,:THUNDERSHOCK],
			[7,:THUNDERWAVE],
			[11,:MAGNETBOMB],
			[13,:LIGHTSCREEN],
			[17,:SONICBOOM],
			[19,:SPARK],
			[23,:MIRRORSHOT],
			[25,:METALSOUND],
			[29,:ELECTROBALL],
			[33,:FLASHCANNON],
			[39,:SCREECH],
			[43,:DISCHARGE],
			[49,:LOCKON],
			[53,:MAGNETRISE],
			[59,:GYROBALL],
			[63,:ZAPCANNON]],
		:compatiblemoves => [:BIDE,:CHARGEBEAM,:CURSE,:DOUBLEEDGE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:EXPLOSION,:FLASH,:FLASHCANNON,:GIGAIMPACT,:GRAVITY,:GYROBALL,:HEADBUTT,:HYPERBEAM,:IRONDEFENSE,:LIGHTSCREEN,:MAGICCOAT,:MAGNETRISE,:MIMIC,:PSYCHUP,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SHOCKWAVE,:SIGNALBEAM,:STEELBEAM,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWHOLD,:SHADOWRAVE,:SHADOWSKY,],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 10,
		:Weight => 600,
		:WildItemUncommon => :METALCOAT,
		:kind => "Magnet",
		:dexentry => "It is actually three Magnemite linked by magnetism. It generates powerful radio waves that raise temperatures by 3.6 degrees F within a 3,300-foot radius.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 15,
		:evolutions => [
			[:MAGNEZONE,:Location,0]
		]
	},

	:OnCreation => {},
},

:FARFETCHD => {
	"Normal Form" => {
		:name => "Farfetch'd",
		:dexnum => 83,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [52, 90, 55, 58, 62, 60],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:KEENEYE, :INNERFOCUS],
		:HiddenAbilities => :DEFIANT,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 132,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:COVET,:CURSE,:FEATHERDANCE,:FIRSTIMPRESSION,:FINALGAMBIT,:FLAIL,:FORESIGHT,:GUST,:LEAFBLADE,:MIRRORMOVE,:MUDSLAP,:NIGHTSLASH,:QUICKATTACK,:REVENGE,:ROOST,:SIMPLEBEAM,:STEELWING,:TRUMPCARD,],
		:Moveset => [
			[1,:BRAVEBIRD],
			[1,:POISONJAB],
			[1,:PECK],
			[1,:SANDATTACK],
			[1,:LEER],
			[1,:FURYCUTTER],
			[7,:FURYATTACK],
			[9,:AERIALACE],
			[13,:KNOCKOFF],
			[19,:SLASH],
			[21,:AIRCUTTER],
			[25,:SWORDSDANCE],
			[31,:AGILITY],
			[33,:NIGHTSLASH],
			[37,:ACROBATICS],
			[43,:FEINT],
			[45,:FALSESWIPE],
			[49,:AIRSLASH],
			[55,:BRAVEBIRD]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BATONPASS,:BIDE,:BODYSLAM,:BRAVEBIRD,:BRUTALSWING,:CLOSECOMBAT,:COVET,:CURSE,:CUT,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FALSESWIPE,:FLY,:FOCUSENERGY,:FURYCUTTER,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LEAFBLADE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:POISONJAB,:PSYCHUP,:RAGE,:RAZORWIND,:REFLECT,:RETALIATE,:REVENGE,:ROOST,:SKULLBASH,:SKYATTACK,:SOLARBLADE,:STEELWING,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAKEDOWN,:THIEF,:THROATCHOP,:TWISTER,:UPROAR,:UTURN,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBREAK,:SHADOWSKY,:SHADOWPANIC,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Flying, :Field],
		:Height => 8,
		:Weight => 150,
		:WildItemUncommon => :STICK,
		:kind => "Wild Duck",
		:dexentry => "It is always seen with a stick from a plant. Apparently, there are good sticks and bad sticks. This Pokémon occasionally fights over choice sticks.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :FIGHTING,
		:BaseStats => [52, 95, 55, 58, 62, 55],
		:Abilities => [:STEADFAST, :SCRAPPY],
		:Moveset => [
			[1,:PECK],
			[1,:SANDATTACK],
			[5,:LEER],
			[10,:FURYCUTTER],
			[15,:ROCKSMASH],
			[20,:BRUTALSWING],
			[25,:DETECT],
			[30,:KNOCKOFF],
			[35,:DEFOG],
			[40,:BRICKBREAK],
			[45,:SWORDSDANCE],
			[50,:SLAM],
			[55,:LEAFBLADE],
			[60,:FINALGAMBIT],
			[65,:BRAVEBIRD],
		],
		:compatiblemoves => [:ASSURANCE,:BODYSLAM,:BRAVEBIRD,:BRICKBREAK,:BRUTALSWING,:CLOSECOMBAT,:COUNTER,:COVET,:DEFOG,:DETECT,:DUALWINGBEAT,:FOCUSENERGY,:FURYCUTTER,:HELPINGHAND,:KNOCKOFF,:LEAFBLADE,:POISONJAB,:RETALIATE,:REVENGE,:ROCKSMASH,:SKYATTACK,:SOLARBLADE,:STEELWING,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:THROATCHOP,:WORKUP,],
		:moveexceptions => [],
		:dexentry => "The Farfetch’d of the Galar region are brave warriors, and they wield thick, tough leeks in battle.",
		:evolutions => [
			[:SIRFETCHD,:LandCritical,3]
		]
	},

	:OnCreation => proc {
 # Map IDs for alt form
 if $game_map && Farfetchd.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:DODUO => {
	"Normal Form" => {
		:name => "Doduo",
		:dexnum => 84,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [35, 85, 45, 35, 35, 75],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:RUNAWAY, :EARLYBIRD],
		:HiddenAbilities => :TANGLEDFEET,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 62,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASSURANCE,:BRAVEBIRD,:ENDEAVOR,:FEINTATTACK,:FLAIL,:HAZE,:MIRRORMOVE,:NATURALGIFT,:QUICKATTACK,:SUPERSONIC,],
		:Moveset => [
			[1,:PECK],
			[1,:GROWL],
			[5,:QUICKATTACK],
			[8,:RAGE],
			[12,:FURYATTACK],
			[15,:PURSUIT],
			[19,:PLUCK],
			[22,:DOUBLEHIT],
			[26,:AGILITY],
			[29,:UPROAR],
			[33,:ACUPRESSURE],
			[36,:SWORDSDANCE],
			[40,:JUMPKICK],
			[43,:DRILLPECK],
			[47,:ENDEAVOR],
			[50,:THRASH]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:ASSURANCE,:BIDE,:BODYSLAM,:BRAVEBIRD,:CURSE,:DOUBLEEDGE,:ECHOEDVOICE,:ENDEAVOR,:FEINTATTACK,:FLY,:HEADBUTT,:KNOCKOFF,:MEGAKICK,:MIMIC,:MUDSLAP,:PLUCK,:RAGE,:REFLECT,:ROOST,:SKULLBASH,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:TRIATTACK,:UPROAR,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Flying],
		:Height => 14,
		:Weight => 392,
		:WildItemUncommon => :SHARPBEAK,
		:kind => "Twin Bird",
		:dexentry => "Even while eating or sleeping, one of the heads remains always vigilant for any sign of danger. When threatened, it flees at over 60 miles per hour.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DODRIO,:Level,31]
		]
	},

	:OnCreation => {},
},

:DODRIO => {
	"Normal Form" => {
		:name => "Dodrio",
		:dexnum => 85,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [60, 110, 70, 60, 60, 110],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:RUNAWAY, :EARLYBIRD],
		:HiddenAbilities => :TANGLEDFEET,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 165,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :DODUO,
			:form => 0
		},
		:Moveset => [
			[0,:TRIATTACK],
			[1,:PECK],
			[1,:GROWL],
			[1,:QUICKATTACK],
			[1,:RAGE],
			[5,:QUICKATTACK],
			[8,:RAGE],
			[12,:FURYATTACK],
			[15,:PURSUIT],
			[19,:PLUCK],
			[22,:DOUBLEHIT],
			[26,:AGILITY],
			[29,:UPROAR],
			[34,:ACUPRESSURE],
			[38,:SWORDSDANCE],
			[43,:JUMPKICK],
			[47,:DRILLPECK],
			[52,:ENDEAVOR],
			[56,:THRASH]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BATONPASS,:BEATUP,:BIDE,:BLAZEKICK,:BODYSLAM,:BRAVEBIRD,:CURSE,:DOUBLEEDGE,:ECHOEDVOICE,:ENDEAVOR,:FEINTATTACK,:FLY,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:KNOCKOFF,:LASHOUT,:MEGAKICK,:MIMIC,:MUDSLAP,:PAYBACK,:PLUCK,:RAGE,:REFLECT,:REVENGE,:ROOST,:SKULLBASH,:SKYATTACK,:STEELWING,:STOMPINGTANTRUM,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:TAUNT,:THIEF,:TORMENT,:TRIATTACK,:UPROAR,:WHIRLWIND,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Flying],
		:Height => 18,
		:Weight => 852,
		:WildItemUncommon => :SHARPBEAK,
		:kind => "Triple Bird",
		:dexentry => "A peculiar Pokémon species with three heads. It vigorously races across grassy plains even in arid seasons with little rainfall.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SEEL => {
	"Normal Form" => {
		:name => "Seel",
		:dexnum => 86,
		:Type1 => :WATER,
		:BaseStats => [65, 45, 55, 45, 70, 45],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:THICKFAT, :HYDRATION],
		:HiddenAbilities => :ICEBODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 65,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BELCH,:DISABLE,:ENCORE,:ENTRAINMENT,:FAKEOUT,:HORNDRILL,:ICICLESPEAR,:IRONTAIL,:LICK,:PERISHSONG,:SIGNALBEAM,:SLAM,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WATERPULSE,],
		:Moveset => [
			[1,:HEADBUTT],
			[3,:GROWL],
			[7,:WATERSPORT],
			[11,:ICYWIND],
			[13,:ENCORE],
			[17,:ICESHARD],
			[21,:REST],
			[23,:AQUARING],
			[27,:AURORABEAM],
			[31,:AQUAJET],
			[33,:BRINE],
			[37,:TAKEDOWN],
			[41,:DIVE],
			[43,:AQUATAIL],
			[47,:ICEBEAM],
			[51,:SAFEGUARD],
			[53,:HAIL]],
		:compatiblemoves => [:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRILLRUN,:ECHOEDVOICE,:ENCORE,:FAKEOUT,:FLING,:FLIPTURN,:HAIL,:HEADBUTT,:HELPINGHAND,:HORNDRILL,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:MEGAHORN,:MIMIC,:MUDDYWATER,:PAYDAY,:RAGE,:RAINDANCE,:SAFEGUARD,:SIGNALBEAM,:SKULLBASH,:SMARTSTRIKE,:STRENGTH,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWMIST,],
		:Color => "White",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Field],
		:Height => 11,
		:Weight => 900,
		:kind => "Sea Lion",
		:dexentry => "Seel hunt for prey in frigid, ice-covered seas. When it needs to breathe, it punches a hole through the ice with the sharply protruding section of its head.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DEWGONG,:Level,34]
		]
	},

	:OnCreation => {},
},

:DEWGONG => {
	"Normal Form" => {
		:name => "Dewgong",
		:dexnum => 87,
		:Type1 => :WATER,
		:Type2 => :ICE,
		:BaseStats => [90, 70, 80, 70, 95, 70],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:THICKFAT, :HYDRATION],
		:HiddenAbilities => :ICEBODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 166,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SEEL,
			:form => 0
		},
		:Moveset => [
			[0,:SHEERCOLD],
			[1,:HEADBUTT],
			[1,:GROWL],
			[1,:SIGNALBEAM],
			[1,:ICYWIND],
			[3,:GROWL],
			[7,:SIGNALBEAM],
			[11,:ICYWIND],
			[13,:ENCORE],
			[17,:ICESHARD],
			[21,:REST],
			[23,:AQUARING],
			[27,:AURORABEAM],
			[31,:AQUAJET],
			[33,:BRINE],
			[39,:TAKEDOWN],
			[45,:DIVE],
			[49,:AQUATAIL],
			[55,:ICEBEAM],
			[61,:SAFEGUARD],
			[65,:HAIL]],
		:compatiblemoves => [:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRILLRUN,:ECHOEDVOICE,:ENCORE,:FAKEOUT,:FLING,:FLIPTURN,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HELPINGHAND,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:LIQUIDATION,:MEGAHORN,:MIMIC,:MUDDYWATER,:PAYDAY,:RAGE,:RAINDANCE,:RAZORSHELL,:SAFEGUARD,:SIGNALBEAM,:SKULLBASH,:SMARTSTRIKE,:STRENGTH,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Field],
		:Height => 17,
		:Weight => 1200,
		:kind => "Sea Lion",
		:dexentry => "It loves to snooze on bitterly cold ice. The sight of this Pokémon sleeping on a glacier was mistakenly thought to be a mermaid by a mariner long ago.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GRIMER => {
	"Normal Form" => {
		:name => "Grimer",
		:dexnum => 88,
		:Type1 => :POISON,
		:BaseStats => [80, 80, 50, 40, 50, 25],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:STENCH, :STICKYHOLD],
		:HiddenAbilities => :POISONTOUCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 65,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDSPRAY,:CURSE,:HAZE,:IMPRISON,:LICK,:MEANLOOK,:POWERUPPUNCH,:SCARYFACE,:SHADOWPUNCH,:SHADOWSNEAK,:SPITUP,:STOCKPILE,:SWALLOW,],
		:Moveset => [
			[1,:POUND],
			[1,:POISONGAS],
			[4,:HARDEN],
			[7,:MUDSLAP],
			[12,:DISABLE],
			[15,:SLUDGE],
			[18,:MUDBOMB],
			[21,:MINIMIZE],
			[26,:FLING],
			[29,:SLUDGEBOMB],
			[32,:SLUDGEWAVE],
			[37,:SCREECH],
			[40,:GUNKSHOT],
			[43,:ACIDARMOR],
			[46,:BELCH],
			[48,:MEMENTO]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:CURSE,:DIG,:DYNAMICPUNCH,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:GIGADRAIN,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:IMPRISON,:INCINERATE,:INFESTATION,:MEGADRAIN,:MIMIC,:MUDSLAP,:PAINSPLIT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:ROCKSLIDE,:ROCKTOMB,:SCARYFACE,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:STRENGTH,:SUNNYDAY,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:VENOSHOCK,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWRUSH,],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 9,
		:Weight => 300,
		:WildItemUncommon => :BLACKSLUDGE,
		:kind => "Sludge",
		:dexentry => "Born from polluted sludge in the sea, Grimer's favorite food is anything filthy. They feed on wastewater pumped out from factories.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MUK,:Level,38]
		]
	},

	"Alolan Form" => {
		:Type2 => :DARK,
		:Abilities => [:POISONTOUCH, :GLUTTONY, :POWEROFALCHEMY],
		:EggMoves => [:ASSURANCE,:CLEARSMOG,:CURSE,:IMPRISON,:MEANLOOK,:POWERUPPUNCH,:PURSUIT,:SCARYFACE,:SHADOWSNEAK,:SPITE,:SPITUP,:STOCKPILE,:SWALLOW,],
		:Moveset => [
			[1,:POUND],
			[1,:POISONGAS],
			[4,:HARDEN],
			[7,:BITE],
			[12,:DISABLE],
			[15,:ACIDSPRAY],
			[18,:POISONFANG],
			[21,:MINIMIZE],
			[26,:FLING],
			[29,:KNOCKOFF],
			[32,:CRUNCH],
			[37,:SCREECH],
			[40,:GUNKSHOT],
			[43,:ACIDARMOR],
			[46,:BELCH],
			[48,:MEMENTO],
		],
		:compatiblemoves => [:ASSURANCE,:BRUTALSWING,:CRUNCH,:DIG,:EMBARGO,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:GASTROACID,:GIGADRAIN,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:IMPRISON,:INFESTATION,:KNOCKOFF,:MEGADRAIN,:PAINSPLIT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:QUASH,:RAINDANCE,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:SCARYFACE,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SNARL,:SPITE,:STONEEDGE,:SUNNYDAY,:TAUNT,:THIEF,:THUNDERPUNCH,:TORMENT,:VENOSHOCK,],
		:moveexceptions => [],
		:Height => 7,
		:Weight => 420,
		:dexentry => "The crystals on Grimer's body are lumps of toxins. If one falls off, lethal poisons leak out.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Grimer.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:MUK => {
	"Normal Form" => {
		:name => "Muk",
		:dexnum => 89,
		:Type1 => :POISON,
		:BaseStats => [105, 105, 75, 65, 100, 50],
		:EVs => [1, 1, 0, 0, 0, 0],
		:Abilities => [:STENCH, :STICKYHOLD],
		:HiddenAbilities => :POISONTOUCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GRIMER,
			:form => 0
		},
		:Moveset => [
			[0,:VENOMDRENCH],
			[1,:POISONGAS],
			[1,:POUND],
			[1,:HARDEN],
			[1,:MUDSLAP],
			[4,:HARDEN],
			[7,:MUDSLAP],
			[12,:DISABLE],
			[15,:SLUDGE],
			[18,:MUDBOMB],
			[21,:MINIMIZE],
			[26,:FLING],
			[29,:SLUDGEBOMB],
			[32,:SLUDGEWAVE],
			[37,:SCREECH],
			[40,:GUNKSHOT],
			[46,:ACIDARMOR],
			[52,:BELCH],
			[57,:MEMENTO]],
		:compatiblemoves => [:BIDE,:BLOCK,:BODYSLAM,:BRICKBREAK,:CORROSIVEGAS,:CURSE,:DARKPULSE,:DIG,:DYNAMICPUNCH,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGADRAIN,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HEX,:HYPERBEAM,:ICEPUNCH,:IMPRISON,:INCINERATE,:INFESTATION,:MEGADRAIN,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PAINSPLIT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:STRENGTH,:SUNNYDAY,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:VENOMDRENCH,:VENOSHOCK,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 12,
		:Weight => 300,
		:WildItemUncommon => :BLACKSLUDGE,
		:kind => "Sludge",
		:dexentry => "It prefers warm and humid habitats. In the summertime, the toxic substances in its body intensify, making Muk reek like putrid kitchen garbage.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type2 => :DARK,
		:Abilities => [:POISONTOUCH, :GLUTTONY, :POWEROFALCHEMY],
		:preevo => {
			:species => :GRIMER,
			:form => 1
		},
		:Moveset => [
			[0,:VENOMDRENCH],
			[1,:POUND],
			[1,:POISONGAS],
			[1,:HARDEN],
			[4,:HARDEN],
			[7,:BITE],
			[12,:DISABLE],
			[15,:ACIDSPRAY],
			[18,:POISONFANG],
			[21,:MINIMIZE],
			[26,:FLING],
			[29,:KNOCKOFF],
			[32,:CRUNCH],
			[37,:SCREECH],
			[40,:GUNKSHOT],
			[46,:ACIDARMOR],
			[52,:BELCH],
			[57,:MEMENTO],
		],
		:compatiblemoves => [:ASSURANCE,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:CORROSIVEGAS,:CRUNCH,:DARKPULSE,:DIG,:EMBARGO,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HEX,:HYPERBEAM,:ICEPUNCH,:IMPRISON,:INFESTATION,:KNOCKOFF,:MEGADRAIN,:MEGAPUNCH,:PAINSPLIT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:QUASH,:RAINDANCE,:RECYCLE,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:SCARYFACE,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SNARL,:SPITE,:STONEEDGE,:SUNNYDAY,:TAUNT,:THIEF,:THUNDERPUNCH,:TORMENT,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:Height => 10,
		:Weight => 520,
		:dexentry => "While it's unexpectedly quiet and friendly, if it's not fed any trash for a while, it will smash its Trainer's furnishings and eat up the fragments.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Grimer.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:SHELLDER => {
	"Normal Form" => {
		:name => "Shellder",
		:dexnum => 90,
		:Type1 => :WATER,
		:BaseStats => [30, 65, 100, 45, 25, 40],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SHELLARMOR, :SKILLLINK],
		:HiddenAbilities => :OVERCOAT,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 61,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUARING,:AVALANCHE,:BARRIER,:BUBBLEBEAM,:ICICLESPEAR,:MUDSHOT,:RAPIDSPIN,:ROCKBLAST,:SCREECH,:TAKEDOWN,:TWINEEDLE,:WATERPULSE,],
		:Moveset => [
			[1,:TACKLE],
			[1,:WATERGUN],
			[4,:WITHDRAW],
			[8,:SUPERSONIC],
			[13,:ICICLESPEAR],
			[16,:PROTECT],
			[20,:LEER],
			[25,:CLAMP],
			[28,:ICESHARD],
			[32,:RAZORSHELL],
			[37,:AURORABEAM],
			[40,:WHIRLPOOL],
			[44,:BRINE],
			[49,:IRONDEFENSE],
			[52,:ICEBEAM],
			[56,:SHELLSMASH],
			[61,:HYDROPUMP]],
		:compatiblemoves => [:AVALANCHE,:BIDE,:BLIZZARD,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:EXPLOSION,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:LIQUIDATION,:MIMIC,:MUDSHOT,:PAYBACK,:RAGE,:RAINDANCE,:RAZORSHELL,:REFLECT,:ROCKBLAST,:SCREECH,:SELFDESTRUCT,:SURF,:SWIFT,:TAKEDOWN,:TELEPORT,:TRIATTACK,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Purple",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 3,
		:Weight => 40,
		:WildItemCommon => :PEARL,
		:WildItemUncommon => :BIGPEARL,
		:kind => "Bivalve",
		:dexentry => "At night, it burrows a hole in the seafloor with its broad tongue to make a place to sleep. While asleep, it closes its shell, but leaves its tongue hanging out.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CLOYSTER,:Item,:WATERSTONE]
		]
	},

	:OnCreation => {},
},

:CLOYSTER => {
	"Normal Form" => {
		:name => "Cloyster",
		:dexnum => 91,
		:Type1 => :WATER,
		:Type2 => :ICE,
		:BaseStats => [50, 95, 180, 85, 45, 70],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SHELLARMOR, :SKILLLINK],
		:HiddenAbilities => :OVERCOAT,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 184,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SHELLDER,
			:form => 0
		},
		:Moveset => [
			[1,:HYDROPUMP],
			[1,:SHELLSMASH],
			[1,:TOXICSPIKES],
			[1,:WITHDRAW],
			[1,:SUPERSONIC],
			[1,:PROTECT],
			[1,:AURORABEAM],
			[13,:SPIKECANNON],
			[28,:SPIKES],
			[50,:ICICLECRASH]],
		:compatiblemoves => [:AVALANCHE,:BIDE,:BLIZZARD,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:EXPLOSION,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:LIGHTSCREEN,:LIQUIDATION,:MIMIC,:MUDSHOT,:PAYBACK,:PINMISSILE,:POISONJAB,:RAGE,:RAINDANCE,:RAZORSHELL,:REFLECT,:ROCKBLAST,:SCREECH,:SELFDESTRUCT,:SIGNALBEAM,:SMARTSTRIKE,:SPIKES,:STEELROLLER,:SURF,:SWIFT,:TAKEDOWN,:TELEPORT,:TORMENT,:TOXICSPIKES,:TRIATTACK,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 15,
		:Weight => 1325,
		:WildItemCommon => :PEARL,
		:WildItemUncommon => :BIGPEARL,
		:kind => "Bivalve",
		:dexentry => "It swims in the sea by swallowing water, then jetting it out toward the rear. The Cloyster shoots spikes from its shell using the same system.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GASTLY => {
	"Normal Form" => {
		:name => "Gastly",
		:dexnum => 92,
		:Type1 => :GHOST,
		:Type2 => :POISON,
		:BaseStats => [30, 35, 30, 100, 35, 80],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 62,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASTONISH,:CLEARSMOG,:DISABLE,:FIREPUNCH,:GRUDGE,:HAZE,:ICEPUNCH,:PERISHSONG,:PSYWAVE,:REFLECTTYPE,:SCARYFACE,:SMOG,:THUNDERPUNCH,],
		:Moveset => [
			[1,:HYPNOSIS],
			[1,:LICK],
			[5,:SPITE],
			[8,:MEANLOOK],
			[12,:CURSE],
			[15,:NIGHTSHADE],
			[19,:CONFUSERAY],
			[22,:SUCKERPUNCH],
			[26,:PAYBACK],
			[29,:SHADOWBALL],
			[33,:DREAMEATER],
			[36,:DARKPULSE],
			[40,:DESTINYBOND],
			[43,:HEX],
			[47,:NIGHTMARE]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:CORROSIVEGAS,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DREAMEATER,:EMBARGO,:ENERGYBALL,:EXPLOSION,:FIREPUNCH,:FOULPLAY,:GIGADRAIN,:HEADBUTT,:HEX,:HYPNOSIS,:ICEPUNCH,:ICYWIND,:INFESTATION,:KNOCKOFF,:MEGADRAIN,:MIMIC,:NIGHTMARE,:NIGHTSHADE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POISONJAB,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:SCARYFACE,:SELFDESTRUCT,:SHADOWBALL,:SKILLSWAP,:SKITTERSMACK,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:VENOSHOCK,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Amorphous],
		:Height => 13,
		:Weight => 1,
		:kind => "Gas",
		:dexentry => "When exposed to a strong wind, a Gastly's gaseous body quickly dwindles away. They cluster under the eaves of houses to escape the ravages of wind.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 13,
		:evolutions => [
			[:HAUNTER,:Level,25]
		]
	},

	:OnCreation => {},
},

:HAUNTER => {
	"Normal Form" => {
		:name => "Haunter",
		:dexnum => 93,
		:Type1 => :GHOST,
		:Type2 => :POISON,
		:BaseStats => [45, 50, 45, 115, 55, 95],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GASTLY,
			:form => 0
		},
		:Moveset => [
			[0,:SHADOWPUNCH],
			[1,:HYPNOSIS],
			[1,:LICK],
			[1,:SPITE],
			[5,:SPITE],
			[8,:MEANLOOK],
			[12,:CURSE],
			[15,:NIGHTSHADE],
			[19,:CONFUSERAY],
			[22,:SUCKERPUNCH],
			[28,:PAYBACK],
			[33,:SHADOWBALL],
			[39,:DREAMEATER],
			[44,:DARKPULSE],
			[50,:DESTINYBOND],
			[55,:HEX],
			[61,:NIGHTMARE]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:CORROSIVEGAS,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DREAMEATER,:EMBARGO,:ENCORE,:ENERGYBALL,:EXPLOSION,:FIREPUNCH,:FLING,:FOULPLAY,:GIGADRAIN,:HEADBUTT,:HEX,:HYPNOSIS,:ICEPUNCH,:ICYWIND,:INFESTATION,:KNOCKOFF,:MEGADRAIN,:MIMIC,:NIGHTMARE,:NIGHTSHADE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POISONJAB,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:SCARYFACE,:SELFDESTRUCT,:SHADOWBALL,:SHADOWCLAW,:SKILLSWAP,:SKITTERSMACK,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:VENOSHOCK,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Amorphous],
		:Height => 16,
		:Weight => 1,
		:kind => "Gas",
		:dexentry => "If a Haunter beckons you while it is floating in darkness, don't approach it. This Pokémon will try to lick you with its tongue and steal your life away.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 14,
		:evolutions => [
			[:GENGAR,:Trade,0]
		]
	},

	:OnCreation => {},
},

:GENGAR => {
	"Normal Form" => {
		:name => "Gengar",
		:dexnum => 94,
		:Type1 => :GHOST,
		:Type2 => :POISON,
		:BaseStats => [60, 65, 60, 130, 75, 110],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:CURSEDBODY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 225,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :HAUNTER,
			:form => 0
		},
		:Moveset => [
			[0,:SHADOWPUNCH],
			[1,:HYPNOSIS],
			[1,:LICK],
			[1,:SPITE],
			[5,:SPITE],
			[8,:MEANLOOK],
			[12,:CURSE],
			[15,:NIGHTSHADE],
			[19,:CONFUSERAY],
			[22,:SUCKERPUNCH],
			[28,:PAYBACK],
			[33,:SHADOWBALL],
			[39,:DREAMEATER],
			[44,:DARKPULSE],
			[50,:DESTINYBOND],
			[55,:HEX],
			[61,:NIGHTMARE]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYSLAM,:BRICKBREAK,:CORROSIVEGAS,:COUNTER,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:ENCORE,:ENERGYBALL,:EXPLOSION,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HEX,:HYPERBEAM,:HYPNOSIS,:ICEPUNCH,:ICYWIND,:IMPRISON,:INFESTATION,:KNOCKOFF,:LASERFOCUS,:MEGADRAIN,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:NASTYPLOT,:NIGHTMARE,:NIGHTSHADE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:POISONJAB,:POLTERGEIST,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:ROCKSMASH,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHADOWCLAW,:SKILLSWAP,:SKITTERSMACK,:SKULLBASH,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:VENOSHOCK,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Amorphous],
		:Height => 15,
		:Weight => 405,
		:kind => "Shadow",
		:dexentry => "Deep in the night, your shadow cast by a streetlight may suddenly overtake you. It is actually a Gengar running past you, pretending to be your shadow.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [60, 65, 80, 170, 95, 130],
		:Abilities => [:SHADOWTAG],
		:Weight => 405,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GENGARITE => 1,
	},
},

:ONIX => {
	"Normal Form" => {
		:name => "Onix",
		:dexnum => 95,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [35, 45, 160, 30, 45, 70],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :STURDY],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 77,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BLOCK,:DEFENSECURL,:FLAIL,:HEAVYSLAM,:ROCKBLAST,:ROCKCLIMB,:ROLLOUT,:ROTOTILLER,:STEALTHROCK,:WIDEGUARD,],
		:Moveset => [
			[1,:MUDSPORT],
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:BIND],
			[4,:CURSE],
			[7,:ROCKTHROW],
			[10,:ROCKTOMB],
			[13,:RAGE],
			[16,:STEALTHROCK],
			[19,:ROCKPOLISH],
			[20,:GYROBALL],
			[22,:SMACKDOWN],
			[25,:DRAGONBREATH],
			[28,:SLAM],
			[31,:SCREECH],
			[34,:ROCKSLIDE],
			[37,:SANDTOMB],
			[40,:IRONTAIL],
			[43,:DIG],
			[46,:STONEEDGE],
			[49,:DOUBLEEDGE],
			[52,:SANDSTORM]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BIND,:BLOCK,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BULLDOZE,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FISSURE,:FLASHCANNON,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:IRONHEAD,:IRONTAIL,:METEORBEAM,:MIMIC,:MUDSLAP,:NATUREPOWER,:PAYBACK,:PSYCHUP,:RAGE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SCORCHINGSANDS,:SCREECH,:SELFDESTRUCT,:SKULLBASH,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TORMENT,:TWISTER,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Mineral],
		:Height => 88,
		:Weight => 2100,
		:kind => "Rock Snake",
		:dexentry => "An Onix never loses direction while tunneling, thanks to a magnet on its brain. As it grows older, its body becomes steadily rounder and smoother.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
		:evolutions => [
			[:STEELIX,:TradeItem,:METALCOAT]
		]
	},

	:OnCreation => {},
},

:DROWZEE => {
	"Normal Form" => {
		:name => "Drowzee",
		:dexnum => 96,
		:Type1 => :PSYCHIC,
		:BaseStats => [60, 48, 45, 43, 90, 42],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:INSOMNIA, :FOREWARN],
		:HiddenAbilities => :INNERFOCUS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASSIST,:BARRIER,:FIREPUNCH,:FLATTER,:GUARDSWAP,:ICEPUNCH,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:PSYCHOCUT,:ROLEPLAY,:SECRETPOWER,:SKILLSWAP,:THUNDERPUNCH,],
		:Moveset => [
			[1,:POUND],
			[1,:HYPNOSIS],
			[5,:DISABLE],
			[9,:CONFUSION],
			[13,:HEADBUTT],
			[17,:POISONGAS],
			[21,:MEDITATE],
			[25,:PSYBEAM],
			[29,:WAKEUPSLAP],
			[33,:PSYCHUP],
			[37,:SYNCHRONOISE],
			[41,:ZENHEADBUTT],
			[45,:SWAGGER],
			[49,:PSYCHIC],
			[53,:NASTYPLOT],
			[57,:PSYSHOCK],
			[61,:FUTURESIGHT]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYSLAM,:BRICKBREAK,:CALMMIND,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HYPNOSIS,:ICEPUNCH,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:NASTYPLOT,:NIGHTMARE,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:HumanLike],
		:Height => 10,
		:Weight => 324,
		:kind => "Hypnosis",
		:dexentry => "If your nose becomes itchy while you are sleeping, it is a sure sign that a Drowzee is standing above your pillow and trying to eat your dream through your nostrils.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HYPNO,:Level,26]
		]
	},

	:OnCreation => {},
},

:HYPNO => {
	"Normal Form" => {
		:name => "Hypno",
		:dexnum => 97,
		:Type1 => :PSYCHIC,
		:BaseStats => [85, 73, 70, 73, 115, 67],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:INSOMNIA, :FOREWARN],
		:HiddenAbilities => :INNERFOCUS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 169,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :DROWZEE,
			:form => 0
		},
		:Moveset => [
			[1,:FUTURESIGHT],
			[1,:NASTYPLOT],
			[1,:NIGHTMARE],
			[1,:SWITCHEROO],
			[1,:POUND],
			[1,:HYPNOSIS],
			[1,:DISABLE],
			[1,:CONFUSION],
			[5,:DISABLE],
			[9,:CONFUSION],
			[13,:HEADBUTT],
			[17,:POISONGAS],
			[21,:MEDITATE],
			[25,:PSYBEAM],
			[29,:WAKEUPSLAP],
			[33,:PSYCHUP],
			[37,:SYNCHRONOISE],
			[41,:ZENHEADBUTT],
			[45,:SWAGGER],
			[49,:PSYCHIC],
			[53,:NASTYPLOT],
			[57,:PSYSHOCK],
			[61,:FUTURESIGHT]],
		:compatiblemoves => [:ALLYSWITCH,:BATONPASS,:BIDE,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:CALMMIND,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENCORE,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HEX,:HYPERBEAM,:HYPNOSIS,:ICEPUNCH,:IMPRISON,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MYSTICALFIRE,:NASTYPLOT,:NIGHTMARE,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SCARYFACE,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:STOREDPOWER,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWDOWN,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:HumanLike],
		:Height => 16,
		:Weight => 756,
		:kind => "Hypnosis",
		:dexentry => "The arcing movement and glitter of the pendulum in a Hypno's hand lull the foe into deep hypnosis. While searching for prey, it polishes the pendulum.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:KRABBY => {
	"Normal Form" => {
		:name => "Krabby",
		:dexnum => 98,
		:Type1 => :WATER,
		:BaseStats => [30, 105, 90, 25, 25, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SHELLARMOR],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 65,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:BIDE,:CHIPAWAY,:ENDURE,:FLAIL,:HAZE,:KNOCKOFF,:SLAM,:TICKLE,],
		:Moveset => [
			[1,:MUDSPORT],
			[1,:BUBBLE],
			[5,:VICEGRIP],
			[9,:LEER],
			[11,:HARDEN],
			[15,:BUBBLEBEAM],
			[19,:MUDSHOT],
			[21,:METALCLAW],
			[25,:STOMP],
			[29,:PROTECT],
			[31,:GUILLOTINE],
			[35,:SLAM],
			[39,:BRINE],
			[41,:CRABHAMMER],
			[45,:FLAIL]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CURSE,:CUT,:DIG,:DIVE,:DOUBLEEDGE,:FALSESWIPE,:FLING,:FURYCUTTER,:HAIL,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LIQUIDATION,:MIMIC,:MUDSHOT,:MUDSLAP,:RAGE,:RAINDANCE,:RAZORSHELL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:STRENGTH,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water3],
		:Height => 4,
		:Weight => 65,
		:kind => "River Crab",
		:dexentry => "Krabby live in holes dug into beaches. On sandy shores with little in the way of food, they can be seen squabbling with each other over territory.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KINGLER,:Level,28]
		]
	},

	:OnCreation => {},
},

:KINGLER => {
	"Normal Form" => {
		:name => "Kingler",
		:dexnum => 99,
		:Type1 => :WATER,
		:BaseStats => [55, 130, 115, 50, 50, 75],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SHELLARMOR],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 166,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :KRABBY,
			:form => 0
		},
		:Moveset => [
			[1,:WIDEGUARD],
			[1,:MUDSPORT],
			[1,:BUBBLE],
			[1,:VICEGRIP],
			[1,:LEER],
			[5,:VICEGRIP],
			[9,:LEER],
			[11,:HARDEN],
			[15,:BUBBLEBEAM],
			[19,:MUDSHOT],
			[21,:METALCLAW],
			[25,:STOMP],
			[32,:PROTECT],
			[37,:GUILLOTINE],
			[44,:SLAM],
			[51,:BRINE],
			[56,:CRABHAMMER],
			[63,:FLAIL]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,:BRUTALSWING,:BUBBLEBEAM,:CURSE,:CUT,:DIG,:DIVE,:DOUBLEEDGE,:FALSESWIPE,:FLING,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HIGHHORSEPOWER,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LIQUIDATION,:MIMIC,:MUDSHOT,:MUDSLAP,:QUASH,:RAGE,:RAINDANCE,:RAZORSHELL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:STOMPINGTANTRUM,:STRENGTH,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water3],
		:Height => 13,
		:Weight => 600,
		:kind => "Pincer",
		:dexentry => "It waves its huge, oversized claw in the air to communicate with others. But since the claw is so heavy, this Pokémon quickly tires.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:VOLTORB => {
	"Normal Form" => {
		:name => "Voltorb",
		:dexnum => 100,
		:Type1 => :ELECTRIC,
		:BaseStats => [40, 30, 50, 55, 55, 100],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SOUNDPROOF, :STATIC],
		:HiddenAbilities => :AFTERMATH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 66,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:CHARGE],
			[1,:TACKLE],
			[4,:SONICBOOM],
			[6,:EERIEIMPULSE],
			[9,:SPARK],
			[11,:ROLLOUT],
			[13,:SCREECH],
			[16,:CHARGEBEAM],
			[20,:SWIFT],
			[22,:ELECTROBALL],
			[26,:SELFDESTRUCT],
			[29,:LIGHTSCREEN],
			[34,:MAGNETRISE],
			[37,:DISCHARGE],
			[41,:EXPLOSION],
			[46,:GYROBALL],
			[48,:MIRRORCOAT]],
		:compatiblemoves => [:BIDE,:CHARGEBEAM,:CURSE,:EERIEIMPULSE,:ELECTROBALL,:EXPLOSION,:FLASH,:FOULPLAY,:GYROBALL,:HEADBUTT,:LIGHTSCREEN,:MAGICCOAT,:MAGNETRISE,:MIMIC,:RAGE,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHOCKWAVE,:SIGNALBEAM,:SUCKERPUNCH,:SWIFT,:TAKEDOWN,:TAUNT,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:VOLTSWITCH,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWRUSH,:SHADOWPANIC,],
		:Color => "Red",
		:Habitat => "Urban",
		:EggGroups => [:Mineral],
		:Height => 5,
		:Weight => 104,
		:kind => "Ball",
		:dexentry => "It bears an uncanny and unexplained resemblance to a Poké Ball. Because it explodes at the slightest shock, even veteran Trainers treat it with caution.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ELECTRODE,:Level,30]
		]
	},

	:OnCreation => {},
},

:ELECTRODE => {
	"Normal Form" => {
		:name => "Electrode",
		:dexnum => 101,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 50, 70, 80, 80, 150],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SOUNDPROOF, :STATIC],
		:HiddenAbilities => :AFTERMATH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 172,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :VOLTORB,
			:form => 0
		},
		:Moveset => [
			[1,:MAGNETICFLUX],
			[1,:CHARGE],
			[1,:TACKLE],
			[1,:SONICBOOM],
			[1,:EERIEIMPULSE],
			[4,:SONICBOOM],
			[6,:EERIEIMPULSE],
			[9,:SPARK],
			[11,:ROLLOUT],
			[13,:SCREECH],
			[16,:CHARGEBEAM],
			[20,:SWIFT],
			[22,:ELECTROBALL],
			[26,:SELFDESTRUCT],
			[29,:LIGHTSCREEN],
			[36,:MAGNETRISE],
			[41,:DISCHARGE],
			[47,:EXPLOSION],
			[54,:GYROBALL],
			[58,:MIRRORCOAT]],
		:compatiblemoves => [:AGILITY,:BIDE,:CHARGEBEAM,:CURSE,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:EXPLOSION,:FLASH,:FOULPLAY,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HYPERBEAM,:LIGHTSCREEN,:MAGICCOAT,:MAGNETRISE,:MIMIC,:RAGE,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SPEEDSWAP,:SUCKERPUNCH,:SWIFT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:Habitat => "Urban",
		:EggGroups => [:Mineral],
		:Height => 12,
		:Weight => 666,
		:kind => "Ball",
		:dexentry => "They appear in great numbers at electric power plants. Because they feed on electricity, they cause massive and chaotic blackouts in nearby cities.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:EXEGGCUTE => {
	"Normal Form" => {
		:name => "Exeggcute",
		:dexnum => 102,
		:Type1 => :GRASS,
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 40, 80, 60, 45, 40],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :HARVEST],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 65,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:BLOCK,:CURSE,:GIGADRAIN,:GRASSYTERRAIN,:INGRAIN,:LEAFSTORM,:LUCKYCHANT,:MOONLIGHT,:NATURALGIFT,:NATUREPOWER,:POWERSWAP,:SKILLSWAP,:SYNTHESIS,],
		:Moveset => [
			[1,:BARRAGE],
			[1,:UPROAR],
			[1,:HYPNOSIS],
			[7,:REFLECT],
			[11,:LEECHSEED],
			[17,:BULLETSEED],
			[19,:STUNSPORE],
			[21,:POISONPOWDER],
			[23,:SLEEPPOWDER],
			[27,:CONFUSION],
			[33,:WORRYSEED],
			[37,:NATURALGIFT],
			[43,:SOLARBEAM],
			[47,:EXTRASENSORY],
			[50,:BESTOW]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BULLETSEED,:CURSE,:DOUBLEEDGE,:DREAMEATER,:ENERGYBALL,:EXPLOSION,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:GRAVITY,:HEADBUTT,:HYPNOSIS,:INFESTATION,:LEAFSTORM,:LIGHTSCREEN,:MEGADRAIN,:MIMIC,:NATUREPOWER,:NIGHTMARE,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:REFLECT,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SKILLSWAP,:SLUDGEBOMB,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THIEF,:TRICKROOM,:UPROAR,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Forest",
		:EggGroups => [:Grass],
		:Height => 4,
		:Weight => 25,
		:WildItemUncommon => :MAGICALSEED,
		:kind => "Egg",
		:dexentry => "It consists of six eggs that care for each other. They attract each other and spin around. It evolves when various cracks start to appear.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 32,
		:BattlerAltitude => 0,
		:evolutions => [
			[:EXEGGUTOR,:Item,:LEAFSTONE]
		]
	},

	:OnCreation => {},
},

:EXEGGUTOR => {
	"Normal Form" => {
		:name => "Exeggutor",
		:dexnum => 103,
		:Type1 => :GRASS,
		:Type2 => :PSYCHIC,
		:BaseStats => [95, 95, 85, 125, 75, 55],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:CHLOROPHYLL, :HARVEST],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 186,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :EXEGGCUTE,
			:form => 0
		},
		:Moveset => [
			[0,:STOMP],
			[1,:SEEDBOMB],
			[1,:BARRAGE],
			[1,:HYPNOSIS],
			[1,:CONFUSION],
			[17,:PSYSHOCK],
			[27,:EGGBOMB],
			[37,:WOODHAMMER],
			[47,:LEAFSTORM]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BULLDOZE,:BULLETSEED,:CALMMIND,:CURSE,:DOUBLEEDGE,:DREAMEATER,:ENERGYBALL,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:GRAVITY,:HEADBUTT,:HYPERBEAM,:HYPNOSIS,:INFESTATION,:LEAFSTORM,:LIGHTSCREEN,:LOWKICK,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:NIGHTMARE,:POWERSWAP,:POWERWHIP,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:REFLECT,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SKILLSWAP,:SLUDGEBOMB,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:TERRAINPULSE,:THIEF,:TRICKROOM,:UPROAR,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWSHED,:SHADOWHOLD,:SHADOWEND,],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Grass],
		:Height => 20,
		:Weight => 1200,
		:kind => "Coconut",
		:dexentry => "Originally from the tropics, Exeggutor's heads grow larger from exposure to strong sunlight. When the heads fall, they group to form an Exeggcute.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 5,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type2 => :DRAGON,
		:BaseStats => [95, 105, 85, 125, 75, 45],
		:Abilities => [:FRISK, :FRISK, :HARVEST],
		:Moveset => [
			[0,:DRAGONHAMMER],
			[1,:SEEDBOMB],
			[1,:BARRAGE],
			[1,:HYPNOSIS],
			[1,:CONFUSION],
			[17,:PSYSHOCK],
			[27,:EGGBOMB],
			[37,:WOODHAMMER],
			[47,:LEAFSTORM],
		],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BLOCK,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:BULLETSEED,:CELEBRATE,:CURSE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONPULSE,:DRAGONTAIL,:DREAMEATER,:EARTHQUAKE,:ENERGYBALL,:EXPLOSION,:FLAMETHROWER,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:GRAVITY,:HEADBUTT,:HYPERBEAM,:HYPNOSIS,:INFESTATION,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LEAFSTORM,:LIGHTSCREEN,:LOWKICK,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:NIGHTMARE,:OUTRAGE,:POWERSWAP,:POWERWHIP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:REFLECT,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SKILLSWAP,:SLUDGEBOMB,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:TERRAINPULSE,:THIEF,:TRICKROOM,:UPROAR,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Height => 109,
		:Weight => 4156,
		:dexentry => "As it grew taller and taller, it outgrew its reliance on psychic powers, while within it awakened the power of the sleeping dragon.",
	},

	:OnCreation => {},
},

:CUBONE => {
	"Normal Form" => {
		:name => "Cubone",
		:dexnum => 104,
		:Type1 => :GROUND,
		:BaseStats => [50, 50, 95, 40, 50, 35],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :LIGHTNINGROD],
		:HiddenAbilities => :BATTLEARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 64,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:BELLYDRUM,:CHIPAWAY,:CURSE,:DETECT,:DOUBLEKICK,:ENDURE,:IRONHEAD,:PERISHSONG,:SCREECH,:SKULLBASH,],
		:Moveset => [
			[1,:GROWL],
			[3,:TAILWHIP],
			[7,:BONECLUB],
			[11,:HEADBUTT],
			[13,:LEER],
			[17,:FOCUSENERGY],
			[21,:BONEMERANG],
			[23,:RAGE],
			[27,:FALSESWIPE],
			[31,:THRASH],
			[33,:FLING],
			[37,:STOMPINGTANTRUM],
			[41,:ENDEAVOR],
			[43,:DOUBLEEDGE],
			[47,:RETALIATE],
			[51,:BONERUSH]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FALSESWIPE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:RAGE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCORCHINGSANDS,:SCREECH,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THUNDERPUNCH,:UPROAR,:WATERGUN,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 4,
		:Weight => 65,
		:WildItemUncommon => :THICKCLUB,
		:kind => "Lonely",
		:dexentry => "It pines for the mother it will never see again. Seeing a likeness of its mother in the full moon, it cries. The stains on the skull it wears are from its tears.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MAROWAK,:Level,28]
		]
	},

	:OnCreation => {},
},

:MAROWAK => {
	"Normal Form" => {
		:name => "Marowak",
		:dexnum => 105,
		:Type1 => :GROUND,
		:BaseStats => [60, 80, 110, 50, 80, 45],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :LIGHTNINGROD],
		:HiddenAbilities => :BATTLEARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 149,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CUBONE,
			:form => 0
		},
		:Moveset => [
			[1,:GROWL],
			[1,:TAILWHIP],
			[1,:BONECLUB],
			[1,:HEADBUTT],
			[3,:TAILWHIP],
			[7,:BONECLUB],
			[11,:HEADBUTT],
			[13,:LEER],
			[17,:FOCUSENERGY],
			[21,:BONEMERANG],
			[23,:RAGE],
			[27,:FALSESWIPE],
			[33,:THRASH],
			[37,:FLING],
			[43,:STOMPINGTANTRUM],
			[49,:ENDEAVOR],
			[53,:DOUBLEEDGE],
			[59,:RETALIATE],
			[65,:BONERUSH]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FALSESWIPE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCORCHINGSANDS,:SCREECH,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THROATCHOP,:THUNDERPUNCH,:UPROAR,:WATERGUN,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWEND,:SHADOWPANIC,],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 10,
		:Weight => 450,
		:WildItemUncommon => :THICKCLUB,
		:kind => "Bone Keeper",
		:dexentry => "A Marowak is a Cubone that has grown tough by overcoming the grief of losing its mother. Its hardened spirit is not easily broken.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
	},

	"Alolan Form" => {
		:Type1 => :FIRE,
		:Type2 => :GHOST,
		:BaseStats => [60, 80, 110, 50, 80, 45],
		:Abilities => [:CURSEDBODY, :LIGHTNINGROD, :ROCKHEAD],
		:Moveset => [
			[1,:GROWL],
			[1,:TAILWHIP],
			[1,:BONECLUB],
			[1,:FLAMEWHEEL],
			[3,:TAILWHIP],
			[7,:BONECLUB],
			[11,:FLAMEWHEEL],
			[13,:LEER],
			[17,:HEX],
			[21,:BONEMERANG],
			[23,:WILLOWISP],
			[27,:SHADOWBONE],
			[33,:THRASH],
			[37,:FLING],
			[43,:STOMPINGTANTRUM],
			[49,:ENDEAVOR],
			[53,:FLAREBLITZ],
			[59,:RETALIATE],
			[65,:BONERUSH],
		],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:BURNINGJEALOUSY,:COUNTER,:CURSE,:DARKPULSE,:DETECT,:DIG,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FALSESWIPE,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FISSURE,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HEX,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IMPRISON,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:PAINSPLIT,:POLTERGEIST,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCORCHINGSANDS,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SKULLBASH,:SMACKDOWN,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERGUN,:WILLOWISP,],
		:moveexceptions => [],
		:Weight => 340,
		:dexentry => "The bones it possesses were once its mother's. Its mother's regrets have become like a vengeful spirit protecting this Pokémon.",
	},

	:OnCreation => proc{
 # Map IDs for alolan form
 if $game_map && Cubone.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:HITMONLEE => {
	"Normal Form" => {
		:name => "Hitmonlee",
		:dexnum => 106,
		:Type1 => :FIGHTING,
		:BaseStats => [50, 120, 53, 35, 110, 87],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:LIMBER, :RECKLESS],
		:HiddenAbilities => :UNBURDEN,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemZero,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :TYROGUE,
			:form => 0
		},
		:Moveset => [
			[0,:DOUBLEKICK],
			[1,:REVERSAL],
			[1,:CLOSECOMBAT],
			[1,:MEGAKICK],
			[1,:REVENGE],
			[1,:MEDITATE],
			[1,:ROLLINGKICK],
			[1,:JUMPKICK],
			[5,:MEDITATE],
			[9,:ROLLINGKICK],
			[13,:JUMPKICK],
			[17,:BRICKBREAK],
			[21,:FOCUSENERGY],
			[25,:FEINT],
			[29,:HIJUMPKICK],
			[33,:MINDREADER],
			[37,:FORESIGHT],
			[41,:WIDEGUARD],
			[45,:BLAZEKICK],
			[49,:ENDURE],
			[53,:MEGAKICK],
			[57,:CLOSECOMBAT],
			[61,:REVERSAL]],
		:compatiblemoves => [:AURASPHERE,:BIDE,:BLAZEKICK,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FAKEOUT,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:HEADBUTT,:HELPINGHAND,:KNOCKOFF,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEISMICTOSS,:SKULLBASH,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAKEDOWN,:THIEF,:THROATCHOP,:UPROAR,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWDOWN,:SHADOWHALF,],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 15,
		:Weight => 498,
		:kind => "Kicking",
		:dexentry => "Its legs freely stretch and contract. Using these springlike limbs, it bowls over foes with devastating kicks. After battle, it rubs down its tired legs.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:HITMONCHAN => {
	"Normal Form" => {
		:name => "Hitmonchan",
		:dexnum => 107,
		:Type1 => :FIGHTING,
		:BaseStats => [50, 105, 79, 35, 110, 76],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:KEENEYE, :IRONFIST],
		:HiddenAbilities => :INNERFOCUS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemZero,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :TYROGUE,
			:form => 0
		},
		:Moveset => [
			[0,:COMETPUNCH],
			[1,:CLOSECOMBAT],
			[1,:COUNTER],
			[1,:FOCUSPUNCH],
			[1,:REVENGE],
			[1,:AGILITY],
			[1,:PURSUIT],
			[1,:MACHPUNCH],
			[6,:AGILITY],
			[11,:PURSUIT],
			[16,:MACHPUNCH],
			[16,:BULLETPUNCH],
			[21,:FEINT],
			[26,:VACUUMWAVE],
			[31,:QUICKGUARD],
			[36,:FIREPUNCH],
			[36,:ICEPUNCH],
			[36,:THUNDERPUNCH],
			[41,:SKYUPPERCUT],
			[46,:MEGAPUNCH],
			[50,:DETECT],
			[56,:FOCUSPUNCH],
			[61,:COUNTER],
			[66,:CLOSECOMBAT]],
		:compatiblemoves => [:AGILITY,:AURASPHERE,:BIDE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:EARTHQUAKE,:FAKEOUT,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEISMICTOSS,:SKULLBASH,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:THIEF,:THROATCHOP,:THUNDERPUNCH,:UPROAR,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWDOWN,],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 14,
		:Weight => 502,
		:kind => "Punching",
		:dexentry => "A Hitmonchan is said to possess the spirit of a boxer who aimed to become the world champion. Having an indomitable spirit means that it will never give up.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LICKITUNG => {
	"Normal Form" => {
		:name => "Lickitung",
		:dexnum => 108,
		:Type1 => :NORMAL,
		:BaseStats => [90, 55, 75, 60, 75, 30],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:OWNTEMPO, :OBLIVIOUS],
		:HiddenAbilities => :CLOUDNINE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 77,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:BELCH,:BELLYDRUM,:BODYSLAM,:CURSE,:HAMMERARM,:MAGNITUDE,:MUDDYWATER,:SLEEPTALK,:SMELLINGSALTS,:SNORE,:THRASH,:ZENHEADBUTT,],
		:Moveset => [
			[1,:LICK],
			[5,:SUPERSONIC],
			[9,:DEFENSECURL],
			[13,:KNOCKOFF],
			[17,:WRAP],
			[21,:STOMP],
			[25,:DISABLE],
			[29,:SLAM],
			[33,:ROLLOUT],
			[37,:CHIPAWAY],
			[41,:MEFIRST],
			[45,:REFRESH],
			[49,:SCREECH],
			[53,:POWERWHIP],
			[57,:WRINGOUT]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BIDE,:BIND,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONTAIL,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:KNOCKOFF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:NIGHTMARE,:POWERUPPUNCH,:POWERWHIP,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SOLARBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SURF,:SWORDSDANCE,:TAKEDOWN,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWPANIC,],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Monster],
		:Height => 12,
		:Weight => 655,
		:WildItemUncommon => :LAGGINGTAIL,
		:kind => "Licking",
		:dexentry => "Whenever it sees something unfamiliar, it always licks the object because it memorizes things by texture and taste. It is somewhat put off by sour things.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LICKILICKY,:HasMove,:ROLLOUT]
		]
	},

	:OnCreation => {},
},

:KOFFING => {
	"Normal Form" => {
		:name => "Koffing",
		:dexnum => 109,
		:Type1 => :POISON,
		:BaseStats => [40, 65, 95, 60, 45, 35],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:LEVITATE, :NEUTRALIZINGGAS],
		:HiddenAbilities => :STENCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 68,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CURSE,:DESTINYBOND,:GRUDGE,:PAINSPLIT,:PSYBEAM,:PSYWAVE,:SCREECH,:SPITE,:SPITUP,:STOCKPILE,:SWALLOW,:TOXICSPIKES,:VENOMDRENCH,],
		:Moveset => [
			[1,:POISONGAS],
			[1,:TACKLE],
			[4,:SMOG],
			[7,:SMOKESCREEN],
			[12,:ASSURANCE],
			[15,:CLEARSMOG],
			[18,:SLUDGE],
			[23,:SELFDESTRUCT],
			[26,:HAZE],
			[29,:GYROBALL],
			[34,:SLUDGEBOMB],
			[37,:EXPLOSION],
			[40,:DESTINYBOND],
			[42,:BELCH],
			[45,:MEMENTO]],
		:compatiblemoves => [:ASSURANCE,:BIDE,:CORROSIVEGAS,:CURSE,:DARKPULSE,:EXPLOSION,:FIREBLAST,:FLAMETHROWER,:FLASH,:GYROBALL,:HEADBUTT,:INCINERATE,:INFESTATION,:MIMIC,:PAINSPLIT,:PAYBACK,:PSYWAVE,:RAGE,:RAINDANCE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SPITE,:SUNNYDAY,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:TORMENT,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WILLOWISP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 6,
		:Weight => 10,
		:WildItemUncommon => :SMOKEBALL,
		:kind => "Poison Gas",
		:dexentry => "Getting up close to a Koffing will give you a chance to observe, through its thin skin, the toxic gases swirling inside. It blows up at the slightest stimulation.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 16,
		:evolutions => [
			[:WEEZING,:Level,35]
		]
	},

	:OnCreation => {},
},

:WEEZING => {
	"Normal Form" => {
		:name => "Weezing",
		:dexnum => 110,
		:Type1 => :POISON,
		:BaseStats => [65, 90, 120, 85, 70, 60],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:LEVITATE, :NEUTRALIZINGGAS],
		:HiddenAbilities => :STENCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 172,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :KOFFING,
			:form => 0
		},
		:Moveset => [
			[0,:DOUBLEHIT],
			[1,:POISONGAS],
			[1,:TACKLE],
			[1,:SMOG],
			[1,:SMOKESCREEN],
			[4,:SMOG],
			[7,:SMOKESCREEN],
			[12,:ASSURANCE],
			[15,:CLEARSMOG],
			[18,:SLUDGE],
			[23,:SELFDESTRUCT],
			[26,:HAZE],
			[29,:GYROBALL],
			[34,:SLUDGEBOMB],
			[40,:EXPLOSION],
			[46,:DESTINYBOND],
			[51,:BELCH],
			[57,:MEMENTO]],
		:compatiblemoves => [:ASSURANCE,:BIDE,:CORROSIVEGAS,:CURSE,:DARKPULSE,:EXPLOSION,:FIREBLAST,:FLAMETHROWER,:FLASH,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEATWAVE,:HYPERBEAM,:INCINERATE,:INFESTATION,:MIMIC,:PAINSPLIT,:PAYBACK,:PSYWAVE,:RAGE,:RAINDANCE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SPITE,:SUNNYDAY,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:TORMENT,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WILLOWISP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 12,
		:Weight => 95,
		:WildItemUncommon => :SMOKEBALL,
		:kind => "Poison Gas",
		:dexentry => "By diluting its toxic gases with a special process, the highest grade of perfume can be extracted. To Weezing, gases from garbage are the ultimate feast.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 8,
	},

	"Galarian Form" => {
		:Type2 => :FAIRY,
		:Abilities => [:LEVITATE, :NEUTRALIZINGGAS, :MISTYSURGE],
		:Moveset => [
			[0,:DOUBLEHIT],
			[1,:AROMATICMIST],
			[1,:POISONGAS],
			[1,:DEFOG],
			[1,:SMOG],
			[1,:SMOKESCREEN],
			[1,:FAIRYWIND],
			[1,:HAZE],
			[1,:HEATWAVE],
			[1,:STRANGESTEAM],
			[1,:TACKLE],
			[12,:CLEARSMOG],
			[16,:ASSURANCE],
			[20,:SLUDGE],
			[24,:AROMATHERAPY],
			[28,:SELFDESTRUCT],
			[32,:SLUDGEBOMB],
			[38,:TOXIC],
			[44,:BELCH],
			[50,:EXPLOSION],
			[56,:MEMENTO],
			[62,:DESTINYBOND],
			[68,:MISTYTERRAIN],
		],
		:compatiblemoves => [:ASSURANCE,:BIDE,:BRUTALSWING,:CORROSIVEGAS,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DEFOG,:EXPLOSION,:FIREBLAST,:FLAMETHROWER,:FLASH,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEATWAVE,:HYPERBEAM,:INCINERATE,:INFESTATION,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:OVERHEAT,:PAINSPLIT,:PAYBACK,:PLAYROUGH,:PSYWAVE,:RAGE,:RAINDANCE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SPITE,:SUNNYDAY,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:TORMENT,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Height => 30,
		:Weight => 160,
		:dexentry => "This Pokémon consumes particles that contaminate the air. Instead of leaving droppings, it expels clean air.",
		:preevo => {
			:species => :KOFFING,
			:form => 0
		},
	},

	:OnCreation => proc {
 # Map IDs for galarian form
 if $game_map && Weezing.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:RHYHORN => {
	"Normal Form" => {
		:name => "Rhyhorn",
		:dexnum => 111,
		:Type1 => :GROUND,
		:Type2 => :ROCK,
		:BaseStats => [80, 85, 95, 30, 30, 25],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:LIGHTNINGROD, :ROCKHEAD],
		:HiddenAbilities => :RECKLESS,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 69,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:COUNTER,:CRUNCH,:CRUSHCLAW,:CURSE,:DRAGONRUSH,:FIREFANG,:GUARDSPLIT,:ICEFANG,:IRONTAIL,:MAGNITUDE,:METALBURST,:REVERSAL,:ROCKCLIMB,:ROTOTILLER,:SKULLBASH,:THUNDERFANG,],
		:Moveset => [
			[1,:HORNATTACK],
			[1,:TAILWHIP],
			[5,:FURYATTACK],
			[9,:SCARYFACE],
			[13,:SMACKDOWN],
			[17,:STOMP],
			[21,:BULLDOZE],
			[25,:CHIPAWAY],
			[29,:ROCKBLAST],
			[33,:DRILLRUN],
			[37,:TAKEDOWN],
			[41,:STONEEDGE],
			[45,:EARTHQUAKE],
			[49,:MEGAHORN],
			[53,:HORNDRILL]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BULLDOZE,:COUNTER,:CRUNCH,:CURSE,:DIG,:DOUBLEEDGE,:DRAGONPULSE,:DRILLRUN,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREFANG,:FISSURE,:FLAMETHROWER,:GIGAIMPACT,:HEADBUTT,:HIGHHORSEPOWER,:ICEBEAM,:ICEFANG,:ICYWIND,:INCINERATE,:IRONTAIL,:MEGAHORN,:MIMIC,:MUDSHOT,:MUDSLAP,:PAYBACK,:POISONJAB,:RAGE,:RAINDANCE,:REVERSAL,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SCORCHINGSANDS,:SHOCKWAVE,:SKULLBASH,:SMACKDOWN,:SMARTSTRIKE,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:UPROAR,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Monster, :Field],
		:Height => 10,
		:Weight => 1150,
		:kind => "Spikes",
		:dexentry => "Once it starts running, it doesn't stop. Its tiny brain makes it so stupid that it can't remember why it started running in the first place.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RHYDON,:Level,42]
		]
	},

	:OnCreation => {},
},

:RHYDON => {
	"Normal Form" => {
		:name => "Rhydon",
		:dexnum => 112,
		:Type1 => :GROUND,
		:Type2 => :ROCK,
		:BaseStats => [105, 130, 120, 45, 45, 40],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:LIGHTNINGROD, :ROCKHEAD],
		:HiddenAbilities => :RECKLESS,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :RHYHORN,
			:form => 0
		},
		:Moveset => [
			[0,:HAMMERARM],
			[1,:HORNDRILL],
			[1,:HORNATTACK],
			[1,:TAILWHIP],
			[1,:FURYATTACK],
			[1,:SCARYFACE],
			[5,:FURYATTACK],
			[9,:SCARYFACE],
			[13,:SMACKDOWN],
			[17,:STOMP],
			[21,:BULLDOZE],
			[25,:CHIPAWAY],
			[29,:ROCKBLAST],
			[33,:DRILLRUN],
			[37,:TAKEDOWN],
			[41,:STONEEDGE],
			[48,:EARTHQUAKE],
			[55,:MEGAHORN],
			[62,:HORNDRILL]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEAVYSLAM,:HELPINGHAND,:HIGHHORSEPOWER,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONTAIL,:MEGAHORN,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:OUTRAGE,:PAYBACK,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:REVERSAL,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SMACKDOWN,:SMARTSTRIKE,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERPUNCH,:UPROAR,:WATERGUN,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWEND,:SHADOWPANIC,:SHADOWDOWN,:SHADOWHOLD,],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Monster, :Field],
		:Height => 19,
		:Weight => 1200,
		:kind => "Drill",
		:dexentry => "Its horn, which rotates like a drill, destroys tall buildings with one strike. It stands on its hind legs, and its brain is well developed.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RHYPERIOR,:TradeItem,:PROTECTOR]
		]
	},

	:OnCreation => {},
},

:CHANSEY => {
	"Normal Form" => {
		:name => "Chansey",
		:dexnum => 113,
		:Type1 => :NORMAL,
		:BaseStats => [250, 5, 5, 35, 105, 50],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:NATURALCURE, :SERENEGRACE],
		:HiddenAbilities => :HEALER,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 395,
		:CatchRate => 30,
		:Happiness => 140,
		:EggSteps => 10455,
		:EggMoves => [:AROMATHERAPY,:COUNTER,:ENDURE,:GRAVITY,:HEALBELL,:HELPINGHAND,:METRONOME,:MUDBOMB,:NATURALGIFT,:PRESENT,:SEISMICTOSS,],
		:preevo => {
			:species => :HAPPINY,
			:form => 0
		},
		:Moveset => [
			[1,:DOUBLEEDGE],
			[1,:DEFENSECURL],
			[1,:POUND],
			[1,:GROWL],
			[5,:TAILWHIP],
			[9,:REFRESH],
			[12,:DOUBLESLAP],
			[16,:SOFTBOILED],
			[20,:BESTOW],
			[23,:MINIMIZE],
			[27,:TAKEDOWN],
			[31,:SING],
			[35,:FLING],
			[39,:HEALPULSE],
			[44,:EGGBOMB],
			[50,:LIGHTSCREEN],
			[57,:HEALINGWISH],
			[65,:DOUBLEEDGE]],
		:compatiblemoves => [:ALLYSWITCH,:BABYDOLLEYES,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:CALMMIND,:CELEBRATE,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SKULLBASH,:SNATCH,:SOFTBOILED,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWEETSCENT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:UPROAR,:WATERGUN,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWHOLD,],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:Fairy],
		:Height => 11,
		:Weight => 346,
		:WildItemCommon => :LUCKYPUNCH,
		:kind => "Egg",
		:dexentry => "Chansey lay nutritionally excellent eggs every day. The eggs are so delicious, they are eagerly devoured by even those who have lost their appetite.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BLISSEY,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:TANGELA => {
	"Normal Form" => {
		:name => "Tangela",
		:dexnum => 114,
		:Type1 => :GRASS,
		:BaseStats => [65, 55, 115, 100, 40, 60],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :LEAFGUARD],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 87,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:CONFUSION,:ENDEAVOR,:FLAIL,:GIGADRAIN,:LEAFSTORM,:LEECHSEED,:MEGADRAIN,:NATURALGIFT,:NATUREPOWER,:POWERSWAP,:RAGEPOWDER,:WAKEUPSLAP,],
		:Moveset => [
			[1,:INGRAIN],
			[1,:CONSTRICT],
			[4,:SLEEPPOWDER],
			[7,:VINEWHIP],
			[10,:ABSORB],
			[14,:POISONPOWDER],
			[17,:BIND],
			[20,:GROWTH],
			[23,:MEGADRAIN],
			[27,:KNOCKOFF],
			[30,:STUNSPORE],
			[33,:NATURALGIFT],
			[36,:GIGADRAIN],
			[38,:ANCIENTPOWER],
			[41,:SLAM],
			[44,:TICKLE],
			[46,:WRINGOUT],
			[48,:GRASSYTERRAIN],
			[50,:POWERWHIP]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BIDE,:BIND,:BODYSLAM,:BULLETSEED,:CURSE,:CUT,:DOUBLEEDGE,:ENDEAVOR,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:INFESTATION,:KNOCKOFF,:LEAFSTORM,:MEGADRAIN,:MIMIC,:NATUREPOWER,:PAINSPLIT,:POWERSWAP,:POWERWHIP,:PSYCHUP,:RAGE,:REFLECT,:ROCKSMASH,:SEEDBOMB,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:WORRYSEED,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWHOLD,],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 10,
		:Weight => 350,
		:kind => "Vine",
		:dexentry => "Its vines snap off easily and painlessly if they are grabbed, allowing it to make a quick getaway. The lost vines are replaced by new growth the next day.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TANGROWTH,:HasMove,:ANCIENTPOWER]
		]
	},

	:OnCreation => {},
},

:KANGASKHAN => {
	"Normal Form" => {
		:name => "Kangaskhan",
		:dexnum => 115,
		:Type1 => :NORMAL,
		:BaseStats => [105, 95, 80, 40, 80, 90],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:EARLYBIRD, :SCRAPPY],
		:HiddenAbilities => :INNERFOCUS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 172,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CIRCLETHROW,:COUNTER,:CRUSHCLAW,:DISABLE,:DOUBLEEDGE,:ENDEAVOR,:FOCUSENERGY,:FOCUSPUNCH,:FORESIGHT,:HAMMERARM,:STOMP,:TRUMPCARD,:UPROAR,],
		:Moveset => [
			[1,:COMETPUNCH],
			[1,:LEER],
			[7,:FAKEOUT],
			[10,:TAILWHIP],
			[13,:BITE],
			[19,:DOUBLEHIT],
			[22,:RAGE],
			[25,:MEGAPUNCH],
			[31,:CHIPAWAY],
			[34,:DIZZYPUNCH],
			[37,:CRUNCH],
			[43,:ENDURE],
			[46,:OUTRAGE],
			[49,:SUCKERPUNCH],
			[50,:REVERSAL]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:ASSURANCE,:AVALANCHE,:BEATUP,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:COVET,:CRUNCH,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:EARTHQUAKE,:ENDEAVOR,:FAKEOUT,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:LASTRESORT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RETALIATE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SOLARBEAM,:SPITE,:STRENGTH,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:SURF,:TAKEDOWN,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWMIST,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Monster],
		:Height => 22,
		:Weight => 800,
		:kind => "Parent",
		:dexentry => "If you come across a young Kangaskhan playing by itself, never try to catch it. The baby's parent is sure to be in the area, and it will become violently enraged.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [105, 125, 100, 60, 100, 100],
		:Abilities => [:PARENTALBOND],
		:Weight => 1000,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:KANGASKHANITE => 1,
	},
},

:HORSEA => {
	"Normal Form" => {
		:name => "Horsea",
		:dexnum => 116,
		:Type1 => :WATER,
		:BaseStats => [30, 40, 70, 70, 25, 60],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:SWIFTSWIM, :SNIPER],
		:HiddenAbilities => :DAMP,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 59,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AURORABEAM,:CLEARSMOG,:DISABLE,:DRAGONRAGE,:DRAGONBREATH,:FLAIL,:MUDDYWATER,:OCTAZOOKA,:OUTRAGE,:RAZORWIND,:SIGNALBEAM,:SPLASH,:WATERPULSE,],
		:Moveset => [
			[1,:BUBBLE],
			[5,:SMOKESCREEN],
			[9,:LEER],
			[13,:WATERGUN],
			[17,:TWISTER],
			[21,:BUBBLEBEAM],
			[26,:FOCUSENERGY],
			[31,:BRINE],
			[36,:AGILITY],
			[41,:DRAGONPULSE],
			[46,:DRAGONDANCE],
			[52,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:BIDE,:BLIZZARD,:BOUNCE,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:FLASHCANNON,:FLIPTURN,:FOCUSENERGY,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:LASERFOCUS,:LIQUIDATION,:MIMIC,:MUDDYWATER,:OUTRAGE,:RAGE,:RAINDANCE,:RAZORWIND,:SCALD,:SCALESHOT,:SIGNALBEAM,:SKULLBASH,:SURF,:SWIFT,:TAKEDOWN,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Dragon],
		:Height => 4,
		:Weight => 80,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "By cleverly flicking the fins on its back side to side, it moves in any direction while facing forward. It spits ink to escape if it senses danger.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 13,
		:evolutions => [
			[:SEADRA,:Level,32]
		]
	},

	:OnCreation => {},
},

:SEADRA => {
	"Normal Form" => {
		:name => "Seadra",
		:dexnum => 117,
		:Type1 => :WATER,
		:BaseStats => [55, 65, 95, 95, 45, 85],
		:EVs => [0, 0, 1, 1, 0, 0],
		:Abilities => [:POISONPOINT, :SNIPER],
		:HiddenAbilities => :DAMP,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 154,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :HORSEA,
			:form => 0
		},
		:Moveset => [
			[1,:HYDROPUMP],
			[1,:BUBBLE],
			[1,:SMOKESCREEN],
			[1,:LEER],
			[1,:WATERGUN],
			[5,:SMOKESCREEN],
			[9,:LEER],
			[13,:WATERGUN],
			[17,:TWISTER],
			[21,:BUBBLEBEAM],
			[26,:FOCUSENERGY],
			[31,:BRINE],
			[38,:AGILITY],
			[45,:DRAGONPULSE],
			[52,:DRAGONDANCE],
			[60,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:BIDE,:BLIZZARD,:BOUNCE,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:FLASHCANNON,:FLIPTURN,:FOCUSENERGY,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LASERFOCUS,:LIQUIDATION,:MIMIC,:MUDDYWATER,:OUTRAGE,:RAGE,:RAINDANCE,:RAZORWIND,:SCALD,:SCALESHOT,:SIGNALBEAM,:SKULLBASH,:SURF,:SWIFT,:TAKEDOWN,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Dragon],
		:Height => 12,
		:Weight => 250,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "The poisonous barbs over its body are highly valued as ingredients for traditional herbal medicine. It shows no mercy to anything approaching its nest.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 11,
		:evolutions => [
			[:KINGDRA,:TradeItem,:DRAGONSCALE]
		]
	},

	:OnCreation => {},
},

:GOLDEEN => {
	"Normal Form" => {
		:name => "Goldeen",
		:dexnum => 118,
		:Type1 => :WATER,
		:BaseStats => [45, 67, 60, 35, 50, 63],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :WATERVEIL],
		:HiddenAbilities => :LIGHTNINGROD,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 64,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUATAIL,:BODYSLAM,:HAZE,:HYDROPUMP,:MUDSHOT,:MUDSPORT,:MUDSLAP,:PSYBEAM,:SIGNALBEAM,:SKULLBASH,:SLEEPTALK,],
		:Moveset => [
			[1,:PECK],
			[1,:TAILWHIP],
			[1,:WATERSPORT],
			[5,:SUPERSONIC],
			[8,:HORNATTACK],
			[13,:FLAIL],
			[16,:WATERPULSE],
			[21,:AQUARING],
			[24,:FURYATTACK],
			[29,:AGILITY],
			[32,:WATERFALL],
			[37,:HORNDRILL],
			[40,:SOAK],
			[45,:MEGAHORN]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRILLRUN,:FLIPTURN,:FURYCUTTER,:HAIL,:HEADBUTT,:HORNDRILL,:HYDROPUMP,:ICEBEAM,:ICYWIND,:KNOCKOFF,:MEGAHORN,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:SCALD,:SCALESHOT,:SIGNALBEAM,:SKULLBASH,:SMARTSTRIKE,:SURF,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THROATCHOP,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2],
		:Height => 6,
		:Weight => 150,
		:WildItemUncommon => :MYSTICWATER,
		:kind => "Goldfish",
		:dexentry => "In the springtime, schools of Goldeen can be seen swimming up falls and rivers. It metes out staggering damage with its single horn.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 11,
		:evolutions => [
			[:SEAKING,:Level,33]
		]
	},

	:OnCreation => {},
},

:SEAKING => {
	"Normal Form" => {
		:name => "Seaking",
		:dexnum => 119,
		:Type1 => :WATER,
		:BaseStats => [80, 92, 65, 65, 80, 68],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :WATERVEIL],
		:HiddenAbilities => :LIGHTNINGROD,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GOLDEEN,
			:form => 0
		},
		:Moveset => [
			[1,:MEGAHORN],
			[1,:POISONJAB],
			[1,:PECK],
			[1,:TAILWHIP],
			[1,:WATERSPORT],
			[1,:SUPERSONIC],
			[5,:SUPERSONIC],
			[8,:HORNATTACK],
			[13,:FLAIL],
			[16,:WATERPULSE],
			[21,:AQUARING],
			[24,:FURYATTACK],
			[29,:AGILITY],
			[32,:WATERFALL],
			[40,:HORNDRILL],
			[46,:SOAK],
			[54,:MEGAHORN]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRILLRUN,:FLIPTURN,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:KNOCKOFF,:MEGAHORN,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:POISONJAB,:RAGE,:RAINDANCE,:SCALD,:SCALESHOT,:SIGNALBEAM,:SKULLBASH,:SMARTSTRIKE,:SURF,:SWIFT,:SWORDSDANCE,:TAKEDOWN,:THROATCHOP,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2],
		:Height => 13,
		:Weight => 390,
		:WildItemUncommon => :MYSTICWATER,
		:kind => "Goldfish",
		:dexentry => "It punches holes in boulders on stream- beds. This is a clever innovation that prevents its eggs from being attacked or washed away by the current.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:STARYU => {
	"Normal Form" => {
		:name => "Staryu",
		:dexnum => 120,
		:Type1 => :WATER,
		:BaseStats => [30, 45, 55, 70, 55, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:ILLUMINATE, :NATURALCURE],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 68,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:TACKLE],
			[1,:HARDEN],
			[4,:WATERGUN],
			[7,:RAPIDSPIN],
			[10,:RECOVER],
			[13,:PSYWAVE],
			[16,:SWIFT],
			[18,:BUBBLEBEAM],
			[22,:CAMOUFLAGE],
			[24,:GYROBALL],
			[28,:BRINE],
			[31,:MINIMIZE],
			[35,:REFLECTTYPE],
			[37,:POWERGEM],
			[40,:CONFUSERAY],
			[42,:PSYCHIC],
			[46,:LIGHTSCREEN],
			[49,:COSMICPOWER],
			[53,:HYDROPUMP]],
		:compatiblemoves => [:BIDE,:BLIZZARD,:BRINE,:BUBBLEBEAM,:COSMICPOWER,:CURSE,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:FLASH,:FLASHCANNON,:FLIPTURN,:GRAVITY,:GYROBALL,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:PAINSPLIT,:POWERGEM,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLLOUT,:SCALD,:SIGNALBEAM,:SKULLBASH,:SURF,:SWIFT,:TAKEDOWN,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Brown",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 8,
		:Weight => 345,
		:WildItemCommon => :STARDUST,
		:WildItemUncommon => :STARPIECE,
		:kind => "Star Shape",
		:dexentry => "It gathers with others in the night and makes its red core glow on and off with the twinkling stars. It can regenerate limbs if they are severed from its body.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:STARMIE,:Item,:WATERSTONE]
		]
	},

	:OnCreation => {},
},

:STARMIE => {
	"Normal Form" => {
		:name => "Starmie",
		:dexnum => 121,
		:Type1 => :WATER,
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 75, 85, 100, 85, 115],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:ILLUMINATE, :NATURALCURE],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 182,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :STARYU,
			:form => 0
		},
		:Moveset => [
			[1,:HYDROPUMP],
			[1,:SPOTLIGHT],
			[1,:WATERGUN],
			[1,:RAPIDSPIN],
			[1,:RECOVER],
			[1,:SWIFT],
			[40,:CONFUSERAY]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:AVALANCHE,:BIDE,:BLIZZARD,:BRINE,:BUBBLEBEAM,:COSMICPOWER,:CURSE,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:DREAMEATER,:EXPANDINGFORCE,:FLASH,:FLASHCANNON,:FLIPTURN,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GYROBALL,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LIGHTSCREEN,:MAGICCOAT,:METEORBEAM,:MIMIC,:NIGHTMARE,:PAINSPLIT,:POWERGEM,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLLOUT,:SCALD,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWSTORM,:SHADOWMIST,:SHADOWBREAK,],
		:Color => "Purple",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 11,
		:Weight => 800,
		:WildItemCommon => :STARDUST,
		:WildItemUncommon => :STARPIECE,
		:kind => "Mysterious",
		:dexentry => "People in ancient times imagined that Starmie were transformed from the reflections of stars that twinkled on gentle waves at night.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MRMIME => {
	"Normal Form" => {
		:name => "Mr. Mime",
		:dexnum => 122,
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:BaseStats => [40, 45, 65, 100, 120, 90],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SOUNDPROOF, :FILTER],
		:HiddenAbilities => :TECHNICIAN,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:CONFUSERAY,:FAKEOUT,:FUTURESIGHT,:HYPNOSIS,:ICYWIND,:MAGICROOM,:MIMIC,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:TEETERDANCE,:TRICK,:WAKEUPSLAP,],
		:preevo => {
			:species => :MIMEJR,
			:form => 0
		},
		:Moveset => [
			[1,:MISTYTERRAIN],
			[1,:MAGICALLEAF],
			[1,:QUICKGUARD],
			[1,:WIDEGUARD],
			[1,:POWERSWAP],
			[1,:GUARDSWAP],
			[1,:BARRIER],
			[1,:POUND],
			[1,:CONFUSION],
			[4,:COPYCAT],
			[8,:MEDITATE],
			[11,:DOUBLESLAP],
			[15,:MIMIC],
			[15,:PSYWAVE],
			[18,:ENCORE],
			[22,:LIGHTSCREEN],
			[22,:REFLECT],
			[25,:PSYBEAM],
			[29,:SUBSTITUTE],
			[32,:RECYCLE],
			[36,:TRICK],
			[39,:PSYCHIC],
			[43,:ROLEPLAY],
			[46,:BATONPASS],
			[50,:SAFEGUARD]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:BATONPASS,:BIDE,:BODYSLAM,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FAKEOUT,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:HYPNOSIS,:ICEPUNCH,:ICYWIND,:INFESTATION,:IRONDEFENSE,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MISTYTERRAIN,:MUDSLAP,:MYSTICALFIRE,:NASTYPLOT,:NIGHTMARE,:PAYBACK,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SOLARBEAM,:STOREDPOWER,:SUBMISSION,:SUCKERPUNCH,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWSHED,],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 13,
		:Weight => 545,
		:kind => "Barrier",
		:dexentry => "A Mr. Mime is a master of pantomime. It can convince others that something unseeable exists. Once believed, the imaginary object becomes real.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :ICE,
		:Type2 => :PSYCHIC,
		:BaseStats => [50, 65, 65, 90, 90, 100],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:VITALSPIRIT, :SCREENCLEANER, :ICEBODY],
		:EggMoves => [:CONFUSERAY,:FAKEOUT,:POWERSPLIT,:TICKLE,],
		:Moveset => [
			[1,:BATONPASS],
			[1,:COPYCAT],
			[1,:DAZZLINGGLEAM],
			[1,:ENCORE],
			[1,:ICESHARD],
			[1,:LIGHTSCREEN],
			[1,:MIMIC],
			[1,:MISTYTERRAIN],
			[1,:POUND],
			[1,:PROTECT],
			[1,:RAPIDSPIN],
			[1,:RECYCLE],
			[1,:REFLECT],
			[1,:ROLEPLAY],
			[1,:SAFEGUARD],
			[12,:CONFUSION],
			[16,:ALLYSWITCH],
			[20,:ICYWIND],
			[24,:DOUBLEKICK],
			[28,:PSYBEAM],
			[32,:HYPNOSIS],
			[36,:MIRRORCOAT],
			[40,:SUCKERPUNCH],
			[44,:FREEZEDRY],
			[48,:PSYCHIC],
			[52,:TEETERDANCE],
		],
		:compatiblemoves => [:ALLYSWITCH,:AVALANCHE,:BATONPASS,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:DAZZLINGGLEAM,:DRAINPUNCH,:DREAMEATER,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FAKEOUT,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HAIL,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:HYPNOSIS,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:INFESTATION,:IRONDEFENSE,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MISTYTERRAIN,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SOLARBEAM,:STOMPINGTANTRUM,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:TRIPLEAXEL,:UPROAR,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Height => 14,
		:Weight => 568,
		:dexentry => "Its talent is tap-dancing. It can also manipulate temperatures to create a floor of ice, which this Pokémon can kick up to use as a barrier.",
		:evolutions => [
			[:MRRIME,:Level,42]
		]
	},

	:OnCreation => {},
},

:SCYTHER => {
	"Normal Form" => {
		:name => "Scyther",
		:dexnum => 123,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [70, 110, 80, 55, 80, 105],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SWARM, :TECHNICIAN],
		:HiddenAbilities => :STEADFAST,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 100,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BATONPASS,:BUGBUZZ,:COUNTER,:DEFOG,:ENDURE,:NIGHTSLASH,:QUICKGUARD,:RAZORWIND,:REVERSAL,:SILVERWIND,:STEELWING,],
		:Moveset => [
			[1,:VACUUMWAVE],
			[1,:QUICKATTACK],
			[1,:LEER],
			[5,:FOCUSENERGY],
			[9,:PURSUIT],
			[13,:FALSESWIPE],
			[17,:AGILITY],
			[21,:WINGATTACK],
			[25,:FURYCUTTER],
			[29,:SLASH],
			[33,:RAZORWIND],
			[37,:DOUBLETEAM],
			[41,:XSCISSOR],
			[45,:NIGHTSLASH],
			[49,:DOUBLEHIT],
			[53,:AIRSLASH],
			[57,:SWORDSDANCE],
			[61,:FEINT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRSLASH,:ASSURANCE,:BATONPASS,:BIDE,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BUGBUZZ,:CALMMIND,:CLOSECOMBAT,:COUNTER,:CROSSPOISON,:CURSE,:CUT,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FALSESWIPE,:FOCUSENERGY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:OMINOUSWIND,:PSYCHOCUT,:RAGE,:RAINDANCE,:RAZORWIND,:REVERSAL,:ROCKSMASH,:ROOST,:SAFEGUARD,:SILVERWIND,:SKULLBASH,:STEELWING,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAKEDOWN,:THIEF,:UTURN,:VACUUMWAVE,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWMIST,],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Bug],
		:Height => 15,
		:Weight => 560,
		:kind => "Mantis",
		:dexentry => "Its blindingly fast speed adds to the sharpness of its twin forearm scythes. The scythes can slice through thick logs in one wicked stroke.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SCIZOR,:TradeItem,:METALCOAT]
		]
	},

	:OnCreation => {},
},

:JYNX => {
	"Normal Form" => {
		:name => "Jynx",
		:dexnum => 124,
		:Type1 => :ICE,
		:Type2 => :PSYCHIC,
		:BaseStats => [65, 50, 35, 115, 95, 95],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:OBLIVIOUS, :FOREWARN],
		:HiddenAbilities => :DRYSKIN,
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :SMOOCHUM,
			:form => 0
		},
		:Moveset => [
			[1,:DRAININGKISS],
			[1,:PERISHSONG],
			[1,:POUND],
			[1,:LICK],
			[1,:LOVELYKISS],
			[1,:POWDERSNOW],
			[5,:LICK],
			[8,:LOVELYKISS],
			[11,:POWDERSNOW],
			[15,:DOUBLESLAP],
			[18,:ICEPUNCH],
			[21,:HEARTSTAMP],
			[25,:MEANLOOK],
			[28,:FAKETEARS],
			[33,:WAKEUPSLAP],
			[39,:AVALANCHE],
			[44,:BODYSLAM],
			[49,:WRINGOUT],
			[55,:PERISHSONG],
			[60,:BLIZZARD]],
		:compatiblemoves => [:ALLYSWITCH,:AURORAVEIL,:AVALANCHE,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:CALMMIND,:CHARM,:COUNTER,:COVET,:CURSE,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ECHOEDVOICE,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FAKEOUT,:FAKETEARS,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FROSTBREATH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYBACK,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:STOREDPOWER,:SUBMISSION,:SWEETSCENT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THIEF,:TORMENT,:TRICK,:TRICKROOM,:TRIPLEAXEL,:UPROAR,:WATERGUN,:WATERPULSE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 14,
		:Weight => 406,
		:kind => "Human Shape",
		:dexentry => "A Jynx sashays rhythmically as if it were dancing. Its motions are so bouncingly alluring, people seeing it are compelled to shake their hips without noticing.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ELECTABUZZ => {
	"Normal Form" => {
		:name => "Electabuzz",
		:dexnum => 125,
		:Type1 => :ELECTRIC,
		:BaseStats => [65, 83, 57, 95, 85, 105],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:STATIC, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 172,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :ELEKID,
			:form => 0
		},
		:Moveset => [
			[1,:QUICKATTACK],
			[1,:LEER],
			[1,:THUNDERSHOCK],
			[5,:THUNDERSHOCK],
			[8,:LOWKICK],
			[12,:SWIFT],
			[15,:SHOCKWAVE],
			[19,:THUNDERWAVE],
			[22,:ELECTROBALL],
			[26,:LIGHTSCREEN],
			[29,:THUNDERPUNCH],
			[36,:DISCHARGE],
			[42,:SCREECH],
			[49,:THUNDERBOLT],
			[55,:THUNDER]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:CHARGEBEAM,:COUNTER,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:ELECTROBALL,:ELECTROWEB,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:IRONTAIL,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:ROCKCLIMB,:ROCKSMASH,:SCREECH,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:STRENGTH,:SUBMISSION,:SWIFT,:TAKEDOWN,:TAUNT,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWMIST,:SHADOWHALF,:SHADOWBREAK,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:HumanLike],
		:Height => 11,
		:Weight => 300,
		:WildItemUncommon => :ELECTIRIZER,
		:kind => "Electric",
		:dexentry => "Electricity permeates its body. It swings its arms round and round to charge up electricity before unleashing a punch.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ELECTIVIRE,:TradeItem,:ELECTIRIZER]
		]
	},

	:OnCreation => {},
},

:MAGMAR => {
	"Normal Form" => {
		:name => "Magmar",
		:dexnum => 126,
		:Type1 => :FIRE,
		:BaseStats => [65, 95, 57, 100, 85, 93],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:FLAMEBODY, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :MAGBY,
			:form => 0
		},
		:Moveset => [
			[1,:SMOG],
			[1,:LEER],
			[1,:EMBER],
			[5,:EMBER],
			[8,:SMOKESCREEN],
			[12,:FEINTATTACK],
			[15,:FIRESPIN],
			[19,:CLEARSMOG],
			[22,:FLAMEBURST],
			[26,:CONFUSERAY],
			[29,:FIREPUNCH],
			[36,:LAVAPLUME],
			[42,:SUNNYDAY],
			[49,:FLAMETHROWER],
			[55,:FIREBLAST]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:BURNINGJEALOUSY,:COUNTER,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:FEINTATTACK,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:INCINERATE,:IRONTAIL,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:OVERHEAT,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:ROCKCLIMB,:ROCKSMASH,:SCARYFACE,:SCORCHINGSANDS,:SCREECH,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TELEPORT,:THIEF,:THUNDERPUNCH,:UPROAR,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWRUSH,:SHADOWSHED,],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 13,
		:Weight => 445,
		:WildItemUncommon => :MAGMARIZER,
		:kind => "Spitfire",
		:dexentry => "It blows out intense flames from all over its body to intimidate its foe. These fiery bursts create heat waves that ignite grass and trees in the area.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MAGMORTAR,:TradeItem,:MAGMARIZER]
		]
	},

	:OnCreation => {},
},

:PINSIR => {
	"Normal Form" => {
		:name => "Pinsir",
		:dexnum => 127,
		:Type1 => :BUG,
		:BaseStats => [65, 125, 100, 55, 70, 85],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :MOLDBREAKER],
		:HiddenAbilities => :MOXIE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BUGBITE,:CLOSECOMBAT,:FEINTATTACK,:FEINT,:FLAIL,:FURYATTACK,:MEFIRST,:QUICKATTACK,:SUPERPOWER,],
		:Moveset => [
			[1,:VICEGRIP],
			[1,:FOCUSENERGY],
			[4,:BIND],
			[8,:SEISMICTOSS],
			[11,:HARDEN],
			[15,:REVENGE],
			[18,:VITALTHROW],
			[22,:DOUBLEHIT],
			[26,:BRICKBREAK],
			[29,:XSCISSOR],
			[33,:SUBMISSION],
			[36,:STORMTHROW],
			[40,:SWORDSDANCE],
			[43,:THRASH],
			[47,:SUPERPOWER],
			[50,:GUILLOTINE]],
		:compatiblemoves => [:BIDE,:BIND,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:EARTHQUAKE,:FALSESWIPE,:FEINTATTACK,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HIGHHORSEPOWER,:HYPERBEAM,:IRONDEFENSE,:KNOCKOFF,:MIMIC,:OUTRAGE,:RAGE,:RAINDANCE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THROATCHOP,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBREAK,:SHADOWSHED,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 15,
		:Weight => 550,
		:kind => "Stag Beetle",
		:dexentry => "Their pincers are strong enough to shatter thick logs. Because they dislike cold, Pinsir burrow and sleep under the ground on chilly nights.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :FLYING,
		:BaseStats => [65, 155, 120, 65, 90, 105],
		:Abilities => [:AERILATE],
		:Weight => 590,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:PINSIRITE => 1,
	},
},

:TAUROS => {
	"Normal Form" => {
		:name => "Tauros",
		:dexnum => 128,
		:Type1 => :NORMAL,
		:BaseStats => [75, 100, 95, 40, 70, 110],
		:EVs => [0, 1, 0, 0, 0, 1],
		:Abilities => [:INTIMIDATE, :ANGERPOINT],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemZero,
		:BaseEXP => 172,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:TACKLE],
			[3,:TAILWHIP],
			[5,:RAGE],
			[8,:HORNATTACK],
			[11,:SCARYFACE],
			[15,:PURSUIT],
			[19,:REST],
			[24,:PAYBACK],
			[29,:WORKUP],
			[35,:TAKEDOWN],
			[41,:ZENHEADBUTT],
			[48,:SWAGGER],
			[55,:THRASH],
			[63,:DOUBLEEDGE],
			[71,:GIGAIMPACT]],
		:compatiblemoves => [:ASSURANCE,:BIDE,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CLOSECOMBAT,:CURSE,:DOUBLEEDGE,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FISSURE,:FLAMETHROWER,:FOCUSENERGY,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HIGHHORSEPOWER,:HORNDRILL,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASHOUT,:MEGAHORN,:MIMIC,:OUTRAGE,:PAYBACK,:RAGE,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SANDSTORM,:SCARYFACE,:SHOCKWAVE,:SKULLBASH,:SMARTSTRIKE,:SOLARBEAM,:SPITE,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SURF,:TAKEDOWN,:THROATCHOP,:THUNDER,:THUNDERBOLT,:UPROAR,:WATERPULSE,:WHIRLPOOL,:WILDCHARGE,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWHOLD,:SHADOWSHED,:SHADOWRUSH,:SHADOWSKY,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 14,
		:Weight => 884,
		:kind => "Wild Bull",
		:dexentry => "It is not satisfied unless it is rampaging at all times. If there is no opponent for Tauros to battle, it will charge at thick trees and knock them down to calm itself.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MAGIKARP => {
	"Normal Form" => {
		:name => "Magikarp",
		:dexnum => 129,
		:Type1 => :WATER,
		:BaseStats => [20, 10, 55, 15, 20, 80],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :RATTLED],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 40,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 1530,
		:Moveset => [
			[1,:SPLASH],
			[15,:TACKLE],
			[30,:FLAIL]],
		:compatiblemoves => [:BOUNCE,:CELEBRATE,:HAPPYHOUR,:HYDROPUMP,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2, :Dragon],
		:Height => 9,
		:Weight => 100,
		:kind => "Fish",
		:dexentry => "Its swimming muscles are weak, so it is easily washed away. In places where water pools, you can see many Magikarp deposited there by the flow.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 10,
		:evolutions => [
			[:GYARADOS,:Level,20]
		]
	},

	:OnCreation => {},
},

:GYARADOS => {
	"Normal Form" => {
		:name => "Gyarados",
		:dexnum => 130,
		:Type1 => :WATER,
		:Type2 => :FLYING,
		:BaseStats => [95, 125, 79, 60, 100, 81],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :MOXIE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 189,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 1530,
		:preevo => {
			:species => :MAGIKARP,
			:form => 0
		},
		:Moveset => [
			[0,:BITE],
			[1,:THRASH],
			[21,:LEER],
			[24,:TWISTER],
			[27,:ICEFANG],
			[30,:AQUATAIL],
			[33,:SCARYFACE],
			[36,:DRAGONRAGE],
			[39,:CRUNCH],
			[42,:HYDROPUMP],
			[45,:DRAGONDANCE],
			[48,:HURRICANE],
			[51,:RAINDANCE],
			[54,:HYPERBEAM]],
		:compatiblemoves => [:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRINE,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:CELEBRATE,:CRUNCH,:CURSE,:DARKPULSE,:DIVE,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:EARTHQUAKE,:FIREBLAST,:FLAMETHROWER,:FOCUSENERGY,:GIGAIMPACT,:HAIL,:HAPPYHOUR,:HEADBUTT,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASHOUT,:MIMIC,:MUDDYWATER,:OUTRAGE,:PAYBACK,:POWERWHIP,:RAGE,:RAINDANCE,:REFLECT,:ROAR,:ROCKSMASH,:SANDSTORM,:SCALD,:SCALESHOT,:SCARYFACE,:SKULLBASH,:SPITE,:STONEEDGE,:STRENGTH,:SURF,:TAKEDOWN,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TWISTER,:UPROAR,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2, :Dragon],
		:Height => 65,
		:Weight => 2350,
		:kind => "Atrocious",
		:dexentry => "It is an extremely vicious and violent Pokémon. When humans begin to fight, it will appear and burn everything to the ground with intensely hot flames.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 2,
	},

	"Mega Form" => {
		:Type2 => :DARK,
		:BaseStats => [95, 155, 109, 70, 130, 81],
		:Abilities => [:MOLDBREAKER],
		:Weight => 3050,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GYARADOSITE => 1,
	},
},

:LAPRAS => {
	"Normal Form" => {
		:name => "Lapras",
		:dexnum => 131,
		:Type1 => :WATER,
		:Type2 => :ICE,
		:BaseStats => [130, 85, 80, 85, 95, 60],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:WATERABSORB, :SHELLARMOR],
		:HiddenAbilities => :HYDRATION,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 187,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:CURSE,:DRAGONDANCE,:DRAGONPULSE,:FISSURE,:FORESIGHT,:FUTURESIGHT,:FREEZEDRY,:HORNDRILL,:REFRESH,:SLEEPTALK,:TICKLE,:WHIRLPOOL,],
		:Moveset => [
			[1,:SING],
			[1,:GROWL],
			[1,:WATERGUN],
			[4,:MIST],
			[7,:CONFUSERAY],
			[10,:ICESHARD],
			[14,:WATERPULSE],
			[18,:BODYSLAM],
			[22,:RAINDANCE],
			[27,:PERISHSONG],
			[32,:ICEBEAM],
			[37,:BRINE],
			[43,:SAFEGUARD],
			[47,:HYDROPUMP],
			[50,:SHEERCOLD]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRINE,:BUBBLEBEAM,:BULLDOZE,:CHARM,:CURSE,:DIVE,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DREAMEATER,:DRILLRUN,:ECHOEDVOICE,:FISSURE,:FROSTBREATH,:FUTURESIGHT,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONHEAD,:IRONTAIL,:LIQUIDATION,:MEGAHORN,:MIMIC,:NIGHTMARE,:OUTRAGE,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:REFLECT,:ROAR,:ROCKSMASH,:SAFEGUARD,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SMARTSTRIKE,:SOLARBEAM,:STRENGTH,:SURF,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:WATERFALL,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSTORM,:SHADOWSHED,:SHADOWSKY,],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Monster, :Water1],
		:Height => 25,
		:Weight => 2200,
		:WildItemCommon => :MYSTICWATER,
		:WildItemUncommon => :MYSTICWATER,
		:WildItemRare => :MYSTICWATER,
		:kind => "Transport",
		:dexentry => "People have driven Lapras almost to the point of extinction. In the evenings, it is said to sing plaintively as it seeks what few others of its kind still remain.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:DITTO => {
	"Normal Form" => {
		:name => "Ditto",
		:dexnum => 132,
		:Type1 => :NORMAL,
		:BaseStats => [48, 48, 48, 48, 48, 48],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:LIMBER, :IMPOSTER],
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 101,
		:CatchRate => 35,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:TRANSFORM]],
		:compatiblemoves => [],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [],
		:Height => 3,
		:Weight => 40,
		:WildItemCommon => :QUICKPOWDER,
		:WildItemUncommon => :METALPOWDER,
		:kind => "Transform",
		:dexentry => "A Ditto rearranges its cell structure to transform itself. However, if it tries to change based on its memory, it will get details wrong.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:EEVEE => {
	"Normal Form" => {
		:name => "Eevee",
		:dexnum => 133,
		:Type1 => :NORMAL,
		:BaseStats => [55, 55, 50, 45, 65, 55],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:RUNAWAY, :ADAPTABILITY],
		:HiddenAbilities => :ANTICIPATION,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 65,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:EggMoves => [:CAPTIVATE,:CHARM,:COVET,:CURSE,:DETECT,:ENDURE,:FAKETEARS,:FLAIL,:NATURALGIFT,:STOREDPOWER,:SYNCHRONOISE,:TICKLE,:WISH,:YAWN,],
		:Moveset => [
			[1,:COVET],
			[1,:HELPINGHAND],
			[1,:GROWL],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:BITE],
			[17,:SWIFT],
			[20,:REFRESH],
			[25,:TAKEDOWN],
			[29,:CHARM],
			[33,:BATONPASS],
			[37,:DOUBLEEDGE],
			[41,:LASTRESORT],
			[45,:TRUMPCARD]],
		:compatiblemoves => [:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:CALMMIND,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FAKETEARS,:FOCUSENERGY,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:MIMIC,:MUDSLAP,:PAYDAY,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:SHADOWBALL,:SKULLBASH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAKEDOWN,:WEATHERBALL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 3,
		:Weight => 65,
		:kind => "Evolution",
		:dexentry => "An Eevee has an unstable genetic makeup that suddenly mutates due to its environment. Radiation from various stones causes this Pokémon to evolve.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VAPOREON,:Item,:WATERSTONE],
			[:JOLTEON,:Item,:THUNDERSTONE],
			[:FLAREON,:Item,:FIRESTONE],
			[:LEAFEON,:Item,:LEAFSTONE],
			[:GLACEON,:Item,:ICESTONE],
			[:LEAFEON,:Location,62],
			[:GLACEON,:Location,26],
			[:SYLVEON,:Affection,:FAIRY],
			[:ESPEON,:HappinessDay,0],
			[:UMBREON,:HappinessNight,0]
		]
	},

	:OnCreation => {},
},

:VAPOREON => {
	"Normal Form" => {
		:name => "Vaporeon",
		:dexnum => 134,
		:Type1 => :WATER,
		:BaseStats => [130, 65, 60, 110, 95, 65],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:WATERABSORB, :WATERABSORB],
		:HiddenAbilities => :HYDRATION,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:WATERGUN],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:WATERPULSE],
			[20,:AURORABEAM],
			[25,:AQUARING],
			[29,:ACIDARMOR],
			[33,:HAZE],
			[37,:MUDDYWATER],
			[41,:LASTRESORT],
			[45,:HYDROPUMP]],
		:compatiblemoves => [:AQUATAIL,:BABYDOLLEYES,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CALMMIND,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DIVE,:DOUBLEEDGE,:ECHOEDVOICE,:FAKETEARS,:FLIPTURN,:FOCUSENERGY,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIQUIDATION,:MIMIC,:MUDDYWATER,:MUDSLAP,:PAYDAY,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKSMASH,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:WATERFALL,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 290,
		:kind => "Bubble Jet",
		:dexentry => "Vaporeon underwent a spontaneous mutation and grew fins and gills that allow them to live underwater. They have the ability to freely control water.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:JOLTEON => {
	"Normal Form" => {
		:name => "Jolteon",
		:dexnum => 135,
		:Type1 => :ELECTRIC,
		:BaseStats => [65, 65, 60, 110, 95, 130],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:VOLTABSORB, :VOLTABSORB],
		:HiddenAbilities => :QUICKFEET,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:THUNDERSHOCK],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:DOUBLEKICK],
			[20,:THUNDERFANG],
			[25,:PINMISSILE],
			[29,:AGILITY],
			[33,:THUNDERWAVE],
			[37,:DISCHARGE],
			[41,:LASTRESORT],
			[45,:THUNDER]],
		:compatiblemoves => [:AGILITY,:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:ELECTROBALL,:FAKETEARS,:FLASH,:FOCUSENERGY,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGNETRISE,:MIMIC,:MUDSLAP,:PAYDAY,:PINMISSILE,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:RISINGVOLTAGE,:ROAR,:ROCKSMASH,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:VOLTSWITCH,:WEATHERBALL,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 245,
		:kind => "Lightning",
		:dexentry => "Its cells generate weak power that is amplified by its fur's static electricity to drop thunderbolts. The bristling fur is made of electrically charged needles.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:FLAREON => {
	"Normal Form" => {
		:name => "Flareon",
		:dexnum => 136,
		:Type1 => :FIRE,
		:BaseStats => [65, 130, 60, 95, 110, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:FLASHFIRE, :FLASHFIRE],
		:HiddenAbilities => :GUTS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:EMBER],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:BITE],
			[20,:FIREFANG],
			[25,:FIRESPIN],
			[29,:SCARYFACE],
			[33,:SMOG],
			[37,:LAVAPLUME],
			[41,:LASTRESORT],
			[45,:FLAREBLITZ]],
		:compatiblemoves => [:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:BURNINGJEALOUSY,:CALMMIND,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FAKETEARS,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FOCUSENERGY,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OVERHEAT,:PAYDAY,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKSMASH,:SCARYFACE,:SCORCHINGSANDS,:SHADOWBALL,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAKEDOWN,:WEATHERBALL,:WILLOWISP,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 250,
		:kind => "Flame",
		:dexentry => "Flareon's fluffy fur releases heat into the air so that its body does not get excessively hot. Its body temperature can rise to a maximum of 1,650 degrees F.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PORYGON => {
	"Normal Form" => {
		:name => "Porygon",
		:dexnum => 137,
		:Type1 => :NORMAL,
		:BaseStats => [65, 60, 70, 85, 75, 40],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:TRACE, :DOWNLOAD],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 79,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:CONVERSION2],
			[1,:TACKLE],
			[1,:CONVERSION],
			[1,:SHARPEN],
			[7,:PSYBEAM],
			[12,:AGILITY],
			[18,:RECOVER],
			[23,:MAGNETRISE],
			[29,:SIGNALBEAM],
			[34,:RECYCLE],
			[40,:DISCHARGE],
			[45,:LOCKON],
			[50,:TRIATTACK],
			[56,:MAGICCOAT],
			[62,:ZAPCANNON]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BIDE,:BLIZZARD,:CHARGEBEAM,:CURSE,:DOUBLEEDGE,:DREAMEATER,:EERIEIMPULSE,:ELECTROWEB,:FLASH,:FOULPLAY,:GIGAIMPACT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:MAGICCOAT,:MAGNETRISE,:MIMIC,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:SOLARBEAM,:SPEEDSWAP,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:Mineral],
		:Height => 8,
		:Weight => 365,
		:kind => "Virtual",
		:dexentry => "It is capable of reverting itself entirely back to program data in order to enter cyberspace. A Porygon is copy- protected so it cannot be duplicated.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 8,
		:evolutions => [
			[:PORYGON2,:TradeItem,:UPGRADE]
		]
	},

	:OnCreation => {},
},

:OMANYTE => {
	"Normal Form" => {
		:name => "Omanyte",
		:dexnum => 138,
		:Type1 => :ROCK,
		:Type2 => :WATER,
		:BaseStats => [35, 40, 100, 90, 55, 35],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :SHELLARMOR],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 71,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:AURORABEAM,:BIDE,:BUBBLEBEAM,:HAZE,:KNOCKOFF,:MUDDYWATER,:REFLECTTYPE,:SLAM,:SPIKES,:SUPERSONIC,:TOXICSPIKES,:WATERPULSE,:WHIRLPOOL,:WRINGOUT,],
		:Moveset => [
			[1,:CONSTRICT],
			[1,:WITHDRAW],
			[7,:BITE],
			[10,:WATERGUN],
			[16,:ROLLOUT],
			[19,:LEER],
			[25,:MUDSHOT],
			[28,:BRINE],
			[34,:PROTECT],
			[37,:ANCIENTPOWER],
			[43,:TICKLE],
			[46,:ROCKBLAST],
			[50,:SHELLSMASH],
			[55,:HYDROPUMP]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BIND,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:GYROBALL,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:METEORBEAM,:MIMIC,:MUDDYWATER,:MUDSHOT,:RAGE,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCALD,:SMACKDOWN,:SPIKES,:STEALTHROCK,:SURF,:TAKEDOWN,:THIEF,:TOXICSPIKES,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water3],
		:Height => 4,
		:Weight => 75,
		:kind => "Spiral",
		:dexentry => "An ancient and long-since-extinct Pokémon that has been regenerated from fossils. If attacked, it withdraws into its hard shell.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:OMASTAR,:Level,40]
		]
	},

	:OnCreation => {},
},

:OMASTAR => {
	"Normal Form" => {
		:name => "Omastar",
		:dexnum => 139,
		:Type1 => :ROCK,
		:Type2 => :WATER,
		:BaseStats => [70, 60, 125, 115, 70, 55],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :SHELLARMOR],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :OMANYTE,
			:form => 0
		},
		:Moveset => [
			[0,:SPIKECANNON],
			[1,:HYDROPUMP],
			[1,:CONSTRICT],
			[1,:WITHDRAW],
			[1,:BITE],
			[7,:BITE],
			[10,:WATERGUN],
			[16,:ROLLOUT],
			[19,:LEER],
			[25,:MUDSHOT],
			[28,:BRINE],
			[34,:PROTECT],
			[37,:ANCIENTPOWER],
			[48,:TICKLE],
			[56,:ROCKBLAST],
			[67,:SHELLSMASH],
			[75,:HYDROPUMP]],
		:compatiblemoves => [:ANCIENTPOWER,:BIDE,:BIND,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CRUNCH,:CURSE,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:GIGAIMPACT,:GYROBALL,:HAIL,:HEADBUTT,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LIQUIDATION,:METEORBEAM,:MIMIC,:MUDDYWATER,:MUDSHOT,:PINMISSILE,:RAGE,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCALD,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:SPIKES,:STEALTHROCK,:STONEEDGE,:SUBMISSION,:SURF,:TAKEDOWN,:THIEF,:TOXICSPIKES,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water3],
		:Height => 10,
		:Weight => 350,
		:kind => "Spiral",
		:dexentry => "An Omastar uses its tentacles to capture its prey. It became extinct because its shell grew too large, making its movements slow and ponderous.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:KABUTO => {
	"Normal Form" => {
		:name => "Kabuto",
		:dexnum => 140,
		:Type1 => :ROCK,
		:Type2 => :WATER,
		:BaseStats => [30, 80, 90, 55, 45, 55],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :BATTLEARMOR],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 71,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:AURORABEAM,:BUBBLEBEAM,:CONFUSERAY,:FLAIL,:FORESIGHT,:GIGADRAIN,:ICYWIND,:KNOCKOFF,:MUDSHOT,:RAPIDSPIN,:SCREECH,:TAKEDOWN,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:HARDEN],
			[6,:ABSORB],
			[11,:LEER],
			[16,:MUDSHOT],
			[21,:SANDATTACK],
			[26,:ENDURE],
			[31,:AQUAJET],
			[36,:MEGADRAIN],
			[41,:METALSOUND],
			[46,:ANCIENTPOWER],
			[50,:WRINGOUT]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BIDE,:BLIZZARD,:BODYSLAM,:BRINE,:BUBBLEBEAM,:CURSE,:DIG,:DOUBLEEDGE,:EARTHPOWER,:GIGADRAIN,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LEECHLIFE,:LIQUIDATION,:MEGADRAIN,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:RAGE,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCALD,:SCREECH,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water3],
		:Height => 5,
		:Weight => 115,
		:kind => "Shellfish",
		:dexentry => "A Pokémon that has been regenerated from a fossil. However, living examples have been discovered. Kabuto haven't changed for 300 million years.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KABUTOPS,:Level,40]
		]
	},

	:OnCreation => {},
},

:KABUTOPS => {
	"Normal Form" => {
		:name => "Kabutops",
		:dexnum => 141,
		:Type1 => :ROCK,
		:Type2 => :WATER,
		:BaseStats => [60, 115, 105, 65, 70, 80],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :BATTLEARMOR],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :KABUTO,
			:form => 0
		},
		:Moveset => [
			[0,:SLASH],
			[1,:NIGHTSLASH],
			[1,:FEINT],
			[1,:SCRATCH],
			[1,:HARDEN],
			[1,:ABSORB],
			[1,:LEER],
			[6,:ABSORB],
			[11,:LEER],
			[16,:MUDSHOT],
			[21,:SANDATTACK],
			[26,:ENDURE],
			[31,:AQUAJET],
			[36,:MEGADRAIN],
			[45,:METALSOUND],
			[54,:ANCIENTPOWER],
			[63,:WRINGOUT],
			[72,:NIGHTSLASH]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:BLIZZARD,:BIDE,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:CROSSPOISON,:CURSE,:CUT,:DIG,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:FLIPTURN,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LEECHLIFE,:LIQUIDATION,:LOWKICK,:MEGADRAIN,:MEGAKICK,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:PSYCHOCUT,:RAGE,:RAINDANCE,:RAZORSHELL,:RAZORWIND,:REFLECT,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCALD,:SCREECH,:SEISMICTOSS,:SKULLBASH,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:SUBMISSION,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water3],
		:Height => 13,
		:Weight => 405,
		:kind => "Shellfish",
		:dexentry => "Kabutops once swam underwater to hunt for prey. It evolved from being a water dweller to living on land as evident from changes in its gills and legs.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:AERODACTYL => {
	"Normal Form" => {
		:name => "Aerodactyl",
		:dexnum => 142,
		:Type1 => :ROCK,
		:Type2 => :FLYING,
		:BaseStats => [80, 105, 65, 60, 75, 130],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:ROCKHEAD, :PRESSURE],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 180,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:EggMoves => [:ASSURANCE,:CURSE,:DRAGONBREATH,:FORESIGHT,:PURSUIT,:ROOST,:STEELWING,:TAILWIND,:WHIRLWIND,:WIDEGUARD,],
		:Moveset => [
			[1,:IRONHEAD],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:WINGATTACK],
			[1,:SUPERSONIC],
			[1,:BITE],
			[1,:SCARYFACE],
			[9,:ROAR],
			[17,:AGILITY],
			[25,:ANCIENTPOWER],
			[33,:CRUNCH],
			[41,:TAKEDOWN],
			[49,:SKYDROP],
			[57,:IRONHEAD],
			[65,:HYPERBEAM],
			[73,:ROCKSLIDE],
			[81,:GIGAIMPACT]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:ANCIENTPOWER,:AQUATAIL,:ASSURANCE,:BIDE,:BRUTALSWING,:BULLDOZE,:CELEBRATE,:CRUNCH,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FLY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HONECLAWS,:HURRICANE,:HYPERBEAM,:ICEFANG,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:METEORBEAM,:MIMIC,:OMINOUSWIND,:PAYBACK,:PSYCHICFANGS,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:ROAR,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SCARYFACE,:SKYATTACK,:SKYDROP,:SMACKDOWN,:STEALTHROCK,:STEELWING,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:TAUNT,:THIEF,:THUNDERFANG,:TORMENT,:TWISTER,:WHIRLWIND,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWDOWN,:SHADOWPANIC,],
		:Color => "Purple",
		:Habitat => "Mountain",
		:EggGroups => [:Flying],
		:Height => 18,
		:Weight => 590,
		:kind => "Fossil",
		:dexentry => "Aerodactyl is a Pokémon from the age of dinosaurs. It was regenerated from DNA extracted from amber. It is imagined to have been the king of the skies.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 20,
	},

	"Mega Form" => {
		:BaseStats => [80, 135, 85, 70, 95, 150],
		:Abilities => [:TOUGHCLAWS],
		:Weight => 1270,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:AERODACTYLITE => 1,
	},
},

:SNORLAX => {
	"Normal Form" => {
		:name => "Snorlax",
		:dexnum => 143,
		:Type1 => :NORMAL,
		:BaseStats => [160, 110, 65, 65, 110, 30],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:IMMUNITY, :THICKFAT],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 189,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:AFTERYOU,:BELCH,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:FISSURE,:LICK,:NATURALGIFT,:POWERUPPUNCH,:PURSUIT,:WHIRLWIND,],
		:preevo => {
			:species => :MUNCHLAX,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[4,:DEFENSECURL],
			[9,:AMNESIA],
			[12,:LICK],
			[17,:CHIPAWAY],
			[20,:YAWN],
			[25,:BODYSLAM],
			[28,:REST],
			[28,:SNORE],
			[33,:SLEEPTALK],
			[35,:GIGAIMPACT],
			[36,:ROLLOUT],
			[41,:BLOCK],
			[44,:BELLYDRUM],
			[49,:CRUNCH],
			[50,:HEAVYSLAM],
			[57,:HIGHHORSEPOWER]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:CELEBRATE,:CHARM,:COUNTER,:COVET,:CRUNCH,:CURSE,:DARKESTLARIAT,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GASTROACID,:GIGAIMPACT,:GUNKSHOT,:HAPPYHOUR,:HEADBUTT,:HEATCRASH,:HEAVYSLAM,:HIGHHORSEPOWER,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONHEAD,:LASTRESORT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:OUTRAGE,:PAYDAY,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SMACKDOWN,:SNATCH,:SOLARBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:SURF,:TAKEDOWN,:TERRAINPULSE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WHIRLWIND,:WILDCHARGE,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWEND,:SHADOWSHED,],
		:Color => "Black",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 21,
		:Weight => 4600,
		:WildItemCommon => :LEFTOVERS,
		:WildItemUncommon => :LEFTOVERS,
		:WildItemRare => :LEFTOVERS,
		:kind => "Sleeping",
		:dexentry => "Snorlax's typical day consists of eating and sleeping. It is such a docile Pokémon that there are children who use its big belly as a place to play.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ARTICUNO => {
	"Normal Form" => {
		:name => "Articuno",
		:dexnum => 144,
		:Type1 => :ICE,
		:Type2 => :FLYING,
		:BaseStats => [90, 85, 100, 95, 125, 85],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:PRESSURE, :SNOWCLOAK],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:GUST],
			[1,:POWDERSNOW],
			[8,:MIST],
			[15,:ICESHARD],
			[22,:MINDREADER],
			[29,:ANCIENTPOWER],
			[36,:AGILITY],
			[43,:FREEZEDRY],
			[50,:REFLECT],
			[57,:HAIL],
			[64,:TAILWIND],
			[71,:ICEBEAM],
			[78,:BLIZZARD],
			[85,:ROOST],
			[92,:HURRICANE],
			[99,:SHEERCOLD]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:AURORAVEIL,:AVALANCHE,:BIDE,:BLIZZARD,:BRAVEBIRD,:BUBBLEBEAM,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FLY,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HURRICANE,:HYPERBEAM,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:LASERFOCUS,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:ROAR,:ROCKSMASH,:ROOST,:SANDSTORM,:SIGNALBEAM,:SKYATTACK,:SKYDROP,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:TRIPLEAXEL,:TWISTER,:UTURN,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLWIND,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWCHILL,:SHADOWSHED,:SHADOWRUSH,:SHADOWSKY,],
		:Color => "Blue",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 17,
		:Weight => 554,
		:kind => "Freeze",
		:dexentry => "Articuno is a legendary bird Pokémon that can control ice. The flapping of its wings chills the air. It is said that when this Pokémon flies, snow will fall.",
		:BattlerPlayerY => 5,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :PSYCHIC,
		:Type2 => :FLYING,
		:BaseStats => [90, 85, 85, 125, 100, 95],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:COMPETITIVE],
		:Moveset => [
			[1,:GUST],
			[1,:PSYCHOSHIFT],
			[5,:CONFUSION],
			[10,:REFLECT],
			[15,:HYPNOSIS],
			[20,:AGILITY],
			[25,:ANCIENTPOWER],
			[30,:TAILWIND],
			[35,:PSYCHOCUT],
			[40,:RECOVER],
			[45,:FREEZINGGLARE],
			[50,:DREAMEATER],
			[55,:HURRICANE],
			[60,:MINDREADER],
			[65,:FUTURESIGHT],
			[70,:TRICKROOM],
		],
		:compatiblemoves => [:AGILITY,:AIRSLASH,:ALLYSWITCH,:ANCIENTPOWER,:BRAVEBIRD,:CALMMIND,:DREAMEATER,:DUALWINGBEAT,:EXPANDINGFORCE,:FLY,:FUTURESIGHT,:GIGAIMPACT,:GUARDSWAP,:HURRICANE,:HYPERBEAM,:HYPERVOICE,:HYPNOSIS,:IMPRISON,:LIGHTSCREEN,:POWERSWAP,:PSYCHIC,:PSYCHOCUT,:PSYSHOCK,:REFLECT,:SCARYFACE,:SHADOWBALL,:SKILLSWAP,:STEELWING,:STOREDPOWER,:SWIFT,:TAILWIND,:TRICKROOM,:UTURN,],
		:moveexceptions => [],
		:Weight => 509,
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 8,
		:dexentry => "Its feather-like blades are composed of psychic energy and can shear through thick iron sheets as if they were paper.",
	},

	:OnCreation => {},
},

:ZAPDOS => {
	"Normal Form" => {
		:name => "Zapdos",
		:dexnum => 145,
		:Type1 => :ELECTRIC,
		:Type2 => :FLYING,
		:BaseStats => [90, 90, 85, 125, 90, 100],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:PRESSURE, :STATIC],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:PECK],
			[1,:THUNDERSHOCK],
			[8,:THUNDERWAVE],
			[15,:DETECT],
			[22,:PLUCK],
			[29,:ANCIENTPOWER],
			[36,:CHARGE],
			[43,:AGILITY],
			[50,:DISCHARGE],
			[57,:RAINDANCE],
			[64,:LIGHTSCREEN],
			[71,:DRILLPECK],
			[78,:THUNDER],
			[85,:ROOST],
			[92,:MAGNETICFLUX],
			[99,:ZAPCANNON]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:BATONPASS,:BIDE,:BRAVEBIRD,:CHARGEBEAM,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:EERIEIMPULSE,:FLASH,:FLY,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:RISINGVOLTAGE,:ROAR,:ROCKSMASH,:ROOST,:SANDSTORM,:SHOCKWAVE,:SIGNALBEAM,:SKYATTACK,:SKYDROP,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:UTURN,:VOLTSWITCH,:WEATHERBALL,:WHIRLWIND,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWBOLT,:SHADOWRUSH,:SHADOWSKY,:SHADOWSHED,],
		:Color => "Yellow",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 16,
		:Weight => 526,
		:kind => "Electric",
		:dexentry => "Zapdos is a legendary bird Pokémon that has the ability to control electricity. It usually lives in thunderclouds. It gains power if it is stricken by lightning bolts.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 8,
	},

	"Galarian Form" => {
		:Type1 => :FIGHTING,
		:Type2 => :FLYING,
		:BaseStats => [90, 125, 90, 85, 90, 100],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:DEFIANT],
		:Moveset => [
			[1,:PECK],
			[1,:FOCUSENERGY],
			[5,:ROCKSMASH],
			[10,:LIGHTSCREEN],
			[15,:PLUCK],
			[20,:AGILITY],
			[25,:ANCIENTPOWER],
			[30,:BRICKBREAK],
			[35,:DRILLPECK],
			[40,:QUICKGUARD],
			[45,:THUNDEROUSKICK],
			[50,:BULKUP],
			[55,:COUNTER],
			[60,:DETECT],
			[65,:CLOSECOMBAT],
			[70,:REVERSAL],
		],
		:compatiblemoves => [:ACROBATICS,:AGILITY,:ANCIENTPOWER,:ASSURANCE,:BLAZEKICK,:BOUNCE,:BRAVEBIRD,:BRICKBREAK,:BULKUP,:CLOSECOMBAT,:COACHING,:COUNTER,:DETECT,:DUALWINGBEAT,:FLY,:FOCUSENERGY,:GIGAIMPACT,:HURRICANE,:HYPERBEAM,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MEGAKICK,:PAYBACK,:PLUCK,:RETALIATE,:REVENGE,:REVERSAL,:ROCKSMASH,:SCARYFACE,:SCREECH,:STEELWING,:STOMPINGTANTRUM,:SUPERPOWER,:SWIFT,:TAUNT,:THROATCHOP,:UTURN,],
		:moveexceptions => [],
		:Weight => 582,
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:dexentry => "One kick from its powerful legs will pulverize a dump truck. Supposedly, this Pokémon runs through the mountains at over 180 mph.",
	},

	:OnCreation => {},
},

:MOLTRES => {
	"Normal Form" => {
		:name => "Moltres",
		:dexnum => 146,
		:Type1 => :FIRE,
		:Type2 => :FLYING,
		:BaseStats => [90, 100, 90, 125, 85, 90],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:PRESSURE, :FLAMEBODY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:WINGATTACK],
			[1,:EMBER],
			[8,:FIRESPIN],
			[15,:AGILITY],
			[22,:ENDURE],
			[29,:ANCIENTPOWER],
			[36,:FLAMETHROWER],
			[43,:SAFEGUARD],
			[50,:AIRSLASH],
			[57,:SUNNYDAY],
			[64,:HEATWAVE],
			[71,:SOLARBEAM],
			[78,:SKYATTACK],
			[85,:ROOST],
			[92,:HURRICANE],
			[99,:BURNUP]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:BIDE,:BRAVEBIRD,:BURNINGJEALOUSY,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:INCINERATE,:LASERFOCUS,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OMINOUSWIND,:OVERHEAT,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:ROAR,:ROCKSMASH,:ROOST,:SAFEGUARD,:SANDSTORM,:SCORCHINGSANDS,:SKYATTACK,:SKYDROP,:SOLARBEAM,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAKEDOWN,:TWISTER,:UTURN,:WEATHERBALL,:WHIRLWIND,:WILLOWISP,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWFIRE,:SHADOWSHED,:SHADOWMIST,:SHADOWBREAK,],
		:Color => "Yellow",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 20,
		:Weight => 600,
		:kind => "Flame",
		:dexentry => "Moltres is a legendary bird Pokémon that can control fire. If injured, it is said to dip its body in the molten magma of a volcano to burn and heal itself.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :DARK,
		:Type2 => :FLYING,
		:BaseStats => [90, 85, 90, 100, 125, 90],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:BERSERK],
		:Moveset => [
			[1,:GUST],
			[1,:LEER],
			[5,:PAYBACK],
			[10,:SAFEGUARD],
			[15,:WINGATTACK],
			[20,:AGILITY],
			[25,:ANCIENTPOWER],
			[30,:SUCKERPUNCH],
			[35,:AIRSLASH],
			[40,:AFTERYOU],
			[45,:FIERYWRATH],
			[50,:NASTYPLOT],
			[55,:HURRICANE],
			[60,:ENDURE],
			[65,:MEMENTO],
			[70,:SKYATTACK],
		],
		:compatiblemoves => [:AFTERYOU,:AGILITY,:AIRSLASH,:ANCIENTPOWER,:ASSURANCE,:BRAVEBIRD,:DARKPULSE,:DUALWINGBEAT,:FLY,:FOULPLAY,:GIGAIMPACT,:HEX,:HURRICANE,:HYPERBEAM,:HYPERVOICE,:IMPRISON,:LASHOUT,:NASTYPLOT,:PAYBACK,:SAFEGUARD,:SCARYFACE,:SHADOWBALL,:SKYATTACK,:SNARL,:STEELWING,:SUCKERPUNCH,:SWIFT,:TAUNT,:UTURN,],
		:moveexceptions => [],
		:Weight => 660,
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 8,
		:dexentry => "This Pokémon's sinister, flame-like aura will consume the spirit of any creature it hits. Victims become burned-out shadows of themselves.",
	},

	:OnCreation => {},
},

:DRATINI => {
	"Normal Form" => {
		:name => "Dratini",
		:dexnum => 147,
		:Type1 => :DRAGON,
		:BaseStats => [41, 64, 45, 50, 50, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :MARVELSCALE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:EggMoves => [:AQUAJET,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRUSH,:EXTREMESPEED,:HAZE,:IRONTAIL,:MIST,:SUPERSONIC,:WATERPULSE,],
		:Moveset => [
			[1,:WRAP],
			[1,:LEER],
			[5,:THUNDERWAVE],
			[11,:TWISTER],
			[15,:DRAGONRAGE],
			[21,:SLAM],
			[25,:AGILITY],
			[31,:DRAGONTAIL],
			[35,:AQUATAIL],
			[41,:DRAGONRUSH],
			[45,:SAFEGUARD],
			[51,:DRAGONDANCE],
			[55,:OUTRAGE],
			[61,:HYPERBEAM]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BUBBLEBEAM,:CURSE,:DETECT,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:FIREBLAST,:FIRESPIN,:FLAMETHROWER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:OUTRAGE,:RAGE,:RAINDANCE,:REFLECT,:SAFEGUARD,:SCALESHOT,:SHOCKWAVE,:SKULLBASH,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Dragon],
		:Height => 18,
		:Weight => 33,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "A Dratini continually molts and sloughs off its old skin. It does so because the life energy within its body steadily builds to reach uncontrollable levels.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DRAGONAIR,:Level,30]
		]
	},

	:OnCreation => {},
},

:DRAGONAIR => {
	"Normal Form" => {
		:name => "Dragonair",
		:dexnum => 148,
		:Type1 => :DRAGON,
		:BaseStats => [61, 84, 65, 70, 70, 70],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :MARVELSCALE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :DRATINI,
			:form => 0
		},
		:Moveset => [
			[1,:WRAP],
			[1,:LEER],
			[1,:THUNDERWAVE],
			[1,:TWISTER],
			[5,:THUNDERWAVE],
			[11,:TWISTER],
			[15,:DRAGONRAGE],
			[21,:SLAM],
			[25,:AGILITY],
			[33,:DRAGONTAIL],
			[39,:AQUATAIL],
			[47,:DRAGONRUSH],
			[53,:SAFEGUARD],
			[61,:DRAGONDANCE],
			[67,:OUTRAGE],
			[75,:HYPERBEAM]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:BIDE,:BLIZZARD,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BUBBLEBEAM,:CURSE,:DETECT,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:FIREBLAST,:FIRESPIN,:FLAMETHROWER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:OUTRAGE,:RAGE,:RAINDANCE,:REFLECT,:SAFEGUARD,:SCALESHOT,:SHOCKWAVE,:SKULLBASH,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Dragon],
		:Height => 40,
		:Weight => 165,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "A Dragonair stores an enormous amount of energy inside its body. It alters the weather around it by loosing energy from the crystals on its neck and tail.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DRAGONITE,:Level,55]
		]
	},

	:OnCreation => {},
},

:DRAGONITE => {
	"Normal Form" => {
		:name => "Dragonite",
		:dexnum => 149,
		:Type1 => :DRAGON,
		:Type2 => :FLYING,
		:BaseStats => [91, 134, 95, 100, 100, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:INNERFOCUS, :MULTISCALE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :DRAGONAIR,
			:form => 0
		},
		:Moveset => [
			[0,:WINGATTACK],
			[1,:EXTREMESPEED],
			[1,:HURRICANE],
			[1,:FIREPUNCH],
			[1,:THUNDERPUNCH],
			[1,:ROOST],
			[1,:WRAP],
			[1,:LEER],
			[1,:THUNDERWAVE],
			[1,:TWISTER],
			[5,:THUNDERWAVE],
			[11,:TWISTER],
			[15,:DRAGONRAGE],
			[21,:SLAM],
			[25,:AGILITY],
			[33,:DRAGONTAIL],
			[39,:AQUATAIL],
			[47,:DRAGONRUSH],
			[53,:SAFEGUARD],
			[61,:DRAGONDANCE],
			[67,:OUTRAGE],
			[75,:HYPERBEAM],
			[81,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:AQUATAIL,:BIDE,:BIND,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:CURSE,:CUT,:DEFOG,:DETECT,:DIVE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONBREATH,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONTAIL,:DUALWINGBEAT,:DYNAMICPUNCH,:EARTHQUAKE,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMETHROWER,:FLING,:FLY,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HEATWAVE,:HONECLAWS,:HORNDRILL,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONHEAD,:IRONTAIL,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:POWERUPPUNCH,:RAGE,:RAINDANCE,:RAZORWIND,:REFLECT,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SHOCKWAVE,:SKULLBASH,:SKYDROP,:STEELWING,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:SWIFT,:TAILWIND,:TAKEDOWN,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWDOWN,:SHADOWRUSH,:SHADOWSHED,:SHADOWSTORM,],
		:Color => "Brown",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Dragon],
		:Height => 22,
		:Weight => 2100,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "It can circle the globe in just 16 hours. It is a kindhearted Pokémon that leads lost and foundering ships in a storm to the safety of land.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MEWTWO => {
	"Normal Form" => {
		:name => "Mewtwo",
		:dexnum => 150,
		:Type1 => :PSYCHIC,
		:BaseStats => [106, 110, 90, 154, 90, 130],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:PRESSURE, :UNNERVE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:LASERFOCUS],
			[1,:PSYWAVE],
			[1,:CONFUSION],
			[1,:DISABLE],
			[1,:SAFEGUARD],
			[8,:SWIFT],
			[15,:FUTURESIGHT],
			[22,:PSYCHUP],
			[29,:MIRACLEEYE],
			[36,:PSYCHOCUT],
			[43,:POWERSWAP],
			[43,:GUARDSWAP],
			[50,:RECOVER],
			[57,:PSYCHIC],
			[64,:BARRIER],
			[70,:AURASPHERE],
			[79,:AMNESIA],
			[86,:MIST],
			[93,:MEFIRST],
			[100,:PSYSTRIKE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:AURASPHERE,:AVALANCHE,:BIDE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULKUP,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COUNTER,:CURSE,:DETECT,:DIVE,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ELECTROBALL,:EMBARGO,:ENERGYBALL,:EXPANDINGFORCE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HAIL,:HEADBUTT,:HURRICANE,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYDAY,:POISONJAB,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SAFEGUARD,:SANDSTORM,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SNATCH,:SOLARBEAM,:SPEEDSWAP,:STONEEDGE,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:WATERGUN,:WATERPULSE,:WILLOWISP,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWBOLT,:SHADOWBLAST,:SHADOWFIRE,:SHADOWCHILL,],
		:Color => "Purple",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 20,
		:Weight => 1220,
		:kind => "Genetic",
		:dexentry => "A Pokémon that was created by genetic manipulation. However, even though the scientific power of humans made its body, they failed to give it a warm heart.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	"Mega X" => {
		:Type2 => :FIGHTING,
		:BaseStats => [106, 190, 100, 154, 100, 130],
		:Abilities => [:STEADFAST],
		:Weight => 1105,
	},

	"Mega Y" => {
		:BaseStats => [106, 150, 70, 194, 120, 140],
		:Abilities => [:INSOMNIA],
		:Weight => 330,
	},

	:OnCreation => {},
	:DefaultForm => 0,
  	:MegaForm => {
		:MEWTWONITEX => 1,
		:MEWTWONITEY => 2
	},
},

:MEW => {
	"Normal Form" => {
		:name => "Mew",
		:dexnum => 151,
		:Type1 => :PSYCHIC,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:SYNCHRONIZE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 100,
		:EggSteps => 30855,
		:Moveset => [
			[1,:POUND],
			[1,:REFLECTTYPE],
			[1,:TRANSFORM],
			[10,:MEGAPUNCH],
			[20,:METRONOME],
			[30,:PSYCHIC],
			[40,:BARRIER],
			[50,:ANCIENTPOWER],
			[60,:AMNESIA],
			[70,:MEFIRST],
			[80,:BATONPASS],
			[90,:NASTYPLOT],
			[100,:AURASPHERE]],
		:compatiblemoves => [],	# Mew is hardcoded to learn every TM or Tutor move in "SpeciesCompatible?" except the moves below here
		:moveexceptions => [:BLASTBURN,:DRACOMETEOR,:DRAGONASCENT,:FIREPLEDGE,:FRENZYPLANT,:GRASSPLEDGE,:HYDROCANNON,:RELICSONG,:SECRETSWORD,:STEELBEAM,:WATERPLEDGE,],
		:Color => "Pink",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 4,
		:Weight => 40,
		:WildItemCommon => :LUMBERRY,
		:WildItemUncommon => :LUMBERRY,
		:WildItemRare => :LUMBERRY,
		:kind => "New Species",
		:dexentry => "A Mew is said to possess the genes of all Pokémon. It is capable of making itself invisible at will, so it entirely avoids notice even if it approaches people.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:CHIKORITA => {
	"Normal Form" => {
		:name => "Chikorita",
		:dexnum => 152,
		:Type1 => :GRASS,
		:BaseStats => [45, 49, 65, 49, 65, 45],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:OVERGROW, :LEAFGUARD],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 64,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:AROMATHERAPY,:BODYSLAM,:COUNTER,:FLAIL,:GRASSWHISTLE,:GRASSYTERRAIN,:HEALPULSE,:INGRAIN,:LEAFSTORM,:LEECHSEED,:NATUREPOWER,:REFRESH,:VINEWHIP,:WRINGOUT,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[6,:RAZORLEAF],
			[9,:POISONPOWDER],
			[12,:SYNTHESIS],
			[17,:REFLECT],
			[20,:MAGICALLEAF],
			[23,:NATURALGIFT],
			[28,:SWEETSCENT],
			[31,:LIGHTSCREEN],
			[34,:BODYSLAM],
			[39,:SAFEGUARD],
			[42,:AROMATHERAPY],
			[45,:SOLARBEAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BULLETSEED,:CUT,:CURSE,:DETECT,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FLASH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:HEADBUTT,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:NATUREPOWER,:REFLECT,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 9,
		:Weight => 64,
		:kind => "Leaf",
		:dexentry => "It waves its leaf around to keep foes at bay. However, a sweet fragrance also wafts from the leaf, creating a friendly atmosphere that becalms the battlers.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BAYLEEF,:Level,16]
		]
	},

	:OnCreation => {},
},

:BAYLEEF => {
	"Normal Form" => {
		:name => "Bayleef",
		:dexnum => 153,
		:Type1 => :GRASS,
		:BaseStats => [60, 62, 80, 63, 80, 60],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:OVERGROW, :LEAFGUARD],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHIKORITA,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[1,:RAZORLEAF],
			[1,:POISONPOWDER],
			[6,:RAZORLEAF],
			[9,:POISONPOWDER],
			[12,:SYNTHESIS],
			[18,:REFLECT],
			[22,:MAGICALLEAF],
			[26,:NATURALGIFT],
			[32,:SWEETSCENT],
			[36,:LIGHTSCREEN],
			[40,:BODYSLAM],
			[46,:SAFEGUARD],
			[50,:AROMATHERAPY],
			[54,:SOLARBEAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BODYSLAM,:BULLETSEED,:CHARM,:CUT,:CURSE,:DETECT,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FLASH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:HEADBUTT,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 12,
		:Weight => 158,
		:kind => "Leaf",
		:dexentry => "A Bayleef's neck is ringed by curled-up leaves. Inside each leaf is a small tree shoot. The fragrance of this shoot makes people peppy.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MEGANIUM,:Level,32]
		]
	},

	:OnCreation => {},
},

:MEGANIUM => {
	"Normal Form" => {
		:name => "Meganium",
		:dexnum => 154,
		:Type1 => :GRASS,
		:BaseStats => [80, 82, 100, 83, 100, 80],
		:EVs => [0, 0, 1, 0, 2, 0],
		:Abilities => [:OVERGROW, :LEAFGUARD],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 236,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BAYLEEF,
			:form => 0
		},
		:Moveset => [
			[0,:PETALDANCE],
			[1,:PETALBLIZZARD],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:RAZORLEAF],
			[1,:POISONPOWDER],
			[6,:RAZORLEAF],
			[9,:POISONPOWDER],
			[12,:SYNTHESIS],
			[18,:REFLECT],
			[22,:MAGICALLEAF],
			[26,:NATURALGIFT],
			[34,:SWEETSCENT],
			[40,:LIGHTSCREEN],
			[46,:BODYSLAM],
			[54,:SAFEGUARD],
			[60,:AROMATHERAPY],
			[66,:SOLARBEAM],
			[70,:PETALBLIZZARD]],
		:compatiblemoves => [:ANCIENTPOWER,:BODYSLAM,:BULLETSEED,:BULLDOZE,:CHARM,:CURSE,:CUT,:DETECT,:DOUBLEEDGE,:DRAGONTAIL,:EARTHQUAKE,:ECHOEDVOICE,:ENERGYBALL,:FLASH,:FRENZYPLANT,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:IRONTAIL,:LASERFOCUS,:LEAFBLADE,:LEAFSTORM,:LIGHTSCREEN,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:REFLECT,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SOLARBLADE,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WEATHERBALL,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Grass],
		:Height => 18,
		:Weight => 1005,
		:kind => "Herb",
		:dexentry => "The fragrance of a Meganium's flower soothes and calms emotions. In battle, it gives off more of its becalming scent to blunt the foe's fighting spirit.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CYNDAQUIL => {
	"Normal Form" => {
		:name => "Cyndaquil",
		:dexnum => 155,
		:Type1 => :FIRE,
		:BaseStats => [39, 52, 43, 60, 50, 65],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:BLAZE, :FLASHFIRE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:COVET,:CRUSHCLAW,:DOUBLEKICK,:DOUBLEEDGE,:EXTRASENSORY,:FLAMEBURST,:FLAREBLITZ,:FORESIGHT,:FURYSWIPES,:HOWL,:NATUREPOWER,:QUICKATTACK,:REVERSAL,:THRASH,],
		:Moveset => [
			[1,:TACKLE],
			[1,:LEER],
			[6,:SMOKESCREEN],
			[10,:EMBER],
			[13,:QUICKATTACK],
			[19,:FLAMEWHEEL],
			[22,:DEFENSECURL],
			[28,:FLAMECHARGE],
			[31,:SWIFT],
			[37,:LAVAPLUME],
			[40,:FLAMETHROWER],
			[46,:INFERNO],
			[49,:ROLLOUT],
			[55,:DOUBLEEDGE],
			[58,:BURNUP],
			[64,:ERUPTION]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:COVET,:CUT,:CURSE,:DETECT,:DOUBLEEDGE,:FIREBLAST,:FIREPLEDGE,:FLAMECHARGE,:FLAMETHROWER,:HEADBUTT,:HEATWAVE,:INCINERATE,:IRONTAIL,:MUDSLAP,:MIMIC,:NATUREPOWER,:OVERHEAT,:ROLLOUT,:SUBMISSION,:SUNNYDAY,:WILDCHARGE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 79,
		:kind => "Fire Mouse",
		:dexentry => "It flares flames from its back to protect itself. The fire burns vigorously if the Pokémon is angry. When it is tired, it sputters with incomplete combustion.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:QUILAVA,:Level,14]
		]
	},

	:OnCreation => {},
},

:QUILAVA => {
	"Normal Form" => {
		:name => "Quilava",
		:dexnum => 156,
		:Type1 => :FIRE,
		:BaseStats => [58, 64, 58, 80, 65, 80],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:BLAZE, :FLASHFIRE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CYNDAQUIL,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:LEER],
			[1,:SMOKESCREEN],
			[6,:SMOKESCREEN],
			[10,:EMBER],
			[13,:QUICKATTACK],
			[20,:FLAMEWHEEL],
			[24,:DEFENSECURL],
			[31,:SWIFT],
			[35,:FLAMECHARGE],
			[42,:LAVAPLUME],
			[46,:FLAMETHROWER],
			[53,:INFERNO],
			[57,:ROLLOUT],
			[64,:DOUBLEEDGE],
			[68,:BURNUP],
			[75,:ERUPTION]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BRICKBREAK,:COVET,:CUT,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:FIREBLAST,:FIREPLEDGE,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:HEATWAVE,:INCINERATE,:MUDSLAP,:MIMIC,:NATUREPOWER,:OVERHEAT,:ROAR,:ROCKSMASH,:ROLLOUT,:STRENGTH,:SUNNYDAY,:SUBMISSION,:WILDCHARGE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 190,
		:kind => "Volcano",
		:dexentry => "It intimidates foes with intense gusts of flames and superheated air. Its quick nimbleness lets it dodge attacks even while scorching an enemy.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TYPHLOSION,:Level,36]
		]
	},

	:OnCreation => {},
},

:TYPHLOSION => {
	"Normal Form" => {
		:name => "Typhlosion",
		:dexnum => 157,
		:Type1 => :FIRE,
		:BaseStats => [78, 84, 78, 109, 85, 100],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:BLAZE, :FLASHFIRE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 240,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :QUILAVA,
			:form => 0
		},
		:Moveset => [
			[1,:ERUPTION],
			[1,:DOUBLEEDGE],
			[1,:GYROBALL],
			[1,:TACKLE],
			[1,:LEER],
			[1,:SMOKESCREEN],
			[1,:EMBER],
			[6,:SMOKESCREEN],
			[10,:EMBER],
			[13,:QUICKATTACK],
			[20,:FLAMEWHEEL],
			[24,:DEFENSECURL],
			[31,:SWIFT],
			[35,:FLAMECHARGE],
			[43,:LAVAPLUME],
			[48,:FLAMETHROWER],
			[56,:INFERNO],
			[61,:ROLLOUT],
			[69,:DOUBLEEDGE],
			[74,:BURNUP],
			[82,:ERUPTION]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BLASTBURN,:COUNTER,:BRICKBREAK,:BULLDOZE,:BURNINGJEALOUSY,:COVET,:CUT,:CURSE,:DYNAMICPUNCH,:DETECT,:DIG,:DOUBLEEDGE,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEATWAVE,:HYPERBEAM,:INCINERATE,:LASERFOCUS,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:MIMIC,:NATUREPOWER,:OVERHEAT,:POWERUPPUNCH,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SHADOWCLAW,:SEISMICTOSS,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUBMISSION,:SWIFT,:THROATCHOP,:THUNDERPUNCH,:WILDCHARGE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 17,
		:Weight => 795,
		:kind => "Volcano",
		:dexentry => "It can hide behind a heat haze that it creates using its flames. Typhlosion create blazing explosive blasts that burn everything to cinders.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TOTODILE => {
	"Normal Form" => {
		:name => "Totodile",
		:dexnum => 158,
		:Type1 => :WATER,
		:BaseStats => [50, 65, 64, 44, 48, 43],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:TORRENT, :SHEERFORCE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:AQUAJET,:BLOCK,:CRUNCH,:DRAGONDANCE,:FAKETEARS,:FLATTER,:HYDROPUMP,:ICEPUNCH,:METALCLAW,:MUDSPORT,:THRASH,:WATERPULSE,:WATERSPORT,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:LEER],
			[6,:WATERGUN],
			[8,:RAGE],
			[13,:BITE],
			[15,:SCARYFACE],
			[20,:ICEFANG],
			[22,:FLAIL],
			[27,:CRUNCH],
			[29,:CHIPAWAY],
			[34,:SLASH],
			[36,:SCREECH],
			[41,:THRASH],
			[43,:AQUATAIL],
			[48,:SUPERPOWER],
			[50,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:BODYSLAM,:BLIZZARD,:BLOCK,:BRICKBREAK,:CUT,:CURSE,:COUNTER,:DIVE,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:DRAGONDANCE,:DRAGONCLAW,:FLING,:FOCUSPUNCH,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LOWKICK,:MUDSLAP,:MEGAPUNCH,:MEGAKICK,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:RAINDANCE,:ROCKSLIDE,:ROCKTOMB,:RAZORWIND,:SCALD,:SEISMICTOSS,:SHADOWCLAW,:SPITE,:SURF,:SWORDSDANCE,:UPROAR,:WHIRLPOOL,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 6,
		:Weight => 95,
		:kind => "Big Jaw",
		:dexentry => "Despite its small body, Totodile's jaws are very powerful. While it may think it is just playfully nipping, its bite can cause serious injury.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CROCONAW,:Level,18]
		]
	},

	:OnCreation => {},
},

:CROCONAW => {
	"Normal Form" => {
		:name => "Croconaw",
		:dexnum => 159,
		:Type1 => :WATER,
		:BaseStats => [65, 80, 80, 59, 63, 58],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:TORRENT, :SHEERFORCE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TOTODILE,
			:form => 0
		},
		:Moveset => [
			[1,:SCRATCH],
			[1,:LEER],
			[1,:WATERGUN],
			[6,:WATERGUN],
			[8,:RAGE],
			[13,:BITE],
			[15,:SCARYFACE],
			[21,:ICEFANG],
			[24,:FLAIL],
			[30,:CRUNCH],
			[33,:CHIPAWAY],
			[39,:SLASH],
			[42,:SCREECH],
			[48,:THRASH],
			[51,:AQUATAIL],
			[57,:SUPERPOWER],
			[60,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:BODYSLAM,:BLIZZARD,:BLOCK,:BRICKBREAK,:CRUNCH,:CUT,:CURSE,:DIVE,:DRAGONDANCE,:DOUBLEEDGE,:DYNAMICPUNCH,:DRAGONDANCE,:DRAGONCLAW,:FLING,:FOCUSPUNCH,:FURYCUTTER,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LOWKICK,:MUDSLAP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:POWERUPPUNCH,:RAINDANCE,:RAZORSHELL,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:RAZORWIND,:SCALD,:SHADOWCLAW,:SEISMICTOSS,:SPITE,:STRENGTH,:SURF,:SWORDSDANCE,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 11,
		:Weight => 250,
		:kind => "Big Jaw",
		:dexentry => "Once its jaws clamp down on its foe, it will not let go. Because the tips of its fangs are forked back like fishhooks, they become irremovably embedded.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
		:evolutions => [
			[:FERALIGATR,:Level,30]
		]
	},

	:OnCreation => {},
},

:FERALIGATR => {
	"Normal Form" => {
		:name => "Feraligatr",
		:dexnum => 160,
		:Type1 => :WATER,
		:BaseStats => [85, 105, 100, 79, 83, 78],
		:EVs => [0, 2, 1, 0, 0, 0],
		:Abilities => [:TORRENT, :SHEERFORCE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CROCONAW,
			:form => 0
		},
		:Moveset => [
			[0,:POISONFANG],
			[1,:AGILITY],
			[1,:SCRATCH],
			[1,:LEER],
			[1,:WATERGUN],
			[1,:RAGE],
			[1,:POISONJAB],
			[6,:WATERGUN],
			[8,:RAGE],
			[13,:BITE],
			[15,:SCARYFACE],
			[21,:ICEFANG],
			[24,:FLAIL],
			[32,:CRUNCH],
			[37,:CHIPAWAY],
			[45,:SLASH],
			[50,:SCREECH],
			[58,:THRASH],
			[63,:AQUATAIL],
			[71,:SUPERPOWER],
			[76,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AVALANCHE,:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:BODYSLAM,:BLIZZARD,:BLOCK,:BRICKBREAK,:BULLDOZE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DETECT,:DIG,:DIVE,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FLING,:FLIPTURN,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROCANNON,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LIQUIDATION,:LOWKICK,:MEGAPUNCH,:MEGAKICK,:MIMIC,:MUDDYWATER,:MUDSLAP,:OUTRAGE,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RAZORSHELL,:ROAR,:RAZORWIND,:REVENGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SEISMICTOSS,:SHADOWCLAW,:SLUDGEBOMB,:SLUDGEWAVE,:SPITE,:STRENGTH,:SUPERPOWER,:SURF,:SWORDSDANCE,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 23,
		:Weight => 888,
		:kind => "Big Jaw",
		:dexentry => "It opens its huge mouth to intimidate enemies. In battle, it runs using its thick and powerful hind legs to charge the foe with incredible speed.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :POISON,
		:BaseStats => [85, 145, 130, 79, 93, 98],
		:Abilities => [:SHEERFORCE],
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:FERALIGATRITE => 1
	},
},

:SENTRET => {
	"Normal Form" => {
		:name => "Sentret",
		:dexnum => 161,
		:Type1 => :NORMAL,
		:BaseStats => [35, 46, 34, 35, 45, 20],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:RUNAWAY, :KEENEYE],
		:HiddenAbilities => :FRISK,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 43,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ASSIST,:BABYDOLLEYES,:CAPTIVATE,:CHARM,:COVET,:DOUBLEEDGE,:FOCUSENERGY,:IRONTAIL,:LASTRESORT,:NATURALGIFT,:PURSUIT,:REVERSAL,:SLASH,:TRICK,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:FORESIGHT],
			[4,:DEFENSECURL],
			[7,:QUICKATTACK],
			[13,:FURYSWIPES],
			[16,:HELPINGHAND],
			[19,:FOLLOWME],
			[25,:SLAM],
			[28,:REST],
			[31,:SUCKERPUNCH],
			[36,:AMNESIA],
			[39,:BATONPASS],
			[42,:MEFIRST],
			[47,:HYPERVOICE]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BATONPASS,:CURSE,:CHARGEBEAM,:COVET,:CUT,:DIG,:DETECT,:DOUBLEEDGE,:DYNAMICPUNCH,:ECHOEDVOICE,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROLLOUT,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SURF,:SWIFT,:THIEF,:THUNDERBOLT,:THUNDERPUNCH,:TRICK,:UPROAR,:UTURN,:WHIRLPOOL,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 60,
		:kind => "Scout",
		:dexentry => "They take turns standing guard at night. The sentry awakens the others if it senses danger. If one becomes separated, it turns sleepless with fear.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
		:evolutions => [
			[:FURRET,:Level,15]
		]
	},

	:OnCreation => {},
},

:FURRET => {
	"Normal Form" => {
		:name => "Furret",
		:dexnum => 162,
		:Type1 => :NORMAL,
		:BaseStats => [85, 76, 64, 45, 55, 90],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:RUNAWAY, :KEENEYE],
		:HiddenAbilities => :FRISK,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 145,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SENTRET,
			:form => 0
		},
		:Moveset => [
			[0,:AGILITY],
			[1,:COIL],
			[1,:SCRATCH],
			[1,:FORESIGHT],
			[1,:DEFENSECURL],
			[1,:QUICKATTACK],
			[4,:DEFENSECURL],
			[7,:QUICKATTACK],
			[13,:FURYSWIPES],
			[17,:HELPINGHAND],
			[21,:FOLLOWME],
			[28,:SLAM],
			[32,:REST],
			[36,:SUCKERPUNCH],
			[42,:AMNESIA],
			[46,:BATONPASS],
			[50,:MEFIRST],
			[56,:HYPERVOICE]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:ASSURANCE,:BODYSLAM,:BLIZZARD,:BRICKBREAK,:BRUTALSWING,:BATONPASS,:CHARGEBEAM,:CHARM,:COVET,:CURSE,:CUT,:DETECT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:ECHOEDVOICE,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PAYDAY,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROLLOUT,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKITTERSMACK,:SOLARBEAM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SURF,:SWIFT,:TAILSLAP,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:TRICK,:UPROAR,:UTURN,:WHIRLPOOL,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 18,
		:Weight => 325,
		:kind => "Long Body",
		:dexentry => "A Furret has a very slim build. When under attack, it can fit through narrow spaces and get away. In spite of its short limbs, it is very nimble.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:HOOTHOOT => {
	"Normal Form" => {
		:name => "Hoothoot",
		:dexnum => 163,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [60, 30, 30, 36, 56, 50],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:INSOMNIA, :KEENEYE],
		:HiddenAbilities => :TINTEDLENS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 52,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AGILITY,:DEFOG,:FEATHERDANCE,:FEINTATTACK,:HURRICANE,:MEANLOOK,:MIRRORMOVE,:NIGHTSHADE,:SKYATTACK,:SUPERSONIC,:WHIRLWIND,:WINGATTACK,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[1,:FORESIGHT],
			[4,:HYPNOSIS],
			[7,:PECK],
			[10,:CONFUSION],
			[13,:ECHOEDVOICE],
			[16,:ZENHEADBUTT],
			[19,:PSYCHOSHIFT],
			[22,:EXTRASENSORY],
			[25,:TAKEDOWN],
			[28,:REFLECT],
			[31,:AIRSLASH],
			[34,:UPROAR],
			[37,:ROOST],
			[40,:MOONBLAST],
			[43,:SYNCHRONOISE],
			[46,:DREAMEATER]],
		:compatiblemoves => [:AGILITY,:AERIALACE,:AIRCUTTER,:AMNESIA,:CURSE,:DETECT,:DEFOG,:DREAMEATER,:DOUBLEEDGE,:DUALWINGBEAT,:ECHOEDVOICE,:FLASH,:FLY,:HEATWAVE,:HYPERVOICE,:MIMIC,:MAGICCOAT,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:REFLECT,:ROOST,:SILVERWIND,:SHADOWBALL,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:STOREDPOWER,:TAILWIND,:THIEF,:TWISTER,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 7,
		:Weight => 212,
		:kind => "Owl",
		:dexentry => "It has an internal organ that senses the earth's rotation. Using this special organ, a Hoothoot begins hooting at precisely the same time every day.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NOCTOWL,:Level,20]
		]
	},

	:OnCreation => {},
},

:NOCTOWL => {
	"Normal Form" => {
		:name => "Noctowl",
		:dexnum => 164,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [100, 50, 50, 86, 96, 70],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:INSOMNIA, :KEENEYE],
		:HiddenAbilities => :TINTEDLENS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :HOOTHOOT,
			:form => 0
		},
		:Moveset => [
			[1,:DREAMEATER],
			[1,:SKYATTACK],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:FORESIGHT],
			[1,:HYPNOSIS],
			[4,:HYPNOSIS],
			[7,:PECK],
			[10,:CONFUSION],
			[13,:ECHOEDVOICE],
			[16,:ZENHEADBUTT],
			[19,:PSYCHOSHIFT],
			[23,:EXTRASENSORY],
			[27,:TAKEDOWN],
			[31,:REFLECT],
			[35,:AIRSLASH],
			[39,:UPROAR],
			[43,:ROOST],
			[47,:MOONBLAST],
			[51,:SYNCHRONOISE],
			[55,:DREAMEATER]],
		:compatiblemoves => [:AGILITY,:AERIALACE,:AIRCUTTER,:AMNESIA,:CURSE,:DETECT,:DOUBLEEDGE,:DEFOG,:DREAMEATER,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:GIGAIMPACT,:HEATWAVE,:HYPERBEAM,:HYPERVOICE,:LASERFOCUS,:PLUCK,:MIMIC,:MAGICCOAT,:MUDSLAP,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:REFLECT,:ROOST,:SHADOWBALL,:SILVERWIND,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 16,
		:Weight => 408,
		:kind => "Owl",
		:dexentry => "It unfailingly catches prey in darkness. Noctowl owe their success to superior vision that allows them to see at night, and to their silent wings.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LEDYBA => {
	"Normal Form" => {
		:name => "Ledyba",
		:dexnum => 165,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [40, 20, 30, 40, 80, 55],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SWARM, :EARLYBIRD],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 53,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BIDE,:BUGBITE,:BUGBUZZ,:COUNTER,:DIZZYPUNCH,:DRAINPUNCH,:ENCORE,:ENDURE,:FOCUSPUNCH,:KNOCKOFF,:PSYBEAM,:SCREECH,:SILVERWIND,:TAILWIND,],
		:Moveset => [
			[1,:TACKLE],
			[5,:SUPERSONIC],
			[8,:SWIFT],
			[12,:LIGHTSCREEN],
			[12,:REFLECT],
			[12,:SAFEGUARD],
			[15,:MACHPUNCH],
			[19,:SILVERWIND],
			[22,:COMETPUNCH],
			[26,:BATONPASS],
			[29,:AGILITY],
			[33,:BUGBUZZ],
			[36,:AIRSLASH],
			[40,:DOUBLEEDGE]],
		:compatiblemoves => [:AGILITY,:ACROBATICS,:AERIALACE,:AIRCUTTER,:BATONPASS,:BRICKBREAK,:BUGBITE,:CURSE,:DRAINPUNCH,:DOUBLEEDGE,:DYNAMICPUNCH,:DIG,:FLASH,:FLING,:FOCUSPUNCH,:GIGADRAIN,:HEADBUTT,:ICEPUNCH,:INFESTATION,:KNOCKOFF,:LIGHTSCREEN,:MEGAPUNCH,:MIMIC,:OMINOUSWIND,:POWERUPPUNCH,:REFLECT,:ROLLOUT,:ROOST,:SAFEGUARD,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SWEETSCENT,:TAILWIND,:THIEF,:THUNDERPUNCH,:UPROAR,:UTURN,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 10,
		:Weight => 108,
		:kind => "Five Star",
		:dexentry => "Ledyba communicate using a fluid that they secrete from where the legs join the body. They can convey feelings to others by altering the fluid's scent.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LEDIAN,:Level,18]
		]
	},

	:OnCreation => {},
},

:LEDIAN => {
	"Normal Form" => {
		:name => "Ledian",
		:dexnum => 166,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [55, 35, 50, 55, 110, 85],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SWARM, :EARLYBIRD],
		:HiddenAbilities => :IRONFIST,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 137,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :LEDYBA,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:SUPERSONIC],
			[1,:SWIFT],
			[5,:SUPERSONIC],
			[8,:SWIFT],
			[12,:LIGHTSCREEN],
			[12,:REFLECT],
			[12,:SAFEGUARD],
			[15,:MACHPUNCH],
			[20,:SILVERWIND],
			[24,:COMETPUNCH],
			[29,:BATONPASS],
			[33,:AGILITY],
			[38,:BUGBUZZ],
			[42,:AIRSLASH],
			[47,:DOUBLEEDGE]],
		:compatiblemoves => [:AGILITY,:ACROBATICS,:AERIALACE,:AIRCUTTER,:BATONPASS,:BRICKBREAK,:BUGBITE,:CLOSECOMBAT,:CURSE,:DEFOG,:DOUBLEEDGE,:DYNAMICPUNCH,:DRAINPUNCH,:DUALWINGBEAT,:FLASH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:ICEPUNCH,:INFESTATION,:KNOCKOFF,:LIGHTSCREEN,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OMINOUSWIND,:POWERUPPUNCH,:REFLECT,:ROLLOUT,:ROCKSMASH,:ROOST,:SAFEGUARD,:SKITTERSMACK,:SOLARBEAM,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:STRINGSHOT,:SWEETSCENT,:TAILWIND,:THIEF,:THUNDERPUNCH,:UPROAR,:UTURN,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 14,
		:Weight => 356,
		:kind => "Five Star",
		:dexentry => "It is said that in lands with clean air, where the stars fill the sky, Ledian thrive. For good reason, they use the light of the stars as energy.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SPINARAK => {
	"Normal Form" => {
		:name => "Spinarak",
		:dexnum => 167,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [40, 60, 40, 40, 40, 30],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SWARM, :INSOMNIA],
		:HiddenAbilities => :SNIPER,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BATONPASS,:DISABLE,:ELECTROWEB,:LUNGE,:MEGAHORN,:NIGHTSLASH,:PSYBEAM,:PURSUIT,:RAGEPOWDER,:SIGNALBEAM,:SONICBOOM,:TOXICSPIKES,:TWINEEDLE,],
		:Moveset => [
			[1,:POISONSTING],
			[1,:STRINGSHOT],
			[1,:CONSTRICT],
			[5,:ABSORB],
			[8,:INFESTATION],
			[12,:SCARYFACE],
			[15,:NIGHTSHADE],
			[19,:SHADOWSNEAK],
			[22,:FURYSWIPES],
			[26,:SUCKERPUNCH],
			[29,:SPIDERWEB],
			[33,:AGILITY],
			[36,:PINMISSILE],
			[40,:PSYCHIC],
			[43,:POISONJAB],
			[47,:CROSSPOISON],
			[50,:STICKYWEB],
			[54,:TOXICTHREAD]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BOUNCE,:BODYSLAM,:BUGBITE,:CURSE,:DIG,:DOUBLEEDGE,:ELECTROWEB,:FLASH,:FOULPLAY,:GIGADRAIN,:HONECLAWS,:INFESTATION,:LEECHLIFE,:MEGAHORN,:MIMIC,:PINMISSILE,:POISONJAB,:PSYCHIC,:SCREECH,:SIGNALBEAM,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUCKERPUNCH,:SUNNYDAY,:THIEF,:TOXICSPIKES,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWMIST,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 5,
		:Weight => 85,
		:kind => "String Spit",
		:dexentry => "The web it spins can be considered its second nervous system. A Spinarak can determine its prey by the tiny vibrations it feels through the web.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ARIADOS,:Level,22]
		]
	},

	:OnCreation => {},
},

:ARIADOS => {
	"Normal Form" => {
		:name => "Ariados",
		:dexnum => 168,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [70, 90, 70, 60, 70, 40],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWARM, :INSOMNIA],
		:HiddenAbilities => :SNIPER,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 140,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SPINARAK,
			:form => 0
		},
		:Moveset => [
			[0,:SWORDSDANCE],
			[1,:FOCUSENERGY],
			[1,:VENOMDRENCH],
			[1,:FELLSTINGER],
			[1,:BUGBITE],
			[1,:POISONSTING],
			[1,:STRINGSHOT],
			[1,:CONSTRICT],
			[1,:ABSORB],
			[5,:ABSORB],
			[8,:INFESTATION],
			[12,:SCARYFACE],
			[15,:NIGHTSHADE],
			[19,:SHADOWSNEAK],
			[23,:FURYSWIPES],
			[28,:SUCKERPUNCH],
			[32,:SPIDERWEB],
			[37,:AGILITY],
			[41,:PINMISSILE],
			[46,:PSYCHIC],
			[50,:POISONJAB],
			[55,:CROSSPOISON],
			[58,:STICKYWEB],
			[60,:TOXICTHREAD]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BOUNCE,:BODYSLAM,:BUGBITE,:BUGBUZZ,:CURSE,:DARKESTLARIAT,:DIG,:DOUBLEEDGE,:ELECTROWEB,:FLASH,:FOULPLAY,:FOCUSENERGY,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:HONECLAWS,:INFESTATION,:LEECHLIFE,:MEGAHORN,:MIMIC,:PINMISSILE,:POISONJAB,:PSYCHIC,:SIGNALBEAM,:SLUDGEBOMB,:SMARTSTRIKE,:SOLARBEAM,:STOMPINGTANTRUM,:STRINGSHOT,:STRUGGLEBUG,:SUCKERPUNCH,:SUNNYDAY,:THIEF,:THROATCHOP,:SPIKES,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 11,
		:Weight => 335,
		:kind => "Long Leg",
		:dexentry => "Its feet are tipped with tiny claws that enable it to scuttle on ceilings and vertical walls. It constricts its foe with thin and strong silk webbing.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CROBAT => {
	"Normal Form" => {
		:name => "Crobat",
		:dexnum => 169,
		:Type1 => :POISON,
		:Type2 => :FLYING,
		:BaseStats => [85, 90, 80, 70, 80, 130],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:INNERFOCUS, :INFILTRATOR],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 241,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :GOLBAT,
			:form => 0
		},
		:Moveset => [
			[0,:CROSSPOISON],
			[1,:SCREECH],
			[1,:ABSORB],
			[1,:SUPERSONIC],
			[1,:ASTONISH],
			[1,:BITE],
			[5,:SUPERSONIC],
			[7,:ASTONISH],
			[11,:BITE],
			[13,:WINGATTACK],
			[17,:CONFUSERAY],
			[19,:AIRCUTTER],
			[24,:SWIFT],
			[27,:POISONFANG],
			[32,:MEANLOOK],
			[35,:LEECHLIFE],
			[40,:HAZE],
			[43,:VENOSHOCK],
			[48,:AIRSLASH],
			[51,:QUICKGUARD]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BIDE,:BRAVEBIRD,:CROSSPOISON,:CRUNCH,:CURSE,:DARKPULSE,:DEFOG,:DETECT,:DOUBLEEDGE,:FLY,:DUALWINGBEAT,:FEINTATTACK,:FLY,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HEX,:HURRICANE,:HYPERBEAM,:HYPNOSIS,:LEECHLIFE,:MEGADRAIN,:MIMIC,:NASTYPLOT,:OMINOUSWIND,:PAYBACK,:PLUCK,:RAGE,:RAINDANCE,:RAZORWIND,:ROOST,:SCREECH,:SHADOWBALL,:SKYATTACK,:SLUDGEBOMB,:SNATCH,:STEELWING,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAILWIND,:TAKEDOWN,:TAUNT,:THIEF,:TORMENT,:TWISTER,:UPROAR,:UTURN,:VENOMDRENCH,:VENOSHOCK,:WHIRLWIND,:XSCISSOR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Flying],
		:Height => 18,
		:Weight => 750,
		:kind => "Bat",
		:dexentry => "Over the course of evolution, its hind legs turned into wings. By alternately resting its front and rear wings, it can fly all day without having to stop.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:CHINCHOU => {
	"Normal Form" => {
		:name => "Chinchou",
		:dexnum => 170,
		:Type1 => :WATER,
		:Type2 => :ELECTRIC,
		:BaseStats => [75, 38, 38, 56, 56, 67],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:VOLTABSORB, :ILLUMINATE],
		:HiddenAbilities => :WATERABSORB,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:AMNESIA,:BRINE,:FLAIL,:MIST,:PSYBEAM,:SCREECH,:SHOCKWAVE,:SOAK,:WATERPULSE,:WHIRLPOOL,],
		:Moveset => [
			[1,:BUBBLE],
			[1,:SUPERSONIC],
			[6,:THUNDERWAVE],
			[9,:ELECTROBALL],
			[12,:WATERGUN],
			[17,:CONFUSERAY],
			[20,:BUBBLEBEAM],
			[23,:SPARK],
			[28,:SIGNALBEAM],
			[31,:FLAIL],
			[34,:DISCHARGE],
			[39,:TAKEDOWN],
			[42,:AQUARING],
			[45,:HYDROPUMP],
			[47,:IONDELUGE],
			[50,:CHARGE]],
		:compatiblemoves => [:AMNESIA,:AGILITY,:BLIZZARD,:BRINE,:BOUNCE,:CURSE,:CHARGEBEAM,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:ELECTROBALL,:FLASH,:HAIL,:HEALBELL,:HYDROPUMP,:ICEBEAM,:ICYWIND,:MIMIC,:RAINDANCE,:RISINGVOLTAGE,:SCREECH,:SCALD,:SHOCKWAVE,:SIGNALBEAM,:SUCKERPUNCH,:SURF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:VOLTSWITCH,:WATERFALL,:WHIRLPOOL,:WATERPULSE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 5,
		:Weight => 120,
		:WildItemUncommon => :DEEPSEASCALE,
		:kind => "Angler",
		:dexentry => "When it senses danger, it discharges positive and negative electricity from its two antennae. It lives in depths beyond sunlight's reach.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 10,
		:evolutions => [
			[:LANTURN,:Level,27]
		]
	},

	:OnCreation => {},
},

:LANTURN => {
	"Normal Form" => {
		:name => "Lanturn",
		:dexnum => 171,
		:Type1 => :WATER,
		:Type2 => :ELECTRIC,
		:BaseStats => [125, 58, 58, 76, 76, 67],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:VOLTABSORB, :ILLUMINATE],
		:HiddenAbilities => :WATERABSORB,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHINCHOU,
			:form => 0
		},
		:Moveset => [
			[0,:STOCKPILE],
			[0,:SWALLOW],
			[0,:SPITUP],
			[1,:EERIEIMPULSE],
			[1,:SPOTLIGHT],
			[1,:BUBBLE],
			[1,:SUPERSONIC],
			[1,:THUNDERWAVE],
			[1,:ELECTROBALL],
			[6,:THUNDERWAVE],
			[9,:ELECTROBALL],
			[12,:WATERGUN],
			[17,:CONFUSERAY],
			[20,:BUBBLEBEAM],
			[23,:SPARK],
			[29,:SIGNALBEAM],
			[33,:FLAIL],
			[37,:DISCHARGE],
			[43,:TAKEDOWN],
			[47,:AQUARING],
			[51,:HYDROPUMP],
			[54,:IONDELUGE],
			[58,:CHARGE]],
		:compatiblemoves => [:AQUATAIL,:AMNESIA,:AGILITY,:BLIZZARD,:BRINE,:BOUNCE,:CHARGEBEAM,:CURSE,:DAZZLINGGLEAM,:DIVE,:DOUBLEEDGE,:ELECTROBALL,:FLASH,:GIGAIMPACT,:HAIL,:HEALBELL,:HYPERBEAM,:HYDROPUMP,:ICEBEAM,:ICYWIND,:MIMIC,:RAINDANCE,:RISINGVOLTAGE,:SCREECH,:SCALD,:SHOCKWAVE,:SIGNALBEAM,:SUCKERPUNCH,:SURF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:VOLTSWITCH,:WHIRLPOOL,:WATERFALL,:WATERPULSE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 12,
		:Weight => 225,
		:WildItemUncommon => :DEEPSEASCALE,
		:kind => "Light",
		:dexentry => "The light-emitting orbs on its back are very bright. They are formed from a part of its dorsal fin. It illuminates the inky darkness of deep seas.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:PICHU => {
	"Normal Form" => {
		:name => "Pichu",
		:dexnum => 172,
		:Type1 => :ELECTRIC,
		:BaseStats => [20, 40, 15, 35, 35, 60],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:STATIC, :LIGHTNINGROD],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 41,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 2805,
		:EggMoves => [:BESTOW,:BIDE,:CHARGE,:DISARMINGVOICE,:DOUBLESLAP,:ELECTRICTERRAIN,:ENCORE,:ENDURE,:FAKEOUT,:FLAIL,:LUCKYCHANT,:PRESENT,:REVERSAL,:THUNDERPUNCH,:TICKLE,:WISH,:VOLTTACKLE,],
		:Moveset => [
			[1,:THUNDERSHOCK],
			[1,:CHARM],
			[5,:TAILWHIP],
			[10,:SWEETKISS],
			[13,:NASTYPLOT],
			[18,:THUNDERWAVE]],
		:compatiblemoves => [:BODYSLAM,:CHARM,:CELEBRATE,:CHARGEBEAM,:COVET,:COUNTER,:CURSE,:DETECT,:DOUBLEEDGE,:ENCORE,:ELECTRICTERRAIN,:ELECTROBALL,:ECHOEDVOICE,:ELECTROWEB,:FLASH,:FLING,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:IRONTAIL,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MAGNETRISE,:MUDSLAP,:NASTYPLOT,:PAINSPLIT,:PLAYROUGH,:RAINDANCE,:REVERSAL,:ROLLOUT,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 20,
		:kind => "Tiny Mouse",
		:dexentry => "It is still inept at retaining electricity. When it is startled, it discharges power accidentally. It gets better at holding power as it grows older.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PIKACHU,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:CLEFFA => {
	"Normal Form" => {
		:name => "Cleffa",
		:dexnum => 173,
		:Type1 => :FAIRY,
		:BaseStats => [50, 25, 28, 45, 55, 15],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:CUTECHARM, :MAGICGUARD],
		:HiddenAbilities => :FRIENDGUARD,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 44,
		:CatchRate => 150,
		:Happiness => 140,
		:EggSteps => 2805,
		:EggMoves => [:AMNESIA,:AROMATHERAPY,:BELLYDRUM,:COVET,:FAKETEARS,:HEALPULSE,:METRONOME,:MIMIC,:MISTYTERRAIN,:PRESENT,:SPLASH,:STOREDPOWER,:TICKLE,:WISH,],
		:Moveset => [
			[1,:POUND],
			[1,:CHARM],
			[4,:ENCORE],
			[7,:SING],
			[10,:SWEETKISS],
			[13,:COPYCAT],
			[16,:MAGICALLEAF]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BODYSLAM,:COVET,:COUNTER,:CURSE,:DIG,:DRAININGKISS,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:ENDEAVOR,:ENCORE,:FAKETEARS,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:ICYWIND,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PLAYROUGH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SOLARBEAM,:SUNNYDAY,:STOREDPOWER,:TELEKINESIS,:THUNDERWAVE,:TRICK,:UPROAR,:WATERPULSE,:WONDERROOM,:WORKUP,:ZENHEADBUTT,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Mountain",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 30,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Star Shape",
		:dexentry => "On nights with many shooting stars, Cleffa can be seen dancing in a ring. They dance until daybreak, when they quench their thirst with the morning dew.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 29,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CLEFAIRY,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:IGGLYBUFF => {
	"Normal Form" => {
		:name => "Igglybuff",
		:dexnum => 174,
		:Type1 => :NORMAL,
		:Type2 => :FAIRY,
		:BaseStats => [90, 30, 15, 40, 20, 15],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:CUTECHARM, :COMPETITIVE],
		:HiddenAbilities => :FRIENDGUARD,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 42,
		:CatchRate => 170,
		:Happiness => 70,
		:EggSteps => 2805,
		:EggMoves => [:CAPTIVATE,:COVET,:FAKETEARS,:FEINTATTACK,:GRAVITY,:HEALPULSE,:LASTRESORT,:MISTYTERRAIN,:PERISHSONG,:PRESENT,:PUNISHMENT,:SLEEPTALK,:WISH,],
		:Moveset => [
			[1,:SING],
			[1,:CHARM],
			[3,:DEFENSECURL],
			[5,:POUND],
			[9,:SWEETKISS],
			[11,:COPYCAT]],
		:compatiblemoves => [:BOUNCE,:CHARM,:COVET,:CURSE,:COUNTER,:DIG,:DREAMEATER,:DRAININGKISS,:DETECT,:DOUBLEEDGE,:ECHOEDVOICE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:INCINERATE,:ICYWIND,:LASTRESORT,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MISTYTERRAIN,:MAGICCOAT,:MIMIC,:MUDSLAP,:PAINSPLIT,:PLAYROUGH,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:SUNNYDAY,:THUNDERWAVE,:UPROAR,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 10,
		:kind => "Balloon",
		:dexentry => "Its soft and pliable body is very bouncy. When it sings continuously with all its might, its body steadily turns a deepening pink color.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:JIGGLYPUFF,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:TOGEPI => {
	"Normal Form" => {
		:name => "Togepi",
		:dexnum => 175,
		:Type1 => :FAIRY,
		:BaseStats => [35, 20, 65, 40, 65, 20],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:HUSTLE, :SERENEGRACE],
		:HiddenAbilities => :SUPERLUCK,
		:GrowthRate => :Fast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 49,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 2805,
		:EggMoves => [:EXTRASENSORY,:FORESIGHT,:FUTURESIGHT,:LUCKYCHANT,:MIRRORMOVE,:MORNINGSUN,:NASTYPLOT,:PECK,:PRESENT,:PSYCHOSHIFT,:SECRETPOWER,:STOREDPOWER,],
		:Moveset => [
			[1,:GROWL],
			[1,:CHARM],
			[5,:METRONOME],
			[9,:SWEETKISS],
			[13,:YAWN],
			[17,:ENCORE],
			[21,:FOLLOWME],
			[25,:BESTOW],
			[29,:WISH],
			[33,:ANCIENTPOWER],
			[37,:SAFEGUARD],
			[41,:BATONPASS],
			[45,:DOUBLEEDGE],
			[49,:LASTRESORT],
			[53,:AFTERYOU]],
		:compatiblemoves => [:AFTERYOU,:COVET,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DREAMEATER,:DRAININGKISS,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:FUTURESIGHT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HYPERVOICE,:INCINERATE,:LASTRESORT,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:METRONOME,:MEGAKICK,:MEGAPUNCH,:MYSTICALFIRE,:NASTYPLOT,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PLAYROUGH,:RAINDANCE,:REFLECT,:ROCKSMASH,:ROLLOUT,:ROLLOUT,:SEISMICTOSS,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SOFTBOILED,:SOLARBEAM,:SUNNYDAY,:SWIFT,:STOREDPOWER,:TELEKINESIS,:THUNDERWAVE,:TRICK,:UPROAR,:WATERPULSE,:WORKUP,:ZENHEADBUTT,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWSHED,],
		:Color => "White",
		:Habitat => "Forest",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 15,
		:kind => "Spike Ball",
		:dexentry => "As its energy, it uses the positive feelings exuded by people and Pokémon. It stores up happy feelings in its shell, then shares them.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TOGETIC,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:TOGETIC => {
	"Normal Form" => {
		:name => "Togetic",
		:dexnum => 176,
		:Type1 => :FAIRY,
		:Type2 => :FLYING,
		:BaseStats => [55, 40, 85, 80, 105, 40],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:HUSTLE, :SERENEGRACE],
		:HiddenAbilities => :SUPERLUCK,
		:GrowthRate => :Fast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :TOGEPI,
			:form => 0
		},
		:Moveset => [
			[1,:MAGICALLEAF],
			[1,:GROWL],
			[1,:CHARM],
			[1,:METRONOME],
			[1,:SWEETKISS],
			[5,:METRONOME],
			[9,:SWEETKISS],
			[13,:YAWN],
			[14,:FAIRYWIND],
			[17,:ENCORE],
			[21,:FOLLOWME],
			[25,:BESTOW],
			[29,:WISH],
			[33,:ANCIENTPOWER],
			[37,:SAFEGUARD],
			[41,:BATONPASS],
			[45,:DOUBLEEDGE],
			[49,:LASTRESORT],
			[53,:AFTERYOU]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AIRCUTTER,:ANCIENTPOWER,:BATONPASS,:BODYSLAM,:BRICKBREAK,:COVET,:CHARM,:CURSE,:DAZZLINGGLEAM,:DEFOG,:DEFENSECURL,:DETECT,:DOUBLEEDGE,:DRAINPUNCH,:DRAININGKISS,:DREAMEATER,:DUALWINGBEAT,:ENCORE,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:FLY,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HEATWAVE,:HYPERBEAM,:HYPERVOICE,:HELPINGHAND,:INCINERATE,:IMPRISON,:LASTRESORT,:LIGHTSCREEN,:MUDSLAP,:MAGICALLEAF,:MIMIC,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MYSTICALFIRE,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PLAYROUGH,:RAINDANCE,:RETALIATE,:REFLECT,:RETALIATE,:ROCKSMASH,:ROLLOUT,:ROOST,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SILVERWIND,:SKYATTACK,:SMARTSTRIKE,:SEISMICTOSS,:SOLARBEAM,:STEELWING,:SUNNYDAY,:SWIFT,:STOREDPOWER,:SOFTBOILED,:TAILWIND,:TELEKINESIS,:THUNDERWAVE,:TRICK,:TRIATTACK,:WATERPULSE,:WORKUP,:ZENHEADBUTT,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Forest",
		:EggGroups => [:Flying, :Fairy],
		:Height => 6,
		:Weight => 32,
		:kind => "Happiness",
		:dexentry => "It is said to be a Pokémon that brings good luck. When it spots someone who is pure of heart, a Togetic appears and shares its happiness with them.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 13,
		:evolutions => [
			[:TOGEKISS,:Item,:SHINYSTONE]
		]
	},

	:OnCreation => {},
},

:NATU => {
	"Normal Form" => {
		:name => "Natu",
		:dexnum => 177,
		:Type1 => :PSYCHIC,
		:Type2 => :FLYING,
		:BaseStats => [40, 50, 45, 70, 45, 70],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:SYNCHRONIZE, :EARLYBIRD],
		:HiddenAbilities => :MAGICBOUNCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 64,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ALLYSWITCH,:DRILLPECK,:FEATHERDANCE,:FEINTATTACK,:HAZE,:QUICKATTACK,:REFRESH,:ROOST,:SIMPLEBEAM,:SKILLSWAP,:STEELWING,:SUCKERPUNCH,:SYNCHRONOISE,:ZENHEADBUTT,],
		:Moveset => [
			[1,:PECK],
			[1,:LEER],
			[6,:NIGHTSHADE],
			[9,:TELEPORT],
			[12,:LUCKYCHANT],
			[17,:STOREDPOWER],
			[20,:OMINOUSWIND],
			[23,:CONFUSERAY],
			[28,:WISH],
			[33,:PSYCHIC],
			[36,:MIRACLEEYE],
			[39,:PSYCHOSHIFT],
			[44,:FUTURESIGHT],
			[47,:POWERSWAP],
			[47,:GUARDSWAP],
			[50,:MEFIRST]],
		:compatiblemoves => [:AIRSLASH,:AERIALACE,:AIRCUTTER,:ALLYSWITCH,:BATONPASS,:CALMMIND,:CURSE,:COSMICPOWER,:DETECT,:DAZZLINGGLEAM,:DREAMEATER,:DUALWINGBEAT,:DOUBLEEDGE,:EXPANDINGFORCE,:FLASH,:FUTURESIGHT,:GIGADRAIN,:GRASSKNOT,:GUARDSWAP,:HEATWAVE,:IMPRISON,:LIGHTSCREEN,:MIMIC,:MAGICROOM,:POWERSWAP,:OMINOUSWIND,:PAINSPLIT,:PSYCHIC,:PLUCK,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROOST,:SILVERWIND,:STOREDPOWER,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKYATTACK,:SOLARBEAM,:STEELWING,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILWIND,:TELEKINESIS,:THIEF,:THUNDERWAVE,:TRICK,:TRICKROOM,:TWISTER,:UTURN,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 2,
		:Weight => 20,
		:kind => "Tiny Bird",
		:dexentry => "It runs up short trees that grow on the savanna to peck at new shoots. A Natu's eyes look as if they are always observing something.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:XATU,:Level,25]
		]
	},

	:OnCreation => {},
},

:XATU => {
	"Normal Form" => {
		:name => "Xatu",
		:dexnum => 178,
		:Type1 => :PSYCHIC,
		:Type2 => :FLYING,
		:BaseStats => [65, 75, 70, 95, 70, 95],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:SYNCHRONIZE, :EARLYBIRD],
		:HiddenAbilities => :MAGICBOUNCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 165,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NATU,
			:form => 0
		},
		:Moveset => [
			[0,:AIRSLASH],
			[1,:TAILWIND],
			[1,:PECK],
			[1,:LEER],
			[1,:NIGHTSHADE],
			[1,:TELEPORT],
			[6,:NIGHTSHADE],
			[9,:TELEPORT],
			[12,:LUCKYCHANT],
			[17,:STOREDPOWER],
			[20,:OMINOUSWIND],
			[23,:CONFUSERAY],
			[29,:WISH],
			[35,:PSYCHIC],
			[39,:MIRACLEEYE],
			[43,:PSYCHOSHIFT],
			[49,:FUTURESIGHT],
			[53,:POWERSWAP],
			[53,:GUARDSWAP],
			[57,:MEFIRST]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:ALLYSWITCH,:BATONPASS,:CALMMIND,:COSMICPOWER,:CURSE,:DETECT,:DAZZLINGGLEAM,:DEFOG,:DOUBLEEDGE,:DREAMEATER,:DUALWINGBEAT,:EXPANDINGFORCE,:FLASH,:FLY,:FOULPLAY,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HEATWAVE,:HYPERBEAM,:LASERFOCUS,:LIGHTSCREEN,:MAGICROOM,:MIMIC,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PLUCK,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROOST,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKYATTACK,:SOLARBEAM,:STEELWING,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:SILVERWIND,:TAILWIND,:TELEKINESIS,:THIEF,:THUNDERWAVE,:TRICK,:TRICKROOM,:TWISTER,:UTURN,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 15,
		:Weight => 150,
		:kind => "Mystic",
		:dexentry => "It has the enigmatic power of foreseeing the future. Some people in different lands have long believed that Xatu are emissaries from another world.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MAREEP => {
	"Normal Form" => {
		:name => "Mareep",
		:dexnum => 179,
		:Type1 => :ELECTRIC,
		:BaseStats => [55, 40, 40, 65, 45, 35],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:STATIC, :PLUS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 235,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AFTERYOU,:AGILITY,:BODYSLAM,:CHARGE,:EERIEIMPULSE,:ELECTRICTERRAIN,:FLATTER,:IRONTAIL,:ODORSLEUTH,:SANDATTACK,:SCREECH,:TAKEDOWN,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[4,:THUNDERWAVE],
			[8,:THUNDERSHOCK],
			[11,:COTTONSPORE],
			[15,:CHARGE],
			[18,:TAKEDOWN],
			[22,:ELECTROBALL],
			[25,:CONFUSERAY],
			[29,:POWERGEM],
			[32,:DISCHARGE],
			[36,:COTTONGUARD],
			[39,:SIGNALBEAM],
			[43,:LIGHTSCREEN],
			[46,:THUNDER]],
		:compatiblemoves => [:AGILITY,:AFTERYOU,:BODYSLAM,:CURSE,:CHARGEBEAM,:DEFENSECURL,:DOUBLEEDGE,:ECHOEDVOICE,:ELECTROWEB,:ELECTRICTERRAIN,:EERIEIMPULSE,:FLASH,:HEADBUTT,:HEALBELL,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:MAGNETRISE,:RAINDANCE,:REFLECT,:SAFEGUARD,:SHOCKWAVE,:SIGNALBEAM,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "White",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 6,
		:Weight => 78,
		:kind => "Wool",
		:dexentry => "Its fluffy wool rubs together and builds a static charge. The more energy is charged, the more brightly the lightbulb at the tip of its tail glows.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:FLAAFFY,:Level,15]
		]
	},

	:OnCreation => {},
},

:FLAAFFY => {
	"Normal Form" => {
		:name => "Flaaffy",
		:dexnum => 180,
		:Type1 => :ELECTRIC,
		:BaseStats => [70, 55, 55, 80, 60, 45],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:STATIC, :PLUS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 128,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MAREEP,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[1,:THUNDERWAVE],
			[1,:THUNDERSHOCK],
			[4,:THUNDERWAVE],
			[8,:THUNDERSHOCK],
			[11,:COTTONSPORE],
			[16,:CHARGE],
			[20,:TAKEDOWN],
			[25,:ELECTROBALL],
			[29,:CONFUSERAY],
			[34,:POWERGEM],
			[38,:DISCHARGE],
			[43,:COTTONGUARD],
			[47,:SIGNALBEAM],
			[52,:LIGHTSCREEN],
			[56,:THUNDER]],
		:compatiblemoves => [:AGILITY,:AFTERYOU,:BODYSLAM,:BRICKBREAK,:CURSE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:ELECTRICTERRAIN,:EERIEIMPULSE,:ECHOEDVOICE,:ELECTROWEB,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:HEADBUTT,:HEALBELL,:IRONTAIL,:LIGHTSCREEN,:MEGAPUNCH,:MEGAKICK,:MAGNETRISE,:MIMIC,:POWERUPPUNCH,:RAINDANCE,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:STRENGTH,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 8,
		:Weight => 133,
		:kind => "Wool",
		:dexentry => "Its fleece quality changes to generate strong static electricity with a small amount of wool. The bare, slick parts of its hide are shielded against electricity.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:AMPHAROS,:Level,30]
		]
	},

	:OnCreation => {},
},

:AMPHAROS => {
	"Normal Form" => {
		:name => "Ampharos",
		:dexnum => 181,
		:Type1 => :ELECTRIC,
		:BaseStats => [90, 75, 85, 115, 90, 55],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:STATIC, :PLUS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 230,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :FLAAFFY,
			:form => 0
		},
		:Moveset => [
			[0,:THUNDERPUNCH],
			[1,:ZAPCANNON],
			[1,:MAGNETICFLUX],
			[1,:IONDELUGE],
			[1,:DRAGONPULSE],
			[1,:FIREPUNCH],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:THUNDERWAVE],
			[1,:THUNDERSHOCK],
			[4,:THUNDERWAVE],
			[8,:THUNDERSHOCK],
			[11,:COTTONSPORE],
			[16,:CHARGE],
			[20,:TAKEDOWN],
			[25,:ELECTROBALL],
			[29,:CONFUSERAY],
			[35,:POWERGEM],
			[40,:DISCHARGE],
			[46,:COTTONGUARD],
			[51,:SIGNALBEAM],
			[57,:LIGHTSCREEN],
			[62,:THUNDER],
			[65,:DRAGONPULSE]],
		:compatiblemoves => [:AGILITY,:AFTERYOU,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CHARGEBEAM,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:DYNAMICPUNCH,:ECHOEDVOICE,:ELECTROWEB,:ELECTRICTERRAIN,:EERIEIMPULSE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HYPERBEAM,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:OUTRAGE,:POWERUPPUNCH,:POWERGEM,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:STRENGTH,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Monster, :Field],
		:Height => 14,
		:Weight => 615,
		:kind => "Light",
		:dexentry => "It gives off so much light that it can be seen from space. People in the old days used its light to send signals back and forth with others far away.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :DRAGON,
		:BaseStats => [90, 95, 105, 165, 110, 45],
		:Abilities => [:MOLDBREAKER],
		:Weight => 615,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:AMPHAROSITE => 1,
	},
},

:BELLOSSOM => {
	"Normal Form" => {
		:name => "Bellossom",
		:dexnum => 182,
		:Type1 => :GRASS,
		:BaseStats => [75, 80, 95, 90, 100, 50],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:CHLOROPHYLL, :HEALER],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 216,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GLOOM,
			:form => 0
		},
		:Moveset => [
			[0,:MAGICALLEAF],
			[1,:LEAFSTORM],
			[1,:LEAFBLADE],
			[1,:MEGADRAIN],
			[1,:SWEETSCENT],
			[1,:STUNSPORE],
			[1,:SUNNYDAY],
			[39,:QUIVERDANCE],
			[49,:PETALBLIZZARD],
			[59,:PETALDANCE],
			[69,:LEAFSTORM]],
		:compatiblemoves => [:AFTERYOU,:BATONPASS,:BIDE,:BULLETSEED,:CHARM,:CURSE,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:DRAINPUNCH,:ENERGYBALL,:FLASH,:FLING,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:INFESTATION,:LASERFOCUS,:LEAFBLADE,:LEAFSTORM,:MAGICALLEAF,:MEGADRAIN,:MIMIC,:NATUREPOWER,:PLAYROUGH,:RAGE,:REFLECT,:SAFEGUARD,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:UPROAR,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 4,
		:Weight => 58,
		:WildItemUncommon => :ABSORBBULB,
		:kind => "Flower",
		:dexentry => "Its flower petals deepen in color through exposure to sunlight. When cloudy weather persists, it does a dance that is thought to summon the sun.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MARILL => {
	"Normal Form" => {
		:name => "Marill",
		:dexnum => 183,
		:Type1 => :WATER,
		:Type2 => :FAIRY,
		:BaseStats => [70, 20, 50, 20, 50, 40],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :HUGEPOWER],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 88,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 2805,
		:EggMoves => [:AMNESIA,:AQUAJET,:BELLYDRUM,:BODYSLAM,:CAMOUFLAGE,:FUTURESIGHT,:MUDDYWATER,:PERISHSONG,:PRESENT,:REFRESH,:SUPERPOWER,:SUPERSONIC,:WATERSPORT,],
		:preevo => {
			:species => :AZURILL,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:WATERGUN],
			[2,:TAILWHIP],
			[5,:WATERSPORT],
			[7,:BUBBLE],
			[10,:DEFENSECURL],
			[10,:ROLLOUT],
			[13,:BUBBLEBEAM],
			[16,:HELPINGHAND],
			[20,:AQUATAIL],
			[23,:PLAYROUGH],
			[28,:AQUARING],
			[31,:RAINDANCE],
			[37,:DOUBLEEDGE],
			[40,:SUPERPOWER],
			[47,:HYDROPUMP]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BRUTALSWING,:CHARM,:COVET,:CURSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ENCORE,:FAKETEARS,:FLING,:FOCUSPUNCH,:FUTURESIGHT,:GRASSKNOT,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:ROLLOUT,:SCALD,:SEISMICTOSS,:STEELROLLER,:STRENGTH,:SUPERPOWER,:SURF,:SWIFT,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Fairy],
		:Height => 4,
		:Weight => 85,
		:kind => "Aqua Mouse",
		:dexentry => "It is covered with water-repellent fur. Because of the fur, it can swim through water at high speed without being slowed by the water's resistance.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:AZUMARILL,:Level,18]
		]
	},

	:OnCreation => {},
},

:AZUMARILL => {
	"Normal Form" => {
		:name => "Azumarill",
		:dexnum => 184,
		:Type1 => :WATER,
		:Type2 => :FAIRY,
		:BaseStats => [100, 50, 80, 60, 80, 50],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :HUGEPOWER],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 189,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :MARILL,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:WATERGUN],
			[1,:TAILWHIP],
			[1,:WATERSPORT],
			[2,:TAILWHIP],
			[5,:WATERSPORT],
			[7,:WATERGUN],
			[10,:DEFENSECURL],
			[10,:ROLLOUT],
			[13,:BUBBLEBEAM],
			[16,:HELPINGHAND],
			[21,:AQUATAIL],
			[25,:PLAYROUGH],
			[31,:AQUARING],
			[35,:RAINDANCE],
			[42,:DOUBLEEDGE],
			[46,:SUPERPOWER],
			[55,:HYDROPUMP]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CHARM,:COVET,:CURSE,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ENCORE,:FAKETEARS,:FLING,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:LIQUIDATION,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:ROLLOUT,:SCALD,:SEISMICTOSS,:STEELROLLER,:STRENGTH,:SUPERPOWER,:SURF,:SWIFT,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Fairy],
		:Height => 8,
		:Weight => 285,
		:kind => "Aqua Rabbit",
		:dexentry => "It lives in water virtually all day long. Its body color and pattern act as camouflage that makes it tough for enemies to spot in water.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SUDOWOODO => {
	"Normal Form" => {
		:name => "Sudowoodo",
		:dexnum => 185,
		:Type1 => :ROCK,
		:BaseStats => [70, 100, 115, 30, 65, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:STURDY, :ROCKHEAD],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 65,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CURSE,:DEFENSECURL,:ENDURE,:HARDEN,:HEADBUTT,:ROLLOUT,:SANDTOMB,:SELFDESTRUCT,:STEALTHROCK,],
		:preevo => {
			:species => :BONSLY,
			:form => 0
		},
		:Moveset => [
			[0,:SLAM],
			[1,:WOODHAMMER],
			[1,:COPYCAT],
			[1,:FLAIL],
			[1,:LOWKICK],
			[1,:ROCKTHROW],
			[5,:FLAIL],
			[8,:LOWKICK],
			[12,:ROCKTHROW],
			[15,:MIMIC],
			[19,:FEINTATTACK],
			[22,:TEARFULLOOK],
			[26,:ROCKTOMB],
			[29,:BLOCK],
			[33,:ROCKSLIDE],
			[36,:COUNTER],
			[40,:SUCKERPUNCH],
			[43,:DOUBLEEDGE],
			[47,:STONEEDGE],
			[50,:HAMMERARM],
			[54,:HEADSMASH]],
		:compatiblemoves => [:AFTERYOU,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CALMMIND,:COUNTER,:COVET,:CURSE,:DEFENSECURL,:DIG,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FAKETEARS,:FIREPUNCH,:FLING,:FOCUSPUNCH,:FOULPLAY,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:PSYCHUP,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:THIEF,:THUNDERPUNCH,:TORMENT,:UPROAR,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Mineral],
		:Height => 12,
		:Weight => 380,
		:kind => "Imitation",
		:dexentry => "It mimics a tree to avoid enemies. But since its forelegs remain green throughout the year, it is easily identified as a fake in the winter.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:POLITOED => {
	"Normal Form" => {
		:name => "Politoed",
		:dexnum => 186,
		:Type1 => :WATER,
		:BaseStats => [90, 75, 75, 90, 100, 70],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:WATERABSORB, :DAMP],
		:HiddenAbilities => :DRIZZLE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 225,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :POLIWHIRL,
			:form => 0
		},
		:Moveset => [
			[1,:BUBBLEBEAM],
			[1,:HYPNOSIS],
			[1,:DOUBLESLAP],
			[1,:PERISHSONG],
			[27,:SWAGGER],
			[37,:BOUNCE],
			[48,:HYPERVOICE]],
		:compatiblemoves => [:AMNESIA,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENCORE,:ENDEAVOR,:FISSURE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:HYPNOSIS,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LIQUIDATION,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PAYBACK,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:ROCKSMASH,:SCALD,:SEISMICTOSS,:SKULLBASH,:STRENGTH,:SUBMISSION,:SURF,:TAKEDOWN,:THIEF,:WATERFALL,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1],
		:Height => 11,
		:Weight => 339,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Frog",
		:dexentry => "The curled hair on its head proves its status as a king. It is said that the longer and curlier the hair, the more respect it earns from its peers.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 5,
	},

	:OnCreation => {},
},

:HOPPIP => {
	"Normal Form" => {
		:name => "Hoppip",
		:dexnum => 187,
		:Type1 => :GRASS,
		:Type2 => :FLYING,
		:BaseStats => [35, 35, 40, 35, 55, 50],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:CHLOROPHYLL, :LEAFGUARD],
		:HiddenAbilities => :INFILTRATOR,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:AROMATHERAPY,:CONFUSION,:COTTONGUARD,:DOUBLEEDGE,:ENCORE,:ENDURE,:GRASSYTERRAIN,:HELPINGHAND,:SEEDBOMB,:STRENGTHSAP,:WORRYSEED,],
		:Moveset => [
			[1,:SPLASH],
			[1,:ABSORB],
			[4,:SYNTHESIS],
			[6,:TAILWHIP],
			[8,:TACKLE],
			[10,:FAIRYWIND],
			[12,:POISONPOWDER],
			[14,:STUNSPORE],
			[16,:SLEEPPOWDER],
			[19,:BULLETSEED],
			[22,:LEECHSEED],
			[25,:MEGADRAIN],
			[28,:ACROBATICS],
			[31,:RAGEPOWDER],
			[34,:COTTONSPORE],
			[37,:UTURN],
			[40,:WORRYSEED],
			[43,:GIGADRAIN],
			[46,:BOUNCE],
			[49,:MEMENTO]],
		:compatiblemoves => [:ACROBATICS,:AMNESIA,:AERIALACE,:BOUNCE,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:GROWL,:GIGADRAIN,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:INFESTATION,:MIMIC,:PAYDAY,:PSYCHUP,:REFLECT,:SILVERWIND,:SEEDBOMB,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SWEETSCENT,:SYNTHESIS,:UTURN,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy, :Grass],
		:Height => 4,
		:Weight => 5,
		:kind => "Cottonweed",
		:dexentry => "This Pokémon drifts with the wind. If it senses the approach of strong winds, a Hoppip links leaves with others to prepare against being blown away.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 13,
		:evolutions => [
			[:SKIPLOOM,:Level,18]
		]
	},

	:OnCreation => {},
},

:SKIPLOOM => {
	"Normal Form" => {
		:name => "Skiploom",
		:dexnum => 188,
		:Type1 => :GRASS,
		:Type2 => :FLYING,
		:BaseStats => [55, 45, 50, 45, 65, 80],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:CHLOROPHYLL, :LEAFGUARD],
		:HiddenAbilities => :INFILTRATOR,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 119,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :HOPPIP,
			:form => 0
		},
		:Moveset => [
			[1,:SPLASH],
			[1,:ABSORB],
			[1,:SYNTHESIS],
			[1,:TAILWHIP],
			[4,:SYNTHESIS],
			[6,:TAILWHIP],
			[8,:TACKLE],
			[10,:FAIRYWIND],
			[12,:POISONPOWDER],
			[14,:STUNSPORE],
			[16,:SLEEPPOWDER],
			[20,:BULLETSEED],
			[24,:LEECHSEED],
			[28,:MEGADRAIN],
			[32,:ACROBATICS],
			[36,:RAGEPOWDER],
			[40,:COTTONSPORE],
			[44,:UTURN],
			[48,:WORRYSEED],
			[52,:GIGADRAIN],
			[56,:BOUNCE],
			[60,:MEMENTO]],
		:compatiblemoves => [:ACROBATICS,:AMNESIA,:AERIALACE,:BOUNCE,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:INFESTATION,:MIMIC,:PSYCHUP,:PAYDAY,:REFLECT,:SEEDBOMB,:SOLARBEAM,:SILVERWIND,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:UTURN,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy, :Grass],
		:Height => 6,
		:Weight => 10,
		:kind => "Cottonweed",
		:dexentry => "It blossoms when the temperature rises above 64 degrees F. Because its flower's blooming changes with the temperature, it is used as a thermometer.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 15,
		:evolutions => [
			[:JUMPLUFF,:Level,27]
		]
	},

	:OnCreation => {},
},

:JUMPLUFF => {
	"Normal Form" => {
		:name => "Jumpluff",
		:dexnum => 189,
		:Type1 => :GRASS,
		:Type2 => :FLYING,
		:BaseStats => [75, 55, 70, 55, 95, 110],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:CHLOROPHYLL, :LEAFGUARD],
		:HiddenAbilities => :INFILTRATOR,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 203,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SKIPLOOM,
			:form => 0
		},
		:Moveset => [
			[1,:SPLASH],
			[1,:ABSORB],
			[1,:SYNTHESIS],
			[1,:TAILWHIP],
			[4,:SYNTHESIS],
			[6,:TAILWHIP],
			[8,:TACKLE],
			[10,:FAIRYWIND],
			[12,:POISONPOWDER],
			[14,:STUNSPORE],
			[16,:SLEEPPOWDER],
			[20,:BULLETSEED],
			[24,:LEECHSEED],
			[29,:MEGADRAIN],
			[34,:ACROBATICS],
			[39,:RAGEPOWDER],
			[44,:COTTONSPORE],
			[49,:UTURN],
			[54,:WORRYSEED],
			[59,:GIGADRAIN],
			[64,:BOUNCE],
			[69,:MEMENTO]],
		:compatiblemoves => [:ACROBATICS,:AGILITY,:AIRSLASH,:AMNESIA,:AERIALACE,:BOUNCE,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:INFESTATION,:LEAFBLADE,:LEAFSTORM,:MAGICALLEAF,:MIMIC,:POLLENPUFF,:PSYCHUP,:REFLECT,:SEEDBOMB,:SILVERWIND,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:UTURN,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy, :Grass],
		:Height => 8,
		:Weight => 30,
		:kind => "Cottonweed",
		:dexentry => "Jumpluff ride warm southern winds to cross the sea and fly to foreign lands. This Pokémon lands when it encounters cold air while it is floating.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 15,
	},

	:OnCreation => {},
},

:AIPOM => {
	"Normal Form" => {
		:name => "Aipom",
		:dexnum => 190,
		:Type1 => :NORMAL,
		:BaseStats => [55, 70, 55, 40, 55, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:RUNAWAY, :PICKUP],
		:HiddenAbilities => :SKILLLINK,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 72,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:BEATUP,:BOUNCE,:COUNTER,:COVET,:DOUBLESLAP,:FAKEOUT,:PURSUIT,:QUICKGUARD,:REVENGE,:SCREECH,:SLAM,:SPITE,:SWITCHEROO,:TAILSLAP,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:TAILWHIP],
			[4,:SANDATTACK],
			[8,:ASTONISH],
			[11,:BATONPASS],
			[15,:TICKLE],
			[18,:FURYSWIPES],
			[22,:SWIFT],
			[25,:SCREECH],
			[29,:AGILITY],
			[32,:DOUBLEHIT],
			[36,:FLING],
			[39,:NASTYPLOT],
			[43,:LASTRESORT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:BODYSLAM,:BOUNCE,:BODYSLAM,:BRICKBREAK,:CURSE,:COVET,:CUT,:DEFENSECURL,:DIG,:DREAMEATER,:DOUBLEEDGE,:DYNAMICPUNCH,:FIREPUNCH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HONECLAWS,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MUDSLAP,:MIMIC,:NIGHTMARE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROLEPLAY,:SEEDBOMB,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNATCH,:SOLARBEAM,:SPITE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:UPROAR,:UTURN,:WATERPULSE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 115,
		:kind => "Long Tail",
		:dexentry => "Its tail ends with a dexterous, handlike appendage. However, because it uses the tail so much, Aipom's real hands have become rather clumsy.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
		:evolutions => [
			[:AMBIPOM,:HasMove,:DOUBLEHIT]
		]
	},

	:OnCreation => {},
},

:SUNKERN => {
	"Normal Form" => {
		:name => "Sunkern",
		:dexnum => 191,
		:Type1 => :GRASS,
		:BaseStats => [30, 30, 30, 30, 30, 30],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:CHLOROPHYLL, :SOLARPOWER],
		:HiddenAbilities => :EARLYBIRD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 36,
		:CatchRate => 235,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BIDE,:CURSE,:ENCORE,:ENDURE,:GRASSWHISTLE,:GRASSYTERRAIN,:HELPINGHAND,:INGRAIN,:LEECHSEED,:MORNINGSUN,:NATURALGIFT,:SWEETSCENT,],
		:Moveset => [
			[1,:ABSORB],
			[1,:GROWTH],
			[4,:INGRAIN],
			[7,:GRASSWHISTLE],
			[10,:MEGADRAIN],
			[13,:LEECHSEED],
			[16,:RAZORLEAF],
			[19,:WORRYSEED],
			[22,:GIGADRAIN],
			[25,:ENDEAVOR],
			[28,:SYNTHESIS],
			[31,:NATURALGIFT],
			[34,:SOLARBEAM],
			[37,:DOUBLEEDGE],
			[40,:SUNNYDAY],
			[43,:SEEDBOMB]],
		:compatiblemoves => [:AFTERYOU,:BIDE,:BULLETSEED,:CUT,:CURSE,:DOUBLEEDGE,:ENCORE,:ENDEAVOR,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYTERRAIN,:HELPINGHAND,:LIGHTSCREEN,:MIMIC,:NATUREPOWER,:SAFEGUARD,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:UPROAR,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 3,
		:Weight => 18,
		:kind => "Seed",
		:dexentry => "Sunkern try to conserve the nutrients they have stored in their bodies for evolution. They will not eat, subsisting only on morning dew.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 8,
		:evolutions => [
			[:SUNFLORA,:Item,:SUNSTONE]
		]
	},

	:OnCreation => {},
},

:SUNFLORA => {
	"Normal Form" => {
		:name => "Sunflora",
		:dexnum => 192,
		:Type1 => :GRASS,
		:BaseStats => [75, 75, 55, 105, 85, 30],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:CHLOROPHYLL, :SOLARPOWER],
		:HiddenAbilities => :EARLYBIRD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 149,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SUNKERN,
			:form => 0
		},
		:Moveset => [
			[1,:FLOWERSHIELD],
			[1,:ABSORB],
			[1,:POUND],
			[1,:GROWTH],
			[4,:INGRAIN],
			[7,:GRASSWHISTLE],
			[10,:MEGADRAIN],
			[13,:LEECHSEED],
			[16,:RAZORLEAF],
			[19,:WORRYSEED],
			[22,:GIGADRAIN],
			[25,:BULLETSEED],
			[28,:PETALDANCE],
			[31,:NATURALGIFT],
			[34,:SOLARBEAM],
			[37,:DOUBLEEDGE],
			[40,:SUNNYDAY],
			[43,:LEAFSTORM],
			[50,:PETALBLIZZARD]],
		:compatiblemoves => [:AFTERYOU,:BIDE,:CHARM,:CUT,:CURSE,:DOUBLEEDGE,:ENCORE,:EARTHPOWER,:ENDEAVOR,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HELPINGHAND,:HYPERBEAM,:LEAFBLADE,:LIGHTSCREEN,:MAGICALLEAF,:MIMIC,:NATUREPOWER,:POLLENPUFF,:SAFEGUARD,:SEEDBOMB,:SLUDGEBOMB,:SOLARBEAM,:SOLARBLADE,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:UPROAR,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Grass],
		:Height => 8,
		:Weight => 85,
		:kind => "Sun",
		:dexentry => "Sunflora convert solar energy into nutrition. They are highly active in the warm daytime but suddenly stop moving as soon as the sun sets.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:YANMA => {
	"Normal Form" => {
		:name => "Yanma",
		:dexnum => 193,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [65, 65, 45, 75, 45, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SPEEDBOOST, :COMPOUNDEYES],
		:HiddenAbilities => :FRISK,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 78,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:DOUBLEEDGE,:FEINT,:FEINTATTACK,:LEECHLIFE,:PURSUIT,:REVERSAL,:SECRETPOWER,:SIGNALBEAM,:SILVERWIND,:WHIRLWIND,],
		:Moveset => [
			[1,:TACKLE],
			[1,:FORESIGHT],
			[6,:QUICKATTACK],
			[11,:DOUBLETEAM],
			[14,:SONICBOOM],
			[17,:DETECT],
			[22,:SUPERSONIC],
			[27,:UPROAR],
			[30,:PURSUIT],
			[33,:ANCIENTPOWER],
			[38,:HYPNOSIS],
			[43,:WINGATTACK],
			[46,:SCREECH],
			[49,:UTURN],
			[54,:AIRSLASH],
			[57,:BUGBUZZ]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:BUGBITE,:BUGBUZZ,:CURSE,:DETECT,:DEFOG,:DOUBLEEDGE,:DREAMEATER,:FLASH,:GIGADRAIN,:HEADBUTT,:LEECHLIFE,:MIMIC,:OMINOUSWIND,:PSYCHIC,:ROOST,:SCREECH,:SHADOWBALL,:SIGNALBEAM,:SOLARBEAM,:STEELWING,:STRINGSHOT,:SILVERWIND,:STRINGSHOT,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:UTURN,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 12,
		:Weight => 380,
		:WildItemUncommon => :WIDELENS,
		:kind => "Clear Wing",
		:dexentry => "It can see 360 degrees without moving its eyes. It is a great flier capable of making sudden stops and turning midair to quickly chase down targeted prey.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 15,
		:evolutions => [
			[:YANMEGA,:HasMove,:ANCIENTPOWER]
		]
	},

	:OnCreation => {},
},

:WOOPER => {
	"Normal Form" => {
		:name => "Wooper",
		:dexnum => 194,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [55, 45, 45, 25, 25, 15],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:DAMP, :WATERABSORB],
		:HiddenAbilities => :UNAWARE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 42,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDSPRAY,:AFTERYOU,:ANCIENTPOWER,:BODYSLAM,:COUNTER,:CURSE,:DOUBLEKICK,:EERIEIMPULSE,:ENCORE,:GUARDSWAP,:MUDSPORT,:POWERUPPUNCH,:RECOVER,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,],
		:Moveset => [
			[1,:WATERGUN],
			[1,:TAILWHIP],
			[5,:MUDSPORT],
			[9,:MUDSHOT],
			[15,:SLAM],
			[19,:MUDBOMB],
			[23,:AMNESIA],
			[29,:YAWN],
			[33,:EARTHQUAKE],
			[37,:RAINDANCE],
			[43,:MIST],
			[43,:HAZE],
			[47,:MUDDYWATER]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:BLIZZARD,:BULLDOZE,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:EERIEIMPULSE,:ENCORE,:EARTHPOWER,:EARTHQUAKE,:FLASH,:GUARDSWAP,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INFESTATION,:IRONTAIL,:MIMIC,:MUDSLAP,:MUDDYWATER,:RAINDANCE,:ROCKSMASH,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SCALD,:SLUDGEBOMB,:SLUDGEWAVE,:STOMPINGTANTRUM,:SURF,:WATERFALL,:WHIRLPOOL,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Field],
		:Height => 4,
		:Weight => 85,
		:kind => "Water Fish",
		:dexentry => "Wooper usually live in water but come out onto land seeking food occasionally. On land, they coat their bodies with a gooey, toxic film.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:QUAGSIRE,:Level,20]
		]
	},

	:OnCreation => {},
},

:QUAGSIRE => {
	"Normal Form" => {
		:name => "Quagsire",
		:dexnum => 195,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [95, 85, 85, 65, 65, 35],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:DAMP, :WATERABSORB],
		:HiddenAbilities => :UNAWARE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 151,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WOOPER,
			:form => 0
		},
		:Moveset => [
			[1,:WATERGUN],
			[1,:TAILWHIP],
			[1,:MUDSPORT],
			[5,:MUDSPORT],
			[9,:MUDSHOT],
			[15,:SLAM],
			[19,:MUDBOMB],
			[24,:AMNESIA],
			[31,:YAWN],
			[36,:EARTHQUAKE],
			[41,:RAINDANCE],
			[48,:MIST],
			[48,:HAZE],
			[53,:MUDDYWATER]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:BODYSLAM,:BLIZZARD,:BRICKBREAK,:BULLDOZE,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:EERIEIMPULSE,:EARTHPOWER,:EARTHQUAKE,:ENCORE,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GUARDSWAP,:HAIL,:HEADBUTT,:HIGHHORSEPOWER,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INFESTATION,:IRONTAIL,:LIQUIDATION,:MIMIC,:MUDDYWATER,:MUDSLAP,:MEGAKICK,:MEGAPUNCH,:MUDSHOT,:POWERUPPUNCH,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SCALD,:SEISMICTOSS,:SLUDGEBOMB,:SLUDGEWAVE,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SURF,:THIEF,:WHIRLPOOL,:WATERFALL,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Field],
		:Height => 14,
		:Weight => 750,
		:kind => "Water Fish",
		:dexentry => "A Quagsire hunts by leaving its mouth wide open in water and waiting for its prey to blunder in. Because it doesn't move, it does not get very hungry.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ESPEON => {
	"Normal Form" => {
		:name => "Espeon",
		:dexnum => 196,
		:Type1 => :PSYCHIC,
		:BaseStats => [65, 65, 60, 130, 95, 110],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SYNCHRONIZE, :SYNCHRONIZE],
		:HiddenAbilities => :MAGICBOUNCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:CONFUSION],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:SWIFT],
			[20,:PSYBEAM],
			[25,:FUTURESIGHT],
			[29,:PSYCHUP],
			[33,:MORNINGSUN],
			[37,:PSYCHIC],
			[41,:LASTRESORT],
			[45,:POWERSWAP]],
		:compatiblemoves => [:ALLYSWITCH,:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:CALMMIND,:CELEBRATE,:CHARM,:COVET,:CURSE,:CUT,:DAZZLINGGLEAM,:DETECT,:DIG,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:EXPANDINGFORCE,:FAKETEARS,:FLASH,:FOCUSENERGY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICROOM,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAYDAY,:PSYCHIC,:PSYCHICFANGS,:PSYCHUP,:PSYSHOCK,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TRICK,:TRICKROOM,:WEATHERBALL,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 265,
		:kind => "Sun",
		:dexentry => "An Espeon is loyal to any Trainer it considers to be worthy. It is said to have developed precognitive powers to protect its Trainer from harm.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:UMBREON => {
	"Normal Form" => {
		:name => "Umbreon",
		:dexnum => 197,
		:Type1 => :DARK,
		:BaseStats => [95, 65, 110, 60, 130, 65],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SYNCHRONIZE, :SYNCHRONIZE],
		:HiddenAbilities => :INNERFOCUS,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:PURSUIT],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:CONFUSERAY],
			[20,:FEINTATTACK],
			[25,:ASSURANCE],
			[29,:SCREECH],
			[33,:MOONLIGHT],
			[37,:MEANLOOK],
			[41,:LASTRESORT],
			[45,:GUARDSWAP]],
		:compatiblemoves => [:ASSURANCE,:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:CALMMIND,:CELEBRATE,:CHARM,:COVET,:CRUNCH,:CURSE,:CUT,:DARKPULSE,:DETECT,:DIG,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:FAKETEARS,:FLASH,:FOCUSENERGY,:FOULPLAY,:GIGAIMPACT,:GUARDSWAP,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:LASERFOCUS,:LASHOUT,:LASTRESORT,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAYBACK,:PAYDAY,:PSYCHIC,:PSYCHUP,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:SCREECH,:SHADOWBALL,:SKULLBASH,:SNARL,:SNATCH,:SPITE,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TAUNT,:THROATCHOP,:TORMENT,:WEATHERBALL,:WONDERROOM,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 270,
		:kind => "Moonlight",
		:dexentry => "Umbreon evolved from exposure to the moon's energy. It lurks in darkness and waits for its foes to move. The rings on its body glow when it attacks.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	"Perfection" => {
		:Type2 => :PSYCHIC,
		:BaseStats => [95, 65, 150, 130, 160, 75],
		:Abilities => [:MAGICBOUNCE],
	},

	:PerfectionForm => 1,
	:OnCreation => {},
},

:MURKROW => {
	"Normal Form" => {
		:name => "Murkrow",
		:dexnum => 198,
		:Type1 => :DARK,
		:Type2 => :FLYING,
		:BaseStats => [60, 85, 42, 85, 42, 91],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:INSOMNIA, :SUPERLUCK],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 81,
		:CatchRate => 30,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:ASSURANCE,:BRAVEBIRD,:CONFUSERAY,:DRILLPECK,:FEATHERDANCE,:FEINTATTACK,:FLATTER,:MIRRORMOVE,:PERISHSONG,:PSYCHOSHIFT,:PUNISHMENT,:ROOST,:SCREECH,:SKYATTACK,:WHIRLWIND,:WINGATTACK,],
		:Moveset => [
			[1,:PECK],
			[1,:ASTONISH],
			[5,:PURSUIT],
			[11,:HAZE],
			[15,:WINGATTACK],
			[21,:NIGHTSHADE],
			[25,:ASSURANCE],
			[31,:TAUNT],
			[35,:FEINTATTACK],
			[41,:MEANLOOK],
			[45,:FOULPLAY],
			[50,:TAILWIND],
			[55,:SUCKERPUNCH],
			[61,:TORMENT],
			[65,:QUASH]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:BRAVEBIRD,:CALMMIND,:CURSE,:DARKPULSE,:DETECT,:DEFOG,:DOUBLEEDGE,:DREAMEATER,:DUALWINGBEAT,:EMBARGO,:FLY,:FOULPLAY,:HEATWAVE,:ICYWIND,:LASHOUT,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PLUCK,:PAYBACK,:PSYCHIC,:PSYCHUP,:QUASH,:RAINDANCE,:ROOST,:SHADOWBALL,:SKYATTACK,:SNARL,:SNATCH,:SPITE,:STEELWING,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILWIND,:TAUNT,:THIEF,:THUNDERWAVE,:TORMENT,:TWISTER,:UPROAR,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Forest",
		:EggGroups => [:Flying],
		:Height => 5,
		:Weight => 21,
		:kind => "Darkness",
		:dexentry => "Murkrow were feared as the bearers of ill fortune. It shows strong interest in anything that sparkles. It will even try to steal rings from women.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 21,
		:evolutions => [
			[:HONCHKROW,:Item,:DUSKSTONE]
		]
	},

	:OnCreation => {},
},

:SLOWKING => {
	"Normal Form" => {
		:name => "Slowking",
		:dexnum => 199,
		:Type1 => :WATER,
		:Type2 => :PSYCHIC,
		:BaseStats => [95, 75, 80, 100, 110, 30],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:OBLIVIOUS, :OWNTEMPO],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 172,
		:CatchRate => 70,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SLOWPOKE,
			:form => 0
		},
		:Moveset => [
			[1,:HEALPULSE],
			[1,:POWERGEM],
			[1,:HIDDENPOWER],
			[1,:CURSE],
			[1,:YAWN],
			[1,:TACKLE],
			[5,:GROWL],
			[9,:WATERGUN],
			[14,:CONFUSION],
			[19,:DISABLE],
			[23,:HEADBUTT],
			[28,:WATERPULSE],
			[32,:ZENHEADBUTT],
			[36,:NASTYPLOT],
			[41,:SWAGGER],
			[45,:PSYCHIC],
			[49,:TRUMPCARD],
			[54,:PSYCHUP],
			[58,:HEALPULSE]],
		:compatiblemoves => [:AFTERYOU,:ALLYSWITCH,:AMNESIA,:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRINE,:BUBBLEBEAM,:BULLDOZE,:CALMMIND,:COUNTER,:CURSE,:DIG,:DIVE,:DOUBLEEDGE,:DRAGONTAIL,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:EXPANDINGFORCE,:FIREBLAST,:FISSURE,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:INCINERATE,:IRONDEFENSE,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:LIQUIDATION,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYDAY,:POWERGEM,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:QUASH,:RAGE,:RAINDANCE,:RAZORSHELL,:RECYCLE,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SCALD,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEKINESIS,:TELEPORT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:WATERGUN,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 20,
		:Weight => 795,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Royal",
		:dexentry => "It undertakes research every day to solve the mysteries of the world. Apparently it forgets everything if the Shellder on its head comes off.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:dexentry => "A combination of toxins and the shock of evolving has increased Shellder’s intelligence to the point that Shellder now controls Slowking.",
		:Type1 => :POISON, 
        :Type2 => :PSYCHIC,
		:BaseStats => [95,65,80,110,110,30],
		:Abilities => [:CURIOUSMEDICINE, :OWNTEMPO, :REGENERATOR], 
		:Moveset => [[0,:EERIESPELL],[1,:EERIESPELL],[1,:POWERGEM],[1,:SWAGGER],[1,:TACKLE],[1,:CURSE],[1,:GROWL],
		    [1,:NASTYPLOT],[1,:ACID],[9,:YAWN],[12,:CONFUSION],[15,:DISABLE],[18,:WATERPULSE],[21,:HEADBUTT],
			[24,:ZENHEADBUTT],[27,:AMNESIA],[30,:SURF],[33,:SLACKOFF],[36,:PSYCHIC],
			[39,:PSYCHUP],[42,:RAINDANCE],[45,:HEALPULSE]],
		:compatiblemoves => [:AMNESIA,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,
			:BULLDOZE,:CALMMIND,:DIG,:DIVE,:DRAINPUNCH,:EARTHQUAKE,:EXPANDINGFORCE,
			:FIREBLAST,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOULPLAY,:FUTURESIGHT,:GIGAIMPACT,
			:GRASSKNOT,:HAIL,:HEX,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,
			:IRONDEFENSE,:IRONTAIL,:LIGHTSCREEN,:LIQUIDATION,:MEGAKICK,:MEGAPUNCH,:MIMIC,
			:MUDDYWATER,:MUDSHOT,:NASTYPLOT,:PAYDAY,:POWERGEM,:PSYCHIC,:PSYCHICTERRAIN,:PSYSHOCK,
			:RAINDANCE,:RAZORSHELL,:SAFEGUARD,:SCALD,:SHADOWBALL,:SKILLSWAP,:SLUDGEBOMB,:SLUDGEWAVE,
			:STOREDPOWER,:SUNNYDAY,:SURF,:SWIFT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:VENOMDRENCH,
			:VENOSHOCK,:WEATHERBALL,:WHIRLPOOL,:WONDERROOM,:ZENHEADBUTT],
		:moveexceptions => [],
		:preevo => {
			:species => :SLOWPOKE,
			:form => 1, 
		  },
	},

	:OnCreation => {},
},

:MISDREAVUS => {
	"Normal Form" => {
		:name => "Misdreavus",
		:dexnum => 200,
		:Type1 => :GHOST,
		:BaseStats => [60, 60, 60, 85, 85, 85],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 87,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 6630,
		:EggMoves => [:CURSE,:DESTINYBOND,:IMPRISON,:MEFIRST,:MEMENTO,:NASTYPLOT,:OMINOUSWIND,:SCREECH,:SHADOWSNEAK,:SKILLSWAP,:SPITE,:SUCKERPUNCH,:WONDERROOM,],
		:Moveset => [
			[1,:GROWL],
			[1,:PSYWAVE],
			[5,:SPITE],
			[10,:ASTONISH],
			[14,:CONFUSERAY],
			[19,:MEANLOOK],
			[23,:HEX],
			[28,:PSYBEAM],
			[32,:PAINSPLIT],
			[37,:PAYBACK],
			[41,:SHADOWBALL],
			[46,:PERISHSONG],
			[50,:GRUDGE],
			[55,:POWERGEM]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:CALMMIND,:CHARGEBEAM,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:FLASH,:FOULPLAY,:HEADBUTT,:HEALBELL,:HEX,:HYPERVOICE,:ICYWIND,:MAGICROOM,:MIMIC,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PSYCHIC,:PSYCHUP,:RAINDANCE,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:Amorphous],
		:Height => 7,
		:Weight => 10,
		:kind => "Screech",
		:dexentry => "A Misdreavus frightens people with a creepy, sobbing cry. It apparently uses its red spheres to absorb the fear of foes as its nutrition.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 17,
		:evolutions => [
			[:MISMAGIUS,:Item,:DUSKSTONE]
		]
	},

	:OnCreation => {},
},

:UNOWN => {
	"A" => {
		:name => "Unown",
		:dexnum => 201,
		:Type1 => :PSYCHIC,
		:BaseStats => [48, 72, 48, 72, 48, 48],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 118,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 10455,
		:Moveset => [
			[1,:HIDDENPOWER]],
		:compatiblemoves => [],
		:moveexceptions => [:ATTRACT,:BIDE,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Black",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 5,
		:Weight => 50,
		:kind => "Symbol",
		:dexentry => "This Pokémon is shaped like ancient text characters. Although research is ongoing, it is a mystery as to which came first, the writings or the Unown.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 19,
	},

	"B" => {
	},

	"C" => {
	},

	"D" => {
	},

	"E" => {
	},

	"F" => {
	},

	"G" => {
	},

	"H" => {
	},

	"I" => {
	},

	"J" => {
	},

	"K" => {
	},

	"L" => {
	},

	"M" => {
	},

	"N" => {
	},

	"O" => {
	},

	"P" => {
	},

	"Q" => {
	},

	"R" => {
	},

	"S" => {
	},

	"T" => {
	},

	"U" => {
	},

	"V" => {
	},

	"W" => {
	},

	"X" => {
	},

	"Y" => {
	},

	"Z" => {
	},

	"?" => {
	},

	"!" => {
	},

	:OnCreation => proc{rand(28)},
},

:WOBBUFFET => {
	"Normal Form" => {
		:name => "Wobbuffet",
		:dexnum => 202,
		:Type1 => :PSYCHIC,
		:BaseStats => [190, 33, 58, 33, 58, 33],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:SHADOWTAG, :TELEPATHY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WYNAUT,
			:form => 0
		},
		:Moveset => [
			[1,:COUNTER],
			[1,:MIRRORCOAT],
			[1,:SAFEGUARD],
			[1,:DESTINYBOND]],
		:compatiblemoves => [:AMNESIA,:CHARM,:ENCORE,:SAFEGUARD,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Blue",
		:Habitat => "Cave",
		:EggGroups => [:Amorphous],
		:Height => 13,
		:Weight => 285,
		:kind => "Patient",
		:dexentry => "Usually docile, a Wobbuffet strikes back ferociously if its black tail is attacked. It makes its lair in caves where it waits for nightfall.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GIRAFARIG => {
	"Normal Form" => {
		:name => "Girafarig",
		:dexnum => 203,
		:Type1 => :NORMAL,
		:Type2 => :PSYCHIC,
		:BaseStats => [70, 80, 65, 90, 65, 85],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:INNERFOCUS, :EARLYBIRD],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:BEATUP,:DOUBLEKICK,:FORESIGHT,:FUTURESIGHT,:MAGICCOAT,:MEANLOOK,:MIRRORCOAT,:RAZORWIND,:PSYCHICFANGS,:PSYCHICTERRAIN,:SECRETPOWER,:SKILLSWAP,:TAKEDOWN,:WISH,],
		:Moveset => [
			[1,:POWERSWAP],
			[1,:GUARDSWAP],
			[1,:ASTONISH],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:CONFUSION],
			[5,:ODORSLEUTH],
			[10,:ASSURANCE],
			[14,:STOMP],
			[19,:PSYBEAM],
			[23,:AGILITY],
			[28,:DOUBLEHIT],
			[32,:ZENHEADBUTT],
			[37,:CRUNCH],
			[41,:BATONPASS],
			[46,:NASTYPLOT],
			[50,:PSYCHIC]],
		:compatiblemoves => [:AGILITY,:ALLYSWITCH,:AMNESIA,:BATONPASS,:BODYSLAM,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CRUNCH,:CURSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DREAMEATER,:EARTHQUAKE,:ECHOEDVOICE,:ENERGYBALL,:FLASH,:FOULPLAY,:FUTURESIGHT,:FLASH,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPERVOICE,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYCHICFANGS,:POWERSWAP,:PSYCHICTERRAIN,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKSMASH,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STOMPINGTANTRUM,:STOREDPOWER,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:TRICKROOM,:UPROAR,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 15,
		:Weight => 415,
		:kind => "Long Neck",
		:dexentry => "A Girafarig is a herbivore-- it eats grass and tree shoots. While it is eating, its tail makes chewing and swallowing motions as if it were also eating.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PINECO => {
	"Normal Form" => {
		:name => "Pineco",
		:dexnum => 204,
		:Type1 => :BUG,
		:BaseStats => [50, 65, 90, 35, 35, 15],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:STURDY, :OVERCOAT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:COUNTER,:DOUBLEEDGE,:ENDURE,:FLAIL,:PINMISSILE,:POWERTRICK,:REVENGE,:SANDTOMB,:STEALTHROCK,:SWIFT,:TOXICSPIKES,],
		:Moveset => [
			[1,:TACKLE],
			[1,:PROTECT],
			[6,:SELFDESTRUCT],
			[9,:BUGBITE],
			[12,:TAKEDOWN],
			[17,:RAPIDSPIN],
			[20,:BIDE],
			[23,:NATURALGIFT],
			[28,:SPIKES],
			[31,:PAYBACK],
			[34,:EXPLOSION],
			[39,:IRONDEFENSE],
			[42,:GYROBALL],
			[45,:DOUBLEEDGE]],
		:compatiblemoves => [:BODYSLAM,:BUGBITE,:BULLDOZE,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRILLRUN,:EARTHQUAKE,:EXPLOSION,:GIGADRAIN,:GRAVITY,:GYROBALL,:HEADBUTT,:IRONDEFENSE,:LIGHTSCREEN,:MIMIC,:PAINSPLIT,:PAYBACK,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SELFDESTRUCT,:SOLARBEAM,:SPIKES,:STEALTHROCK,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWEETSCENT,:TOXICSPIKES,:VENOSHOCK,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Gray",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 6,
		:Weight => 72,
		:kind => "Bagworm",
		:dexentry => "A Pineco hangs from a branch and waits for prey. While eating, if it is disturbed by someone shaking its tree, it falls on the ground and explodes.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 10,
		:evolutions => [
			[:FORRETRESS,:Level,31]
		]
	},

	:OnCreation => {},
},

:FORRETRESS => {
	"Normal Form" => {
		:name => "Forretress",
		:dexnum => 205,
		:Type1 => :BUG,
		:Type2 => :STEEL,
		:BaseStats => [75, 90, 140, 60, 60, 40],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:STURDY, :OVERCOAT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 163,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PINECO,
			:form => 0
		},
		:Moveset => [
			[0,:MIRRORSHOT],
			[0,:AUTOTOMIZE],
			[1,:HEAVYSLAM],
			[1,:ZAPCANNON],
			[1,:MAGNETRISE],
			[1,:TOXICSPIKES],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:SELFDESTRUCT],
			[1,:BUGBITE],
			[6,:SELFDESTRUCT],
			[9,:BUGBITE],
			[12,:TAKEDOWN],
			[17,:RAPIDSPIN],
			[20,:BIDE],
			[23,:NATURALGIFT],
			[28,:SPIKES],
			[32,:PAYBACK],
			[36,:EXPLOSION],
			[42,:IRONDEFENSE],
			[46,:GYROBALL],
			[50,:DOUBLEEDGE],
			[56,:MAGNETRISE],
			[60,:ZAPCANNON],
			[64,:HEAVYSLAM]],
		:compatiblemoves => [:ALLYSWITCH,:BLOCK,:BODYPRESS,:BODYSLAM,:BUGBITE,:BULLDOZE,:CURSE,:DARKESTLARIAT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRILLRUN,:EARTHQUAKE,:EXPLOSION,:FLASHCANNON,:GIGADRAIN,:GIGAIMPACT,:GRAVITY,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:IRONDEFENSE,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MIMIC,:PAINSPLIT,:PAYBACK,:PINMISSILE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SELFDESTRUCT,:SIGNALBEAM,:SOLARBEAM,:SPIKES,:STEALTHROCK,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:TELEKINESIS,:SPIKES,:VENOSHOCK,:VOLTSWITCH,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 12,
		:Weight => 1258,
		:kind => "Bagworm",
		:dexentry => "It keeps itself inside its steel shell. The shell is opened when it is catching prey, but it is so quick that the shell's inside cannot be seen.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:DUNSPARCE => {
	"Normal Form" => {
		:name => "Dunsparce",
		:dexnum => 206,
		:Type1 => :NORMAL,
		:BaseStats => [100, 70, 70, 65, 65, 45],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SERENEGRACE, :RUNAWAY],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 145,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:ANCIENTPOWER,:ASTONISH,:BIDE,:BITE,:CURSE,:HEADBUTT,:HEX,:MAGICCOAT,:SECRETPOWER,:SLEEPTALK,:SNORE,:TRUMPCARD,],
		:Moveset => [
			[1,:RAGE],
			[1,:DEFENSECURL],
			[3,:ROLLOUT],
			[6,:SPITE],
			[8,:PURSUIT],
			[11,:SCREECH],
			[13,:MUDSLAP],
			[16,:YAWN],
			[18,:ANCIENTPOWER],
			[21,:BODYSLAM],
			[23,:DRILLRUN],
			[26,:ROOST],
			[28,:TAKEDOWN],
			[31,:COIL],
			[33,:DIG],
			[36,:GLARE],
			[38,:DOUBLEEDGE],
			[41,:ENDEAVOR],
			[43,:AIRSLASH],
			[46,:DRAGONRUSH],
			[48,:ENDURE],
			[51,:FLAIL]],
		:compatiblemoves => [:AGILITY,:AMNESIA,:AIRSLASH,:ANCIENTPOWER,:AQUATAIL,:BATONPASS,:BIND,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COUNTER,:CURSE,:DIG,:DOUBLEEDGE,:DREAMEATER,:DRILLRUN,:DUALWINGBEAT,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FLAMETHROWER,:GYROBALL,:HEADBUTT,:HEX,:ICEBEAM,:INCINERATE,:IRONTAIL,:LASTRESORT,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:POISONJAB,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:ROOST,:SCALESHOT,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SKITTERSMACK,:SOLARBEAM,:SPITE,:STEALTHROCK,:STOREDPOWER,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:WATERPULSE,:WILDCHARGE,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Cave",
		:EggGroups => [:Field],
		:Height => 15,
		:Weight => 140,
		:kind => "Land Snake",
		:dexentry => "Its drill-tipped tail is used to burrow into the ground backwards. This Pokémon is known to make its nest in complex shapes deep under the ground.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 30,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GLIGAR => {
	"Normal Form" => {
		:name => "Gligar",
		:dexnum => 207,
		:Type1 => :GROUND,
		:Type2 => :FLYING,
		:BaseStats => [65, 75, 105, 35, 65, 85],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SANDVEIL],
		:HiddenAbilities => :IMMUNITY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 86,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:BATONPASS,:COUNTER,:CROSSPOISON,:DOUBLEEDGE,:FEINT,:METALCLAW,:NIGHTSLASH,:POISONTAIL,:POWERTRICK,:RAZORWIND,:ROCKCLIMB,:SANDTOMB,:WINGATTACK,],
		:Moveset => [
			[1,:POISONSTING],
			[4,:SANDATTACK],
			[7,:HARDEN],
			[10,:KNOCKOFF],
			[13,:QUICKATTACK],
			[16,:FURYCUTTER],
			[19,:FEINTATTACK],
			[22,:ACROBATICS],
			[27,:SLASH],
			[30,:UTURN],
			[35,:SCREECH],
			[40,:XSCISSOR],
			[45,:SKYUPPERCUT],
			[50,:SWORDSDANCE],
			[55,:GUILLOTINE]],
		:compatiblemoves => [:AGILITY,:AIRSLASH,:ACROBATICS,:AERIALACE,:AQUATAIL,:BRICKBREAK,:BUGBITE,:BULLDOZE,:CROSSPOISON,:CUT,:CURSE,:DARKPULSE,:DIG,:DEFOG,:DETECT,:DOUBLEEDGE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:FALSESWIPE,:FIREFANG,:FLING,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:ICEFANG,:IRONTAIL,:MIMIC,:MUDSHOT,:PAYBACK,:POISONJAB,:RAINDANCE,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SKITTERSMACK,:SLUDGEBOMB,:STEALTHROCK,:STEELWING,:STONEEDGE,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAUNT,:THIEF,:THROATCHOP,:THUNDERFANG,:TORMENT,:UTURN,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Mountain",
		:EggGroups => [:Bug],
		:Height => 11,
		:Weight => 648,
		:kind => "FlyScorpion",
		:dexentry => "It glides without making a single sound. It grasps the face of its foe using its hind and large front claws, then stabs with its poison barb.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 8,
		:evolutions => [
			[:GLISCOR,:NightHoldItem,:RAZORFANG]
		]
	},

	:OnCreation => {},
},

:STEELIX => {
	"Normal Form" => {
		:name => "Steelix",
		:dexnum => 208,
		:Type1 => :STEEL,
		:Type2 => :GROUND,
		:BaseStats => [75, 85, 200, 55, 65, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :STURDY],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 179,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :ONIX,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERFANG],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:MUDSPORT],
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:BIND],
			[4,:CURSE],
			[7,:ROCKTHROW],
			[10,:ROCKTOMB],
			[13,:RAGE],
			[16,:STEALTHROCK],
			[19,:AUTOTOMIZE],
			[20,:GYROBALL],
			[22,:SMACKDOWN],
			[25,:DRAGONBREATH],
			[28,:SLAM],
			[31,:SCREECH],
			[34,:ROCKSLIDE],
			[37,:CRUNCH],
			[40,:IRONTAIL],
			[43,:DIG],
			[46,:STONEEDGE],
			[49,:DOUBLEEDGE],
			[52,:SANDSTORM]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:BIDE,:BIND,:BLOCK,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BULLDOZE,:CURSE,:CUT,:DARKPULSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREFANG,:FISSURE,:FLASHCANNON,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:ICEFANG,:IRONHEAD,:IRONTAIL,:MAGNETRISE,:METEORBEAM,:MIMIC,:MUDSLAP,:NATUREPOWER,:PAYBACK,:PSYCHICFANGS,:ROAR,:PSYCHUP,:RAGE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SCORCHINGSANDS,:SCREECH,:SELFDESTRUCT,:SKULLBASH,:SMACKDOWN,:STEALTHROCK,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TAKEDOWN,:TAUNT,:THUNDERFANG,:TORMENT,:TWISTER,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Mineral],
		:Height => 92,
		:Weight => 4000,
		:WildItemUncommon => :METALCOAT,
		:kind => "Iron Snake",
		:dexentry => "Steelix live even further underground than Onix. This Pokémon digs toward the earth's core, reaching a depth of over six-tenths of a mile underground.",
		:BattlerPlayerY => 8,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [75, 125, 230, 55, 95, 30],
		:Abilities => [:SANDFORCE],
		:Height => 105,
		:Weight => 7400,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:STEELIXITE => 1,
	},
},

:SNUBBULL => {
	"Normal Form" => {
		:name => "Snubbull",
		:dexnum => 209,
		:Type1 => :FAIRY,
		:BaseStats => [60, 80, 50, 40, 40, 30],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :RUNAWAY],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 60,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CLOSECOMBAT,:CRUNCH,:DOUBLEEDGE,:FAKETEARS,:FEINTATTACK,:FIREFANG,:FOCUSPUNCH,:HEALBELL,:ICEFANG,:METRONOME,:MIMIC,:PRESENT,:SMELLINGSALTS,:SNORE,:THUNDERFANG,],
		:Moveset => [
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:TACKLE],
			[1,:SCARYFACE],
			[1,:TAILWHIP],
			[1,:CHARM],
			[7,:BITE],
			[13,:LICK],
			[19,:HEADBUTT],
			[25,:ROAR],
			[31,:RAGE],
			[37,:PLAYROUGH],
			[43,:PAYBACK],
			[49,:CRUNCH]],
		:compatiblemoves => [:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CHARM,:CLOSECOMBAT,:COVET,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:HEADBUTT,:HEALBELL,:HYPERVOICE,:ICEFANG,:ICEPUNCH,:INCINERATE,:LASTRESORT,:LEER,:LOWKICK,:MEGAPUNCH,:MEGAKICK,:MIMIC,:MUDSLAP,:OVERHEAT,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKSMASH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SNARL,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:TAKEDOWN,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:Field, :Fairy],
		:Height => 6,
		:Weight => 78,
		:kind => "Fairy",
		:dexentry => "By baring its fangs and making a scary face, it sends smaller Pokémon scurrying in terror. Snubbull does seem a little sad at making its foes flee.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GRANBULL,:Level,23]
		]
	},

	:OnCreation => {},
},

:GRANBULL => {
	"Normal Form" => {
		:name => "Granbull",
		:dexnum => 210,
		:Type1 => :FAIRY,
		:BaseStats => [90, 120, 75, 60, 60, 45],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :QUICKFEET],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 158,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SNUBBULL,
			:form => 0
		},
		:Moveset => [
			[1,:OUTRAGE],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:TACKLE],
			[1,:SCARYFACE],
			[1,:TAILWHIP],
			[1,:CHARM],
			[7,:BITE],
			[13,:LICK],
			[19,:HEADBUTT],
			[27,:ROAR],
			[35,:RAGE],
			[43,:PLAYROUGH],
			[51,:PAYBACK],
			[59,:CRUNCH],
			[67,:OUTRAGE]],
		:compatiblemoves => [:AGILITY,:ASSURANCE,:BEATUP,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CHARM,:CLOSECOMBAT,:COVET,:COUNTER,:CURSE,:DAZZLINGGLEAM,:DETECT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HYPERBEAM,:HYPERVOICE,:ICEFANG,:ICEPUNCH,:IRONTAIL,:INCINERATE,:LASHOUT,:LASTRESORT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:PSYCHICFANGS,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SNARL,:SOLARBEAM,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:TAUNT,:THIEF,:THUNDER,:THUNDERFANG,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Field, :Fairy],
		:Height => 14,
		:Weight => 487,
		:kind => "Fairy",
		:dexentry => "It has a particularly well-developed lower jaw. The huge fangs are heavy, causing it to tilt its head. Unless it is startled, it will not try to bite.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:QWILFISH => {
	"Normal Form" => {
		:name => "Qwilfish",
		:dexnum => 211,
		:Type1 => :WATER,
		:Type2 => :POISON,
		:BaseStats => [65, 95, 85, 55, 55, 85],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:POISONPOINT, :SWIFTSWIM],
		:HiddenAbilities => :INTIMIDATE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 86,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDSPRAY,:AQUAJET,:ASTONISH,:BRINE,:BUBBLEBEAM,:FLAIL,:HAZE,:SIGNALBEAM,:SUPERSONIC,:WATERPULSE,],
		:Moveset => [
			[1,:FELLSTINGER],
			[1,:HYDROPUMP],
			[1,:DESTINYBOND],
			[1,:WATERGUN],
			[1,:SPIKES],
			[1,:TACKLE],
			[1,:POISONSTING],
			[9,:HARDEN],
			[9,:MINIMIZE],
			[13,:BUBBLE],
			[17,:ROLLOUT],
			[21,:TOXICSPIKES],
			[25,:STOCKPILE],
			[25,:SPITUP],
			[29,:REVENGE],
			[33,:BRINE],
			[37,:PINMISSILE],
			[41,:TAKEDOWN],
			[45,:AQUATAIL],
			[49,:POISONJAB],
			[53,:DESTINYBOND],
			[57,:HYDROPUMP],
			[60,:FELLSTINGER]],
		:compatiblemoves => [:AQUATAIL,:ASSURANCE,:BLIZZARD,:BOUNCE,:BRINE,:CURSE,:DIVE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EXPLOSION,:GYROBALL,:HAIL,:HEADBUTT,:HEX,:ICEBEAM,:ICYWIND,:LIQUIDATION,:MIMIC,:MUDSLAP,:PAINSPLIT,:PAYBACK,:POISONJAB,:PINMISSILE,:RAINDANCE,:REVENGE,:REVERSAL,:SCALD,:SCARYFACE,:SCALESHOT,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SLUDGEBOMB,:SLUDGEWAVE,:SPIKES,:STEELROLLER,:SURF,:SWORDSDANCE,:SWIFT,:TAUNT,:THROATCHOP,:THUNDERWAVE,:VENOSHOCK,:VENOMDRENCH,:WHIRLPOOL,:WATERFALL,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 5,
		:Weight => 39,
		:WildItemUncommon => :POISONBARB,
		:kind => "Balloon",
		:dexentry => "A Qwilfish uses the pressure of water it swallows to shoot toxic quills out from all over its body. It finds swimming to be somewhat challenging.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 12,
	},

	:OnCreation => {},
},

:SCIZOR => {
	"Normal Form" => {
		:name => "Scizor",
		:dexnum => 212,
		:Type1 => :BUG,
		:Type2 => :STEEL,
		:BaseStats => [70, 130, 100, 55, 80, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWARM, :TECHNICIAN],
		:HiddenAbilities => :LIGHTMETAL,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :SCYTHER,
			:form => 0
		},
		:Moveset => [
			[1,:FEINT],
			[1,:BULLETPUNCH],
			[1,:QUICKATTACK],
			[1,:LEER],
			[5,:FOCUSENERGY],
			[9,:PURSUIT],
			[13,:FALSESWIPE],
			[17,:AGILITY],
			[21,:METALCLAW],
			[25,:FURYCUTTER],
			[29,:SLASH],
			[33,:RAZORWIND],
			[37,:IRONDEFENSE],
			[41,:XSCISSOR],
			[45,:NIGHTSLASH],
			[49,:DOUBLEHIT],
			[50,:IRONHEAD],
			[57,:SWORDSDANCE],
			[61,:FEINT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRSLASH,:ASSURANCE,:BATONPASS,:BIDE,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BUGBUZZ,:CALMMIND,:CLOSECOMBAT,:COUNTER,:CROSSPOISON,:CURSE,:CUT,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FALSESWIPE,:FLASHCANNON,:FLING,:FOCUSENERGY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:OMINOUSWIND,:PSYCHOCUT,:RAGE,:RAINDANCE,:RAZORWIND,:REVERSAL,:ROCKSMASH,:ROOST,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SILVERWIND,:SKULLBASH,:STEELWING,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAKEDOWN,:THIEF,:UTURN,:VACUUMWAVE,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Grassland",
		:EggGroups => [:Bug],
		:Height => 18,
		:Weight => 1180,
		:kind => "Pincer",
		:dexentry => "A Scizor has a body as hard as steel. It is not easily fazed by ordinary sorts of attacks. It flaps its wings to regulate its body temperature.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [70, 150, 140, 65, 100, 75],
		:Abilities => [:TECHNICIAN],
		:Weight => 1250,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SCIZORITE => 1,
	},
},

:SHUCKLE => {
	"Normal Form" => {
		:name => "Shuckle",
		:dexnum => 213,
		:Type1 => :BUG,
		:Type2 => :ROCK,
		:BaseStats => [20, 10, 230, 10, 230, 5],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:STURDY, :GLUTTONY],
		:HiddenAbilities => :CONTRARY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 177,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACID,:ACUPRESSURE,:FINALGAMBIT,:HELPINGHAND,:KNOCKOFF,:MUDSLAP,:ROCKBLAST,:SANDTOMB,:SWEETSCENT,],
		:Moveset => [
			[1,:STICKYWEB],
			[1,:WITHDRAW],
			[1,:CONSTRICT],
			[1,:BIDE],
			[1,:ROLLOUT],
			[5,:ENCORE],
			[9,:WRAP],
			[12,:STRUGGLEBUG],
			[16,:SAFEGUARD],
			[20,:REST],
			[23,:ROCKTHROW],
			[27,:GASTROACID],
			[31,:POWERTRICK],
			[34,:SHELLSMASH],
			[38,:ROCKSLIDE],
			[42,:BUGBITE],
			[45,:POWERSPLIT],
			[45,:GUARDSPLIT],
			[49,:STONEEDGE],
			[53,:STICKYWEB]],
		:compatiblemoves => [:AFTERYOU,:ANCIENTPOWER,:BIND,:BODYSLAM,:BUGBITE,:BULLDOZE,:COVET,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENCORE,:FLASH,:GASTROACID,:GYROBALL,:HELPINGHAND,:INFESTATION,:IRONDEFENSE,:KNOCKOFF,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:REVERSAL,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SKITTERSMACK,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:STEALTHROCK,:STEELROLLER,:STONEEDGE,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Mountain",
		:EggGroups => [:Bug],
		:Height => 6,
		:Weight => 205,
		:WildItemCommon => :BERRYJUICE,
		:WildItemUncommon => :BERRYJUICE,
		:WildItemRare => :BERRYJUICE,
		:kind => "Mold",
		:dexentry => "A Shuckle hides under rocks, keeping its body inside its shell while eating stored berries. The berries mix with its body fluids to become a juice.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:HERACROSS => {
	"Normal Form" => {
		:name => "Heracross",
		:dexnum => 214,
		:Type1 => :BUG,
		:Type2 => :FIGHTING,
		:BaseStats => [80, 125, 75, 40, 95, 85],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWARM, :GUTS],
		:HiddenAbilities => :MOXIE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BIDE,:DOUBLEEDGE,:FLAIL,:FOCUSPUNCH,:HARDEN,:MEGAHORN,:PURSUIT,:REVENGE,:ROCKBLAST,:SEISMICTOSS,],
		:Moveset => [
			[1,:ARMTHRUST],
			[1,:BULLETSEED],
			[1,:NIGHTSLASH],
			[1,:TACKLE],
			[1,:LEER],
			[1,:HORNATTACK],
			[1,:ENDURE],
			[7,:FEINT],
			[10,:AERIALACE],
			[16,:CHIPAWAY],
			[19,:COUNTER],
			[25,:FURYATTACK],
			[28,:BRICKBREAK],
			[31,:PINMISSILE],
			[34,:TAKEDOWN],
			[37,:MEGAHORN],
			[43,:CLOSECOMBAT],
			[46,:REVERSAL]],
		:compatiblemoves => [:AFTERYOU,:ANCIENTPOWER,:ASSURANCE,:BODYSLAM,:BIND,:BUGBITE,:BULLDOZE,:BRUTALSWING,:BULLETSEED,:CLOSECOMBAT,:COACHING,:CURSE,:CUT,:COUNTER,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENCORE,:FLASH,:FURYCUTTER,:GASTROACID,:GYROBALL,:HEADBUTT,:HELPINGHAND,:HIGHHORSEPOWER,:INFESTATION,:IRONDEFENSE,:KNOCKOFF,:LOWKICK,:MEGAHORN,:MUDSHOT,:MIMIC,:PINMISSILE,:REVENGE,:RETALIATE,:REVERSAL,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SPIKES,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:SMARTSTRIKE,:STEALTHROCK,:STONEEDGE,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:VACUUMWAVE,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 15,
		:Weight => 540,
		:kind => "Single Horn",
		:dexentry => "They gather in forests seeking the sap of trees. It is completely clad in a steel-hard shell. It is proud of its horn, which it uses to fling foes.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [80, 185, 115, 40, 105, 75],
		:Abilities => [:SKILLLINK],
		:Weight => 625,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:HERACRONITE => 1,
	},
},

:SNEASEL => {
	"Normal Form" => {
		:name => "Sneasel",
		:dexnum => 215,
		:Type1 => :DARK,
		:Type2 => :ICE,
		:BaseStats => [55, 95, 55, 35, 75, 115],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:INNERFOCUS, :KEENEYE],
		:HiddenAbilities => :PICKPOCKET,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 86,
		:CatchRate => 60,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:ASSIST,:AVALANCHE,:BITE,:COUNTER,:CRUSHCLAW,:DOUBLEHIT,:FAKEOUT,:FEINT,:FORESIGHT,:ICEPUNCH,:ICESHARD,:ICICLECRASH,:PUNISHMENT,:PURSUIT,:SPITE,:THROATCHOP,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:LEER],
			[1,:TAUNT],
			[8,:QUICKATTACK],
			[10,:FEINTATTACK],
			[14,:ICYWIND],
			[16,:FURYSWIPES],
			[20,:AGILITY],
			[22,:METALCLAW],
			[25,:HONECLAWS],
			[28,:BEATUP],
			[32,:SCREECH],
			[35,:SLASH],
			[40,:SNATCH],
			[44,:PUNISHMENT],
			[47,:ICESHARD]],
		:compatiblemoves => [:AGILITY,:AERIALACE,:AVALANCHE,:BEATUP,:BLIZZARD,:BRICKBREAK,:CALMMIND,:COUNTER,:CUT,:CURSE,:DARKPULSE,:DIG,:DOUBLEEDGE,:DEFENSECURL,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:FALSESWIPE,:FURYCUTTER,:FLING,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:HAIL,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:PSYCHUP,:PSYCHOCUT,:RAINDANCE,:REFLECT,:ROCKSMASH,:SHADOWBALL,:SHADOWCLAW,:SNARL,:SNATCH,:SPITE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:TORMENT,:TRIPLEAXEL,:XSCISSOR,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 280,
		:WildItemUncommon => :QUICKCLAW,
		:kind => "Sharp Claw",
		:dexentry => "A Sneasel scales trees by punching its hooked claws into the bark. It seeks out unguarded nests and steals eggs for food while the parents are away.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WEAVILE,:NightHoldItem,:RAZORCLAW]
		]
	},

	:OnCreation => {},
},

:TEDDIURSA => {
	"Normal Form" => {
		:name => "Teddiursa",
		:dexnum => 216,
		:Type1 => :NORMAL,
		:BaseStats => [60, 80, 50, 50, 50, 40],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:PICKUP, :QUICKFEET],
		:HiddenAbilities => :HONEYGATHER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BELLYDRUM,:CHIPAWAY,:CLOSECOMBAT,:COUNTER,:CROSSCHOP,:CRUNCH,:DOUBLEEDGE,:FAKETEARS,:METALCLAW,:NIGHTSLASH,:PLAYROUGH,:SEISMICTOSS,:SLEEPTALK,:TAKEDOWN,:YAWN,],
		:Moveset => [
			[1,:FLING],
			[1,:COVET],
			[1,:SCRATCH],
			[1,:BABYDOLLEYES],
			[1,:LICK],
			[1,:FAKETEARS],
			[8,:FURYSWIPES],
			[15,:FEINTATTACK],
			[22,:SWEETSCENT],
			[25,:PLAYNICE],
			[29,:SLASH],
			[36,:CHARM],
			[43,:REST],
			[43,:SNORE],
			[50,:THRASH],
			[57,:FLING]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COVET,:CUT,:CURSE,:CRUNCH,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FIREPUNCH,:FLING,:FOCUSPUNCH,:FOCUSENERGY,:FURYCUTTER,:GUNKSHOT,:HEADBUTT,:HYPERVOICE,:HONECLAWS,:LEER,:ICEPUNCH,:LASTRESORT,:MEGAPUNCH,:MEGAKICK,:METRONOME,:MIMIC,:MUDSLAP,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SEEDBOMB,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THUNDERPUNCH,:TORMENT,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWRUSH,],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 88,
		:kind => "Little Bear",
		:dexentry => "It licks its palms that are sweetened by being soaked in honey. A Teddiursa makes its own honey by blending fruits and pollen collected by Beedrill.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:URSARING,:Level,30]
		]
	},

	:OnCreation => {},
},

:URSARING => {
	"Normal Form" => {
		:name => "Ursaring",
		:dexnum => 217,
		:Type1 => :NORMAL,
		:BaseStats => [90, 130, 75, 75, 75, 55],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:GUTS, :QUICKFEET],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TEDDIURSA,
			:form => 0
		},
		:Moveset => [
			[1,:HAMMERARM],
			[1,:COVET],
			[1,:SCRATCH],
			[1,:LEER],
			[1,:LICK],
			[1,:FAKETEARS],
			[8,:FURYSWIPES],
			[15,:FEINTATTACK],
			[22,:SWEETSCENT],
			[25,:PLAYNICE],
			[29,:SLASH],
			[38,:SCARYFACE],
			[47,:REST],
			[49,:SNORE],
			[58,:THRASH],
			[67,:HAMMERARM]],
		:compatiblemoves => [:AERIALACE,:BRICKBREAK,:BULKUP,:BULLDOZE,:COVET,:CUT,:CRUNCH,:CURSE,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:EARTHQUAKE,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOCUSENERGY,:FURYCUTTER,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HIGHHORSEPOWER,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:ICEPUNCH,:LASERFOCUS,:LASTRESORT,:LOWKICK,:MEGAPUNCH,:MEGAKICK,:METRONOME,:MIMIC,:MUDSLAP,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SEEDBOMB,:SHADOWCLAW,:SMACKDOWN,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDERPUNCH,:TORMENT,:UPROAR,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 18,
		:Weight => 1258,
		:kind => "Hibernator",
		:dexentry => "It is said that there are many streams and towering trees where an Ursaring gathers food. It walks through its forest collecting food every day.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SLUGMA => {
	"Normal Form" => {
		:name => "Slugma",
		:dexnum => 218,
		:Type1 => :FIRE,
		:BaseStats => [40, 40, 40, 70, 40, 20],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:MAGMAARMOR, :FLAMEBODY],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDARMOR,:CURSE,:EARTHPOWER,:GUARDSWAP,:HEATWAVE,:INFERNO,:MEMENTO,:ROLLOUT,:SMOKESCREEN,:SPITUP,:STOCKPILE,:SWALLOW,],
		:Moveset => [
			[1,:YAWN],
			[1,:SMOG],
			[6,:EMBER],
			[8,:ROCKTHROW],
			[13,:HARDEN],
			[15,:INCINERATE],
			[20,:CLEARSMOG],
			[22,:ANCIENTPOWER],
			[27,:FLAMEBURST],
			[29,:ROCKSLIDE],
			[34,:LAVAPLUME],
			[36,:AMNESIA],
			[41,:BODYSLAM],
			[43,:RECOVER],
			[48,:FLAMETHROWER],
			[50,:EARTHPOWER]],
		:compatiblemoves => [:AFTERYOU,:ANCIENTPOWER,:CURSE,:DEFENSECURL,:DOUBLEEDGE,:EARTHPOWER,:FIREBLAST,:FLAMECHARGE,:FLAMETHROWER,:HEATWAVE,:INFESTATION,:INCINERATE,:IRONDEFENSE,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:NATUREPOWER,:OVERHEAT,:PAINSPLIT,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SUNNYDAY,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Amorphous],
		:Height => 7,
		:Weight => 350,
		:kind => "Lava",
		:dexentry => "It is a species of Pokémon that lives in volcanic areas. If its body cools, its skin hardens and immobilizes it. To avoid that, it sleeps near magma.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MAGCARGO,:Level,38]
		]
	},

	:OnCreation => {},
},

:MAGCARGO => {
	"Normal Form" => {
		:name => "Magcargo",
		:dexnum => 219,
		:Type1 => :FIRE,
		:Type2 => :ROCK,
		:BaseStats => [60, 50, 120, 90, 80, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:MAGMAARMOR, :FLAMEBODY],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 151,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SLUGMA,
			:form => 0
		},
		:Moveset => [
			[0,:SHELLSMASH],
			[1,:EARTHPOWER],
			[1,:YAWN],
			[1,:SMOG],
			[1,:EMBER],
			[1,:ROCKTHROW],
			[6,:EMBER],
			[8,:ROCKTHROW],
			[13,:HARDEN],
			[15,:INCINERATE],
			[20,:CLEARSMOG],
			[22,:ANCIENTPOWER],
			[27,:FLAMEBURST],
			[29,:ROCKSLIDE],
			[34,:LAVAPLUME],
			[36,:AMNESIA],
			[43,:BODYSLAM],
			[47,:RECOVER],
			[54,:FLAMETHROWER],
			[58,:EARTHPOWER]],
		:compatiblemoves => [:AFTERYOU,:ANCIENTPOWER,:BULLDOZE,:BURNINGJEALOUSY,:CURSE,:DEFENSECURL,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:GIGAIMPACT,:GYROBALL,:HEATWAVE,:HYPERBEAM,:INFESTATION,:IRONDEFENSE,:LIGHTSCREEN,:METEORBEAM,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:NATUREPOWER,:OVERHEAT,:PAINSPLIT,:POWERGEM,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRAVE,:SHADOWSHED,],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Amorphous],
		:Height => 8,
		:Weight => 550,
		:kind => "Lava",
		:dexentry => "The shell on its back is made of hardened magma. Tens of thousands of years spent living in volcanic craters have turned Magcargo's bodies into magma.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SWINUB => {
	"Normal Form" => {
		:name => "Swinub",
		:dexnum => 220,
		:Type1 => :ICE,
		:Type2 => :GROUND,
		:BaseStats => [50, 50, 40, 30, 30, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :SNOWCLOAK],
		:HiddenAbilities => :THICKFAT,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:BITE,:BODYSLAM,:CURSE,:DOUBLEEDGE,:FISSURE,:FREEZEDRY,:ICICLECRASH,:ICICLESPEAR,:MUDSHOT,:STEALTHROCK,:TAKEDOWN,],
		:Moveset => [
			[1,:TACKLE],
			[1,:ODORSLEUTH],
			[5,:MUDSPORT],
			[8,:POWDERSNOW],
			[11,:MUDSLAP],
			[14,:ENDURE],
			[18,:MUDBOMB],
			[21,:ICYWIND],
			[24,:ICESHARD],
			[28,:TAKEDOWN],
			[35,:MIST],
			[37,:EARTHQUAKE],
			[40,:FLAIL],
			[44,:BLIZZARD],
			[48,:AMNESIA]],
		:compatiblemoves => [:ANCIENTPOWER,:AMNESIA,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:HAIL,:HEADBUTT,:ICICLESPEAR,:ICEBEAM,:LIGHTSCREEN,:MIMIC,:MUDSHOT,:MUDSLAP,:RAINDANCE,:REFLECT,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDTOMB,:SANDSTORM,:STEALTHROCK,:STRENGTH,:SUPERPOWER,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWWAVE,],
		:Color => "Brown",
		:Habitat => "Cave",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 65,
		:kind => "Pig",
		:dexentry => "It roots for food by rubbing its snout against the ground. It likes mushrooms that grow under dried grass. It occasionally roots out hot springs.",
		:BattlerPlayerY => 36,
		:BattlerEnemyY => 31,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PILOSWINE,:Level,33]
		]
	},

	:OnCreation => {},
},

:PILOSWINE => {
	"Normal Form" => {
		:name => "Piloswine",
		:dexnum => 221,
		:Type1 => :ICE,
		:Type2 => :GROUND,
		:BaseStats => [100, 100, 80, 60, 60, 50],
		:EVs => [1, 1, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :SNOWCLOAK],
		:HiddenAbilities => :THICKFAT,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SWINUB,
			:form => 0
		},
		:Moveset => [
			[0,:FURYATTACK],
			[1,:ANCIENTPOWER],
			[1,:PECK],
			[1,:ODORSLEUTH],
			[1,:MUDSPORT],
			[1,:POWDERSNOW],
			[5,:MUDSPORT],
			[8,:POWDERSNOW],
			[11,:MUDSLAP],
			[14,:ENDURE],
			[18,:MUDBOMB],
			[21,:ICYWIND],
			[24,:ICEFANG],
			[28,:TAKEDOWN],
			[37,:MIST],
			[41,:THRASH],
			[46,:EARTHQUAKE],
			[52,:BLIZZARD],
			[58,:AMNESIA]],
		:compatiblemoves => [:ANCIENTPOWER,:AMNESIA,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CURSE,:DIG,:DETECT,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:GIGAIMPACT,:HAIL,:HEADBUTT,:HIGHHORSEPOWER,:HYPERBEAM,:ICICLESPEAR,:ICEBEAM,:ICYWIND,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:MUDSHOT,:RAINDANCE,:REFLECT,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SANDTOMB,:SANDSTORM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUPERPOWER,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Cave",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 558,
		:kind => "Swine",
		:dexentry => "A Piloswine is covered by a thick coat of long hair for enduring freezing cold. It uses its tusks to dig up food that has been buried under ice.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MAMOSWINE,:HasMove,:ANCIENTPOWER]
		]
	},

	:OnCreation => {},
},

:CORSOLA => {
	"Normal Form" => {
		:name => "Corsola",
		:dexnum => 222,
		:Type1 => :WATER,
		:Type2 => :ROCK,
		:BaseStats => [65, 55, 95, 65, 95, 35],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:HUSTLE, :NATURALCURE],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 144,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:AQUARING,:BARRIER,:BIDE,:CAMOUFLAGE,:CONFUSERAY,:CURSE,:HEADSMASH,:ICICLESPEAR,:INGRAIN,:LIQUIDATION,:MIST,:NATUREPOWER,:SCREECH,:WATERPULSE,],
		:Moveset => [
			[1,:TACKLE],
			[1,:HARDEN],
			[4,:BUBBLE],
			[8,:RECOVER],
			[10,:BUBBLEBEAM],
			[13,:REFRESH],
			[17,:ANCIENTPOWER],
			[20,:SPIKECANNON],
			[23,:LUCKYCHANT],
			[27,:BRINE],
			[29,:IRONDEFENSE],
			[31,:ROCKBLAST],
			[35,:ENDURE],
			[38,:AQUARING],
			[41,:POWERGEM],
			[45,:MIRRORCOAT],
			[47,:EARTHPOWER],
			[50,:FLAIL]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BLIZZARD,:BRINE,:BODYSLAM,:BULLDOZE,:CALMMIND,:CURSE,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:EXPLOSION,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:LIGHTSCREEN,:LIQUIDATION,:MIMIC,:METEORBEAM,:MUDSLAP,:NATUREPOWER,:PSYCHIC,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SCREECH,:SELFDESTRUCT,:SCALD,:SHADOWBALL,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SURF,:THROATCHOP,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water3],
		:Height => 6,
		:Weight => 50,
		:WildItemUncommon => :LUMINOUSMOSS,
		:kind => "Coral",
		:dexentry => "Corsola live in warm southern seas. If the sea becomes polluted, the beautiful coral stalks become discolored and crumble away in tatters.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :GHOST,
		:BaseStats => [60, 55, 100, 65, 100, 30],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:WEAKARMOR, :CURSEDBODY],
		:EggMoves => [:CONFUSERAY,:DESTINYBOND,:HAZE,:HEADSMASH,:NATUREPOWER,:WATERPULSE,],
		:Moveset => [
			[1,:HARDEN],
			[1,:TACKLE],
			[5,:ASTONISH],
			[10,:DISABLE],
			[15,:SPITE],
			[20,:ANCIENTPOWER],
			[25,:HEX],
			[30,:CURSE],
			[35,:STRENGTHSAP],
			[40,:POWERGEM],
			[45,:NIGHTSHADE],
			[50,:GRUDGE],
			[55,:MIRRORCOAT],
		],
		:compatiblemoves => [:AMNESIA,:BLIZZARD,:BODYSLAM,:BRINE,:BULLDOZE,:CALMMIND,:DIG,:EARTHPOWER,:EARTHQUAKE,:GIGADRAIN,:HAIL,:HEX,:HYDROPUMP,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:LIGHTSCREEN,:LIQUIDATION,:METEORBEAM,:MIMIC,:POWERGEM,:PSYCHIC,:RAINDANCE,:REFLECT,:ROCKBLAST,:ROCKSLIDE,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SCALD,:SCREECH,:SELFDESTRUCT,:SHADOWBALL,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:SUNNYDAY,:SURF,:THROATCHOP,:WHIRLPOOL,:WILLOWISP,],
		:moveexceptions => [],
		:Weight => 5,
		:dexentry => "Sudden climate change wiped out this ancient kind of Corsola. This Pokémon absorbs others’ life-force through its branches.",
		:evolutions => [
			[:CURSOLA,:Level,38]
		]
	},

	:OnCreation => {},
},

:REMORAID => {
	"Normal Form" => {
		:name => "Remoraid",
		:dexnum => 223,
		:Type1 => :WATER,
		:BaseStats => [35, 65, 35, 65, 35, 65],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:HUSTLE, :SNIPER],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDSPRAY,:AURORABEAM,:ENTRAINMENT,:FLAIL,:HAZE,:MUDSHOT,:OCTAZOOKA,:ROCKBLAST,:SCREECH,:SNORE,:SUPERSONIC,:SWIFT,:WATERPULSE,:WATERSPOUT,],
		:Moveset => [
			[1,:WATERGUN],
			[6,:LOCKON],
			[10,:PSYBEAM],
			[14,:AURORABEAM],
			[18,:BUBBLEBEAM],
			[22,:FOCUSENERGY],
			[26,:WATERPULSE],
			[30,:SIGNALBEAM],
			[34,:ICEBEAM],
			[38,:BULLETSEED],
			[42,:HYDROPUMP],
			[46,:HYPERBEAM],
			[50,:SOAK]],
		:compatiblemoves => [:ASSURANCE,:BLIZZARD,:BOUNCE,:BRINE,:BULLETSEED,:CHARGEBEAM,:CURSE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:FIREBLAST,:FLAMETHROWER,:FOCUSENERGY,:GUNKSHOT,:HYPERBEAM,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INCINERATE,:MIMIC,:MUDSHOT,:MUDSLAP,:PSYCHIC,:RAINDANCE,:ROCKBLAST,:SCALD,:SCREECH,:SEEDBOMB,:SIGNALBEAM,:SMACKDOWN,:STRINGSHOT,:SUNNYDAY,:SURF,:SWIFT,:THIEF,:THUNDERWAVE,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water2],
		:Height => 6,
		:Weight => 120,
		:kind => "Jet",
		:dexentry => "Remoraid uses its abdominal muscles to expel swallowed water, then shoot down flying prey. When evolution approaches, it travels down rivers.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 11,
		:evolutions => [
			[:OCTILLERY,:Level,25]
		]
	},

	:OnCreation => {},
},

:OCTILLERY => {
	"Normal Form" => {
		:name => "Octillery",
		:dexnum => 224,
		:Type1 => :WATER,
		:BaseStats => [75, 105, 75, 105, 75, 45],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:SUCTIONCUPS, :SNIPER],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 168,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :REMORAID,
			:form => 0
		},
		:Moveset => [
			[0,:OCTAZOOKA],
			[1,:GUNKSHOT],
			[1,:ROCKBLAST],
			[1,:WATERGUN],
			[1,:CONSTRICT],
			[1,:PSYBEAM],
			[1,:AURORABEAM],
			[6,:CONSTRICT],
			[10,:PSYBEAM],
			[14,:AURORABEAM],
			[18,:BUBBLEBEAM],
			[22,:FOCUSENERGY],
			[28,:WRINGOUT],
			[34,:SIGNALBEAM],
			[40,:ICEBEAM],
			[46,:BULLETSEED],
			[52,:HYDROPUMP],
			[58,:HYPERBEAM],
			[64,:SOAK]],
		:compatiblemoves => [:ASSURANCE,:BIND,:BLIZZARD,:BOUNCE,:BRINE,:BULLETSEED,:CHARGEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:ENERGYBALL,:FIREBLAST,:FLAMETHROWER,:FLASHCANNON,:FOCUSENERGY,:GIGAIMPACT,:GUNKSHOT,:HYPERBEAM,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INCINERATE,:MIMIC,:MUDSLAP,:MUDSHOT,:PAYBACK,:PSYCHIC,:RAINDANCE,:ROCKBLAST,:SCALD,:SEEDBOMB,:SEISMICTOSS,:SIGNALBEAM,:SKITTERSMACK,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:STRINGSHOT,:SUNNYDAY,:SURF,:SWIFT,:THIEF,:THUNDERWAVE,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water2],
		:Height => 9,
		:Weight => 285,
		:kind => "Jet",
		:dexentry => "It ensnares its foe with its suction- cupped tentacles before delivering the final blow. If the foe turns out to be too strong, it spews ink to escape.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:DELIBIRD => {
	"Normal Form" => {
		:name => "Delibird",
		:dexnum => 225,
		:Type1 => :ICE,
		:Type2 => :FLYING,
		:BaseStats => [45, 55, 45, 65, 45, 75],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:VITALSPIRIT, :HUSTLE],
		:HiddenAbilities => :INSOMNIA,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 116,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AURORABEAM,:BESTOW,:COUNTER,:DESTINYBOND,:FAKEOUT,:FREEZEDRY,:FUTURESIGHT,:ICEBALL,:ICEPUNCH,:ICESHARD,:ICYWIND,:QUICKATTACK,:RAPIDSPIN,:SPIKES,:SPLASH,],
		:Moveset => [
			[1,:PRESENT],
			[25,:DRILLPECK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ASSURANCE,:AURORAVEIL,:AVALANCHE,:BATONPASS,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRAVEBIRD,:BRICKBREAK,:BRUTALSWING,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DRILLRUN,:FLING,:FLY,:FOCUSPUNCH,:FROSTBREATH,:FUTURESIGHT,:GUNKSHOT,:HAIL,:HEADBUTT,:ICEBEAM,:ICEPUNCH,:ICYWIND,:ICICLESPEAR,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PLUCK,:RAINDANCE,:RECYCLE,:ROLLOUT,:SEEDBOMB,:SEISMICTOSS,:SIGNALBEAM,:SKYATTACK,:SPIKES,:SWIFT,:THIEF,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Water1, :Field],
		:Height => 9,
		:Weight => 160,
		:kind => "Delivery",
		:dexentry => "Delibird carries food bundled up in its tail. Once, a famous explorer managed to climb the world's highest mountain only thanks to a Delibird sharing its food.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MANTINE => {
	"Normal Form" => {
		:name => "Mantine",
		:dexnum => 226,
		:Type1 => :WATER,
		:Type2 => :FLYING,
		:BaseStats => [85, 40, 70, 80, 140, 70],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SWIFTSWIM, :WATERABSORB],
		:HiddenAbilities => :WATERVEIL,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:AMNESIA,:HAZE,:HYDROPUMP,:MIRRORCOAT,:MUDSPORT,:SLAM,:SPLASH,:TWISTER,:WATERSPORT,:WIDEGUARD,],
		:preevo => {
			:species => :MANTYKE,
			:form => 0
		},
		:Moveset => [
			[1,:PSYBEAM],
			[1,:BULLETSEED],
			[1,:SIGNALBEAM],
			[1,:TACKLE],
			[1,:BUBBLE],
			[1,:SUPERSONIC],
			[1,:BUBBLEBEAM],
			[1,:ROOST],
			[3,:SUPERSONIC],
			[7,:BUBBLEBEAM],
			[11,:CONFUSERAY],
			[14,:WINGATTACK],
			[16,:HEADBUTT],
			[19,:WATERPULSE],
			[23,:WIDEGUARD],
			[27,:TAKEDOWN],
			[32,:AGILITY],
			[36,:AIRSLASH],
			[39,:AQUARING],
			[46,:BOUNCE],
			[49,:HYDROPUMP]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:AMNESIA,:AQUATAIL,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRINE,:BULLDOZE,:BULLETSEED,:CURSE,:DEFOG,:DIVE,:DOUBLEEDGE,:DUALWINGBEAT,:EARTHQUAKE,:GIGAIMPACT,:GUNKSHOT,:HAIL,:HEADBUTT,:HELPINGHAND,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONHEAD,:LIQUIDATION,:MIMIC,:MUDSLAP,:RAINDANCE,:ROCKBLAST,:ROCKSLIDE,:ROCKTOMB,:ROOST,:SCALD,:SEEDBOMB,:SIGNALBEAM,:STRINGSHOT,:SURF,:SWIFT,:TAILWIND,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Sea",
		:EggGroups => [:Water1],
		:Height => 21,
		:Weight => 2200,
		:kind => "Kite",
		:dexentry => "On sunny days, schools of Mantine can be seen elegantly leaping over the waves. It is not bothered by the Remoraid that hitches rides.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 15,
	},

	:OnCreation => {},
},

:SKARMORY => {
	"Normal Form" => {
		:name => "Skarmory",
		:dexnum => 227,
		:Type1 => :STEEL,
		:Type2 => :FLYING,
		:BaseStats => [65, 80, 140, 40, 70, 70],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:KEENEYE, :STURDY],
		:HiddenAbilities => :WEAKARMOR,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 163,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:ASSURANCE,:BRAVEBIRD,:CURSE,:DRILLPECK,:ENDURE,:GUARDSWAP,:PURSUIT,:SKYATTACK,:STEALTHROCK,:WHIRLWIND,],
		:Moveset => [
			[1,:LEER],
			[1,:PECK],
			[6,:SANDATTACK],
			[9,:METALCLAW],
			[12,:AIRCUTTER],
			[17,:FURYATTACK],
			[20,:FEINT],
			[23,:SWIFT],
			[28,:SPIKES],
			[31,:AGILITY],
			[34,:STEELWING],
			[39,:SLASH],
			[42,:METALSOUND],
			[45,:AIRSLASH],
			[50,:AUTOTOMIZE],
			[53,:NIGHTSLASH]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BODYPRESS,:BRAVEBIRD,:COUNTER,:CURSE,:CUT,:DARKPULSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:FLASH,:FLASHCANNON,:FLY,:FURYCUTTER,:GUARDSWAP,:ICYWIND,:IRONDEFENSE,:IRONHEAD,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PAYBACK,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDTOMB,:SANDSTORM,:SKYATTACK,:SKYDROP,:STEALTHROCK,:STEELWING,:SPIKES,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAUNT,:THIEF,:TORMENT,:TWISTER,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Flying],
		:Height => 17,
		:Weight => 505,
		:WildItemUncommon => :METALCOAT,
		:kind => "Armor Bird",
		:dexentry => "A Pokémon that has a body and wings of steel. People in the past used feathers fallen from Skarmory to make swords and knives.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:HOUNDOUR => {
	"Normal Form" => {
		:name => "Houndour",
		:dexnum => 228,
		:Type1 => :DARK,
		:Type2 => :FIRE,
		:BaseStats => [45, 60, 30, 80, 50, 65],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:EARLYBIRD, :FLASHFIRE],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 120,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:BEATUP,:COUNTER,:DESTINYBOND,:FEINT,:FIREFANG,:FIRESPIN,:NASTYPLOT,:PUNISHMENT,:PURSUIT,:RAGE,:REVERSAL,:SPITE,:SUCKERPUNCH,:THUNDERFANG,],
		:Moveset => [
			[1,:LEER],
			[1,:EMBER],
			[4,:HOWL],
			[8,:SMOG],
			[13,:ROAR],
			[16,:BITE],
			[20,:ODORSLEUTH],
			[25,:BEATUP],
			[28,:FIREFANG],
			[32,:FEINTATTACK],
			[37,:EMBARGO],
			[40,:FOULPLAY],
			[44,:FLAMETHROWER],
			[49,:CRUNCH],
			[52,:NASTYPLOT],
			[56,:INFERNO]],
		:compatiblemoves => [:BODYSLAM,:CRUNCH,:CURSE,:DARKPULSE,:DETECT,:DOUBLEEDGE,:DREAMEATER,:EMBARGO,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FOULPLAY,:HEADBUTT,:HEATWAVE,:HEADBUTT,:HYPERVOICE,:IRONTAIL,:INCINERATE,:MIMIC,:MUDSLAP,:NIGHTMARE,:OVERHEAT,:PAYBACK,:ROAR,:ROCKSMASH,:ROLEPLAY,:SHADOWBALL,:SLUDGEBOMB,:SNARL,:SNATCH,:SOLARBEAM,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Black",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 108,
		:kind => "Dark",
		:dexentry => "Houndour communicate with each other using a variety of cries to corner their prey. This Pokémon's remarkable teamwork is simply unparalleled.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HOUNDOOM,:Level,24]
		]
	},

	:OnCreation => {},
},

:HOUNDOOM => {
	"Normal Form" => {
		:name => "Houndoom",
		:dexnum => 229,
		:Type1 => :DARK,
		:Type2 => :FIRE,
		:BaseStats => [75, 90, 50, 110, 80, 95],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:EARLYBIRD, :FLASHFIRE],
		:HiddenAbilities => :UNNERVE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :HOUNDOUR,
			:form => 0
		},
		:Moveset => [
			[1,:INFERNO],
			[1,:NASTYPLOT],
			[1,:THUNDERFANG],
			[1,:LEER],
			[1,:EMBER],
			[1,:HOWL],
			[1,:SMOG],
			[4,:HOWL],
			[8,:SMOG],
			[13,:ROAR],
			[16,:BITE],
			[20,:ODORSLEUTH],
			[26,:BEATUP],
			[30,:FIREFANG],
			[35,:FEINTATTACK],
			[41,:EMBARGO],
			[45,:FOULPLAY],
			[50,:FLAMETHROWER],
			[56,:CRUNCH],
			[60,:NASTYPLOT],
			[65,:INFERNO]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:BURNINGJEALOUSY,:CRUNCH,:CURSE,:DARKPULSE,:DETECT,:DOUBLEEDGE,:DREAMEATER,:EMBARGO,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FOULPLAY,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HEX,:HYPERBEAM,:HYPERVOICE,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LASHOUT,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:NIGHTMARE,:OVERHEAT,:PAYBACK,:ROAR,:ROCKSMASH,:ROLEPLAY,:SHADOWBALL,:SLUDGEBOMB,:SNARL,:SNATCH,:SOLARBEAM,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:UPROAR,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 14,
		:Weight => 350,
		:kind => "Dark",
		:dexentry => "In a Houndoom pack, the one with its horns raked sharply back serves a leadership role. They choose their leader by fighting among themselves.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [75, 90, 90, 140, 90, 115],
		:Abilities => [:SOLARPOWER],
		:Weight => 495,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:HOUNDOOMINITE => 1,
	},
},

:KINGDRA => {
	"Normal Form" => {
		:name => "Kingdra",
		:dexnum => 230,
		:Type1 => :WATER,
		:Type2 => :DRAGON,
		:BaseStats => [75, 95, 95, 95, 95, 85],
		:EVs => [0, 1, 0, 1, 1, 0],
		:Abilities => [:SWIFTSWIM, :SNIPER],
		:HiddenAbilities => :DAMP,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 243,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SEADRA,
			:form => 0
		},
		:Moveset => [
			[1,:HYDROPUMP],
			[1,:YAWN],
			[1,:BUBBLE],
			[1,:SMOKESCREEN],
			[1,:LEER],
			[1,:WATERGUN],
			[5,:SMOKESCREEN],
			[9,:LEER],
			[13,:WATERGUN],
			[17,:TWISTER],
			[21,:BUBBLEBEAM],
			[26,:FOCUSENERGY],
			[31,:BRINE],
			[38,:AGILITY],
			[45,:DRAGONPULSE],
			[52,:DRAGONDANCE],
			[60,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:BIDE,:BLIZZARD,:BODYSLAM,:BOUNCE,:BREAKINGSWIPE,:BRINE,:BUBBLEBEAM,:CURSE,:DIVE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:FLASHCANNON,:FLIPTURN,:FOCUSENERGY,:GIGAIMPACT,:HAIL,:HEADBUTT,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONHEAD,:LASERFOCUS,:LIQUIDATION,:MIMIC,:MUDDYWATER,:OUTRAGE,:QUASH,:RAGE,:RAINDANCE,:RAZORWIND,:SCALD,:SCALESHOT,:SIGNALBEAM,:SKULLBASH,:SURF,:SWIFT,:TAKEDOWN,:TWISTER,:WATERFALL,:WATERGUN,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Dragon],
		:Height => 18,
		:Weight => 1520,
		:WildItemUncommon => :DRAGONSCALE,
		:kind => "Dragon",
		:dexentry => "It sleeps quietly, deep on the seafloor. When it comes up to the surface, it creates a huge whirlpool that can swallow even ships.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 9,
	},

	:OnCreation => {},
},

:PHANPY => {
	"Normal Form" => {
		:name => "Phanpy",
		:dexnum => 231,
		:Type1 => :GROUND,
		:BaseStats => [90, 60, 60, 40, 40, 40],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:PICKUP, :SANDVEIL],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:BODYSLAM,:COUNTER,:ENDEAVOR,:FISSURE,:FOCUSENERGY,:HEADSMASH,:HEAVYSLAM,:HIGHHORSEPOWER,:ICESHARD,:MUDSLAP,:PLAYROUGH,:SNORE,],
		:Moveset => [
			[1,:ODORSLEUTH],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:DEFENSECURL],
			[6,:FLAIL],
			[10,:ROLLOUT],
			[15,:NATURALGIFT],
			[19,:ENDURE],
			[24,:SLAM],
			[28,:TAKEDOWN],
			[33,:CHARM],
			[37,:LASTRESORT],
			[42,:DOUBLEEDGE]],
		:compatiblemoves => [:ANCIENTPOWER,:BULLDOZE,:CHARM,:CURSE,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:GUNKSHOT,:HEADBUTT,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:MIMIC,:MUDSLAP,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SEEDBOMB,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:SUPERPOWER,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 335,
		:kind => "Long Nose",
		:dexentry => "Phanpy's big ears serve as broad fans. When it becomes hot, it flaps the ears busily to cool down. Even the young are very strong.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DONPHAN,:Level,25]
		]
	},

	:OnCreation => {},
},

:DONPHAN => {
	"Normal Form" => {
		:name => "Donphan",
		:dexnum => 232,
		:Type1 => :GROUND,
		:BaseStats => [90, 120, 120, 60, 60, 50],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:STURDY, :SANDVEIL],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PHANPY,
			:form => 0
		},
		:Moveset => [
			[0,:FURYATTACK],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:HORNATTACK],
			[1,:BULLDOZE],
			[1,:GROWL],
			[1,:DEFENSECURL],
			[6,:RAPIDSPIN],
			[10,:ROLLOUT],
			[15,:ASSURANCE],
			[19,:KNOCKOFF],
			[24,:SLAM],
			[30,:MAGNITUDE],
			[37,:SCARYFACE],
			[43,:EARTHQUAKE],
			[50,:GIGAIMPACT]],
		:compatiblemoves => [:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRUTALSWING,:BULLDOZE,:CHARM,:CURSE,:DARKESTLARIAT,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:GIGAIMPACT,:GUNKSHOT,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:HYPERVOICE,:IRONDEFENSE,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:MIMIC,:MUDSLAP,:POISONJAB,:ROAR,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SEEDBOMB,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 1200,
		:kind => "Armor",
		:dexentry => "A Donphan is so strong it can easily haul a dump truck. Its hide has toughened to a rock-hard state. An ordinary attack won't even leave a scratch.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PORYGON2 => {
	"Normal Form" => {
		:name => "Porygon2",
		:dexnum => 233,
		:Type1 => :NORMAL,
		:BaseStats => [85, 80, 90, 105, 95, 60],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:TRACE, :DOWNLOAD],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 180,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PORYGON,
			:form => 0
		},
		:Moveset => [
			[1,:ZAPCANNON],
			[1,:MAGICCOAT],
			[1,:CONVERSION2],
			[1,:TACKLE],
			[1,:CONVERSION],
			[1,:DEFENSECURL],
			[7,:PSYBEAM],
			[12,:AGILITY],
			[18,:RECOVER],
			[23,:MAGNETRISE],
			[29,:SIGNALBEAM],
			[34,:RECYCLE],
			[40,:DISCHARGE],
			[45,:LOCKON],
			[50,:TRIATTACK],
			[56,:MAGICCOAT],
			[62,:ZAPCANNON],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BIDE,:BLIZZARD,:BOUNCE,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CURSE,:DOUBLEEDGE,:DREAMEATER,:EARTHQUAKE,:EERIEIMPULSE,:ELECTROWEB,:ENERGYBALL,:FLASH,:FOULPLAY,:GIGAIMPACT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MAGNETRISE,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROAR,:ROLEPLAY,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SOLARBEAM,:SPEEDSWAP,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:UPROAR,:WILDCHARGE,:WONDERROOM,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:Habitat => "Urban",
		:EggGroups => [:Mineral],
		:Height => 6,
		:Weight => 325,
		:kind => "Virtual",
		:dexentry => "It was created using the power of science. It has been given artificial intelligence that enables it to learn new gestures and emotions on its own.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 11,
		:evolutions => [
			[:PORYGONZ,:TradeItem,:DUBIOUSDISC]
		]
	},

	:OnCreation => {},
},

:STANTLER => {
	"Normal Form" => {
		:name => "Stantler",
		:dexnum => 234,
		:Type1 => :NORMAL,
		:BaseStats => [73, 95, 62, 85, 65, 85],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :FRISK],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 163,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BITE,:DISABLE,:DOUBLEKICK,:EXTRASENSORY,:MEFIRST,:MEGAHORN,:MUDSPORT,:RAGE,:SPITE,:THRASH,:ZENHEADBUTT,],
		:Moveset => [
			[1,:MEFIRST],
			[1,:TACKLE],
			[3,:LEER],
			[7,:ASTONISH],
			[10,:HYPNOSIS],
			[13,:STOMP],
			[16,:SANDATTACK],
			[21,:TAKEDOWN],
			[23,:CONFUSERAY],
			[27,:CALMMIND],
			[33,:ROLEPLAY],
			[38,:ZENHEADBUTT],
			[43,:JUMPKICK],
			[49,:IMPRISON],
			[50,:CAPTIVATE],
			[55,:MEFIRST]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:BOUNCE,:BULLDOZE,:CALMMIND,:CURSE,:CHARGEBEAM,:DETECT,:DOUBLEEDGE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:ENERGYBALL,:FLASH,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:IMPRISON,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGICROOM,:MEGAHORN,:MIMIC,:MUDSLAP,:NIGHTMARE,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RETALIATE,:REFLECT,:ROAR,:ROLEPLAY,:SCARYFACE,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SPITE,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICKROOM,:UPROAR,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 14,
		:Weight => 712,
		:kind => "Big Horn",
		:dexentry => "Stantler's magnificent antlers were once traded at high prices as works of art. As a result, this Pokémon was hunted close to extinction.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SMEARGLE => {
	"Normal Form" => {
		:name => "Smeargle",
		:dexnum => 235,
		:Type1 => :NORMAL,
		:BaseStats => [55, 20, 35, 20, 45, 75],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:OWNTEMPO, :TECHNICIAN],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 88,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:SKETCH],
			[11,:SKETCH],
			[21,:SKETCH],
			[31,:SKETCH],
			[41,:SKETCH],
			[51,:SKETCH],
			[61,:SKETCH],
			[71,:SKETCH],
			[81,:SKETCH],
			[91,:SKETCH]],
		:compatiblemoves => [],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "White",
		:Habitat => "Urban",
		:EggGroups => [:Field],
		:Height => 12,
		:Weight => 580,
		:kind => "Painter",
		:dexentry => "A Smeargle marks its territory using a fluid that leaks out from the tip of its tail. About 5,000 different marks left by this Pokémon have been found.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TYROGUE => {
	"Normal Form" => {
		:name => "Tyrogue",
		:dexnum => 236,
		:Type1 => :FIGHTING,
		:BaseStats => [35, 35, 35, 35, 35, 35],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:GUTS, :STEADFAST],
		:HiddenAbilities => :VITALSPIRIT,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemZero,
		:BaseEXP => 42,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BULLETPUNCH,:COUNTER,:ENDURE,:FEINT,:HELPINGHAND,:HIJUMPKICK,:MACHPUNCH,:MINDREADER,:PURSUIT,:RAPIDSPIN,:VACUUMWAVE,],
		:Moveset => [
			[1,:TACKLE],
			[1,:HELPINGHAND],
			[1,:FAKEOUT],
			[1,:FORESIGHT]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:EARTHQUAKE,:FOCUSENERGY,:HEADBUTT,:HELPINGHAND,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:RAINDANCE,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROLEPLAY,:STRENGTH,:SUNNYDAY,:SWIFT,:THIEF,:UPROAR,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Urban",
		:EggGroups => [:Undiscovered],
		:Height => 7,
		:Weight => 210,
		:kind => "Scuffle",
		:dexentry => "Tyrogue become stressed out if they do not get to train every day. When raising this Pokémon, the Trainer must establish a regular training schedule.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HITMONLEE,:AttackGreater,20],
			[:HITMONCHAN,:DefenseGreater,20],
			[:HITMONTOP,:AtkDefEqual,20]
		]
	},

	:OnCreation => {},
},

:HITMONTOP => {
	"Normal Form" => {
		:name => "Hitmontop",
		:dexnum => 237,
		:Type1 => :FIGHTING,
		:BaseStats => [50, 95, 95, 35, 110, 70],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:INTIMIDATE, :TECHNICIAN],
		:HiddenAbilities => :STEADFAST,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemZero,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :TYROGUE,
			:form => 0
		},
		:Moveset => [
			[0,:ROLLINGKICK],
			[1,:ENDEAVOR],
			[1,:CLOSECOMBAT],
			[1,:DETECT],
			[1,:REVENGE],
			[1,:FOCUSENERGY],
			[1,:PURSUIT],
			[1,:QUICKATTACK],
			[6,:FOCUSENERGY],
			[10,:PURSUIT],
			[15,:QUICKATTACK],
			[19,:RAPIDSPIN],
			[24,:FEINT],
			[28,:COUNTER],
			[33,:TRIPLEKICK],
			[37,:AGILITY],
			[42,:GYROBALL],
			[46,:WIDEGUARD],
			[46,:QUICKGUARD],
			[50,:DETECT],
			[55,:CLOSECOMBAT],
			[60,:ENDEAVOR]],
		:compatiblemoves => [:ALLYSWITCH,:AGILITY,:AERIALACE,:BRICKBREAK,:BULKUP,:BULLDOZE,:COACHING,:COVET,:CURSE,:CLOSECOMBAT,:DOUBLEEDGE,:DIG,:DRILLRUN,:EARTHQUAKE,:ENDEAVOR,:FOCUSENERGY,:GYROBALL,:HEADBUTT,:HELPINGHAND,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MIMIC,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROLEPLAY,:ROLLOUT,:SANDSTORM,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:THIEF,:TRIPLEAXEL,:TWISTER,:VACUUMWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Urban",
		:EggGroups => [:HumanLike],
		:Height => 14,
		:Weight => 480,
		:kind => "Handstand",
		:dexentry => "Its technique of kicking while spinning is a remarkable mix of both offense and defense. Hitmontop travel faster spinning than they do walking.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SMOOCHUM => {
	"Normal Form" => {
		:name => "Smoochum",
		:dexnum => 238,
		:Type1 => :ICE,
		:Type2 => :PSYCHIC,
		:BaseStats => [45, 30, 15, 85, 65, 65],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:OBLIVIOUS, :FOREWARN],
		:HiddenAbilities => :HYDRATION,
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 61,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:CAPTIVATE,:FAKEOUT,:ICEPUNCH,:MEDITATE,:MIRACLEEYE,:NASTYPLOT,:WAKEUPSLAP,:WISH,],
		:Moveset => [
			[1,:POUND],
			[5,:LICK],
			[8,:SWEETKISS],
			[11,:POWDERSNOW],
			[15,:CONFUSION],
			[18,:SING],
			[21,:HEARTSTAMP],
			[25,:MEANLOOK],
			[28,:FAKETEARS],
			[31,:LUCKYCHANT],
			[35,:AVALANCHE],
			[38,:PSYCHIC],
			[41,:COPYCAT],
			[45,:PERISHSONG],
			[48,:BLIZZARD]],
		:compatiblemoves => [:AURORAVEIL,:AVALANCHE,:BLIZZARD,:BODYSLAM,:CALMMIND,:COVET,:COUNTER,:CURSE,:DOUBLEEDGE,:DREAMEATER,:DRAININGKISS,:ECHOEDVOICE,:FLASH,:FLING,:FROSTBREATH,:GRASSKNOT,:HAIL,:HEALBELL,:HELPINGHAND,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:STOREDPOWER,:THIEF,:TRICK,:TRICKROOM,:UPROAR,:WATERPULSE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:Undiscovered],
		:Height => 4,
		:Weight => 60,
		:kind => "Kiss",
		:dexentry => "It actively runs about, but also falls often. Whenever it falls, it will check its reflection on a lake's surface to make sure its face isn't dirty.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:JYNX,:Level,30]
		]
	},

	:OnCreation => {},
},

:ELEKID => {
	"Normal Form" => {
		:name => "Elekid",
		:dexnum => 239,
		:Type1 => :ELECTRIC,
		:BaseStats => [45, 63, 37, 65, 55, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:STATIC, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 72,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BARRIER,:CROSSCHOP,:DYNAMICPUNCH,:FEINT,:FIREPUNCH,:FOCUSPUNCH,:HAMMERARM,:ICEPUNCH,:KARATECHOP,:MEDITATE,:ROLLINGKICK,],
		:Moveset => [
			[1,:QUICKATTACK],
			[1,:LEER],
			[5,:THUNDERSHOCK],
			[8,:LOWKICK],
			[12,:SWIFT],
			[15,:SHOCKWAVE],
			[19,:THUNDERWAVE],
			[22,:ELECTROBALL],
			[26,:LIGHTSCREEN],
			[29,:THUNDERPUNCH],
			[33,:DISCHARGE],
			[36,:SCREECH],
			[40,:THUNDERBOLT],
			[43,:THUNDER]],
		:compatiblemoves => [:BODYSLAM,:BRICKBREAK,:CHARGEBEAM,:COVET,:CURSE,:DOUBLEEDGE,:DUALCHOP,:DETECT,:ELECTROWEB,:ELECTROBALL,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:LIGHTSCREEN,:LOWKICK,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:RAINDANCE,:ROCKSMASH,:SHOCKWAVE,:SIGNALBEAM,:SCREECH,:SWIFT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 235,
		:WildItemUncommon => :ELECTIRIZER,
		:kind => "Electric",
		:dexentry => "If it touches metal and discharges the electricity it has stored in its body, an Elekid begins swinging its arms in circles to recharge itself.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ELECTABUZZ,:Level,30]
		]
	},

	:OnCreation => {},
},

:MAGBY => {
	"Normal Form" => {
		:name => "Magby",
		:dexnum => 240,
		:Type1 => :FIRE,
		:BaseStats => [45, 75, 37, 70, 55, 83],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:FLAMEBODY, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 73,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BARRIER,:BELCH,:BELLYDRUM,:CROSSCHOP,:DYNAMICPUNCH,:FLAREBLITZ,:FOCUSENERGY,:IRONTAIL,:KARATECHOP,:MACHPUNCH,:MEGAPUNCH,:POWERSWAP,:SCREECH,:THUNDERPUNCH,],
		:Moveset => [
			[1,:SMOG],
			[1,:LEER],
			[5,:EMBER],
			[8,:SMOKESCREEN],
			[12,:FEINTATTACK],
			[15,:FIRESPIN],
			[19,:CLEARSMOG],
			[22,:FLAMEBURST],
			[26,:CONFUSERAY],
			[29,:FIREPUNCH],
			[33,:LAVAPLUME],
			[36,:SUNNYDAY],
			[40,:FLAMETHROWER],
			[43,:FIREBLAST]],
		:compatiblemoves => [:BODYSLAM,:BRICKBREAK,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DUALCHOP,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FOCUSENERGY,:FLING,:FOCUSPUNCH,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OVERHEAT,:POWERUPPUNCH,:PSYCHIC,:POWERSWAP,:ROCKSMASH,:SCARYFACE,:SCREECH,:SUNNYDAY,:THIEF,:THUNDERPUNCH,:UPROAR,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Undiscovered],
		:Height => 7,
		:Weight => 214,
		:WildItemUncommon => :MAGMARIZER,
		:kind => "Live Coal",
		:dexentry => "If a Magby is spouting yellow flames from its mouth, it is in good health. When it is fatigued, black smoke will be mixed in with the flames.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MAGMAR,:Level,30]
		]
	},

	:OnCreation => {},
},

:MILTANK => {
	"Normal Form" => {
		:name => "Miltank",
		:dexnum => 241,
		:Type1 => :NORMAL,
		:BaseStats => [95, 80, 105, 40, 70, 100],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:THICKFAT, :SCRAPPY],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :Slow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 172,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BELCH,:CURSE,:DIZZYPUNCH,:DOUBLEEDGE,:ENDURE,:HAMMERARM,:HEARTSTAMP,:HELPINGHAND,:NATURALGIFT,:PRESENT,:PUNISHMENT,:REVERSAL,:SEISMICTOSS,:SLEEPTALK,],
		:Moveset => [
			[1,:TACKLE],
			[3,:GROWL],
			[5,:DEFENSECURL],
			[8,:STOMP],
			[11,:MILKDRINK],
			[15,:BIDE],
			[19,:ROLLOUT],
			[24,:BODYSLAM],
			[29,:ZENHEADBUTT],
			[35,:CAPTIVATE],
			[41,:GYROBALL],
			[48,:HEALBELL],
			[50,:WAKEUPSLAP]],
		:compatiblemoves => [:AFTERYOU,:BLIZZARD,:BLOCK,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEALBELL,:HEAVYSLAM,:HIGHHORSEPOWER,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONHEAD,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:REVERSAL,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:STEALTHROCK,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SURF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:WATERPULSE,:WORKUP,:WHIRLPOOL,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 12,
		:Weight => 755,
		:WildItemCommon => :MOOMOOMILK,
		:WildItemUncommon => :MOOMOOMILK,
		:WildItemRare => :MOOMOOMILK,
		:kind => "Milk Cow",
		:dexentry => "It gives over five gallons of milk daily. Its milk is enjoyed by children and grown-ups alike. People who can't drink milk turn it into yogurt instead.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BLISSEY => {
	"Normal Form" => {
		:name => "Blissey",
		:dexnum => 242,
		:Type1 => :NORMAL,
		:BaseStats => [255, 10, 10, 75, 135, 55],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:NATURALCURE, :SERENEGRACE],
		:HiddenAbilities => :HEALER,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 608,
		:CatchRate => 30,
		:Happiness => 140,
		:EggSteps => 10455,
		:preevo => {
			:species => :CHANSEY,
			:form => 0
		},
		:Moveset => [
			[1,:DOUBLEEDGE],
			[1,:DEFENSECURL],
			[1,:POUND],
			[1,:GROWL],
			[5,:TAILWHIP],
			[9,:REFRESH],
			[12,:DOUBLESLAP],
			[16,:SOFTBOILED],
			[20,:BESTOW],
			[23,:MINIMIZE],
			[27,:TAKEDOWN],
			[31,:SING],
			[34,:FLING],
			[39,:HEALPULSE],
			[44,:EGGBOMB],
			[50,:LIGHTSCREEN],
			[57,:HEALINGWISH],
			[65,:DOUBLEEDGE]],
		:compatiblemoves => [:ALLYSWITCH,:AVALANCHE,:BABYDOLLEYES,:BIDE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BUBBLEBEAM,:BULLDOZE,:CALMMIND,:CELEBRATE,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SKULLBASH,:SNATCH,:SOFTBOILED,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STOREDPOWER,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SWEETSCENT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:UPROAR,:WATERGUN,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Urban",
		:EggGroups => [:Fairy],
		:Height => 15,
		:Weight => 468,
		:WildItemUncommon => :LUCKYEGG,
		:kind => "Happiness",
		:dexentry => "If it senses sadness with its fluffy fur, a Blissey will rush over to the sad person to share an egg of happiness that brings a smile to any face.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:RAIKOU => {
	"Normal Form" => {
		:name => "Raikou",
		:dexnum => 243,
		:Type1 => :ELECTRIC,
		:BaseStats => [90, 85, 75, 115, 100, 115],
		:EVs => [0, 0, 0, 1, 0, 2],
		:Abilities => [:PRESSURE, :INNERFOCUS],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:ZAPCANNON],
			[1,:WEATHERBALL],
			[1,:AURASPHERE],
			[1,:EXTREMESPEED],
			[1,:EXTRASENSORY],
			[1,:DISCHARGE],
			[1,:BITE],
			[1,:LEER],
			[8,:THUNDERSHOCK],
			[15,:ROAR],
			[22,:QUICKATTACK],
			[29,:SPARK],
			[36,:REFLECT],
			[43,:CRUNCH],
			[50,:THUNDERFANG],
			[57,:DISCHARGE],
			[64,:EXTRASENSORY],
			[71,:RAINDANCE],
			[78,:CALMMIND],
			[85,:THUNDER]],
		:compatiblemoves => [:AGILITY,:AURASPHERE,:BODYSLAM,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CUT,:CURSE,:CRUNCH,:DETECT,:DIG,:DOUBLEEDGE,:EERIEIMPULSE,:ELECTRICTERRAIN,:EXTREMESPEED,:FLASH,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MIMIC,:MUDSLAP,:PSYCHUP,:QUASH,:RAINDANCE,:REFLECT,:ROAR,:ROCKCLIMB,:ROCKSMASH,:RISINGVOLTAGE,:SANDSTORM,:SCALD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SUNNYDAY,:SWIFT,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:VOLTSWITCH,:WEATHERBALL,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 19,
		:Weight => 1780,
		:kind => "Thunder",
		:dexentry => "Raikou embodies the speed of lightning. Its roars send shock waves shuddering through the air and ground as if lightning bolts were crashing down.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ENTEI => {
	"Normal Form" => {
		:name => "Entei",
		:dexnum => 244,
		:Type1 => :FIRE,
		:BaseStats => [115, 115, 85, 90, 75, 100],
		:EVs => [1, 2, 0, 0, 0, 0],
		:Abilities => [:PRESSURE, :INNERFOCUS],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:FLAREBLITZ],
			[1,:CRUSHCLAW],
			[1,:HOWL],
			[1,:EXTREMESPEED],
			[1,:SACREDFIRE],
			[1,:ERUPTION],
			[1,:EXTRASENSORY],
			[1,:LAVAPLUME],
			[1,:BITE],
			[1,:LEER],
			[8,:EMBER],
			[15,:ROAR],
			[22,:FIRESPIN],
			[29,:STOMP],
			[36,:FLAMETHROWER],
			[43,:SWAGGER],
			[50,:FIREFANG],
			[57,:LAVAPLUME],
			[64,:EXTRASENSORY],
			[71,:FIREBLAST],
			[78,:CALMMIND],
			[85,:ERUPTION]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:BULLDOZE,:CALMMIND,:CUT,:CRUSHCLAW,:CRUNCH,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:EXTREMESPEED,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLASH,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:HOWL,:IRONHEAD,:IRONTAIL,:INCINERATE,:LASERFOCUS,:MIMIC,:MUDSLAP,:OVERHEAT,:PSYCHUP,:QUASH,:RAINDANCE,:REFLECT,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSMASH,:SANDSTORM,:SCORCHINGSANDS,:SHADOWBALL,:SNARL,:SOLARBEAM,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 21,
		:Weight => 1980,
		:kind => "Volcano",
		:dexentry => "Entei embodies the passion of magma. It is thought to have been born in the eruption of a volcano. It blasts fire that consumes all that it touches.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SUICUNE => {
	"Normal Form" => {
		:name => "Suicune",
		:dexnum => 245,
		:Type1 => :WATER,
		:BaseStats => [100, 75, 115, 90, 115, 85],
		:EVs => [0, 0, 1, 0, 2, 0],
		:Abilities => [:PRESSURE, :INNERFOCUS],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:AIRSLASH],
			[1,:AQUARING],
			[1,:EXTREMESPEED],
			[1,:BITE],
			[1,:LEER],
			[1,:BUBBLEBEAM],
			[1,:RAINDANCE],
			[8,:BUBBLEBEAM],
			[15,:RAINDANCE],
			[22,:GUST],
			[29,:AURORABEAM],
			[36,:MIST],
			[43,:MIRRORCOAT],
			[50,:ICEFANG],
			[57,:TAILWIND],
			[64,:EXTRASENSORY],
			[71,:HYDROPUMP],
			[78,:CALMMIND],
			[85,:BLIZZARD]],
		:compatiblemoves => [:AGILITY,:AIRSLASH,:AVALANCHE,:BRINE,:BLIZZARD,:BULLDOZE,:CALMMIND,:CUT,:CURSE,:DIG,:DIVE,:DETECT,:DOUBLEEDGE,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYPERBEAM,:HYDROPUMP,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:LIQUIDATION,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PSYCHUP,:QUASH,:RAINDANCE,:REFLECT,:ROAR,:ROCKCLIMB,:ROCKSMASH,:SANDSTORM,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SNARL,:SUNNYDAY,:SURF,:SWIFT,:TAILWIND,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Undiscovered],
		:Height => 20,
		:Weight => 1870,
		:kind => "Aurora",
		:dexentry => "Suicune embodies the compassion of a pure spring of water. It runs across the land with gliding elegance. It has the power to purify dirty water.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LARVITAR => {
	"Normal Form" => {
		:name => "Larvitar",
		:dexnum => 246,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [50, 64, 50, 45, 50, 41],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:GUTS, :SANDVEIL],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:EggMoves => [:ANCIENTPOWER,:ASSURANCE,:CURSE,:DRAGONDANCE,:FOCUSENERGY,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:OUTRAGE,:PURSUIT,:STEALTHROCK,:STOMP,],
		:Moveset => [
			[1,:BITE],
			[1,:LEER],
			[5,:SANDSTORM],
			[10,:SCREECH],
			[14,:CHIPAWAY],
			[19,:ROCKSLIDE],
			[23,:SCARYFACE],
			[28,:THRASH],
			[32,:DARKPULSE],
			[37,:PAYBACK],
			[41,:CRUNCH],
			[46,:EARTHQUAKE],
			[50,:STONEEDGE],
			[55,:HYPERBEAM]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BRICKBREAK,:BODYSLAM,:BULLDOZE,:CRUNCH,:CURSE,:DARKPULSE,:DRAGONDANCE,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:HEADBUTT,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MUDDYWATER,:MIMIC,:OUTRAGE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SMACKDOWN,:SNARL,:SPITE,:STEALTHROCK,:STONEEDGE,:SUNNYDAY,:SUPERPOWER,:TAUNT,:TORMENT,:UPROAR,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 6,
		:Weight => 720,
		:kind => "Rock Skin",
		:dexentry => "A Larvitar is born deep under the ground. It must eat its way through the soil above and reach the surface for it to see its parents' faces.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PUPITAR,:Level,30]
		]
	},

	:OnCreation => {},
},

:PUPITAR => {
	"Normal Form" => {
		:name => "Pupitar",
		:dexnum => 247,
		:Type1 => :ROCK,
		:Type2 => :GROUND,
		:BaseStats => [70, 84, 70, 65, 70, 51],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :ROCKHEAD],	#Rock head added so the ability index is maintained on evolution, don't worry about it  - Fal
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :LARVITAR,
			:form => 0
		},
		:Moveset => [
			[1,:BITE],
			[1,:LEER],
			[1,:SANDSTORM],
			[1,:SCREECH],
			[5,:SANDSTORM],
			[10,:SCREECH],
			[14,:CHIPAWAY],
			[19,:ROCKSLIDE],
			[23,:SCARYFACE],
			[28,:THRASH],
			[34,:DARKPULSE],
			[41,:PAYBACK],
			[47,:CRUNCH],
			[54,:EARTHQUAKE],
			[60,:STONEEDGE],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BRICKBREAK,:BODYSLAM,:BULLDOZE,:CURSE,:DARKPULSE,:DRAGONDANCE,:DETECT,:DOUBLEEDGE,:DIG,:EARTHPOWER,:EARTHQUAKE,:FOCUSENERGY,:HEADBUTT,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MUDDYWATER,:MIMIC,:OUTRAGE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SMACKDOWN,:SNARL,:SPITE,:STEALTHROCK,:STONEEDGE,:SUNNYDAY,:SUPERPOWER,:TAUNT,:TORMENT,:UPROAR,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 12,
		:Weight => 1520,
		:kind => "Hard Shell",
		:dexentry => "A Pupitar creates a gas inside its body that it ejects under compression to propel itself. Its body can withstand a collision with solid steel.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 8,
		:evolutions => [
			[:TYRANITAR,:Level,55]
		]
	},

	:OnCreation => {},
},

:TYRANITAR => {
	"Normal Form" => {
		:name => "Tyranitar",
		:dexnum => 248,
		:Type1 => :ROCK,
		:Type2 => :DARK,
		:BaseStats => [100, 134, 110, 95, 100, 61],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:SANDSTREAM, :UNNERVE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :PUPITAR,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERFANG],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:BITE],
			[1,:LEER],
			[1,:SANDSTORM],
			[1,:SCREECH],
			[5,:SANDSTORM],
			[10,:SCREECH],
			[14,:CHIPAWAY],
			[19,:ROCKSLIDE],
			[23,:SCARYFACE],
			[28,:THRASH],
			[34,:DARKPULSE],
			[41,:PAYBACK],
			[47,:CRUNCH],
			[54,:EARTHQUAKE],
			[63,:STONEEDGE],
			[73,:HYPERBEAM],
			[82,:GIGAIMPACT]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:ASSURANCE,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BRICKBREAK,:BREAKINGSWIPE,:BODYSLAM,:BRUTALSWING,:BULLDOZE,:CUT,:CURSE,:COUNTER,:DARKPULSE,:DETECT,:DIG,:DOUBLEEDGE,:DRAGONDANCE,:DRAGONCLAW,:DRAGONBREATH,:DRAGONPULSE,:DRAGONTAIL,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HIGHHORSEPOWER,:HYPERBEAM,:HYDROPUMP,:ICEBEAM,:ICEFANG,:ICEPUNCH,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:LASHOUT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:MUDDYWATER,:NIGHTMARE,:OUTRAGE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SEISMICTOSS,:SCARYFACE,:SCREECH,:SHADOWCLAW,:SHOCKWAVE,:SMACKDOWN,:SNARL,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:THUNDERFANG,:TORMENT,:UPROAR,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 20,
		:Weight => 2020,
		:kind => "Armor",
		:dexentry => "A Tyranitar is so overwhelmingly strong, it can bring down a whole mountain to make its nest. It roams in mountains seeking new opponents to fight.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [100, 164, 150, 95, 120, 71],
		:Abilities => [:SANDSTREAM],
		:Weight => 2550,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:TYRANITARITE => 1,
	},
},

:LUGIA => {
	"Normal Form" => {
		:name => "Lugia",
		:dexnum => 249,
		:Type1 => :PSYCHIC,
		:Type2 => :FLYING,
		:BaseStats => [106, 90, 130, 90, 154, 110],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:PRESSURE, :MULTISCALE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:WHIRLWIND],
			[1,:WEATHERBALL],
			[9,:GUST],
			[15,:DRAGONRUSH],
			[23,:EXTRASENSORY],
			[29,:RAINDANCE],
			[37,:HYDROPUMP],
			[43,:AEROBLAST],
			[50,:PUNISHMENT],
			[57,:ANCIENTPOWER],
			[65,:SAFEGUARD],
			[71,:RECOVER],
			[79,:FUTURESIGHT],
			[85,:NATURALGIFT],
			[93,:CALMMIND],
			[99,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AIRSLASH,:AIRCUTTER,:AVALANCHE,:ANCIENTPOWER,:AQUATAIL,:BLIZZARD,:BULLDOZE,:BODYSLAM,:BRINE,:CALMMIND,:CHARGEBEAM,:CURSE,:DETECT,:DEFOG,:DIVE,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONBREATH,:DRAGONTAIL,:DREAMEATER,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FLASH,:FLY,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYPERBEAM,:HYPERVOICE,:HURRICANE,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IRONHEAD,:IRONTAIL,:IMPRISON,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:NIGHTMARE,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROAR,:ROCKSMASH,:ROOST,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKYATTACK,:SKYDROP,:STEELWING,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:TAILWIND,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:TWISTER,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWBLAST,:SHADOWSHED,:SHADOWDOWN,:SHADOWSTORM,],
		:Color => "White",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 52,
		:Weight => 2160,
		:kind => "Diving",
		:dexentry => "Lugia is so powerful that even a light fluttering of its wings can blow apart houses. As a result, it chooses to live out of sight deep under the sea.",
		:BattlerPlayerY => 7,
		:BattlerEnemyY => 5,
		:BattlerAltitude => 6,
	},

	:OnCreation => {},
},

:HOOH => {
	"Normal Form" => {
		:name => "Ho-Oh",
		:dexnum => 250,
		:Type1 => :FIRE,
		:Type2 => :FLYING,
		:BaseStats => [106, 130, 90, 110, 154, 90],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:PRESSURE, :REGENERATOR],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:WHIRLWIND],
			[1,:WEATHERBALL],
			[9,:GUST],
			[15,:BRAVEBIRD],
			[23,:EXTRASENSORY],
			[29,:SUNNYDAY],
			[37,:FIREBLAST],
			[43,:SACREDFIRE],
			[50,:PUNISHMENT],
			[57,:ANCIENTPOWER],
			[65,:SAFEGUARD],
			[71,:RECOVER],
			[79,:FUTURESIGHT],
			[85,:NATURALGIFT],
			[93,:CALMMIND],
			[99,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AIRSLASH,:AIRCUTTER,:ANCIENTPOWER,:BRAVEBIRD,:BULLDOZE,:CALMMIND,:CELEBRATE,:CHARGEBEAM,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:DREAMEATER,:DRAGONBREATH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLASH,:FLY,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:HEATWAVE,:HYPERBEAM,:HYPERVOICE,:IRONHEAD,:INCINERATE,:IMPRISON,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:NIGHTMARE,:OMINOUSWIND,:OVERHEAT,:PLUCK,:PSYCHIC,:PSYCHUP,:RAINDANCE,:REFLECT,:ROAR,:ROCKSMASH,:ROOST,:SAFEGUARD,:SANDSTORM,:SCORCHINGSANDS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKYATTACK,:SKYDROP,:SOLARBEAM,:STEELWING,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILWIND,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:WEATHERBALL,:WILLOWISP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 38,
		:Weight => 1990,
		:WildItemCommon => :SACREDASH,
		:WildItemUncommon => :SACREDASH,
		:WildItemRare => :SACREDASH,
		:kind => "Rainbow",
		:dexentry => "Its feathers-- which glow in seven colors depending on the angle at which they are struck by light-- are thought to bring joy.",
		:BattlerPlayerY => 6,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 8,
	},

	:OnCreation => {},
},

:CELEBI => {
	"Normal Form" => {
		:name => "Celebi",
		:dexnum => 251,
		:Type1 => :PSYCHIC,
		:Type2 => :GRASS,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:NATURALCURE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 100,
		:EggSteps => 30855,
		:Moveset => [
			[1,:LEECHSEED],
			[1,:CONFUSION],
			[1,:RECOVER],
			[1,:HEALBELL],
			[10,:SAFEGUARD],
			[19,:MAGICALLEAF],
			[28,:ANCIENTPOWER],
			[37,:BATONPASS],
			[46,:NATURALGIFT],
			[55,:HEALBLOCK],
			[64,:FUTURESIGHT],
			[73,:HEALINGWISH],
			[82,:LEAFSTORM],
			[91,:PERISHSONG]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:ANCIENTPOWER,:CALMMIND,:CHARGEBEAM,:CUT,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DETECT,:DOUBLEEDGE,:DUALWINGBEAT,:DREAMEATER,:EARTHPOWER,:ECHOEDVOICE,:ENERGYBALL,:EXPANDINGFORCE,:FLASH,:FLING,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:GRASSYGLIDE,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:IMPRISON,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICROOM,:MAGICALLEAF,:METRONOME,:MIMIC,:MUDSLAP,:NIGHTMARE,:NATUREPOWER,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:RAINDANCE,:REFLECT,:SAFEGUARD,:SANDSTORM,:SEEDBOMB,:SILVERWIND,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SOLARBLADE,:STEALTHROCK,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:TELEKINESIS,:THUNDERWAVE,:TRICK,:TRICKROOM,:UPROAR,:UTURN,:WATERPULSE,:WEATHERBALL,:WONDERROOM,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 50,
		:WildItemCommon => :LUMBERRY,
		:WildItemUncommon => :LUMBERRY,
		:WildItemRare => :LUMBERRY,
		:kind => "Time Travel",
		:dexentry => "This Pokémon came from the future by crossing over time. It is thought that so long as Celebi appears, a bright and shining future awaits us.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:TREECKO => {
	"Normal Form" => {
		:name => "Treecko",
		:dexnum => 252,
		:Type1 => :GRASS,
		:BaseStats => [40, 45, 35, 65, 55, 70],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:OVERGROW, :UNBURDEN],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BULLETSEED,:CRUNCH,:CRUSHCLAW,:DOUBLEKICK,:DRAGONBREATH,:ENDEAVOR,:GRASSWHISTLE,:GRASSYTERRAIN,:LEAFSTORM,:LEECHSEED,:MAGICALLEAF,:MUDSPORT,:NATURALGIFT,:RAZORWIND,:SYNTHESIS,:WORRYSEED,],
		:Moveset => [
			[1,:POUND],
			[1,:LEER],
			[5,:ABSORB],
			[9,:QUICKATTACK],
			[13,:MEGADRAIN],
			[17,:PURSUIT],
			[21,:GIGADRAIN],
			[25,:AGILITY],
			[29,:SLAM],
			[33,:DETECT],
			[37,:ENERGYBALL],
			[41,:QUICKGUARD],
			[45,:ENDEAVOR],
			[49,:SCREECH]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:ASSURANCE,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:COUNTER,:CRUNCH,:CUT,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ENDEAVOR,:ENERGYBALL,:FLASH,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:IRONTAIL,:LEAFSTORM,:LOWKICK,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:THUNDERPUNCH,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Monster, :Dragon],
		:Height => 5,
		:Weight => 50,
		:kind => "Wood Gecko",
		:dexentry => "It makes its nest in trees in the forest. It ferociously guards against anything near its territory. It is said to be the protector of the forest's trees.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GROVYLE,:Level,16]
		]
	},

	:OnCreation => {},
},

:GROVYLE => {
	"Normal Form" => {
		:name => "Grovyle",
		:dexnum => 253,
		:Type1 => :GRASS,
		:BaseStats => [50, 65, 45, 85, 65, 95],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:OVERGROW, :UNBURDEN],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TREECKO,
			:form => 0
		},
		:Moveset => [
			[0,:FURYCUTTER],
			[1,:POUND],
			[1,:LEER],
			[1,:ABSORB],
			[1,:QUICKATTACK],
			[5,:ABSORB],
			[9,:QUICKATTACK],
			[13,:MEGADRAIN],
			[18,:PURSUIT],
			[23,:LEAFBLADE],
			[28,:AGILITY],
			[33,:SLAM],
			[38,:DETECT],
			[43,:XSCISSOR],
			[48,:FALSESWIPE],
			[53,:QUICKGUARD],
			[58,:LEAFSTORM],
			[63,:SCREECH]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:ASSURANCE,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:COUNTER,:CRUNCH,:CUT,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ENDEAVOR,:ENERGYBALL,:FALSESWIPE,:FLASH,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:IRONTAIL,:LEAFBLADE,:LEAFSTORM,:LOWKICK,:LOWSWEEP,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:SOLARBLADE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:THUNDERPUNCH,:WORKUP,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Monster, :Dragon],
		:Height => 9,
		:Weight => 216,
		:kind => "Wood Gecko",
		:dexentry => "Leaves grow out of this Pokémon's body. They help obscure a Grovyle from the eyes of its enemies while it is in a thickly overgrown forest.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SCEPTILE,:Level,36]
		]
	},

	:OnCreation => {},
},

:SCEPTILE => {
	"Normal Form" => {
		:name => "Sceptile",
		:dexnum => 254,
		:Type1 => :GRASS,
		:BaseStats => [70, 85, 65, 105, 85, 120],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:OVERGROW, :UNBURDEN],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GROVYLE,
			:form => 0
		},
		:Moveset => [
			[0,:DUALCHOP],
			[1,:FURYCUTTER],
			[1,:LEAFSTORM],
			[1,:NIGHTSLASH],
			[1,:POUND],
			[1,:LEER],
			[1,:ABSORB],
			[1,:QUICKATTACK],
			[5,:ABSORB],
			[9,:QUICKATTACK],
			[13,:MEGADRAIN],
			[18,:PURSUIT],
			[23,:LEAFBLADE],
			[28,:AGILITY],
			[33,:SLAM],
			[39,:DETECT],
			[45,:XSCISSOR],
			[51,:FALSESWIPE],
			[57,:QUICKGUARD],
			[63,:LEAFSTORM],
			[69,:SCREECH]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:ASSURANCE,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:BULLETSEED,:COUNTER,:CROSSPOISON,:CRUNCH,:CUT,:DIG,:DOUBLEEDGE,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAINPUNCH,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ENDEAVOR,:ENERGYBALL,:FALSESWIPE,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FRENZYPLANT,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:IRONTAIL,:LASERFOCUS,:LEAFBLADE,:LEAFSTORM,:LOWKICK,:LOWSWEEP,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:POWERUPPUNCH,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SCALESHOT,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:SOLARBLADE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:THROATCHOP,:THUNDERPUNCH,:WORKUP,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Monster, :Dragon],
		:Height => 17,
		:Weight => 522,
		:kind => "Forest",
		:dexentry => "In the jungle, its power is without equal. This Pokémon carefully grows trees and plants. It regulates its body temperature by basking in sunlight.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :DRAGON,
		:BaseStats => [70, 110, 75, 145, 85, 145],
		:Abilities => [:LIGHTNINGROD],
		:Height => 19,
		:Weight => 552,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SCEPTILITE => 1,
	},
},

:TORCHIC => {
	"Normal Form" => {
		:name => "Torchic",
		:dexnum => 255,
		:Type1 => :FIRE,
		:BaseStats => [45, 60, 40, 70, 50, 45],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:BLAZE, :SPEEDBOOST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:BATONPASS,:COUNTER,:CRUSHCLAW,:CURSE,:ENDURE,:FEATHERDANCE,:FEINT,:FLAMEBURST,:LASTRESORT,:LOWKICK,:NIGHTSLASH,:REVERSAL,:SMELLINGSALTS,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[5,:EMBER],
			[10,:SANDATTACK],
			[14,:PECK],
			[19,:FIRESPIN],
			[23,:QUICKATTACK],
			[28,:FLAMEBURST],
			[32,:FOCUSENERGY],
			[37,:SLASH],
			[41,:MIRRORMOVE],
			[46,:FLAMETHROWER]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ASSURANCE,:BATONPASS,:BODYSLAM,:BOUNCE,:COUNTER,:CUT,:DEFOG,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FIREBLAST,:FIREPLEDGE,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FOCUSENERGY,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:LASTRESORT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OVERHEAT,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 25,
		:kind => "Chick",
		:dexentry => "If attacked, it strikes back by spitting balls of fire it forms in its stomach. A Torchic dislikes darkness because it can't see its surroundings.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:COMBUSKEN,:Level,16]
		]
	},

	:OnCreation => {},
},

:COMBUSKEN => {
	"Normal Form" => {
		:name => "Combusken",
		:dexnum => 256,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [60, 85, 60, 85, 60, 55],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:BLAZE, :SPEEDBOOST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TORCHIC,
			:form => 0
		},
		:Moveset => [
			[0,:DOUBLEKICK],
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:EMBER],
			[1,:SANDATTACK],
			[5,:EMBER],
			[10,:SANDATTACK],
			[14,:PECK],
			[20,:FLAMECHARGE],
			[25,:QUICKATTACK],
			[31,:BULKUP],
			[36,:FOCUSENERGY],
			[42,:SLASH],
			[47,:MIRRORMOVE],
			[53,:SKYUPPERCUT],
			[58,:FLAREBLITZ]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ASSURANCE,:BATONPASS,:BLAZEKICK,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BULKUP,:COACHING,:COUNTER,:CUT,:DEFOG,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:ECHOEDVOICE,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OVERHEAT,:POISONJAB,:REVENGE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:THUNDERPUNCH,:VACUUMWAVE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 195,
		:kind => "Young Fowl",
		:dexentry => "It lashes out with 10 kicks per second. Its strong fighting instinct compels it to keep up its offensive until the opponent gives up.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BLAZIKEN,:Level,36]
		]
	},

	:OnCreation => {},
},

:BLAZIKEN => {
	"Normal Form" => {
		:name => "Blaziken",
		:dexnum => 257,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [80, 120, 70, 110, 70, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:BLAZE, :SPEEDBOOST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :COMBUSKEN,
			:form => 0
		},
		:Moveset => [
			[0,:BLAZEKICK],
			[1,:DOUBLEKICK],
			[1,:FLAREBLITZ],
			[1,:FIREPUNCH],
			[1,:HIJUMPKICK],
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:EMBER],
			[1,:SANDATTACK],
			[5,:EMBER],
			[10,:SANDATTACK],
			[14,:PECK],
			[20,:FLAMECHARGE],
			[25,:QUICKATTACK],
			[31,:BULKUP],
			[37,:FOCUSENERGY],
			[44,:SLASH],
			[50,:BRAVEBIRD],
			[57,:SKYUPPERCUT],
			[63,:FLAREBLITZ]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:ASSURANCE,:AURASPHERE,:BATONPASS,:BLASTBURN,:BLAZEKICK,:BODYSLAM,:BOUNCE,:BRAVEBIRD,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:CUT,:DEFOG,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:INCINERATE,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OVERHEAT,:POISONJAB,:POWERUPPUNCH,:REVENGE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SOLARBEAM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:THUNDERPUNCH,:UTURN,:VACUUMWAVE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 19,
		:Weight => 520,
		:kind => "Blaze",
		:dexentry => "It learns martial arts that use punches and kicks. Every several years, its old feathers burn off, and new, supple feathers grow back in their place.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [80, 160, 80, 130, 80, 100],
		:Abilities => [:SPEEDBOOST],
		:Weight => 520,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:BLAZIKENITE => 1,
	},
},

:MUDKIP => {
	"Normal Form" => {
		:name => "Mudkip",
		:dexnum => 258,
		:Type1 => :WATER,
		:BaseStats => [50, 70, 50, 50, 50, 40],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:TORRENT, :DAMP],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:BARRIER,:BITE,:COUNTER,:CURSE,:DOUBLEEDGE,:ICEBALL,:MIRRORCOAT,:MUDBOMB,:REFRESH,:SLUDGE,:STOMP,:UPROAR,:WHIRLPOOL,:WIDEGUARD,:YAWN,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[4,:WATERGUN],
			[9,:MUDSLAP],
			[12,:FORESIGHT],
			[17,:BIDE],
			[20,:MUDSPORT],
			[25,:ROCKTHROW],
			[28,:PROTECT],
			[33,:WHIRLPOOL],
			[36,:TAKEDOWN],
			[41,:HYDROPUMP],
			[44,:ENDEAVOR]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BODYSLAM,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:ECHOEDVOICE,:ENDEAVOR,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IRONTAIL,:LOWKICK,:MIMIC,:MUDSLAP,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SCREECH,:SLUDGEWAVE,:STRENGTH,:SUPERPOWER,:SURF,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 4,
		:Weight => 76,
		:kind => "Mud Fish",
		:dexentry => "On land, it can powerfully lift large boulders by planting its four feet and heaving. It sleeps by burying itself in soil at the water's edge.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MARSHTOMP,:Level,16]
		]
	},

	:OnCreation => {},
},

:MARSHTOMP => {
	"Normal Form" => {
		:name => "Marshtomp",
		:dexnum => 259,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [70, 85, 70, 60, 70, 50],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:TORRENT, :DAMP],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MUDKIP,
			:form => 0
		},
		:Moveset => [
			[0,:MUDSHOT],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:WATERGUN],
			[1,:MUDSLAP],
			[4,:WATERGUN],
			[9,:MUDSLAP],
			[12,:FORESIGHT],
			[18,:BIDE],
			[22,:MUDBOMB],
			[28,:ROCKSLIDE],
			[32,:PROTECT],
			[38,:MUDDYWATER],
			[42,:TAKEDOWN],
			[48,:EARTHQUAKE],
			[52,:ENDEAVOR]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FLING,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:POWERUPPUNCH,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDTOMB,:SCALD,:SCREECH,:SEISMICTOSS,:SLUDGEWAVE,:STEALTHROCK,:STRENGTH,:SUPERPOWER,:SURF,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 7,
		:Weight => 280,
		:kind => "Mud Fish",
		:dexentry => "Its toughened hind legs enable it to stand upright. Because it weakens if its skin dries out, it replenishes fluids by playing in mud.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SWAMPERT,:Level,36]
		]
	},

	:OnCreation => {},
},

:SWAMPERT => {
	"Normal Form" => {
		:name => "Swampert",
		:dexnum => 260,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [100, 110, 90, 85, 90, 60],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:TORRENT, :DAMP],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 241,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MARSHTOMP,
			:form => 0
		},
		:Moveset => [
			[1,:MUDSHOT],
			[1,:HAMMERARM],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:WATERGUN],
			[1,:MUDSLAP],
			[4,:WATERGUN],
			[9,:MUDSLAP],
			[12,:FORESIGHT],
			[18,:BIDE],
			[22,:MUDBOMB],
			[28,:ROCKSLIDE],
			[32,:PROTECT],
			[39,:MUDDYWATER],
			[44,:TAKEDOWN],
			[51,:EARTHQUAKE],
			[56,:ENDEAVOR],
			[63,:HAMMERARM]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:COUNTER,:DARKESTLARIAT,:DEFENSECURL,:DIG,:DIVE,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FLING,:FLIPTURN,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HIGHHORSEPOWER,:HYDROCANNON,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LIQUIDATION,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:OUTRAGE,:POWERUPPUNCH,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDTOMB,:SCALD,:SCREECH,:SEISMICTOSS,:SLUDGEWAVE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUPERPOWER,:SURF,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Monster, :Water1],
		:Height => 15,
		:Weight => 819,
		:kind => "Mud Fish",
		:dexentry => "If it senses the approach of a storm and a tidal wave, it protects its seaside nest by piling up boulders. It swims as fast as a jet ski.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [100, 150, 110, 85, 110, 70],
		:Abilities => [:SWIFTSWIM],
		:Height => 19,
		:Weight => 552,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SWAMPERTITE => 1,
	},
},

:POOCHYENA => {
	"Normal Form" => {
		:name => "Poochyena",
		:dexnum => 261,
		:Type1 => :DARK,
		:BaseStats => [35, 55, 35, 30, 30, 35],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:RUNAWAY, :QUICKFEET],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ASTONISH,:COVET,:FIREFANG,:ICEFANG,:LEER,:MEFIRST,:PLAYROUGH,:POISONFANG,:SLEEPTALK,:SNATCH,:SUCKERPUNCH,:THUNDERFANG,:YAWN,],
		:Moveset => [
			[1,:TACKLE],
			[4,:HOWL],
			[7,:SANDATTACK],
			[10,:BITE],
			[13,:ODORSLEUTH],
			[16,:ROAR],
			[19,:SWAGGER],
			[22,:ASSURANCE],
			[25,:SCARYFACE],
			[28,:EMBARGO],
			[31,:TAUNT],
			[34,:CRUNCH],
			[37,:YAWN],
			[40,:TAKEDOWN],
			[43,:SUCKERPUNCH],
			[46,:PLAYROUGH]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:COUNTER,:COVET,:CRUNCH,:DARKPULSE,:DIG,:DOUBLEEDGE,:EMBARGO,:FAKETEARS,:FOULPLAY,:HEADBUTT,:HYPERVOICE,:INCINERATE,:IRONTAIL,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROCKSMASH,:SHADOWBALL,:SNARL,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAUNT,:THIEF,:TORMENT,:UPROAR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWHOLD,],
		:Color => "Gray",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 136,
		:kind => "Bite",
		:dexentry => "It savagely threatens foes with bared fangs. It chases after fleeing targets tenaciously. It turns tail and runs, however, if the foe strikes back.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MIGHTYENA,:Level,18]
		]
	},

	:OnCreation => {},
},

:MIGHTYENA => {
	"Normal Form" => {
		:name => "Mightyena",
		:dexnum => 262,
		:Type1 => :DARK,
		:BaseStats => [70, 90, 70, 60, 60, 70],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :QUICKFEET],
		:HiddenAbilities => :MOXIE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 127,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :POOCHYENA,
			:form => 0
		},
		:Moveset => [
			[0,:SNARL],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:ICEFANG],
			[1,:CRUNCH],
			[1,:THIEF],
			[1,:TACKLE],
			[1,:HOWL],
			[1,:SANDATTACK],
			[1,:BITE],
			[1,:SHADOWSNEAK],
			[4,:HOWL],
			[7,:SANDATTACK],
			[10,:BITE],
			[13,:ODORSLEUTH],
			[16,:ROAR],
			[20,:SWAGGER],
			[24,:ASSURANCE],
			[28,:SCARYFACE],
			[32,:EMBARGO],
			[36,:TAUNT],
			[40,:CRUNCH],
			[44,:YAWN],
			[48,:TAKEDOWN],
			[52,:SUCKERPUNCH],
			[56,:PLAYROUGH]],
		:compatiblemoves => [:AGILITY,:BEATUP,:BODYSLAM,:BURNINGJEALOUSY,:CLOSECOMBAT,:COUNTER,:COVET,:CRUNCH,:DARKPULSE,:DIG,:DOUBLEEDGE,:EMBARGO,:FAKETEARS,:FIREFANG,:FOULPLAY,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:HYPERVOICE,:ICEFANG,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LASHOUT,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROCKSMASH,:SCARYFACE,:SHADOWCLAW,:SHADOWBALL,:SNARL,:SNATCH,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAUNT,:THIEF,:THROATCHOP,:THUNDERFANG,:TORMENT,:UPROAR,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 370,
		:kind => "Bite",
		:dexentry => "In the wild, Mightyena live in a pack. They never defy their leader's orders. They defeat foes with perfectly coordinated teamwork.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :GHOST,
		:BaseStats => [70, 125, 70, 60, 70, 125],
		:Abilities => [:DARKSURGE],
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:MIGHTYENITE => 1
	},
},

:ZIGZAGOON => {
	"Normal Form" => {
		:name => "Zigzagoon",
		:dexnum => 263,
		:Type1 => :NORMAL,
		:BaseStats => [38, 30, 41, 30, 41, 60],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:PICKUP, :GLUTTONY],
		:HiddenAbilities => :QUICKFEET,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:CHARM,:EXTREMESPEED,:HELPINGHAND,:MUDSLAP,:PURSUIT,:ROCKCLIMB,:SIMPLEBEAM,:SLEEPTALK,:TICKLE,:TRICK,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[5,:TAILWHIP],
			[7,:SANDATTACK],
			[11,:HEADBUTT],
			[12,:BABYDOLLEYES],
			[13,:ODORSLEUTH],
			[17,:MUDSPORT],
			[19,:PINMISSILE],
			[23,:COVET],
			[25,:BESTOW],
			[29,:FLAIL],
			[31,:TAKEDOWN],
			[35,:REST],
			[37,:BELLYDRUM],
			[41,:FLING]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:CHARGEBEAM,:CHARM,:COVET,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FLING,:FURYCUTTER,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:MIMIC,:MUDSHOT,:MUDSLAP,:PINMISSILE,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROLLOUT,:SEEDBOMB,:SHADOWBALL,:SHOCKWAVE,:SUNNYDAY,:SUPERFANG,:SURF,:SWIFT,:TAILSLAP,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 175,
		:WildItemCommon => :POTION,
		:WildItemUncommon => :REVIVE,
		:kind => "TinyRaccoon",
		:dexentry => "Rubbing its nose against the ground, it always wanders about back and forth in search of something. It is distinguished by the zigzag footprints it leaves.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LINOONE,:Level,20]
		]
	},

	"Galarian Form" => {
		:Type1 => :DARK,
		:Type2 => :NORMAL,
		:EggMoves => [:KNOCKOFF,:PARTINGSHOT,:QUICKGUARD,],
		:Moveset => [
			[1,:LEER],
			[1,:TACKLE],
			[3,:SANDATTACK],
			[6,:LICK],
			[9,:SNARL],
			[12,:HEADBUTT],
			[15,:BABYDOLLEYES],
			[18,:PINMISSILE],
			[21,:REST],
			[24,:TAKEDOWN],
			[27,:SCARYFACE],
			[30,:COUNTER],
			[33,:TAUNT],
			[36,:DOUBLEEDGE],
		],
		:compatiblemoves => [:ASSURANCE,:BLIZZARD,:BODYSLAM,:COUNTER,:DIG,:DOUBLEEDGE,:FAKETEARS,:FLING,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASHOUT,:MUDSHOT,:PAYBACK,:PINMISSILE,:RAINDANCE,:RETALIATE,:SCARYFACE,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SNARL,:SUNNYDAY,:SURF,:SWIFT,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:dexentry => "Thought to be the oldest form of Zigzagoon, it moves in zigzags and wreaks havoc upon its surroundings.",
	},

	:OnCreation => proc {
 # Map IDs for galarian form
 next $game_map && Zigzagoon.include?($game_map.map_id) ? 1 : 0
 },
},

:LINOONE => {
	"Normal Form" => {
		:name => "Linoone",
		:dexnum => 264,
		:Type1 => :NORMAL,
		:BaseStats => [78, 70, 61, 50, 61, 100],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:PICKUP, :GLUTTONY],
		:HiddenAbilities => :QUICKFEET,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :ZIGZAGOON,
			:form => 0
		},
		:Moveset => [
			[1,:PLAYROUGH],
			[1,:ROTOTILLER],
			[1,:SWITCHEROO],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:TAILWHIP],
			[1,:SANDATTACK],
			[5,:TAILWHIP],
			[7,:SANDATTACK],
			[11,:HEADBUTT],
			[13,:ODORSLEUTH],
			[17,:MUDSPORT],
			[19,:FURYSWIPES],
			[24,:COVET],
			[27,:BESTOW],
			[32,:SLASH],
			[35,:DOUBLEEDGE],
			[40,:REST],
			[43,:BELLYDRUM],
			[48,:FLING]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:CHARGEBEAM,:CHARM,:COVET,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FLING,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:MIMIC,:MUDSHOT,:MUDSLAP,:PINMISSILE,:PLAYROUGH,:RAINDANCE,:RETALIATE,:ROAR,:ROCKSMASH,:ROLLOUT,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERFANG,:SURF,:SWIFT,:TAILSLAP,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 325,
		:WildItemCommon => :POTION,
		:WildItemUncommon => :MAXREVIVE,
		:kind => "Rushing",
		:dexentry => "It is exceedingly fast if it only has to run in a straight line. When it spots prey underwater, it leaps in and catches it with its sharp claws.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	"Galarian Form" => {
		:Type1 => :DARK,
		:Type2 => :NORMAL,
		:preevo => {
			:species => :ZIGZAGOON,
			:form => 1
		},
		:Moveset => [
			[0,:NIGHTSLASH],
			[1,:BABYDOLLEYES],
			[1,:PINMISSILE],
			[1,:LEER],
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:LICK],
			[1,:SWITCHEROO],
			[9,:SNARL],
			[12,:HEADBUTT],
			[15,:HONECLAWS],
			[18,:FURYSWIPES],
			[23,:REST],
			[28,:TAKEDOWN],
			[33,:SCARYFACE],
			[38,:COUNTER],
			[43,:TAUNT],
			[48,:DOUBLEEDGE],
		],
		:compatiblemoves => [:ASSURANCE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:COUNTER,:DIG,:DOUBLEEDGE,:FAKETEARS,:FLING,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASHOUT,:MUDSHOT,:PAYBACK,:PINMISSILE,:RAINDANCE,:RETALIATE,:SCARYFACE,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SNARL,:STOMPINGTANTRUM,:SUNNYDAY,:SURF,:SWIFT,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:dexentry => "This very aggressive Pokémon will recklessly challenge opponents stronger than itself.",
		:evolutions => [
			[:OBSTAGOON,:LevelNight,35]
		]
	},

	:OnCreation => proc {
 # Map IDs for galarian form
 next $game_map && Zigzagoon.include?($game_map.map_id) ? 1 : 0
 },
},

:WURMPLE => {
	"Normal Form" => {
		:name => "Wurmple",
		:dexnum => 265,
		:Type1 => :BUG,
		:BaseStats => [45, 45, 35, 20, 30, 20],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SHIELDDUST, :RUNAWAY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:TACKLE],
			[1,:STRINGSHOT],
			[5,:POISONSTING],
			[15,:BUGBITE]],
		:compatiblemoves => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Red",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 3,
		:Weight => 36,
		:WildItemCommon => :PECHABERRY,
		:WildItemUncommon => :BRIGHTPOWDER,
		:kind => "Worm",
		:dexentry => "It sticks to tree branches and eats leaves. The thread it spits from its mouth slows the movement of its foes.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SILCOON,:Silcoon,7],
			[:CASCOON,:Cascoon,7]
		]
	},

	:OnCreation => {},
},

:SILCOON => {
	"Normal Form" => {
		:name => "Silcoon",
		:dexnum => 266,
		:Type1 => :BUG,
		:BaseStats => [50, 35, 55, 25, 25, 15],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :OVERCOAT],	# Overcoat added so the ability index is maintained on evolution, don't worry about it  - Fal
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 72,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :WURMPLE,
			:form => 0
		},
		:Moveset => [
			[0,:HARDEN]],
		:compatiblemoves => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "White",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 6,
		:Weight => 100,
		:kind => "Cocoon",
		:dexentry => "It prepares for evolution using the energy it stored while it was a Wurmple. It keeps watch over the surroundings with its two eyes.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 33,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BEAUTIFLY,:Level,10]
		]
	},

	:OnCreation => {},
},

:BEAUTIFLY => {
	"Normal Form" => {
		:name => "Beautifly",
		:dexnum => 267,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [60, 70, 50, 100, 50, 65],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:SWARM, :RIVALRY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 178,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SILCOON,
			:form => 0
		},
		:Moveset => [
			[0,:GUST],
			[12,:ABSORB],
			[15,:STUNSPORE],
			[17,:MORNINGSUN],
			[20,:AIRCUTTER],
			[22,:MEGADRAIN],
			[25,:SILVERWIND],
			[27,:ATTRACT],
			[30,:WHIRLWIND],
			[32,:GIGADRAIN],
			[35,:BUGBUZZ],
			[37,:RAGE],
			[40,:QUIVERDANCE]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:AIRSLASH,:BUGBITE,:BUGBUZZ,:CHARM,:DEFOG,:DOUBLEEDGE,:DRAININGKISS,:DUALWINGBEAT,:ELECTROWEB,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:HURRICANE,:HYPERBEAM,:IMPRISON,:INFESTATION,:LASERFOCUS,:LEECHLIFE,:MAGICALLEAF,:MIMIC,:OMINOUSWIND,:POLLENPUFF,:PSYCHIC,:ROOST,:SAFEGUARD,:SHADOWBALL,:SIGNALBEAM,:SILVERWIND,:SKITTERSMACK,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UTURN,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 10,
		:Weight => 284,
		:WildItemUncommon => :SHEDSHELL,
		:kind => "Butterfly",
		:dexentry => "Its colorfully patterned wings are its most striking feature. It flies through flower-covered fields collecting pollen. It attacks ferociously when angered.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 17,
	},

	:OnCreation => {},
},

:CASCOON => {
	"Normal Form" => {
		:name => "Cascoon",
		:dexnum => 268,
		:Type1 => :BUG,
		:BaseStats => [50, 35, 55, 25, 25, 15],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :OVERCOAT],	# Overcoat added so the ability index is maintained on evolution, don't worry about it  - Fal
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 72,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :WURMPLE,
			:form => 0
		},
		:Moveset => [
			[0,:HARDEN]],
		:compatiblemoves => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 7,
		:Weight => 115,
		:kind => "Cocoon",
		:dexentry => "To avoid detection by its enemies, it hides beneath large leaves and in the gaps of branches. It also attaches dead leaves to its body for camouflage.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DUSTOX,:Level,10]
		]
	},

	:OnCreation => {},
},

:DUSTOX => {
	"Normal Form" => {
		:name => "Dustox",
		:dexnum => 269,
		:Type1 => :BUG,
		:Type2 => :POISON,
		:BaseStats => [60, 50, 70, 50, 90, 65],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:SHIELDDUST, :COMPOUNDEYES],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :CASCOON,
			:form => 0
		},
		:Moveset => [
			[0,:GUST],
			[12,:CONFUSION],
			[15,:POISONPOWDER],
			[17,:MOONLIGHT],
			[20,:VENOSHOCK],
			[22,:PSYBEAM],
			[25,:SILVERWIND],
			[27,:LIGHTSCREEN],
			[30,:WHIRLWIND],
			[32,:TOXIC],
			[35,:BUGBUZZ],
			[37,:PROTECT],
			[40,:QUIVERDANCE]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:AIRSLASH,:BUGBITE,:BUGBUZZ,:CORROSIVEGAS,:CROSSPOISON,:DEFOG,:DOUBLEEDGE,:DUALWINGBEAT,:ELECTROWEB,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:HEX,:HURRICANE,:HYPERBEAM,:INFESTATION,:LASERFOCUS,:LEECHLIFE,:LIGHTSCREEN,:MIMIC,:NASTYPLOT,:OMINOUSWIND,:PSYCHIC,:ROOST,:SCALESHOT,:SCARYFACE,:SHADOWBALL,:SIGNALBEAM,:SILVERWIND,:SKITTERSMACK,:SLUDGEBOMB,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UTURN,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 12,
		:Weight => 316,
		:WildItemUncommon => :SHEDSHELL,
		:kind => "Poison Moth",
		:dexentry => "It is a nocturnal Pokémon that flies from fields and mountains to the attraction of streetlights at night. It looses highly toxic powder from its wings.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 15,
	},

	:OnCreation => {},
},

:LOTAD => {
	"Normal Form" => {
		:name => "Lotad",
		:dexnum => 270,
		:Type1 => :WATER,
		:Type2 => :GRASS,
		:BaseStats => [40, 30, 30, 40, 50, 30],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SWIFTSWIM, :RAINDISH],
		:HiddenAbilities => :OWNTEMPO,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 44,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:COUNTER,:FLAIL,:GIGADRAIN,:LEECHSEED,:RAZORLEAF,:SWEETSCENT,:SYNTHESIS,:TEETERDANCE,:TICKLE,:WATERGUN,],
		:Moveset => [
			[1,:ASTONISH],
			[3,:GROWL],
			[6,:ABSORB],
			[9,:BUBBLE],
			[12,:NATURALGIFT],
			[15,:MIST],
			[18,:MEGADRAIN],
			[21,:BUBBLEBEAM],
			[24,:NATUREPOWER],
			[27,:RAINDANCE],
			[30,:GIGADRAIN],
			[33,:ZENHEADBUTT],
			[36,:ENERGYBALL]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BULLETSEED,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:HAIL,:HEADBUTT,:ICEBEAM,:ICYWIND,:MIMIC,:NATUREPOWER,:RAINDANCE,:SCALD,:SEEDBOMB,:SOLARBEAM,:SUNNYDAY,:SURF,:SWORDSDANCE,:SYNTHESIS,:THIEF,:UPROAR,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Grass],
		:Height => 5,
		:Weight => 26,
		:WildItemUncommon => :MENTALHERB,
		:kind => "Water Weed",
		:dexentry => "This Pokémon lives in ponds with clean water. It is known to ferry small Pokémon across ponds by carrying them on the broad leaf on its head.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LOMBRE,:Level,14]
		]
	},

	:OnCreation => {},
},

:LOMBRE => {
	"Normal Form" => {
		:name => "Lombre",
		:dexnum => 271,
		:Type1 => :WATER,
		:Type2 => :GRASS,
		:BaseStats => [60, 50, 50, 60, 70, 50],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SWIFTSWIM, :RAINDISH],
		:HiddenAbilities => :OWNTEMPO,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 119,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :LOTAD,
			:form => 0
		},
		:Moveset => [
			[1,:ASTONISH],
			[3,:GROWL],
			[6,:ABSORB],
			[9,:BUBBLE],
			[12,:FURYSWIPES],
			[16,:FAKEOUT],
			[20,:WATERSPORT],
			[24,:BUBBLEBEAM],
			[28,:NATUREPOWER],
			[32,:UPROAR],
			[36,:KNOCKOFF],
			[40,:ZENHEADBUTT],
			[44,:HYDROPUMP]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:DIVE,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ECHOEDVOICE,:ENERGYBALL,:FIREPUNCH,:FLASH,:FLING,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:KNOCKOFF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:SCALD,:SEEDBOMB,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SURF,:SWORDSDANCE,:SYNTHESIS,:THIEF,:THUNDERPUNCH,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Grass],
		:Height => 12,
		:Weight => 325,
		:WildItemUncommon => :MENTALHERB,
		:kind => "Jolly",
		:dexentry => "In the evening, it takes great delight in popping out of rivers and startling people. It feeds on aquatic moss that grows on rocks in the riverbed.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LUDICOLO,:Item,:WATERSTONE]
		]
	},

	:OnCreation => {},
},

:LUDICOLO => {
	"Normal Form" => {
		:name => "Ludicolo",
		:dexnum => 272,
		:Type1 => :WATER,
		:Type2 => :GRASS,
		:BaseStats => [80, 70, 70, 90, 100, 70],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:SWIFTSWIM, :RAINDISH],
		:HiddenAbilities => :OWNTEMPO,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 216,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :LOMBRE,
			:form => 0
		},
		:Moveset => [
			[1,:ASTONISH],
			[1,:GROWL],
			[1,:MEGADRAIN],
			[1,:NATUREPOWER]],
		:compatiblemoves => [:AMNESIA,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:COUNTER,:DIVE,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ECHOEDVOICE,:ENCORE,:ENERGYBALL,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:KNOCKOFF,:LEAFSTORM,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:SCALD,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SURF,:SWORDSDANCE,:SYNTHESIS,:THIEF,:THUNDERPUNCH,:UPROAR,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Grass],
		:Height => 15,
		:Weight => 550,
		:WildItemUncommon => :MENTALHERB,
		:kind => "Carefree",
		:dexentry => "When it hears festive music, all its cells become stimulated, and it begins moving in rhythm. It does not quail even when it faces a tough opponent.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SEEDOT => {
	"Normal Form" => {
		:name => "Seedot",
		:dexnum => 273,
		:Type1 => :GRASS,
		:BaseStats => [40, 40, 50, 30, 30, 30],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :EARLYBIRD],
		:HiddenAbilities => :PICKPOCKET,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 44,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AMNESIA,:BEATUP,:BULLETSEED,:DEFOG,:FOULPLAY,:GRASSYTERRAIN,:LEECHSEED,:NASTYPLOT,:POWERSWAP,:QUICKATTACK,:RAZORWIND,:TAKEDOWN,:WORRYSEED,],
		:Moveset => [
			[1,:BIDE],
			[3,:HARDEN],
			[9,:GROWTH],
			[15,:NATUREPOWER],
			[21,:SYNTHESIS],
			[27,:SUNNYDAY],
			[33,:EXPLOSION]],
		:compatiblemoves => [:AMNESIA,:BEATUP,:BODYSLAM,:BULLETSEED,:DEFENSECURL,:DEFOG,:DIG,:DOUBLEEDGE,:ENERGYBALL,:EXPLOSION,:FALSESWIPE,:FLASH,:FOULPLAY,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:MIMIC,:NASTYPLOT,:NATUREPOWER,:PAYBACK,:POWERSWAP,:RETALIATE,:ROCKSMASH,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SOLARBEAM,:SPITE,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORRYSEED,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWHOLD,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Grass],
		:Height => 5,
		:Weight => 40,
		:WildItemUncommon => :POWERHERB,
		:kind => "Acorn",
		:dexentry => "It hangs off branches and absorbs nutrients. When it finishes eating, its body becomes so heavy that it drops to the ground with a thump.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NUZLEAF,:Level,14]
		]
	},

	:OnCreation => {},
},

:NUZLEAF => {
	"Normal Form" => {
		:name => "Nuzleaf",
		:dexnum => 274,
		:Type1 => :GRASS,
		:Type2 => :DARK,
		:BaseStats => [70, 70, 40, 60, 40, 60],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :EARLYBIRD],
		:HiddenAbilities => :PICKPOCKET,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 119,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SEEDOT,
			:form => 0
		},
		:Moveset => [
			[0,:RAZORLEAF],
			[1,:POUND],
			[3,:HARDEN],
			[6,:GROWTH],
			[12,:FAKEOUT],
			[16,:NATUREPOWER],
			[20,:RAZORWIND],
			[24,:FEINTATTACK],
			[28,:LEAFBLADE],
			[32,:SWAGGER],
			[36,:EXTRASENSORY]],
		:compatiblemoves => [:AMNESIA,:ASSURANCE,:BEATUP,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:CUT,:DARKPULSE,:DEFENSECURL,:DEFOG,:DIG,:DOUBLEEDGE,:EMBARGO,:ENERGYBALL,:EXPLOSION,:FALSESWIPE,:FLASH,:FLING,:FOULPLAY,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:LASHOUT,:LEAFBLADE,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MIMIC,:MUDSLAP,:NASTYPLOT,:NATUREPOWER,:PAYBACK,:POWERSWAP,:POWERUPPUNCH,:PSYCHUP,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SNARL,:SOLARBEAM,:SOLARBLADE,:SPITE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:THIEF,:TORMENT,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Grass],
		:Height => 10,
		:Weight => 280,
		:WildItemUncommon => :POWERHERB,
		:kind => "Wily",
		:dexentry => "A forest-dwelling Pokémon that is skilled at climbing trees. Its long and pointed nose is its weak point. It loses power if the nose is gripped.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SHIFTRY,:Item,:LEAFSTONE]
		]
	},

	:OnCreation => {},
},

:SHIFTRY => {
	"Normal Form" => {
		:name => "Shiftry",
		:dexnum => 275,
		:Type1 => :GRASS,
		:Type2 => :DARK,
		:BaseStats => [90, 100, 60, 90, 60, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :EARLYBIRD],
		:HiddenAbilities => :PICKPOCKET,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 216,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :NUZLEAF,
			:form => 0
		},
		:Moveset => [
			[1,:RAZORLEAF],
			[1,:FEINTATTACK],
			[1,:WHIRLWIND],
			[1,:NASTYPLOT],
			[20,:LEAFTORNADO],
			[32,:HURRICANE],
			[44,:LEAFSTORM]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:AMNESIA,:ASSURANCE,:BEATUP,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BRUTALSWING,:BULLETSEED,:CUT,:DARKPULSE,:DEFENSECURL,:DEFOG,:DIG,:DOUBLEEDGE,:EMBARGO,:ENERGYBALL,:EXPLOSION,:FALSESWIPE,:FLASH,:FLING,:FOCUSBLAST,:FOULPLAY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:ICYWIND,:KNOCKOFF,:LASHOUT,:LEAFBLADE,:LEAFSTORM,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MIMIC,:MUDSLAP,:NASTYPLOT,:NATUREPOWER,:OMINOUSWIND,:PAYBACK,:POWERSWAP,:POWERUPPUNCH,:PSYCHUP,:RETALIATE,:REVENGE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCREECH,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SNARL,:SOLARBEAM,:SOLARBLADE,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:TAILWIND,:THIEF,:THROATCHOP,:TORMENT,:TWISTER,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Grass],
		:Height => 13,
		:Weight => 596,
		:WildItemUncommon => :POWERHERB,
		:kind => "Wicked",
		:dexentry => "It is said to arrive on chilly, wintry winds. Feared from long ago as the guardian of forests, this Pokémon lives in a deep forest without people.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TAILLOW => {
	"Normal Form" => {
		:name => "Taillow",
		:dexnum => 276,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [40, 55, 30, 30, 30, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:GUTS, :SCRAPPY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 54,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BOOMBURST,:BRAVEBIRD,:DEFOG,:HURRICANE,:MIRRORMOVE,:PURSUIT,:RAGE,:REFRESH,:ROOST,:SKYATTACK,:STEELWING,:SUPERSONIC,:WHIRLWIND,],
		:Moveset => [
			[1,:PECK],
			[1,:GROWL],
			[5,:FOCUSENERGY],
			[9,:QUICKATTACK],
			[13,:WINGATTACK],
			[17,:DOUBLETEAM],
			[21,:AERIALACE],
			[25,:QUICKGUARD],
			[29,:AGILITY],
			[33,:AIRSLASH],
			[37,:ENDEAVOR],
			[41,:BRAVEBIRD],
			[45,:REVERSAL]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:AIRSLASH,:BRAVEBIRD,:COUNTER,:DEFOG,:DOUBLEEDGE,:ECHOEDVOICE,:ENDEAVOR,:FLY,:FOCUSENERGY,:HEATWAVE,:HURRICANE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAINDANCE,:REVERSAL,:ROOST,:SCREECH,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Flying],
		:Height => 3,
		:Weight => 23,
		:kind => "TinySwallow",
		:dexentry => "Although it is small, it is very courageous. It will take on a larger Skarmory on an equal footing. However, its will weakens if it becomes hungry.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 20,
		:evolutions => [
			[:SWELLOW,:Level,22]
		]
	},

	:OnCreation => {},
},

:SWELLOW => {
	"Normal Form" => {
		:name => "Swellow",
		:dexnum => 277,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [60, 85, 60, 75, 50, 125],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:GUTS, :SCRAPPY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :TAILLOW,
			:form => 0
		},
		:Moveset => [
			[1,:BRAVEBIRD],
			[1,:AIRSLASH],
			[1,:PLUCK],
			[1,:PECK],
			[1,:GROWL],
			[1,:FOCUSENERGY],
			[1,:QUICKATTACK],
			[5,:FOCUSENERGY],
			[9,:QUICKATTACK],
			[13,:WINGATTACK],
			[17,:DOUBLETEAM],
			[21,:AERIALACE],
			[27,:QUICKGUARD],
			[33,:AGILITY],
			[39,:AIRSLASH],
			[45,:ENDEAVOR],
			[51,:BRAVEBIRD],
			[57,:REVERSAL]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:AIRSLASH,:BRAVEBIRD,:COUNTER,:DEFOG,:DOUBLEEDGE,:DUALWINGBEAT,:ECHOEDVOICE,:ENDEAVOR,:FLY,:FOCUSENERGY,:GIGAIMPACT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:LASERFOCUS,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAINDANCE,:REVERSAL,:ROOST,:SCREECH,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TRIPLEAXEL,:TWISTER,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBREAK,:SHADOWMIST,:SHADOWHALF,:SHADOWSKY,],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Flying],
		:Height => 7,
		:Weight => 198,
		:kind => "Swallow",
		:dexentry => "A Swellow dives upon prey from far above. It never misses its targets. It takes to the skies in search of lands with a warm climate.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:WINGULL => {
	"Normal Form" => {
		:name => "Wingull",
		:dexnum => 278,
		:Type1 => :WATER,
		:Type2 => :FLYING,
		:BaseStats => [40, 30, 30, 55, 30, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:KEENEYE, :HYDRATION],
		:HiddenAbilities => :RAINDISH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 54,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:AQUARING,:BRINE,:GUST,:KNOCKOFF,:MIST,:ROOST,:SOAK,:TWISTER,:WATERSPORT,:WIDEGUARD,],
		:Moveset => [
			[1,:GROWL],
			[1,:WATERGUN],
			[5,:SUPERSONIC],
			[8,:WINGATTACK],
			[12,:MIST],
			[15,:WATERPULSE],
			[19,:QUICKATTACK],
			[22,:AIRCUTTER],
			[26,:PURSUIT],
			[29,:AERIALACE],
			[33,:ROOST],
			[36,:AGILITY],
			[40,:AIRSLASH],
			[43,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BLIZZARD,:BRINE,:DEFOG,:DOUBLEEDGE,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:HAIL,:HURRICANE,:ICEBEAM,:ICYWIND,:KNOCKOFF,:LIQUIDATION,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PLUCK,:RAINDANCE,:ROOST,:SCALD,:SHOCKWAVE,:SKYATTACK,:STEELWING,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:UTURN,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Flying],
		:Height => 6,
		:Weight => 95,
		:WildItemCommon => :PRETTYWING,
		:kind => "Seagull",
		:dexentry => "It makes its nest on a sheer cliff at the edge of the sea. It has trouble keeping its wings flapping in flight. Instead, it soars on updrafts.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 18,
		:evolutions => [
			[:PELIPPER,:Level,25]
		]
	},

	:OnCreation => {},
},

:PELIPPER => {
	"Normal Form" => {
		:name => "Pelipper",
		:dexnum => 279,
		:Type1 => :WATER,
		:Type2 => :FLYING,
		:BaseStats => [60, 50, 100, 95, 70, 65],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:KEENEYE, :DRIZZLE],
		:HiddenAbilities => :RAINDISH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 154,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WINGULL,
			:form => 0
		},
		:Moveset => [
			[0,:PROTECT],
			[1,:HURRICANE],
			[1,:HYDROPUMP],
			[1,:TAILWIND],
			[1,:SOAK],
			[1,:GROWL],
			[1,:WATERGUN],
			[1,:WATERSPORT],
			[1,:WINGATTACK],
			[5,:SUPERSONIC],
			[8,:WINGATTACK],
			[12,:MIST],
			[15,:WATERPULSE],
			[19,:PAYBACK],
			[22,:BRINE],
			[28,:FLING],
			[33,:STOCKPILE],
			[33,:SWALLOW],
			[33,:SPITUP],
			[39,:ROOST],
			[44,:TAILWIND],
			[50,:HYDROPUMP],
			[55,:HURRICANE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BLIZZARD,:BRAVEBIRD,:BRINE,:DEFOG,:DOUBLEEDGE,:DUALWINGBEAT,:ECHOEDVOICE,:FLING,:FLY,:GIGAIMPACT,:GUNKSHOT,:HAIL,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:KNOCKOFF,:LIQUIDATION,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PAYBACK,:PLUCK,:RAINDANCE,:ROOST,:SCALD,:SEEDBOMB,:SHOCKWAVE,:SKYATTACK,:SKYDROP,:STEELWING,:SURF,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:UTURN,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Flying],
		:Height => 12,
		:Weight => 280,
		:WildItemCommon => :PRETTYWING,
		:kind => "Water Bird",
		:dexentry => "It skims the tops of waves as it flies. When it spots prey, it uses its large beak to scoop up the victim with water. It protects its eggs in its beak.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:RALTS => {
	"Normal Form" => {
		:name => "Ralts",
		:dexnum => 280,
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:BaseStats => [28, 25, 25, 45, 35, 40],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:SYNCHRONIZE, :TRACE],
		:HiddenAbilities => :TELEPATHY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 40,
		:CatchRate => 235,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:ALLYSWITCH,:CONFUSERAY,:DESTINYBOND,:DISABLE,:ENCORE,:GRUDGE,:MEANLOOK,:MEMENTO,:MISTYTERRAIN,:SHADOWSNEAK,:SKILLSWAP,:SYNCHRONOISE,],
		:Moveset => [
			[1,:GROWL],
			[4,:CONFUSION],
			[6,:DOUBLETEAM],
			[9,:TELEPORT],
			[11,:DISARMINGVOICE],
			[14,:LUCKYCHANT],
			[17,:MAGICALLEAF],
			[19,:HEALPULSE],
			[22,:DRAININGKISS],
			[24,:CALMMIND],
			[27,:PSYCHIC],
			[29,:IMPRISON],
			[32,:FUTURESIGHT],
			[34,:CHARM],
			[37,:HYPNOSIS],
			[39,:DREAMEATER],
			[42,:STOREDPOWER]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FUTURESIGHT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:ICEPUNCH,:ICYWIND,:IMPRISON,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYTERRAIN,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WILLOWISP,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWHOLD,],
		:Color => "White",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 4,
		:Weight => 66,
		:kind => "Feeling",
		:dexentry => "A Ralts has the power to sense the emotions of people and Pokémon with the horns on its head. It takes cover if it senses any hostility.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KIRLIA,:Level,20]
		]
	},

	:OnCreation => {},
},

:KIRLIA => {
	"Normal Form" => {
		:name => "Kirlia",
		:dexnum => 281,
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:BaseStats => [38, 35, 35, 65, 55, 50],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SYNCHRONIZE, :TRACE],
		:HiddenAbilities => :TELEPATHY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 97,
		:CatchRate => 120,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :RALTS,
			:form => 0
		},
		:Moveset => [
			[1,:GROWL],
			[1,:CONFUSION],
			[1,:DOUBLETEAM],
			[1,:TELEPORT],
			[4,:CONFUSION],
			[6,:DOUBLETEAM],
			[9,:TELEPORT],
			[11,:DISARMINGVOICE],
			[14,:LUCKYCHANT],
			[17,:MAGICALLEAF],
			[19,:HEALPULSE],
			[23,:DRAININGKISS],
			[26,:CALMMIND],
			[30,:PSYCHIC],
			[33,:IMPRISON],
			[37,:FUTURESIGHT],
			[40,:CHARM],
			[44,:HYPNOSIS],
			[47,:DREAMEATER],
			[51,:STOREDPOWER]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FUTURESIGHT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:ICEPUNCH,:ICYWIND,:IMPRISON,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYTERRAIN,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:TRIPLEAXEL,:WILLOWISP,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 8,
		:Weight => 202,
		:kind => "Emotion",
		:dexentry => "A Kirlia has the psychic power to create a rip in the dimensions and see into the future. It is said to dance with pleasure on sunny mornings.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GARDEVOIR,:Level,30],
			[:GALLADE,:ItemMale,:DAWNSTONE]
		]
	},

	:OnCreation => {},
},

:GARDEVOIR => {
	"Normal Form" => {
		:name => "Gardevoir",
		:dexnum => 282,
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:BaseStats => [68, 65, 65, 125, 115, 80],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:SYNCHRONIZE, :TRACE],
		:HiddenAbilities => :TELEPATHY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 233,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :KIRLIA,
			:form => 0
		},
		:Moveset => [
			[1,:MOONBLAST],
			[1,:STOREDPOWER],
			[1,:MISTYTERRAIN],
			[1,:HEALINGWISH],
			[1,:GROWL],
			[1,:CONFUSION],
			[1,:DOUBLETEAM],
			[1,:TELEPORT],
			[4,:CONFUSION],
			[6,:DOUBLETEAM],
			[9,:TELEPORT],
			[11,:DISARMINGVOICE],
			[14,:WISH],
			[17,:MAGICALLEAF],
			[19,:HEALPULSE],
			[23,:DRAININGKISS],
			[26,:CALMMIND],
			[31,:PSYCHIC],
			[35,:IMPRISON],
			[40,:FUTURESIGHT],
			[44,:CAPTIVATE],
			[49,:HYPNOSIS],
			[53,:DREAMEATER],
			[58,:STOREDPOWER],
			[62,:MOONBLAST]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEPUNCH,:ICYWIND,:IMPRISON,:LASERFOCUS,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYEXPLOSION,:MISTYTERRAIN,:MUDSLAP,:MYSTICALFIRE,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:TRIPLEAXEL,:WILLOWISP,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 16,
		:Weight => 484,
		:kind => "Embrace",
		:dexentry => "It apparently does not feel the pull of gravity because it supports itself with psychic power. It will give its life to protect its Trainer.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [68, 85, 65, 165, 135, 100],
		:Abilities => [:PIXILATE],
		:Weight => 484,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GARDEVOIRITE => 1,
	},
},

:SURSKIT => {
	"Normal Form" => {
		:name => "Surskit",
		:dexnum => 283,
		:Type1 => :BUG,
		:Type2 => :WATER,
		:BaseStats => [40, 30, 32, 50, 52, 65],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :RAINDISH],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 54,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AQUAJET,:BUGBITE,:ENDURE,:FELLSTINGER,:FORESIGHT,:HYDROPUMP,:MINDREADER,:MUDSHOT,:POWERSPLIT,:PSYBEAM,:SIGNALBEAM,],
		:Moveset => [
			[1,:BUBBLE],
			[6,:QUICKATTACK],
			[9,:SWEETSCENT],
			[14,:WATERSPORT],
			[17,:BUBBLEBEAM],
			[22,:AGILITY],
			[25,:MIST],
			[25,:HAZE],
			[30,:AQUAJET],
			[35,:BATONPASS],
			[38,:STICKYWEB]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BLIZZARD,:BUGBITE,:DOUBLEEDGE,:FLASH,:FLIPTURN,:GIGADRAIN,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INFESTATION,:LIQUIDATION,:MIMIC,:MUDSHOT,:MUDSLAP,:PSYCHUP,:RAINDANCE,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:THIEF,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Bug],
		:Height => 5,
		:Weight => 17,
		:WildItemCommon => :HONEY,
		:kind => "Pond Skater",
		:dexentry => "They gather on puddles after evening downpours, gliding across the surface of water as if sliding. It secretes honey with a sweet aroma from its head.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MASQUERAIN,:Level,22]
		]
	},

	:OnCreation => {},
},

:MASQUERAIN => {
	"Normal Form" => {
		:name => "Masquerain",
		:dexnum => 284,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [70, 60, 62, 100, 82, 80],
		:EVs => [0, 0, 0, 1, 1, 0],
		:Abilities => [:INTIMIDATE, :UNNERVE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SURSKIT,
			:form => 0
		},
		:Moveset => [
			[1,:QUIVERDANCE],
			[1,:WHIRLWIND],
			[1,:BUGBUZZ],
			[1,:OMINOUSWIND],
			[1,:BUBBLE],
			[1,:QUICKATTACK],
			[1,:SWEETSCENT],
			[1,:WATERSPORT],
			[6,:QUICKATTACK],
			[9,:SWEETSCENT],
			[14,:WATERSPORT],
			[17,:GUST],
			[22,:SCARYFACE],
			[22,:AIRCUTTER],
			[26,:STUNSPORE],
			[32,:SILVERWIND],
			[38,:AIRSLASH],
			[42,:BUGBUZZ],
			[48,:WHIRLWIND],
			[52,:QUIVERDANCE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BATONPASS,:BLIZZARD,:BUGBITE,:BUGBUZZ,:DEFOG,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:FLIPTURN,:GIGADRAIN,:GIGAIMPACT,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INFESTATION,:LIQUIDATION,:MIMIC,:MUDSHOT,:MUDSLAP,:NIGHTMARE,:OMINOUSWIND,:PSYCHUP,:RAINDANCE,:ROOST,:SCALD,:SCARYFACE,:SHADOWBALL,:SIGNALBEAM,:SILVERWIND,:SKITTERSMACK,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UTURN,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Bug],
		:Height => 8,
		:Weight => 36,
		:WildItemUncommon => :SILVERPOWDER,
		:kind => "Eyeball",
		:dexentry => "It intimidates foes with the eyelike patterns on its antennae. Since it can't fly with wet wings, it shelters itself from rain under large trees and eaves.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 9,
	},

	:OnCreation => {},
},

:SHROOMISH => {
	"Normal Form" => {
		:name => "Shroomish",
		:dexnum => 285,
		:Type1 => :GRASS,
		:BaseStats => [60, 40, 60, 40, 60, 35],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:EFFECTSPORE, :POISONHEAL],
		:HiddenAbilities => :QUICKFEET,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 59,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BULLETSEED,:CHARM,:DRAINPUNCH,:FAKETEARS,:FOCUSPUNCH,:HELPINGHAND,:NATURALGIFT,:SEEDBOMB,:WAKEUPSLAP,:WORRYSEED,],
		:Moveset => [
			[1,:ABSORB],
			[1,:TACKLE],
			[5,:STUNSPORE],
			[8,:LEECHSEED],
			[12,:MEGADRAIN],
			[15,:HEADBUTT],
			[19,:POISONPOWDER],
			[22,:WORRYSEED],
			[26,:GIGADRAIN],
			[29,:GROWTH],
			[33,:TOXIC],
			[36,:SEEDBOMB],
			[40,:SPORE]],
		:compatiblemoves => [:BODYSLAM,:BULLETSEED,:CHARM,:DOUBLEEDGE,:DRAINPUNCH,:ENERGYBALL,:FAKETEARS,:FALSESWIPE,:FLASH,:FOCUSPUNCH,:GIGADRAIN,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:MAGICALLEAF,:MIMIC,:SAFEGUARD,:SEEDBOMB,:SLUDGEBOMB,:SNATCH,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWMIST,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Fairy, :Grass],
		:Height => 4,
		:Weight => 45,
		:WildItemCommon => :TINYMUSHROOM,
		:WildItemUncommon => :BIGMUSHROOM,
		:kind => "Mushroom",
		:dexentry => "It loves to eat damp, composted soil in forests. If you enter a forest after a long rain, you can see many Shroomish feasting on composted soil.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BRELOOM,:Level,23]
		]
	},

	:OnCreation => {},
},

:BRELOOM => {
	"Normal Form" => {
		:name => "Breloom",
		:dexnum => 286,
		:Type1 => :GRASS,
		:Type2 => :FIGHTING,
		:BaseStats => [60, 130, 80, 60, 60, 70],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:EFFECTSPORE, :POISONHEAL],
		:HiddenAbilities => :TECHNICIAN,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SHROOMISH,
			:form => 0
		},
		:Moveset => [
			[0,:MACHPUNCH],
			[1,:ABSORB],
			[1,:TACKLE],
			[1,:STUNSPORE],
			[1,:LEECHSEED],
			[5,:STUNSPORE],
			[8,:LEECHSEED],
			[12,:MEGADRAIN],
			[15,:HEADBUTT],
			[19,:FEINT],
			[22,:COUNTER],
			[28,:FORCEPALM],
			[33,:MINDREADER],
			[39,:SKYUPPERCUT],
			[44,:SEEDBOMB],
			[50,:DYNAMICPUNCH]],
		:compatiblemoves => [:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLETSEED,:CHARM,:CLOSECOMBAT,:COACHING,:COUNTER,:CUT,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ENERGYBALL,:FAKETEARS,:FALSESWIPE,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:IRONTAIL,:LASERFOCUS,:LEAFSTORM,:LOWKICK,:LOWSWEEP,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:RETALIATE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SEEDBOMB,:SEISMICTOSS,:SLUDGEBOMB,:SNATCH,:SOLARBEAM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:SYNTHESIS,:THUNDERPUNCH,:VACUUMWAVE,:VENOSHOCK,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Fairy, :Grass],
		:Height => 12,
		:Weight => 392,
		:WildItemCommon => :TINYMUSHROOM,
		:WildItemUncommon => :BIGMUSHROOM,
		:kind => "Mushroom",
		:dexentry => "It scatters spores from holes in the cap on its head. It loves warm and humid climates. It feeds on trees and plants in fields and forests.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SLAKOTH => {
	"Normal Form" => {
		:name => "Slakoth",
		:dexnum => 287,
		:Type1 => :NORMAL,
		:BaseStats => [60, 60, 60, 35, 35, 30],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:TRUANT],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AFTERYOU,:BODYSLAM,:CRUSHCLAW,:CURSE,:HAMMERARM,:NIGHTSLASH,:PURSUIT,:SLASH,:SLEEPTALK,:SNORE,:TICKLE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:YAWN],
			[6,:ENCORE],
			[9,:SLACKOFF],
			[14,:FEINTATTACK],
			[17,:AMNESIA],
			[22,:COVET],
			[25,:CHIPAWAY],
			[30,:COUNTER],
			[33,:FLAIL],
			[38,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AMNESIA,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULKUP,:COUNTER,:COVET,:CUT,:DOUBLEEDGE,:DYNAMICPUNCH,:ENCORE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GUNKSHOT,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 240,
		:kind => "Slacker",
		:dexentry => "It sleeps virtually all day and night long. It doesn't change its nest its entire life, but it sometimes travels great distances by swimming in rivers.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VIGOROTH,:Level,18]
		]
	},

	:OnCreation => {},
},

:VIGOROTH => {
	"Normal Form" => {
		:name => "Vigoroth",
		:dexnum => 288,
		:Type1 => :NORMAL,
		:BaseStats => [80, 80, 80, 55, 55, 90],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:VITALSPIRIT],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 154,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SLAKOTH,
			:form => 0
		},
		:Moveset => [
			[1,:REVERSAL],
			[1,:SCRATCH],
			[1,:FOCUSENERGY],
			[1,:ENCORE],
			[1,:UPROAR],
			[6,:ENCORE],
			[9,:UPROAR],
			[14,:FURYSWIPES],
			[17,:ENDURE],
			[23,:SLASH],
			[27,:CHIPAWAY],
			[33,:COUNTER],
			[37,:FOCUSPUNCH],
			[43,:REVERSAL]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AMNESIA,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:COUNTER,:COVET,:CUT,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GUNKSHOT,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 14,
		:Weight => 465,
		:kind => "Wild Monkey",
		:dexentry => "It can't keep still because its filled with energy. It runs through fields and mountains all day to calm itself. If it doesn't, it can't sleep at night.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SLAKING,:Level,36]
		]
	},

	:OnCreation => {},
},

:SLAKING => {
	"Normal Form" => {
		:name => "Slaking",
		:dexnum => 289,
		:Type1 => :NORMAL,
		:BaseStats => [150, 160, 100, 95, 65, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:TRUANT],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 252,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :VIGOROTH,
			:form => 0
		},
		:Moveset => [
			[0,:SWAGGER],
			[1,:HAMMERARM],
			[1,:PUNISHMENT],
			[1,:FLING],
			[1,:SCRATCH],
			[1,:YAWN],
			[1,:ENCORE],
			[1,:SLACKOFF],
			[6,:ENCORE],
			[9,:SLACKOFF],
			[14,:FEINTATTACK],
			[17,:AMNESIA],
			[23,:COVET],
			[27,:CHIPAWAY],
			[33,:COUNTER],
			[39,:FLAIL],
			[47,:FLING],
			[53,:PUNISHMENT],
			[61,:HAMMERARM]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AMNESIA,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:COUNTER,:COVET,:CUT,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:PLAYROUGH,:POWERUPPUNCH,:QUASH,:RAINDANCE,:RETALIATE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SMACKDOWN,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 20,
		:Weight => 1305,
		:kind => "Lazy",
		:dexentry => "Hordes of Slaking gather around trees when fruits come into season. They wait around patiently for ripened fruits to fall out of the trees.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:NINCADA => {
	"Normal Form" => {
		:name => "Nincada",
		:dexnum => 290,
		:Type1 => :BUG,
		:Type2 => :GROUND,
		:BaseStats => [31, 45, 90, 30, 30, 40],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:COMPOUNDEYES, :RUNAWAY],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 53,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BUGBITE,:BUGBUZZ,:ENDURE,:FEINTATTACK,:FINALGAMBIT,:GUST,:NIGHTSLASH,:SILVERWIND,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:HARDEN],
			[5,:ABSORB],
			[9,:SANDATTACK],
			[13,:FURYSWIPES],
			[17,:MUDSLAP],
			[21,:METALCLAW],
			[25,:MINDREADER],
			[29,:BIDE],
			[33,:FALSESWIPE],
			[37,:DIG]],
		:compatiblemoves => [:AERIALACE,:BUGBITE,:BUGBUZZ,:CUT,:DIG,:DOUBLEEDGE,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGADRAIN,:HONECLAWS,:LEECHLIFE,:MIMIC,:MUDSLAP,:SANDSTORM,:SHADOWBALL,:SKITTERSMACK,:SOLARBEAM,:SPITE,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:XSCISSOR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Gray",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 5,
		:Weight => 55,
		:WildItemUncommon => :SOFTSAND,
		:kind => "Trainee",
		:dexentry => "It makes its nest at the roots of a mighty tree. Using its whiskerlike antennae, it probes its surroundings in the pitch-black darkness of soil.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 29,
		:BattlerAltitude => 0,
		:evolutions => [
			[:NINJASK,:Ninjask,20],
			[:SHEDINJA,:Shedinja,20]
		]
	},

	:OnCreation => {},
},

:NINJASK => {
	"Normal Form" => {
		:name => "Ninjask",
		:dexnum => 291,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [61, 90, 45, 50, 50, 160],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SPEEDBOOST, :INFILTRATOR],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 160,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :NINCADA,
			:form => 0
		},
		:Moveset => [
			[0,:DOUBLETEAM],
			[0,:SCREECH],
			[0,:FURYCUTTER],
			[1,:BUGBITE],
			[1,:SCRATCH],
			[1,:HARDEN],
			[1,:ABSORB],
			[1,:SANDATTACK],
			[5,:ABSORB],
			[9,:SANDATTACK],
			[13,:FURYSWIPES],
			[17,:AGILITY],
			[23,:SLASH],
			[29,:MINDREADER],
			[35,:BATONPASS],
			[41,:SWORDSDANCE],
			[47,:XSCISSOR]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:BATONPASS,:BUGBITE,:BUGBUZZ,:CUT,:DEFOG,:DIG,:DOUBLEEDGE,:DUALWINGBEAT,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:HONECLAWS,:HYPERBEAM,:LASERFOCUS,:LEECHLIFE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:ROOST,:SANDSTORM,:SCREECH,:SHADOWBALL,:SKITTERSMACK,:SOLARBEAM,:SPITE,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:THIEF,:UPROAR,:UTURN,:XSCISSOR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Yellow",
		:Habitat => "Forest",
		:EggGroups => [:Bug],
		:Height => 8,
		:Weight => 120,
		:kind => "Ninja",
		:dexentry => "Because it darts about vigorously at high speed, it is very difficult to see. Hearing its distinctive cries for too long induces a headache.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 16,
	},

	:OnCreation => {},
},

:SHEDINJA => {
	"Normal Form" => {
		:name => "Shedinja",
		:dexnum => 292,
		:Type1 => :BUG,
		:Type2 => :GHOST,
		:BaseStats => [1, 90, 45, 30, 30, 40],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:WONDERGUARD],
		:GrowthRate => :Erratic,
		:GenderRatio => :Genderless,
		:BaseEXP => 83,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :NINCADA,
			:form => 0
		},
		:Moveset => [
			[1,:SCRATCH],
			[1,:HARDEN],
			[1,:ABSORB],
			[1,:SANDATTACK],
			[5,:ABSORB],
			[9,:SANDATTACK],
			[13,:FURYSWIPES],
			[17,:SPITE],
			[21,:SHADOWSNEAK],
			[25,:MINDREADER],
			[29,:CONFUSERAY],
			[33,:SHADOWBALL],
			[37,:GRUDGE],
			[41,:HEALBLOCK],
			[45,:PHANTOMFORCE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BUGBITE,:BUGBUZZ,:CUT,:DIG,:DOUBLEEDGE,:DREAMEATER,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:HEX,:HONECLAWS,:HYPERBEAM,:LEECHLIFE,:MIMIC,:MUDSLAP,:NIGHTMARE,:PHANTOMFORCE,:POLTERGEIST,:SANDSTORM,:SHADOWBALL,:SHADOWCLAW,:SKITTERSMACK,:SOLARBEAM,:SPITE,:STRINGSHOT,:STRUGGLEBUG,:SUCKERPUNCH,:SUNNYDAY,:TELEKINESIS,:THIEF,:TRICK,:WILLOWISP,:XSCISSOR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Brown",
		:Habitat => "Forest",
		:EggGroups => [:Mineral],
		:Height => 8,
		:Weight => 12,
		:kind => "Shed",
		:dexentry => "A peculiar Pokémon that floats in air even though its wings remain completely still. The inside of its body is hollow and utterly dark.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:WHISMUR => {
	"Normal Form" => {
		:name => "Whismur",
		:dexnum => 293,
		:Type1 => :NORMAL,
		:BaseStats => [64, 51, 23, 51, 23, 28],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SOUNDPROOF, :RATTLED],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 48,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CIRCLETHROW,:DISARMINGVOICE,:ENDEAVOR,:EXTRASENSORY,:FAKETEARS,:HAMMERARM,:SMELLINGSALTS,:SMOKESCREEN,:SNORE,:TAKEDOWN,:WHIRLWIND,],
		:Moveset => [
			[1,:POUND],
			[4,:ECHOEDVOICE],
			[8,:ASTONISH],
			[11,:HOWL],
			[15,:SCREECH],
			[18,:SUPERSONIC],
			[22,:STOMP],
			[25,:UPROAR],
			[29,:ROAR],
			[32,:REST],
			[36,:SLEEPTALK],
			[39,:HYPERVOICE],
			[43,:SYNCHRONOISE]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:COUNTER,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:ECHOEDVOICE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:HEADBUTT,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROLLOUT,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:SUNNYDAY,:THUNDERPUNCH,:UPROAR,:WATERPULSE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Cave",
		:EggGroups => [:Monster, :Field],
		:Height => 6,
		:Weight => 163,
		:kind => "Whisper",
		:dexentry => "Its cries equal a jet plane in volume. It inhales through its ear canals. Because of this, it can cry continually without having to catch its breath.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LOUDRED,:Level,20]
		]
	},

	:OnCreation => {},
},

:LOUDRED => {
	"Normal Form" => {
		:name => "Loudred",
		:dexnum => 294,
		:Type1 => :NORMAL,
		:BaseStats => [84, 71, 43, 71, 43, 48],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:SOUNDPROOF, :SCRAPPY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 126,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :WHISMUR,
			:form => 0
		},
		:Moveset => [
			[0,:BITE],
			[1,:POUND],
			[1,:ECHOEDVOICE],
			[1,:ASTONISH],
			[1,:HOWL],
			[4,:ECHOEDVOICE],
			[9,:ASTONISH],
			[11,:HOWL],
			[15,:SCREECH],
			[18,:SUPERSONIC],
			[23,:STOMP],
			[27,:UPROAR],
			[32,:ROAR],
			[36,:REST],
			[41,:SLEEPTALK],
			[45,:HYPERVOICE],
			[50,:SYNCHRONOISE]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:HEADBUTT,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OVERHEAT,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SMACKDOWN,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:TAUNT,:THUNDERPUNCH,:TORMENT,:UPROAR,:WATERPULSE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Cave",
		:EggGroups => [:Monster, :Field],
		:Height => 10,
		:Weight => 405,
		:kind => "Big Voice",
		:dexentry => "It positions the round speakers on its head to assail foes with ultrasonic waves at massive volume. It builds power by stomping the ground.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
		:evolutions => [
			[:EXPLOUD,:Level,40]
		]
	},

	:OnCreation => {},
},

:EXPLOUD => {
	"Normal Form" => {
		:name => "Exploud",
		:dexnum => 295,
		:Type1 => :NORMAL,
		:BaseStats => [104, 91, 63, 91, 73, 68],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:SOUNDPROOF, :SCRAPPY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 221,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :LOUDRED,
			:form => 0
		},
		:Moveset => [
			[0,:CRUNCH],
			[1,:BITE],
			[1,:BOOMBURST],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:POUND],
			[1,:ECHOEDVOICE],
			[1,:ASTONISH],
			[1,:HOWL],
			[4,:ECHOEDVOICE],
			[9,:ASTONISH],
			[11,:HOWL],
			[15,:SCREECH],
			[18,:SUPERSONIC],
			[23,:STOMP],
			[27,:UPROAR],
			[32,:ROAR],
			[36,:REST],
			[42,:SLEEPTALK],
			[47,:HYPERVOICE],
			[53,:SYNCHRONOISE],
			[58,:BOOMBURST],
			[64,:HYPERBEAM]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COUNTER,:CRUNCH,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FAKETEARS,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:GIGAIMPACT,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICYWIND,:INCINERATE,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCREECH,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SMACKDOWN,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SURF,:TAUNT,:TERRAINPULSE,:THUNDERFANG,:THUNDERPUNCH,:TORMENT,:UPROAR,:WATERPULSE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Cave",
		:EggGroups => [:Monster, :Field],
		:Height => 15,
		:Weight => 840,
		:kind => "Loud Noise",
		:dexentry => "It has sound-generating organs all over its body. It communicates with others by adjusting the tone and volume of the cries it emits.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MAKUHITA => {
	"Normal Form" => {
		:name => "Makuhita",
		:dexnum => 296,
		:Type1 => :FIGHTING,
		:BaseStats => [72, 60, 30, 20, 30, 25],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :GUTS],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 47,
		:CatchRate => 180,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BULLETPUNCH,:CHIPAWAY,:COUNTER,:CROSSCHOP,:DETECT,:DYNAMICPUNCH,:FEINT,:FEINTATTACK,:FOCUSPUNCH,:FORESIGHT,:HELPINGHAND,:REVENGE,:WAKEUPSLAP,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[1,:FOCUSENERGY],
			[4,:SANDATTACK],
			[7,:ARMTHRUST],
			[10,:FAKEOUT],
			[13,:FORCEPALM],
			[16,:WHIRLWIND],
			[19,:KNOCKOFF],
			[22,:VITALTHROW],
			[25,:BELLYDRUM],
			[28,:SMELLINGSALTS],
			[31,:SEISMICTOSS],
			[34,:WAKEUPSLAP],
			[37,:ENDURE],
			[40,:CLOSECOMBAT],
			[43,:REVERSAL],
			[46,:HEAVYSLAM]],
		:compatiblemoves => [:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:HEADBUTT,:HEAVYSLAM,:HELPINGHAND,:ICEPUNCH,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSHOT,:MUDSLAP,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SMACKDOWN,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:THUNDERPUNCH,:VACUUMWAVE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Yellow",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 10,
		:Weight => 864,
		:WildItemUncommon => :BLACKBELT,
		:kind => "Guts",
		:dexentry => "It loves to toughen up its body above all else. If you hear quaking rumbles in a cave, it is the sound of Makuhita undertaking strenuous training.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HARIYAMA,:Level,24]
		]
	},

	:OnCreation => {},
},

:HARIYAMA => {
	"Normal Form" => {
		:name => "Hariyama",
		:dexnum => 297,
		:Type1 => :FIGHTING,
		:BaseStats => [144, 120, 60, 40, 60, 50],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :GUTS],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 166,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MAKUHITA,
			:form => 0
		},
		:Moveset => [
			[1,:BRINE],
			[1,:TACKLE],
			[1,:FOCUSENERGY],
			[1,:SANDATTACK],
			[1,:ARMTHRUST],
			[4,:SANDATTACK],
			[7,:ARMTHRUST],
			[10,:FAKEOUT],
			[13,:FORCEPALM],
			[16,:WHIRLWIND],
			[19,:KNOCKOFF],
			[22,:VITALTHROW],
			[26,:BELLYDRUM],
			[30,:SMELLINGSALTS],
			[34,:SEISMICTOSS],
			[38,:WAKEUPSLAP],
			[42,:ENDURE],
			[46,:CLOSECOMBAT],
			[50,:REVERSAL],
			[54,:HEAVYSLAM]],
		:compatiblemoves => [:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRINE,:BULKUP,:BULLDOZE,:CLOSECOMBAT,:COACHING,:COUNTER,:DARKESTLARIAT,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEAVYSLAM,:HELPINGHAND,:HIGHHORSEPOWER,:HYPERBEAM,:ICEPUNCH,:IRONHEAD,:KNOCKOFF,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSHOT,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SEISMICTOSS,:SMACKDOWN,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:THROATCHOP,:THUNDERPUNCH,:VACUUMWAVE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 23,
		:Weight => 2538,
		:WildItemUncommon => :KINGSROCK,
		:kind => "Arm Thrust",
		:dexentry => "It has the habit of challenging others without hesitation to test its strength. It has been known to stop trains using forearm thrusts.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:AZURILL => {
	"Normal Form" => {
		:name => "Azurill",
		:dexnum => 298,
		:Type1 => :NORMAL,
		:Type2 => :FAIRY,
		:BaseStats => [50, 20, 40, 20, 40, 20],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :HUGEPOWER],
		:HiddenAbilities => :SAPSIPPER,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 38,
		:CatchRate => 150,
		:Happiness => 70,
		:EggSteps => 2805,
		:EggMoves => [:BODYSLAM,:CAMOUFLAGE,:COPYCAT,:ENCORE,:FAKETEARS,:MUDDYWATER,:REFRESH,:SING,:SLAM,:SOAK,:TICKLE,:WATERSPORT,],
		:Moveset => [
			[1,:SPLASH],
			[1,:WATERGUN],
			[2,:TAILWHIP],
			[5,:WATERSPORT],
			[7,:BUBBLE],
			[10,:CHARM],
			[13,:BUBBLEBEAM],
			[16,:HELPINGHAND],
			[20,:SLAM],
			[23,:BOUNCE]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BOUNCE,:BRUTALSWING,:CHARM,:COVET,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:ENCORE,:FAKETEARS,:HAIL,:HEADBUTT,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:RAINDANCE,:ROLLOUT,:SCALD,:SURF,:SWIFT,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Undiscovered],
		:Height => 2,
		:Weight => 20,
		:kind => "Polka Dot",
		:dexentry => "Its tail, which is packed with nutrition, is very bouncy like a rubber ball. On sunny days they gather at the edge of water and splash about for fun.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MARILL,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:NOSEPASS => {
	"Normal Form" => {
		:name => "Nosepass",
		:dexnum => 299,
		:Type1 => :ROCK,
		:BaseStats => [30, 45, 135, 45, 90, 30],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:STURDY, :MAGNETPULL],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 75,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BLOCK,:DOUBLEEDGE,:ENDURE,:MAGNITUDE,:ROLLOUT,:STEALTHROCK,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[4,:HARDEN],
			[7,:BLOCK],
			[10,:ROCKTHROW],
			[13,:THUNDERWAVE],
			[16,:REST],
			[19,:SPARK],
			[22,:ROCKSLIDE],
			[25,:POWERGEM],
			[28,:ROCKBLAST],
			[31,:DISCHARGE],
			[34,:SANDSTORM],
			[37,:EARTHPOWER],
			[40,:STONEEDGE],
			[43,:LOCKON],
			[43,:ZAPCANNON]],
		:compatiblemoves => [:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BODYSLAM,:BULLDOZE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREPUNCH,:GRAVITY,:HEADBUTT,:HEAVYSLAM,:ICEPUNCH,:IRONDEFENSE,:MAGICCOAT,:MAGNETRISE,:METEORBEAM,:MIMIC,:MUDSLAP,:PAINSPLIT,:POWERGEM,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SELFDESTRUCT,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:VOLTSWITCH,:ZAPCANNON,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWMIST,],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Mineral],
		:Height => 10,
		:Weight => 970,
		:WildItemUncommon => :MAGNET,
		:kind => "Compass",
		:dexentry => "Its body emits a powerful magnetism. It feeds on prey that is pulled in by the force. Its magnetism is stronger in cold seasons.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PROBOPASS,:Location,0]
		]
	},

	:OnCreation => {},
},

:SKITTY => {
	"Normal Form" => {
		:name => "Skitty",
		:dexnum => 300,
		:Type1 => :NORMAL,
		:BaseStats => [50, 45, 45, 35, 35, 50],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:CUTECHARM, :NORMALIZE],
		:HiddenAbilities => :WONDERSKIN,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 52,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BATONPASS,:CAPTIVATE,:COSMICPOWER,:FAKEOUT,:FAKETEARS,:HELPINGHAND,:LASTRESORT,:MUDBOMB,:SIMPLEBEAM,:SUCKERPUNCH,:TICKLE,:UPROAR,:WISH,:ZENHEADBUTT,],
		:Moveset => [
			[1,:FAKEOUT],
			[1,:GROWL],
			[1,:TAILWHIP],
			[1,:TACKLE],
			[4,:FORESIGHT],
			[7,:SING],
			[10,:ATTRACT],
			[13,:DISARMINGVOICE],
			[16,:DOUBLESLAP],
			[19,:COPYCAT],
			[22,:FEINTATTACK],
			[25,:CHARM],
			[28,:WAKEUPSLAP],
			[31,:ASSIST],
			[34,:COVET],
			[37,:HEALBELL],
			[40,:DOUBLEEDGE],
			[43,:CAPTIVATE],
			[46,:PLAYROUGH]],
		:compatiblemoves => [:AGILITY,:BEATUP,:BLIZZARD,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:FAKETEARS,:FIREFANG,:FLASH,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:LASTRESORT,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:POWERSWAP,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Fairy],
		:Height => 6,
		:Weight => 110,
		:kind => "Kitten",
		:dexentry => "A Skitty's adorably cute behavior makes it highly popular. In battle, it makes its tail puff out. It threatens foes with a sharp growl.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 3,
		:evolutions => [
			[:DELCATTY,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:DELCATTY => {
	"Normal Form" => {
		:name => "Delcatty",
		:dexnum => 301,
		:Type1 => :NORMAL,
		:BaseStats => [70, 65, 65, 55, 55, 90],
		:EVs => [1, 0, 0, 0, 0, 1],
		:Abilities => [:CUTECHARM, :NORMALIZE],
		:HiddenAbilities => :WONDERSKIN,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 140,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :SKITTY,
			:form => 0
		},
		:Moveset => [
			[1,:FAKEOUT],
			[1,:SING],
			[1,:ATTRACT],
			[1,:DOUBLESLAP]],
		:compatiblemoves => [:AGILITY,:BEATUP,:BLIZZARD,:BODYSLAM,:BURNINGJEALOUSY,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:FAKETEARS,:FIREFANG,:FLASH,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HIGHHORSEPOWER,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LASHOUT,:LASTRESORT,:MIMIC,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:POWERSWAP,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:TRIPLEAXEL,:UPROAR,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWWAVE,],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Field, :Fairy],
		:Height => 11,
		:Weight => 326,
		:kind => "Prim",
		:dexentry => "Rather than keeping a permanent lair, it habitually seeks comfortable spots and sleeps there. It is nocturnal and becomes active at dusk.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SABLEYE => {
	"Normal Form" => {
		:name => "Sableye",
		:dexnum => 302,
		:Type1 => :DARK,
		:Type2 => :GHOST,
		:BaseStats => [50, 75, 75, 65, 65, 50],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:KEENEYE, :STALL],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 133,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 6630,
		:EggMoves => [:CAPTIVATE,:FEINT,:FLATTER,:IMPRISON,:MEANLOOK,:METALBURST,:MOONLIGHT,:NASTYPLOT,:RECOVER,:SUCKERPUNCH,:TRICK,],
		:Moveset => [
			[1,:LEER],
			[1,:SCRATCH],
			[4,:FORESIGHT],
			[6,:NIGHTSHADE],
			[9,:ASTONISH],
			[11,:FURYSWIPES],
			[14,:DETECT],
			[16,:SHADOWSNEAK],
			[19,:FEINTATTACK],
			[21,:FAKEOUT],
			[24,:PUNISHMENT],
			[26,:KNOCKOFF],
			[29,:SHADOWCLAW],
			[31,:CONFUSERAY],
			[34,:ZENHEADBUTT],
			[36,:POWERGEM],
			[39,:SHADOWBALL],
			[41,:FOULPLAY],
			[44,:QUASH],
			[46,:MEANLOOK]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:BODYSLAM,:BRICKBREAK,:CALMMIND,:COUNTER,:CUT,:DARKPULSE,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:EMBARGO,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GRAVITY,:GYROBALL,:HEADBUTT,:HELPINGHAND,:HEX,:HONECLAWS,:ICEPUNCH,:ICYWIND,:IMPRISON,:INCINERATE,:KNOCKOFF,:LASHOUT,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POISONJAB,:POLTERGEIST,:POWERGEM,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:QUASH,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERPUNCH,:TORMENT,:TRICK,:WATERPULSE,:WILLOWISP,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWHOLD,],
		:Color => "Purple",
		:Habitat => "Cave",
		:EggGroups => [:HumanLike],
		:Height => 5,
		:Weight => 110,
		:WildItemUncommon => :WIDELENS,
		:kind => "Darkness",
		:dexentry => "It digs branching holes in caves using its sharp claws in search of food-- raw gems. A Sableye lurks in darkness and is seen only rarely.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [50, 85, 125, 85, 115, 20],
		:Abilities => [:MAGICBOUNCE],
		:Height => 5,
		:Weight => 1610,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SABLENITE => 1,
	},
},

:MAWILE => {
	"Normal Form" => {
		:name => "Mawile",
		:dexnum => 303,
		:Type1 => :STEEL,
		:Type2 => :FAIRY,
		:BaseStats => [50, 85, 85, 55, 55, 50],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :INTIMIDATE],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 133,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:CAPTIVATE,:FIREFANG,:GUARDSWAP,:ICEFANG,:METALBURST,:MISTYTERRAIN,:POISONFANG,:POWERUPPUNCH,:PUNISHMENT,:SEISMICTOSS,:SLAM,:SUCKERPUNCH,:THUNDERFANG,:TICKLE,],
		:Moveset => [
			[1,:PLAYROUGH],
			[1,:IRONHEAD],
			[1,:TAUNT],
			[1,:GROWL],
			[1,:FAIRYWIND],
			[1,:ASTONISH],
			[5,:FAKETEARS],
			[9,:BITE],
			[13,:SWEETSCENT],
			[17,:VICEGRIP],
			[21,:FEINTATTACK],
			[25,:BATONPASS],
			[29,:CRUNCH],
			[33,:IRONDEFENSE],
			[37,:SUCKERPUNCH],
			[41,:STOCKPILE],
			[41,:SPITUP],
			[41,:SWALLOW],
			[45,:IRONHEAD],
			[49,:PLAYROUGH]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BATONPASS,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:CHARGEBEAM,:COUNTER,:CRUNCH,:DARKPULSE,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:EMBARGO,:FAKETEARS,:FALSESWIPE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYTERRAIN,:MUDSLAP,:PAINSPLIT,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SEISMICTOSS,:SHADOWBALL,:SLUDGEBOMB,:SNATCH,:SOLARBEAM,:STEALTHROCK,:STEELBEAM,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWORDSDANCE,:TAUNT,:THUNDERFANG,:THUNDERPUNCH,:TORMENT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWWAVE,],
		:Color => "Black",
		:Habitat => "Cave",
		:EggGroups => [:Field, :Fairy],
		:Height => 6,
		:Weight => 115,
		:WildItemUncommon => :IRONBALL,
		:kind => "Deceiver",
		:dexentry => "Its giant jaws are actually steel horns that transformed. It fools foes into complacency with its adorable gestures, then chomps them with its huge jaws.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [50, 105, 125, 55, 95, 50],
		:Abilities => [:HUGEPOWER],
		:Weight => 235,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:MAWILITE => 1,
	},
},

:ARON => {
	"Normal Form" => {
		:name => "Aron",
		:dexnum => 304,
		:Type1 => :STEEL,
		:Type2 => :ROCK,
		:BaseStats => [50, 70, 100, 40, 40, 30],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:STURDY, :ROCKHEAD],
		:HiddenAbilities => :HEAVYMETAL,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 180,
		:Happiness => 35,
		:EggSteps => 9180,
		:EggMoves => [:BODYSLAM,:CURSE,:DRAGONRUSH,:ENDEAVOR,:HEADSMASH,:IRONHEAD,:REVERSAL,:SCREECH,:SMELLINGSALTS,:STEALTHROCK,:STOMP,:SUPERPOWER,],
		:Moveset => [
			[1,:TACKLE],
			[1,:HARDEN],
			[4,:MUDSLAP],
			[7,:HEADBUTT],
			[10,:METALCLAW],
			[13,:ROCKTOMB],
			[16,:PROTECT],
			[19,:ROAR],
			[22,:IRONHEAD],
			[25,:ROCKSLIDE],
			[28,:TAKEDOWN],
			[31,:METALSOUND],
			[34,:IRONTAIL],
			[37,:IRONDEFENSE],
			[40,:DOUBLEEDGE],
			[43,:AUTOTOMIZE],
			[46,:HEAVYSLAM],
			[49,:METALBURST]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BODYPRESS,:BODYSLAM,:BULLDOZE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FURYCUTTER,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MAGNETRISE,:MIMIC,:MUDSLAP,:RAINDANCE,:REVERSAL,:ROAR,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SHADOWCLAW,:SHOCKWAVE,:SPITE,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:UPROAR,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 4,
		:Weight => 600,
		:WildItemUncommon => :HARDSTONE,
		:kind => "Iron Armor",
		:dexentry => "A Pokémon that is clad in steel armor. A new suit of armor is made when it evolves. The old armor is salvaged as metal for making iron products.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LAIRON,:Level,32]
		]
	},

	:OnCreation => {},
},

:LAIRON => {
	"Normal Form" => {
		:name => "Lairon",
		:dexnum => 305,
		:Type1 => :STEEL,
		:Type2 => :ROCK,
		:BaseStats => [60, 90, 140, 50, 50, 40],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:STURDY, :ROCKHEAD],
		:HiddenAbilities => :HEAVYMETAL,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 151,
		:CatchRate => 90,
		:Happiness => 35,
		:EggSteps => 9180,
		:preevo => {
			:species => :ARON,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:MUDSLAP],
			[1,:HEADBUTT],
			[4,:MUDSLAP],
			[7,:HEADBUTT],
			[10,:METALCLAW],
			[13,:ROCKTOMB],
			[16,:PROTECT],
			[19,:ROAR],
			[22,:IRONHEAD],
			[25,:ROCKSLIDE],
			[28,:TAKEDOWN],
			[31,:METALSOUND],
			[35,:IRONTAIL],
			[39,:IRONDEFENSE],
			[43,:DOUBLEEDGE],
			[47,:AUTOTOMIZE],
			[51,:HEAVYSLAM],
			[55,:METALBURST]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BODYPRESS,:BODYSLAM,:BULLDOZE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FURYCUTTER,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MAGNETRISE,:MIMIC,:MUDSLAP,:RAINDANCE,:REVERSAL,:ROAR,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SHADOWCLAW,:SHOCKWAVE,:SPITE,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:UPROAR,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 9,
		:Weight => 1200,
		:WildItemUncommon => :HARDSTONE,
		:kind => "Iron Armor",
		:dexentry => "When two Lairon meet in the wild, they fight for territory by bashing into each other. The sound of their collision carries for miles.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:AGGRON,:Level,42]
		]
	},

	:OnCreation => {},
},

:AGGRON => {
	"Normal Form" => {
		:name => "Aggron",
		:dexnum => 306,
		:Type1 => :STEEL,
		:Type2 => :ROCK,
		:BaseStats => [70, 110, 180, 60, 60, 50],
		:EVs => [0, 0, 3, 0, 0, 0],
		:Abilities => [:STURDY, :ROCKHEAD],
		:HiddenAbilities => :HEAVYMETAL,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 9180,
		:preevo => {
			:species => :LAIRON,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:MUDSLAP],
			[1,:HEADBUTT],
			[4,:MUDSLAP],
			[7,:HEADBUTT],
			[10,:METALCLAW],
			[13,:ROCKTOMB],
			[16,:PROTECT],
			[19,:ROAR],
			[22,:IRONHEAD],
			[25,:ROCKSLIDE],
			[28,:TAKEDOWN],
			[31,:METALSOUND],
			[35,:IRONTAIL],
			[39,:IRONDEFENSE],
			[45,:DOUBLEEDGE],
			[51,:AUTOTOMIZE],
			[57,:HEAVYSLAM],
			[63,:METALBURST]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:COUNTER,:CRUNCH,:CUT,:DARKPULSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:LOWKICK,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSLAP,:OUTRAGE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:REVERSAL,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SCREECH,:SEISMICTOSS,:SHADOWCLAW,:SHOCKWAVE,:SMACKDOWN,:SMARTSTRIKE,:SOLARBEAM,:SPITE,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Mountain",
		:EggGroups => [:Monster],
		:Height => 21,
		:Weight => 3600,
		:WildItemUncommon => :HARDSTONE,
		:kind => "Iron Armor",
		:dexentry => "Its iron horns grow longer a little at a time. They determine the Aggron's age. The gouges in its armor are worn with pride as mementos from battles.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type1 => :STEEL,
		:BaseStats => [70, 140, 230, 60, 80, 50],
		:Abilities => [:FILTER],
		:Weight => 3950,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:AGGRONITE => 1,
	},
},

:MEDITITE => {
	"Normal Form" => {
		:name => "Meditite",
		:dexnum => 307,
		:Type1 => :FIGHTING,
		:Type2 => :PSYCHIC,
		:BaseStats => [30, 40, 55, 40, 55, 60],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:PUREPOWER, :TELEPATHY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 180,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BATONPASS,:BULLETPUNCH,:DRAINPUNCH,:DYNAMICPUNCH,:FAKEOUT,:FIREPUNCH,:FORESIGHT,:GUARDSWAP,:ICEPUNCH,:POWERSWAP,:PSYCHOCUT,:QUICKGUARD,:SECRETPOWER,:THUNDERPUNCH,],
		:Moveset => [
			[1,:BIDE],
			[4,:MEDITATE],
			[7,:CONFUSION],
			[9,:DETECT],
			[12,:ENDURE],
			[15,:FEINT],
			[17,:FORCEPALM],
			[20,:HIDDENPOWER],
			[23,:CALMMIND],
			[25,:MINDREADER],
			[28,:HIJUMPKICK],
			[31,:PSYCHUP],
			[33,:ACUPRESSURE],
			[36,:POWERTRICK],
			[39,:REVERSAL],
			[41,:RECOVER],
			[44,:COUNTER]],
		:compatiblemoves => [:BATONPASS,:BODYSLAM,:BRICKBREAK,:BULKUP,:CALMMIND,:COUNTER,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:PAINSPLIT,:POISONJAB,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDERPUNCH,:TRICK,:VACUUMWAVE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 6,
		:Weight => 112,
		:kind => "Meditate",
		:dexentry => "It continually meditates for hours every day. As a result of rigorous and dedicated yoga training, it has tempered its spiritual power so much it can fly.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MEDICHAM,:Level,37]
		]
	},

	:OnCreation => {},
},

:MEDICHAM => {
	"Normal Form" => {
		:name => "Medicham",
		:dexnum => 308,
		:Type1 => :FIGHTING,
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 60, 75, 60, 75, 80],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:PUREPOWER, :TELEPATHY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MEDITITE,
			:form => 0
		},
		:Moveset => [
			[1,:ZENHEADBUTT],
			[1,:FIREPUNCH],
			[1,:THUNDERPUNCH],
			[1,:ICEPUNCH],
			[1,:BIDE],
			[1,:MEDITATE],
			[1,:CONFUSION],
			[1,:DETECT],
			[1,:BIDE],
			[4,:MEDITATE],
			[7,:CONFUSION],
			[9,:DETECT],
			[12,:ENDURE],
			[15,:FEINT],
			[17,:FORCEPALM],
			[20,:HIDDENPOWER],
			[23,:CALMMIND],
			[25,:MINDREADER],
			[28,:HIJUMPKICK],
			[31,:PSYCHUP],
			[33,:ACUPRESSURE],
			[36,:POWERTRICK],
			[42,:REVERSAL],
			[47,:RECOVER],
			[53,:COUNTER]],
		:compatiblemoves => [:BATONPASS,:BODYSLAM,:BRICKBREAK,:BULKUP,:CALMMIND,:CLOSECOMBAT,:COACHING,:COUNTER,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:LASERFOCUS,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:PAINSPLIT,:POISONJAB,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEISMICTOSS,:SHADOWBALL,:SIGNALBEAM,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:TERRAINPULSE,:THUNDERPUNCH,:TRICK,:VACUUMWAVE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:HumanLike],
		:Height => 13,
		:Weight => 315,
		:kind => "Meditate",
		:dexentry => "Through crushingly harsh yoga training, it gained the power to foretell its foe's actions. It battles with elegant, dance- like movement.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [60, 100, 85, 80, 85, 100],
		:Abilities => [:PUREPOWER],
		:Weight => 315,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:MEDICHAMITE => 1,
	},
},

:ELECTRIKE => {
	"Normal Form" => {
		:name => "Electrike",
		:dexnum => 309,
		:Type1 => :ELECTRIC,
		:BaseStats => [40, 45, 40, 65, 40, 65],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:STATIC, :LIGHTNINGROD],
		:HiddenAbilities => :MINUS,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 59,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CRUNCH,:CURSE,:DISCHARGE,:EERIEIMPULSE,:ELECTROBALL,:FIREFANG,:FLAMEBURST,:HEADBUTT,:ICEFANG,:SHOCKWAVE,:SWIFT,:SWITCHEROO,:THUNDERFANG,:UPROAR,],
		:Moveset => [
			[1,:TACKLE],
			[1,:THUNDERWAVE],
			[4,:LEER],
			[7,:HOWL],
			[10,:QUICKATTACK],
			[13,:SPARK],
			[16,:ODORSLEUTH],
			[19,:THUNDERFANG],
			[24,:BITE],
			[29,:DISCHARGE],
			[34,:ROAR],
			[39,:WILDCHARGE],
			[44,:CHARGE],
			[49,:THUNDER]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:CHARGEBEAM,:CRUNCH,:DOUBLEEDGE,:EERIEIMPULSE,:ELECTROBALL,:FIREFANG,:FLAMETHROWER,:FLASH,:HEADBUTT,:ICEFANG,:IRONTAIL,:LIGHTSCREEN,:MAGNETRISE,:MIMIC,:MUDSLAP,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROAR,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SWIFT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 152,
		:kind => "Lightning",
		:dexentry => "It generates electricity using friction from the atmosphere. In seasons with especially arid air, its entire body blazes with violent showers of sparks.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MANECTRIC,:Level,26]
		]
	},

	:OnCreation => {},
},

:MANECTRIC => {
	"Normal Form" => {
		:name => "Manectric",
		:dexnum => 310,
		:Type1 => :ELECTRIC,
		:BaseStats => [70, 75, 60, 105, 60, 105],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:STATIC, :LIGHTNINGROD],
		:HiddenAbilities => :MINUS,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 166,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :ELECTRIKE,
			:form => 0
		},
		:Moveset => [
			[1,:ELECTRICTERRAIN],
			[1,:FIREFANG],
			[1,:TACKLE],
			[1,:THUNDERWAVE],
			[1,:LEER],
			[1,:HOWL],
			[4,:LEER],
			[7,:HOWL],
			[10,:QUICKATTACK],
			[13,:SPARK],
			[16,:ODORSLEUTH],
			[19,:THUNDERFANG],
			[24,:BITE],
			[30,:DISCHARGE],
			[36,:ROAR],
			[42,:WILDCHARGE],
			[48,:CHARGE],
			[54,:THUNDER],
			[60,:ELECTRICTERRAIN]],
		:compatiblemoves => [:AGILITY,:BODYSLAM,:CHARGEBEAM,:CRUNCH,:DOUBLEEDGE,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:FIREFANG,:FLAMETHROWER,:FLASH,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:HYPERVOICE,:ICEFANG,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MIMIC,:MUDSLAP,:OVERHEAT,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROAR,:SCARYFACE,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SWIFT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWMIST,:SHADOWEND,:SHADOWSKY,],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 15,
		:Weight => 402,
		:kind => "Discharge",
		:dexentry => "Because lightning falls in their vicinities, Manectric were thought to have been born from lightning. In battle, they create thunderclouds.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [70, 75, 80, 135, 80, 135],
		:Abilities => [:INTIMIDATE],
		:Weight => 440,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:MANECTITE => 1,
	},
},

:PLUSLE => {
	"Normal Form" => {
		:name => "Plusle",
		:dexnum => 311,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 50, 40, 85, 75, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:PLUS, :LIGHTNINGROD],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CHARM,:DISCHARGE,:FAKETEARS,:LUCKYCHANT,:SING,:SWEETKISS,:TEARFULLOOK,:WISH,],
		:Moveset => [
			[1,:NUZZLE],
			[1,:PLAYNICE],
			[1,:GROWL],
			[1,:THUNDERWAVE],
			[1,:QUICKATTACK],
			[4,:HELPINGHAND],
			[7,:SPARK],
			[10,:ENCORE],
			[13,:BESTOW],
			[16,:SWIFT],
			[19,:ELECTROBALL],
			[22,:COPYCAT],
			[25,:CHARM],
			[28,:CHARGE],
			[31,:DISCHARGE],
			[34,:BATONPASS],
			[37,:AGILITY],
			[40,:LASTRESORT],
			[43,:THUNDER],
			[46,:NASTYPLOT],
			[49,:ENTRAINMENT]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BODYSLAM,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ECHOEDVOICE,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:ENCORE,:FLASH,:FLING,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:NASTYPLOT,:PLAYROUGH,:POWERSWAP,:RAINDANCE,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SWIFT,:TERRAINPULSE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy],
		:Height => 4,
		:Weight => 42,
		:WildItemUncommon => :CELLBATTERY,
		:kind => "Cheering",
		:dexentry => "It has the trait of cheering on its fellow Pokémon. By shorting out the electricity it releases from its paws, it creates pom-poms for cheering.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MINUN => {
	"Normal Form" => {
		:name => "Minun",
		:dexnum => 312,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 40, 50, 75, 85, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:MINUS, :VOLTABSORB],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CHARM,:DISCHARGE,:FAKETEARS,:LUCKYCHANT,:SING,:SWEETKISS,:TEARFULLOOK,:WISH,],
		:Moveset => [
			[1,:NUZZLE],
			[1,:PLAYNICE],
			[1,:GROWL],
			[1,:THUNDERWAVE],
			[1,:QUICKATTACK],
			[4,:HELPINGHAND],
			[7,:SPARK],
			[10,:ENCORE],
			[13,:SWITCHEROO],
			[16,:SWIFT],
			[19,:ELECTROBALL],
			[22,:COPYCAT],
			[25,:FAKETEARS],
			[28,:CHARGE],
			[31,:DISCHARGE],
			[34,:BATONPASS],
			[37,:AGILITY],
			[40,:TRUMPCARD],
			[43,:THUNDER],
			[46,:NASTYPLOT],
			[49,:ENTRAINMENT]],
		:compatiblemoves => [:AGILITY,:BATONPASS,:BODYSLAM,:CHARGEBEAM,:COUNTER,:COVET,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DYNAMICPUNCH,:ECHOEDVOICE,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:ENCORE,:FAKETEARS,:FLASH,:FLING,:GRASSKNOT,:GUARDSWAP,:HEADBUTT,:HELPINGHAND,:HEX,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NASTYPLOT,:PLAYROUGH,:RAINDANCE,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SWIFT,:TERRAINPULSE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Yellow",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy],
		:Height => 4,
		:Weight => 42,
		:WildItemUncommon => :CELLBATTERY,
		:kind => "Cheering",
		:dexentry => "At a meeting of Pokémon academics, it was announced that simultaneous exposure to electricity from a Minun will promote circulation and boost vitality.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:VOLBEAT => {
	"Normal Form" => {
		:name => "Volbeat",
		:dexnum => 313,
		:Type1 => :BUG,
		:BaseStats => [65, 73, 75, 47, 85, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:ILLUMINATE, :SWARM],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :Erratic,
		:GenderRatio => :FemZero,
		:BaseEXP => 151,
		:CatchRate => 150,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:BATONPASS,:BUGBUZZ,:DIZZYPUNCH,:ENCORE,:LUNGE,:SEISMICTOSS,:SILVERWIND,:TRICK,],
		:Moveset => [
			[1,:FLASH],
			[1,:TACKLE],
			[5,:DOUBLETEAM],
			[8,:CONFUSERAY],
			[12,:QUICKATTACK],
			[15,:STRUGGLEBUG],
			[19,:MOONLIGHT],
			[22,:TAILGLOW],
			[26,:SIGNALBEAM],
			[29,:PROTECT],
			[33,:ZENHEADBUTT],
			[36,:HELPINGHAND],
			[40,:BUGBUZZ],
			[43,:PLAYROUGH],
			[47,:DOUBLEEDGE],
			[50,:INFESTATION]],
		:compatiblemoves => [:AIRSLASH,:DRAININGKISS,:FAKETEARS,:MAGICALLEAF,:POLLENPUFF,:POWERGEM,:SKITTERSMACK,:BATONPASS,:DOUBLEEDGE,:MIMIC,:ACROBATICS,:AERIALACE,:AIRCUTTER,:BODYSLAM,:BRICKBREAK,:BUGBITE,:BUGBUZZ,:CHARGEBEAM,:COUNTER,:DAZZLINGGLEAM,:DEFOG,:DYNAMICPUNCH,:ENCORE,:FLASH,:FLING,:FOCUSPUNCH,:GIGADRAIN,:HELPINGHAND,:ICEPUNCH,:INFESTATION,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MUDSLAP,:OMINOUSWIND,:PLAYROUGH,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:ROOST,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SILVERWIND,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRICK,:UTURN,:WATERPULSE,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Forest",
		:EggGroups => [:Bug, :HumanLike],
		:Height => 7,
		:Weight => 177,
		:WildItemUncommon => :BRIGHTPOWDER,
		:kind => "Firefly",
		:dexentry => "With their taillights lit, Volbeat fly in a swarm, drawing geometric designs in the night sky. They move their nests if their pond water becomes dirty.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:ILLUMISE => {
	"Normal Form" => {
		:name => "Illumise",
		:dexnum => 314,
		:Type1 => :BUG,
		:BaseStats => [65, 47, 75, 73, 85, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:OBLIVIOUS, :TINTEDLENS],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :MaleZero,
		:BaseEXP => 151,
		:CatchRate => 150,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AROMATHERAPY,:BATONPASS,:BUGBUZZ,:CAPTIVATE,:CONFUSERAY,:ENCORE,:FAKETEARS,:GROWTH,:SILVERWIND,],
		:Moveset => [
			[1,:PLAYNICE],
			[1,:TACKLE],
			[5,:SWEETSCENT],
			[9,:CHARM],
			[12,:QUICKATTACK],
			[15,:STRUGGLEBUG],
			[19,:MOONLIGHT],
			[22,:WISH],
			[26,:ENCORE],
			[29,:FLATTER],
			[33,:ZENHEADBUTT],
			[36,:HELPINGHAND],
			[40,:BUGBUZZ],
			[43,:PLAYROUGH],
			[47,:COVET],
			[50,:INFESTATION]],
		:compatiblemoves => [:AIRSLASH,:DRAININGKISS,:FAKETEARS,:MAGICALLEAF,:POLLENPUFF,:POWERGEM,:SKITTERSMACK,:BATONPASS,:DOUBLEEDGE,:MIMIC,:ACROBATICS,:AERIALACE,:AIRCUTTER,:BODYSLAM,:BRICKBREAK,:BUGBITE,:BUGBUZZ,:CHARGEBEAM,:CHARM,:COUNTER,:COVET,:DAZZLINGGLEAM,:DEFOG,:DYNAMICPUNCH,:ENCORE,:FLASH,:FLING,:FOCUSPUNCH,:GIGADRAIN,:HELPINGHAND,:ICEPUNCH,:INFESTATION,:LIGHTSCREEN,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:OMINOUSWIND,:PLAYROUGH,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:ROOST,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SILVERWIND,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UTURN,:WATERPULSE,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Forest",
		:EggGroups => [:Bug, :HumanLike],
		:Height => 6,
		:Weight => 177,
		:WildItemUncommon => :BRIGHTPOWDER,
		:kind => "Firefly",
		:dexentry => "A nocturnal Pokémon that becomes active upon nightfall. It leads Volbeat swarms to draw patterns in the sky. Over 200 different patterns have been seen.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:ROSELIA => {
	"Normal Form" => {
		:name => "Roselia",
		:dexnum => 315,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [50, 60, 45, 100, 80, 65],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:NATURALCURE, :POISONPOINT],
		:HiddenAbilities => :LEAFGUARD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 140,
		:CatchRate => 150,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BULLETSEED,:COTTONSPORE,:GIGADRAIN,:GRASSWHISTLE,:LEAFSTORM,:MINDREADER,:NATURALGIFT,:PINMISSILE,:POWERWHIP,:RAZORLEAF,:SEEDBOMB,:SLEEPPOWDER,:SPIKES,:SYNTHESIS,],
		:preevo => {
			:species => :BUDEW,
			:form => 0
		},
		:Moveset => [
			[1,:ABSORB],
			[4,:GROWTH],
			[7,:POISONSTING],
			[10,:STUNSPORE],
			[13,:MEGADRAIN],
			[16,:LEECHSEED],
			[19,:MAGICALLEAF],
			[22,:GRASSWHISTLE],
			[25,:GIGADRAIN],
			[28,:TOXICSPIKES],
			[31,:SWEETSCENT],
			[34,:INGRAIN],
			[37,:PETALBLIZZARD],
			[40,:TOXIC],
			[43,:AROMATHERAPY],
			[46,:SYNTHESIS],
			[50,:PETALDANCE]],
		:compatiblemoves => [:BODYSLAM,:BULLETSEED,:COVET,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:LEAFSTORM,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:NIGHTMARE,:PINMISSILE,:POISONJAB,:POWERWHIP,:PSYCHUP,:RAINDANCE,:SEEDBOMB,:SHADOWBALL,:SLUDGEBOMB,:SOLARBEAM,:SPIKES,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:TOXICSPIKES,:UPROAR,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWSHED,],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy, :Grass],
		:Height => 3,
		:Weight => 20,
		:WildItemUncommon => :POISONBARB,
		:kind => "Thorn",
		:dexentry => "A Roselia that drinks nutritionally rich springwater blooms with lovely flowers. The fragrance of its flowers has the effect of making its foes careless.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ROSERADE,:Item,:SHINYSTONE]
		]
	},

	:OnCreation => {},
},

:GULPIN => {
	"Normal Form" => {
		:name => "Gulpin",
		:dexnum => 316,
		:Type1 => :POISON,
		:BaseStats => [70, 43, 53, 43, 53, 40],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:LIQUIDOOZE, :STICKYHOLD],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDARMOR,:CURSE,:DESTINYBOND,:GUNKSHOT,:MUDSLAP,:PAINSPLIT,:SMOG,:VENOMDRENCH,],
		:Moveset => [
			[1,:POUND],
			[5,:YAWN],
			[8,:POISONGAS],
			[10,:SLUDGE],
			[12,:AMNESIA],
			[17,:ACIDSPRAY],
			[20,:ENCORE],
			[25,:TOXIC],
			[28,:STOCKPILE],
			[28,:SPITUP],
			[28,:SWALLOW],
			[33,:SLUDGEBOMB],
			[36,:GASTROACID],
			[41,:BELCH],
			[44,:WRINGOUT],
			[49,:GUNKSHOT]],
		:compatiblemoves => [:AMNESIA,:BODYSLAM,:BULLETSEED,:CORROSIVEGAS,:COUNTER,:CRUNCH,:DEFENSECURL,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:ENCORE,:EXPLOSION,:FIREPUNCH,:GASTROACID,:GIGADRAIN,:GUNKSHOT,:HEADBUTT,:ICEBEAM,:ICEPUNCH,:INFESTATION,:MIMIC,:MUDSHOT,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:THUNDERPUNCH,:VENOSHOCK,:WATERPULSE,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWHOLD,],
		:Color => "Green",
		:Habitat => "Grassland",
		:EggGroups => [:Amorphous],
		:Height => 4,
		:Weight => 103,
		:WildItemCommon => :ORANBERRY,
		:WildItemUncommon => :SITRUSBERRY,
		:kind => "Stomach",
		:dexentry => "This Pokémon's stomach fluid can even digest scrap iron. In one gulp, it can swallow something that is as large as itself.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SWALOT,:Level,26]
		]
	},

	:OnCreation => {},
},

:SWALOT => {
	"Normal Form" => {
		:name => "Swalot",
		:dexnum => 317,
		:Type1 => :POISON,
		:BaseStats => [100, 73, 83, 73, 83, 55],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:LIQUIDOOZE, :STICKYHOLD],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 163,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GULPIN,
			:form => 0
		},
		:Moveset => [
			[0,:BODYSLAM],
			[1,:VENOMDRENCH],
			[1,:GUNKSHOT],
			[1,:WRINGOUT],
			[1,:POUND],
			[1,:YAWN],
			[1,:POISONGAS],
			[1,:SLUDGE],
			[5,:YAWN],
			[8,:POISONGAS],
			[10,:SLUDGE],
			[12,:AMNESIA],
			[17,:ACIDSPRAY],
			[20,:ENCORE],
			[25,:TOXIC],
			[30,:STOCKPILE],
			[30,:SPITUP],
			[30,:SWALLOW],
			[37,:SLUDGEBOMB],
			[42,:GASTROACID],
			[49,:BELCH],
			[54,:WRINGOUT],
			[61,:GUNKSHOT]],
		:compatiblemoves => [:AMNESIA,:BLOCK,:BODYPRESS,:BODYSLAM,:BULLDOZE,:BULLETSEED,:CORROSIVEGAS,:COUNTER,:CRUNCH,:DEFENSECURL,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:ENCORE,:EXPLOSION,:FIREPUNCH,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:INFESTATION,:MIMIC,:MUDSHOT,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:ROLLOUT,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:TERRAINPULSE,:THUNDERPUNCH,:VENOSHOCK,:WATERPULSE,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Grassland",
		:EggGroups => [:Amorphous],
		:Height => 17,
		:Weight => 800,
		:WildItemCommon => :ORANBERRY,
		:WildItemUncommon => :SITRUSBERRY,
		:kind => "Poison Bag",
		:dexentry => "Its powerful stomach acid is capable of digesting almost anything. The one thing in the whole world a Swalot can't digest is its own stomach.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CARVANHA => {
	"Normal Form" => {
		:name => "Carvanha",
		:dexnum => 318,
		:Type1 => :WATER,
		:Type2 => :DARK,
		:BaseStats => [45, 90, 20, 65, 20, 65],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:ROUGHSKIN, :SPEEDBOOST],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 61,
		:CatchRate => 225,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:BRINE,:DESTINYBOND,:DOUBLEEDGE,:HYDROPUMP,:PSYCHICFANGS,:SWIFT,:THRASH,],
		:Moveset => [
			[1,:LEER],
			[1,:BITE],
			[4,:RAGE],
			[8,:FOCUSENERGY],
			[11,:AQUAJET],
			[15,:ASSURANCE],
			[18,:SCREECH],
			[22,:SWAGGER],
			[25,:ICEFANG],
			[29,:SCARYFACE],
			[32,:POISONFANG],
			[36,:CRUNCH],
			[39,:AGILITY],
			[43,:TAKEDOWN]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BLIZZARD,:BOUNCE,:BRINE,:CRUNCH,:DARKPULSE,:DIVE,:DOUBLEEDGE,:FLIPTURN,:FURYCUTTER,:HAIL,:HYDROPUMP,:ICEBEAM,:ICEFANG,:ICYWIND,:LIQUIDATION,:MIMIC,:MUDSLAP,:PAYBACK,:PSYCHICFANGS,:RAINDANCE,:RETALIATE,:SCALD,:SCALESHOT,:SCARYFACE,:SCREECH,:SNARL,:SPITE,:SUPERFANG,:SURF,:SWIFT,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWHOLD,],
		:Color => "Red",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 8,
		:Weight => 208,
		:WildItemUncommon => :DEEPSEATOOTH,
		:kind => "Savage",
		:dexentry => "Carvanha attack ships in swarms, making them sink. Although it is said to be a very vicious Pokémon, it timidly flees as soon as it finds itself alone.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 10,
		:evolutions => [
			[:SHARPEDO,:Level,30]
		]
	},

	:OnCreation => {},
},

:SHARPEDO => {
	"Normal Form" => {
		:name => "Sharpedo",
		:dexnum => 319,
		:Type1 => :WATER,
		:Type2 => :DARK,
		:BaseStats => [70, 120, 40, 95, 40, 95],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:ROUGHSKIN, :SPEEDBOOST],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 60,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :CARVANHA,
			:form => 0
		},
		:Moveset => [
			[0,:SLASH],
			[1,:NIGHTSLASH],
			[1,:FEINT],
			[1,:LEER],
			[1,:BITE],
			[1,:RAGE],
			[1,:FOCUSENERGY],
			[4,:RAGE],
			[8,:FOCUSENERGY],
			[11,:AQUAJET],
			[15,:ASSURANCE],
			[18,:SCREECH],
			[22,:SWAGGER],
			[25,:ICEFANG],
			[29,:SCARYFACE],
			[34,:POISONFANG],
			[40,:CRUNCH],
			[45,:AGILITY],
			[51,:SKULLBASH],
			[56,:TAUNT],
			[62,:NIGHTSLASH]],
		:compatiblemoves => [:AGILITY,:ANCIENTPOWER,:ASSURANCE,:AVALANCHE,:BLIZZARD,:BOUNCE,:BRINE,:BULLDOZE,:CLOSECOMBAT,:CRUNCH,:DARKPULSE,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:FLIPTURN,:FOCUSENERGY,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:LIQUIDATION,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:PSYCHICFANGS,:RAINDANCE,:RETALIATE,:ROAR,:ROCKSMASH,:ROCKTOMB,:SCALD,:SCALESHOT,:SCARYFACE,:SCREECH,:SNARL,:SPITE,:STRENGTH,:SUPERFANG,:SURF,:SWIFT,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 18,
		:Weight => 888,
		:WildItemUncommon => :DEEPSEATOOTH,
		:kind => "Brutal",
		:dexentry => "The vicious and sly gangster of the sea. Its skin is specially textured to minimize drag in water. Its speed tops out at over 75 miles per hour.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 8,
	},

	"Mega Form" => {
		:BaseStats => [70, 140, 70, 110, 65, 105],
		:Abilities => [:STRONGJAW],
		:Height => 25,
		:Weight => 1303,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SHARPEDONITE => 1,
	},
},

:WAILMER => {
	"Normal Form" => {
		:name => "Wailmer",
		:dexnum => 320,
		:Type1 => :WATER,
		:BaseStats => [130, 70, 35, 70, 35, 60],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:WATERVEIL, :OBLIVIOUS],
		:HiddenAbilities => :PRESSURE,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 80,
		:CatchRate => 125,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:AQUARING,:BODYSLAM,:CLEARSMOG,:CURSE,:DEFENSECURL,:DOUBLEEDGE,:FISSURE,:SLEEPTALK,:SNORE,:SOAK,:THRASH,:TICKLE,:ZENHEADBUTT,],
		:Moveset => [
			[1,:SPLASH],
			[4,:GROWL],
			[7,:WATERGUN],
			[10,:ROLLOUT],
			[13,:WHIRLPOOL],
			[16,:ASTONISH],
			[19,:WATERPULSE],
			[22,:MIST],
			[25,:BRINE],
			[29,:REST],
			[33,:WATERSPOUT],
			[37,:AMNESIA],
			[41,:DIVE],
			[45,:BOUNCE],
			[49,:HYDROPUMP],
			[53,:HEAVYSLAM]],
		:compatiblemoves => [:AMNESIA,:AVALANCHE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRINE,:BULLDOZE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:ECHOEDVOICE,:HAIL,:HEADBUTT,:HEAVYSLAM,:HYDROPUMP,:HYPERVOICE,:ICEBEAM,:ICYWIND,:MIMIC,:RAINDANCE,:ROAR,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SELFDESTRUCT,:STEELROLLER,:STRENGTH,:SURF,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Field, :Water2],
		:Height => 20,
		:Weight => 1300,
		:kind => "Ball Whale",
		:dexentry => "While this Pokémon usually lives in the sea, it can survive on land, although not too long. It loses vitality if its body becomes dried out.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WAILORD,:Level,40]
		]
	},

	:OnCreation => {},
},

:WAILORD => {
	"Normal Form" => {
		:name => "Wailord",
		:dexnum => 321,
		:Type1 => :WATER,
		:BaseStats => [170, 90, 45, 90, 45, 60],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:WATERVEIL, :OBLIVIOUS],
		:HiddenAbilities => :PRESSURE,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 10455,
		:preevo => {
			:species => :WAILMER,
			:form => 0
		},
		:Moveset => [
			[1,:SOAK],
			[1,:NOBLEROAR],
			[1,:HEAVYSLAM],
			[1,:SPLASH],
			[1,:GROWL],
			[1,:WATERGUN],
			[1,:ROLLOUT],
			[4,:GROWL],
			[7,:WATERGUN],
			[10,:ROLLOUT],
			[13,:WHIRLPOOL],
			[16,:ASTONISH],
			[19,:WATERPULSE],
			[22,:MIST],
			[25,:BRINE],
			[29,:REST],
			[33,:WATERSPOUT],
			[37,:AMNESIA],
			[44,:DIVE],
			[51,:BOUNCE],
			[58,:HYDROPUMP],
			[65,:HEAVYSLAM]],
		:compatiblemoves => [:AMNESIA,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRINE,:BULLDOZE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:ECHOEDVOICE,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEAVYSLAM,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:IRONHEAD,:LIQUIDATION,:MIMIC,:RAINDANCE,:ROAR,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCALD,:SELFDESTRUCT,:STEELROLLER,:STRENGTH,:SURF,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Field, :Water2],
		:Height => 145,
		:Weight => 3980,
		:kind => "Float Whale",
		:dexentry => "It breathes through nostrils that it raises above the sea. By inhaling to its maximum capacity, a Wailord can dive close to 10,000 feet beneath the waves.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:NUMEL => {
	"Normal Form" => {
		:name => "Numel",
		:dexnum => 322,
		:Type1 => :FIRE,
		:Type2 => :GROUND,
		:BaseStats => [60, 60, 40, 65, 45, 35],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:OBLIVIOUS, :SIMPLE],
		:HiddenAbilities => :OWNTEMPO,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 61,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ANCIENTPOWER,:BODYSLAM,:DEFENSECURL,:ENDURE,:GROWTH,:HEATWAVE,:HEAVYSLAM,:HOWL,:IRONHEAD,:MUDBOMB,:ROLLOUT,:SCARYFACE,:SPITUP,:STOCKPILE,:STOMP,:SWALLOW,:YAWN,],
		:Moveset => [
			[1,:GROWL],
			[1,:TACKLE],
			[5,:EMBER],
			[8,:FOCUSENERGY],
			[12,:MAGNITUDE],
			[15,:FLAMEBURST],
			[19,:AMNESIA],
			[22,:LAVAPLUME],
			[26,:EARTHPOWER],
			[29,:CURSE],
			[31,:TAKEDOWN],
			[36,:YAWN],
			[40,:EARTHQUAKE],
			[43,:FLAMETHROWER],
			[47,:DOUBLEEDGE]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BODYSLAM,:BULLDOZE,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FOCUSENERGY,:HEADBUTT,:HEATCRASH,:HEATWAVE,:IRONHEAD,:MIMIC,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:OVERHEAT,:POWERGEM,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:TERRAINPULSE,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBLITZ,:SHADOWSHED,],
		:Color => "Yellow",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 7,
		:Weight => 240,
		:kind => "Numb",
		:dexentry => "It stores boiling magma in the hump on its back. Numel is a hardy Pokémon that can transport a 220-pound load. It has served humans at work since long ago.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CAMERUPT,:Level,33]
		]
	},

	:OnCreation => {},
},

:CAMERUPT => {
	"Normal Form" => {
		:name => "Camerupt",
		:dexnum => 323,
		:Type1 => :FIRE,
		:Type2 => :GROUND,
		:BaseStats => [70, 100, 70, 105, 75, 40],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:MAGMAARMOR, :SOLIDROCK],
		:HiddenAbilities => :ANGERPOINT,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 150,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NUMEL,
			:form => 0
		},
		:Moveset => [
			[0,:ROCKSLIDE],
			[1,:FISSURE],
			[1,:ERUPTION],
			[1,:GROWL],
			[1,:TACKLE],
			[1,:EMBER],
			[1,:FOCUSENERGY],
			[8,:EMBER],
			[8,:FOCUSENERGY],
			[12,:MAGNITUDE],
			[15,:FLAMEBURST],
			[19,:AMNESIA],
			[22,:LAVAPLUME],
			[26,:EARTHPOWER],
			[29,:CURSE],
			[31,:TAKEDOWN],
			[39,:YAWN],
			[46,:EARTHQUAKE],
			[52,:ERUPTION],
			[59,:FISSURE]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BODYPRESS,:BODYSLAM,:BULLDOZE,:BURNINGJEALOUSY,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:EXPLOSION,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLASHCANNON,:FOCUSENERGY,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HYPERBEAM,:IRONHEAD,:MIMIC,:MUDSHOT,:MUDSLAP,:NATUREPOWER,:OVERHEAT,:POWERGEM,:ROAR,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCORCHINGSANDS,:SELFDESTRUCT,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TERRAINPULSE,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 19,
		:Weight => 2200,
		:kind => "Eruption",
		:dexentry => "A Pokémon that lives in the crater of a volcano. Every 10 years, the volcanoes on its back erupt violently. Research is under way on the cause of eruption.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [70, 120, 100, 145, 105, 20],
		:Abilities => [:SHEERFORCE],
		:Height => 25,
		:Weight => 3205,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:CAMERUPTITE => 1,
	},
},

:TORKOAL => {
	"Normal Form" => {
		:name => "Torkoal",
		:dexnum => 324,
		:Type1 => :FIRE,
		:BaseStats => [70, 85, 140, 85, 70, 20],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:WHITESMOKE, :DROUGHT],
		:HiddenAbilities => :SHELLARMOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 165,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CLEARSMOG,:ENDURE,:ERUPTION,:FISSURE,:FLAMEBURST,:SKULLBASH,:SLEEPTALK,:SUPERPOWER,:YAWN,],
		:Moveset => [
			[1,:EMBER],
			[4,:SMOG],
			[7,:WITHDRAW],
			[10,:RAPIDSPIN],
			[13,:FIRESPIN],
			[15,:SMOKESCREEN],
			[18,:FLAMEWHEEL],
			[22,:CURSE],
			[25,:LAVAPLUME],
			[27,:BODYSLAM],
			[30,:PROTECT],
			[34,:FLAMETHROWER],
			[38,:IRONDEFENSE],
			[40,:AMNESIA],
			[42,:FLAIL],
			[45,:HEATWAVE],
			[47,:SHELLSMASH],
			[50,:INFERNO]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BODYPRESS,:BODYSLAM,:BULLDOZE,:BURNINGJEALOUSY,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HYPERBEAM,:INCINERATE,:IRONDEFENSE,:IRONTAIL,:MIMIC,:MUDSLAP,:NATUREPOWER,:OVERHEAT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCORCHINGSANDS,:SELFDESTRUCT,:SLUDGEBOMB,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 804,
		:WildItemUncommon => :CHARCOAL,
		:kind => "Coal",
		:dexentry => "It battles using energy it gets from burning coal. When loosing smoke from its nostrils, it lets off a sound that is similar to a locomotive's horn.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SPOINK => {
	"Normal Form" => {
		:name => "Spoink",
		:dexnum => 325,
		:Type1 => :PSYCHIC,
		:BaseStats => [60, 25, 35, 70, 80, 60],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:THICKFAT, :OWNTEMPO],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:ENDURE,:EXTRASENSORY,:FUTURESIGHT,:LUCKYCHANT,:MIRRORCOAT,:SIMPLEBEAM,:SKILLSWAP,:TRICK,:WHIRLWIND,:ZENHEADBUTT,],
		:Moveset => [
			[1,:SPLASH],
			[7,:PSYWAVE],
			[10,:ODORSLEUTH],
			[14,:PSYBEAM],
			[15,:PSYCHUP],
			[18,:CONFUSERAY],
			[21,:MAGICCOAT],
			[26,:ZENHEADBUTT],
			[29,:POWERGEM],
			[29,:REST],
			[33,:SNORE],
			[38,:PSYSHOCK],
			[40,:PAYBACK],
			[44,:PSYCHIC],
			[50,:BOUNCE]],
		:compatiblemoves => [:ALLYSWITCH,:AMNESIA,:BOUNCE,:CALMMIND,:CHARGEBEAM,:COVET,:DOUBLEEDGE,:DREAMEATER,:FLASH,:GRASSKNOT,:HEADBUTT,:HEALBELL,:ICYWIND,:IRONTAIL,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:MUDSHOT,:PAYBACK,:POWERGEM,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 7,
		:Weight => 306,
		:kind => "Bounce",
		:dexentry => "A Pokémon that manipulates psychic power at will. It doesn't stop bouncing even when it is asleep. It loves eating mushrooms that grow underground.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GRUMPIG,:Level,32]
		]
	},

	:OnCreation => {},
},

:GRUMPIG => {
	"Normal Form" => {
		:name => "Grumpig",
		:dexnum => 326,
		:Type1 => :PSYCHIC,
		:BaseStats => [80, 45, 65, 90, 110, 80],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:THICKFAT, :OWNTEMPO],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 165,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SPOINK,
			:form => 0
		},
		:Moveset => [
			[0,:TEETERDANCE],
			[1,:BELCH],
			[1,:SPLASH],
			[1,:PSYWAVE],
			[1,:ODORSLEUTH],
			[1,:PSYBEAM],
			[7,:PSYWAVE],
			[10,:ODORSLEUTH],
			[14,:PSYBEAM],
			[15,:PSYCHUP],
			[18,:CONFUSERAY],
			[21,:MAGICCOAT],
			[26,:ZENHEADBUTT],
			[29,:POWERGEM],
			[35,:REST],
			[35,:SNORE],
			[42,:PSYSHOCK],
			[46,:PAYBACK],
			[52,:PSYCHIC],
			[60,:BOUNCE]],
		:compatiblemoves => [:ALLYSWITCH,:AMNESIA,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRICKBREAK,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COUNTER,:COVET,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POWERGEM,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 715,
		:kind => "Manipulate",
		:dexentry => "Grumpig uses the black pearls on its body to amplify its psychic power for gaining total control over its foe. Its snorting grows labored when doing so.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SPINDA => {
	"Normal Form" => {
		:name => "Spinda",
		:dexnum => 327,
		:Type1 => :NORMAL,
		:BaseStats => [60, 60, 60, 60, 60, 60],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:OWNTEMPO, :TANGLEDFEET],
		:HiddenAbilities => :CONTRARY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 126,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ASSIST,:BATONPASS,:DISABLE,:ENCORE,:FAKEOUT,:FAKETEARS,:GUARDSPLIT,:ICYWIND,:PSYCHOCUT,:PSYCHOSHIFT,:RAPIDSPIN,:ROLEPLAY,:SMELLINGSALTS,:SPOTLIGHT,:TRICK,:WATERPULSE,:WISH,],
		:Moveset => [
			[1,:TACKLE],
			[5,:COPYCAT],
			[10,:FEINTATTACK],
			[14,:PSYBEAM],
			[19,:HYPNOSIS],
			[23,:DIZZYPUNCH],
			[28,:SUCKERPUNCH],
			[32,:TEETERDANCE],
			[37,:UPROAR],
			[41,:PSYCHUP],
			[46,:DOUBLEEDGE],
			[50,:FLAIL],
			[55,:THRASH]],
		:compatiblemoves => [:AGILITY,:AMNESIA,:BEATUP,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:CALMMIND,:CHARM,:CLOSECOMBAT,:COUNTER,:COVET,:DARKESTLARIAT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONDANCE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENCORE,:FAKETEARS,:FIREFANG,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:HEADBUTT,:HELPINGHAND,:HIGHHORSEPOWER,:HYPERVOICE,:ICEFANG,:ICEPUNCH,:ICYWIND,:LASHOUT,:LASTRESORT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSHOT,:MUDSLAP,:NIGHTMARE,:PAYDAY,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RECYCLE,:RETALIATE,:REVENGE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SKITTERSMACK,:SNATCH,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TERRAINPULSE,:THIEF,:THUNDERFANG,:THUNDERPUNCH,:TRICK,:TRICKROOM,:UPROAR,:WATERPULSE,:WILDCHARGE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "Mountain",
		:EggGroups => [:Field, :HumanLike],
		:Height => 11,
		:Weight => 50,
		:kind => "Spot Panda",
		:dexentry => "It is distinguished by a pattern of spots that is always different. Its unsteady, tottering walk has the effect of fouling its foe's aim.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TRAPINCH => {
	"Normal Form" => {
		:name => "Trapinch",
		:dexnum => 328,
		:Type1 => :GROUND,
		:BaseStats => [45, 100, 45, 45, 45, 10],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :ARENATRAP],
		:HiddenAbilities => :SHEERFORCE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BUGBITE,:EARTHPOWER,:ENDURE,:FLAIL,:FOCUSENERGY,:FURYCUTTER,:GUST,:MUDSHOT,:QUICKATTACK,:SIGNALBEAM,],
		:Moveset => [
			[1,:SANDATTACK],
			[1,:BITE],
			[1,:FEINTATTACK],
			[1,:BIDE],
			[5,:MUDSLAP],
			[8,:BULLDOZE],
			[12,:SANDTOMB],
			[15,:ROCKSLIDE],
			[19,:DIG],
			[22,:CRUNCH],
			[26,:EARTHPOWER],
			[29,:FEINT],
			[33,:EARTHQUAKE],
			[36,:SANDSTORM],
			[40,:SUPERPOWER],
			[43,:HYPERBEAM],
			[47,:FISSURE]],
		:compatiblemoves => [:BODYSLAM,:BUGBITE,:BULLDOZE,:CRUNCH,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:FOCUSENERGY,:FURYCUTTER,:GIGADRAIN,:HEADBUTT,:HYPERBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SIGNALBEAM,:SOLARBEAM,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SUPERPOWER,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Bug],
		:Height => 7,
		:Weight => 150,
		:WildItemUncommon => :SOFTSAND,
		:kind => "Ant Pit",
		:dexentry => "Its big jaws crunch through boulders. Because its head is so big, it has a hard time getting back upright if it tips over onto its back.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:VIBRAVA,:Level,35]
		]
	},

	:OnCreation => {},
},

:VIBRAVA => {
	"Normal Form" => {
		:name => "Vibrava",
		:dexnum => 329,
		:Type1 => :GROUND,
		:Type2 => :DRAGON,
		:BaseStats => [50, 70, 50, 50, 50, 70],
		:EVs => [0, 1, 0, 0, 0, 1],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 119,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TRAPINCH,
			:form => 0
		},
		:Moveset => [
			[0,:DRAGONBREATH],
			[1,:SANDATTACK],
			[1,:SONICBOOM],
			[1,:FEINTATTACK],
			[1,:BIDE],
			[5,:MUDSLAP],
			[8,:BULLDOZE],
			[12,:SANDTOMB],
			[15,:ROCKSLIDE],
			[19,:SUPERSONIC],
			[22,:SCREECH],
			[26,:EARTHPOWER],
			[29,:BUGBUZZ],
			[33,:EARTHQUAKE],
			[36,:SANDSTORM],
			[40,:UPROAR],
			[43,:HYPERBEAM],
			[47,:BOOMBURST]],
		:compatiblemoves => [:AIRCUTTER,:AIRSLASH,:BODYSLAM,:BUGBITE,:BUGBUZZ,:BULLDOZE,:CRUNCH,:DEFOG,:DIG,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONPULSE,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:FLY,:FOCUSENERGY,:FURYCUTTER,:GIGADRAIN,:HEADBUTT,:HEATWAVE,:HYPERBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SCREECH,:SIGNALBEAM,:SILVERWIND,:SOLARBEAM,:STEELWING,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAILWIND,:THROATCHOP,:TWISTER,:UTURN,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Bug],
		:Height => 11,
		:Weight => 153,
		:kind => "Vibration",
		:dexentry => "It looses ultrasonic waves by rubbing its wings together. Since a Vibrava's wings are still in the process of growing, it can only fly short distances.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 17,
		:evolutions => [
			[:FLYGON,:Level,45]
		]
	},

	:OnCreation => {},
},

:FLYGON => {
	"Normal Form" => {
		:name => "Flygon",
		:dexnum => 330,
		:Type1 => :GROUND,
		:Type2 => :DRAGON,
		:BaseStats => [80, 100, 80, 80, 80, 100],
		:EVs => [0, 1, 0, 0, 0, 2],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 234,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :VIBRAVA,
			:form => 0
		},
		:Moveset => [
			[0,:DRAGONCLAW],
			[1,:DRAGONBREATH],
			[1,:DRAGONDANCE],
			[1,:SANDATTACK],
			[1,:SONICBOOM],
			[1,:FEINTATTACK],
			[1,:BIDE],
			[5,:MUDSLAP],
			[8,:BULLDOZE],
			[12,:SANDTOMB],
			[15,:ROCKSLIDE],
			[19,:SUPERSONIC],
			[22,:SCREECH],
			[26,:EARTHPOWER],
			[29,:DRAGONTAIL],
			[33,:EARTHQUAKE],
			[36,:SANDSTORM],
			[40,:UPROAR],
			[43,:HYPERBEAM],
			[47,:DRAGONRUSH]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BUGBITE,:BUGBUZZ,:BULLDOZE,:CRUNCH,:DEFOG,:DIG,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMETHROWER,:FLY,:FOCUSENERGY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HONECLAWS,:HYPERBEAM,:INCINERATE,:IRONTAIL,:LASERFOCUS,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:POWERUPPUNCH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SANDTOMB,:SCALESHOT,:SCORCHINGSANDS,:SCREECH,:SIGNALBEAM,:SILVERWIND,:SOLARBEAM,:STEELWING,:STONEEDGE,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAILWIND,:THROATCHOP,:THUNDERPUNCH,:TWISTER,:UTURN,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Bug],
		:Height => 20,
		:Weight => 820,
		:kind => "Mystic",
		:dexentry => "The flapping of its wings sounds like singing. To prevent detection by enemies, it hides itself by flapping up a cloud of desert sand.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 9,
	},

	:OnCreation => {},
},

:CACNEA => {
	"Normal Form" => {
		:name => "Cacnea",
		:dexnum => 331,
		:Type1 => :GRASS,
		:BaseStats => [50, 85, 40, 85, 40, 35],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:SANDVEIL, :WATERABSORB],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 67,
		:CatchRate => 190,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:ACID,:BELCH,:BLOCK,:COUNTER,:DISABLE,:DYNAMICPUNCH,:FELLSTINGER,:GRASSWHISTLE,:LOWKICK,:MAGICALLEAF,:NASTYPLOT,:POWERUPPUNCH,:ROTOTILLER,:SEEDBOMB,:SMELLINGSALTS,:SWITCHEROO,:TEETERDANCE,:WORRYSEED,],
		:Moveset => [
			[1,:POISONSTING],
			[1,:LEER],
			[4,:ABSORB],
			[7,:GROWTH],
			[10,:LEECHSEED],
			[13,:SANDATTACK],
			[16,:NEEDLEARM],
			[19,:FEINTATTACK],
			[22,:INGRAIN],
			[26,:PAYBACK],
			[30,:SPIKES],
			[34,:SUCKERPUNCH],
			[38,:PINMISSILE],
			[42,:ENERGYBALL],
			[46,:COTTONSPORE],
			[50,:SANDSTORM],
			[54,:DESTINYBOND]],
		:compatiblemoves => [:ASSURANCE,:BLOCK,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:COUNTER,:CUT,:DARKPULSE,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:ENERGYBALL,:FLASH,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GIGADRAIN,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:LOWKICK,:MAGICALLEAF,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:NATUREPOWER,:PAYBACK,:PINMISSILE,:POISONJAB,:POWERUPPUNCH,:ROLEPLAY,:SANDSTORM,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:SPIKES,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:THUNDERPUNCH,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Grass, :HumanLike],
		:Height => 4,
		:Weight => 513,
		:WildItemUncommon => :STICKYBARB,
		:kind => "Cactus",
		:dexentry => "Cacnea live in deserts with virtually no rainfall. It battles by swinging its thick, spiked arms. Once a year, a yellow flower blooms.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CACTURNE,:Level,32]
		]
	},

	:OnCreation => {},
},

:CACTURNE => {
	"Normal Form" => {
		:name => "Cacturne",
		:dexnum => 332,
		:Type1 => :GRASS,
		:Type2 => :DARK,
		:BaseStats => [70, 115, 60, 115, 60, 55],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:SANDVEIL, :WATERABSORB],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 166,
		:CatchRate => 60,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :CACNEA,
			:form => 0
		},
		:Moveset => [
			[0,:SPIKYSHIELD],
			[1,:DESTINYBOND],
			[1,:REVENGE],
			[1,:POISONSTING],
			[1,:LEER],
			[1,:ABSORB],
			[1,:GROWTH],
			[4,:ABSORB],
			[7,:GROWTH],
			[10,:LEECHSEED],
			[13,:SANDATTACK],
			[16,:NEEDLEARM],
			[19,:FEINTATTACK],
			[22,:INGRAIN],
			[26,:PAYBACK],
			[30,:SPIKES],
			[35,:SUCKERPUNCH],
			[38,:PINMISSILE],
			[44,:ENERGYBALL],
			[49,:COTTONSPORE],
			[54,:SANDSTORM],
			[59,:DESTINYBOND]],
		:compatiblemoves => [:ASSURANCE,:BLOCK,:BODYSLAM,:BRICKBREAK,:BULLETSEED,:COUNTER,:CUT,:DARKPULSE,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:EMBARGO,:ENERGYBALL,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:LOWKICK,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:NATUREPOWER,:PAYBACK,:PINMISSILE,:POISONJAB,:POWERUPPUNCH,:RETALIATE,:ROLEPLAY,:SANDSTORM,:SCORCHINGSANDS,:SEEDBOMB,:SEISMICTOSS,:SOLARBEAM,:SPIKES,:SPITE,:STOMPINGTANTRUM,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:SYNTHESIS,:THUNDERPUNCH,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Grass, :HumanLike],
		:Height => 13,
		:Weight => 774,
		:WildItemUncommon => :STICKYBARB,
		:kind => "Scarecrow",
		:dexentry => "After spending thousands of years in harsh deserts, its blood transformed into the same substances as sand. It is nocturnal, so it hunts at night.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SWABLU => {
	"Normal Form" => {
		:name => "Swablu",
		:dexnum => 333,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [45, 40, 60, 40, 75, 50],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:NATURALCURE, :CLOUDNINE],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 62,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:DRAGONRUSH,:FEATHERDANCE,:HAZE,:HYPERVOICE,:PLAYROUGH,:POWERSWAP,:PURSUIT,:RAGE,:ROOST,:STEELWING,],
		:Moveset => [
			[1,:PECK],
			[1,:GROWL],
			[3,:ASTONISH],
			[5,:SING],
			[7,:FURYATTACK],
			[9,:SAFEGUARD],
			[11,:DISARMINGVOICE],
			[14,:MIST],
			[17,:ROUND],
			[20,:NATURALGIFT],
			[23,:TAKEDOWN],
			[26,:REFRESH],
			[30,:MIRRORMOVE],
			[34,:COTTONGUARD],
			[38,:DRAGONPULSE],
			[42,:PERISHSONG],
			[46,:MOONBLAST]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:BODYSLAM,:DAZZLINGGLEAM,:DEFOG,:DOUBLEEDGE,:DRAGONPULSE,:DREAMEATER,:DUALWINGBEAT,:ECHOEDVOICE,:FALSESWIPE,:FLY,:HEALBELL,:HEATWAVE,:HYPERVOICE,:ICEBEAM,:MIMIC,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:PLAYROUGH,:PLUCK,:POWERSWAP,:PSYCHUP,:RAINDANCE,:ROOST,:SAFEGUARD,:SKYATTACK,:SOLARBEAM,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Forest",
		:EggGroups => [:Flying, :Dragon],
		:Height => 4,
		:Weight => 12,
		:kind => "Cotton Bird",
		:dexentry => "A Pokémon that has wings like cottony clouds. After enduring winter, in which little food is available, Swablu flocks move closer to towns in the spring.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 17,
		:evolutions => [
			[:ALTARIA,:Level,35]
		]
	},

	:OnCreation => {},
},

:ALTARIA => {
	"Normal Form" => {
		:name => "Altaria",
		:dexnum => 334,
		:Type1 => :DRAGON,
		:Type2 => :FLYING,
		:BaseStats => [75, 70, 90, 70, 105, 80],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:NATURALCURE, :CLOUDNINE],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 172,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SWABLU,
			:form => 0
		},
		:Moveset => [
			[0,:DRAGONBREATH],
			[1,:SKYATTACK],
			[1,:PLUCK],
			[1,:PECK],
			[1,:GROWL],
			[1,:ASTONISH],
			[1,:SING],
			[3,:ASTONISH],
			[5,:SING],
			[7,:FURYATTACK],
			[9,:SAFEGUARD],
			[11,:DISARMINGVOICE],
			[14,:MIST],
			[17,:ROUND],
			[20,:NATURALGIFT],
			[23,:TAKEDOWN],
			[26,:REFRESH],
			[30,:DRAGONDANCE],
			[34,:COTTONGUARD],
			[40,:DRAGONPULSE],
			[46,:PERISHSONG],
			[52,:MOONBLAST],
			[59,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRCUTTER,:BODYSLAM,:BREAKINGSWIPE,:BULLDOZE,:DAZZLINGGLEAM,:DEFOG,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DREAMEATER,:DUALWINGBEAT,:EARTHQUAKE,:ECHOEDVOICE,:FALSESWIPE,:FIREBLAST,:FIRESPIN,:FLAMETHROWER,:FLY,:GIGAIMPACT,:HEALBELL,:HEATWAVE,:HONECLAWS,:HURRICANE,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:INCINERATE,:IRONTAIL,:MIMIC,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:PLAYROUGH,:PLUCK,:POWERSWAP,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKSMASH,:ROOST,:SAFEGUARD,:SKYATTACK,:SOLARBEAM,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:WONDERROOM,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWBREAK,:SHADOWMIST,:SHADOWRAVE,],
		:Color => "Blue",
		:Habitat => "Forest",
		:EggGroups => [:Flying, :Dragon],
		:Height => 11,
		:Weight => 206,
		:kind => "Humming",
		:dexentry => "It hums in a beautiful soprano voice. It flies among white clouds in the blue sky. It launches intensely hot fireballs from its mouth.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 15,
	},

	"Mega Form" => {
		:Type2 => :FAIRY,
		:BaseStats => [75, 110, 110, 110, 105, 80],
		:Abilities => [:PIXILATE],
		:Height => 15,
		:Weight => 2060,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:ALTARIANITE => 1,
	},
},

:ZANGOOSE => {
	"Normal Form" => {
		:name => "Zangoose",
		:dexnum => 335,
		:Type1 => :NORMAL,
		:BaseStats => [73, 115, 60, 60, 60, 90],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:IMMUNITY, :TOXICBOOST],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 160,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BELLYDRUM,:COUNTER,:CURSE,:DISABLE,:DOUBLEHIT,:DOUBLEKICK,:FEINT,:FINALGAMBIT,:FLAIL,:FURYSWIPES,:IRONTAIL,:METALCLAW,:NIGHTSLASH,:QUICKGUARD,:RAZORWIND,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:LEER],
			[5,:QUICKATTACK],
			[8,:FURYCUTTER],
			[12,:PURSUIT],
			[15,:HONECLAWS],
			[19,:SLASH],
			[22,:REVENGE],
			[26,:CRUSHCLAW],
			[29,:FALSESWIPE],
			[33,:EMBARGO],
			[36,:DETECT],
			[40,:XSCISSOR],
			[43,:TAUNT],
			[47,:SWORDSDANCE],
			[50,:CLOSECOMBAT]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AURASPHERE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:CLOSECOMBAT,:COUNTER,:CROSSPOISON,:CURSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DYNAMICPUNCH,:EMBARGO,:ENDEAVOR,:FALSESWIPE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGADRAIN,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:LOWKICK,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:WATERPULSE,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWMIST,],
		:Color => "White",
		:Habitat => "Grassland",
		:EggGroups => [:Field],
		:Height => 13,
		:Weight => 403,
		:WildItemUncommon => :QUICKCLAW,
		:kind => "Cat Ferret",
		:dexentry => "When it battles, it stands on its hind legs and attacks with its sharply clawed forelegs. Its fur bristles if it encounters any Seviper.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SEVIPER => {
	"Normal Form" => {
		:name => "Seviper",
		:dexnum => 336,
		:Type1 => :POISON,
		:BaseStats => [73, 100, 60, 100, 60, 65],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:SHEDSKIN, :INFILTRATOR],
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 160,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASSURANCE,:BODYSLAM,:FINALGAMBIT,:IRONTAIL,:NIGHTSLASH,:PUNISHMENT,:SCARYFACE,:SPITUP,:STOCKPILE,:SWALLOW,:SWITCHEROO,:WRINGOUT,],
		:Moveset => [
			[1,:WRAP],
			[1,:SWAGGER],
			[4,:BITE],
			[6,:LICK],
			[9,:POISONTAIL],
			[11,:FEINT],
			[14,:SCREECH],
			[16,:VENOSHOCK],
			[19,:GLARE],
			[21,:POISONFANG],
			[24,:VENOMDRENCH],
			[26,:NIGHTSLASH],
			[29,:GASTROACID],
			[31,:POISONJAB],
			[34,:HAZE],
			[36,:SWORDSDANCE],
			[39,:CRUNCH],
			[41,:BELCH],
			[44,:COIL],
			[46,:WRINGOUT]],
		:compatiblemoves => [:AQUATAIL,:BIND,:BODYSLAM,:BRUTALSWING,:BULLDOZE,:CROSSPOISON,:CRUNCH,:DARKPULSE,:DIG,:DOUBLEEDGE,:DRAGONTAIL,:EARTHQUAKE,:FIREFANG,:FLAMETHROWER,:FURYCUTTER,:GASTROACID,:GIGADRAIN,:HEADBUTT,:ICEFANG,:INFESTATION,:IRONTAIL,:KNOCKOFF,:MIMIC,:MUDSLAP,:PAYBACK,:POISONJAB,:PSYCHICFANGS,:RAINDANCE,:REVERSAL,:ROCKSMASH,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDERFANG,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Grassland",
		:EggGroups => [:Field, :Dragon],
		:Height => 27,
		:Weight => 525,
		:WildItemUncommon => :SHEDSHELL,
		:kind => "Fang Snake",
		:dexentry => "Seviper and Zangoose are eternal rivals. It counters a Zangoose's incredible agility with its swordlike tail, which also oozes a horrible poison.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LUNATONE => {
	"Normal Form" => {
		:name => "Lunatone",
		:dexnum => 337,
		:Type1 => :ROCK,
		:Type2 => :PSYCHIC,
		:BaseStats => [90, 55, 65, 95, 85, 70],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :Genderless,
		:BaseEXP => 161,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:Moveset => [
			[1,:POWERGEM],
			[1,:PSYSHOCK],
			[1,:MOONBLAST],
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:CONFUSION],
			[1,:ROCKTHROW],
			[5,:HYPNOSIS],
			[9,:ROCKPOLISH],
			[13,:PSYWAVE],
			[17,:EMBARGO],
			[21,:ROCKSLIDE],
			[25,:COSMICPOWER],
			[29,:PSYCHIC],
			[33,:HEALBLOCK],
			[37,:STONEEDGE],
			[41,:FUTURESIGHT],
			[45,:EXPLOSION],
			[49,:MAGICROOM]],
		:compatiblemoves => [:ACROBATICS,:ALLYSWITCH,:ANCIENTPOWER,:BATONPASS,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COSMICPOWER,:DEFENSECURL,:DOUBLEEDGE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:EMBARGO,:EXPLOSION,:FLASH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GYROBALL,:HAIL,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONHEAD,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:METEORBEAM,:MIMIC,:NASTYPLOT,:PAINSPLIT,:POWERGEM,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STOREDPOWER,:SWIFT,:TELEKINESIS,:TRICKROOM,:WEATHERBALL,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWWAVE,:SHADOWSKY,],
		:Color => "Yellow",
		:Habitat => "Cave",
		:EggGroups => [:Mineral],
		:Height => 10,
		:Weight => 1680,
		:WildItemCommon => :STARDUST,
		:WildItemUncommon => :MOONSTONE,
		:kind => "Meteorite",
		:dexentry => "It becomes very active on the night of a full moon. This Pokémon was first discovered 40 years ago at the site of a meteor strike.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:SOLROCK => {
	"Normal Form" => {
		:name => "Solrock",
		:dexnum => 338,
		:Type1 => :ROCK,
		:Type2 => :PSYCHIC,
		:BaseStats => [90, 95, 85, 55, 65, 70],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :Genderless,
		:BaseEXP => 161,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:Moveset => [
			[1,:FLAREBLITZ],
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:CONFUSION],
			[1,:ROCKTHROW],
			[5,:FIRESPIN],
			[9,:ROCKPOLISH],
			[13,:PSYWAVE],
			[17,:EMBARGO],
			[21,:ROCKSLIDE],
			[25,:COSMICPOWER],
			[29,:PSYCHIC],
			[33,:HEALBLOCK],
			[37,:STONEEDGE],
			[41,:SOLARBEAM],
			[45,:EXPLOSION],
			[49,:WONDERROOM]],
		:compatiblemoves => [:ACROBATICS,:ALLYSWITCH,:ANCIENTPOWER,:BATONPASS,:BODYSLAM,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COSMICPOWER,:DEFENSECURL,:DOUBLEEDGE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:EMBARGO,:EXPLOSION,:FIREBLAST,:FLAMETHROWER,:FLAREBLITZ,:FLASH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GYROBALL,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:METEORBEAM,:MIMIC,:OVERHEAT,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RECYCLE,:REFLECT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STOREDPOWER,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TELEKINESIS,:TRICKROOM,:WEATHERBALL,:WILLOWISP,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:shadowmoves => [:SHADOWRAVE,:SHADOWSKY,:SHADOWPANIC,],
		:Color => "Red",
		:Habitat => "Cave",
		:EggGroups => [:Mineral],
		:Height => 12,
		:Weight => 1540,
		:WildItemCommon => :STARDUST,
		:WildItemUncommon => :SUNSTONE,
		:kind => "Meteorite",
		:dexentry => "Solar energy is the source of this Pokémon's power. On sunny days, groups of Solrock line up facing the sun and absorb its light.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:BARBOACH => {
	"Normal Form" => {
		:name => "Barboach",
		:dexnum => 339,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [50, 48, 43, 46, 41, 60],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :ANTICIPATION],
		:HiddenAbilities => :HYDRATION,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:DRAGONDANCE,:EARTHPOWER,:FLAIL,:HYDROPUMP,:MUDSHOT,:MUDDYWATER,:SPARK,:TAKEDOWN,:THRASH,:WHIRLPOOL,],
		:Moveset => [
			[1,:MUDSLAP],
			[6,:MUDSPORT],
			[6,:WATERSPORT],
			[9,:WATERGUN],
			[13,:MUDBOMB],
			[15,:AMNESIA],
			[17,:WATERPULSE],
			[20,:MAGNITUDE],
			[25,:REST],
			[25,:SNORE],
			[28,:AQUATAIL],
			[32,:EARTHQUAKE],
			[35,:MUDDYWATER],
			[39,:FUTURESIGHT],
			[44,:FISSURE]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BOUNCE,:BULLDOZE,:DIVE,:DOUBLEEDGE,:DRAGONDANCE,:EARTHPOWER,:EARTHQUAKE,:FUTURESIGHT,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:RAINDANCE,:ROCKTOMB,:SANDSTORM,:SCALD,:SURF,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2],
		:Height => 4,
		:Weight => 19,
		:kind => "Whiskers",
		:dexentry => "Its body is covered with a slimy film. The film acts as a barrier to prevent germs in muddy water from entering the Barboach's body.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 12,
		:evolutions => [
			[:WHISCASH,:Level,30]
		]
	},

	:OnCreation => {},
},

:WHISCASH => {
	"Normal Form" => {
		:name => "Whiscash",
		:dexnum => 340,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [110, 78, 73, 76, 71, 60],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :ANTICIPATION],
		:HiddenAbilities => :HYDRATION,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 164,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BARBOACH,
			:form => 0
		},
		:Moveset => [
			[0,:THRASH],
			[1,:BELCH],
			[1,:ZENHEADBUTT],
			[1,:TICKLE],
			[1,:MUDSLAP],
			[1,:MUDSPORT],
			[1,:WATERSPORT],
			[1,:WATERGUN],
			[6,:MUDSPORT],
			[6,:WATERSPORT],
			[9,:WATERGUN],
			[13,:MUDBOMB],
			[15,:AMNESIA],
			[17,:WATERPULSE],
			[20,:MAGNITUDE],
			[25,:REST],
			[25,:SNORE],
			[28,:AQUATAIL],
			[34,:EARTHQUAKE],
			[39,:MUDDYWATER],
			[45,:FUTURESIGHT],
			[52,:FISSURE]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BOUNCE,:BULLDOZE,:DIVE,:DOUBLEEDGE,:DRAGONDANCE,:EARTHPOWER,:EARTHQUAKE,:FUTURESIGHT,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LIQUIDATION,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCALD,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SURF,:UPROAR,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water2],
		:Height => 9,
		:Weight => 236,
		:kind => "Whiskers",
		:dexentry => "It can foretell earthquakes. In the daytime, it sleeps in mud at the bottom of a pond. When it awakens, it continually feeds throughout the night.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:CORPHISH => {
	"Normal Form" => {
		:name => "Corphish",
		:dexnum => 341,
		:Type1 => :WATER,
		:BaseStats => [43, 80, 65, 50, 35, 35],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SHELLARMOR],
		:HiddenAbilities => :ADAPTABILITY,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 62,
		:CatchRate => 205,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ANCIENTPOWER,:AQUAJET,:BODYSLAM,:CHIPAWAY,:DOUBLEEDGE,:DRAGONDANCE,:ENDEAVOR,:KNOCKOFF,:METALCLAW,:MUDSPORT,:SUPERPOWER,:SWITCHEROO,:TRUMPCARD,],
		:Moveset => [
			[1,:BUBBLE],
			[5,:HARDEN],
			[7,:VICEGRIP],
			[10,:LEER],
			[14,:BUBBLEBEAM],
			[17,:PROTECT],
			[20,:DOUBLEHIT],
			[23,:KNOCKOFF],
			[26,:NIGHTSLASH],
			[31,:RAZORSHELL],
			[34,:TAUNT],
			[37,:SWORDSDANCE],
			[39,:CRUNCH],
			[43,:CRABHAMMER],
			[48,:GUILLOTINE]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:COUNTER,:CRUNCH,:CUT,:DIG,:DOUBLEEDGE,:DRAGONDANCE,:ENDEAVOR,:FALSESWIPE,:FLING,:FURYCUTTER,:HAIL,:HONECLAWS,:HYDROPUMP,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PAYBACK,:RAINDANCE,:RAZORSHELL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SLUDGEBOMB,:SPITE,:STRENGTH,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAUNT,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Water3],
		:Height => 6,
		:Weight => 115,
		:kind => "Ruffian",
		:dexentry => "Once it grips prey with its large pincers, it will never let go, no matter what. It is a hardy Pokémon that can thrive in any environment.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CRAWDAUNT,:Level,30]
		]
	},

	:OnCreation => {},
},

:CRAWDAUNT => {
	"Normal Form" => {
		:name => "Crawdaunt",
		:dexnum => 342,
		:Type1 => :WATER,
		:Type2 => :DARK,
		:BaseStats => [63, 120, 85, 90, 55, 55],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SHELLARMOR],
		:HiddenAbilities => :ADAPTABILITY,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 164,
		:CatchRate => 155,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :CORPHISH,
			:form => 0
		},
		:Moveset => [
			[0,:SWIFT],
			[1,:BUBBLE],
			[1,:HARDEN],
			[1,:VICEGRIP],
			[1,:LEER],
			[5,:HARDEN],
			[7,:VICEGRIP],
			[10,:LEER],
			[14,:BUBBLEBEAM],
			[17,:PROTECT],
			[20,:DOUBLEHIT],
			[23,:KNOCKOFF],
			[26,:NIGHTSLASH],
			[32,:RAZORSHELL],
			[36,:TAUNT],
			[40,:SWORDSDANCE],
			[43,:CRUNCH],
			[48,:CRABHAMMER],
			[54,:GUILLOTINE]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AVALANCHE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:CLOSECOMBAT,:COUNTER,:CRUNCH,:CUT,:DARKPULSE,:DIG,:DIVE,:DOUBLEEDGE,:DRAGONDANCE,:ENDEAVOR,:FALSESWIPE,:FLING,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HONECLAWS,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LASHOUT,:LIQUIDATION,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:NASTYPLOT,:NATUREPOWER,:PAYBACK,:RAINDANCE,:RAZORSHELL,:RETALIATE,:REVENGE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SLUDGEBOMB,:SLUDGEWAVE,:SNARL,:SPITE,:STRENGTH,:SUPERPOWER,:SURF,:SWIFT,:SWORDSDANCE,:TAUNT,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Water3],
		:Height => 11,
		:Weight => 328,
		:kind => "Rogue",
		:dexentry => "A brutish Pokémon that loves to battle. A veteran Crawdaunt that has prevailed in hundreds of battles has giant pincers marked with countless scars.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BALTOY => {
	"Normal Form" => {
		:name => "Baltoy",
		:dexnum => 343,
		:Type1 => :GROUND,
		:Type2 => :PSYCHIC,
		:BaseStats => [40, 40, 55, 40, 70, 55],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:HARDEN],
			[1,:CONFUSION],
			[4,:RAPIDSPIN],
			[7,:MUDSLAP],
			[10,:HEALBLOCK],
			[13,:ROCKTOMB],
			[16,:PSYBEAM],
			[19,:ANCIENTPOWER],
			[22,:COSMICPOWER],
			[25,:POWERTRICK],
			[28,:SELFDESTRUCT],
			[31,:EXTRASENSORY],
			[34,:GUARDSPLIT],
			[34,:POWERSPLIT],
			[37,:EARTHPOWER],
			[40,:SANDSTORM],
			[43,:IMPRISON],
			[46,:EXPLOSION]],
		:compatiblemoves => [:ALLYSWITCH,:ANCIENTPOWER,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COSMICPOWER,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DREAMEATER,:DRILLRUN,:EARTHPOWER,:EARTHQUAKE,:EERIEIMPULSE,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEADBUTT,:HEX,:ICEBEAM,:IMPRISON,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:MUDSLAP,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:SUNNYDAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWWAVE,],
		:Color => "Brown",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 5,
		:Weight => 215,
		:WildItemUncommon => :LIGHTCLAY,
		:kind => "Clay Doll",
		:dexentry => "A Baltoy moves by spinning on its single foot. It has been depicted in murals adorning the walls of a once-bustling city in an ancient age.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 11,
		:evolutions => [
			[:CLAYDOL,:Level,36]
		]
	},

	:OnCreation => {},
},

:CLAYDOL => {
	"Normal Form" => {
		:name => "Claydol",
		:dexnum => 344,
		:Type1 => :GROUND,
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 70, 105, 70, 120, 75],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 175,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BALTOY,
			:form => 0
		},
		:Moveset => [
			[0,:HYPERBEAM],
			[1,:TELEPORT],
			[1,:HARDEN],
			[1,:CONFUSION],
			[1,:RAPIDSPIN],
			[4,:RAPIDSPIN],
			[7,:MUDSLAP],
			[10,:HEALBLOCK],
			[13,:ROCKTOMB],
			[16,:PSYBEAM],
			[19,:ANCIENTPOWER],
			[22,:COSMICPOWER],
			[25,:POWERTRICK],
			[28,:SELFDESTRUCT],
			[31,:EXTRASENSORY],
			[34,:GUARDSPLIT],
			[34,:POWERSPLIT],
			[40,:EARTHPOWER],
			[46,:SANDSTORM],
			[52,:IMPRISON],
			[58,:EXPLOSION]],
		:compatiblemoves => [:ALLYSWITCH,:ANCIENTPOWER,:BODYPRESS,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COSMICPOWER,:DAZZLINGGLEAM,:DIG,:DOUBLEEDGE,:DREAMEATER,:DRILLRUN,:EARTHPOWER,:EARTHQUAKE,:EERIEIMPULSE,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEADBUTT,:HEX,:HYPERBEAM,:ICEBEAM,:IMPRISON,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:MUDSLAP,:NASTYPLOT,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STONEEDGE,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 15,
		:Weight => 1080,
		:WildItemUncommon => :LIGHTCLAY,
		:kind => "Clay Doll",
		:dexentry => "A Claydol sleeps while hovering in midair. Its arms are separate from its body. They are kept floating by the Pokémon's manipulation of psychic power.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:LILEEP => {
	"Normal Form" => {
		:name => "Lileep",
		:dexnum => 345,
		:Type1 => :ROCK,
		:Type2 => :GRASS,
		:BaseStats => [66, 41, 77, 61, 87, 23],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SUCTIONCUPS, :STORMDRAIN],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 71,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:BARRIER,:CURSE,:ENDURE,:MEGADRAIN,:MIRRORCOAT,:RECOVER,:STEALTHROCK,:TICKLE,:WRINGOUT,],
		:Moveset => [
			[1,:ASTONISH],
			[1,:CONSTRICT],
			[5,:ACID],
			[9,:INGRAIN],
			[13,:CONFUSERAY],
			[17,:ANCIENTPOWER],
			[21,:BRINE],
			[26,:GIGADRAIN],
			[31,:GASTROACID],
			[36,:AMNESIA],
			[41,:ENERGYBALL],
			[46,:STOCKPILE],
			[46,:SWALLOW],
			[46,:SPITUP],
			[52,:WRINGOUT]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BIND,:BODYSLAM,:BRINE,:BULLETSEED,:DOUBLEEDGE,:EARTHPOWER,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:HEADBUTT,:INFESTATION,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:PAINSPLIT,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:SEEDBOMB,:SLUDGEBOMB,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STRINGSHOT,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Purple",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 10,
		:Weight => 238,
		:WildItemUncommon => :BIGROOT,
		:kind => "Sea Lily",
		:dexentry => "It disguises itself as seaweed by swaying its tentacles. Unsuspecting prey that comes too close is swallowed whole.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CRADILY,:Level,40]
		]
	},

	:OnCreation => {},
},

:CRADILY => {
	"Normal Form" => {
		:name => "Cradily",
		:dexnum => 346,
		:Type1 => :ROCK,
		:Type2 => :GRASS,
		:BaseStats => [86, 81, 97, 81, 107, 43],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:SUCTIONCUPS, :STORMDRAIN],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :LILEEP,
			:form => 0
		},
		:Moveset => [
			[1,:WRINGOUT],
			[1,:ASTONISH],
			[1,:CONSTRICT],
			[1,:ACID],
			[1,:INGRAIN],
			[5,:ACID],
			[9,:INGRAIN],
			[13,:CONFUSERAY],
			[17,:ANCIENTPOWER],
			[21,:BRINE],
			[26,:GIGADRAIN],
			[31,:GASTROACID],
			[36,:AMNESIA],
			[44,:ENERGYBALL],
			[52,:STOCKPILE],
			[52,:SWALLOW],
			[52,:SPITUP],
			[61,:WRINGOUT]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BIND,:BLOCK,:BODYSLAM,:BRINE,:BULLDOZE,:BULLETSEED,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:INFESTATION,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:PAINSPLIT,:POWERWHIP,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SEEDBOMB,:SLUDGEBOMB,:SLUDGEWAVE,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STONEEDGE,:STRENGTH,:STRINGSHOT,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Sea",
		:EggGroups => [:Water3],
		:Height => 15,
		:Weight => 604,
		:WildItemUncommon => :BIGROOT,
		:kind => "Barnacle",
		:dexentry => "It drags its heavy body along the seafloor. It makes its nest in the shallows of warm seas. Cradily can be seen on beaches when the tide goes out.",
		:BattlerPlayerY => 7,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ANORITH => {
	"Normal Form" => {
		:name => "Anorith",
		:dexnum => 347,
		:Type1 => :ROCK,
		:Type2 => :BUG,
		:BaseStats => [45, 95, 50, 40, 50, 75],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:BATTLEARMOR, :SWIFTSWIM],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 71,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:AQUAJET,:CROSSPOISON,:CURSE,:IRONDEFENSE,:KNOCKOFF,:RAPIDSPIN,:SANDATTACK,:SCREECH,:WATERPULSE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:HARDEN],
			[4,:MUDSPORT],
			[7,:WATERGUN],
			[10,:FURYCUTTER],
			[13,:SMACKDOWN],
			[17,:METALCLAW],
			[21,:ANCIENTPOWER],
			[25,:BUGBITE],
			[29,:BRINE],
			[34,:SLASH],
			[39,:CRUSHCLAW],
			[44,:XSCISSOR],
			[49,:PROTECT],
			[55,:ROCKBLAST]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BODYSLAM,:BRICKBREAK,:BRINE,:BUGBITE,:CROSSPOISON,:CUT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:FALSESWIPE,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:IRONDEFENSE,:KNOCKOFF,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCREECH,:SMACKDOWN,:STEALTHROCK,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWORDSDANCE,:WATERPULSE,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water3],
		:Height => 7,
		:Weight => 125,
		:kind => "Old Shrimp",
		:dexentry => "It was resurrected from a fossil. Anorith swims by undulating the eight wings at its sides. They were feet that adapted to life in the sea.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 32,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ARMALDO,:Level,40]
		]
	},

	:OnCreation => {},
},

:ARMALDO => {
	"Normal Form" => {
		:name => "Armaldo",
		:dexnum => 348,
		:Type1 => :ROCK,
		:Type2 => :BUG,
		:BaseStats => [75, 125, 100, 70, 80, 45],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:BATTLEARMOR, :SWIFTSWIM],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :ANORITH,
			:form => 0
		},
		:Moveset => [
			[1,:SCRATCH],
			[1,:HARDEN],
			[1,:MUDSPORT],
			[1,:WATERGUN],
			[4,:MUDSPORT],
			[7,:WATERGUN],
			[10,:FURYCUTTER],
			[13,:SMACKDOWN],
			[17,:METALCLAW],
			[21,:ANCIENTPOWER],
			[25,:BUGBITE],
			[29,:BRINE],
			[34,:SLASH],
			[39,:CRUSHCLAW],
			[46,:XSCISSOR],
			[53,:PROTECT],
			[61,:ROCKBLAST]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRINE,:BRUTALSWING,:BUGBITE,:BULLDOZE,:CROSSPOISON,:CUT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:FALSESWIPE,:FLASHCANNON,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:IRONDEFENSE,:IRONTAIL,:KNOCKOFF,:LIQUIDATION,:LOWKICK,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SHADOWCLAW,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:WATERPULSE,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water3],
		:Height => 15,
		:Weight => 682,
		:kind => "Plate",
		:dexentry => "Armaldo usually lives on land. However, when it hunts for prey, it dives beneath the ocean. It swims around using its two large wings.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:FEEBAS => {
	"Normal Form" => {
		:name => "Feebas",
		:dexnum => 349,
		:Type1 => :WATER,
		:BaseStats => [20, 15, 20, 10, 55, 80],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :OBLIVIOUS],
		:HiddenAbilities => :ADAPTABILITY,
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 40,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:BRINE,:CAPTIVATE,:CONFUSERAY,:DRAGONBREATH,:DRAGONPULSE,:HAZE,:HYPNOSIS,:IRONTAIL,:MIRRORCOAT,:MIST,:MUDSPORT,:TICKLE,],
		:Moveset => [
			[1,:SPLASH],
			[15,:TACKLE],
			[30,:FLAIL]],
		:compatiblemoves => [:BLIZZARD,:BRINE,:DIVE,:DOUBLEEDGE,:DRAGONPULSE,:HAIL,:ICEBEAM,:ICYWIND,:IRONTAIL,:LIGHTSCREEN,:MIMIC,:MUDDYWATER,:MUDSHOT,:RAINDANCE,:SCALD,:SCALESHOT,:SURF,:SWIFT,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Brown",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Dragon],
		:Height => 6,
		:Weight => 74,
		:kind => "Fish",
		:dexentry => "Feebas live in ponds that are heavily infested with weeds. Because of its hopelessly shabby appearance, it seems as if few Trainers raise it.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 12,
		:evolutions => [
			[:MILOTIC,:TradeItem,:PRISMSCALE]
		]
	},

	:OnCreation => {},
},

:MILOTIC => {
	"Normal Form" => {
		:name => "Milotic",
		:dexnum => 350,
		:Type1 => :WATER,
		:BaseStats => [95, 60, 79, 100, 125, 81],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:MARVELSCALE, :COMPETITIVE],
		:HiddenAbilities => :CUTECHARM,
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 189,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :FEEBAS,
			:form => 0
		},
		:Moveset => [
			[0,:WATERPULSE],
			[1,:WRAP],
			[1,:WATERGUN],
			[1,:WATERSPORT],
			[1,:REFRESH],
			[4,:WATERSPORT],
			[7,:REFRESH],
			[11,:DISARMINGVOICE],
			[14,:TWISTER],
			[17,:AQUARING],
			[21,:CAPTIVATE],
			[24,:DRAGONTAIL],
			[27,:RECOVER],
			[31,:AQUATAIL],
			[34,:ATTRACT],
			[37,:SAFEGUARD],
			[41,:COIL],
			[44,:HYDROPUMP],
			[47,:RAINDANCE]],
		:compatiblemoves => [:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:SWIFT,:BIND,:PSYCHUP,:SAFEGUARD,:LIGHTSCREEN,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:BRUTALSWING,:LASERFOCUS,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "WatersEdge",
		:EggGroups => [:Water1, :Dragon],
		:Height => 62,
		:Weight => 1620,
		:kind => "Tender",
		:dexentry => "It is said to live at the bottom of large lakes. Considered to be the most beautiful of all Pokémon, it has been depicted in paintings and statues.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 3,
	},

	:OnCreation => {},
},

:CASTFORM => {
	"Normal Form" => {
		:name => "Castform",
		:dexnum => 351,
		:Type1 => :NORMAL,
		:BaseStats => [70, 70, 70, 70, 70, 70],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:FORECAST],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:AMNESIA,:CLEARSMOG,:COSMICPOWER,:DISABLE,:FUTURESIGHT,:GUARDSWAP,:HEX,:LUCKYCHANT,:OMINOUSWIND,:REFLECTTYPE,],
		:Moveset => [
			[1,:TACKLE],
			[10,:WATERGUN],
			[10,:EMBER],
			[10,:POWDERSNOW],
			[15,:HEADBUTT],
			[20,:RAINDANCE],
			[20,:SUNNYDAY],
			[20,:HAIL],
			[25,:WEATHERBALL],
			[35,:HYDROPUMP],
			[35,:FIREBLAST],
			[35,:BLIZZARD],
			[45,:HURRICANE]],
		:compatiblemoves => [:AVALANCHE,:BLIZZARD,:BODYSLAM,:DEFENSECURL,:DEFOG,:DOUBLEEDGE,:ENERGYBALL,:FIREBLAST,:FLAMETHROWER,:FLASH,:HAIL,:HURRICANE,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INCINERATE,:LASTRESORT,:MIMIC,:MUDDYWATER,:MYSTICALFIRE,:NASTYPLOT,:OMINOUSWIND,:PSYCHUP,:RAINDANCE,:RETALIATE,:SANDSTORM,:SCALD,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:SUNNYDAY,:SWIFT,:TAILWIND,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:WATERPULSE,:WEATHERBALL,:WORKUP,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Grassland",
		:EggGroups => [:Fairy, :Amorphous],
		:Height => 3,
		:Weight => 8,
		:WildItemCommon => :MYSTICWATER,
		:WildItemUncommon => :MYSTICWATER,
		:WildItemRare => :MYSTICWATER,
		:kind => "Weather",
		:dexentry => "It alters its form depending on the weather. Changes in the climate such as the temperature and humidity appear to affect its cellular structure.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 18,
	},

	"Sunny Form" => {
		:Type1 => :FIRE,
	},

	"Rainy Form" => {
		:Type1 => :WATER,
	},

	"Snowy Form" => {
		:Type1 => :ICE,
	},

	:OnCreation => {},
},

:KECLEON => {
	"Normal Form" => {
		:name => "Kecleon",
		:dexnum => 352,
		:Type1 => :NORMAL,
		:BaseStats => [60, 90, 70, 60, 120, 40],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:COLORCHANGE, :PROTEAN],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 154,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CAMOUFLAGE,:DISABLE,:DIZZYPUNCH,:FAKEOUT,:FOULPLAY,:MAGICCOAT,:NASTYPLOT,:POWERUPPUNCH,:RECOVER,:SKILLSWAP,:SNATCH,:TRICK,],
		:Moveset => [
			[1,:THIEF],
			[1,:TAILWHIP],
			[1,:ASTONISH],
			[1,:LICK],
			[1,:SCRATCH],
			[4,:BIND],
			[7,:SHADOWSNEAK],
			[10,:FEINT],
			[13,:FURYSWIPES],
			[16,:FEINTATTACK],
			[18,:PSYBEAM],
			[21,:ANCIENTPOWER],
			[25,:SLASH],
			[30,:CAMOUFLAGE],
			[33,:SHADOWCLAW],
			[38,:SCREECH],
			[42,:SUBSTITUTE],
			[46,:SUCKERPUNCH],
			[50,:SYNCHRONOISE]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:ANCIENTPOWER,:AQUATAIL,:BIND,:BLIZZARD,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:CHARGEBEAM,:COUNTER,:CUT,:DARKESTLARIAT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GRASSKNOT,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASTRESORT,:LOWKICK,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RECYCLE,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKILLSWAP,:SKITTERSMACK,:SNATCH,:SOLARBEAM,:STEALTHROCK,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRICK,:TRICKROOM,:WATERPULSE,:WONDERROOM,:WORKUP,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 220,
		:kind => "Color Swap",
		:dexentry => "A Pokémon that has the ability to alter its body colors to match its surroundings. A Kecleon reverts to its original colors if it is startled.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SHUPPET => {
	"Normal Form" => {
		:name => "Shuppet",
		:dexnum => 353,
		:Type1 => :GHOST,
		:BaseStats => [44, 75, 35, 63, 33, 45],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:INSOMNIA, :FRISK],
		:HiddenAbilities => :CURSEDBODY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 59,
		:CatchRate => 225,
		:Happiness => 35,
		:EggSteps => 6630,
		:EggMoves => [:ASTONISH,:CONFUSERAY,:DESTINYBOND,:DISABLE,:FORESIGHT,:GUNKSHOT,:IMPRISON,:OMINOUSWIND,:PHANTOMFORCE,:PURSUIT,:SHADOWSNEAK,],
		:Moveset => [
			[1,:KNOCKOFF],
			[4,:SCREECH],
			[7,:NIGHTSHADE],
			[10,:SPITE],
			[13,:SHADOWSNEAK],
			[16,:WILLOWISP],
			[19,:FEINTATTACK],
			[22,:HEX],
			[26,:CURSE],
			[30,:SHADOWBALL],
			[34,:EMBARGO],
			[38,:SUCKERPUNCH],
			[42,:SNATCH],
			[46,:GRUDGE],
			[50,:TRICK],
			[54,:PHANTOMFORCE]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:DARKPULSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DREAMEATER,:EMBARGO,:ENCORE,:FLASH,:FOULPLAY,:GUNKSHOT,:HEADBUTT,:HEX,:ICYWIND,:KNOCKOFF,:MAGICCOAT,:MAGICROOM,:MIMIC,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:RAINDANCE,:ROLEPLAY,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 6,
		:Weight => 23,
		:WildItemUncommon => :SPELLTAG,
		:kind => "Puppet",
		:dexentry => "This Pokémon roams about deep in the night seeking such negative emotions as grudges and envy. It retreats to its nest when the sun begins to rise.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 17,
		:evolutions => [
			[:BANETTE,:Level,37]
		]
	},

	:OnCreation => {},
},

:BANETTE => {
	"Normal Form" => {
		:name => "Banette",
		:dexnum => 354,
		:Type1 => :GHOST,
		:BaseStats => [64, 115, 65, 83, 63, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INSOMNIA, :FRISK],
		:HiddenAbilities => :CURSEDBODY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 6630,
		:preevo => {
			:species => :SHUPPET,
			:form => 0
		},
		:Moveset => [
			[1,:PHANTOMFORCE],
			[1,:KNOCKOFF],
			[1,:SCREECH],
			[1,:NIGHTSHADE],
			[1,:SPITE],
			[4,:SCREECH],
			[7,:NIGHTSHADE],
			[10,:SPITE],
			[13,:SHADOWSNEAK],
			[16,:WILLOWISP],
			[19,:FEINTATTACK],
			[22,:HEX],
			[26,:CURSE],
			[30,:SHADOWBALL],
			[34,:EMBARGO],
			[40,:SUCKERPUNCH],
			[46,:SNATCH],
			[52,:GRUDGE],
			[58,:TRICK],
			[64,:PHANTOMFORCE]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:DARKPULSE,:DAZZLINGGLEAM,:DOUBLEEDGE,:DREAMEATER,:EMBARGO,:ENCORE,:FLASH,:FLING,:FOULPLAY,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HEX,:HYPERBEAM,:ICYWIND,:INFESTATION,:KNOCKOFF,:MAGICCOAT,:MAGICROOM,:METRONOME,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:PLAYROUGH,:POLTERGEIST,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:RAINDANCE,:ROLEPLAY,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SKILLSWAP,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WILLOWISP,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWHOLD,],
		:Color => "Black",
		:Habitat => "Urban",
		:EggGroups => [:Amorphous],
		:Height => 11,
		:Weight => 125,
		:WildItemUncommon => :SPELLTAG,
		:kind => "Marionette",
		:dexentry => "An abandoned plush doll became this Pokémon. They are said to live in garbage dumps and wander about in search of the children that threw them away.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [64, 165, 75, 93, 83, 75],
		:Abilities => [:PRANKSTER],
		:Weight => 130,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:BANETTITE => 1,
	},
},

:DUSKULL => {
	"Normal Form" => {
		:name => "Duskull",
		:dexnum => 355,
		:Type1 => :GHOST,
		:BaseStats => [20, 40, 90, 30, 90, 25],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:LEVITATE, :FRISK],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 59,
		:CatchRate => 190,
		:Happiness => 35,
		:EggSteps => 6630,
		:EggMoves => [:DARKPULSE,:DESTINYBOND,:FEINTATTACK,:GRUDGE,:HAZE,:IMPRISON,:MEMENTO,:OMINOUSWIND,:PAINSPLIT,:SKILLSWAP,],
		:Moveset => [
			[1,:LEER],
			[1,:NIGHTSHADE],
			[6,:DISABLE],
			[9,:ASTONISH],
			[14,:FORESIGHT],
			[17,:SHADOWSNEAK],
			[22,:PURSUIT],
			[25,:WILLOWISP],
			[30,:CONFUSERAY],
			[33,:CURSE],
			[38,:HEX],
			[41,:SHADOWBALL],
			[46,:MEANLOOK],
			[49,:PAYBACK],
			[54,:FUTURESIGHT]],
		:compatiblemoves => [:ALLYSWITCH,:BLIZZARD,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:DARKPULSE,:DOUBLEEDGE,:DREAMEATER,:EMBARGO,:FLASH,:FLING,:FUTURESIGHT,:GRAVITY,:HEADBUTT,:HELPINGHAND,:HEX,:ICEBEAM,:ICYWIND,:IMPRISON,:INFESTATION,:MIMIC,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:RAINDANCE,:REVENGE,:SHADOWBALL,:SKILLSWAP,:SKITTERSMACK,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:TORMENT,:TRICK,:TRICKROOM,:WILLOWISP,:WONDERROOM,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWHOLD,:SHADOWWAVE,],
		:Color => "Black",
		:Habitat => "Forest",
		:EggGroups => [:Amorphous],
		:Height => 8,
		:Weight => 150,
		:WildItemUncommon => :SPELLTAG,
		:kind => "Requiem",
		:dexentry => "A glare from its single scarlet eye makes even burly grown-ups freeze in fear. It is a nocturnal Pokémon that roams about under the cloak of darkness.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 11,
		:evolutions => [
			[:DUSCLOPS,:Level,37]
		]
	},

	:OnCreation => {},
},

:DUSCLOPS => {
	"Normal Form" => {
		:name => "Dusclops",
		:dexnum => 356,
		:Type1 => :GHOST,
		:BaseStats => [40, 70, 130, 60, 130, 25],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:PRESSURE, :FRISK],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 90,
		:Happiness => 35,
		:EggSteps => 6630,
		:preevo => {
			:species => :DUSKULL,
			:form => 0
		},
		:Moveset => [
			[0,:SHADOWPUNCH],
			[1,:FUTURESIGHT],
			[1,:FIREPUNCH],
			[1,:ICEPUNCH],
			[1,:THUNDERPUNCH],
			[1,:GRAVITY],
			[1,:BIND],
			[1,:LEER],
			[1,:NIGHTSHADE],
			[1,:DISABLE],
			[1,:ASTONISH],
			[6,:DISABLE],
			[9,:ASTONISH],
			[14,:FORESIGHT],
			[17,:SHADOWSNEAK],
			[22,:PURSUIT],
			[25,:WILLOWISP],
			[30,:CONFUSERAY],
			[33,:CURSE],
			[40,:HEX],
			[45,:SHADOWBALL],
			[52,:MEANLOOK],
			[57,:PAYBACK],
			[64,:FUTURESIGHT]],
		:compatiblemoves => [:ALLYSWITCH,:BIND,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:COUNTER,:DARKPULSE,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:EMBARGO,:FIREPUNCH,:FLASH,:FLING,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HELPINGHAND,:HEX,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:INFESTATION,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POLTERGEIST,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:RAINDANCE,:REVENGE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEISMICTOSS,:SHADOWBALL,:SKILLSWAP,:SKITTERSMACK,:SNATCH,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDERPUNCH,:TORMENT,:TRICK,:TRICKROOM,:WILLOWISP,:WONDERROOM,],
		:moveexceptions => [],
		:Color => "Black",
		:Habitat => "Forest",
		:EggGroups => [:Amorphous],
		:Height => 16,
		:Weight => 306,
		:WildItemUncommon => :SPELLTAG,
		:kind => "Beckon",
		:dexentry => "It is thought that its body is hollow with only a spectral ball of fire burning inside. However, no one has been able to confirm this theory as fact.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DUSKNOIR,:TradeItem,:REAPERCLOTH]
		]
	},

	:OnCreation => {},
},

:TROPIUS => {
	"Normal Form" => {
		:name => "Tropius",
		:dexnum => 357,
		:Type1 => :GRASS,
		:Type2 => :FLYING,
		:BaseStats => [99, 68, 83, 72, 87, 51],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :SOLARPOWER],
		:HiddenAbilities => :HARVEST,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:BULLETSEED,:CURSE,:DRAGONDANCE,:DRAGONHAMMER,:HEADBUTT,:LEAFBLADE,:LEAFSTORM,:LEECHSEED,:NATURALGIFT,:RAZORWIND,:SLAM,:SYNTHESIS,],
		:Moveset => [
			[1,:LEAFSTORM],
			[1,:LEER],
			[1,:GUST],
			[1,:GROWTH],
			[1,:RAZORLEAF],
			[6,:SWEETSCENT],
			[10,:STOMP],
			[16,:MAGICALLEAF],
			[21,:WHIRLWIND],
			[26,:LEAFTORNADO],
			[30,:NATURALGIFT],
			[36,:AIRSLASH],
			[41,:BODYSLAM],
			[46,:BESTOW],
			[50,:SYNTHESIS],
			[56,:SOLARBEAM],
			[61,:LEAFSTORM]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:BODYPRESS,:BODYSLAM,:BRUTALSWING,:BULLDOZE,:BULLETSEED,:CUT,:DEFOG,:DOUBLEEDGE,:DRAGONDANCE,:DRAGONPULSE,:DUALWINGBEAT,:EARTHQUAKE,:ENERGYBALL,:FLASH,:FLY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HURRICANE,:HYPERBEAM,:LEAFBLADE,:LEAFSTORM,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:OMINOUSWIND,:OUTRAGE,:ROAR,:ROCKSMASH,:ROOST,:SAFEGUARD,:SEEDBOMB,:SILVERWIND,:SOLARBEAM,:STEELWING,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:TAILWIND,:TWISTER,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:Habitat => "Forest",
		:EggGroups => [:Monster, :Grass],
		:Height => 20,
		:Weight => 1000,
		:kind => "Fruit",
		:dexentry => "It flies by flapping its broad leaves. The bunch of fruit that grows around its neck is deliciously sweet. In the spring, it scatters pollen from its neck.",
		:BattlerPlayerY => 8,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CHIMECHO => {
	"Normal Form" => {
		:name => "Chimecho",
		:dexnum => 358,
		:Type1 => :PSYCHIC,
		:BaseStats => [75, 50, 80, 95, 90, 65],
		:EVs => [0, 0, 0, 1, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:COSMICPOWER,:CRAFTYSHIELD,:CURSE,:DISABLE,:FUTURESIGHT,:HYPNOSIS,:PERISHSONG,:RECOVER,:SKILLSWAP,:STOREDPOWER,:WISH,],
		:preevo => {
			:species => :CHINGLING,
			:form => 0
		},
		:Moveset => [
			[1,:HEALINGWISH],
			[1,:SYNCHRONOISE],
			[1,:WRAP],
			[1,:GROWL],
			[1,:ASTONISH],
			[1,:CONFUSION],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:CONFUSION],
			[13,:YAWN],
			[16,:PSYWAVE],
			[19,:TAKEDOWN],
			[22,:EXTRASENSORY],
			[27,:HEALBELL],
			[32,:UPROAR],
			[37,:SAFEGUARD],
			[42,:DOUBLEEDGE],
			[47,:HEALPULSE],
			[52,:SYNCHRONOISE],
			[57,:HEALINGWISH]],
		:compatiblemoves => [:ALLYSWITCH,:BIND,:CALMMIND,:CHARGEBEAM,:CHARM,:COSMICPOWER,:DAZZLINGGLEAM,:DEFENSECURL,:DEFOG,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:ENERGYBALL,:EXPANDINGFORCE,:FAKETEARS,:FLASH,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICYWIND,:IMPRISON,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:NIGHTMARE,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SPEEDSWAP,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Grassland",
		:EggGroups => [:Amorphous],
		:Height => 6,
		:Weight => 10,
		:WildItemUncommon => :CLEANSETAG,
		:kind => "Wind Chime",
		:dexentry => "They fly about very actively when the hot season arrives. They communicate among themselves using seven different and distinguishing cries.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:ABSOL => {
	"Normal Form" => {
		:name => "Absol",
		:dexnum => 359,
		:Type1 => :DARK,
		:BaseStats => [65, 130, 60, 75, 60, 75],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:PRESSURE, :SUPERLUCK],
		:HiddenAbilities => :JUSTIFIED,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 163,
		:CatchRate => 30,
		:Happiness => 35,
		:EggSteps => 6630,
		:EggMoves => [:ASSURANCE,:BATONPASS,:CURSE,:DOUBLEEDGE,:FEINTATTACK,:HEX,:MAGICCOAT,:MEFIRST,:MEANLOOK,:MEGAHORN,:PERISHSONG,:PLAYROUGH,:PUNISHMENT,:SUCKERPUNCH,:ZENHEADBUTT,],
		:Moveset => [
			[1,:PERISHSONG],
			[1,:FUTURESIGHT],
			[1,:SCRATCH],
			[1,:FEINT],
			[1,:LEER],
			[1,:QUICKATTACK],
			[4,:LEER],
			[7,:QUICKATTACK],
			[10,:PURSUIT],
			[13,:TAUNT],
			[16,:BITE],
			[19,:DOUBLETEAM],
			[22,:SLASH],
			[25,:SWORDSDANCE],
			[29,:NIGHTSLASH],
			[33,:DETECT],
			[37,:PSYCHOCUT],
			[41,:MEFIRST],
			[45,:SUCKERPUNCH],
			[49,:RAZORWIND],
			[53,:FUTURESIGHT],
			[57,:PERISHSONG]],
		:compatiblemoves => [:AERIALACE,:AIRSLASH,:ASSURANCE,:BATONPASS,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRUTALSWING,:CALMMIND,:CHARGEBEAM,:COUNTER,:CUT,:DARKPULSE,:DOUBLEEDGE,:DREAMEATER,:ECHOEDVOICE,:FALSESWIPE,:FIREBLAST,:FLAMETHROWER,:FLASH,:FOCUSENERGY,:FOULPLAY,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEX,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:MAGICCOAT,:MEGAHORN,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAYBACK,:PLAYROUGH,:PSYCHOCUT,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SANDSTORM,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNARL,:SNATCH,:SPITE,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:WATERPULSE,:WILLOWISP,:XSCISSOR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "Mountain",
		:EggGroups => [:Field],
		:Height => 12,
		:Weight => 470,
		:kind => "Disaster",
		:dexentry => "It sharply senses even subtle changes in sky and land to predict natural disasters. It is a long-lived Pokémon with a life-span of 100 years.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [65, 150, 60, 115, 60, 115],
		:Abilities => [:MAGICBOUNCE],
		:Weight => 490,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:ABSOLITE => 1,
	},
},

:WYNAUT => {
	"Normal Form" => {
		:name => "Wynaut",
		:dexnum => 360,
		:Type1 => :PSYCHIC,
		:BaseStats => [95, 23, 48, 23, 48, 23],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SHADOWTAG, :TELEPATHY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 52,
		:CatchRate => 125,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:SPLASH],
			[1,:CHARM],
			[1,:ENCORE],
			[15,:COUNTER],
			[15,:MIRRORCOAT],
			[15,:SAFEGUARD],
			[15,:DESTINYBOND]],
		:compatiblemoves => [:AMNESIA,:CHARM,:COUNTER,:ENCORE,:SAFEGUARD,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Blue",
		:Habitat => "Cave",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 140,
		:kind => "Bright",
		:dexentry => "A Wynaut loves to eat sweet fruits. It cleverly picks fruits using its earlike arms. They gather in fruit gardens, drawn by the fragrance.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WOBBUFFET,:Level,15]
		]
	},

	:OnCreation => {},
},

:SNORUNT => {
	"Normal Form" => {
		:name => "Snorunt",
		:dexnum => 361,
		:Type1 => :ICE,
		:BaseStats => [50, 50, 50, 50, 50, 50],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:INNERFOCUS, :ICEBODY],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AVALANCHE,:BIDE,:BLOCK,:DISABLE,:FAKETEARS,:HEX,:ROLLOUT,:SPIKES,:SWITCHEROO,:WEATHERBALL,],
		:Moveset => [
			[1,:POWDERSNOW],
			[1,:LEER],
			[5,:DOUBLETEAM],
			[10,:ICESHARD],
			[14,:ICYWIND],
			[19,:BITE],
			[23,:ICEFANG],
			[28,:HEADBUTT],
			[32,:PROTECT],
			[37,:FROSTBREATH],
			[41,:CRUNCH],
			[46,:BLIZZARD],
			[50,:HAIL]],
		:compatiblemoves => [:AVALANCHE,:BLIZZARD,:BLOCK,:BODYSLAM,:CRUNCH,:DOUBLEEDGE,:FAKETEARS,:FLASH,:FROSTBREATH,:HAIL,:HEADBUTT,:HEX,:ICEBEAM,:ICEFANG,:ICYWIND,:LIGHTSCREEN,:MIMIC,:RAINDANCE,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SPIKES,:SPITE,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWSHED,:SHADOWWAVE,],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Fairy, :Mineral],
		:Height => 7,
		:Weight => 168,
		:WildItemUncommon => :SNOWBALL,
		:kind => "Snow Hat",
		:dexentry => "They tend to move about in groups of around five. In snowy regions, it is said that when they are seen late at night, snowfall will arrive by morning.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GLALIE,:Level,42],
			[:FROSLASS,:ItemFemale,:DAWNSTONE]
		]
	},

	:OnCreation => {},
},

:GLALIE => {
	"Normal Form" => {
		:name => "Glalie",
		:dexnum => 362,
		:Type1 => :ICE,
		:BaseStats => [80, 80, 80, 80, 80, 80],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:INNERFOCUS, :ICEBODY],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 168,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SNORUNT,
			:form => 0
		},
		:Moveset => [
			[0,:FREEZEDRY],
			[1,:SHEERCOLD],
			[1,:POWDERSNOW],
			[1,:LEER],
			[1,:DOUBLETEAM],
			[1,:ICESHARD],
			[5,:DOUBLETEAM],
			[10,:ICESHARD],
			[14,:ICYWIND],
			[19,:BITE],
			[23,:ICEFANG],
			[28,:HEADBUTT],
			[32,:PROTECT],
			[37,:FROSTBREATH],
			[41,:CRUNCH],
			[48,:BLIZZARD],
			[54,:HAIL],
			[61,:SHEERCOLD]],
		:compatiblemoves => [:AVALANCHE,:BLIZZARD,:BLOCK,:BODYSLAM,:BULLDOZE,:CRUNCH,:DARKPULSE,:DEFENSECURL,:DOUBLEEDGE,:EARTHQUAKE,:EXPLOSION,:FAKETEARS,:FLASH,:FROSTBREATH,:GIGAIMPACT,:GYROBALL,:HAIL,:HEADBUTT,:HEX,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICICLESPEAR,:ICYWIND,:IRONHEAD,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:PAYBACK,:RAINDANCE,:ROLLOUT,:SAFEGUARD,:SCARYFACE,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SPIKES,:SPITE,:STEELROLLER,:SUPERFANG,:TAUNT,:TORMENT,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Fairy, :Mineral],
		:Height => 15,
		:Weight => 2565,
		:kind => "Face",
		:dexentry => "A Glalie has the power to immediately freeze moisture in the atmosphere. A dazzling cloud of diamondlike ice crystals forms around its body.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 10,
	},

	"Mega Form" => {
		:BaseStats => [80, 120, 80, 120, 80, 100],
		:Abilities => [:REFRIGERATE],
		:Height => 21,
		:Weight => 3502,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GLALITITE => 1,
	},
},

:SPHEAL => {
	"Normal Form" => {
		:name => "Spheal",
		:dexnum => 363,
		:Type1 => :ICE,
		:Type2 => :WATER,
		:BaseStats => [70, 40, 50, 55, 50, 25],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :ICEBODY],
		:HiddenAbilities => :OBLIVIOUS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUARING,:BELLYDRUM,:CURSE,:FISSURE,:ROLLOUT,:SIGNALBEAM,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WATERPULSE,:WATERSPORT,:YAWN,],
		:Moveset => [
			[1,:DEFENSECURL],
			[1,:POWDERSNOW],
			[1,:GROWL],
			[1,:WATERGUN],
			[5,:ROLLOUT],
			[9,:ENCORE],
			[13,:ICEBALL],
			[17,:BRINE],
			[21,:AURORABEAM],
			[26,:BODYSLAM],
			[31,:REST],
			[31,:SNORE],
			[36,:HAIL],
			[41,:BLIZZARD],
			[46,:SHEERCOLD]],
		:compatiblemoves => [:AQUATAIL,:BLIZZARD,:BODYSLAM,:BRINE,:BULLDOZE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:ECHOEDVOICE,:ENCORE,:FROSTBREATH,:HAIL,:HEADBUTT,:ICEBEAM,:ICYWIND,:IRONTAIL,:MIMIC,:MUDSLAP,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SIGNALBEAM,:STEELROLLER,:STRENGTH,:SUPERFANG,:SURF,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWWAVE,:SHADOWMIST,],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Field],
		:Height => 8,
		:Weight => 395,
		:kind => "Clap",
		:dexentry => "It is completely covered with plushy fur. As a result, it never feels the cold even when it is rolling about on ice floes or diving in the sea.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SEALEO,:Level,32]
		]
	},

	:OnCreation => {},
},

:SEALEO => {
	"Normal Form" => {
		:name => "Sealeo",
		:dexnum => 364,
		:Type1 => :ICE,
		:Type2 => :WATER,
		:BaseStats => [90, 60, 70, 75, 70, 45],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :ICEBODY],
		:HiddenAbilities => :OBLIVIOUS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SPHEAL,
			:form => 0
		},
		:Moveset => [
			[0,:SWAGGER],
			[1,:DEFENSECURL],
			[1,:POWDERSNOW],
			[1,:GROWL],
			[1,:WATERGUN],
			[5,:ROLLOUT],
			[9,:ENCORE],
			[13,:ICEBALL],
			[17,:BRINE],
			[21,:AURORABEAM],
			[26,:BODYSLAM],
			[31,:REST],
			[31,:SNORE],
			[38,:HAIL],
			[45,:BLIZZARD],
			[52,:SHEERCOLD]],
		:compatiblemoves => [:AQUATAIL,:BLIZZARD,:BODYSLAM,:BRINE,:BULLDOZE,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:ECHOEDVOICE,:ENCORE,:FROSTBREATH,:HAIL,:HEADBUTT,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:MIMIC,:MUDSLAP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SIGNALBEAM,:STEELROLLER,:STRENGTH,:SUPERFANG,:SURF,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Field],
		:Height => 11,
		:Weight => 876,
		:kind => "Ball Roll",
		:dexentry => "Sealeo live in herds on ice floes. Using its powerful flippers, it shatters ice. It dives into the sea to hunt prey five times a day.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WALREIN,:Level,44]
		]
	},

	:OnCreation => {},
},

:WALREIN => {
	"Normal Form" => {
		:name => "Walrein",
		:dexnum => 365,
		:Type1 => :ICE,
		:Type2 => :WATER,
		:BaseStats => [110, 80, 90, 95, 90, 65],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:THICKFAT, :ICEBODY],
		:HiddenAbilities => :OBLIVIOUS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SEALEO,
			:form => 0
		},
		:Moveset => [
			[0,:ICEFANG],
			[1,:SWAGGER],
			[1,:CRUNCH],
			[1,:DEFENSECURL],
			[1,:POWDERSNOW],
			[1,:GROWL],
			[1,:WATERGUN],
			[7,:ROLLOUT],
			[7,:ENCORE],
			[13,:ICEBALL],
			[19,:BRINE],
			[19,:AURORABEAM],
			[25,:BODYSLAM],
			[31,:REST],
			[31,:SNORE],
			[38,:HAIL],
			[49,:BLIZZARD],
			[60,:SHEERCOLD]],
		:compatiblemoves => [:AQUATAIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRINE,:BULLDOZE,:CRUNCH,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:ECHOEDVOICE,:ENCORE,:FROSTBREATH,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEAVYSLAM,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICICLESPEAR,:ICYWIND,:IRONHEAD,:IRONTAIL,:LIQUIDATION,:MIMIC,:MUDSLAP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SIGNALBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUPERFANG,:SURF,:SWORDSDANCE,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Field],
		:Height => 14,
		:Weight => 1506,
		:kind => "Ice Break",
		:dexentry => "To protect its herd, the leader battles anything that invades its territory, even at the cost of its life. Its tusks may snap off in battle.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CLAMPERL => {
	"Normal Form" => {
		:name => "Clamperl",
		:dexnum => 366,
		:Type1 => :WATER,
		:BaseStats => [35, 64, 85, 74, 55, 32],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SHELLARMOR, :RATTLED],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 69,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUARING,:BARRIER,:BODYSLAM,:BRINE,:CONFUSERAY,:ENDURE,:MUDSPORT,:MUDDYWATER,:REFRESH,:SUPERSONIC,:WATERPULSE,],
		:Moveset => [
			[1,:CLAMP],
			[1,:WATERGUN],
			[1,:WHIRLPOOL],
			[1,:IRONDEFENSE],
			[50,:SHELLSMASH]],
		:compatiblemoves => [:BLIZZARD,:BODYSLAM,:BRINE,:DIVE,:DOUBLEEDGE,:HAIL,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:MIMIC,:MUDDYWATER,:RAINDANCE,:SCALD,:SURF,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1],
		:Height => 4,
		:Weight => 525,
		:WildItemCommon => :PEARL,
		:WildItemUncommon => :BIGPEARL,
		:kind => "Bivalve",
		:dexentry => "A Clamperl slams its shell closed on prey to prevent escape. The pearl it creates upon evolution is said to be infused with a mysterious energy.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HUNTAIL,:TradeItem,:DEEPSEATOOTH],
			[:GOREBYSS,:TradeItem,:DEEPSEASCALE]
		]
	},

	:OnCreation => {},
},

:HUNTAIL => {
	"Normal Form" => {
		:name => "Huntail",
		:dexnum => 367,
		:Type1 => :WATER,
		:BaseStats => [55, 104, 105, 94, 75, 52],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :WATERVEIL],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CLAMPERL,
			:form => 0
		},
		:Moveset => [
			[1,:WHIRLPOOL],
			[1,:BITE],
			[5,:SCREECH],
			[9,:SCARYFACE],
			[11,:FEINTATTACK],
			[14,:WATERPULSE],
			[16,:ICEFANG],
			[19,:BRINE],
			[23,:SUCKERPUNCH],
			[26,:DIVE],
			[29,:BATONPASS],
			[34,:CRUNCH],
			[39,:AQUATAIL],
			[45,:COIL],
			[50,:HYDROPUMP]],
		:compatiblemoves => [:AQUATAIL,:BATONPASS,:BIND,:BLIZZARD,:BODYSLAM,:BOUNCE,:BREAKINGSWIPE,:BRINE,:CRUNCH,:DIVE,:DOUBLEEDGE,:FLIPTURN,:GIGAIMPACT,:HAIL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:INFESTATION,:IRONDEFENSE,:MIMIC,:MUDDYWATER,:MUDSLAP,:RAINDANCE,:RAZORSHELL,:ROCKTOMB,:SCALD,:SCARYFACE,:SNATCH,:SUCKERPUNCH,:SUPERFANG,:SURF,:SWIFT,:THUNDERFANG,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Water1],
		:Height => 17,
		:Weight => 270,
		:WildItemUncommon => :DEEPSEATOOTH,
		:kind => "Deep Sea",
		:dexentry => "To withstand the pressure of water deep under the sea, its spine is very sturdy. Its tail, which is shaped like a small fish, has eyes that light up.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 8,
	},

	:OnCreation => {},
},

:GOREBYSS => {
	"Normal Form" => {
		:name => "Gorebyss",
		:dexnum => 368,
		:Type1 => :WATER,
		:BaseStats => [55, 84, 105, 114, 75, 52],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SWIFTSWIM, :HYDRATION],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CLAMPERL,
			:form => 0
		},
		:Moveset => [
			[1,:WHIRLPOOL],
			[1,:CONFUSION],
			[5,:WATERSPORT],
			[9,:AGILITY],
			[11,:DRAININGKISS],
			[14,:WATERPULSE],
			[16,:AMNESIA],
			[19,:AQUARING],
			[23,:CAPTIVATE],
			[26,:DIVE],
			[29,:BATONPASS],
			[34,:PSYCHIC],
			[39,:AQUATAIL],
			[45,:COIL],
			[50,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AMNESIA,:AQUATAIL,:BATONPASS,:BIND,:BLIZZARD,:BODYSLAM,:BOUNCE,:BRINE,:CHARM,:DIVE,:DOUBLEEDGE,:DRAININGKISS,:FLIPTURN,:GIGAIMPACT,:HAIL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INFESTATION,:IRONDEFENSE,:MIMIC,:MUDDYWATER,:MUDSLAP,:PLAYROUGH,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RAZORSHELL,:SAFEGUARD,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SURF,:SWIFT,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Sea",
		:EggGroups => [:Water1],
		:Height => 18,
		:Weight => 226,
		:WildItemUncommon => :DEEPSEASCALE,
		:kind => "South Sea",
		:dexentry => "A Gorebyss siphons the body fluids of prey through its thin, tubular mouth. Its light pink body color turns vivid when it finishes feeding.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:RELICANTH => {
	"Normal Form" => {
		:name => "Relicanth",
		:dexnum => 369,
		:Type1 => :WATER,
		:Type2 => :ROCK,
		:BaseStats => [100, 90, 130, 45, 65, 55],
		:EVs => [1, 0, 1, 0, 0, 0],
		:Abilities => [:SWIFTSWIM, :ROCKHEAD],
		:HiddenAbilities => :STURDY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 170,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:AMNESIA,:AQUATAIL,:BRINE,:MAGNITUDE,:MUDSHOT,:MUDSLAP,:MUDDYWATER,:SKULLBASH,:SLEEPTALK,:SNORE,:WATERSPORT,:ZENHEADBUTT,],
		:Moveset => [
			[1,:FLAIL],
			[1,:HEADSMASH],
			[1,:TACKLE],
			[1,:HARDEN],
			[1,:MUDSPORT],
			[1,:WATERGUN],
			[6,:MUDSPORT],
			[10,:WATERGUN],
			[15,:ROCKTOMB],
			[21,:ANCIENTPOWER],
			[26,:DIVE],
			[31,:TAKEDOWN],
			[35,:YAWN],
			[41,:REST],
			[46,:HYDROPUMP],
			[50,:DOUBLEEDGE],
			[56,:HEADSMASH]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BOUNCE,:BRINE,:BULLDOZE,:CALMMIND,:DIVE,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONDEFENSE,:LIQUIDATION,:METEORBEAM,:MIMIC,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PSYCHUP,:RAINDANCE,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SCALD,:SCALESHOT,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:SURF,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Gray",
		:Habitat => "Sea",
		:EggGroups => [:Water1, :Water2],
		:Height => 10,
		:Weight => 234,
		:WildItemUncommon => :DEEPSEASCALE,
		:kind => "Longevity",
		:dexentry => "A Pokémon that was once believed to have been extinct. The species has not changed for 100 million years. It walks on the seafloor using its pectoral fins.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:LUVDISC => {
	"Normal Form" => {
		:name => "Luvdisc",
		:dexnum => 370,
		:Type1 => :WATER,
		:BaseStats => [43, 30, 55, 40, 65, 97],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :HYDRATION],
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 116,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUAJET,:AQUARING,:BRINE,:CAPTIVATE,:ENTRAINMENT,:HEALPULSE,:MUDSPORT,:SPLASH,:SUPERSONIC,:WATERSPORT,],
		:Moveset => [
			[1,:TACKLE],
			[1,:CHARM],
			[4,:WATERGUN],
			[7,:AGILITY],
			[9,:DRAININGKISS],
			[13,:LUCKYCHANT],
			[17,:WATERPULSE],
			[20,:ATTRACT],
			[22,:HEARTSTAMP],
			[26,:FLAIL],
			[31,:SWEETKISS],
			[34,:TAKEDOWN],
			[37,:CAPTIVATE],
			[40,:AQUARING],
			[42,:SOAK],
			[46,:HYDROPUMP],
			[49,:SAFEGUARD]],
		:compatiblemoves => [:AGILITY,:BLIZZARD,:BOUNCE,:BRINE,:CHARM,:DIVE,:DOUBLEEDGE,:DRAININGKISS,:ENCORE,:EXPANDINGFORCE,:FAKETEARS,:FLIPTURN,:HAIL,:HYDROPUMP,:ICEBEAM,:ICYWIND,:LIQUIDATION,:MIMIC,:MISTYTERRAIN,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SCALD,:SPEEDSWAP,:SURF,:SWIFT,:TERRAINPULSE,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Pink",
		:Habitat => "Sea",
		:EggGroups => [:Water2],
		:Height => 6,
		:Weight => 87,
		:WildItemCommon => :HEARTSCALE,
		:kind => "Rendezvous",
		:dexentry => "Luvdisc make the branches of Corsola their nests. There is a custom from long ago of giving a Luvdisc as a gift to express one's feelings of love.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:BAGON => {
	"Normal Form" => {
		:name => "Bagon",
		:dexnum => 371,
		:Type1 => :DRAGON,
		:BaseStats => [45, 75, 60, 40, 30, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :SHEERFORCE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:EggMoves => [:DEFENSECURL,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONRUSH,:ENDURE,:FIREFANG,:HYDROPUMP,:THRASH,:TWISTER,],
		:Moveset => [
			[1,:RAGE],
			[4,:EMBER],
			[7,:LEER],
			[10,:BITE],
			[13,:DRAGONBREATH],
			[17,:HEADBUTT],
			[21,:FOCUSENERGY],
			[25,:CRUNCH],
			[29,:DRAGONCLAW],
			[34,:ZENHEADBUTT],
			[39,:SCARYFACE],
			[44,:FLAMETHROWER],
			[49,:DOUBLEEDGE]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BRICKBREAK,:CRUNCH,:CUT,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FOCUSENERGY,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERVOICE,:INCINERATE,:IRONDEFENSE,:MIMIC,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:TWISTER,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Dragon],
		:Height => 6,
		:Weight => 421,
		:WildItemUncommon => :DRAGONFANG,
		:kind => "Rock Head",
		:dexentry => "Although it is small, this Pokémon is very powerful because its body is a bundle of muscles. It launches head-butts with its ironlike skull.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SHELGON,:Level,30]
		]
	},

	:OnCreation => {},
},

:SHELGON => {
	"Normal Form" => {
		:name => "Shelgon",
		:dexnum => 372,
		:Type1 => :DRAGON,
		:BaseStats => [65, 95, 100, 60, 50, 50],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:ROCKHEAD, :OVERCOAT],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :BAGON,
			:form => 0
		},
		:Moveset => [
			[0,:PROTECT],
			[1,:RAGE],
			[1,:EMBER],
			[1,:LEER],
			[1,:BITE],
			[4,:EMBER],
			[7,:LEER],
			[10,:BITE],
			[13,:DRAGONBREATH],
			[17,:HEADBUTT],
			[21,:FOCUSENERGY],
			[25,:CRUNCH],
			[29,:DRAGONCLAW],
			[35,:ZENHEADBUTT],
			[42,:SCARYFACE],
			[49,:FLAMETHROWER],
			[56,:DOUBLEEDGE]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BRICKBREAK,:CRUNCH,:CUT,:DEFENSECURL,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FOCUSENERGY,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:HYDROPUMP,:HYPERVOICE,:INCINERATE,:IRONDEFENSE,:MIMIC,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SCARYFACE,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:TWISTER,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Dragon],
		:Height => 11,
		:Weight => 1105,
		:WildItemUncommon => :DRAGONFANG,
		:kind => "Endurance",
		:dexentry => "It hardly eats while it awaits evolution. It becomes hardier by enduring hunger. Its shell peels off the instant it begins to evolve.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SALAMENCE,:Level,50]
		]
	},

	:OnCreation => {},
},

:SALAMENCE => {
	"Normal Form" => {
		:name => "Salamence",
		:dexnum => 373,
		:Type1 => :DRAGON,
		:Type2 => :FLYING,
		:BaseStats => [95, 135, 80, 110, 80, 100],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :MOXIE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :SHELGON,
			:form => 0
		},
		:Moveset => [
			[0,:FLY],
			[1,:PROTECT],
			[1,:DRAGONTAIL],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:RAGE],
			[1,:EMBER],
			[1,:LEER],
			[1,:BITE],
			[4,:EMBER],
			[7,:LEER],
			[10,:BITE],
			[13,:DRAGONBREATH],
			[17,:HEADBUTT],
			[21,:FOCUSENERGY],
			[25,:CRUNCH],
			[29,:DRAGONCLAW],
			[35,:ZENHEADBUTT],
			[42,:SCARYFACE],
			[49,:FLAMETHROWER],
			[63,:DOUBLEEDGE]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:AQUATAIL,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CRUNCH,:CUT,:DEFENSECURL,:DEFOG,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:DUALWINGBEAT,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FLY,:FOCUSENERGY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HONECLAWS,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:INCINERATE,:IRONDEFENSE,:IRONTAIL,:LASERFOCUS,:MIMIC,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:ROOST,:SCARYFACE,:SHADOWCLAW,:STEELWING,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILWIND,:THUNDERFANG,:TWISTER,:ZENHEADBUTT,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWHOLD,],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Dragon],
		:Height => 15,
		:Weight => 1026,
		:WildItemUncommon => :DRAGONFANG,
		:kind => "Dragon",
		:dexentry => "After many long years, its cellular structure underwent a sudden mutation to grow wings. When angered, it loses all thought and rampages out of control.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [95, 145, 130, 120, 90, 120],
		:Abilities => [:AERILATE],
		:Height => 18,
		:Weight => 1125,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:SALAMENCITE => 1,
	},
},

:BELDUM => {
	"Normal Form" => {
		:name => "Beldum",
		:dexnum => 374,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [40, 55, 80, 35, 60, 30],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:CLEARBODY, :LIGHTMETAL],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 60,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 10455,
		:Moveset => [
			[1,:TAKEDOWN]],
		:compatiblemoves => [:HEADBUTT,:IRONDEFENSE,:IRONHEAD,:STEELBEAM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 6,
		:Weight => 952,
		:WildItemUncommon => :METALCOAT,
		:kind => "Iron Ball",
		:dexentry => "When Beldum gather in a swarm, they move in perfect unison as if they were but one Pokémon. They communicate with each other using brain waves.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 12,
		:evolutions => [
			[:METANG,:Level,20]
		]
	},

	:OnCreation => {},
},

:METANG => {
	"Normal Form" => {
		:name => "Metang",
		:dexnum => 375,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [60, 75, 100, 55, 80, 50],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:CLEARBODY, :LIGHTMETAL],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 147,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :BELDUM,
			:form => 0
		},
		:Moveset => [
			[0,:CONFUSION],
			[0,:METALCLAW],
			[1,:MAGNETRISE],
			[1,:TAKEDOWN],
			[23,:PURSUIT],
			[26,:BULLETPUNCH],
			[29,:MIRACLEEYE],
			[32,:ZENHEADBUTT],
			[35,:SCARYFACE],
			[38,:PSYCHIC],
			[41,:AGILITY],
			[44,:METEORMASH],
			[47,:IRONDEFENSE],
			[50,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:COSMICPOWER,:CUT,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:FLASHCANNON,:FURYCUTTER,:GRASSKNOT,:GRAVITY,:GYROBALL,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:IRONHEAD,:LIGHTSCREEN,:MAGNETRISE,:METEORBEAM,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SLUDGEBOMB,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STRENGTH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDERPUNCH,:TRICK,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 12,
		:Weight => 2025,
		:WildItemUncommon => :METALCOAT,
		:kind => "Iron Claw",
		:dexentry => "The claws tipping its arms pack the destructive power to tear through thick iron sheets as if they were silk. It flies at over 60 miles per hour.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 3,
		:evolutions => [
			[:METAGROSS,:Level,45]
		]
	},

	:OnCreation => {},
},

:METAGROSS => {
	"Normal Form" => {
		:name => "Metagross",
		:dexnum => 376,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [80, 135, 130, 95, 90, 70],
		:EVs => [0, 0, 3, 0, 0, 0],
		:Abilities => [:CLEARBODY, :LIGHTMETAL],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 10455,
		:preevo => {
			:species => :METANG,
			:form => 0
		},
		:Moveset => [
			[0,:HAMMERARM],
			[1,:CONFUSION],
			[1,:METALCLAW],
			[1,:MAGNETRISE],
			[1,:TAKEDOWN],
			[23,:PURSUIT],
			[26,:BULLETPUNCH],
			[29,:MIRACLEEYE],
			[32,:ZENHEADBUTT],
			[35,:SCARYFACE],
			[38,:PSYCHIC],
			[41,:AGILITY],
			[44,:METEORMASH],
			[52,:IRONDEFENSE],
			[60,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:COSMICPOWER,:CUT,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:FLASHCANNON,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GYROBALL,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:IRONHEAD,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:METEORBEAM,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SELFDESTRUCT,:SHADOWBALL,:SIGNALBEAM,:SLUDGEBOMB,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDERPUNCH,:TRICK,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Mineral],
		:Height => 16,
		:Weight => 5500,
		:WildItemUncommon => :METALCOAT,
		:kind => "Iron Leg",
		:dexentry => "Metagross has four brains that are joined by a complex neural network. As a result of integration, this Pokémon is smarter than a supercomputer.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [80, 145, 150, 105, 110, 110],
		:Abilities => [:TOUGHCLAWS],
		:Height => 25,
		:Weight => 9429,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:METAGROSSITE => 1,
	},
},

:REGIROCK => {
	"Normal Form" => {
		:name => "Regirock",
		:dexnum => 377,
		:Type1 => :ROCK,
		:BaseStats => [80, 100, 200, 50, 100, 50],
		:EVs => [0, 0, 3, 0, 0, 0],
		:Abilities => [:CLEARBODY, :STURDY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:EXPLOSION],
			[1,:STOMP],
			[1,:ROCKTHROW],
			[1,:CHARGEBEAM],
			[1,:BULLDOZE],
			[7,:ROCKTHROW],
			[13,:CHARGEBEAM],
			[19,:BULLDOZE],
			[25,:CURSE],
			[31,:ANCIENTPOWER],
			[37,:IRONDEFENSE],
			[43,:STONEEDGE],
			[49,:HAMMERARM],
			[55,:LOCKON],
			[55,:ZAPCANNON],
			[61,:SUPERPOWER],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAINPUNCH,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREPUNCH,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:ICEPUNCH,:IRONDEFENSE,:IRONHEAD,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHUP,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SEISMICTOSS,:SELFDESTRUCT,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Brown",
		:Habitat => "Cave",
		:EggGroups => [:Undiscovered],
		:Height => 17,
		:Weight => 2300,
		:kind => "Rock Peak",
		:dexentry => "A Pokémon that is made entirely of rocks and boulders. If parts of its body chip off in battle, Regirock repairs itself by adding new rocks.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:REGICE => {
	"Normal Form" => {
		:name => "Regice",
		:dexnum => 378,
		:Type1 => :ICE,
		:BaseStats => [80, 50, 100, 100, 200, 50],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:CLEARBODY, :ICEBODY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:EXPLOSION],
			[1,:STOMP],
			[1,:ICYWIND],
			[1,:CHARGEBEAM],
			[1,:BULLDOZE],
			[7,:ICYWIND],
			[13,:CHARGEBEAM],
			[19,:BULLDOZE],
			[25,:CURSE],
			[31,:ANCIENTPOWER],
			[37,:AMNESIA],
			[43,:ICEBEAM],
			[49,:HAMMERARM],
			[55,:LOCKON],
			[55,:ZAPCANNON],
			[61,:SUPERPOWER],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AURORAVEIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:EXPLOSION,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FROSTBREATH,:GIGAIMPACT,:GRAVITY,:HAIL,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONHEAD,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SELFDESTRUCT,:SHOCKWAVE,:SIGNALBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:Habitat => "Cave",
		:EggGroups => [:Undiscovered],
		:Height => 18,
		:Weight => 1750,
		:kind => "Iceberg",
		:dexentry => "Regice's body was made during an ice age. The deep-frozen body can't be melted, even by fire. This Pokémon controls frigid air of -328 degrees Fahrenheit.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:REGISTEEL => {
	"Normal Form" => {
		:name => "Registeel",
		:dexnum => 379,
		:Type1 => :STEEL,
		:BaseStats => [80, 75, 150, 75, 150, 50],
		:EVs => [0, 0, 2, 0, 1, 0],
		:Abilities => [:CLEARBODY, :LIGHTMETAL],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 35,
		:EggSteps => 20655,
		:Moveset => [
			[1,:EXPLOSION],
			[1,:STOMP],
			[1,:METALCLAW],
			[1,:CHARGEBEAM],
			[1,:BULLDOZE],
			[7,:METALCLAW],
			[13,:CHARGEBEAM],
			[19,:BULLDOZE],
			[25,:CURSE],
			[31,:ANCIENTPOWER],
			[37,:IRONDEFENSE],
			[37,:AMNESIA],
			[43,:IRONHEAD],
			[43,:FLASHCANNON],
			[49,:HAMMERARM],
			[55,:LOCKON],
			[55,:ZAPCANNON],
			[61,:SUPERPOWER],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARGEBEAM,:COUNTER,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHQUAKE,:EXPLOSION,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:IRONDEFENSE,:IRONHEAD,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWCLAW,:SHOCKWAVE,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Gray",
		:Habitat => "Cave",
		:EggGroups => [:Undiscovered],
		:Height => 19,
		:Weight => 2050,
		:kind => "Iron",
		:dexentry => "Its body is harder than any other kind of metal. The body metal is composed of a mysterious substance. It can also shrink and stretch flexibly.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LATIAS => {
	"Normal Form" => {
		:name => "Latias",
		:dexnum => 380,
		:Type1 => :DRAGON,
		:Type2 => :PSYCHIC,
		:BaseStats => [80, 80, 90, 110, 130, 110],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 90,
		:EggSteps => 30855,
		:Moveset => [
			[1,:HEALINGWISH],
			[1,:HELPINGHAND],
			[1,:WISH],
			[1,:PSYWAVE],
			[1,:SAFEGUARD],
			[4,:WATERSPORT],
			[7,:CHARM],
			[10,:STOREDPOWER],
			[13,:REFRESH],
			[16,:HEALPULSE],
			[20,:DRAGONBREATH],
			[24,:MISTBALL],
			[28,:PSYCHOSHIFT],
			[32,:RECOVER],
			[36,:REFLECTTYPE],
			[41,:ZENHEADBUTT],
			[46,:GUARDSPLIT],
			[51,:PSYCHIC],
			[56,:DRAGONPULSE],
			[61,:HEALINGWISH]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:ALLYSWITCH,:AURASPHERE,:BATONPASS,:BODYSLAM,:BREAKINGSWIPE,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:CUT,:DEFOG,:DIVE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DREAMEATER,:DUALWINGBEAT,:EARTHQUAKE,:ENERGYBALL,:FLASH,:FLY,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OUTRAGE,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROLEPLAY,:ROOST,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:STEELWING,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:SURF,:SWIFT,:TAILWIND,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TWISTER,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:Habitat => "WatersEdge",
		:EggGroups => [:Undiscovered],
		:Height => 14,
		:Weight => 400,
		:kind => "Eon",
		:dexentry => "They make a small herd of only several members. They rarely make contact with people or other Pokémon. They disappear if they sense enemies.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 11,
	},

	"Mega Form" => {
		:BaseStats => [80, 100, 120, 140, 150, 110],
		:Height => 18,
		:Weight => 520,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:LATIASITE => 1,
	},
},

:LATIOS => {
	"Normal Form" => {
		:name => "Latios",
		:dexnum => 381,
		:Type1 => :DRAGON,
		:Type2 => :PSYCHIC,
		:BaseStats => [80, 90, 80, 130, 110, 110],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemZero,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 90,
		:EggSteps => 30855,
		:Moveset => [
			[1,:MEMENTO],
			[1,:HELPINGHAND],
			[1,:HEALBLOCK],
			[1,:PSYWAVE],
			[1,:SAFEGUARD],
			[4,:PROTECT],
			[7,:DRAGONDANCE],
			[10,:STOREDPOWER],
			[13,:REFRESH],
			[16,:HEALPULSE],
			[20,:DRAGONBREATH],
			[24,:LUSTERPURGE],
			[28,:PSYCHOSHIFT],
			[32,:RECOVER],
			[36,:TELEKINESIS],
			[41,:ZENHEADBUTT],
			[46,:POWERSPLIT],
			[51,:PSYCHIC],
			[56,:DRAGONPULSE],
			[61,:MEMENTO]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:ALLYSWITCH,:AURASPHERE,:BATONPASS,:BODYSLAM,:BREAKINGSWIPE,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CUT,:DEFOG,:DIVE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DREAMEATER,:DUALWINGBEAT,:EARTHQUAKE,:ENERGYBALL,:FLASH,:FLY,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OUTRAGE,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROOST,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SOLARBEAM,:STEELWING,:STOREDPOWER,:SUNNYDAY,:SURF,:SWIFT,:TAILWIND,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TWISTER,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:Habitat => "WatersEdge",
		:EggGroups => [:Undiscovered],
		:Height => 20,
		:Weight => 600,
		:kind => "Eon",
		:dexentry => "Even in hiding, it can detect the locations of others and sense their emotions telepathically. Its intelligence allows it to understand human languages.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 10,
	},

	"Mega Form" => {
		:BaseStats => [80, 130, 100, 160, 120, 110],
		:Height => 23,
		:Weight => 700,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:LATIOSITE => 1,
	},
},

:KYOGRE => {
	"Normal Form" => {
		:name => "Kyogre",
		:dexnum => 382,
		:Type1 => :WATER,
		:BaseStats => [100, 100, 90, 150, 140, 90],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:DRIZZLE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 302,
		:CatchRate => 5,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:ANCIENTPOWER],
			[1,:WATERPULSE],
			[5,:SCARYFACE],
			[15,:AQUATAIL],
			[20,:BODYSLAM],
			[30,:AQUARING],
			[35,:ICEBEAM],
			[45,:ORIGINPULSE],
			[50,:CALMMIND],
			[60,:MUDDYWATER],
			[65,:SHEERCOLD],
			[75,:HYDROPUMP],
			[80,:DOUBLEEDGE],
			[90,:WATERSPOUT]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRINE,:BULLDOZE,:CALMMIND,:DEFENSECURL,:DIVE,:DOUBLEEDGE,:EARTHQUAKE,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEAVYSLAM,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONHEAD,:LIQUIDATION,:MIMIC,:MUDDYWATER,:MUDSLAP,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SCALD,:SCARYFACE,:SHOCKWAVE,:SIGNALBEAM,:STRENGTH,:SURF,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:Habitat => "Sea",
		:EggGroups => [:Undiscovered],
		:Height => 45,
		:Weight => 3520,
		:kind => "Sea Basin",
		:dexentry => "Kyogre has appeared in mythology as the creator of the sea. After long years of feuding with Groudon, it took to sleep at the bottom of the sea.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 3,
	},

	"Primal Form" => {
		:BaseStats => [100, 150, 90, 180, 160, 90],
		:Abilities => [:PRIMORDIALSEA],
		:Height => 98,
		:Weight => 4300,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:PrimalForm => 1,
},

:GROUDON => {
	"Normal Form" => {
		:name => "Groudon",
		:dexnum => 383,
		:Type1 => :GROUND,
		:BaseStats => [100, 150, 140, 100, 90, 90],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:DROUGHT],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 302,
		:CatchRate => 5,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:ANCIENTPOWER],
			[1,:MUDSHOT],
			[5,:SCARYFACE],
			[15,:EARTHPOWER],
			[20,:LAVAPLUME],
			[30,:REST],
			[35,:EARTHQUAKE],
			[45,:PRECIPICEBLADES],
			[50,:BULKUP],
			[60,:SOLARBEAM],
			[65,:FISSURE],
			[75,:FIREBLAST],
			[80,:HAMMERARM],
			[90,:ERUPTION]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BULKUP,:BULLDOZE,:COUNTER,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEAVYSLAM,:HIGHHORSEPOWER,:HONECLAWS,:HYPERBEAM,:INCINERATE,:IRONHEAD,:IRONTAIL,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSHOT,:MUDSLAP,:OVERHEAT,:POWERUPPUNCH,:PSYCHUP,:ROAR,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SCARYFACE,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SHOCKWAVE,:SMACKDOWN,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:Habitat => "RoughTerrain",
		:EggGroups => [:Undiscovered],
		:Height => 35,
		:Weight => 9500,
		:kind => "Continent",
		:dexentry => "Groudon has appeared in mythology as the creator of the land. It sleeps in magma underground and is said to make volcanoes erupt on awakening.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	"Primal Form" => {
		:Type2 => :FIRE,
		:BaseStats => [100, 180, 160, 150, 90, 90],
		:Abilities => [:DESOLATELAND],
		:Height => 50,
		:Weight => 9997,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:PrimalForm => 1,
},

:RAYQUAZA => {
	"Normal Form" => {
		:name => "Rayquaza",
		:dexnum => 384,
		:Type1 => :DRAGON,
		:Type2 => :FLYING,
		:BaseStats => [105, 150, 90, 150, 90, 95],
		:EVs => [0, 2, 0, 1, 0, 0],
		:Abilities => [:AIRLOCK],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:DRAGONASCENT],
			[1,:VCREATE],
			[1,:TWISTER],
			[5,:SCARYFACE],
			[15,:ANCIENTPOWER],
			[20,:CRUNCH],
			[30,:AIRSLASH],
			[35,:REST],
			[45,:EXTREMESPEED],
			[50,:DRAGONPULSE],
			[60,:DRAGONDANCE],
			[65,:FLY],
			[75,:HYPERVOICE],
			[80,:OUTRAGE],
			[90,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BIND,:BLIZZARD,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULKUP,:BULLDOZE,:COSMICPOWER,:CRUNCH,:DEFOG,:DIVE,:DOUBLEEDGE,:DRACOMETEOR,:DRAGONASCENT,:DRAGONCLAW,:DRAGONDANCE,:DRAGONPULSE,:DRAGONTAIL,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENERGYBALL,:FIREBLAST,:FLAMETHROWER,:FLING,:FLY,:FOCUSBLAST,:FURYCUTTER,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HONECLAWS,:HURRICANE,:HYDROPUMP,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICYWIND,:INCINERATE,:IRONHEAD,:IRONTAIL,:METEORBEAM,:MIMIC,:MUDSLAP,:OUTRAGE,:OVERHEAT,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCALESHOT,:SCARYFACE,:SHADOWCLAW,:SHOCKWAVE,:SKYDROP,:SOLARBEAM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:SWORDSDANCE,:TAILWIND,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:UPROAR,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Green",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 70,
		:Weight => 2065,
		:kind => "Sky High",
		:dexentry => "A Pokémon that flies endlessly in the ozone layer. It is said it would descend to the ground if Kyogre and Groudon were to fight.",
		:BattlerPlayerY => 2,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 5,
	},

	"Mega Form" => {
		:BaseStats => [105, 180, 100, 180, 100, 115],
		:Abilities => [:DELTASTREAM],
		:Height => 108,
		:Weight => 3920,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => 1,
},

:JIRACHI => {
	"Normal Form" => {
		:name => "Jirachi",
		:dexnum => 385,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:SERENEGRACE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 100,
		:EggSteps => 30855,
		:Moveset => [
			[1,:DRACOMETEOR],
			[1,:MOONBLAST],
			[1,:HEARTSTAMP],
			[1,:METEORMASH],
			[1,:PLAYROUGH],
			[1,:WISH],
			[1,:CONFUSION],
			[5,:REST],
			[10,:SWIFT],
			[15,:HELPINGHAND],
			[20,:PSYCHIC],
			[25,:REFRESH],
			[30,:LUCKYCHANT],
			[35,:ZENHEADBUTT],
			[40,:DOUBLEEDGE],
			[45,:GRAVITY],
			[50,:HEALINGWISH],
			[55,:FUTURESIGHT],
			[60,:COSMICPOWER],
			[65,:LASTRESORT],
			[70,:DOOMDESIRE]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:AURASPHERE,:BATONPASS,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:CHARM,:COSMICPOWER,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLASHCANNON,:FLING,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:IMPRISON,:IRONDEFENSE,:IRONHEAD,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:METRONOME,:MIMIC,:MUDSLAP,:NIGHTMARE,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SANDSTORM,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STEALTHROCK,:STEELBEAM,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRICK,:TRICKROOM,:UPROAR,:UTURN,:WATERPULSE,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Yellow",
		:Habitat => "Mountain",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 11,
		:WildItemCommon => :STARPIECE,
		:WildItemUncommon => :STARPIECE,
		:WildItemRare => :STARPIECE,
		:kind => "Wish",
		:dexentry => "Jirachi is said to make wishes come true. While it sleeps, a tough crystalline shell envelops the body to protect it from enemies.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:DEOXYS => {
	"Normal Forme" => {
		:name => "Deoxys",
		:dexnum => 386,
		:Type1 => :PSYCHIC,
		:BaseStats => [50, 150, 50, 150, 50, 150],
		:EVs => [0, 1, 0, 1, 0, 1],
		:Abilities => [:PRESSURE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:METEORMASH],
			[1,:NASTYPLOT],
			[1,:DETECT],
			[1,:ZAPCANNON],
			[1,:LEER],
			[1,:WRAP],
			[7,:NIGHTSHADE],
			[13,:TELEPORT],
			[19,:KNOCKOFF],
			[25,:PURSUIT],
			[31,:PSYCHIC],
			[37,:SNATCH],
			[43,:PSYCHOSHIFT],
			[49,:ZENHEADBUTT],
			[55,:COSMICPOWER],
			[61,:RECOVER],
			[67,:PSYCHOBOOST],
			[73,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:AMNESIA,:AURASPHERE,:AVALANCHE,:BEATUP,:BIND,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:CALMMIND,:CHARGEBEAM,:COSMICPOWER,:COUNTER,:CUT,:DARKESTLARIAT,:DARKPULSE,:DOUBLEEDGE,:DRAINPUNCH,:DREAMEATER,:DYNAMICPUNCH,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:POISONJAB,:POWERUPPUNCH,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SAFEGUARD,:SEISMICTOSS,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAUNT,:TELEKINESIS,:TERRAINPULSE,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WATERPULSE,:WONDERROOM,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:Habitat => "Rare",
		:EggGroups => [:Undiscovered],
		:Height => 17,
		:Weight => 608,
		:kind => "DNA",
		:dexentry => "A Pokémon that mutated from an extraterrestrial virus exposed to a laser beam. Its body is configured for superior agility and speed.",
		:BattlerPlayerY => 10,
		:BattlerEnemyY => 5,
		:BattlerAltitude => 0,
	},

	"Attack Forme" => {
		:BaseStats => [50, 180, 20, 180, 20, 150],
		:EVs => [0, 2, 0, 0, 1, 0],
		:Moveset => [
			[1,:LEER],
			[1,:WRAP],
			[7,:NIGHTSHADE],
			[13,:TELEPORT],
			[19,:TAUNT],
			[25,:PURSUIT],
			[31,:PSYCHIC],
			[37,:SUPERPOWER],
			[43,:PSYCHOSHIFT],
			[49,:ZENHEADBUTT],
			[55,:COSMICPOWER],
			[61,:ZAPCANNON],
			[67,:PSYCHOBOOST],
			[73,:HYPERBEAM],
		],
	},

	"Defense Forme" => {
		:BaseStats => [50, 70, 160, 70, 160, 90],
		:EVs => [0, 0, 2, 0, 0, 1],
		:Moveset => [
			[1,:LEER],
			[1,:WRAP],
			[7,:NIGHTSHADE],
			[13,:TELEPORT],
			[19,:KNOCKOFF],
			[25,:SPIKES],
			[31,:PSYCHIC],
			[37,:SNATCH],
			[43,:PSYCHOSHIFT],
			[49,:ZENHEADBUTT],
			[55,:IRONDEFENSE],
			[55,:AMNESIA],
			[61,:RECOVER],
			[67,:PSYCHOBOOST],
			[73,:COUNTER],
			[73,:MIRRORCOAT],
		],
	},

	"Speed Forme" => {
		:BaseStats => [50, 95, 90, 95, 90, 180],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Moveset => [
			[1,:LEER],
			[1,:WRAP],
			[7,:NIGHTSHADE],
			[13,:DOUBLETEAM],
			[19,:KNOCKOFF],
			[25,:PURSUIT],
			[31,:PSYCHIC],
			[37,:SWIFT],
			[43,:PSYCHOSHIFT],
			[49,:ZENHEADBUTT],
			[55,:AGILITY],
			[61,:RECOVER],
			[67,:PSYCHOBOOST],
			[73,:EXTREMESPEED],
		],
	},

	:OnCreation => {},
},

:TURTWIG => {
	"Normal Form" => {
		:name => "Turtwig",
		:dexnum => 387,
		:Type1 => :GRASS,
		:BaseStats => [55, 68, 64, 45, 55, 31],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:OVERGROW, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 64,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AMNESIA,:BODYSLAM,:DOUBLEEDGE,:EARTHPOWER,:GRASSYTERRAIN,:GROWTH,:HEAVYSLAM,:SANDTOMB,:SEEDBOMB,:SPITUP,:STOCKPILE,:SUPERPOWER,:SWALLOW,:THRASH,:TICKLE,:WIDEGUARD,:WORRYSEED,],
		:Moveset => [
			[1,:TACKLE],
			[5,:WITHDRAW],
			[9,:ABSORB],
			[13,:RAZORLEAF],
			[17,:CURSE],
			[21,:BITE],
			[25,:MEGADRAIN],
			[29,:LEECHSEED],
			[33,:SYNTHESIS],
			[37,:CRUNCH],
			[41,:GIGADRAIN],
			[45,:LEAFSTORM]],
		:compatiblemoves => [:BULLETSEED,:CUT,:EARTHPOWER,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYTERRAIN,:HEADBUTT,:IRONTAIL,:LIGHTSCREEN,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:REFLECT,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SANDTOMB,:SEEDBOMB,:SOLARBEAM,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Monster, :Grass],
		:Height => 4,
		:Weight => 102,
		:kind => "Tiny Leaf",
		:dexentry => "Made from soil, the shell on its back hardens when it drinks water. It lives along lakes.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GROTLE,:Level,18]
		]
	},

	:OnCreation => {},
},

:GROTLE => {
	"Normal Form" => {
		:name => "Grotle",
		:dexnum => 388,
		:Type1 => :GRASS,
		:BaseStats => [75, 89, 85, 55, 65, 36],
		:EVs => [0, 1, 1, 0, 0, 0],
		:Abilities => [:OVERGROW, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TURTWIG,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:WITHDRAW],
			[1,:ABSORB],
			[5,:WITHDRAW],
			[9,:ABSORB],
			[13,:RAZORLEAF],
			[17,:CURSE],
			[22,:BITE],
			[27,:MEGADRAIN],
			[32,:LEECHSEED],
			[37,:SYNTHESIS],
			[42,:CRUNCH],
			[47,:GIGADRAIN],
			[52,:LEAFSTORM]],
		:compatiblemoves => [:BULLETSEED,:CUT,:EARTHPOWER,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GRASSYTERRAIN,:HEADBUTT,:IRONTAIL,:LIGHTSCREEN,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:REFLECT,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SANDTOMB,:SEEDBOMB,:SOLARBEAM,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Monster, :Grass],
		:Height => 11,
		:Weight => 970,
		:kind => "Grove",
		:dexentry => "It lives along water in forests. In the daytime, it leaves the forest to sunbathe its treed shell.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TORTERRA,:Level,32]
		]
	},

	:OnCreation => {},
},

:TORTERRA => {
	"Normal Form" => {
		:name => "Torterra",
		:dexnum => 389,
		:Type1 => :GRASS,
		:Type2 => :GROUND,
		:BaseStats => [95, 109, 105, 75, 85, 56],
		:EVs => [0, 2, 1, 0, 0, 0],
		:Abilities => [:OVERGROW, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 236,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GROTLE,
			:form => 0
		},
		:Moveset => [
			[0,:EARTHQUAKE],
			[1,:WOODHAMMER],
			[1,:TACKLE],
			[1,:WITHDRAW],
			[1,:ABSORB],
			[1,:RAZORLEAF],
			[5,:WITHDRAW],
			[9,:ABSORB],
			[13,:RAZORLEAF],
			[17,:CURSE],
			[22,:BITE],
			[27,:MEGADRAIN],
			[33,:LEECHSEED],
			[39,:SYNTHESIS],
			[45,:CRUNCH],
			[51,:GIGADRAIN],
			[57,:LEAFSTORM]],
		:compatiblemoves => [:BLOCK,:BODYPRESS,:BULLDOZE,:BULLETSEED,:CUT,:DIG,:EARTHPOWER,:EARTHQUAKE,:ENERGYBALL,:FLASH,:FRENZYPLANT,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:IRONHEAD,:IRONTAIL,:LIGHTSCREEN,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:OUTRAGE,:REFLECT,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SCREECH,:SEEDBOMB,:SOLARBEAM,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:SYNTHESIS,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Monster, :Grass],
		:Height => 22,
		:Weight => 3100,
		:kind => "Continent",
		:dexentry => "Small Pokémon occasionally gather on its unmoving back to begin building their nests.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CHIMCHAR => {
	"Normal Form" => {
		:name => "Chimchar",
		:dexnum => 390,
		:Type1 => :FIRE,
		:BaseStats => [44, 58, 44, 58, 44, 61],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:BLAZE, :IRONFIST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASSIST,:BLAZEKICK,:COUNTER,:DOUBLEKICK,:ENCORE,:FAKEOUT,:FIREPUNCH,:FOCUSENERGY,:FOCUSPUNCH,:HEATWAVE,:HELPINGHAND,:POWERUPPUNCH,:QUICKGUARD,:SUBMISSION,:THUNDERPUNCH,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:LEER],
			[7,:EMBER],
			[9,:TAUNT],
			[15,:FURYSWIPES],
			[17,:FLAMEWHEEL],
			[23,:NASTYPLOT],
			[25,:TORMENT],
			[31,:FACADE],
			[33,:FIRESPIN],
			[39,:ACROBATICS],
			[41,:SLACKOFF],
			[47,:FLAMETHROWER]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:BEATUP,:BRICKBREAK,:BULKUP,:BURNINGJEALOUSY,:COVET,:CUT,:DIG,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GRASSKNOT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:IRONTAIL,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:OVERHEAT,:POWERUPPUNCH,:REVENGE,:ROCKCLIMB,:ROCKSMASH,:ROLEPLAY,:ROLLOUT,:SHADOWCLAW,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THUNDERPUNCH,:TORMENT,:UPROAR,:UTURN,:VACUUMWAVE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field, :HumanLike],
		:Height => 5,
		:Weight => 62,
		:kind => "Chimp",
		:dexentry => "It agilely scales sheer cliffs to live atop craggy mountains. Its fire is put out when it sleeps.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MONFERNO,:Level,14]
		]
	},

	:OnCreation => {},
},

:MONFERNO => {
	"Normal Form" => {
		:name => "Monferno",
		:dexnum => 391,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [64, 78, 52, 78, 52, 81],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:BLAZE, :IRONFIST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHIMCHAR,
			:form => 0
		},
		:Moveset => [
			[0,:MACHPUNCH],
			[1,:SCRATCH],
			[1,:LEER],
			[1,:EMBER],
			[7,:EMBER],
			[9,:TAUNT],
			[16,:FURYSWIPES],
			[19,:FLAMEWHEEL],
			[26,:FEINT],
			[29,:TORMENT],
			[36,:CLOSECOMBAT],
			[39,:FIRESPIN],
			[46,:ACROBATICS],
			[49,:SLACKOFF],
			[56,:FLAREBLITZ]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:BEATUP,:BRICKBREAK,:BULKUP,:BURNINGJEALOUSY,:COVET,:CUT,:DIG,:DUALCHOP,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:INCINERATE,:IRONTAIL,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:OVERHEAT,:POISONJAB,:POWERUPPUNCH,:RETALIATE,:REVENGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SHADOWCLAW,:STEALTHROCK,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THUNDERPUNCH,:TORMENT,:UTURN,:VACUUMWAVE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field, :HumanLike],
		:Height => 9,
		:Weight => 220,
		:kind => "Playful",
		:dexentry => "To intimidate attackers, it stretches the fire on its tail to make itself appear bigger.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:INFERNAPE,:Level,36]
		]
	},

	:OnCreation => {},
},

:INFERNAPE => {
	"Normal Form" => {
		:name => "Infernape",
		:dexnum => 392,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [76, 104, 71, 104, 71, 108],
		:EVs => [0, 1, 0, 1, 0, 1],
		:Abilities => [:BLAZE, :IRONFIST],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 240,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MONFERNO,
			:form => 0
		},
		:Moveset => [
			[0,:CLOSECOMBAT],
			[1,:MACHPUNCH],
			[1,:FLAREBLITZ],
			[1,:SCRATCH],
			[1,:LEER],
			[1,:EMBER],
			[1,:TAUNT],
			[7,:EMBER],
			[9,:TAUNT],
			[16,:FURYSWIPES],
			[19,:FLAMEWHEEL],
			[26,:FEINT],
			[29,:PUNISHMENT],
			[42,:FIRESPIN],
			[52,:ACROBATICS],
			[58,:CALMMIND],
			[68,:FLAREBLITZ]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:BEATUP,:BLASTBURN,:BRICKBREAK,:BULKUP,:BULLDOZE,:BURNINGJEALOUSY,:CALMMIND,:COVET,:CUT,:DIG,:DUALCHOP,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:INCINERATE,:IRONTAIL,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:OVERHEAT,:POISONJAB,:POWERUPPUNCH,:RETALIATE,:REVENGE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SCORCHINGSANDS,:SHADOWCLAW,:SOLARBEAM,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THUNDERPUNCH,:TORMENT,:UTURN,:VACUUMWAVE,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field, :HumanLike],
		:Height => 12,
		:Weight => 550,
		:kind => "Flame",
		:dexentry => "It uses a special kind of martial arts involving all its limbs. Its fire never goes out.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PIPLUP => {
	"Normal Form" => {
		:name => "Piplup",
		:dexnum => 393,
		:Type1 => :WATER,
		:BaseStats => [53, 51, 53, 61, 56, 40],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:TORRENT, :DEFIANT],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:AQUARING,:BIDE,:DOUBLEHIT,:FEATHERDANCE,:FLAIL,:HYDROPUMP,:ICYWIND,:MUDSPORT,:MUDSLAP,:POWERTRIP,:SNORE,:SUPERSONIC,:YAWN,],
		:Moveset => [
			[1,:POUND],
			[4,:GROWL],
			[8,:BUBBLE],
			[11,:WATERSPORT],
			[15,:PECK],
			[18,:BUBBLEBEAM],
			[22,:BIDE],
			[25,:FURYATTACK],
			[29,:BRINE],
			[32,:WHIRLPOOL],
			[36,:MIST],
			[39,:DRILLPECK],
			[43,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:BLIZZARD,:BRICKBREAK,:BRINE,:COVET,:CUT,:DEFOG,:DIVE,:ECHOEDVOICE,:FLING,:FLIPTURN,:GRASSKNOT,:HAIL,:HEADBUTT,:ICEBEAM,:ICYWIND,:MUDSLAP,:QUASH,:RAINDANCE,:ROCKTOMB,:SCALD,:SIGNALBEAM,:STEALTHROCK,:SURF,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Water1, :Field],
		:Height => 4,
		:Weight => 52,
		:kind => "Penguin",
		:dexentry => "Because it is very proud, it hates accepting food from people. Its thick down guards it from cold.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PRINPLUP,:Level,16]
		]
	},

	:OnCreation => {},
},

:PRINPLUP => {
	"Normal Form" => {
		:name => "Prinplup",
		:dexnum => 394,
		:Type1 => :WATER,
		:BaseStats => [64, 66, 68, 81, 76, 50],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:TORRENT, :DEFIANT],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 142,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PIPLUP,
			:form => 0
		},
		:Moveset => [
			[0,:METALCLAW],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:BUBBLE],
			[4,:GROWL],
			[8,:BUBBLE],
			[11,:WATERSPORT],
			[15,:PECK],
			[19,:BUBBLEBEAM],
			[24,:BIDE],
			[28,:FURYATTACK],
			[33,:BRINE],
			[37,:WHIRLPOOL],
			[42,:MIST],
			[46,:DRILLPECK],
			[51,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:BLIZZARD,:BRICKBREAK,:BRINE,:COVET,:CUT,:DEFOG,:DIG,:DIVE,:ECHOEDVOICE,:FLING,:FLIPTURN,:GRASSKNOT,:HAIL,:HEADBUTT,:HONECLAWS,:ICEBEAM,:ICYWIND,:MUDSLAP,:QUASH,:RAINDANCE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SHADOWCLAW,:SIGNALBEAM,:STEALTHROCK,:STRENGTH,:SURF,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Water1, :Field],
		:Height => 8,
		:Weight => 230,
		:kind => "Penguin",
		:dexentry => "It lives alone, away from others. Apparently, every one of them believes it is the most important.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
		:evolutions => [
			[:EMPOLEON,:Level,36]
		]
	},

	:OnCreation => {},
},

:EMPOLEON => {
	"Normal Form" => {
		:name => "Empoleon",
		:dexnum => 395,
		:Type1 => :WATER,
		:Type2 => :STEEL,
		:BaseStats => [84, 86, 88, 111, 101, 60],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:TORRENT, :DEFIANT],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 239,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PRINPLUP,
			:form => 0
		},
		:Moveset => [
			[0,:AQUAJET],
			[1,:METALCLAW],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:BUBBLE],
			[4,:GROWL],
			[8,:BUBBLE],
			[11,:SWORDSDANCE],
			[15,:PECK],
			[19,:BUBBLEBEAM],
			[24,:SWAGGER],
			[28,:FURYATTACK],
			[33,:BRINE],
			[39,:WHIRLPOOL],
			[46,:MIST],
			[52,:DRILLPECK],
			[59,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:AVALANCHE,:BLIZZARD,:BRICKBREAK,:BRINE,:BULLDOZE,:COVET,:CUT,:DEFOG,:DIG,:DIVE,:EARTHQUAKE,:ECHOEDVOICE,:FLASHCANNON,:FLING,:FLIPTURN,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEADBUTT,:HONECLAWS,:HYDROCANNON,:HYPERBEAM,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IRONDEFENSE,:KNOCKOFF,:LASERFOCUS,:LIQUIDATION,:MUDSLAP,:QUASH,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SHADOWCLAW,:SIGNALBEAM,:STEALTHROCK,:STEELWING,:STRENGTH,:SURF,:SWORDSDANCE,:THROATCHOP,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Water1, :Field],
		:Height => 17,
		:Weight => 845,
		:kind => "Emperor",
		:dexentry => "The three horns that extend from its beak attest to its power. The leader has the biggest horns.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:STARLY => {
	"Normal Form" => {
		:name => "Starly",
		:dexnum => 396,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [40, 55, 30, 30, 30, 60],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:KEENEYE, :RECKLESS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 49,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:ASTONISH,:DETECT,:DOUBLEEDGE,:FEATHERDANCE,:FORESIGHT,:FURYATTACK,:MIRRORMOVE,:PURSUIT,:REVENGE,:ROOST,:SANDATTACK,:STEELWING,:UPROAR,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[5,:QUICKATTACK],
			[9,:WINGATTACK],
			[13,:DOUBLETEAM],
			[17,:ENDEAVOR],
			[21,:WHIRLWIND],
			[25,:AERIALACE],
			[29,:TAKEDOWN],
			[33,:AGILITY],
			[37,:BRAVEBIRD],
			[41,:FINALGAMBIT]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:DEFOG,:DUALWINGBEAT,:ECHOEDVOICE,:ENDEAVOR,:FLY,:HEATWAVE,:MUDSLAP,:OMINOUSWIND,:RAINDANCE,:ROOST,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Flying],
		:Height => 3,
		:Weight => 20,
		:kind => "Starling",
		:dexentry => "They flock in great numbers. Though small, they flap their wings with great power.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:STARAVIA,:Level,14]
		]
	},

	:OnCreation => {},
},

:STARAVIA => {
	"Normal Form" => {
		:name => "Staravia",
		:dexnum => 397,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [55, 75, 50, 40, 40, 80],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:INTIMIDATE, :RECKLESS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 119,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :STARLY,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[1,:QUICKATTACK],
			[5,:QUICKATTACK],
			[9,:WINGATTACK],
			[13,:DOUBLETEAM],
			[18,:ENDEAVOR],
			[23,:WHIRLWIND],
			[28,:AERIALACE],
			[33,:TAKEDOWN],
			[38,:AGILITY],
			[43,:BRAVEBIRD],
			[48,:FINALGAMBIT]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:DEFOG,:DUALWINGBEAT,:ECHOEDVOICE,:ENDEAVOR,:FLY,:HEATWAVE,:MUDSLAP,:OMINOUSWIND,:RAINDANCE,:RETALIATE,:ROOST,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Flying],
		:Height => 6,
		:Weight => 155,
		:kind => "Starling",
		:dexentry => "It flies around forests and fields in search of Bug Pokémon. It stays within a huge flock.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:STARAPTOR,:Level,34]
		]
	},

	:OnCreation => {},
},

:STARAPTOR => {
	"Normal Form" => {
		:name => "Staraptor",
		:dexnum => 398,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [85, 120, 70, 50, 60, 100],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :RECKLESS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 214,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :STARAVIA,
			:form => 0
		},
		:Moveset => [
			[0,:CLOSECOMBAT],
			[1,:TACKLE],
			[1,:GROWL],
			[1,:QUICKATTACK],
			[1,:WINGATTACK],
			[5,:QUICKATTACK],
			[9,:WINGATTACK],
			[13,:DOUBLETEAM],
			[18,:ENDEAVOR],
			[23,:WHIRLWIND],
			[28,:AERIALACE],
			[33,:TAKEDOWN],
			[41,:AGILITY],
			[49,:BRAVEBIRD],
			[57,:FINALGAMBIT]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:DEFOG,:DUALWINGBEAT,:ECHOEDVOICE,:ENDEAVOR,:FLY,:GIGAIMPACT,:HEATWAVE,:HYPERBEAM,:LASERFOCUS,:MUDSLAP,:OMINOUSWIND,:RAINDANCE,:RETALIATE,:ROOST,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Flying],
		:Height => 12,
		:Weight => 249,
		:kind => "Predator",
		:dexentry => "It has a savage nature. It will courageously challenge foes that are much larger.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BIDOOF => {
	"Normal Form" => {
		:name => "Bidoof",
		:dexnum => 399,
		:Type1 => :NORMAL,
		:BaseStats => [59, 45, 40, 35, 40, 31],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:SIMPLE, :UNAWARE],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 50,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:EggMoves => [:AQUATAIL,:DEFENSECURL,:DOUBLEEDGE,:ENDURE,:FURYSWIPES,:MUDSPORT,:ODORSLEUTH,:QUICKATTACK,:ROCKCLIMB,:ROLLOUT,:SKULLBASH,:SLEEPTALK,:WATERSPORT,],
		:Moveset => [
			[1,:TACKLE],
			[1,:GROWL],
			[5,:DEFENSECURL],
			[9,:ROLLOUT],
			[13,:HEADBUTT],
			[17,:HYPERFANG],
			[21,:YAWN],
			[25,:CRUNCH],
			[29,:TAKEDOWN],
			[33,:SUPERFANG],
			[37,:SWORDSDANCE],
			[41,:AMNESIA],
			[45,:SUPERPOWER],
			[49,:CURSE]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BODYSLAM,:CHARGEBEAM,:COVET,:CRUNCH,:CUT,:DIG,:ECHOEDVOICE,:FURYCUTTER,:GRASSKNOT,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:LASTRESORT,:MUDSLAP,:PSYCHICFANGS,:RAINDANCE,:RAZORSHELL,:RETALIATE,:ROCKCLIMB,:ROCKSMASH,:ROLLOUT,:SHADOWBALL,:SHOCKWAVE,:STEALTHROCK,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Water1, :Field],
		:Height => 5,
		:Weight => 200,
		:kind => "Plump Mouse",
		:dexentry => "With nerves of steel, nothing can perturb it. It is more agile and active than it appears.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BIBAREL,:Level,15]
		]
	},

	:OnCreation => {},
},

:BIBAREL => {
	"Normal Form" => {
		:name => "Bibarel",
		:dexnum => 400,
		:Type1 => :NORMAL,
		:Type2 => :WATER,
		:BaseStats => [79, 85, 60, 55, 60, 71],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SIMPLE, :UNAWARE],
		:HiddenAbilities => :MOODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 127,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :BIDOOF,
			:form => 0
		},
		:Moveset => [
			[0,:WATERGUN],
			[1,:AQUAJET],
			[1,:ROTOTILLER],
			[1,:TACKLE],
			[1,:GROWL],
			[5,:DEFENSECURL],
			[9,:ROLLOUT],
			[13,:HEADBUTT],
			[18,:HYPERFANG],
			[23,:YAWN],
			[28,:CRUNCH],
			[33,:TAKEDOWN],
			[38,:SUPERFANG],
			[43,:SWORDSDANCE],
			[48,:AMNESIA],
			[53,:SUPERPOWER],
			[58,:CURSE]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BLIZZARD,:BODYSLAM,:BULLDOZE,:CHARGEBEAM,:COVET,:CRUNCH,:CUT,:DIG,:DIVE,:ECHOEDVOICE,:FLING,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:LASTRESORT,:LIQUIDATION,:MUDSLAP,:PSYCHICFANGS,:RAINDANCE,:RAZORSHELL,:RETALIATE,:ROCKCLIMB,:ROCKSMASH,:ROLLOUT,:SCALD,:SHADOWBALL,:SHOCKWAVE,:STEALTHROCK,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERFANG,:SUPERPOWER,:SURF,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:WATERFALL,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Water1, :Field],
		:Height => 10,
		:Weight => 315,
		:kind => "Beaver",
		:dexentry => "It makes its nest by damming streams with bark and mud. It is known as an industrious worker.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:KRICKETOT => {
	"Normal Form" => {
		:name => "Kricketot",
		:dexnum => 401,
		:Type1 => :BUG,
		:BaseStats => [37, 25, 41, 25, 41, 25],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SHEDSKIN, :RUNAWAY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 39,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:GROWL],
			[1,:BIDE],
			[6,:STRUGGLEBUG],
			[16,:BUGBITE]],
		:compatiblemoves => [:BUGBITE,:ENDEAVOR,:MUDSLAP,:SKITTERSMACK,:STRINGSHOT,:STRUGGLEBUG,:UPROAR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Red",
		:EggGroups => [:Bug],
		:Height => 3,
		:Weight => 22,
		:WildItemUncommon => :METRONOME,
		:kind => "Cricket",
		:dexentry => "It shakes its head back to front, causing its antennae to hit each other and sound like a xylophone.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:KRICKETUNE,:Level,10]
		]
	},

	:OnCreation => {},
},

:KRICKETUNE => {
	"Normal Form" => {
		:name => "Kricketune",
		:dexnum => 402,
		:Type1 => :BUG,
		:BaseStats => [77, 85, 51, 55, 51, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SWARM, :TECHNICIAN],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 134,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :KRICKETOT,
			:form => 0
		},
		:Moveset => [
			[0,:FURYCUTTER],
			[1,:GROWL],
			[1,:BIDE],
			[14,:ABSORB],
			[18,:SING],
			[22,:FOCUSENERGY],
			[26,:SLASH],
			[30,:XSCISSOR],
			[34,:SCREECH],
			[36,:FELLSTINGER],
			[38,:TAUNT],
			[42,:NIGHTSLASH],
			[44,:STICKYWEB],
			[46,:BUGBUZZ],
			[50,:PERISHSONG]],
		:compatiblemoves => [:AERIALACE,:BREAKINGSWIPE,:BRICKBREAK,:BUGBITE,:BUGBUZZ,:CUT,:DARKESTLARIAT,:ECHOEDVOICE,:ENDEAVOR,:FALSESWIPE,:FLASH,:FURYCUTTER,:GIGAIMPACT,:HEALBELL,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:KNOCKOFF,:LASERFOCUS,:LEECHLIFE,:MUDSLAP,:POWERUPPUNCH,:RAINDANCE,:ROCKSMASH,:SCREECH,:SKITTERSMACK,:STRENGTH,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWORDSDANCE,:TAUNT,:THROATCHOP,:UPROAR,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Bug],
		:Height => 10,
		:Weight => 255,
		:WildItemUncommon => :METRONOME,
		:kind => "Cricket",
		:dexentry => "It crosses its knifelike arms in front of its chest when it cries. It can compose melodies ad lib.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SHINX => {
	"Normal Form" => {
		:name => "Shinx",
		:dexnum => 403,
		:Type1 => :ELECTRIC,
		:BaseStats => [45, 65, 34, 40, 34, 45],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:RIVALRY, :INTIMIDATE],
		:HiddenAbilities => :GUTS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 53,
		:CatchRate => 235,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:DOUBLEKICK,:EERIEIMPULSE,:FAKETEARS,:FIREFANG,:HELPINGHAND,:HOWL,:ICEFANG,:NIGHTSLASH,:QUICKATTACK,:SHOCKWAVE,:SIGNALBEAM,:SWIFT,:TAKEDOWN,:THUNDERFANG,],
		:Moveset => [
			[1,:TACKLE],
			[5,:LEER],
			[9,:CHARGE],
			[11,:BABYDOLLEYES],
			[13,:SPARK],
			[17,:BITE],
			[21,:ROAR],
			[25,:SWAGGER],
			[29,:THUNDERFANG],
			[33,:CRUNCH],
			[37,:SCARYFACE],
			[41,:DISCHARGE],
			[45,:WILDCHARGE]],
		:compatiblemoves => [:CHARGEBEAM,:CRUNCH,:EERIEIMPULSE,:ELECTROBALL,:FAKETEARS,:FIREFANG,:FLASH,:FURYCUTTER,:HEADBUTT,:HELPINGHAND,:ICEFANG,:IRONTAIL,:LIGHTSCREEN,:MAGNETRISE,:MUDSLAP,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROAR,:SCARYFACE,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SWIFT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 95,
		:kind => "Flash",
		:dexentry => "All of its fur dazzles if danger is sensed. It flees while the foe is momentarily blinded.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LUXIO,:Level,15]
		]
	},

	:OnCreation => {},
},

:LUXIO => {
	"Normal Form" => {
		:name => "Luxio",
		:dexnum => 404,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 85, 49, 60, 49, 60],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:RIVALRY, :INTIMIDATE],
		:HiddenAbilities => :GUTS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 127,
		:CatchRate => 120,
		:Happiness => 100,
		:EggSteps => 5355,
		:preevo => {
			:species => :SHINX,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:LEER],
			[5,:LEER],
			[9,:CHARGE],
			[13,:SPARK],
			[18,:BITE],
			[23,:ROAR],
			[28,:SWAGGER],
			[33,:THUNDERFANG],
			[38,:CRUNCH],
			[43,:SCARYFACE],
			[48,:DISCHARGE],
			[53,:WILDCHARGE]],
		:compatiblemoves => [:CHARGEBEAM,:CRUNCH,:EERIEIMPULSE,:ELECTROBALL,:FAKETEARS,:FIREFANG,:FLASH,:FURYCUTTER,:HEADBUTT,:HELPINGHAND,:ICEFANG,:IRONTAIL,:LIGHTSCREEN,:MAGNETRISE,:MUDSLAP,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROAR,:SCARYFACE,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SWIFT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 305,
		:kind => "Spark",
		:dexentry => "Its claws loose electricity with enough amperage to cause fainting. They live in small groups.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LUXRAY,:Level,30]
		]
	},

	:OnCreation => {},
},

:LUXRAY => {
	"Normal Form" => {
		:name => "Luxray",
		:dexnum => 405,
		:Type1 => :ELECTRIC,
		:BaseStats => [80, 120, 79, 95, 79, 70],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:RIVALRY, :INTIMIDATE],
		:HiddenAbilities => :GUTS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 235,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :LUXIO,
			:form => 0
		},
		:Moveset => [
			[1,:ELECTRICTERRAIN],
			[1,:TACKLE],
			[1,:LEER],
			[1,:CHARGE],
			[5,:LEER],
			[9,:CHARGE],
			[13,:SPARK],
			[18,:BITE],
			[23,:ROAR],
			[28,:SWAGGER],
			[35,:THUNDERFANG],
			[42,:CRUNCH],
			[49,:SCARYFACE],
			[56,:DISCHARGE],
			[63,:WILDCHARGE],
			[67,:ELECTRICTERRAIN]],
		:compatiblemoves => [:CHARGEBEAM,:CRUNCH,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:FAKETEARS,:FIREFANG,:FLASH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEFANG,:IRONTAIL,:LASERFOCUS,:LIGHTSCREEN,:MAGNETRISE,:MUDSLAP,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROAR,:SCARYFACE,:SHOCKWAVE,:SIGNALBEAM,:SNARL,:STRENGTH,:SUPERPOWER,:SWIFT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:VOLTSWITCH,:WILDCHARGE,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 14,
		:Weight => 420,
		:kind => "Gleam Eyes",
		:dexentry => "It has eyes that can see through anything. It spots and captures prey hiding behind objects.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :DARK,
		:BaseStats => [80, 145, 99, 95, 79, 125],
		:Abilities => [:STRONGJAW],
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:LUXRITE => 1
	},
},

:BUDEW => {
	"Normal Form" => {
		:name => "Budew",
		:dexnum => 406,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [40, 30, 35, 50, 70, 55],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:NATURALCURE, :POISONPOINT],
		:HiddenAbilities => :LEAFGUARD,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:COTTONSPORE,:EXTRASENSORY,:GIGADRAIN,:GRASSWHISTLE,:LEAFSTORM,:MINDREADER,:NATURALGIFT,:PINMISSILE,:RAZORLEAF,:SEEDBOMB,:SLEEPPOWDER,:SPIKES,:SYNTHESIS,],
		:Moveset => [
			[1,:ABSORB],
			[4,:GROWTH],
			[7,:WATERSPORT],
			[10,:STUNSPORE],
			[13,:MEGADRAIN],
			[16,:WORRYSEED]],
		:compatiblemoves => [:BULLETSEED,:COVET,:CUT,:DAZZLINGGLEAM,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:LEAFSTORM,:MUDSLAP,:NATUREPOWER,:PINMISSILE,:PSYCHUP,:RAINDANCE,:SEEDBOMB,:SHADOWBALL,:SLUDGEBOMB,:SOLARBEAM,:SPIKES,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:UPROAR,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Undiscovered],
		:Height => 2,
		:Weight => 12,
		:WildItemUncommon => :POISONBARB,
		:kind => "Bud",
		:dexentry => "Over the winter, it closes its bud and endures the cold. In spring, the bud opens and releases pollen.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ROSELIA,:HappinessDay,0]
		]
	},

	:OnCreation => {},
},

:ROSERADE => {
	"Normal Form" => {
		:name => "Roserade",
		:dexnum => 407,
		:Type1 => :GRASS,
		:Type2 => :POISON,
		:BaseStats => [60, 70, 65, 125, 105, 90],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:NATURALCURE, :POISONPOINT],
		:HiddenAbilities => :TECHNICIAN,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 232,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :ROSELIA,
			:form => 0
		},
		:Moveset => [
			[1,:VENOMDRENCH],
			[1,:GRASSYTERRAIN],
			[1,:WEATHERBALL],
			[1,:POISONSTING],
			[1,:MEGADRAIN],
			[1,:MAGICALLEAF],
			[1,:SWEETSCENT]],
		:compatiblemoves => [:BODYSLAM,:BULLETSEED,:COVET,:CUT,:DAZZLINGGLEAM,:DOUBLEEDGE,:ENERGYBALL,:FLASH,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HYPERBEAM,:LASERFOCUS,:LEAFSTORM,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:NIGHTMARE,:PINMISSILE,:POISONJAB,:POWERWHIP,:PSYCHUP,:RAINDANCE,:SEEDBOMB,:SHADOWBALL,:SLUDGEBOMB,:SOLARBEAM,:SPIKES,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:SYNTHESIS,:SPIKES,:TOXICSPIKES,:UPROAR,:VENOMDRENCH,:VENOSHOCK,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Fairy, :Grass],
		:Height => 9,
		:Weight => 145,
		:WildItemUncommon => :POISONBARB,
		:kind => "Bouquet",
		:dexentry => "It attracts prey with a sweet aroma, then downs it with thorny whips hidden in its arms.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CRANIDOS => {
	"Normal Form" => {
		:name => "Cranidos",
		:dexnum => 408,
		:Type1 => :ROCK,
		:BaseStats => [67, 125, 40, 30, 30, 58],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:MOLDBREAKER, :SHEERFORCE],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 70,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:CRUNCH,:CURSE,:DOUBLEEDGE,:HAMMERARM,:IRONHEAD,:IRONTAIL,:LEER,:SLAM,:STOMP,:THRASH,:WHIRLWIND,],
		:Moveset => [
			[1,:HEADBUTT],
			[1,:LEER],
			[6,:FOCUSENERGY],
			[10,:PURSUIT],
			[15,:TAKEDOWN],
			[19,:SCARYFACE],
			[24,:ASSURANCE],
			[28,:CHIPAWAY],
			[33,:ANCIENTPOWER],
			[37,:ZENHEADBUTT],
			[42,:SCREECH],
			[46,:HEADSMASH]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BLIZZARD,:BULLDOZE,:DIG,:DRAGONPULSE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:HEADBUTT,:ICEBEAM,:INCINERATE,:IRONHEAD,:IRONTAIL,:MUDSLAP,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCARYFACE,:SCREECH,:SHOCKWAVE,:SMACKDOWN,:SPITE,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SWORDSDANCE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Monster],
		:Height => 9,
		:Weight => 315,
		:kind => "Head Butt",
		:dexentry => "It lived in jungles around 100 million years ago. Its skull is as hard as iron.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:RAMPARDOS,:Level,30]
		]
	},

	:OnCreation => {},
},

:RAMPARDOS => {
	"Normal Form" => {
		:name => "Rampardos",
		:dexnum => 409,
		:Type1 => :ROCK,
		:BaseStats => [97, 165, 60, 65, 50, 58],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:MOLDBREAKER, :SHEERFORCE],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :CRANIDOS,
			:form => 0
		},
		:Moveset => [
			[0,:ENDEAVOR],
			[1,:HEADBUTT],
			[1,:LEER],
			[1,:FOCUSENERGY],
			[1,:PURSUIT],
			[6,:FOCUSENERGY],
			[10,:PURSUIT],
			[15,:TAKEDOWN],
			[19,:SCARYFACE],
			[24,:ASSURANCE],
			[28,:CHIPAWAY],
			[36,:ANCIENTPOWER],
			[43,:ZENHEADBUTT],
			[51,:SCREECH],
			[58,:HEADSMASH]],
		:compatiblemoves => [:ANCIENTPOWER,:ASSURANCE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CUT,:DIG,:DRAGONPULSE,:DRAGONTAIL,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HIGHHORSEPOWER,:HYPERBEAM,:ICEBEAM,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:MUDSLAP,:OUTRAGE,:PAINSPLIT,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCARYFACE,:SCREECH,:SHOCKWAVE,:SMACKDOWN,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:SWORDSDANCE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Monster],
		:Height => 16,
		:Weight => 1025,
		:kind => "Head Butt",
		:dexentry => "Its powerful head-butt has enough power to shatter even the most durable things upon impact.",
		:BattlerPlayerY => 8,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SHIELDON => {
	"Normal Form" => {
		:name => "Shieldon",
		:dexnum => 410,
		:Type1 => :ROCK,
		:Type2 => :STEEL,
		:BaseStats => [30, 42, 118, 42, 88, 30],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:STURDY, :SOUNDPROOF],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 70,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:BODYSLAM,:COUNTER,:CURSE,:DOUBLEEDGE,:FISSURE,:FOCUSENERGY,:GUARDSPLIT,:HEADBUTT,:ROCKBLAST,:SCARYFACE,:SCREECH,:STEALTHROCK,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[1,:PROTECT],
			[6,:TAUNT],
			[10,:METALSOUND],
			[15,:TAKEDOWN],
			[19,:IRONDEFENSE],
			[24,:SWAGGER],
			[28,:ANCIENTPOWER],
			[33,:ENDURE],
			[37,:METALBURST],
			[42,:IRONHEAD],
			[46,:HEAVYSLAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BLIZZARD,:BODYSLAM,:BULLDOZE,:DIG,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FLAMETHROWER,:FLASHCANNON,:GUARDSPLIT,:HEADBUTT,:ICEBEAM,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MAGNETRISE,:MUDSLAP,:RAINDANCE,:ROAR,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCARYFACE,:SCREECH,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TAUNT,:THUNDER,:THUNDERBOLT,:TORMENT,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Monster],
		:Height => 5,
		:Weight => 570,
		:kind => "Shield",
		:dexentry => "A Pokémon that lived in jungles around 100 million years ago. Its facial hide is extremely hard.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:BASTIODON,:Level,30]
		]
	},

	:OnCreation => {},
},

:BASTIODON => {
	"Normal Form" => {
		:name => "Bastiodon",
		:dexnum => 411,
		:Type1 => :ROCK,
		:Type2 => :STEEL,
		:BaseStats => [60, 52, 168, 47, 138, 30],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:STURDY, :SOUNDPROOF],
		:GrowthRate => :Erratic,
		:GenderRatio => :FemEighth,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :SHIELDON,
			:form => 0
		},
		:Moveset => [
			[0,:BLOCK],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:TAUNT],
			[1,:METALSOUND],
			[6,:TAUNT],
			[10,:METALSOUND],
			[15,:TAKEDOWN],
			[19,:IRONDEFENSE],
			[24,:SWAGGER],
			[28,:ANCIENTPOWER],
			[36,:ENDURE],
			[43,:METALBURST],
			[51,:IRONHEAD],
			[58,:HEAVYSLAM]],
		:compatiblemoves => [:ANCIENTPOWER,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BULLDOZE,:DIG,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FLASHCANNON,:GIGAIMPACT,:GUARDSPLIT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICEFANG,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MAGICCOAT,:MAGNETRISE,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SCARYFACE,:SCREECH,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:TORMENT,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Monster],
		:Height => 13,
		:Weight => 1495,
		:kind => "Shield",
		:dexentry => "Any frontal attack is repulsed. It is a docile Pokémon that feeds on grass and berries.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BURMY => {
	"Plant Cloak" => {
		:name => "Burmy",
		:dexnum => 412,
		:Type1 => :BUG,
		:BaseStats => [40, 29, 45, 29, 45, 36],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SHEDSKIN, :OVERCOAT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 45,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:PROTECT],
			[10,:TACKLE],
			[15,:BUGBITE],
			[20,:HIDDENPOWER]],
		:compatiblemoves => [:BUGBITE,:ELECTROWEB,:STRINGSHOT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:NATURALGIFT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Gray",
		:EggGroups => [:Bug],
		:Height => 2,
		:Weight => 34,
		:kind => "Bagworm",
		:dexentry => "To shelter itself from cold, wintry winds, it covers itself with a cloak made of twigs and leaves.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 15,
		:evolutions => [
			[:WORMADAM,:LevelFemale,20],
			[:MOTHIM,:LevelMale,20]
		]
	},

	"Sandy Cloak" => {
	},

	"Trash Cloak" => {
	},

	:OnCreation => proc{
 begin #horribly stupid section to make the battle stress test work
 if PBFields::TRASHCLOAK.include?(@battle.FE)
 next 2 # Trash Cloak
 elsif PBFields::PLANTCLOAK.include?(@battle.FE)
 next 0 # Plant Cloak
 elsif PBFields::SANDYCLOAK.include?(@battle.FE)
 next 1 #Sandy Cloak
 else
 env=pbGetEnvironment()
 if env==:Sand || env==:Rock || env==:Cave
 next 1 # Sandy Cloak
 elsif $cache.mapdata[$game_map.map_id].Outdoor
 next 2 # Trash Cloak
 else
 next 0 # Plant Cloak
 end
 end
 rescue
 next 0
 end
 },
},

:WORMADAM => {
	"Plant Cloak" => {
		:name => "Wormadam",
		:dexnum => 413,
		:Type1 => :BUG,
		:Type2 => :GRASS,
		:BaseStats => [60, 59, 85, 79, 105, 36],
		:EVs => [0, 0, 0, 0, 2, 0],
		:Abilities => [:ANTICIPATION, :OVERCOAT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 148,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :BURMY,
			:form => 0
		},
		:Moveset => [
			[0,:QUIVERDANCE],
			[1,:SUCKERPUNCH],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:BUGBITE],
			[10,:PROTECT],
			[15,:BUGBITE],
			[20,:HIDDENPOWER],
			[23,:CONFUSION],
			[26,:RAZORLEAF],
			[29,:GROWTH],
			[32,:PSYBEAM],
			[35,:CAPTIVATE],
			[38,:FLAIL],
			[41,:ATTRACT],
			[44,:PSYCHIC],
			[47,:LEAFSTORM],
			[50,:BUGBUZZ]],
		:compatiblemoves => [:ALLYSWITCH,:BUGBITE,:BUGBUZZ,:BULLETSEED,:DREAMEATER,:ELECTROWEB,:ENDEAVOR,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HYPERBEAM,:INFESTATION,:LEAFSTORM,:MAGICALLEAF,:PSYCHIC,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SEEDBOMB,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SUCKERPUNCH,:SUNNYDAY,:SYNTHESIS,:TELEKINESIS,:THIEF,:UPROAR,:VENOSHOCK,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Bug],
		:Height => 5,
		:Weight => 65,
		:WildItemUncommon => :SILVERPOWDER,
		:kind => "Bagworm",
		:dexentry => "When Burmy evolved, its cloak became a part of this Pokémon's body. The cloak is never shed.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 12,
	},

	"Sandy Cloak" => {
		:Type2 => :GROUND,
		:BaseStats => [60, 79, 105, 59, 85, 36],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Moveset => [
			[0,:QUIVERDANCE],
			[1,:SUCKERPUNCH],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:BUGBITE],
			[10,:PROTECT],
			[15,:BUGBITE],
			[20,:HIDDENPOWER],
			[23,:CONFUSION],
			[26,:ROCKBLAST],
			[29,:HARDEN],
			[32,:PSYBEAM],
			[35,:CAPTIVATE],
			[38,:FLAIL],
			[41,:ATTRACT],
			[44,:PSYCHIC],
			[47,:FISSURE],
			[50,:BUGBUZZ],
		],
		:compatiblemoves => [:ALLYSWITCH,:BUGBITE,:BUGBUZZ,:BULLDOZE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:ELECTROWEB,:ENDEAVOR,:GIGAIMPACT,:HYPERBEAM,:INFESTATION,:MUDSHOT,:MUDSLAP,:PSYCHIC,:PSYCHUP,:RAINDANCE,:ROCKBLAST,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SANDTOMB,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:STEALTHROCK,:SUCKERPUNCH,:SUNNYDAY,:TELEKINESIS,:THIEF,:UPROAR,:VENOSHOCK,],
		:moveexceptions => [],
	},

	"Trash Cloak" => {
		:Type2 => :STEEL,
		:BaseStats => [60, 69, 95, 69, 95, 36],
		:EVs => [0, 0, 1, 0, 0, 1],
		:Moveset => [
			[0,:QUIVERDANCE],
			[1,:METALBURST],
			[1,:SUCKERPUNCH],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:BUGBITE],
			[10,:PROTECT],
			[15,:BUGBITE],
			[20,:HIDDENPOWER],
			[23,:CONFUSION],
			[26,:MIRRORSHOT],
			[29,:METALSOUND],
			[32,:PSYBEAM],
			[35,:CAPTIVATE],
			[38,:FLAIL],
			[41,:ATTRACT],
			[44,:PSYCHIC],
			[47,:IRONHEAD],
			[50,:BUGBUZZ],
		],
		:compatiblemoves => [:ALLYSWITCH,:BUGBITE,:BUGBUZZ,:DIG,:DREAMEATER,:ELECTROWEB,:ENDEAVOR,:FLASHCANNON,:GIGAIMPACT,:GUNKSHOT,:GYROBALL,:HYPERBEAM,:INFESTATION,:IRONDEFENSE,:IRONHEAD,:MAGNETRISE,:PSYCHIC,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:STEALTHROCK,:SUCKERPUNCH,:SUNNYDAY,:TELEKINESIS,:THIEF,:UPROAR,:VENOSHOCK,],
		:moveexceptions => [],
	},

	:OnCreation => proc{
 begin #horribly stupid section to make the battle stress test work
 if PBFields::TRASHCLOAK.include?(@battle.FE)
 next 2 # Trash Cloak
 elsif PBFields::PLANTCLOAK.include?(@battle.FE)
 next 0 # Plant Cloak
 elsif PBFields::SANDYCLOAK.include?(@battle.FE)
 next 1 #Sandy Cloak
 else
 env=pbGetEnvironment()
 if env==:Sand || env==:Rock || env==:Cave
 next 1 # Sandy Cloak
 elsif $cache.mapdata[$game_map.map_id].Outdoor
 next 2 # Trash Cloak
 else
 next 0 # Plant Cloak
 end
 end
 rescue
 next 0
 end
 },
},

:MOTHIM => {
	"Normal Form" => {
		:name => "Mothim",
		:dexnum => 414,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [70, 94, 50, 94, 50, 66],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:SWARM, :TINTEDLENS],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemZero,
		:BaseEXP => 148,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :BURMY,
			:form => 0
		},
		:Moveset => [
			[0,:QUIVERDANCE],
			[1,:TACKLE],
			[1,:PROTECT],
			[1,:BUGBITE],
			[10,:PROTECT],
			[15,:BUGBITE],
			[20,:HIDDENPOWER],
			[23,:CONFUSION],
			[26,:GUST],
			[29,:POISONPOWDER],
			[32,:PSYBEAM],
			[35,:CAMOUFLAGE],
			[38,:SILVERWIND],
			[41,:AIRSLASH],
			[44,:PSYCHIC],
			[47,:LUNGE],
			[50,:BUGBUZZ]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:BUGBITE,:BUGBUZZ,:DEFOG,:DREAMEATER,:ELECTROWEB,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:INFESTATION,:MUDSLAP,:OMINOUSWIND,:POLLENPUFF,:PSYCHIC,:PSYCHUP,:RAINDANCE,:ROOST,:SAFEGUARD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TWISTER,:UTURN,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Yellow",
		:EggGroups => [:Bug],
		:Height => 9,
		:Weight => 233,
		:WildItemUncommon => :SILVERPOWDER,
		:kind => "Moth",
		:dexentry => "It loves the honey of flowers and steals honey collected by Combee.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:COMBEE => {
	"Normal Form" => {
		:name => "Combee",
		:dexnum => 415,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [30, 30, 42, 30, 42, 70],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:HONEYGATHER, :HUSTLE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 49,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 4080,
		:Moveset => [
			[1,:SWEETSCENT],
			[1,:GUST],
			[13,:BUGBITE],
			[29,:BUGBUZZ]],
		:compatiblemoves => [:BUGBITE,:DUALWINGBEAT,:STRINGSHOT,:AIRCUTTER,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:SWIFT,:ENDEAVOR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,:CONFIDE,:DOUBLETEAM,:ENDURE,:FACADE,:FRUSTRATION,:HIDDENPOWER,:NATURALGIFT,:PROTECT,:REST,:RETURN,:ROUND,:SECRETPOWER,:SLEEPTALK,:SNORE,:SUBSTITUTE,:SWAGGER,:TOXIC,],
		:Color => "Yellow",
		:EggGroups => [:Bug],
		:Height => 3,
		:Weight => 55,
		:WildItemUncommon => :HONEY,
		:kind => "Tiny Bee",
		:dexentry => "A Pokémon formed by three others. It busily carries sweet floral honey to Vespiquen.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 13,
		:evolutions => [
			[:VESPIQUEN,:LevelFemale,21]
		]
	},

	:OnCreation => {},
},

:VESPIQUEN => {
	"Normal Form" => {
		:name => "Vespiquen",
		:dexnum => 416,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [70, 80, 102, 80, 102, 40],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:PRESSURE, :UNNERVE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 166,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 4080,
		:preevo => {
			:species => :COMBEE,
			:form => 0
		},
		:Moveset => [
			[0,:SLASH],
			[1,:FELLSTINGER],
			[1,:DESTINYBOND],
			[1,:SWEETSCENT],
			[1,:GUST],
			[1,:POISONSTING],
			[1,:CONFUSERAY],
			[5,:FURYCUTTER],
			[9,:PURSUIT],
			[13,:FURYSWIPES],
			[17,:DEFENDORDER],
			[25,:POWERGEM],
			[29,:HEALORDER],
			[33,:TOXIC],
			[37,:AIRSLASH],
			[41,:CAPTIVATE],
			[45,:ATTACKORDER],
			[49,:SWAGGER],
			[53,:DESTINYBOND],
			[57,:FELLSTINGER]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BEATUP,:BUGBITE,:BUGBUZZ,:CROSSPOISON,:CUT,:DEFOG,:DUALWINGBEAT,:ENDEAVOR,:FLASH,:FLING,:FURYCUTTER,:GIGAIMPACT,:HEX,:HONECLAWS,:HYPERBEAM,:INFESTATION,:LASERFOCUS,:MUDSLAP,:OMINOUSWIND,:PINMISSILE,:POWERGEM,:QUASH,:RAINDANCE,:REVENGE,:REVERSAL,:ROOST,:SCREECH,:SIGNALBEAM,:SLUDGEBOMB,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:TOXICSPIKES,:UPROAR,:UTURN,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Yellow",
		:EggGroups => [:Bug],
		:Height => 12,
		:Weight => 385,
		:WildItemUncommon => :POISONBARB,
		:kind => "Beehive",
		:dexentry => "Its abdomen is a honeycomb for grubs. It raises its grubs on honey collected by Combee.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:PACHIRISU => {
	"Normal Form" => {
		:name => "Pachirisu",
		:dexnum => 417,
		:Type1 => :ELECTRIC,
		:BaseStats => [60, 45, 70, 45, 90, 95],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:RUNAWAY, :PICKUP],
		:HiddenAbilities => :VOLTABSORB,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 142,
		:CatchRate => 200,
		:Happiness => 100,
		:EggSteps => 2805,
		:EggMoves => [:BABYDOLLEYES,:BESTOW,:BITE,:CHARGE,:COVET,:DEFENSECURL,:FAKETEARS,:FLAIL,:FLATTER,:FOLLOWME,:IONDELUGE,:IRONTAIL,:ROLLOUT,:TAILWHIP,],
		:Moveset => [
			[1,:GROWL],
			[1,:BIDE],
			[5,:QUICKATTACK],
			[9,:CHARM],
			[13,:SPARK],
			[17,:ENDURE],
			[19,:NUZZLE],
			[21,:SWIFT],
			[25,:ELECTROBALL],
			[29,:SWEETKISS],
			[33,:THUNDERWAVE],
			[37,:SUPERFANG],
			[41,:DISCHARGE],
			[45,:LASTRESORT],
			[49,:HYPERFANG]],
		:compatiblemoves => [:CHARGEBEAM,:CHARM,:COVET,:CUT,:DIG,:DRAININGKISS,:ECHOEDVOICE,:EERIEIMPULSE,:ELECTROWEB,:FAKETEARS,:FLASH,:FLING,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGNETRISE,:MUDSLAP,:PSYCHICFANGS,:RAINDANCE,:RISINGVOLTAGE,:ROLLOUT,:SEEDBOMB,:SHOCKWAVE,:SUPERFANG,:SWIFT,:TAILSLAP,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERPUNCH,:THUNDERWAVE,:UPROAR,:UTURN,:VOLTSWITCH,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Field, :Fairy],
		:Height => 4,
		:Weight => 39,
		:kind => "EleSquirrel",
		:dexentry => "It makes fur balls that crackle with static electricity. It stores them with berries in tree holes.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BUIZEL => {
	"Normal Form" => {
		:name => "Buizel",
		:dexnum => 418,
		:Type1 => :WATER,
		:BaseStats => [55, 65, 35, 60, 30, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :WATERVEIL],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AQUARING,:AQUATAIL,:BATONPASS,:DOUBLESLAP,:FURYCUTTER,:FURYSWIPES,:HEADBUTT,:HELPINGHAND,:MEFIRST,:MUDSLAP,:ODORSLEUTH,:SLASH,:SOAK,:SWITCHEROO,:TAILSLAP,],
		:Moveset => [
			[1,:SONICBOOM],
			[4,:GROWL],
			[7,:WATERSPORT],
			[11,:QUICKATTACK],
			[15,:WATERGUN],
			[18,:PURSUIT],
			[21,:SWIFT],
			[24,:AQUAJET],
			[27,:DOUBLEHIT],
			[31,:WHIRLPOOL],
			[35,:RAZORWIND],
			[38,:AQUATAIL],
			[41,:AGILITY],
			[45,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:ASSURANCE,:BLIZZARD,:BRICKBREAK,:BRINE,:BULKUP,:DIG,:DIVE,:ECHOEDVOICE,:FLIPTURN,:FOCUSPUNCH,:HAIL,:HEADBUTT,:HELPINGHAND,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:LIQUIDATION,:MEGAPUNCH,:MUDDYWATER,:MUDSLAP,:POWERUPPUNCH,:RAINDANCE,:RAZORSHELL,:ROCKSMASH,:ROCKTOMB,:SCALD,:STRENGTH,:SURF,:SWIFT,:TAILSLAP,:TRIPLEAXEL,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Water1, :Field],
		:Height => 7,
		:Weight => 295,
		:kind => "Sea Weasel",
		:dexentry => "It has a flotation sac that is like an inflatable collar. It floats on water with its head out.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
		:evolutions => [
			[:FLOATZEL,:Level,26]
		]
	},

	:OnCreation => {},
},

:FLOATZEL => {
	"Normal Form" => {
		:name => "Floatzel",
		:dexnum => 419,
		:Type1 => :WATER,
		:BaseStats => [85, 105, 55, 85, 50, 115],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SWIFTSWIM, :WATERVEIL],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BUIZEL,
			:form => 0
		},
		:Moveset => [
			[1,:ICEFANG],
			[1,:CRUNCH],
			[1,:SONICBOOM],
			[1,:GROWL],
			[1,:WATERSPORT],
			[1,:QUICKATTACK],
			[4,:GROWL],
			[7,:WATERSPORT],
			[11,:QUICKATTACK],
			[15,:WATERGUN],
			[18,:PURSUIT],
			[21,:SWIFT],
			[24,:AQUAJET],
			[29,:DOUBLEHIT],
			[35,:WHIRLPOOL],
			[41,:RAZORWIND],
			[46,:AQUATAIL],
			[51,:AGILITY],
			[57,:HYDROPUMP]],
		:compatiblemoves => [:AGILITY,:AQUATAIL,:ASSURANCE,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BRINE,:BULKUP,:DIG,:DIVE,:ECHOEDVOICE,:FLIPTURN,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:LIQUIDATION,:LOWKICK,:MEGAPUNCH,:MUDDYWATER,:MUDSLAP,:PAYBACK,:POWERUPPUNCH,:PSYCHICFANGS,:RAINDANCE,:RAZORSHELL,:ROAR,:ROCKSMASH,:ROCKTOMB,:SCALD,:STRENGTH,:SURF,:SWIFT,:TAILSLAP,:TAUNT,:TORMENT,:TRIPLEAXEL,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Water1, :Field],
		:Height => 11,
		:Weight => 335,
		:kind => "Sea Weasel",
		:dexentry => "It floats using its well-developed flotation sac. It assists in the rescues of drowning people.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 5,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CHERUBI => {
	"Normal Form" => {
		:name => "Cherubi",
		:dexnum => 420,
		:Type1 => :GRASS,
		:BaseStats => [45, 35, 45, 62, 53, 35],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:CHLOROPHYLL],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 55,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AROMATHERAPY,:DEFENSECURL,:FLOWERSHIELD,:GRASSWHISTLE,:GRASSYTERRAIN,:HEALPULSE,:HEALINGWISH,:NATURALGIFT,:NATUREPOWER,:RAZORLEAF,:ROLLOUT,:SEEDBOMB,:SWEETSCENT,:TICKLE,:WEATHERBALL,],
		:Moveset => [
			[1,:MORNINGSUN],
			[1,:TACKLE],
			[7,:GROWTH],
			[10,:LEECHSEED],
			[13,:HELPINGHAND],
			[19,:MAGICALLEAF],
			[22,:SUNNYDAY],
			[28,:WORRYSEED],
			[31,:TAKEDOWN],
			[37,:SOLARBEAM],
			[40,:LUCKYCHANT],
			[47,:PETALBLIZZARD]],
		:compatiblemoves => [:BULLETSEED,:DAZZLINGGLEAM,:DRAININGKISS,:ENERGYBALL,:FLASH,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HELPINGHAND,:MAGICALLEAF,:NATUREPOWER,:POLLENPUFF,:ROLLOUT,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Fairy, :Grass],
		:Height => 4,
		:Weight => 33,
		:WildItemUncommon => :MIRACLESEED,
		:kind => "Cherry",
		:dexentry => "The small ball holds the nutrients needed for evolution. Apparently, it is very sweet and tasty.",
		:BattlerPlayerY => 32,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CHERRIM,:Level,25]
		]
	},

	:OnCreation => {},
},

:CHERRIM => {
	"Overcast Form" => {
		:name => "Cherrim",
		:dexnum => 421,
		:Type1 => :GRASS,
		:BaseStats => [70, 60, 70, 87, 78, 85],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:FLOWERGIFT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 158,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CHERUBI,
			:form => 0
		},
		:Moveset => [
			[0,:PETALDANCE],
			[1,:MORNINGSUN],
			[1,:TACKLE],
			[1,:GROWTH],
			[1,:LEECHSEED],
			[7,:GROWTH],
			[10,:LEECHSEED],
			[13,:HELPINGHAND],
			[19,:MAGICALLEAF],
			[22,:SUNNYDAY],
			[30,:WORRYSEED],
			[35,:TAKEDOWN],
			[43,:SOLARBEAM],
			[48,:LUCKYCHANT],
			[50,:PETALBLIZZARD]],
		:compatiblemoves => [:BULLETSEED,:DAZZLINGGLEAM,:DRAININGKISS,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HELPINGHAND,:HYPERBEAM,:LASERFOCUS,:MAGICALLEAF,:NATUREPOWER,:PLAYROUGH,:POLLENPUFF,:ROLLOUT,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SOLARBLADE,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Fairy, :Grass],
		:Height => 5,
		:Weight => 93,
		:WildItemUncommon => :MIRACLESEED,
		:kind => "Blossom",
		:dexentry => "It blooms during times of strong sunlight. It tries to make up for everything it endured as a bud.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
	},

	"Sunshine Form" => {
	},

	:OnCreation => {},
},

:SHELLOS => {
	"West Sea" => {
		:name => "Shellos",
		:dexnum => 422,
		:Type1 => :WATER,
		:BaseStats => [76, 48, 48, 57, 62, 34],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:STICKYHOLD, :STORMDRAIN],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 65,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ACIDARMOR,:AMNESIA,:BRINE,:CLEARSMOG,:COUNTER,:CURSE,:FISSURE,:MEMENTO,:MIRRORCOAT,:MIST,:SLUDGE,:SPITUP,:STOCKPILE,:SWALLOW,:TRUMPCARD,:YAWN,],
		:Moveset => [
			[1,:MUDSLAP],
			[2,:MUDSPORT],
			[4,:HARDEN],
			[7,:WATERPULSE],
			[11,:MUDBOMB],
			[16,:HIDDENPOWER],
			[22,:RAINDANCE],
			[29,:BODYSLAM],
			[37,:MUDDYWATER],
			[46,:RECOVER]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BLIZZARD,:BODYSLAM,:BRINE,:DIVE,:EARTHPOWER,:HAIL,:HEADBUTT,:HYDROPUMP,:ICEBEAM,:ICYWIND,:INFESTATION,:MUDDYWATER,:MUDSHOT,:PAINSPLIT,:RAINDANCE,:SCALD,:SKITTERSMACK,:STRINGSHOT,:SURF,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Water1, :Amorphous],
		:Height => 3,
		:Weight => 63,
		:kind => "Sea Slug",
		:dexentry => "Its colors and shapes differ from region to region. In the Sinnoh region, two types are confirmed.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GASTRODON,:Level,30]
		]
	},

	"East Sea" => {
	},

	:OnCreation => proc{
 # Map IDs for second form
 if $game_map && Shellos.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:GASTRODON => {
	"West Sea" => {
		:name => "Gastrodon",
		:dexnum => 423,
		:Type1 => :WATER,
		:Type2 => :GROUND,
		:BaseStats => [111, 83, 68, 92, 82, 39],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:STICKYHOLD, :STORMDRAIN],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 166,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SHELLOS,
			:form => 0
		},
		:Moveset => [
			[1,:MUDSLAP],
			[1,:MUDSPORT],
			[1,:HARDEN],
			[1,:WATERPULSE],
			[2,:MUDSPORT],
			[4,:HARDEN],
			[7,:WATERPULSE],
			[11,:MUDBOMB],
			[16,:HIDDENPOWER],
			[22,:RAINDANCE],
			[29,:BODYSLAM],
			[41,:MUDDYWATER],
			[54,:RECOVER]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:BLIZZARD,:BLOCK,:BODYSLAM,:BRINE,:BULLDOZE,:DIG,:DIVE,:EARTHPOWER,:EARTHQUAKE,:FLASH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INFESTATION,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:PAINSPLIT,:RAINDANCE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCALD,:SKITTERSMACK,:SLUDGEBOMB,:SLUDGEWAVE,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:STRINGSHOT,:SURF,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Water1, :Amorphous],
		:Height => 9,
		:Weight => 299,
		:kind => "Sea Slug",
		:dexentry => "It has a pliable body without any bones. If any part of its body is torn off, it grows right back.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	"East Sea" => {
	},

	:OnCreation => proc{
 # Map IDs for second form
 if $game_map && Shellos.include?($game_map.map_id)
 next 1
 else
 next 0
 end
 },
},

:AMBIPOM => {
	"Normal Form" => {
		:name => "Ambipom",
		:dexnum => 424,
		:Type1 => :NORMAL,
		:BaseStats => [75, 100, 66, 60, 66, 115],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:TECHNICIAN, :PICKUP],
		:HiddenAbilities => :SKILLLINK,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 169,
		:CatchRate => 45,
		:Happiness => 100,
		:EggSteps => 5355,
		:preevo => {
			:species => :AIPOM,
			:form => 0
		},
		:Moveset => [
			[1,:DUALCHOP],
			[1,:SCRATCH],
			[1,:TAILWHIP],
			[1,:SANDATTACK],
			[1,:ASTONISH],
			[4,:SANDATTACK],
			[8,:ASTONISH],
			[11,:BATONPASS],
			[15,:TICKLE],
			[18,:FURYSWIPES],
			[22,:SWIFT],
			[25,:SCREECH],
			[29,:AGILITY],
			[32,:DOUBLEHIT],
			[36,:FLING],
			[39,:NASTYPLOT],
			[43,:LASTRESORT]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:ASSURANCE,:BEATUP,:BODYSLAM,:BOUNCE,:BREAKINGSWIPE,:BRICKBREAK,:COVET,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:FIREPUNCH,:FLING,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:NIGHTMARE,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKSMASH,:ROLEPLAY,:SCREECH,:SEEDBOMB,:SEISMICTOSS,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNATCH,:SOLARBEAM,:SPITE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:TRIPLEAXEL,:UPROAR,:UTURN,:WATERPULSE,:WORKUP,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Field],
		:Height => 12,
		:Weight => 203,
		:kind => "Long Tail",
		:dexentry => "To eat, it deftly shucks nuts with its two tails. It rarely uses its arms now.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:DRIFLOON => {
	"Normal Form" => {
		:name => "Drifloon",
		:dexnum => 425,
		:Type1 => :GHOST,
		:Type2 => :FLYING,
		:BaseStats => [90, 50, 34, 60, 44, 70],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:AFTERMATH, :UNBURDEN],
		:HiddenAbilities => :FLAREBOOST,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 70,
		:CatchRate => 125,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:BODYSLAM,:CLEARSMOG,:DEFOG,:DESTINYBOND,:DISABLE,:HAZE,:HYPNOSIS,:MEMENTO,:TAILWIND,:WEATHERBALL,],
		:Moveset => [
			[1,:CONSTRICT],
			[1,:MINIMIZE],
			[4,:ASTONISH],
			[8,:GUST],
			[13,:FOCUSENERGY],
			[16,:PAYBACK],
			[20,:OMINOUSWIND],
			[25,:STOCKPILE],
			[27,:HEX],
			[32,:SWALLOW],
			[32,:SPITUP],
			[36,:SHADOWBALL],
			[40,:AMNESIA],
			[44,:BATONPASS],
			[50,:EXPLOSION]],
		:compatiblemoves => [:ACROBATICS,:AIRCUTTER,:ALLYSWITCH,:BATONPASS,:BIND,:BODYSLAM,:BRUTALSWING,:CALMMIND,:CHARGEBEAM,:CUT,:DEFOG,:DREAMEATER,:EMBARGO,:EXPLOSION,:FLASH,:FOCUSENERGY,:GYROBALL,:HEX,:ICYWIND,:KNOCKOFF,:MAGICCOAT,:MUDSLAP,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:ROLLOUT,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SILVERWIND,:SKILLSWAP,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILWIND,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Amorphous],
		:Height => 4,
		:Weight => 12,
		:kind => "Balloon",
		:dexentry => "A Pokémon formed by the spirits of people and Pokémon. It loves damp, humid seasons.",
		:BattlerPlayerY => 20,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 9,
		:evolutions => [
			[:DRIFBLIM,:Level,28]
		]
	},

	:OnCreation => {},
},

:DRIFBLIM => {
	"Normal Form" => {
		:name => "Drifblim",
		:dexnum => 426,
		:Type1 => :GHOST,
		:Type2 => :FLYING,
		:BaseStats => [150, 80, 44, 90, 54, 80],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:AFTERMATH, :UNBURDEN],
		:HiddenAbilities => :FLAREBOOST,
		:GrowthRate => :Fluctuating,
		:GenderRatio => :FemHalf,
		:BaseEXP => 174,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :DRIFLOON,
			:form => 0
		},
		:Moveset => [
			[1,:PHANTOMFORCE],
			[1,:CONSTRICT],
			[1,:MINIMIZE],
			[1,:ASTONISH],
			[1,:GUST],
			[4,:ASTONISH],
			[8,:GUST],
			[13,:FOCUSENERGY],
			[16,:PAYBACK],
			[20,:OMINOUSWIND],
			[25,:STOCKPILE],
			[27,:HEX],
			[34,:SWALLOW],
			[34,:SPITUP],
			[40,:SHADOWBALL],
			[46,:AMNESIA],
			[52,:BATONPASS],
			[60,:EXPLOSION],
			[65,:PHANTOMFORCE]],
		:compatiblemoves => [:ACROBATICS,:AIRCUTTER,:ALLYSWITCH,:BATONPASS,:BIND,:BODYSLAM,:BRUTALSWING,:CALMMIND,:CHARGEBEAM,:CUT,:DEFOG,:DREAMEATER,:EMBARGO,:EXPLOSION,:FLASH,:FOCUSENERGY,:FLY,:GIGAIMPACT,:GYROBALL,:HEX,:HYPERBEAM,:ICYWIND,:IMPRISON,:KNOCKOFF,:MAGICCOAT,:MUDSLAP,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:ROLLOUT,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SILVERWIND,:SKILLSWAP,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILWIND,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Amorphous],
		:Height => 12,
		:Weight => 150,
		:kind => "Blimp",
		:dexentry => "It is drowzy in daytime, but flies off in the evening in big groups. No one knows where they go.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 14,
	},

	:OnCreation => {},
},

:BUNEARY => {
	"Normal Form" => {
		:name => "Buneary",
		:dexnum => 427,
		:Type1 => :NORMAL,
		:BaseStats => [55, 66, 44, 44, 56, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:RUNAWAY, :KLUTZ],
		:HiddenAbilities => :LIMBER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 70,
		:CatchRate => 190,
		:Happiness => 0,
		:EggSteps => 5355,
		:EggMoves => [:CIRCLETHROW,:COPYCAT,:COSMICPOWER,:DOUBLEHIT,:ENCORE,:FAKEOUT,:FAKETEARS,:FIREPUNCH,:FLAIL,:FOCUSPUNCH,:ICEPUNCH,:LOWKICK,:MUDSPORT,:POWERUPPUNCH,:SKYUPPERCUT,:SWEETKISS,:SWITCHEROO,:TEETERDANCE,:THUNDERPUNCH,],
		:Moveset => [
			[1,:FRUSTRATION],
			[1,:DEFENSECURL],
			[1,:SPLASH],
			[1,:POUND],
			[1,:FORESIGHT],
			[6,:ENDURE],
			[13,:BABYDOLLEYES],
			[16,:QUICKATTACK],
			[23,:JUMPKICK],
			[26,:BATONPASS],
			[33,:AGILITY],
			[36,:DIZZYPUNCH],
			[43,:AFTERYOU],
			[46,:CHARM],
			[50,:ENTRAINMENT],
			[56,:BOUNCE],
			[63,:HEALINGWISH]],
		:compatiblemoves => [:AFTERYOU,:AGILITY,:ASSURANCE,:BATONPASS,:BOUNCE,:CHARGEBEAM,:CHARM,:COSMICPOWER,:COVET,:CUT,:DIG,:DRAINPUNCH,:ENCORE,:ENDEAVOR,:FAKETEARS,:FIREPUNCH,:FLING,:FOCUSPUNCH,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:IRONTAIL,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:ROCKSMASH,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:SUNNYDAY,:SWIFT,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIPLEAXEL,:UPROAR,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field, :HumanLike],
		:Height => 4,
		:Weight => 55,
		:kind => "Rabbit",
		:dexentry => "It slams foes by sharply uncoiling its rolled ears. It stings enough to make a grown-up cry in pain.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LOPUNNY,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:LOPUNNY => {
	"Normal Form" => {
		:name => "Lopunny",
		:dexnum => 428,
		:Type1 => :NORMAL,
		:BaseStats => [65, 76, 84, 54, 96, 105],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:CUTECHARM, :KLUTZ],
		:HiddenAbilities => :LIMBER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 168,
		:CatchRate => 60,
		:Happiness => 140,
		:EggSteps => 5355,
		:preevo => {
			:species => :BUNEARY,
			:form => 0
		},
		:Moveset => [
			[0,:RETURN],
			[1,:HEALINGWISH],
			[1,:BOUNCE],
			[1,:ROTOTILLER],
			[1,:MIRRORCOAT],
			[1,:MAGICCOAT],
			[1,:DEFENSECURL],
			[1,:SPLASH],
			[1,:POUND],
			[1,:FORESIGHT],
			[6,:ENDURE],
			[13,:BABYDOLLEYES],
			[16,:QUICKATTACK],
			[23,:JUMPKICK],
			[26,:BATONPASS],
			[33,:AGILITY],
			[36,:DIZZYPUNCH],
			[43,:AFTERYOU],
			[46,:CHARM],
			[53,:ENTRAINMENT],
			[56,:BOUNCE],
			[63,:HEALINGWISH],
			[66,:HIJUMPKICK]],
		:compatiblemoves => [:ACROBATICS,:AFTERYOU,:ASSURANCE,:AURASPHERE,:BATONPASS,:BLIZZARD,:BOUNCE,:BRUTALSWING,:CHARGEBEAM,:CHARM,:CLOSECOMBAT,:COSMICPOWER,:COVET,:CUT,:DIG,:DRAINPUNCH,:ENCORE,:ENDEAVOR,:FAKETEARS,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LOWKICK,:LOWSWEEP,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKSMASH,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:STRENGTH,:SUNNYDAY,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIPLEAXEL,:UPROAR,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field, :HumanLike],
		:Height => 12,
		:Weight => 333,
		:kind => "Rabbit",
		:dexentry => "An extremely cautious Pokémon. It cloaks its body with its fluffy ear fur when it senses danger.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:Type2 => :FIGHTING,
		:BaseStats => [65, 136, 94, 54, 96, 135],
		:Abilities => [:SCRAPPY],
		:Height => 13,
		:Weight => 283,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:LOPUNNITE => 1,
	},
},

:MISMAGIUS => {
	"Normal Form" => {
		:name => "Mismagius",
		:dexnum => 429,
		:Type1 => :GHOST,
		:BaseStats => [60, 60, 60, 105, 105, 105],
		:EVs => [0, 0, 0, 1, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 6630,
		:preevo => {
			:species => :MISDREAVUS,
			:form => 0
		},
		:Moveset => [
			[1,:MYSTICALFIRE],
			[1,:POWERGEM],
			[1,:PHANTOMFORCE],
			[1,:LUCKYCHANT],
			[1,:MAGICALLEAF],
			[1,:GROWL],
			[1,:PSYWAVE],
			[1,:SPITE],
			[1,:ASTONISH]],
		:compatiblemoves => [:AERIALACE,:ALLYSWITCH,:CALMMIND,:CHARGEBEAM,:CURSE,:DARKPULSE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:ENERGYBALL,:FLASH,:FOULPLAY,:GIGAIMPACT,:HEADBUTT,:HEALBELL,:HEX,:HYPERBEAM,:HYPERVOICE,:ICYWIND,:IMPRISON,:LASERFOCUS,:MAGICCOAT,:MAGICROOM,:MIMIC,:MYSTICALFIRE,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:RAINDANCE,:SCREECH,:SHADOWBALL,:SHOCKWAVE,:SKILLSWAP,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:WILLOWISP,:WONDERROOM,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Amorphous],
		:Height => 9,
		:Weight => 44,
		:kind => "Magical",
		:dexentry => "Its cries sound like incantations. Those hearing them are tormented by headaches and hallucinations.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 8,
	},

	:OnCreation => {},
},

:HONCHKROW => {
	"Normal Form" => {
		:name => "Honchkrow",
		:dexnum => 430,
		:Type1 => :DARK,
		:Type2 => :FLYING,
		:BaseStats => [100, 125, 52, 105, 52, 71],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INSOMNIA, :SUPERLUCK],
		:HiddenAbilities => :MOXIE,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 177,
		:CatchRate => 30,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :MURKROW,
			:form => 0
		},
		:Moveset => [
			[1,:NIGHTSLASH],
			[1,:SUCKERPUNCH],
			[1,:ASTONISH],
			[1,:PURSUIT],
			[1,:HAZE],
			[1,:WINGATTACK],
			[25,:SWAGGER],
			[35,:NASTYPLOT],
			[45,:FOULPLAY],
			[55,:NIGHTSLASH],
			[65,:QUASH],
			[75,:DARKPULSE]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:ASSURANCE,:BRAVEBIRD,:CALMMIND,:CURSE,:DARKPULSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DREAMEATER,:DUALWINGBEAT,:EMBARGO,:FLY,:FOULPLAY,:GIGAIMPACT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:ICYWIND,:INCINERATE,:LASHOUT,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAYBACK,:PLUCK,:PSYCHIC,:PSYCHUP,:QUASH,:RAINDANCE,:RETALIATE,:ROOST,:SCREECH,:SHADOWBALL,:SKYATTACK,:SNARL,:SNATCH,:SPITE,:STEELWING,:SUCKERPUNCH,:SUNNYDAY,:SUPERPOWER,:SWIFT,:TAILWIND,:TAUNT,:THIEF,:THUNDERWAVE,:TORMENT,:TWISTER,:UPROAR,],
		:moveexceptions => [],
		:Color => "Black",
		:EggGroups => [:Flying],
		:Height => 9,
		:Weight => 273,
		:kind => "Big Boss",
		:dexentry => "Becoming active at night, it is known to swarm with numerous Murkrow in tow.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GLAMEOW => {
	"Normal Form" => {
		:name => "Glameow",
		:dexnum => 431,
		:Type1 => :NORMAL,
		:BaseStats => [49, 55, 42, 42, 37, 85],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:LIMBER, :OWNTEMPO],
		:HiddenAbilities => :KEENEYE,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 62,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASSURANCE,:BITE,:FAKETEARS,:FLAIL,:LASTRESORT,:QUICKATTACK,:SANDATTACK,:SNATCH,:TAILWHIP,:WAKEUPSLAP,],
		:Moveset => [
			[1,:FAKEOUT],
			[5,:SCRATCH],
			[8,:GROWL],
			[13,:HYPNOSIS],
			[17,:FEINTATTACK],
			[20,:FURYSWIPES],
			[25,:CHARM],
			[29,:ASSIST],
			[32,:CAPTIVATE],
			[37,:SLASH],
			[41,:SUCKERPUNCH],
			[44,:ATTRACT],
			[48,:HONECLAWS],
			[50,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:ASSURANCE,:BEATUP,:COVET,:CUT,:DIG,:DREAMEATER,:ECHOEDVOICE,:FAKETEARS,:FLASH,:FOULPLAY,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:MUDSLAP,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHUP,:RAINDANCE,:RETALIATE,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNATCH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THUNDER,:THUNDERBOLT,:TORMENT,:UTURN,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 39,
		:kind => "Catty",
		:dexentry => "It claws if displeased and purrs when affectionate. Its fickleness is very popular among some.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PURUGLY,:Level,38]
		]
	},

	:OnCreation => {},
},

:PURUGLY => {
	"Normal Form" => {
		:name => "Purugly",
		:dexnum => 432,
		:Type1 => :NORMAL,
		:BaseStats => [71, 82, 64, 64, 59, 112],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:THICKFAT, :OWNTEMPO],
		:HiddenAbilities => :DEFIANT,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleQuarter,
		:BaseEXP => 158,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GLAMEOW,
			:form => 0
		},
		:Moveset => [
			[0,:SWAGGER],
			[1,:FAKEOUT],
			[1,:SCRATCH],
			[1,:GROWL],
			[5,:SCRATCH],
			[8,:GROWL],
			[13,:HYPNOSIS],
			[17,:FEINTATTACK],
			[20,:FURYSWIPES],
			[25,:CHARM],
			[29,:ASSIST],
			[32,:CAPTIVATE],
			[37,:SLASH],
			[45,:BODYSLAM],
			[52,:ATTRACT],
			[60,:HONECLAWS]],
		:compatiblemoves => [:AERIALACE,:ASSURANCE,:BEATUP,:BODYSLAM,:BULLDOZE,:COVET,:CUT,:DIG,:DREAMEATER,:ECHOEDVOICE,:FAKETEARS,:FLASH,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LASTRESORT,:MUDSLAP,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROAR,:ROLLOUT,:SCARYFACE,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SNATCH,:STOMPINGTANTRUM,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:TORMENT,:UTURN,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 438,
		:kind => "Tiger Cat",
		:dexentry => "It is a brazen brute that barges its way into another Pokémon's nest and claims it as its own.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CHINGLING => {
	"Normal Form" => {
		:name => "Chingling",
		:dexnum => 433,
		:Type1 => :PSYCHIC,
		:BaseStats => [45, 30, 50, 65, 50, 45],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 57,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:COSMICPOWER,:CURSE,:DISABLE,:FUTURESIGHT,:HYPNOSIS,:RECOVER,:SKILLSWAP,:STOREDPOWER,:WISH,],
		:Moveset => [
			[1,:WRAP],
			[4,:GROWL],
			[7,:ASTONISH],
			[10,:CONFUSION],
			[13,:YAWN],
			[16,:LASTRESORT],
			[19,:ENTRAINMENT],
			[32,:UPROAR]],
		:compatiblemoves => [:ALLYSWITCH,:BIND,:CALMMIND,:CHARGEBEAM,:CHARM,:COSMICPOWER,:DAZZLINGGLEAM,:DEFENSECURL,:DREAMEATER,:ECHOEDVOICE,:EXPANDINGFORCE,:FAKETEARS,:FLASH,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICYWIND,:IMPRISON,:KNOCKOFF,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SPEEDSWAP,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:EggGroups => [:Undiscovered],
		:Height => 2,
		:Weight => 6,
		:WildItemUncommon => :CLEANSETAG,
		:kind => "Bell",
		:dexentry => "It emits cries by agitating an orb at the back of its throat. It moves with flouncing hops.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 12,
		:evolutions => [
			[:CHIMECHO,:HappinessNight,0]
		]
	},

	:OnCreation => {},
},

:STUNKY => {
	"Normal Form" => {
		:name => "Stunky",
		:dexnum => 434,
		:Type1 => :POISON,
		:Type2 => :DARK,
		:BaseStats => [63, 63, 47, 41, 41, 74],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:STENCH, :AFTERMATH],
		:HiddenAbilities => :KEENEYE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 225,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:ASTONISH,:CRUNCH,:DOUBLEEDGE,:FLAMEBURST,:FOULPLAY,:HAZE,:IRONTAIL,:LEER,:PLAYROUGH,:PUNISHMENT,:PURSUIT,:SCARYFACE,:SMOG,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:FOCUSENERGY],
			[3,:POISONGAS],
			[7,:SCREECH],
			[9,:FURYSWIPES],
			[13,:SMOKESCREEN],
			[15,:FEINT],
			[19,:ACIDSPRAY],
			[21,:BITE],
			[25,:SLASH],
			[27,:TOXIC],
			[31,:NIGHTSLASH],
			[33,:MEMENTO],
			[39,:SUCKERPUNCH],
			[43,:BELCH],
			[45,:EXPLOSION]],
		:compatiblemoves => [:ASSURANCE,:CORROSIVEGAS,:CRUNCH,:CUT,:DARKPULSE,:DEFOG,:DIG,:EXPLOSION,:FIREBLAST,:FLAMETHROWER,:FOCUSENERGY,:FOULPLAY,:FURYCUTTER,:HEADBUTT,:HEX,:HONECLAWS,:INCINERATE,:IRONTAIL,:LASHOUT,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:RAINDANCE,:ROAR,:ROCKSMASH,:SCARYFACE,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SLUDGEBOMB,:SNARL,:SNATCH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 192,
		:kind => "Skunk",
		:dexentry => "It protects itself by spraying a noxious fluid from its rear. The stench lingers for 24 hours.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SKUNTANK,:Level,34]
		]
	},

	:OnCreation => {},
},

:SKUNTANK => {
	"Normal Form" => {
		:name => "Skuntank",
		:dexnum => 435,
		:Type1 => :POISON,
		:Type2 => :DARK,
		:BaseStats => [103, 93, 67, 71, 61, 84],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:STENCH, :AFTERMATH],
		:HiddenAbilities => :KEENEYE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 168,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :STUNKY,
			:form => 0
		},
		:Moveset => [
			[0,:FLAMETHROWER],
			[1,:SCRATCH],
			[1,:FOCUSENERGY],
			[1,:POISONGAS],
			[1,:SCREECH],
			[3,:POISONGAS],
			[7,:SCREECH],
			[9,:FURYSWIPES],
			[13,:SMOKESCREEN],
			[15,:FEINT],
			[19,:ACIDSPRAY],
			[21,:BITE],
			[25,:SLASH],
			[27,:TOXIC],
			[31,:NIGHTSLASH],
			[33,:MEMENTO],
			[37,:VENOMDRENCH],
			[39,:SUCKERPUNCH],
			[43,:BELCH],
			[45,:EXPLOSION]],
		:compatiblemoves => [:ASSURANCE,:BURNINGJEALOUSY,:CORROSIVEGAS,:CRUNCH,:CUT,:DARKPULSE,:DEFOG,:DIG,:EXPLOSION,:FIREBLAST,:FIRESPIN,:FLAMETHROWER,:FOCUSENERGY,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEX,:HONECLAWS,:HYPERBEAM,:INCINERATE,:IRONTAIL,:LASHOUT,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:POISONJAB,:RAINDANCE,:ROAR,:ROCKSMASH,:SCARYFACE,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SLUDGEBOMB,:SNARL,:SNATCH,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAILSLAP,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:VENOMDRENCH,:VENOSHOCK,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 380,
		:kind => "Skunk",
		:dexentry => "It sprays a vile-smelling fluid from the tip of its tail to attack. Its range is over 160 feet.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 18,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BRONZOR => {
	"Normal Form" => {
		:name => "Bronzor",
		:dexnum => 436,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [57, 24, 86, 24, 86, 23],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:LEVITATE, :HEATPROOF],
		:HiddenAbilities => :HEAVYMETAL,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 60,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:TACKLE],
			[1,:CONFUSION],
			[5,:HYPNOSIS],
			[9,:IMPRISON],
			[11,:CONFUSERAY],
			[15,:PSYWAVE],
			[19,:IRONDEFENSE],
			[21,:FEINTATTACK],
			[25,:SAFEGUARD],
			[29,:FUTURESIGHT],
			[31,:METALSOUND],
			[35,:GYROBALL],
			[39,:EXTRASENSORY],
			[41,:PAYBACK],
			[45,:HEALBLOCK],
			[49,:HEAVYSLAM]],
		:compatiblemoves => [:ALLYSWITCH,:ANCIENTPOWER,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:DREAMEATER,:EARTHQUAKE,:EXPANDINGFORCE,:FLASH,:FLASHCANNON,:FUTURESIGHT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEAVYSLAM,:HEX,:IMPRISON,:IRONDEFENSE,:LIGHTSCREEN,:PAYBACK,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SPEEDSWAP,:STEALTHROCK,:STEELROLLER,:SUNNYDAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Green",
		:EggGroups => [:Mineral],
		:Height => 5,
		:Weight => 605,
		:WildItemUncommon => :METALCOAT,
		:kind => "Bronze",
		:dexentry => "Implements shaped like it were discovered in ancient tombs. It is unknown if they are related.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 13,
		:evolutions => [
			[:BRONZONG,:Level,33]
		]
	},

	:OnCreation => {},
},

:BRONZONG => {
	"Normal Form" => {
		:name => "Bronzong",
		:dexnum => 437,
		:Type1 => :STEEL,
		:Type2 => :PSYCHIC,
		:BaseStats => [67, 89, 116, 79, 116, 33],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:LEVITATE, :HEATPROOF],
		:HiddenAbilities => :HEAVYMETAL,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 175,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :BRONZOR,
			:form => 0
		},
		:Moveset => [
			[0,:BLOCK],
			[1,:SUNNYDAY],
			[1,:RAINDANCE],
			[1,:TACKLE],
			[1,:CONFUSION],
			[1,:HYPNOSIS],
			[1,:IMPRISON],
			[5,:HYPNOSIS],
			[9,:IMPRISON],
			[11,:CONFUSERAY],
			[15,:PSYWAVE],
			[19,:IRONDEFENSE],
			[21,:FEINTATTACK],
			[25,:SAFEGUARD],
			[29,:FUTURESIGHT],
			[31,:METALSOUND],
			[36,:GYROBALL],
			[42,:EXTRASENSORY],
			[46,:PAYBACK],
			[52,:HEALBLOCK],
			[58,:HEAVYSLAM]],
		:compatiblemoves => [:ALLYSWITCH,:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:DREAMEATER,:EARTHQUAKE,:EXPANDINGFORCE,:EXPLOSION,:FLASH,:FLASHCANNON,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEAVYSLAM,:HEX,:HYPERBEAM,:IMPRISON,:IRONDEFENSE,:IRONHEAD,:LIGHTSCREEN,:METEORBEAM,:PAYBACK,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SAFEGUARD,:SANDSTORM,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SPEEDSWAP,:STEALTHROCK,:STEELROLLER,:STRENGTH,:SUNNYDAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WEATHERBALL,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Green",
		:EggGroups => [:Mineral],
		:Height => 13,
		:Weight => 1870,
		:WildItemUncommon => :METALCOAT,
		:kind => "Bronze Bell",
		:dexentry => "One caused a news sensation when it was dug up at a construction site after a 2,000-year sleep.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 13,
	},

	:OnCreation => {},
},

:BONSLY => {
	"Normal Form" => {
		:name => "Bonsly",
		:dexnum => 438,
		:Type1 => :ROCK,
		:BaseStats => [50, 80, 95, 10, 45, 10],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:STURDY, :ROCKHEAD],
		:HiddenAbilities => :RATTLED,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:CURSE,:DEFENSECURL,:ENDURE,:HARDEN,:HEADBUTT,:ROLLOUT,:SANDTOMB,:SELFDESTRUCT,:STEALTHROCK,],
		:Moveset => [
			[1,:FAKETEARS],
			[1,:COPYCAT],
			[5,:FLAIL],
			[8,:LOWKICK],
			[12,:ROCKTHROW],
			[15,:MIMIC],
			[19,:FEINTATTACK],
			[22,:TEARFULLOOK],
			[26,:ROCKTOMB],
			[29,:BLOCK],
			[33,:ROCKSLIDE],
			[36,:COUNTER],
			[40,:SUCKERPUNCH],
			[43,:DOUBLEEDGE]],
		:compatiblemoves => [:AFTERYOU,:BLOCK,:BRICKBREAK,:CALMMIND,:COVET,:DIG,:EARTHPOWER,:EXPLOSION,:FAKETEARS,:FOULPLAY,:HEADBUTT,:HELPINGHAND,:LOWKICK,:MIMIC,:NATUREPOWER,:PSYCHUP,:ROCKPOLISH,:ROCKSLIDE,:ROCKTOMB,:ROLEPLAY,:ROLLOUT,:SANDSTORM,:SANDTOMB,:SELFDESTRUCT,:SMACKDOWN,:STEALTHROCK,:STOMPINGTANTRUM,:SUCKERPUNCH,:SUNNYDAY,:THIEF,:UPROAR,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Undiscovered],
		:Height => 5,
		:Weight => 150,
		:kind => "Bonsai",
		:dexentry => "It looks as if it is always crying. It is actually adjusting its body's fluid levels by eliminating excess.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SUDOWOODO,:HasMove,:MIMIC]
		]
	},

	:OnCreation => {},
},

:MIMEJR => {
	"Normal Form" => {
		:name => "Mime Jr.",
		:dexnum => 439,
		:Type1 => :PSYCHIC,
		:Type2 => :FAIRY,
		:BaseStats => [20, 25, 45, 70, 90, 60],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SOUNDPROOF, :FILTER],
		:HiddenAbilities => :TECHNICIAN,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 62,
		:CatchRate => 145,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:CHARM,:CONFUSERAY,:FAKEOUT,:FUTURESIGHT,:HEALINGWISH,:HYPNOSIS,:ICYWIND,:MAGICROOM,:MIMIC,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:TEETERDANCE,:TRICK,:WAKEUPSLAP,],
		:Moveset => [
			[1,:TICKLE],
			[1,:BARRIER],
			[1,:POUND],
			[1,:CONFUSION],
			[4,:COPYCAT],
			[8,:MEDITATE],
			[11,:DOUBLESLAP],
			[15,:MIMIC],
			[18,:ENCORE],
			[22,:LIGHTSCREEN],
			[22,:REFLECT],
			[25,:PSYBEAM],
			[29,:SUBSTITUTE],
			[32,:RECYCLE],
			[36,:TRICK],
			[39,:PSYCHIC],
			[43,:ROLEPLAY],
			[46,:BATONPASS],
			[50,:SAFEGUARD]],
		:compatiblemoves => [:ALLYSWITCH,:BATONPASS,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CHARM,:COVET,:DRAINPUNCH,:DREAMEATER,:ENCORE,:FLASH,:FLING,:FOCUSPUNCH,:FUTURESIGHT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:ICYWIND,:INFESTATION,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MISTYTERRAIN,:MUDSLAP,:NASTYPLOT,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SOLARBEAM,:STOREDPOWER,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:UPROAR,:WONDERROOM,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 130,
		:kind => "Mime",
		:dexentry => "It habitually mimics foes. Once mimicked, the foe cannot take its eyes off this Pokémon.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
		:evolutions => [
			[:MRMIME,:HasMove,:MIMIC]
		]
	},

	:OnCreation => {},
},

:HAPPINY => {
	"Normal Form" => {
		:name => "Happiny",
		:dexnum => 440,
		:Type1 => :NORMAL,
		:BaseStats => [100, 5, 5, 15, 65, 30],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:NATURALCURE, :SERENEGRACE],
		:HiddenAbilities => :FRIENDGUARD,
		:GrowthRate => :Fast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 110,
		:CatchRate => 130,
		:Happiness => 140,
		:EggSteps => 10455,
		:EggMoves => [:AROMATHERAPY,:COUNTER,:ENDURE,:GRAVITY,:HEALBELL,:HELPINGHAND,:LASTRESORT,:METRONOME,:MUDBOMB,:NATURALGIFT,:PRESENT,],
		:Moveset => [
			[1,:POUND],
			[1,:CHARM],
			[5,:COPYCAT],
			[9,:REFRESH],
			[12,:SWEETKISS]],
		:compatiblemoves => [:CHARM,:COVET,:DEFENSECURL,:DRAINPUNCH,:DREAMEATER,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:GRASSKNOT,:GRAVITY,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERVOICE,:ICYWIND,:INCINERATE,:LASTRESORT,:LIGHTSCREEN,:METRONOME,:MUDSLAP,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RECYCLE,:ROLLOUT,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SOLARBEAM,:STOREDPOWER,:SUNNYDAY,:THUNDERWAVE,:UPROAR,:WATERPULSE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 244,
		:WildItemCommon => :OVALSTONE,
		:kind => "Playhouse",
		:dexentry => "It loves round white things. It carries an egg-shaped rock in imitation of Chansey.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:CHANSEY,:DayHoldItem,:OVALSTONE]
		]
	},

	:OnCreation => {},
},

:CHATOT => {
	"Normal Form" => {
		:name => "Chatot",
		:dexnum => 441,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [76, 65, 45, 92, 42, 91],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:KEENEYE, :TANGLEDFEET],
		:HiddenAbilities => :BIGPECKS,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 30,
		:Happiness => 35,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:AIRCUTTER,:BOOMBURST,:DEFOG,:ENCORE,:NASTYPLOT,:NIGHTSHADE,:SLEEPTALK,:STEELWING,:SUPERSONIC,],
		:Moveset => [
			[1,:HYPERVOICE],
			[1,:CHATTER],
			[1,:CONFIDE],
			[1,:TAUNT],
			[1,:PECK],
			[5,:GROWL],
			[9,:MIRRORMOVE],
			[13,:SING],
			[17,:FURYATTACK],
			[21,:CHATTER],
			[25,:TAUNT],
			[29,:ROUND],
			[33,:MIMIC],
			[37,:ECHOEDVOICE],
			[41,:ROOST],
			[45,:UPROAR],
			[49,:SYNCHRONOISE],
			[50,:FEATHERDANCE],
			[57,:HYPERVOICE]],
		:compatiblemoves => [:AERIALACE,:AIRSLASH,:BRAVEBIRD,:CHARM,:DEFOG,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:HEATWAVE,:HURRICANE,:HYPERVOICE,:MUDSLAP,:NASTYPLOT,:OMINOUSWIND,:PLUCK,:RAINDANCE,:ROLEPLAY,:ROOST,:SCREECH,:SKYATTACK,:STEELWING,:SUNNYDAY,:SWIFT,:TAILWIND,:TAUNT,:THIEF,:TORMENT,:TWISTER,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Black",
		:EggGroups => [:Flying],
		:Height => 5,
		:Weight => 19,
		:WildItemUncommon => :METRONOME,
		:kind => "Music Note",
		:dexentry => "It can learn and speak human words. If they gather, they all learn the same saying.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SPIRITOMB => {
	"Normal Form" => {
		:name => "Spiritomb",
		:dexnum => 442,
		:Type1 => :GHOST,
		:Type2 => :DARK,
		:BaseStats => [50, 92, 108, 92, 108, 35],
		:EVs => [0, 0, 1, 0, 1, 0],
		:Abilities => [:PRESSURE, :INFILTRATOR],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 100,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:CAPTIVATE,:DESTINYBOND,:DISABLE,:FOULPLAY,:GRUDGE,:IMPRISON,:NIGHTMARE,:PAINSPLIT,:SHADOWSNEAK,:SMOKESCREEN,],
		:Moveset => [
			[1,:CURSE],
			[1,:PURSUIT],
			[1,:CONFUSERAY],
			[1,:SPITE],
			[1,:SHADOWSNEAK],
			[7,:FEINTATTACK],
			[13,:HYPNOSIS],
			[19,:DREAMEATER],
			[25,:OMINOUSWIND],
			[31,:SUCKERPUNCH],
			[37,:NASTYPLOT],
			[43,:MEMENTO],
			[49,:DARKPULSE]],
		:compatiblemoves => [:ALLYSWITCH,:BURNINGJEALOUSY,:CALMMIND,:DARKPULSE,:DREAMEATER,:EMBARGO,:FLASH,:FOULPLAY,:GIGAIMPACT,:HEX,:HYPERBEAM,:ICYWIND,:IMPRISON,:INFESTATION,:LASHOUT,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:QUASH,:RAINDANCE,:RETALIATE,:ROCKTOMB,:SHADOWBALL,:SHOCKWAVE,:SILVERWIND,:SNARL,:SNATCH,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:TAUNT,:TELEKINESIS,:THIEF,:TORMENT,:TRICK,:UPROAR,:WATERPULSE,:WILLOWISP,:WONDERROOM,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Amorphous],
		:Height => 10,
		:Weight => 1080,
		:kind => "Forbidden",
		:dexentry => "A Pokémon that was formed by 108 spirits. It is bound to a fissure in an odd keystone.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GIBLE => {
	"Normal Form" => {
		:name => "Gible",
		:dexnum => 443,
		:Type1 => :DRAGON,
		:Type2 => :GROUND,
		:BaseStats => [58, 70, 45, 40, 45, 42],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SANDVEIL, :ROUGHSKIN],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:BODYSLAM,:DOUBLEEDGE,:DRAGONBREATH,:IRONHEAD,:IRONTAIL,:METALCLAW,:MUDSHOT,:OUTRAGE,:ROCKCLIMB,:SANDTOMB,:SCARYFACE,:THRASH,:TWISTER,],
		:Moveset => [
			[1,:TACKLE],
			[3,:SANDATTACK],
			[7,:DRAGONRAGE],
			[13,:SANDSTORM],
			[15,:TAKEDOWN],
			[19,:SANDTOMB],
			[25,:SLASH],
			[27,:DRAGONCLAW],
			[31,:DIG],
			[37,:DRAGONRUSH]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BULLDOZE,:CUT,:DIG,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FLAMETHROWER,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:INCINERATE,:IRONHEAD,:IRONTAIL,:MUDSHOT,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCALESHOT,:SCORCHINGSANDS,:SHADOWCLAW,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TWISTER,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Monster, :Dragon],
		:Height => 7,
		:Weight => 205,
		:kind => "Land Shark",
		:dexentry => "It nests in small, horizontal holes in cave walls. It pounces to catch prey that strays too close.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GABITE,:Level,24]
		]
	},

	:OnCreation => {},
},

:GABITE => {
	"Normal Form" => {
		:name => "Gabite",
		:dexnum => 444,
		:Type1 => :DRAGON,
		:Type2 => :GROUND,
		:BaseStats => [68, 90, 65, 50, 55, 82],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SANDVEIL, :ROUGHSKIN],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 144,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 10455,
		:preevo => {
			:species => :GIBLE,
			:form => 0
		},
		:Moveset => [
			[0,:DUALCHOP],
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:DRAGONRAGE],
			[3,:SANDATTACK],
			[7,:DRAGONRAGE],
			[13,:SANDSTORM],
			[15,:TAKEDOWN],
			[19,:SANDTOMB],
			[28,:SLASH],
			[33,:DRAGONCLAW],
			[40,:DIG],
			[49,:DRAGONRUSH]],
		:compatiblemoves => [:AERIALACE,:BODYSLAM,:BULLDOZE,:CUT,:DIG,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DUALCHOP,:EARTHPOWER,:EARTHQUAKE,:FIREBLAST,:FLAMETHROWER,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:MUDSHOT,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCALESHOT,:SCARYFACE,:SCORCHINGSANDS,:SHADOWCLAW,:STEALTHROCK,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TWISTER,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Monster, :Dragon],
		:Height => 14,
		:Weight => 560,
		:kind => "Cave",
		:dexentry => "There is a long-held belief that medicine made from its scales will heal even incurable illnesses.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
		:evolutions => [
			[:GARCHOMP,:Level,48]
		]
	},

	:OnCreation => {},
},

:GARCHOMP => {
	"Normal Form" => {
		:name => "Garchomp",
		:dexnum => 445,
		:Type1 => :DRAGON,
		:Type2 => :GROUND,
		:BaseStats => [108, 130, 95, 80, 85, 102],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:SANDVEIL, :ROUGHSKIN],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 10455,
		:preevo => {
			:species => :GABITE,
			:form => 0
		},
		:Moveset => [
			[0,:CRUNCH],
			[1,:DUALCHOP],
			[1,:FIREFANG],
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:DRAGONRAGE],
			[1,:SANDSTORM],
			[3,:SANDATTACK],
			[7,:DRAGONRAGE],
			[13,:SANDSTORM],
			[15,:TAKEDOWN],
			[19,:SANDTOMB],
			[28,:SLASH],
			[33,:DRAGONCLAW],
			[40,:DIG],
			[55,:DRAGONRUSH]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:CRUNCH,:CUT,:DIG,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:DUALCHOP,:EARTHPOWER,:EARTHQUAKE,:FALSESWIPE,:FIREBLAST,:FIREFANG,:FLAMETHROWER,:FLING,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:INCINERATE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:MUDSHOT,:MUDSLAP,:OUTRAGE,:POISONJAB,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCALESHOT,:SCARYFACE,:SCORCHINGSANDS,:SHADOWCLAW,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:SWORDSDANCE,:TWISTER,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Monster, :Dragon],
		:Height => 19,
		:Weight => 950,
		:kind => "Mach",
		:dexentry => "When it folds up its body and extends its wings, it looks like a jet plane. It flies at sonic speed.",
		:BattlerPlayerY => 11,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [108, 170, 92, 120, 95, 115],
		:Abilities => [:SANDFORCE],
		:Weight => 950,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GARCHOMPITE => 1,
	},
},

:MUNCHLAX => {
	"Normal Form" => {
		:name => "Munchlax",
		:dexnum => 446,
		:Type1 => :NORMAL,
		:BaseStats => [135, 85, 40, 40, 85, 5],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:PICKUP, :THICKFAT],
		:HiddenAbilities => :GLUTTONY,
		:GrowthRate => :Slow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 78,
		:CatchRate => 50,
		:Happiness => 70,
		:EggSteps => 10455,
		:EggMoves => [:AFTERYOU,:BELCH,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:FISSURE,:LICK,:NATURALGIFT,:POWERUPPUNCH,:PURSUIT,:SELFDESTRUCT,:WHIRLWIND,:ZENHEADBUTT,],
		:Moveset => [
			[1,:LASTRESORT],
			[1,:RECYCLE],
			[1,:LICK],
			[1,:METRONOME],
			[1,:ODORSLEUTH],
			[1,:TACKLE],
			[4,:DEFENSECURL],
			[9,:AMNESIA],
			[12,:LICK],
			[17,:CHIPAWAY],
			[20,:SCREECH],
			[25,:BODYSLAM],
			[28,:STOCKPILE],
			[33,:SWALLOW],
			[36,:ROLLOUT],
			[41,:FLING],
			[44,:BELLYDRUM],
			[49,:NATURALGIFT],
			[50,:SNATCH],
			[57,:LASTRESORT]],
		:compatiblemoves => [:AFTERYOU,:AMNESIA,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARM,:COVET,:EARTHQUAKE,:ENCORE,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GUNKSHOT,:HEADBUTT,:HYDROPUMP,:HYPERVOICE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:LASTRESORT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MUDSLAP,:PAYDAY,:POWERUPPUNCH,:PSYCHIC,:RAINDANCE,:RECYCLE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEEDBOMB,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SNATCH,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:UPROAR,:WATERPULSE,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Black",
		:EggGroups => [:Undiscovered],
		:Height => 6,
		:Weight => 1050,
		:WildItemCommon => :LEFTOVERS,
		:WildItemUncommon => :LEFTOVERS,
		:WildItemRare => :LEFTOVERS,
		:kind => "Big Eater",
		:dexentry => "It wolfs down its weight in food once a day, swallowing food whole with almost no chewing.",
		:BattlerPlayerY => 25,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SNORLAX,:Happiness,0]
		]
	},

	:OnCreation => {},
},

:RIOLU => {
	"Normal Form" => {
		:name => "Riolu",
		:dexnum => 447,
		:Type1 => :FIGHTING,
		:BaseStats => [40, 70, 40, 35, 40, 60],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:STEADFAST, :INNERFOCUS],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 57,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:AGILITY,:BITE,:BLAZEKICK,:BULLETPUNCH,:CIRCLETHROW,:CROSSCHOP,:CRUNCH,:DETECT,:FOLLOWME,:HIJUMPKICK,:IRONDEFENSE,:LOWKICK,:METEORMASH,:MINDREADER,:SKYUPPERCUT,:VACUUMWAVE,],
		:Moveset => [
			[1,:FORESIGHT],
			[1,:QUICKATTACK],
			[1,:ENDURE],
			[6,:COUNTER],
			[11,:FEINT],
			[15,:FORCEPALM],
			[19,:COPYCAT],
			[24,:SCREECH],
			[29,:REVERSAL],
			[47,:NASTYPLOT],
			[50,:FINALGAMBIT]],
		:compatiblemoves => [:AGILITY,:BLAZEKICK,:BRICKBREAK,:BULKUP,:BULLDOZE,:COACHING,:CRUNCH,:DIG,:DRAINPUNCH,:DUALCHOP,:EARTHQUAKE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:IRONDEFENSE,:IRONTAIL,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCREECH,:SHADOWCLAW,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:THUNDERPUNCH,:VACUUMWAVE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Undiscovered],
		:Height => 7,
		:Weight => 202,
		:kind => "Emanation",
		:dexentry => "The aura that emanates from its body intensifies to alert others if it is afraid or sad.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LUCARIO,:HappinessDay,0]
		]
	},

	:OnCreation => {},
},

:LUCARIO => {
	"Normal Form" => {
		:name => "Lucario",
		:dexnum => 448,
		:Type1 => :FIGHTING,
		:Type2 => :STEEL,
		:BaseStats => [70, 110, 70, 115, 70, 90],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:STEADFAST, :INNERFOCUS],
		:HiddenAbilities => :JUSTIFIED,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :RIOLU,
			:form => 0
		},
		:Moveset => [
			[0,:AURASPHERE],
			[1,:LASERFOCUS],
			[1,:FORESIGHT],
			[1,:QUICKATTACK],
			[1,:DETECT],
			[1,:METALCLAW],
			[6,:COUNTER],
			[11,:FEINT],
			[15,:POWERUPPUNCH],
			[19,:SWORDSDANCE],
			[24,:METALSOUND],
			[29,:BONERUSH],
			[33,:QUICKGUARD],
			[37,:MEFIRST],
			[42,:WORKUP],
			[47,:CALMMIND],
			[51,:HEALPULSE],
			[55,:CLOSECOMBAT],
			[60,:DRAGONPULSE],
			[65,:EXTREMESPEED]],
		:compatiblemoves => [:AGILITY,:AURASPHERE,:BLAZEKICK,:BRICKBREAK,:BULKUP,:BULLDOZE,:CALMMIND,:CLOSECOMBAT,:COACHING,:CRUNCH,:DARKPULSE,:DIG,:DRAGONPULSE,:DRAINPUNCH,:DUALCHOP,:EARTHQUAKE,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:ICEPUNCH,:IRONDEFENSE,:IRONTAIL,:LASERFOCUS,:LOWKICK,:LOWSWEEP,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:PSYCHIC,:RAINDANCE,:RETALIATE,:REVENGE,:REVERSAL,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCARYFACE,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TERRAINPULSE,:THUNDERPUNCH,:VACUUMWAVE,:WATERPULSE,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field, :HumanLike],
		:Height => 12,
		:Weight => 540,
		:kind => "Aura",
		:dexentry => "It has the ability to sense the auras of all things. It understands human speech.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [70, 145, 88, 140, 70, 112],
		:Abilities => [:ADAPTABILITY],
		:Weight => 575,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:LUCARIONITE => 1,
	},
},

:HIPPOPOTAS => {
	"Normal Form" => {
		:name => "Hippopotas",
		:dexnum => 449,
		:Type1 => :GROUND,
		:BaseStats => [68, 72, 78, 38, 42, 32],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:SANDSTREAM, :SANDFORCE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 140,
		:Happiness => 70,
		:EggSteps => 7905,
		:EggMoves => [:BODYSLAM,:CURSE,:REVENGE,:SANDTOMB,:SLACKOFF,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WHIRLWIND,],
		:Moveset => [
			[1,:TACKLE],
			[1,:SANDATTACK],
			[7,:BITE],
			[13,:YAWN],
			[19,:TAKEDOWN],
			[19,:DIG],
			[25,:SANDTOMB],
			[31,:CRUNCH],
			[37,:EARTHQUAKE],
			[44,:DOUBLEEDGE],
			[50,:FISSURE]],
		:compatiblemoves => [:AMNESIA,:BODYSLAM,:BULLDOZE,:CRUNCH,:DIG,:EARTHPOWER,:EARTHQUAKE,:HEADBUTT,:HIGHHORSEPOWER,:IRONTAIL,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:REVENGE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:STEALTHROCK,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 495,
		:kind => "Hippo",
		:dexentry => "It lives in arid places. Instead of perspiration, it expels grainy sand from its body.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HIPPOWDON,:Level,34]
		]
	},

	:OnCreation => {},
},

:HIPPOWDON => {
	"Normal Form" => {
		:name => "Hippowdon",
		:dexnum => 450,
		:Type1 => :GROUND,
		:BaseStats => [108, 112, 118, 68, 72, 47],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:SANDSTREAM, :SANDFORCE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 184,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 7905,
		:preevo => {
			:species => :HIPPOPOTAS,
			:form => 0
		},
		:Moveset => [
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:TACKLE],
			[1,:SANDATTACK],
			[1,:BITE],
			[1,:YAWN],
			[7,:BITE],
			[13,:YAWN],
			[19,:TAKEDOWN],
			[19,:DIG],
			[25,:SANDTOMB],
			[31,:CRUNCH],
			[40,:EARTHQUAKE],
			[50,:DOUBLEEDGE],
			[60,:FISSURE]],
		:compatiblemoves => [:AMNESIA,:BODYPRESS,:BODYSLAM,:BULLDOZE,:CRUNCH,:DIG,:EARTHPOWER,:EARTHQUAKE,:FIREFANG,:GIGAIMPACT,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:ICEFANG,:IRONHEAD,:IRONTAIL,:MUDDYWATER,:MUDSHOT,:MUDSLAP,:REVENGE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCORCHINGSANDS,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:THUNDERFANG,:WATERPULSE,:WEATHERBALL,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 20,
		:Weight => 3000,
		:kind => "Heavyweight",
		:dexentry => "It blasts internally stored sand from ports on its body to create a towering twister for attack.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SKORUPI => {
	"Normal Form" => {
		:name => "Skorupi",
		:dexnum => 451,
		:Type1 => :POISON,
		:Type2 => :BUG,
		:BaseStats => [40, 50, 90, 30, 55, 65],
		:EVs => [0, 0, 1, 0, 0, 0],
		:Abilities => [:BATTLEARMOR, :SNIPER],
		:HiddenAbilities => :KEENEYE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:CONFUSERAY,:FEINTATTACK,:IRONTAIL,:NIGHTSLASH,:POISONTAIL,:PURSUIT,:SANDATTACK,:SCREECH,:SLASH,:TWINEEDLE,:WHIRLWIND,],
		:Moveset => [
			[1,:BITE],
			[1,:POISONSTING],
			[1,:LEER],
			[5,:KNOCKOFF],
			[9,:PINMISSILE],
			[13,:ACUPRESSURE],
			[16,:PURSUIT],
			[20,:BUGBITE],
			[23,:POISONFANG],
			[27,:VENOSHOCK],
			[30,:HONECLAWS],
			[34,:TOXICSPIKES],
			[38,:NIGHTSLASH],
			[41,:SCARYFACE],
			[45,:CRUNCH],
			[47,:FELLSTINGER],
			[49,:CROSSPOISON]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AQUATAIL,:ASSURANCE,:BRICKBREAK,:BUGBITE,:BUGBUZZ,:CROSSPOISON,:CRUNCH,:CUT,:DARKPULSE,:DIG,:FALSESWIPE,:FLASH,:FLING,:FURYCUTTER,:HEADBUTT,:HONECLAWS,:INFESTATION,:IRONTAIL,:KNOCKOFF,:MUDSLAP,:PAYBACK,:PINMISSILE,:POISONJAB,:RAINDANCE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SCREECH,:SHADOWBALL,:SKITTERSMACK,:SLUDGEBOMB,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SWORDSDANCE,:TAUNT,:THIEF,:TORMENT,:TOXICSPIKES,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Bug, :Water3],
		:Height => 8,
		:Weight => 120,
		:WildItemUncommon => :POISONBARB,
		:kind => "Scorpion",
		:dexentry => "It grips prey with its tail claws and injects poison. It tenaciously hangs on until the poison takes.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 19,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DRAPION,:Level,40]
		]
	},

	:OnCreation => {},
},

:DRAPION => {
	"Normal Form" => {
		:name => "Drapion",
		:dexnum => 452,
		:Type1 => :POISON,
		:Type2 => :DARK,
		:BaseStats => [70, 90, 110, 60, 75, 95],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:BATTLEARMOR, :SNIPER],
		:HiddenAbilities => :KEENEYE,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 175,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SKORUPI,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERFANG],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:BITE],
			[1,:POISONSTING],
			[1,:LEER],
			[1,:KNOCKOFF],
			[5,:KNOCKOFF],
			[9,:PINMISSILE],
			[13,:ACUPRESSURE],
			[16,:PURSUIT],
			[20,:BUGBITE],
			[23,:POISONFANG],
			[27,:VENOSHOCK],
			[30,:HONECLAWS],
			[34,:TOXICSPIKES],
			[38,:NIGHTSLASH],
			[43,:SCARYFACE],
			[49,:CRUNCH],
			[53,:FELLSTINGER],
			[57,:CROSSPOISON]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AQUATAIL,:ASSURANCE,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BULLDOZE,:CROSSPOISON,:CRUNCH,:CUT,:DARKPULSE,:DIG,:EARTHQUAKE,:FALSESWIPE,:FIREFANG,:FLASH,:FLING,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEFANG,:INFESTATION,:IRONDEFENSE,:IRONTAIL,:KNOCKOFF,:LASHOUT,:LEECHLIFE,:MUDSLAP,:PAYBACK,:PINMISSILE,:POISONJAB,:RAINDANCE,:RETALIATE,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDTOMB,:SCARYFACE,:SCREECH,:SHADOWBALL,:SKITTERSMACK,:SLUDGEBOMB,:SNARL,:STOMPINGTANTRUM,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDERFANG,:TORMENT,:TOXICSPIKES,:VENOMDRENCH,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Bug, :Water3],
		:Height => 13,
		:Weight => 615,
		:WildItemUncommon => :POISONBARB,
		:kind => "Ogre Scorp",
		:dexentry => "It has the power in its clawed arms to make scrap of a car. The tips of its claws release poison.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:CROAGUNK => {
	"Normal Form" => {
		:name => "Croagunk",
		:dexnum => 453,
		:Type1 => :POISON,
		:Type2 => :FIGHTING,
		:BaseStats => [48, 61, 40, 61, 40, 50],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:ANTICIPATION, :DRYSKIN],
		:HiddenAbilities => :POISONTOUCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 60,
		:CatchRate => 140,
		:Happiness => 100,
		:EggSteps => 2805,
		:EggMoves => [:ACUPRESSURE,:BULLETPUNCH,:COUNTER,:CROSSCHOP,:DRAINPUNCH,:DYNAMICPUNCH,:FAKEOUT,:FEINT,:HEADBUTT,:MEFIRST,:MEDITATE,:QUICKGUARD,:SMELLINGSALTS,:VACUUMWAVE,:WAKEUPSLAP,],
		:Moveset => [
			[1,:ASTONISH],
			[3,:MUDSLAP],
			[8,:POISONSTING],
			[10,:TAUNT],
			[15,:PURSUIT],
			[17,:FEINTATTACK],
			[22,:REVENGE],
			[24,:SWAGGER],
			[29,:MUDBOMB],
			[31,:SUCKERPUNCH],
			[36,:VENOSHOCK],
			[38,:NASTYPLOT],
			[43,:POISONJAB],
			[45,:SLUDGEBOMB],
			[47,:BELCH],
			[50,:FLATTER]],
		:compatiblemoves => [:ASSURANCE,:BATONPASS,:BOUNCE,:BRICKBREAK,:BULKUP,:BULLDOZE,:COACHING,:DARKPULSE,:DIG,:DRAINPUNCH,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:EMBARGO,:ENCORE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:ICEPUNCH,:ICYWIND,:KNOCKOFF,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVENGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCREECH,:SHADOWBALL,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:TAUNT,:THIEF,:THUNDERPUNCH,:TORMENT,:VACUUMWAVE,:VENOMDRENCH,:VENOSHOCK,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:HumanLike],
		:Height => 7,
		:Weight => 230,
		:WildItemUncommon => :BLACKSLUDGE,
		:kind => "Toxic Mouth",
		:dexentry => "Its cheeks hold poison sacs. It tries to catch foes off guard to jab them with toxic fingers.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TOXICROAK,:Level,37]
		]
	},

	:OnCreation => {},
},

:TOXICROAK => {
	"Normal Form" => {
		:name => "Toxicroak",
		:dexnum => 454,
		:Type1 => :POISON,
		:Type2 => :FIGHTING,
		:BaseStats => [83, 106, 65, 86, 65, 85],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:ANTICIPATION, :DRYSKIN],
		:HiddenAbilities => :POISONTOUCH,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 172,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :CROAGUNK,
			:form => 0
		},
		:Moveset => [
			[1,:ASTONISH],
			[1,:MUDSLAP],
			[1,:POISONSTING],
			[3,:MUDSLAP],
			[8,:POISONSTING],
			[10,:TAUNT],
			[15,:PURSUIT],
			[17,:FEINTATTACK],
			[22,:REVENGE],
			[24,:SWAGGER],
			[29,:MUDBOMB],
			[31,:SUCKERPUNCH],
			[36,:VENOSHOCK],
			[41,:NASTYPLOT],
			[49,:POISONJAB],
			[54,:SLUDGEBOMB],
			[58,:BELCH],
			[62,:FLATTER]],
		:compatiblemoves => [:ASSURANCE,:BATONPASS,:BOUNCE,:BRICKBREAK,:BULKUP,:BULLDOZE,:COACHING,:CORROSIVEGAS,:CROSSPOISON,:CUT,:DARKPULSE,:DIG,:DRAINPUNCH,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:EMBARGO,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:GUNKSHOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:KNOCKOFF,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:NASTYPLOT,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:RAINDANCE,:RETALIATE,:REVENGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCREECH,:SHADOWBALL,:SLUDGEBOMB,:SLUDGEWAVE,:SNATCH,:SPITE,:STONEEDGE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SUPERFANG,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDERPUNCH,:TORMENT,:VACUUMWAVE,:VENOMDRENCH,:VENOSHOCK,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:shadowmoves => [:SHADOWRUSH,:SHADOWDOWN,],
		:Color => "Blue",
		:EggGroups => [:HumanLike],
		:Height => 13,
		:Weight => 444,
		:WildItemUncommon => :BLACKSLUDGE,
		:kind => "Toxic Mouth",
		:dexentry => "Its knuckle claws secrete a toxin so vile that even a scratch could prove fatal.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [83, 136, 70, 116, 70, 115],
		:Abilities => [:ADAPTABILITY],
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:TOXICROAKITE => 1
	},
},

:CARNIVINE => {
	"Normal Form" => {
		:name => "Carnivine",
		:dexnum => 455,
		:Type1 => :GRASS,
		:BaseStats => [74, 100, 72, 90, 72, 46],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 159,
		:CatchRate => 200,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:ACIDSPRAY,:GIGADRAIN,:GRASSWHISTLE,:LEECHSEED,:MAGICALLEAF,:RAGEPOWDER,:RAZORLEAF,:SLAM,:SLEEPPOWDER,:STUNSPORE,:SYNTHESIS,:WORRYSEED,],
		:Moveset => [
			[1,:BIND],
			[1,:GROWTH],
			[7,:BITE],
			[11,:VINEWHIP],
			[17,:SWEETSCENT],
			[21,:INGRAIN],
			[27,:FEINTATTACK],
			[31,:LEAFTORNADO],
			[37,:STOCKPILE],
			[37,:SPITUP],
			[37,:SWALLOW],
			[41,:CRUNCH],
			[47,:WRINGOUT],
			[50,:POWERWHIP]],
		:compatiblemoves => [:ASSURANCE,:BIND,:BUGBITE,:BULLETSEED,:CUT,:DARKESTLARIAT,:DEFOG,:ENERGYBALL,:FLASH,:FLING,:FURYCUTTER,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYTERRAIN,:HYPERBEAM,:INFESTATION,:KNOCKOFF,:LASHOUT,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:PAYBACK,:POWERWHIP,:SEEDBOMB,:SKITTERSMACK,:SLUDGEBOMB,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:THIEF,:THROATCHOP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Grass],
		:Height => 14,
		:Weight => 270,
		:kind => "Bug Catcher",
		:dexentry => "It attracts prey with its sweet-smelling saliva, then chomps down. It takes a whole day to eat prey.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:FINNEON => {
	"Normal Form" => {
		:name => "Finneon",
		:dexnum => 456,
		:Type1 => :WATER,
		:BaseStats => [49, 49, 56, 49, 61, 66],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:SWIFTSWIM, :STORMDRAIN],
		:HiddenAbilities => :WATERVEIL,
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 66,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AGILITY,:AQUATAIL,:AURORABEAM,:BRINE,:CHARM,:CONFUSERAY,:FLAIL,:PSYBEAM,:SIGNALBEAM,:SPLASH,:SWEETKISS,:TICKLE,],
		:Moveset => [
			[1,:POUND],
			[6,:WATERGUN],
			[10,:ATTRACT],
			[13,:RAINDANCE],
			[17,:GUST],
			[22,:WATERPULSE],
			[26,:CAPTIVATE],
			[29,:SAFEGUARD],
			[33,:AQUARING],
			[38,:WHIRLPOOL],
			[42,:UTURN],
			[45,:BOUNCE],
			[49,:SILVERWIND],
			[54,:SOAK]],
		:compatiblemoves => [:AGILITY,:AIRCUTTER,:AIRSLASH,:AQUATAIL,:BLIZZARD,:BOUNCE,:BRINE,:CHARM,:DEFOG,:DIVE,:FAKETEARS,:FLASH,:FLIPTURN,:HAIL,:ICEBEAM,:ICYWIND,:MUDDYWATER,:NATUREPOWER,:OMINOUSWIND,:PAYBACK,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SCALD,:SIGNALBEAM,:SKITTERSMACK,:SURF,:SWIFT,:TAILWIND,:TWISTER,:UTURN,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Water2],
		:Height => 4,
		:Weight => 70,
		:kind => "Wing Fish",
		:dexentry => "After long exposure to sunlight, the patterns on its tail fins shine vividly when darkness arrives.",
		:BattlerPlayerY => 35,
		:BattlerEnemyY => 26,
		:BattlerAltitude => 18,
		:evolutions => [
			[:LUMINEON,:Level,31]
		]
	},

	:OnCreation => {},
},

:LUMINEON => {
	"Normal Form" => {
		:name => "Lumineon",
		:dexnum => 457,
		:Type1 => :WATER,
		:BaseStats => [69, 69, 76, 69, 86, 91],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SWIFTSWIM, :STORMDRAIN],
		:HiddenAbilities => :WATERVEIL,
		:GrowthRate => :Erratic,
		:GenderRatio => :FemHalf,
		:BaseEXP => 161,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :FINNEON,
			:form => 0
		},
		:Moveset => [
			[1,:SOAK],
			[1,:GUST],
			[1,:POUND],
			[1,:WATERGUN],
			[1,:ATTRACT],
			[6,:WATERGUN],
			[10,:ATTRACT],
			[13,:RAINDANCE],
			[17,:GUST],
			[22,:WATERPULSE],
			[26,:CAPTIVATE],
			[29,:SAFEGUARD],
			[35,:AQUARING],
			[42,:WHIRLPOOL],
			[48,:UTURN],
			[53,:BOUNCE],
			[59,:SILVERWIND],
			[66,:SOAK]],
		:compatiblemoves => [:AGILITY,:AIRCUTTER,:AIRSLASH,:AQUATAIL,:BLIZZARD,:BOUNCE,:BRINE,:CHARM,:DEFOG,:DIVE,:FAKETEARS,:FLASH,:FLIPTURN,:GIGAIMPACT,:HAIL,:HURRICANE,:HYPERBEAM,:ICEBEAM,:ICYWIND,:MUDDYWATER,:OMINOUSWIND,:PAYBACK,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SCALD,:SIGNALBEAM,:SKITTERSMACK,:SURF,:SWIFT,:TAILWIND,:TWISTER,:UTURN,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Water2],
		:Height => 12,
		:Weight => 240,
		:kind => "Neon",
		:dexentry => "It lives on the deep-sea floor. It attracts prey by flashing the patterns on its four tail fins.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 13,
		:BattlerAltitude => 12,
	},

	:OnCreation => {},
},

:MANTYKE => {
	"Normal Form" => {
		:name => "Mantyke",
		:dexnum => 458,
		:Type1 => :WATER,
		:Type2 => :FLYING,
		:BaseStats => [45, 20, 50, 60, 120, 50],
		:EVs => [0, 0, 0, 0, 1, 0],
		:Abilities => [:SWIFTSWIM, :WATERABSORB],
		:HiddenAbilities => :WATERVEIL,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 69,
		:CatchRate => 25,
		:Happiness => 70,
		:EggSteps => 6630,
		:EggMoves => [:AMNESIA,:HAZE,:HYDROPUMP,:MIRRORCOAT,:MUDSPORT,:SIGNALBEAM,:SLAM,:SPLASH,:TAILWIND,:TWISTER,:WATERSPORT,:WIDEGUARD,],
		:Moveset => [
			[1,:TACKLE],
			[1,:BUBBLE],
			[3,:SUPERSONIC],
			[7,:BUBBLEBEAM],
			[11,:CONFUSERAY],
			[14,:WINGATTACK],
			[16,:HEADBUTT],
			[19,:WATERPULSE],
			[23,:WIDEGUARD],
			[27,:TAKEDOWN],
			[32,:AGILITY],
			[36,:AIRSLASH],
			[39,:AQUARING],
			[46,:BOUNCE],
			[49,:HYDROPUMP]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AGILITY,:AIRCUTTER,:AIRSLASH,:AMNESIA,:BLIZZARD,:BOUNCE,:BULLDOZE,:DIVE,:EARTHQUAKE,:HAIL,:HEADBUTT,:HELPINGHAND,:HYDROPUMP,:ICEBEAM,:ICYWIND,:MUDSLAP,:RAINDANCE,:ROCKSLIDE,:SCALD,:SIGNALBEAM,:SURF,:SWIFT,:TAILWIND,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Undiscovered],
		:Height => 10,
		:Weight => 650,
		:kind => "Kite",
		:dexentry => "A friendly Pokémon that captures the subtle flows of seawater using its two antennae.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 18,
		:evolutions => [
			[:MANTINE,:HasInParty,:REMORAID]
		]
	},

	:OnCreation => {},
},

:SNOVER => {
	"Normal Form" => {
		:name => "Snover",
		:dexnum => 459,
		:Type1 => :GRASS,
		:Type2 => :ICE,
		:BaseStats => [60, 62, 50, 62, 60, 40],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:SNOWWARNING, :SOUNDPROOF],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 67,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 5355,
		:EggMoves => [:AVALANCHE,:BULLETSEED,:DOUBLEEDGE,:GROWTH,:LEECHSEED,:MAGICALLEAF,:MIST,:NATURALGIFT,:SEEDBOMB,:SKULLBASH,:STOMP,],
		:Moveset => [
			[1,:POWDERSNOW],
			[1,:LEER],
			[5,:RAZORLEAF],
			[9,:ICYWIND],
			[13,:GRASSWHISTLE],
			[17,:SWAGGER],
			[21,:MIST],
			[26,:ICESHARD],
			[31,:INGRAIN],
			[36,:WOODHAMMER],
			[41,:BLIZZARD],
			[46,:SHEERCOLD]],
		:compatiblemoves => [:AVALANCHE,:BLIZZARD,:BULLETSEED,:ENERGYBALL,:FLASH,:FROSTBREATH,:GIGADRAIN,:GRASSKNOT,:GRASSYGLIDE,:HAIL,:HEADBUTT,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:LIGHTSCREEN,:MAGICALLEAF,:MEGAPUNCH,:MUDSLAP,:RAINDANCE,:ROLEPLAY,:SAFEGUARD,:SEEDBOMB,:SHADOWBALL,:SOLARBEAM,:SWORDSDANCE,:SYNTHESIS,:WATERPULSE,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Monster, :Grass],
		:Height => 10,
		:Weight => 505,
		:WildItemUncommon => :NEVERMELTICE,
		:kind => "Frost Tree",
		:dexentry => "It lives on snowy mountains. Having had little contact with humans, it is boldly inquisitive.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
		:evolutions => [
			[:ABOMASNOW,:Level,40]
		]
	},

	:OnCreation => {},
},

:ABOMASNOW => {
	"Normal Form" => {
		:name => "Abomasnow",
		:dexnum => 460,
		:Type1 => :GRASS,
		:Type2 => :ICE,
		:BaseStats => [90, 92, 75, 92, 85, 60],
		:EVs => [0, 1, 0, 1, 0, 0],
		:Abilities => [:SNOWWARNING, :SOUNDPROOF],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 173,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SNOVER,
			:form => 0
		},
		:Moveset => [
			[1,:ICEPUNCH],
			[1,:POWDERSNOW],
			[1,:LEER],
			[1,:RAZORLEAF],
			[1,:ICYWIND],
			[5,:RAZORLEAF],
			[9,:ICYWIND],
			[13,:GRASSWHISTLE],
			[17,:SWAGGER],
			[21,:MIST],
			[26,:ICESHARD],
			[31,:INGRAIN],
			[36,:WOODHAMMER],
			[47,:BLIZZARD],
			[58,:SHEERCOLD]],
		:compatiblemoves => [:AVALANCHE,:BLIZZARD,:BLOCK,:BRICKBREAK,:BULLDOZE,:BULLETSEED,:EARTHPOWER,:EARTHQUAKE,:ENERGYBALL,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FROSTBREATH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:HAIL,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:LEAFSTORM,:LIGHTSCREEN,:MAGICALLEAF,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:OUTRAGE,:RAINDANCE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SAFEGUARD,:SEEDBOMB,:SHADOWBALL,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:STRENGTH,:SWORDSDANCE,:SYNTHESIS,:WATERPULSE,:WEATHERBALL,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Monster, :Grass],
		:Height => 22,
		:Weight => 1355,
		:WildItemUncommon => :NEVERMELTICE,
		:kind => "Frost Tree",
		:dexentry => "It whips up blizzards in mountains that are always buried in snow. It is the abominable snowman.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 10,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [90, 132, 105, 132, 105, 30],
		:Abilities => [:SNOWWARNING],
		:Weight => 1850,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:ABOMASITE => 1,
	},
},

:WEAVILE => {
	"Normal Form" => {
		:name => "Weavile",
		:dexnum => 461,
		:Type1 => :DARK,
		:Type2 => :ICE,
		:BaseStats => [70, 120, 65, 45, 85, 125],
		:EVs => [0, 1, 0, 0, 0, 1],
		:Abilities => [:PRESSURE, :PRESSURE],
		:HiddenAbilities => :PICKPOCKET,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 179,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :SNEASEL,
			:form => 0
		},
		:Moveset => [
			[1,:EMBARGO],
			[1,:REVENGE],
			[1,:ASSURANCE],
			[1,:SCRATCH],
			[1,:LEER],
			[1,:TAUNT],
			[1,:QUICKATTACK],
			[8,:QUICKATTACK],
			[10,:FEINTATTACK],
			[14,:ICYWIND],
			[16,:FURYSWIPES],
			[20,:NASTYPLOT],
			[22,:METALCLAW],
			[25,:HONECLAWS],
			[28,:FLING],
			[32,:SCREECH],
			[35,:NIGHTSLASH],
			[40,:SNATCH],
			[44,:PUNISHMENT],
			[47,:DARKPULSE]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ASSURANCE,:AVALANCHE,:BEATUP,:BLIZZARD,:BRICKBREAK,:CALMMIND,:COUNTER,:CURSE,:CUT,:DARKPULSE,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DREAMEATER,:DYNAMICPUNCH,:DYNAMICPUNCH,:EMBARGO,:FAKETEARS,:FALSESWIPE,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASHOUT,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAYBACK,:POISONJAB,:POWERUPPUNCH,:PSYCHOCUT,:PSYCHUP,:RAINDANCE,:REFLECT,:RETALIATE,:REVENGE,:ROCKSMASH,:SCREECH,:SHADOWBALL,:SHADOWCLAW,:SNARL,:SNATCH,:SPITE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:TRIPLEAXEL,:WHIRLPOOL,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Black",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 340,
		:WildItemUncommon => :QUICKCLAW,
		:kind => "Sharp Claw",
		:dexentry => "They live in cold regions, forming groups of four or five that hunt prey with impressive coordination.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MAGNEZONE => {
	"Normal Form" => {
		:name => "Magnezone",
		:dexnum => 462,
		:Type1 => :ELECTRIC,
		:Type2 => :STEEL,
		:BaseStats => [70, 70, 115, 130, 90, 60],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:MAGNETPULL, :STURDY],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 241,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :MAGNETON,
			:form => 0
		},
		:Moveset => [
			[1,:TRIATTACK],
			[1,:ZAPCANNON],
			[1,:MAGNETICFLUX],
			[1,:MIRRORCOAT],
			[1,:BARRIER],
			[1,:ELECTRICTERRAIN],
			[1,:TACKLE],
			[1,:SUPERSONIC],
			[1,:THUNDERSHOCK],
			[1,:MAGNETBOMB],
			[5,:THUNDERSHOCK],
			[7,:MAGNETBOMB],
			[11,:THUNDERWAVE],
			[13,:LIGHTSCREEN],
			[17,:SONICBOOM],
			[19,:SPARK],
			[23,:MIRRORSHOT],
			[25,:METALSOUND],
			[29,:ELECTROBALL],
			[33,:FLASHCANNON],
			[39,:SCREECH],
			[43,:DISCHARGE],
			[49,:LOCKON],
			[53,:MAGNETRISE],
			[59,:GYROBALL],
			[63,:ZAPCANNON]],
		:compatiblemoves => [:ALLYSWITCH,:BIDE,:BODYPRESS,:CHARGEBEAM,:CURSE,:DOUBLEEDGE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:EXPLOSION,:FLASH,:FLASHCANNON,:GIGAIMPACT,:GRAVITY,:GYROBALL,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:IRONDEFENSE,:IRONHEAD,:LIGHTSCREEN,:MAGICCOAT,:MAGNETRISE,:MIMIC,:PSYCHUP,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:RISINGVOLTAGE,:ROLLOUT,:SCREECH,:SELFDESTRUCT,:SHOCKWAVE,:SIGNALBEAM,:STEELBEAM,:STEELROLLER,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEPORT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:VOLTSWITCH,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Gray",
		:EggGroups => [:Mineral],
		:Height => 12,
		:Weight => 1800,
		:WildItemUncommon => :METALCOAT,
		:kind => "Magnet Area",
		:dexentry => "It evolved from exposure to a special magnetic field. Three units generate magnetism.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:LICKILICKY => {
	"Normal Form" => {
		:name => "Lickilicky",
		:dexnum => 463,
		:Type1 => :NORMAL,
		:BaseStats => [110, 85, 95, 80, 95, 50],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:OWNTEMPO, :OBLIVIOUS],
		:HiddenAbilities => :CLOUDNINE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 180,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :LICKITUNG,
			:form => 0
		},
		:Moveset => [
			[1,:WRINGOUT],
			[1,:POWERWHIP],
			[1,:LICK],
			[5,:SUPERSONIC],
			[9,:DEFENSECURL],
			[13,:KNOCKOFF],
			[17,:WRAP],
			[21,:STOMP],
			[25,:DISABLE],
			[29,:SLAM],
			[33,:ROLLOUT],
			[37,:CHIPAWAY],
			[41,:MEFIRST],
			[45,:REFRESH],
			[49,:SCREECH],
			[53,:POWERWHIP],
			[57,:WRINGOUT],
			[61,:GYROBALL]],
		:compatiblemoves => [:AMNESIA,:AQUATAIL,:BIDE,:BIND,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CURSE,:CUT,:DEFENSECURL,:DIG,:DOUBLEEDGE,:DRAGONTAIL,:DREAMEATER,:DYNAMICPUNCH,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GYROBALL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:ICEBALL,:ICEBEAM,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONTAIL,:KNOCKOFF,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MUDDYWATER,:MUDSLAP,:NIGHTMARE,:POWERUPPUNCH,:POWERWHIP,:PSYCHUP,:RAGE,:RAINDANCE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SEISMICTOSS,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SKULLBASH,:SOLARBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SURF,:SWORDSDANCE,:TAKEDOWN,:TERRAINPULSE,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:WATERGUN,:WATERPULSE,:WHIRLPOOL,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Monster],
		:Height => 17,
		:Weight => 1400,
		:WildItemUncommon => :LAGGINGTAIL,
		:kind => "Licking",
		:dexentry => "It wraps things with its extensible tongue. Getting too close to it will leave you soaked with drool.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 9,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:RHYPERIOR => {
	"Normal Form" => {
		:name => "Rhyperior",
		:dexnum => 464,
		:Type1 => :GROUND,
		:Type2 => :ROCK,
		:BaseStats => [115, 140, 130, 55, 55, 40],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:LIGHTNINGROD, :SOLIDROCK],
		:HiddenAbilities => :RECKLESS,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 241,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :RHYDON,
			:form => 0
		},
		:Moveset => [
			[1,:HAMMERARM],
			[1,:ROCKWRECKER],
			[1,:HORNDRILL],
			[1,:POISONJAB],
			[1,:HORNATTACK],
			[1,:TAILWHIP],
			[1,:FURYATTACK],
			[1,:SCARYFACE],
			[5,:FURYATTACK],
			[9,:SCARYFACE],
			[13,:SMACKDOWN],
			[17,:STOMP],
			[21,:BULLDOZE],
			[25,:CHIPAWAY],
			[29,:ROCKBLAST],
			[33,:DRILLRUN],
			[37,:TAKEDOWN],
			[41,:STONEEDGE],
			[48,:EARTHQUAKE],
			[55,:MEGAHORN],
			[62,:HORNDRILL],
			[69,:ROCKWRECKER]],
		:compatiblemoves => [:ANCIENTPOWER,:AQUATAIL,:AVALANCHE,:BIDE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRUTALSWING,:BUBBLEBEAM,:BULLDOZE,:COUNTER,:CRUNCH,:CURSE,:CUT,:DIG,:DOUBLEEDGE,:DRAGONPULSE,:DRAGONTAIL,:DRILLRUN,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FIREBLAST,:FIREFANG,:FIREPUNCH,:FISSURE,:FLAMETHROWER,:FLASHCANNON,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEAVYSLAM,:HELPINGHAND,:HIGHHORSEPOWER,:HORNDRILL,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICYWIND,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MEGAHORN,:MEGAKICK,:MEGAPUNCH,:METEORBEAM,:MIMIC,:MUDSHOT,:MUDSLAP,:OUTRAGE,:PAYBACK,:PAYDAY,:POISONJAB,:POWERUPPUNCH,:RAGE,:RAINDANCE,:REVERSAL,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCARYFACE,:SCORCHINGSANDS,:SEISMICTOSS,:SHADOWCLAW,:SHOCKWAVE,:SKULLBASH,:SMACKDOWN,:SMARTSTRIKE,:SPITE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUBMISSION,:SUNNYDAY,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAKEDOWN,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERPUNCH,:UPROAR,:WATERGUN,:WHIRLPOOL,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Monster, :Field],
		:Height => 24,
		:Weight => 2828,
		:kind => "Drill",
		:dexentry => "It puts rocks in holes in its palms and uses its muscles to shoot them. Geodude are shot at rare times.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TANGROWTH => {
	"Normal Form" => {
		:name => "Tangrowth",
		:dexnum => 465,
		:Type1 => :GRASS,
		:BaseStats => [100, 100, 125, 110, 50, 50],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:CHLOROPHYLL, :LEAFGUARD],
		:HiddenAbilities => :REGENERATOR,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 187,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :TANGELA,
			:form => 0
		},
		:Moveset => [
			[1,:BLOCK],
			[1,:INGRAIN],
			[1,:CONSTRICT],
			[4,:SLEEPPOWDER],
			[7,:VINEWHIP],
			[10,:ABSORB],
			[14,:POISONPOWDER],
			[17,:BIND],
			[20,:GROWTH],
			[23,:MEGADRAIN],
			[27,:KNOCKOFF],
			[30,:STUNSPORE],
			[33,:NATURALGIFT],
			[36,:GIGADRAIN],
			[40,:ANCIENTPOWER],
			[43,:SLAM],
			[46,:TICKLE],
			[49,:WRINGOUT],
			[50,:GRASSYTERRAIN],
			[53,:POWERWHIP],
			[56,:BLOCK]],
		:compatiblemoves => [:AERIALACE,:AMNESIA,:ANCIENTPOWER,:BIDE,:BIND,:BLOCK,:BODYSLAM,:BRICKBREAK,:BRUTALSWING,:BULLDOZE,:BULLETSEED,:CURSE,:CUT,:DOUBLEEDGE,:EARTHQUAKE,:ENDEAVOR,:ENERGYBALL,:FLASH,:FLING,:FOCUSBLAST,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:GRASSYTERRAIN,:HEADBUTT,:HYPERBEAM,:INFESTATION,:KNOCKOFF,:LEAFSTORM,:MEGADRAIN,:MIMIC,:MUDSLAP,:NATUREPOWER,:PAINSPLIT,:PAYBACK,:POISONJAB,:POWERSWAP,:POWERWHIP,:PSYCHUP,:RAGE,:REFLECT,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SEEDBOMB,:SHOCKWAVE,:SKULLBASH,:SLUDGEBOMB,:SOLARBEAM,:SOLARBLADE,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SWEETSCENT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:THIEF,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Grass],
		:Height => 20,
		:Weight => 1286,
		:kind => "Vine",
		:dexentry => "It ensnares prey by extending arms made of vines. Losing arms to predators does not trouble it.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:ELECTIVIRE => {
	"Normal Form" => {
		:name => "Electivire",
		:dexnum => 466,
		:Type1 => :ELECTRIC,
		:BaseStats => [75, 123, 67, 95, 85, 95],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:MOTORDRIVE, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 243,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :ELECTABUZZ,
			:form => 0
		},
		:Moveset => [
			[1,:ELECTRICTERRAIN],
			[1,:IONDELUGE],
			[1,:FIREPUNCH],
			[1,:QUICKATTACK],
			[1,:LEER],
			[1,:THUNDERSHOCK],
			[1,:LOWKICK],
			[5,:THUNDERSHOCK],
			[8,:LOWKICK],
			[12,:SWIFT],
			[15,:SHOCKWAVE],
			[19,:THUNDERWAVE],
			[22,:ELECTROBALL],
			[26,:LIGHTSCREEN],
			[29,:THUNDERPUNCH],
			[36,:DISCHARGE],
			[42,:SCREECH],
			[49,:THUNDERBOLT],
			[55,:THUNDER],
			[62,:GIGAIMPACT],
			[65,:ELECTRICTERRAIN]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:CHARGEBEAM,:COUNTER,:COVET,:CURSE,:DARKESTLARIAT,:DETECT,:DIG,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:IRONTAIL,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGNETRISE,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCREECH,:SEISMICTOSS,:SHOCKWAVE,:SIGNALBEAM,:SKULLBASH,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SWIFT,:TAKEDOWN,:TAUNT,:TELEPORT,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:UPROAR,:VOLTSWITCH,:WEATHERBALL,:WILDCHARGE,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Yellow",
		:EggGroups => [:HumanLike],
		:Height => 18,
		:Weight => 1386,
		:WildItemUncommon => :ELECTIRIZER,
		:kind => "Thunderbolt",
		:dexentry => "It pushes the tips of its two tails against the foe, then lets loose with over 20,000 volts of power.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MAGMORTAR => {
	"Normal Form" => {
		:name => "Magmortar",
		:dexnum => 467,
		:Type1 => :FIRE,
		:BaseStats => [75, 95, 67, 125, 95, 83],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:FLAMEBODY, :VITALSPIRIT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemQuarter,
		:BaseEXP => 243,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 6630,
		:preevo => {
			:species => :MAGMAR,
			:form => 0
		},
		:Moveset => [
			[1,:THUNDERPUNCH],
			[1,:SMOG],
			[1,:LEER],
			[1,:EMBER],
			[1,:SMOKESCREEN],
			[5,:EMBER],
			[8,:SMOKESCREEN],
			[12,:FEINTATTACK],
			[15,:FIRESPIN],
			[19,:CLEARSMOG],
			[22,:FLAMEBURST],
			[26,:CONFUSERAY],
			[29,:FIREPUNCH],
			[36,:LAVAPLUME],
			[42,:SUNNYDAY],
			[49,:FLAMETHROWER],
			[55,:FIREBLAST],
			[62,:HYPERBEAM]],
		:compatiblemoves => [:BIDE,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:BURNINGJEALOUSY,:COUNTER,:COVET,:CURSE,:DETECT,:DOUBLEEDGE,:DUALCHOP,:DYNAMICPUNCH,:EARTHQUAKE,:FEINTATTACK,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLAREBLITZ,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FOCUSPUNCH,:GIGAIMPACT,:HEADBUTT,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:INCINERATE,:IRONTAIL,:LOWKICK,:LOWSWEEP,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:OVERHEAT,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYWAVE,:RAGE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SCORCHINGSANDS,:SCREECH,:SEISMICTOSS,:SKULLBASH,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUBMISSION,:SUNNYDAY,:TAKEDOWN,:TAUNT,:TELEPORT,:THIEF,:THUNDERBOLT,:THUNDERPUNCH,:TORMENT,:UPROAR,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:HumanLike],
		:Height => 16,
		:Weight => 680,
		:WildItemUncommon => :MAGMARIZER,
		:kind => "Blast",
		:dexentry => "It blasts fireballs of over 3,600 degrees F from the ends of its arms. It lives in volcanic craters.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TOGEKISS => {
	"Normal Form" => {
		:name => "Togekiss",
		:dexnum => 468,
		:Type1 => :FAIRY,
		:Type2 => :FLYING,
		:BaseStats => [85, 50, 95, 120, 115, 80],
		:EVs => [0, 0, 0, 2, 1, 0],
		:Abilities => [:HUSTLE, :SERENEGRACE],
		:HiddenAbilities => :SUPERLUCK,
		:GrowthRate => :Fast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 245,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 2805,
		:preevo => {
			:species => :TOGETIC,
			:form => 0
		},
		:Moveset => [
			[1,:AFTERYOU],
			[1,:SKYATTACK],
			[1,:EXTREMESPEED],
			[1,:AURASPHERE],
			[1,:AIRSLASH]],
		:compatiblemoves => [:AERIALACE,:AFTERYOU,:AIRCUTTER,:AIRSLASH,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:AURASPHERE,:BATONPASS,:BODYSLAM,:BRICKBREAK,:CHARM,:COVET,:CURSE,:DAZZLINGGLEAM,:DEFENSECURL,:DEFOG,:DETECT,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DUALWINGBEAT,:ECHOEDVOICE,:ENCORE,:ENDEAVOR,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLING,:FLY,:FOCUSPUNCH,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:IMPRISON,:INCINERATE,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICALLEAF,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:METRONOME,:MIMIC,:MUDSLAP,:MYSTICALFIRE,:NASTYPLOT,:OMINOUSWIND,:PLAYROUGH,:PLUCK,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:RETALIATE,:ROCKSMASH,:ROLLOUT,:ROOST,:SAFEGUARD,:SEISMICTOSS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SILVERWIND,:SKYATTACK,:SMARTSTRIKE,:SOFTBOILED,:SOLARBEAM,:STEELWING,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAILWIND,:TELEKINESIS,:THUNDERWAVE,:TRIATTACK,:TRICK,:TWISTER,:WATERPULSE,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Flying, :Fairy],
		:Height => 15,
		:Weight => 380,
		:kind => "Jubilee",
		:dexentry => "It will never appear where there is strife. Its sightings have become rare recently.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 18,
	},

	:OnCreation => {},
},

:YANMEGA => {
	"Normal Form" => {
		:name => "Yanmega",
		:dexnum => 469,
		:Type1 => :BUG,
		:Type2 => :FLYING,
		:BaseStats => [86, 76, 86, 116, 56, 95],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:SPEEDBOOST, :TINTEDLENS],
		:HiddenAbilities => :FRISK,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 180,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :YANMA,
			:form => 0
		},
		:Moveset => [
			[1,:BUGBUZZ],
			[1,:AIRSLASH],
			[1,:NIGHTSLASH],
			[1,:BUGBITE],
			[1,:TACKLE],
			[1,:FORESIGHT],
			[1,:QUICKATTACK],
			[1,:DOUBLETEAM],
			[6,:QUICKATTACK],
			[11,:DOUBLETEAM],
			[14,:SONICBOOM],
			[17,:DETECT],
			[22,:SUPERSONIC],
			[27,:UPROAR],
			[30,:PURSUIT],
			[33,:ANCIENTPOWER],
			[38,:FEINT],
			[43,:SLASH],
			[46,:SCREECH],
			[49,:UTURN],
			[54,:AIRSLASH],
			[57,:BUGBUZZ]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:AIRSLASH,:ANCIENTPOWER,:BUGBITE,:BUGBUZZ,:CURSE,:DEFOG,:DETECT,:DOUBLEEDGE,:DREAMEATER,:DUALWINGBEAT,:FLASH,:GIGADRAIN,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:LASERFOCUS,:LEECHLIFE,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:ROOST,:SCREECH,:SHADOWBALL,:SIGNALBEAM,:SILVERWIND,:SKITTERSMACK,:SOLARBEAM,:STEELWING,:STRINGSHOT,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:TAILWIND,:THIEF,:UPROAR,:UTURN,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Bug],
		:Height => 19,
		:Weight => 515,
		:WildItemUncommon => :WIDELENS,
		:kind => "Ogre Darner",
		:dexentry => "By churning its wings, it creates shock waves that inflict critical internal injuries to foes.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:LEAFEON => {
	"Normal Form" => {
		:name => "Leafeon",
		:dexnum => 470,
		:Type1 => :GRASS,
		:BaseStats => [65, 110, 130, 60, 65, 95],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:LEAFGUARD, :LEAFGUARD],
		:HiddenAbilities => :CHLOROPHYLL,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:RAZORLEAF],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:GRASSWHISTLE],
			[20,:MAGICALLEAF],
			[25,:GIGADRAIN],
			[29,:SWORDSDANCE],
			[33,:SYNTHESIS],
			[37,:SUNNYDAY],
			[41,:LASTRESORT],
			[45,:LEAFBLADE]],
		:compatiblemoves => [:AERIALACE,:BABYDOLLEYES,:BATONPASS,:BIDE,:BODYSLAM,:BULLETSEED,:CALMMIND,:CELEBRATE,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:ENERGYBALL,:FAKETEARS,:FLASH,:FOCUSENERGY,:FURYCUTTER,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSYGLIDE,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LEAFSTORM,:MAGICALLEAF,:MIMIC,:MUDSLAP,:NATUREPOWER,:PAYDAY,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKSMASH,:SEEDBOMB,:SHADOWBALL,:SKULLBASH,:SOLARBEAM,:SOLARBLADE,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:TAKEDOWN,:WEATHERBALL,:WORKUP,:WORRYSEED,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 255,
		:kind => "Verdant",
		:dexentry => "Just like a plant, it uses photosynthesis. As a result, it is always enveloped in clear air.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GLACEON => {
	"Normal Form" => {
		:name => "Glaceon",
		:dexnum => 471,
		:Type1 => :ICE,
		:BaseStats => [65, 60, 110, 130, 95, 65],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:SNOWCLOAK, :SNOWCLOAK],
		:HiddenAbilities => :ICEBODY,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 184,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 9180,
		:preevo => {
			:species => :EEVEE,
			:form => 0
		},
		:Moveset => [
			[0,:ICYWIND],
			[1,:HELPINGHAND],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[5,:SANDATTACK],
			[9,:BABYDOLLEYES],
			[13,:QUICKATTACK],
			[17,:BITE],
			[20,:ICEFANG],
			[25,:ICESHARD],
			[29,:BARRIER],
			[33,:MIRRORCOAT],
			[37,:HAIL],
			[41,:LASTRESORT],
			[45,:BLIZZARD]],
		:compatiblemoves => [:AQUATAIL,:AURORAVEIL,:AVALANCHE,:BABYDOLLEYES,:BATONPASS,:BIDE,:BLIZZARD,:BODYSLAM,:CALMMIND,:CELEBRATE,:CHARM,:COVET,:CURSE,:DETECT,:DIG,:DOUBLEEDGE,:ECHOEDVOICE,:FAKETEARS,:FOCUSENERGY,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICEFANG,:ICICLESPEAR,:ICYWIND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:MIMIC,:MUDSLAP,:PAYDAY,:RAGE,:RAINDANCE,:REFLECT,:RETALIATE,:ROAR,:ROCKSMASH,:SHADOWBALL,:SIGNALBEAM,:SKULLBASH,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TRIPLEAXEL,:WATERPULSE,:WEATHERBALL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 259,
		:kind => "Fresh Snow",
		:dexentry => "As a protective technique, it can completely freeze its fur to make its hairs stand like needles.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GLISCOR => {
	"Normal Form" => {
		:name => "Gliscor",
		:dexnum => 472,
		:Type1 => :GROUND,
		:Type2 => :FLYING,
		:BaseStats => [75, 95, 125, 45, 75, 95],
		:EVs => [0, 0, 2, 0, 0, 0],
		:Abilities => [:HYPERCUTTER, :SANDVEIL],
		:HiddenAbilities => :POISONHEAL,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 179,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :GLIGAR,
			:form => 0
		},
		:Moveset => [
			[1,:GUILLOTINE],
			[1,:THUNDERFANG],
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:POISONJAB],
			[1,:SANDATTACK],
			[1,:HARDEN],
			[1,:KNOCKOFF],
			[4,:SANDATTACK],
			[7,:HARDEN],
			[10,:KNOCKOFF],
			[13,:QUICKATTACK],
			[16,:FURYCUTTER],
			[19,:FEINTATTACK],
			[22,:ACROBATICS],
			[27,:NIGHTSLASH],
			[30,:UTURN],
			[35,:SCREECH],
			[40,:XSCISSOR],
			[45,:SKYUPPERCUT],
			[50,:SWORDSDANCE],
			[55,:GUILLOTINE]],
		:compatiblemoves => [:ACROBATICS,:AERIALACE,:AIRSLASH,:AQUATAIL,:BEATUP,:BRICKBREAK,:BRUTALSWING,:BUGBITE,:BULLDOZE,:CROSSPOISON,:CUT,:DARKESTLARIAT,:DARKPULSE,:DEFOG,:DIG,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:FALSESWIPE,:FIREFANG,:FLING,:FURYCUTTER,:GIGAIMPACT,:HEADBUTT,:HONECLAWS,:HYPERBEAM,:ICEFANG,:IRONTAIL,:KNOCKOFF,:LASHOUT,:MUDSHOT,:MUDSLAP,:PAYBACK,:POISONJAB,:RAINDANCE,:ROCKCLIMB,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROOST,:SANDSTORM,:SANDTOMB,:SCARYFACE,:SCORCHINGSANDS,:SCREECH,:SKITTERSMACK,:SKYATTACK,:SLUDGEBOMB,:STEALTHROCK,:STEELWING,:STONEEDGE,:STRENGTH,:STRUGGLEBUG,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAILWIND,:TAUNT,:THIEF,:THROATCHOP,:THUNDERFANG,:TORMENT,:UTURN,:VENOSHOCK,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Bug],
		:Height => 20,
		:Weight => 425,
		:kind => "Fang Scorp",
		:dexentry => "It observes prey while hanging inverted from branches. When the chance presents itself, it swoops.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:MAMOSWINE => {
	"Normal Form" => {
		:name => "Mamoswine",
		:dexnum => 473,
		:Type1 => :ICE,
		:Type2 => :GROUND,
		:BaseStats => [110, 130, 80, 70, 60, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:OBLIVIOUS, :SNOWCLOAK],
		:HiddenAbilities => :THICKFAT,
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 239,
		:CatchRate => 50,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PILOSWINE,
			:form => 0
		},
		:Moveset => [
			[1,:FURYATTACK],
			[1,:SCARYFACE],
			[1,:ANCIENTPOWER],
			[1,:PECK],
			[1,:ODORSLEUTH],
			[1,:MUDSPORT],
			[1,:POWDERSNOW],
			[5,:MUDSPORT],
			[8,:POWDERSNOW],
			[11,:MUDSLAP],
			[14,:ENDURE],
			[18,:MUDBOMB],
			[21,:HAIL],
			[24,:ICEFANG],
			[28,:TAKEDOWN],
			[33,:DOUBLEHIT],
			[37,:MIST],
			[41,:THRASH],
			[46,:EARTHQUAKE],
			[52,:BLIZZARD],
			[58,:SCARYFACE]],
		:compatiblemoves => [:AMNESIA,:ANCIENTPOWER,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYPRESS,:BODYSLAM,:BULLDOZE,:CURSE,:DEFENSECURL,:DETECT,:DIG,:DOUBLEEDGE,:EARTHPOWER,:EARTHQUAKE,:ENDEAVOR,:FURYCUTTER,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICICLESPEAR,:ICYWIND,:IRONHEAD,:KNOCKOFF,:LIGHTSCREEN,:MIMIC,:MUDSHOT,:MUDSLAP,:RAINDANCE,:REFLECT,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SANDSTORM,:SANDTOMB,:SCARYFACE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUPERPOWER,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 25,
		:Weight => 2910,
		:kind => "Twin Tusk",
		:dexentry => "A frozen Mamoswine was dug from ice dating back 10,000 years. This Pokémon has been around for a long, long time.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PORYGONZ => {
	"Normal Form" => {
		:name => "Porygon-Z",
		:dexnum => 474,
		:Type1 => :NORMAL,
		:BaseStats => [85, 80, 70, 135, 75, 90],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:ADAPTABILITY, :DOWNLOAD],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 241,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :PORYGON2,
			:form => 0
		},
		:Moveset => [
			[1,:TRICKROOM],
			[1,:ZAPCANNON],
			[1,:MAGICCOAT],
			[1,:CONVERSION2],
			[1,:TACKLE],
			[1,:CONVERSION],
			[1,:NASTYPLOT],
			[7,:PSYBEAM],
			[12,:AGILITY],
			[18,:RECOVER],
			[23,:MAGNETRISE],
			[29,:SIGNALBEAM],
			[34,:EMBARGO],
			[40,:DISCHARGE],
			[45,:LOCKON],
			[50,:TRIATTACK],
			[56,:MAGICCOAT],
			[62,:ZAPCANNON],
			[67,:HYPERBEAM]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:ALLYSWITCH,:BIDE,:BLIZZARD,:BOUNCE,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CURSE,:DARKPULSE,:DEFENSECURL,:DOUBLEEDGE,:DREAMEATER,:EARTHQUAKE,:EERIEIMPULSE,:ELECTROWEB,:EMBARGO,:ENERGYBALL,:FLASH,:FOULPLAY,:GIGAIMPACT,:GRAVITY,:GUARDSWAP,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:IRONTAIL,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MAGNETRISE,:MIMIC,:MUDSLAP,:NASTYPLOT,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:PSYWAVE,:RAGE,:RAINDANCE,:RECYCLE,:REFLECT,:ROAR,:ROLEPLAY,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SKULLBASH,:SOLARBEAM,:SPEEDSWAP,:SPITE,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TAKEDOWN,:TELEKINESIS,:TELEPORT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:UPROAR,:WILDCHARGE,:WONDERROOM,:WORKUP,:ZAPCANNON,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:EggGroups => [:Mineral],
		:Height => 9,
		:Weight => 340,
		:kind => "Virtual",
		:dexentry => "Additional software was installed to make it a better Pokémon. It began acting oddly, however.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 16,
		:BattlerAltitude => 8,
	},

	:OnCreation => {},
},

:GALLADE => {
	"Normal Form" => {
		:name => "Gallade",
		:dexnum => 475,
		:Type1 => :PSYCHIC,
		:Type2 => :FIGHTING,
		:BaseStats => [68, 125, 65, 65, 115, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:STEADFAST, :JUSTIFIED],
		:GrowthRate => :Slow,
		:GenderRatio => :FemZero,
		:BaseEXP => 233,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 5355,
		:preevo => {
			:species => :KIRLIA,
			:form => 0
		},
		:Moveset => [
			[0,:SLASH],
			[1,:STOREDPOWER],
			[1,:CLOSECOMBAT],
			[1,:LEAFBLADE],
			[1,:NIGHTSLASH],
			[1,:LEER],
			[1,:CONFUSION],
			[1,:DOUBLETEAM],
			[1,:TELEPORT],
			[4,:CONFUSION],
			[6,:DOUBLETEAM],
			[9,:TELEPORT],
			[11,:QUICKGUARD],
			[14,:FURYCUTTER],
			[17,:AERIALACE],
			[19,:HEALPULSE],
			[23,:WIDEGUARD],
			[26,:SWORDSDANCE],
			[31,:PSYCHOCUT],
			[35,:HELPINGHAND],
			[40,:FEINT],
			[44,:FALSESWIPE],
			[49,:PROTECT],
			[53,:CLOSECOMBAT],
			[58,:STOREDPOWER]],
		:compatiblemoves => [:AERIALACE,:AIRSLASH,:ALLYSWITCH,:AURASPHERE,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CHARM,:CLOSECOMBAT,:COACHING,:CUT,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:DUALCHOP,:EARTHQUAKE,:ECHOEDVOICE,:ENCORE,:EXPANDINGFORCE,:FALSESWIPE,:FIREPUNCH,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEPUNCH,:ICYWIND,:IMPRISON,:KNOCKOFF,:LASERFOCUS,:LEAFBLADE,:LIGHTSCREEN,:LOWKICK,:LOWSWEEP,:MAGICALLEAF,:MAGICCOAT,:MAGICROOM,:MEGAKICK,:MEGAPUNCH,:MIMIC,:MISTYTERRAIN,:MUDSLAP,:NIGHTMARE,:PAINSPLIT,:POISONJAB,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:REVENGE,:REVERSAL,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SNATCH,:SOLARBLADE,:STONEEDGE,:STOREDPOWER,:STRENGTH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:TELEKINESIS,:THIEF,:THROATCHOP,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:TRIPLEAXEL,:VACUUMWAVE,:WILLOWISP,:WONDERROOM,:WORKUP,:XSCISSOR,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Amorphous],
		:Height => 16,
		:Weight => 520,
		:kind => "Blade",
		:dexentry => "A master of courtesy and swordsmanship, it fights using extending swords on its elbows.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 8,
		:BattlerAltitude => 0,
	},

	"Mega Form" => {
		:BaseStats => [68, 165, 95, 65, 115, 110],
		:Abilities => [:INNERFOCUS],
		:Height => 16,
		:Weight => 564,
	},

	:OnCreation => {},
	:DefaultForm => 0,
	:MegaForm => {
		:GALLADITE => 1,
	},
},

:PROBOPASS => {
	"Normal Form" => {
		:name => "Probopass",
		:dexnum => 476,
		:Type1 => :ROCK,
		:Type2 => :STEEL,
		:BaseStats => [60, 55, 145, 75, 150, 40],
		:EVs => [0, 0, 1, 0, 2, 0],
		:Abilities => [:STURDY, :MAGNETPULL],
		:HiddenAbilities => :SANDFORCE,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 184,
		:CatchRate => 60,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :NOSEPASS,
			:form => 0
		},
		:Moveset => [
			[0,:TRIATTACK],
			[1,:MAGNETICFLUX],
			[1,:MAGNETRISE],
			[1,:GRAVITY],
			[1,:WIDEGUARD],
			[1,:TACKLE],
			[1,:IRONDEFENSE],
			[1,:BLOCK],
			[1,:MAGNETBOMB],
			[4,:IRONDEFENSE],
			[7,:BLOCK],
			[10,:MAGNETBOMB],
			[13,:THUNDERWAVE],
			[16,:REST],
			[19,:SPARK],
			[22,:ROCKSLIDE],
			[25,:POWERGEM],
			[28,:ROCKBLAST],
			[31,:DISCHARGE],
			[34,:SANDSTORM],
			[37,:EARTHPOWER],
			[40,:STONEEDGE],
			[43,:LOCKON],
			[43,:ZAPCANNON]],
		:compatiblemoves => [:ALLYSWITCH,:ANCIENTPOWER,:BLOCK,:BODYPRESS,:BODYSLAM,:BULLDOZE,:DAZZLINGGLEAM,:DEFENSECURL,:DOUBLEEDGE,:DYNAMICPUNCH,:EARTHPOWER,:EARTHQUAKE,:EERIEIMPULSE,:EXPLOSION,:FIREPUNCH,:FLASHCANNON,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEAVYSLAM,:HYPERBEAM,:ICEPUNCH,:IRONDEFENSE,:IRONHEAD,:MAGICCOAT,:MAGNETRISE,:METEORBEAM,:MIMIC,:MUDSLAP,:PAINSPLIT,:POWERGEM,:ROCKBLAST,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SCREECH,:SELFDESTRUCT,:SHOCKWAVE,:SMACKDOWN,:STEALTHROCK,:STEELBEAM,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:VOLTSWITCH,:ZAPCANNON,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Mineral],
		:Height => 14,
		:Weight => 3400,
		:WildItemUncommon => :MAGNET,
		:kind => "Compass",
		:dexentry => "It exudes strong magnetism from all over. It controls three small units called Mini-Noses.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:DUSKNOIR => {
	"Normal Form" => {
		:name => "Dusknoir",
		:dexnum => 477,
		:Type1 => :GHOST,
		:BaseStats => [45, 100, 135, 65, 135, 45],
		:EVs => [0, 0, 1, 0, 2, 0],
		:Abilities => [:PRESSURE, :FRISK],
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 236,
		:CatchRate => 45,
		:Happiness => 35,
		:EggSteps => 6630,
		:preevo => {
			:species => :DUSCLOPS,
			:form => 0
		},
		:Moveset => [
			[1,:SHADOWPUNCH],
			[1,:FUTURESIGHT],
			[1,:FIREPUNCH],
			[1,:ICEPUNCH],
			[1,:THUNDERPUNCH],
			[1,:GRAVITY],
			[1,:BIND],
			[1,:LEER],
			[1,:NIGHTSHADE],
			[1,:DISABLE],
			[1,:ASTONISH],
			[6,:DISABLE],
			[9,:ASTONISH],
			[14,:FORESIGHT],
			[17,:SHADOWSNEAK],
			[22,:PURSUIT],
			[25,:WILLOWISP],
			[30,:CONFUSERAY],
			[33,:CURSE],
			[40,:HEX],
			[45,:SHADOWBALL],
			[52,:MEANLOOK],
			[57,:PAYBACK],
			[64,:FUTURESIGHT]],
		:compatiblemoves => [:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:CHARGEBEAM,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:HEADBUTT,:BIND,:FLASH,:PAINSPLIT,:PSYCHUP,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:GRAVITY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:INFESTATION,:POWERUPPUNCH,:LASERFOCUS,],
		:moveexceptions => [],
		:Color => "Black",
		:EggGroups => [:Amorphous],
		:Height => 22,
		:Weight => 1066,
		:WildItemUncommon => :SPELLTAG,
		:kind => "Gripper",
		:dexentry => "The antenna on its head captures radio waves from the world of spirits that command it to take people there.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 11,
		:BattlerAltitude => 7,
	},

	:OnCreation => {},
},

:FROSLASS => {
	"Normal Form" => {
		:name => "Froslass",
		:dexnum => 478,
		:Type1 => :ICE,
		:Type2 => :GHOST,
		:BaseStats => [70, 80, 70, 80, 70, 110],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:SNOWCLOAK, :CURSEDBODY],
		:GrowthRate => :MediumFast,
		:GenderRatio => :MaleZero,
		:BaseEXP => 168,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5355,
		:preevo => {
			:species => :SNORUNT,
			:form => 0
		},
		:Moveset => [
			[0,:OMINOUSWIND],
			[1,:DESTINYBOND],
			[1,:POWDERSNOW],
			[1,:LEER],
			[1,:DOUBLETEAM],
			[1,:ICESHARD],
			[5,:DOUBLETEAM],
			[10,:ICESHARD],
			[14,:ICYWIND],
			[19,:ASTONISH],
			[23,:DRAININGKISS],
			[28,:WILLOWISP],
			[32,:CONFUSERAY],
			[37,:WAKEUPSLAP],
			[41,:CAPTIVATE],
			[42,:SHADOWBALL],
			[48,:BLIZZARD],
			[54,:HAIL],
			[61,:DESTINYBOND]],
		:compatiblemoves => [:ALLYSWITCH,:AURORAVEIL,:AVALANCHE,:BLIZZARD,:BLOCK,:BODYSLAM,:CHARM,:CRUNCH,:DEFENSECURL,:DOUBLEEDGE,:DRAININGKISS,:DREAMEATER,:EMBARGO,:FAKETEARS,:FLASH,:FLING,:FROSTBREATH,:GIGAIMPACT,:HAIL,:HEADBUTT,:HEX,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICEPUNCH,:ICICLESPEAR,:ICYWIND,:IMPRISON,:LASERFOCUS,:LIGHTSCREEN,:MIMIC,:MUDSLAP,:OMINOUSWIND,:PAINSPLIT,:PAYBACK,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:RAINDANCE,:ROLLOUT,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SNATCH,:SPIKES,:SPITE,:SUCKERPUNCH,:TAUNT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:TRIPLEAXEL,:WATERPULSE,:WEATHERBALL,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "White",
		:EggGroups => [:Fairy, :Mineral],
		:Height => 13,
		:Weight => 266,
		:kind => "Snow Land",
		:dexentry => "It freezes foes with an icy breath of nearly -60 degrees F. What seems to be its body is actually hollow.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 7,
	},

	:OnCreation => {},
},

:ROTOM => {
	"Rotom" => {
		:name => "Rotom",
		:dexnum => 479,
		:Type1 => :ELECTRIC,
		:Type2 => :GHOST,
		:BaseStats => [50, 50, 77, 95, 77, 91],
		:EVs => [0, 0, 0, 1, 0, 1],
		:Abilities => [:LEVITATE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :Genderless,
		:BaseEXP => 154,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5355,
		:Moveset => [
			[1,:DISCHARGE],
			[1,:CHARGE],
			[1,:TRICK],
			[1,:ASTONISH],
			[1,:THUNDERWAVE],
			[1,:THUNDERSHOCK],
			[1,:CONFUSERAY],
			[8,:UPROAR],
			[15,:DOUBLETEAM],
			[22,:SHOCKWAVE],
			[29,:OMINOUSWIND],
			[36,:SUBSTITUTE],
			[43,:ELECTROBALL],
			[50,:HEX],
			[57,:CHARGE],
			[64,:DISCHARGE]],
		:compatiblemoves => [:ALLYSWITCH,:CHARGEBEAM,:DARKPULSE,:DEFOG,:DREAMEATER,:EERIEIMPULSE,:ELECTRICTERRAIN,:ELECTROBALL,:ELECTROWEB,:FLASH,:FOULPLAY,:HELPINGHAND,:HEX,:HYPERVOICE,:LIGHTSCREEN,:MUDSLAP,:NASTYPLOT,:OMINOUSWIND,:PAINSPLIT,:POLTERGEIST,:PSYCHUP,:RAINDANCE,:REFLECT,:RISINGVOLTAGE,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SNATCH,:SPITE,:STOREDPOWER,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THIEF,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICK,:UPROAR,:VOLTSWITCH,:WILLOWISP,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Red",
		:EggGroups => [:Amorphous],
		:Height => 3,
		:Weight => 3,
		:kind => "Plasma",
		:dexentry => "Its body is composed of plasma. It is known to infiltrate electronic devices and wreak havoc.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 17,
		:BattlerAltitude => 13,
	},

	"Heat Rotom" => {
		:Type2 => :FIRE,
		:BaseStats => [50, 65, 107, 105, 107, 86],
	},

	"Wash Rotom" => {
		:Type2 => :WATER,
		:BaseStats => [50, 65, 107, 105, 107, 86],
	},

	"Frost Rotom" => {
		:Type2 => :ICE,
		:BaseStats => [50, 65, 107, 105, 107, 86],
	},

	"Fan Rotom" => {
		:Type2 => :FLYING,
		:BaseStats => [50, 65, 107, 105, 107, 86],
	},

	"Mow Rotom" => {
		:Type2 => :GRASS,
		:BaseStats => [50, 65, 107, 105, 107, 86],
	},

	:OnCreation => {},
},

:UXIE => {
	"Normal Form" => {
		:name => "Uxie",
		:dexnum => 480,
		:Type1 => :PSYCHIC,
		:BaseStats => [75, 75, 130, 75, 130, 95],
		:EVs => [0, 0, 2, 0, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 140,
		:EggSteps => 20655,
		:Moveset => [
			[1,:MEMENTO],
			[1,:NATURALGIFT],
			[1,:FLAIL],
			[1,:REST],
			[1,:CONFUSION],
			[6,:IMPRISON],
			[16,:ENDURE],
			[21,:SWIFT],
			[31,:YAWN],
			[36,:FUTURESIGHT],
			[46,:AMNESIA],
			[50,:EXTRASENSORY],
			[61,:FLAIL],
			[66,:NATURALGIFT],
			[76,:MEMENTO]],
		:compatiblemoves => [:ACROBATICS,:ALLYSWITCH,:AMNESIA,:BATONPASS,:CALMMIND,:CHARGEBEAM,:DAZZLINGGLEAM,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FOULPLAY,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:IMPRISON,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:METRONOME,:MUDSLAP,:NASTYPLOT,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SANDSTORM,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:STEALTHROCK,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:UTURN,:WATERPULSE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Yellow",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 3,
		:kind => "Knowledge",
		:dexentry => "Known as “The Being of Knowledge.” It is said that it can wipe out the memory of those who see its eyes.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 18,
	},

	:OnCreation => {},
},

:MESPRIT => {
	"Normal Form" => {
		:name => "Mesprit",
		:dexnum => 481,
		:Type1 => :PSYCHIC,
		:BaseStats => [80, 105, 105, 105, 105, 80],
		:EVs => [0, 1, 0, 1, 1, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 140,
		:EggSteps => 20655,
		:Moveset => [
			[1,:HEALINGWISH],
			[1,:NATURALGIFT],
			[1,:COPYCAT],
			[1,:REST],
			[1,:CONFUSION],
			[6,:IMPRISON],
			[16,:PROTECT],
			[21,:SWIFT],
			[31,:LUCKYCHANT],
			[36,:FUTURESIGHT],
			[46,:CHARM],
			[50,:EXTRASENSORY],
			[61,:COPYCAT],
			[66,:NATURALGIFT],
			[76,:HEALINGWISH]],
		:compatiblemoves => [:ACROBATICS,:ALLYSWITCH,:BATONPASS,:BLIZZARD,:CALMMIND,:CHARGEBEAM,:CHARM,:DAZZLINGGLEAM,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FIREPUNCH,:FLASH,:FLING,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:IMPRISON,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:METRONOME,:MUDSLAP,:NASTYPLOT,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SANDSTORM,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STEALTHROCK,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:UTURN,:WATERPULSE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Pink",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 3,
		:kind => "Emotion",
		:dexentry => "Known as “The Being of Emotion.” It taught humans the nobility of sorrow, pain, and joy.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 18,
	},

	:OnCreation => {},
},

:AZELF => {
	"Normal Form" => {
		:name => "Azelf",
		:dexnum => 482,
		:Type1 => :PSYCHIC,
		:BaseStats => [75, 125, 70, 125, 70, 115],
		:EVs => [0, 2, 0, 1, 0, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 261,
		:CatchRate => 3,
		:Happiness => 140,
		:EggSteps => 20655,
		:Moveset => [
			[1,:NATURALGIFT],
			[1,:LASTRESORT],
			[1,:REST],
			[1,:CONFUSION],
			[6,:IMPRISON],
			[16,:DETECT],
			[21,:SWIFT],
			[31,:UPROAR],
			[36,:FUTURESIGHT],
			[46,:NASTYPLOT],
			[50,:EXTRASENSORY],
			[61,:LASTRESORT],
			[66,:NATURALGIFT],
			[76,:EXPLOSION]],
		:compatiblemoves => [:ACROBATICS,:ALLYSWITCH,:ASSURANCE,:BATONPASS,:CALMMIND,:CHARGEBEAM,:DAZZLINGGLEAM,:DRAININGKISS,:DRAINPUNCH,:DREAMEATER,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:EXPLOSION,:FIREBLAST,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HELPINGHAND,:HYPERBEAM,:ICEPUNCH,:IMPRISON,:INCINERATE,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:METRONOME,:MUDSLAP,:NASTYPLOT,:PAYBACK,:PLAYROUGH,:POWERUPPUNCH,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:ROLEPLAY,:SAFEGUARD,:SANDSTORM,:SELFDESTRUCT,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STEALTHROCK,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TORMENT,:TRIATTACK,:TRICK,:TRICKROOM,:UPROAR,:UTURN,:WATERPULSE,:WONDERROOM,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:EggGroups => [:Undiscovered],
		:Height => 3,
		:Weight => 3,
		:kind => "Willpower",
		:dexentry => "Known as “The Being of Willpower.” It sleeps at the bottom of a lake to keep the world in balance.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 20,
	},

	:OnCreation => {},
},

:DIALGA => {
	"Dialga" => {
		:name => "Dialga",
		:dexnum => 483,
		:Type1 => :STEEL,
		:Type2 => :DRAGON,
		:BaseStats => [100, 120, 120, 150, 100, 90],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:PRESSURE, :TELEPATHY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 30,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:DRAGONBREATH],
			[1,:SCARYFACE],
			[6,:METALCLAW],
			[10,:ANCIENTPOWER],
			[15,:SLASH],
			[19,:POWERGEM],
			[24,:METALBURST],
			[28,:DRAGONCLAW],
			[33,:EARTHPOWER],
			[37,:AURASPHERE],
			[42,:IRONTAIL],
			[46,:ROAROFTIME],
			[50,:FLASHCANNON]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AURASPHERE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BULKUP,:BULLDOZE,:CUT,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FLAMETHROWER,:FLASH,:FLASHCANNON,:FURYCUTTER,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:MAGNETRISE,:MUDSLAP,:OUTRAGE,:OVERHEAT,:POWERGEM,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SCARYFACE,:SHADOWCLAW,:SHOCKWAVE,:STEALTHROCK,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICKROOM,:TWISTER,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "White",
		:EggGroups => [:Undiscovered],
		:Height => 54,
		:Weight => 6830,
		:kind => "Temporal",
		:dexentry => "It has the power to control time. It appears as an ancient deity in myths of the Sinnoh Region.",
		:BattlerPlayerY => 5,
		:BattlerEnemyY => 2,
		:BattlerAltitude => 0,
	},

	"Origin Forme" => {
		:BaseStats => [100, 100, 120, 150, 120, 90],
		:Height => 70,
		:Weight => 8500,
	},

	:OnCreation => {},
},

:PALKIA => {
	"Palkia" => {
		:name => "Palkia",
		:dexnum => 484,
		:Type1 => :WATER,
		:Type2 => :DRAGON,
		:BaseStats => [90, 120, 100, 150, 120, 100],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:PRESSURE, :TELEPATHY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 30,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:DRAGONBREATH],
			[1,:SCARYFACE],
			[6,:WATERPULSE],
			[10,:ANCIENTPOWER],
			[15,:SLASH],
			[19,:POWERGEM],
			[24,:AQUARING],
			[28,:DRAGONCLAW],
			[33,:EARTHPOWER],
			[37,:AURASPHERE],
			[42,:AQUATAIL],
			[46,:SPACIALREND],
			[50,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AQUATAIL,:AURASPHERE,:AVALANCHE,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRINE,:BULKUP,:BULLDOZE,:CUT,:DIVE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:FIREBLAST,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FURYCUTTER,:GIGAIMPACT,:GRAVITY,:HAIL,:HEADBUTT,:HEAVYSLAM,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:INCINERATE,:LIQUIDATION,:MUDSLAP,:OUTRAGE,:POWERGEM,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SCARYFACE,:SHADOWCLAW,:SHOCKWAVE,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRICKROOM,:TWISTER,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Purple",
		:EggGroups => [:Undiscovered],
		:Height => 42,
		:Weight => 3360,
		:kind => "Spatial",
		:dexentry => "It has the ability to distort space. It is described as a deity in the Sinnoh Region's mythology.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 4,
		:BattlerAltitude => 0,
	},

	"Origin Forme" => {
		:BaseStats => [90, 100, 100, 150, 120, 120],
		:Height => 63,
		:Weight => 6600,
	},

	:OnCreation => {},
},

:HEATRAN => {
	"Normal Form" => {
		:name => "Heatran",
		:dexnum => 485,
		:Type1 => :FIRE,
		:Type2 => :STEEL,
		:BaseStats => [91, 90, 106, 130, 106, 77],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:FLASHFIRE, :FLAMEBODY],
		:GrowthRate => :Slow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 100,
		:EggSteps => 2805,
		:Moveset => [
			[1,:MAGMASTORM],
			[1,:HEATWAVE],
			[1,:EARTHPOWER],
			[1,:IRONHEAD],
			[1,:FIRESPIN],
			[1,:ANCIENTPOWER],
			[9,:LEER],
			[17,:FIREFANG],
			[25,:METALSOUND],
			[33,:CRUNCH],
			[41,:SCARYFACE],
			[49,:LAVAPLUME],
			[57,:FIRESPIN],
			[65,:IRONHEAD],
			[73,:EARTHPOWER],
			[81,:HEATWAVE],
			[88,:STONEEDGE],
			[96,:MAGMASTORM]],
		:compatiblemoves => [:ANCIENTPOWER,:BODYPRESS,:BODYSLAM,:BUGBITE,:BULLDOZE,:BURNINGJEALOUSY,:CRUNCH,:DARKPULSE,:DIG,:DRAGONPULSE,:EARTHPOWER,:EARTHQUAKE,:EXPLOSION,:FIREBLAST,:FIREFANG,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLASHCANNON,:GIGAIMPACT,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HEAVYSLAM,:HYPERBEAM,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:MUDSLAP,:NATUREPOWER,:OVERHEAT,:PAYBACK,:ROAR,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SCORCHINGSANDS,:SELFDESTRUCT,:SOLARBEAM,:STEALTHROCK,:STEELROLLER,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:TAUNT,:TORMENT,:UPROAR,:WILLOWISP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Undiscovered],
		:Height => 17,
		:Weight => 4300,
		:kind => "Lava Dome",
		:dexentry => "It dwells in volcanic caves. It digs in with its cross-shaped feet to crawl on ceilings and walls.",
		:BattlerPlayerY => 23,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:REGIGIGAS => {
	"Normal Form" => {
		:name => "Regigigas",
		:dexnum => 486,
		:Type1 => :NORMAL,
		:BaseStats => [110, 160, 110, 80, 110, 100],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:SLOWSTART],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 302,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:HEAVYSLAM],
			[1,:CRUSHGRIP],
			[1,:FIREPUNCH],
			[1,:ICEPUNCH],
			[1,:THUNDERPUNCH],
			[1,:DIZZYPUNCH],
			[1,:KNOCKOFF],
			[1,:CONFUSERAY],
			[1,:FORESIGHT],
			[25,:REVENGE],
			[40,:WIDEGUARD],
			[50,:ZENHEADBUTT],
			[65,:PAYBACK],
			[75,:CRUSHGRIP],
			[90,:HEAVYSLAM],
			[100,:GIGAIMPACT]],
		:compatiblemoves => [:AERIALACE,:ANCIENTPOWER,:AVALANCHE,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULLDOZE,:DARKESTLARIAT,:DRAINPUNCH,:EARTHPOWER,:EARTHQUAKE,:FIREPUNCH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEATCRASH,:HEAVYSLAM,:HIGHHORSEPOWER,:HYPERBEAM,:ICEPUNCH,:ICYWIND,:IRONHEAD,:KNOCKOFF,:MEGAKICK,:MEGAPUNCH,:MUDSLAP,:NATUREPOWER,:PAYBACK,:POWERUPPUNCH,:PSYCHUP,:RAINDANCE,:RETALIATE,:REVENGE,:ROCKPOLISH,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SHOCKWAVE,:SMACKDOWN,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:TERRAINPULSE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "White",
		:EggGroups => [:Undiscovered],
		:Height => 37,
		:Weight => 4200,
		:kind => "Colossal",
		:dexentry => "There is an enduring legend that states this Pokémon having towed continents with ropes.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:GIRATINA => {
	"Altered Forme" => {
		:name => "Giratina",
		:dexnum => 487,
		:Type1 => :GHOST,
		:Type2 => :DRAGON,
		:BaseStats => [150, 100, 120, 100, 120, 90],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:PRESSURE, :TELEPATHY],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 306,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:DRAGONBREATH],
			[1,:SCARYFACE],
			[6,:OMINOUSWIND],
			[10,:ANCIENTPOWER],
			[15,:SLASH],
			[19,:SHADOWSNEAK],
			[24,:DESTINYBOND],
			[28,:DRAGONCLAW],
			[33,:EARTHPOWER],
			[37,:AURASPHERE],
			[42,:SHADOWCLAW],
			[46,:SHADOWFORCE],
			[50,:HEX]],
		:compatiblemoves => [:AERIALACE,:AIRCUTTER,:ANCIENTPOWER,:AQUATAIL,:AURASPHERE,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:BULLDOZE,:CALMMIND,:CHARGEBEAM,:CUT,:DARKPULSE,:DEFOG,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DRAGONTAIL,:DREAMEATER,:DUALWINGBEAT,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ENERGYBALL,:FLY,:FURYCUTTER,:GIGAIMPACT,:GRAVITY,:HEADBUTT,:HEX,:HONECLAWS,:HYPERBEAM,:HYPERVOICE,:ICYWIND,:IRONHEAD,:IRONTAIL,:MAGICCOAT,:MUDSLAP,:OMINOUSWIND,:OUTRAGE,:PAINSPLIT,:PAYBACK,:PHANTOMFORCE,:POLTERGEIST,:PSYCHIC,:PSYCHUP,:RAINDANCE,:ROAR,:ROCKCLIMB,:ROCKSMASH,:SAFEGUARD,:SCARYFACE,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SILVERWIND,:SPITE,:STEELWING,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SWIFT,:TAILWIND,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TWISTER,:WILLOWISP,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Black",
		:EggGroups => [:Undiscovered],
		:Height => 45,
		:Weight => 7500,
		:kind => "Renegade",
		:dexentry => "A Pokémon that is said to live in a world on the reverse side of ours. It appears in an ancient cemetery.",
		:BattlerPlayerY => 8,
		:BattlerEnemyY => 3,
		:BattlerAltitude => 0,
	},

	"Origin Forme" => {
		:BaseStats => [150, 120, 100, 120, 100, 90],
		:Abilities => [:LEVITATE],
		:Height => 69,
		:Weight => 6500,
	},

	:OnCreation => {},
},

:CRESSELIA => {
	"Normal Form" => {
		:name => "Cresselia",
		:dexnum => 488,
		:Type1 => :PSYCHIC,
		:BaseStats => [120, 70, 120, 75, 130, 85],
		:EVs => [0, 0, 0, 0, 3, 0],
		:Abilities => [:LEVITATE],
		:GrowthRate => :Slow,
		:GenderRatio => :MaleZero,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 100,
		:EggSteps => 30855,
		:Moveset => [
			[1,:LUNARDANCE],
			[1,:PSYCHOSHIFT],
			[1,:MOONLIGHT],
			[1,:CONFUSION],
			[1,:DOUBLETEAM],
			[11,:SAFEGUARD],
			[20,:MIST],
			[29,:AURORABEAM],
			[38,:FUTURESIGHT],
			[47,:SLASH],
			[57,:MOONLIGHT],
			[66,:PSYCHOCUT],
			[75,:PSYCHOSHIFT],
			[84,:LUNARDANCE],
			[93,:PSYCHIC],
			[99,:MOONBLAST]],
		:compatiblemoves => [:ALLYSWITCH,:BODYSLAM,:CALMMIND,:CHARGEBEAM,:DREAMEATER,:ENERGYBALL,:EXPANDINGFORCE,:FLASH,:FURYCUTTER,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HELPINGHAND,:HYPERBEAM,:ICEBEAM,:ICYWIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:MUDSLAP,:POWERSWAP,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:RECYCLE,:REFLECT,:SAFEGUARD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TELEKINESIS,:THUNDERWAVE,:TRICK,:TRICKROOM,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Yellow",
		:EggGroups => [:Undiscovered],
		:Height => 15,
		:Weight => 856,
		:kind => "Lunar",
		:dexentry => "Shiny particles are released from its wings like a veil. It is said to represent the crescent moon.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 7,
		:BattlerAltitude => 11,
	},

	:OnCreation => {},
},

:PHIONE => {
	"Normal Form" => {
		:name => "Phione",
		:dexnum => 489,
		:Type1 => :WATER,
		:BaseStats => [80, 80, 80, 80, 80, 80],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:HYDRATION],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 216,
		:CatchRate => 30,
		:Happiness => 70,
		:EggSteps => 10455,
		:Moveset => [
			[1,:BUBBLE],
			[1,:WATERSPORT],
			[9,:CHARM],
			[16,:SUPERSONIC],
			[24,:BUBBLEBEAM],
			[31,:ACIDARMOR],
			[39,:WHIRLPOOL],
			[46,:WATERPULSE],
			[54,:AQUARING],
			[61,:DIVE],
			[69,:RAINDANCE]],
		:compatiblemoves => [:ANCIENTPOWER,:BLIZZARD,:BOUNCE,:BRINE,:CHARM,:COVET,:DAZZLINGGLEAM,:DIVE,:FAKETEARS,:FLING,:FLIPTURN,:GRASSKNOT,:HAIL,:HEALBELL,:HELPINGHAND,:HYDROPUMP,:ICEBEAM,:ICYWIND,:KNOCKOFF,:LASTRESORT,:LIQUIDATION,:MUDDYWATER,:MUDSLAP,:PSYCHUP,:RAINDANCE,:SAFEGUARD,:SCALD,:SIGNALBEAM,:SURF,:SWIFT,:UPROAR,:UTURN,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:EggGroups => [:Water1, :Fairy],
		:Height => 4,
		:Weight => 31,
		:kind => "Sea Drifter",
		:dexentry => "A Pokémon that lives in warm seas. It inflates the flotation sac on its head to drift and search for food.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 24,
		:BattlerAltitude => 17,
	},

	:OnCreation => {},
},

:MANAPHY => {
	"Normal Form" => {
		:name => "Manaphy",
		:dexnum => 490,
		:Type1 => :WATER,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:HYDRATION],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 70,
		:EggSteps => 2805,
		:Moveset => [
			[1,:TAILGLOW],
			[1,:BUBBLE],
			[1,:WATERSPORT],
			[9,:CHARM],
			[16,:SUPERSONIC],
			[24,:BUBBLEBEAM],
			[31,:ACIDARMOR],
			[39,:WHIRLPOOL],
			[46,:WATERPULSE],
			[54,:AQUARING],
			[61,:DIVE],
			[69,:RAINDANCE],
			[76,:HEARTSWAP]],
		:compatiblemoves => [:ANCIENTPOWER,:BLIZZARD,:BOUNCE,:BRINE,:CALMMIND,:CHARM,:COVET,:DAZZLINGGLEAM,:DIVE,:ENERGYBALL,:FAKETEARS,:FLASH,:FLING,:FLIPTURN,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HEALBELL,:HELPINGHAND,:HYDROPUMP,:HYPERBEAM,:ICEBEAM,:ICYWIND,:KNOCKOFF,:LASTRESORT,:LIGHTSCREEN,:LIQUIDATION,:MUDSLAP,:PSYCHIC,:PSYCHUP,:RAINDANCE,:REFLECT,:SAFEGUARD,:SCALD,:SHADOWBALL,:SIGNALBEAM,:SKILLSWAP,:SURF,:SWIFT,:UPROAR,:UTURN,:WATERFALL,:WATERPULSE,:WHIRLPOOL,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Blue",
		:EggGroups => [:Water1, :Fairy],
		:Height => 3,
		:Weight => 14,
		:kind => "Seafaring",
		:dexentry => "Born on a cold seafloor, it will swim great distances to return to its birthplace.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 17,
	},

	:OnCreation => {},
},

:DARKRAI => {
	"Normal Form" => {
		:name => "Darkrai",
		:dexnum => 491,
		:Type1 => :DARK,
		:BaseStats => [70, 90, 90, 135, 90, 125],
		:EVs => [0, 0, 0, 2, 0, 1],
		:Abilities => [:BADDREAMS],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:PHANTOMFORCE],
			[1,:SPACIALREND],
			[1,:ROAROFTIME],
			[1,:OMINOUSWIND],
			[1,:DISABLE],
			[11,:QUICKATTACK],
			[20,:HYPNOSIS],
			[29,:FEINTATTACK],
			[38,:NIGHTMARE],
			[47,:DOUBLETEAM],
			[57,:HAZE],
			[66,:DARKVOID],
			[75,:NASTYPLOT],
			[84,:DREAMEATER],
			[93,:DARKPULSE]],
		:compatiblemoves => [:AERIALACE,:ASSURANCE,:BEATUP,:BLIZZARD,:BRICKBREAK,:CALMMIND,:CHARGEBEAM,:CUT,:DARKESTLARIAT,:DARKPULSE,:DRAINPUNCH,:DREAMEATER,:EMBARGO,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:FOULPLAY,:GIGAIMPACT,:HEADBUTT,:HYPERBEAM,:ICEBEAM,:ICYWIND,:INCINERATE,:KNOCKOFF,:LASHOUT,:LASTRESORT,:MUDSLAP,:MYSTICALFIRE,:NASTYPLOT,:NIGHTMARE,:OMINOUSWIND,:PAYBACK,:PHANTOMFORCE,:POISONJAB,:POLTERGEIST,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SLUDGEBOMB,:SNARL,:SNATCH,:SPITE,:STRENGTH,:SUCKERPUNCH,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:TAUNT,:THIEF,:THROATCHOP,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TORMENT,:TRICK,:WILLOWISP,:WONDERROOM,:XSCISSOR,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Black",
		:EggGroups => [:Undiscovered],
		:Height => 15,
		:Weight => 505,
		:kind => "Pitch-Black",
		:dexentry => "It can lull people to sleep and make them dream. It is active during nights of the new moon.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 9,
	},

	"Perfection" => {
		:Type2 => :GHOST,
		:BaseStats => [70, 90, 95, 165, 100, 170],
		:Abilities => [:BADDREAMS],
		:Weight => 1011,
	},

	:PerfectionForm => 1,
	:OnCreation => {},
},

:SHAYMIN => {
	"Land Forme" => {
		:name => "Shaymin",
		:dexnum => 492,
		:Type1 => :GRASS,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:NATURALCURE],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 45,
		:Happiness => 100,
		:EggSteps => 30855,
		:Moveset => [
			[1,:GROWTH],
			[10,:MAGICALLEAF],
			[19,:LEECHSEED],
			[28,:SYNTHESIS],
			[37,:SWEETSCENT],
			[46,:NATURALGIFT],
			[55,:WORRYSEED],
			[64,:AROMATHERAPY],
			[73,:ENERGYBALL],
			[82,:SWEETKISS],
			[91,:HEALINGWISH],
			[100,:SEEDFLARE]],
		:compatiblemoves => [:BULLETSEED,:CHARM,:COVET,:DAZZLINGGLEAM,:DEFENSECURL,:EARTHPOWER,:ENDEAVOR,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSWHISTLE,:HEADBUTT,:HYPERBEAM,:LASERFOCUS,:LASTRESORT,:LEAFSTORM,:LUCKYCHANT,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:PSYCHIC,:PSYCHUP,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Green",
		:EggGroups => [:Undiscovered],
		:Height => 2,
		:Weight => 21,
		:WildItemCommon => :LUMBERRY,
		:WildItemUncommon => :LUMBERRY,
		:WildItemRare => :LUMBERRY,
		:kind => "Gratitude",
		:dexentry => "It lives in flower patches and avoids detection by curling up to look like a flowering plant.",
		:BattlerPlayerY => 34,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 0,
	},

	"Sky Forme" => {
		:Type2 => :FLYING,
		:BaseStats => [100, 103, 75, 120, 75, 127],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:SERENEGRACE],
		:Moveset => [
			[1,:GROWTH],
			[10,:MAGICALLEAF],
			[19,:LEECHSEED],
			[28,:QUICKATTACK],
			[37,:SWEETSCENT],
			[46,:NATURALGIFT],
			[55,:WORRYSEED],
			[64,:AIRSLASH],
			[73,:ENERGYBALL],
			[82,:SWEETKISS],
			[91,:LEAFSTORM],
			[100,:SEEDFLARE],
		],
		:compatiblemoves => [:AIRCUTTER,:AIRSLASH,:BULLETSEED,:CHARM,:COVET,:DAZZLINGGLEAM,:ENERGYBALL,:FLASH,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:HEADBUTT,:HURRICANE,:HYPERBEAM,:LASERFOCUS,:LASTRESORT,:LEAFBLADE,:LEAFSTORM,:MAGICALLEAF,:MUDSLAP,:NATUREPOWER,:OMINOUSWIND,:PSYCHIC,:PSYCHUP,:SAFEGUARD,:SEEDBOMB,:SOLARBEAM,:SOLARBLADE,:SUNNYDAY,:SWIFT,:SWORDSDANCE,:SYNTHESIS,:TAILWIND,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Height => 4,
		:Weight => 52,
	},

	:OnCreation => {},
},

:ARCEUS => {
	"Normal" => {
		:name => "Arceus",
		:dexnum => 493,
		:Type1 => :NORMAL,
		:BaseStats => [120, 120, 120, 120, 120, 120],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:MULTITYPE],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 324,
		:CatchRate => 3,
		:Happiness => 0,
		:EggSteps => 30855,
		:Moveset => [
			[1,:SHADOWFORCE],
			[1,:ROAROFTIME],
			[1,:SPACIALREND],
			[1,:SEISMICTOSS],
			[1,:COSMICPOWER],
			[1,:NATURALGIFT],
			[1,:PUNISHMENT],
			[10,:GRAVITY],
			[20,:EARTHPOWER],
			[30,:HYPERVOICE],
			[40,:EXTREMESPEED],
			[50,:REFRESH],
			[60,:FUTURESIGHT],
			[70,:RECOVER],
			[80,:HYPERBEAM],
			[90,:PERISHSONG],
			[100,:JUDGMENT]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:AMNESIA,:ANCIENTPOWER,:AQUATAIL,:ASSURANCE,:AURASPHERE,:AVALANCHE,:BLASTBURN,:BLIZZARD,:BODYPRESS,:BODYSLAM,:BREAKINGSWIPE,:BRICKBREAK,:BRINE,:BULLDOZE,:BULLETSEED,:BURNINGJEALOUSY,:CALMMIND,:CHARGEBEAM,:CLOSECOMBAT,:COACHING,:COSMICPOWER,:CUT,:DARKESTLARIAT,:DARKPULSE,:DEFOG,:DIVE,:DRACOMETEOR,:DRAGONCLAW,:DRAGONPULSE,:DREAMEATER,:EARTHPOWER,:EARTHQUAKE,:ECHOEDVOICE,:ELECTROBALL,:ENERGYBALL,:EXPANDINGFORCE,:FIREBLAST,:FIRESPIN,:FLAMETHROWER,:FLAREBLITZ,:FLASH,:FLASHCANNON,:FLY,:FOCUSBLAST,:FOCUSENERGY,:FURYCUTTER,:FUTURESIGHT,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRAVITY,:GUARDSWAP,:HAIL,:HEADBUTT,:HEATCRASH,:HEATWAVE,:HEAVYSLAM,:HEX,:HIGHHORSEPOWER,:HONECLAWS,:HYDROCANNON,:HYPERBEAM,:HYPERVOICE,:ICEBEAM,:ICICLESPEAR,:ICYWIND,:IMPRISON,:INCINERATE,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:LASERFOCUS,:LASHOUT,:LASTRESORT,:LIGHTSCREEN,:LIQUIDATION,:MAGICALLEAF,:MAGICCOAT,:MEGAHORN,:METEORBEAM,:METRONOME,:MUDSLAP,:MYSTICALFIRE,:OMINOUSWIND,:OUTRAGE,:OVERHEAT,:PAYBACK,:PHANTOMFORCE,:PLAYROUGH,:POISONJAB,:POLTERGEIST,:POWERSWAP,:POWERWHIP,:PSYCHIC,:PSYCHOCUT,:PSYCHUP,:PSYSHOCK,:QUASH,:RAINDANCE,:RECYCLE,:REFLECT,:RETALIATE,:REVENGE,:REVERSAL,:RISINGVOLTAGE,:ROAR,:ROCKBLAST,:ROCKCLIMB,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SAFEGUARD,:SANDSTORM,:SCALESHOT,:SCORCHINGSANDS,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SHOCKWAVE,:SIGNALBEAM,:SILVERWIND,:SKITTERSMACK,:SLUDGEBOMB,:SNARL,:SOLARBEAM,:SOLARBLADE,:SPEEDSWAP,:STEALTHROCK,:STEELROLLER,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SURF,:SWIFT,:SWORDSDANCE,:TAILWIND,:TELEKINESIS,:TERRAINPULSE,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:TRIATTACK,:TRICK,:TRICKROOM,:TWISTER,:WATERFALL,:WATERPULSE,:WEATHERBALL,:WHIRLPOOL,:WILLOWISP,:WORKUP,:XSCISSOR,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Gray",
		:EggGroups => [:Undiscovered],
		:Height => 32,
		:Weight => 3200,
		:kind => "Alpha",
		:dexentry => "It is described in mythology as the Pokémon that shaped the universe with its 1,000 arms.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 6,
		:BattlerAltitude => 0,
	},

	"Fighting" => {
	},

	"Flying" => {
	},

	"Poison" => {
	},

	"Ground" => {
	},

	"Rock" => {
	},

	"Bug" => {
	},

	"Ghost" => {
	},

	"Steel" => {
	},

	"???" => {
	},

	"Fire" => {
	},

	"Water" => {
	},

	"Grass" => {
	},

	"Electric" => {
	},

	"Psychic" => {
	},

	"Ice" => {
	},

	"Dragon" => {
	},

	"Dark" => {
	},

	"Fairy" => {
	},

	:OnCreation => {},
},

:VICTINI => {
	"Normal Form" => {
		:name => "Victini",
		:dexnum => 494,
		:Type1 => :PSYCHIC,
		:Type2 => :FIRE,
		:BaseStats => [100, 100, 100, 100, 100, 100],
		:EVs => [3, 0, 0, 0, 0, 0],
		:Abilities => [:VICTORYSTAR],
		:GrowthRate => :Slow,
		:GenderRatio => :Genderless,
		:BaseEXP => 270,
		:CatchRate => 3,
		:Happiness => 100,
		:EggSteps => 30720,
		:Moveset => [
			[1,:SEARINGSHOT],
			[1,:VCREATE],
			[1,:FUSIONFLARE],
			[1,:FUSIONBOLT],
			[1,:BOLTSTRIKE],
			[1,:BLUEFLARE],
			[1,:GLACIATE],
			[1,:FOCUSENERGY],
			[1,:CONFUSION],
			[1,:INCINERATE],
			[1,:QUICKATTACK],
			[9,:ENDURE],
			[17,:HEADBUTT],
			[25,:FLAMECHARGE],
			[33,:REVERSAL],
			[41,:FLAMEBURST],
			[49,:ZENHEADBUTT],
			[57,:INFERNO],
			[65,:DOUBLEEDGE],
			[73,:FLAREBLITZ],
			[81,:FINALGAMBIT],
			[89,:STOREDPOWER],
			[97,:OVERHEAT]],
		:compatiblemoves => [:BATONPASS,:BLAZEKICK,:BOUNCE,:BRICKBREAK,:CHARGEBEAM,:DAZZLINGGLEAM,:EMBARGO,:ENCORE,:ENERGYBALL,:EXPANDINGFORCE,:FIREBLAST,:FIREPUNCH,:FIRESPIN,:FLAMEBURST,:FLAMETHROWER,:FLAREBLITZ,:FLASH,:FLING,:FOCUSBLAST,:FOCUSENERGY,:FUTURESIGHT,:GIGAIMPACT,:GRASSKNOT,:GUARDSWAP,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:MAGICCOAT,:MEGAKICK,:MEGAPUNCH,:MYSTICALFIRE,:OVERHEAT,:POWERSWAP,:POWERUPPUNCH,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:REVERSAL,:ROCKSMASH,:ROLEPLAY,:SAFEGUARD,:SCORCHINGSANDS,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:SOLARBEAM,:SPEEDSWAP,:STOREDPOWER,:SUNNYDAY,:SWIFT,:TAUNT,:TELEKINESIS,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:THUNDERWAVE,:TRICK,:TRICKROOM,:UPROAR,:UTURN,:WILDCHARGE,:WILLOWISP,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [:ATTRACT,:CAPTIVATE,],
		:Color => "Yellow",
		:EggGroups => [:Undiscovered],
		:Height => 4,
		:Weight => 40,
		:kind => "Victory",
		:dexentry => "It creates an unlimited supply of energy inside its body, which it shares with those who touch it.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 20,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:SNIVY => {
	"Normal Form" => {
		:name => "Snivy",
		:dexnum => 495,
		:Type1 => :GRASS,
		:BaseStats => [45, 45, 55, 45, 55, 63],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:OVERGROW, :CONTRARY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:CAPTIVATE,:GLARE,:GRASSYTERRAIN,:IRONTAIL,:MAGICALLEAF,:MEANLOOK,:MIRRORCOAT,:NATURALGIFT,:PURSUIT,:SWEETSCENT,:TWISTER,],
		:Moveset => [
			[1,:TACKLE],
			[4,:LEER],
			[7,:VINEWHIP],
			[10,:WRAP],
			[13,:GROWTH],
			[16,:LEAFTORNADO],
			[19,:LEECHSEED],
			[22,:MEGADRAIN],
			[25,:SLAM],
			[28,:LEAFBLADE],
			[31,:COIL],
			[34,:GIGADRAIN],
			[37,:WRINGOUT],
			[40,:GASTROACID],
			[43,:LEAFSTORM]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BIND,:CALMMIND,:CUT,:DEFOG,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:NATUREPOWER,:REFLECT,:SAFEGUARD,:SEEDBOMB,:SNATCH,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:TAUNT,:TORMENT,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field, :Grass],
		:Height => 6,
		:Weight => 81,
		:kind => "Grass Snake",
		:dexentry => "They photosynthesize by bathing their tails in sunlight. When they are not feeling well, their tails droop.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 33,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SERVINE,:Level,17]
		]
	},

	:OnCreation => {},
},

:SERVINE => {
	"Normal Form" => {
		:name => "Servine",
		:dexnum => 496,
		:Type1 => :GRASS,
		:BaseStats => [60, 60, 75, 60, 75, 83],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:OVERGROW, :CONTRARY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 145,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :SNIVY,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:LEER],
			[1,:VINEWHIP],
			[1,:WRAP],
			[4,:LEER],
			[7,:VINEWHIP],
			[10,:WRAP],
			[13,:GROWTH],
			[16,:LEAFTORNADO],
			[20,:LEECHSEED],
			[24,:MEGADRAIN],
			[28,:SLAM],
			[32,:LEAFBLADE],
			[36,:COIL],
			[40,:GIGADRAIN],
			[44,:WRINGOUT],
			[48,:GASTROACID],
			[52,:LEAFSTORM]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BIND,:CALMMIND,:CUT,:DEFOG,:ENERGYBALL,:FLASH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:NATUREPOWER,:REFLECT,:SAFEGUARD,:SEEDBOMB,:SNATCH,:SOLARBEAM,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:TAUNT,:TORMENT,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field, :Grass],
		:Height => 8,
		:Weight => 160,
		:kind => "Grass Snake",
		:dexentry => "They avoid attacks by sinking into the shadows of thick foliage. They retaliate with masterful whipping techniques.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SERPERIOR,:Level,36]
		]
	},

	:OnCreation => {},
},

:SERPERIOR => {
	"Normal Form" => {
		:name => "Serperior",
		:dexnum => 497,
		:Type1 => :GRASS,
		:BaseStats => [75, 75, 95, 75, 95, 113],
		:EVs => [0, 0, 0, 0, 0, 3],
		:Abilities => [:OVERGROW, :CONTRARY],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 238,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :SERVINE,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:LEER],
			[1,:VINEWHIP],
			[1,:WRAP],
			[4,:LEER],
			[7,:VINEWHIP],
			[10,:WRAP],
			[13,:GROWTH],
			[16,:LEAFTORNADO],
			[20,:LEECHSEED],
			[24,:MEGADRAIN],
			[28,:SLAM],
			[32,:LEAFBLADE],
			[38,:COIL],
			[44,:GIGADRAIN],
			[50,:WRINGOUT],
			[56,:GASTROACID],
			[62,:LEAFSTORM]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BIND,:BODYSLAM,:BREAKINGSWIPE,:BRUTALSWING,:CALMMIND,:CUT,:DEFOG,:DRAGONPULSE,:DRAGONTAIL,:ENERGYBALL,:FLASH,:FRENZYPLANT,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LIGHTSCREEN,:MAGICALLEAF,:NATUREPOWER,:OUTRAGE,:REFLECT,:ROCKSMASH,:SAFEGUARD,:SEEDBOMB,:SNATCH,:SOLARBEAM,:SOLARBLADE,:STRENGTH,:SUNNYDAY,:SWORDSDANCE,:SYNTHESIS,:TAUNT,:TORMENT,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field, :Grass],
		:Height => 33,
		:Weight => 630,
		:kind => "Regal",
		:dexentry => "They raise their heads to intimidate opponents but only give it their all when fighting a powerful opponent.",
		:BattlerPlayerY => 12,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:TEPIG => {
	"Normal Form" => {
		:name => "Tepig",
		:dexnum => 498,
		:Type1 => :FIRE,
		:BaseStats => [65, 63, 45, 45, 45, 45],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:BLAZE, :THICKFAT],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:BODYSLAM,:BURNUP,:COVET,:CURSE,:ENDEAVOR,:HEAVYSLAM,:MAGNITUDE,:SLEEPTALK,:SUCKERPUNCH,:SUPERPOWER,:THRASH,:YAWN,],
		:Moveset => [
			[1,:TACKLE],
			[3,:TAILWHIP],
			[7,:EMBER],
			[9,:ODORSLEUTH],
			[13,:DEFENSECURL],
			[15,:FLAMECHARGE],
			[19,:SMOG],
			[21,:ROLLOUT],
			[25,:TAKEDOWN],
			[27,:HEATCRASH],
			[31,:ASSURANCE],
			[33,:FLAMETHROWER],
			[37,:HEADSMASH],
			[39,:ROAR],
			[43,:FLAREBLITZ]],
		:compatiblemoves => [:COVET,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FLAMECHARGE,:FLAMETHROWER,:GRASSKNOT,:GYROBALL,:HEATWAVE,:HELPINGHAND,:INCINERATE,:IRONTAIL,:OVERHEAT,:ROAR,:ROCKSMASH,:ROCKTOMB,:SOLARBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:TAUNT,:WILDCHARGE,:WILLOWISP,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 99,
		:kind => "Fire Pig",
		:dexentry => "It blows fire through its nose. When it catches a cold, the fire becomes pitch-black smoke instead.",
		:BattlerPlayerY => 31,
		:BattlerEnemyY => 35,
		:BattlerAltitude => 0,
		:evolutions => [
			[:PIGNITE,:Level,17]
		]
	},

	:OnCreation => {},
},

:PIGNITE => {
	"Normal Form" => {
		:name => "Pignite",
		:dexnum => 499,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [90, 93, 55, 70, 55, 55],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:BLAZE, :THICKFAT],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 146,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :TEPIG,
			:form => 0
		},
		:Moveset => [
			[0,:ARMTHRUST],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:EMBER],
			[1,:ODORSLEUTH],
			[3,:TAILWHIP],
			[7,:EMBER],
			[9,:ODORSLEUTH],
			[13,:DEFENSECURL],
			[15,:FLAMECHARGE],
			[20,:SMOG],
			[23,:ROLLOUT],
			[28,:TAKEDOWN],
			[31,:HEATCRASH],
			[36,:ASSURANCE],
			[39,:FLAMETHROWER],
			[44,:HEADSMASH],
			[47,:ROAR],
			[52,:FLAREBLITZ]],
		:compatiblemoves => [:BRICKBREAK,:BULLDOZE,:COVET,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GRASSKNOT,:GYROBALL,:HEATWAVE,:HELPINGHAND,:INCINERATE,:IRONTAIL,:LOWKICK,:LOWSWEEP,:OVERHEAT,:POISONJAB,:POWERUPPUNCH,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCARYFACE,:SOLARBEAM,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:TAUNT,:THUNDERPUNCH,:WILDCHARGE,:WILLOWISP,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 555,
		:kind => "Fire Pig",
		:dexentry => "Whatever it eats becomes fuel for the flame in its stomach. When it is angered, the intensity of the flame increases.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 30,
		:BattlerAltitude => 0,
		:evolutions => [
			[:EMBOAR,:Level,36]
		]
	},

	:OnCreation => {},
},

:EMBOAR => {
	"Normal Form" => {
		:name => "Emboar",
		:dexnum => 500,
		:Type1 => :FIRE,
		:Type2 => :FIGHTING,
		:BaseStats => [110, 123, 65, 100, 65, 65],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:BLAZE, :RECKLESS],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 238,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PIGNITE,
			:form => 0
		},
		:Moveset => [
			[0,:ARMTHRUST],
			[1,:HAMMERARM],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:EMBER],
			[1,:ODORSLEUTH],
			[3,:TAILWHIP],
			[7,:EMBER],
			[9,:ODORSLEUTH],
			[13,:DEFENSECURL],
			[15,:FLAMECHARGE],
			[20,:SMOG],
			[23,:ROLLOUT],
			[28,:TAKEDOWN],
			[31,:HEATCRASH],
			[38,:ASSURANCE],
			[43,:FLAMETHROWER],
			[50,:HEADSMASH],
			[55,:ROAR],
			[62,:FLAREBLITZ]],
		:compatiblemoves => [:BLASTBURN,:BLOCK,:BODYPRESS,:BODYSLAM,:BRICKBREAK,:BULKUP,:BULLDOZE,:BURNINGJEALOUSY,:CLOSECOMBAT,:COACHING,:COVET,:EARTHQUAKE,:ECHOEDVOICE,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GYROBALL,:HEATWAVE,:HELPINGHAND,:HYPERBEAM,:INCINERATE,:IRONHEAD,:IRONTAIL,:LOWKICK,:LOWSWEEP,:OVERHEAT,:POISONJAB,:POWERUPPUNCH,:ROAR,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:SCALD,:SMACKDOWN,:SOLARBEAM,:STOMPINGTANTRUM,:STONEEDGE,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:TAUNT,:THUNDERPUNCH,:WILDCHARGE,:WILLOWISP,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Field],
		:Height => 16,
		:Weight => 1500,
		:kind => "Mega Fire Pig",
		:dexentry => "It has mastered fast and powerful fighting moves. It grows a beard of fire.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:OSHAWOTT => {
	"Normal Form" => {
		:name => "Oshawott",
		:dexnum => 501,
		:Type1 => :WATER,
		:BaseStats => [55, 55, 45, 63, 45, 45],
		:EVs => [0, 0, 0, 1, 0, 0],
		:Abilities => [:TORRENT, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 62,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:AIRSLASH,:ASSURANCE,:BRINE,:COPYCAT,:DETECT,:NIGHTSLASH,:SACREDSWORD,:SCREECH,:TRUMPCARD,],
		:Moveset => [
			[1,:TACKLE],
			[5,:TAILWHIP],
			[7,:WATERGUN],
			[11,:WATERSPORT],
			[13,:FOCUSENERGY],
			[17,:RAZORSHELL],
			[19,:FURYCUTTER],
			[23,:WATERPULSE],
			[25,:REVENGE],
			[29,:AQUAJET],
			[31,:ENCORE],
			[35,:AQUATAIL],
			[37,:RETALIATE],
			[41,:SWORDSDANCE],
			[43,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BLIZZARD,:COVET,:CUT,:DIG,:DIVE,:FALSESWIPE,:FLING,:GRASSKNOT,:HAIL,:HELPINGHAND,:ICEBEAM,:ICYWIND,:IRONTAIL,:RAINDANCE,:ROCKSMASH,:SCALD,:SURF,:SWORDSDANCE,:TAUNT,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 59,
		:kind => "Sea Otter",
		:dexentry => "The scalchop on its stomach is made from the same element as claws. It detaches the scalchop for use as a blade.",
		:BattlerPlayerY => 30,
		:BattlerEnemyY => 32,
		:BattlerAltitude => 0,
		:evolutions => [
			[:DEWOTT,:Level,17]
		]
	},

	:OnCreation => {},
},

:DEWOTT => {
	"Normal Form" => {
		:name => "Dewott",
		:dexnum => 502,
		:Type1 => :WATER,
		:BaseStats => [75, 75, 60, 83, 60, 60],
		:EVs => [0, 0, 0, 2, 0, 0],
		:Abilities => [:TORRENT, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 145,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :OSHAWOTT,
			:form => 0
		},
		:Moveset => [
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:WATERGUN],
			[1,:WATERSPORT],
			[5,:TAILWHIP],
			[7,:WATERGUN],
			[11,:WATERSPORT],
			[13,:FOCUSENERGY],
			[18,:RAZORSHELL],
			[21,:FURYCUTTER],
			[26,:WATERPULSE],
			[29,:REVENGE],
			[34,:AQUAJET],
			[37,:ENCORE],
			[42,:AQUATAIL],
			[45,:RETALIATE],
			[50,:SWORDSDANCE],
			[53,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:AQUATAIL,:BLIZZARD,:COVET,:CUT,:DIG,:DIVE,:FALSESWIPE,:FLING,:GRASSKNOT,:HAIL,:HELPINGHAND,:ICEBEAM,:ICYWIND,:IRONTAIL,:RAINDANCE,:ROCKSMASH,:SCALD,:SURF,:SWORDSDANCE,:TAUNT,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 8,
		:Weight => 245,
		:kind => "Discipline",
		:dexentry => "Scalchop techniques differ from one Dewott to another. It never neglects maintaining its scalchops.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SAMUROTT,:Level,36]
		]
	},

	:OnCreation => {},
},

:SAMUROTT => {
	"Normal Form" => {
		:name => "Samurott",
		:dexnum => 503,
		:Type1 => :WATER,
		:BaseStats => [95, 100, 85, 108, 70, 70],
		:EVs => [0, 0, 0, 3, 0, 0],
		:Abilities => [:TORRENT, :SHELLARMOR],
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemEighth,
		:BaseEXP => 238,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :DEWOTT,
			:form => 0
		},
		:Moveset => [
			[0,:SLASH],
			[1,:MEGAHORN],
			[1,:TACKLE],
			[1,:TAILWHIP],
			[1,:WATERGUN],
			[1,:WATERSPORT],
			[5,:TAILWHIP],
			[7,:WATERGUN],
			[11,:WATERSPORT],
			[13,:FOCUSENERGY],
			[18,:RAZORSHELL],
			[21,:FURYCUTTER],
			[25,:WATERPULSE],
			[29,:REVENGE],
			[34,:AQUAJET],
			[39,:ENCORE],
			[46,:AQUATAIL],
			[51,:RETALIATE],
			[58,:SWORDSDANCE],
			[63,:HYDROPUMP]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:AQUATAIL,:ASSURANCE,:BLIZZARD,:BLOCK,:BODYSLAM,:BRINE,:COVET,:CUT,:DIG,:DIVE,:DRAGONTAIL,:FALSESWIPE,:FLING,:FLIPTURN,:GIGAIMPACT,:GRASSKNOT,:HAIL,:HELPINGHAND,:HYDROCANNON,:HYPERBEAM,:ICEBEAM,:ICEFANG,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LIQUIDATION,:RAINDANCE,:ROCKSMASH,:SCALD,:SMARTSTRIKE,:STRENGTH,:SUPERPOWER,:SURF,:SWORDSDANCE,:TAUNT,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,:XSCISSOR,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 15,
		:Weight => 946,
		:kind => "Formidable",
		:dexentry => "Part of the armor on its anterior legs becomes a giant sword. Its cry alone is enough to intimidate most enemies.",
		:BattlerPlayerY => 9,
		:BattlerEnemyY => 14,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PATRAT => {
	"Normal Form" => {
		:name => "Patrat",
		:dexnum => 504,
		:Type1 => :NORMAL,
		:BaseStats => [45, 55, 39, 35, 39, 42],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:RUNAWAY, :KEENEYE],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 51,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 3840,
		:EggMoves => [:ASSURANCE,:BULLETSEED,:FLAIL,:FORESIGHT,:IRONTAIL,:PURSUIT,:REVENGE,:SCREECH,:TEARFULLOOK,],
		:Moveset => [
			[1,:TACKLE],
			[3,:LEER],
			[6,:BITE],
			[8,:BIDE],
			[11,:DETECT],
			[13,:SANDATTACK],
			[16,:CRUNCH],
			[18,:HYPNOSIS],
			[21,:SUPERFANG],
			[23,:AFTERYOU],
			[26,:FOCUSENERGY],
			[28,:WORKUP],
			[31,:HYPERFANG],
			[33,:NASTYPLOT],
			[36,:MEANLOOK],
			[38,:BATONPASS],
			[41,:SLAM]],
		:compatiblemoves => [:AFTERYOU,:AQUATAIL,:COVET,:CUT,:DIG,:ENDEAVOR,:FLING,:GRASSKNOT,:GUNKSHOT,:HELPINGHAND,:IRONTAIL,:LASERFOCUS,:LASTRESORT,:LOWKICK,:RAINDANCE,:RETALIATE,:SEEDBOMB,:SHADOWBALL,:SHOCKWAVE,:SUNNYDAY,:SUPERFANG,:SWORDSDANCE,:THUNDERBOLT,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 5,
		:Weight => 116,
		:kind => "Scout",
		:dexentry => "Extremely cautious, they take shifts to maintain a constant watch of their nest. They feel insecure without a lookout.",
		:BattlerPlayerY => 29,
		:BattlerEnemyY => 29,
		:BattlerAltitude => 0,
		:evolutions => [
			[:WATCHOG,:Level,20]
		]
	},

	:OnCreation => {},
},

:WATCHOG => {
	"Normal Form" => {
		:name => "Watchog",
		:dexnum => 505,
		:Type1 => :NORMAL,
		:BaseStats => [60, 85, 69, 60, 69, 77],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:ILLUMINATE, :KEENEYE],
		:HiddenAbilities => :ANALYTIC,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 147,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PATRAT,
			:form => 0
		},
		:Moveset => [
			[0,:CONFUSERAY],
			[1,:ROTOTILLER],
			[1,:TACKLE],
			[1,:LEER],
			[1,:BITE],
			[1,:LOWKICK],
			[3,:LEER],
			[6,:BITE],
			[8,:BIDE],
			[11,:DETECT],
			[13,:SANDATTACK],
			[16,:CRUNCH],
			[18,:HYPNOSIS],
			[22,:SUPERFANG],
			[25,:AFTERYOU],
			[29,:FOCUSENERGY],
			[32,:PSYCHUP],
			[36,:HYPERFANG],
			[39,:NASTYPLOT],
			[43,:MEANLOOK],
			[46,:BATONPASS],
			[50,:SLAM]],
		:compatiblemoves => [:AFTERYOU,:AQUATAIL,:COVET,:CUT,:DIG,:DREAMEATER,:ENCORE,:ENDEAVOR,:FIREFANG,:FIREPUNCH,:FLAMETHROWER,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HELPINGHAND,:HYPERBEAM,:ICEFANG,:ICEPUNCH,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASTRESORT,:LIGHTSCREEN,:LOWKICK,:MEGAPUNCH,:POWERUPPUNCH,:PSYCHICFANGS,:PSYCHUP,:RAINDANCE,:RETALIATE,:ROCKSMASH,:SEEDBOMB,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERFANG,:SWORDSDANCE,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERPUNCH,:THUNDERWAVE,:TRIATTACK,:WORKUP,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 270,
		:kind => "Lookout",
		:dexentry => "They make the patterns on their bodies shine in order to threaten predators. Keen eyesight lets them see in the dark.",
		:BattlerPlayerY => 15,
		:BattlerEnemyY => 15,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:LILLIPUP => {
	"Normal Form" => {
		:name => "Lillipup",
		:dexnum => 506,
		:Type1 => :NORMAL,
		:BaseStats => [45, 60, 45, 25, 45, 55],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:VITALSPIRIT, :PICKUP],
		:HiddenAbilities => :RUNAWAY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 55,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 3840,
		:EggMoves => [:AFTERYOU,:CHARM,:ENDURE,:FIREFANG,:HOWL,:ICEFANG,:LICK,:MUDSLAP,:PSYCHICFANGS,:PURSUIT,:SANDATTACK,:THUNDERFANG,:YAWN,],
		:Moveset => [
			[1,:LEER],
			[1,:TACKLE],
			[5,:ODORSLEUTH],
			[8,:BITE],
			[10,:BABYDOLLEYES],
			[12,:HELPINGHAND],
			[15,:TAKEDOWN],
			[19,:WORKUP],
			[22,:CRUNCH],
			[26,:ROAR],
			[29,:RETALIATE],
			[33,:REVERSAL],
			[36,:LASTRESORT],
			[40,:GIGAIMPACT],
			[45,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:CHARM,:CRUNCH,:DIG,:FIREFANG,:GIGAIMPACT,:HELPINGHAND,:HYPERVOICE,:ICEFANG,:PAYBACK,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKSMASH,:ROCKTOMB,:SHADOWBALL,:SHOCKWAVE,:SNARL,:SUNNYDAY,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:WILDCHARGE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Brown",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 41,
		:kind => "Puppy",
		:dexentry => "The long hair around its face provides an amazing radar that lets it sense subtle changes in its surroundings.",
		:BattlerPlayerY => 27,
		:BattlerEnemyY => 30,
		:BattlerAltitude => 0,
		:evolutions => [
			[:HERDIER,:Level,16]
		]
	},

	:OnCreation => {},
},

:HERDIER => {
	"Normal Form" => {
		:name => "Herdier",
		:dexnum => 507,
		:Type1 => :NORMAL,
		:BaseStats => [65, 80, 65, 35, 65, 60],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :SANDRUSH],
		:HiddenAbilities => :SCRAPPY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 130,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 3840,
		:preevo => {
			:species => :LILLIPUP,
			:form => 0
		},
		:Moveset => [
			[1,:LEER],
			[1,:TACKLE],
			[1,:ODORSLEUTH],
			[1,:BITE],
			[5,:ODORSLEUTH],
			[8,:BITE],
			[12,:HELPINGHAND],
			[15,:TAKEDOWN],
			[20,:WORKUP],
			[24,:CRUNCH],
			[29,:ROAR],
			[33,:RETALIATE],
			[38,:REVERSAL],
			[42,:LASTRESORT],
			[47,:GIGAIMPACT],
			[52,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:CHARM,:CRUNCH,:DIG,:FIREFANG,:GIGAIMPACT,:HELPINGHAND,:HYPERVOICE,:ICEFANG,:PAYBACK,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKSMASH,:ROCKTOMB,:SHADOWBALL,:SHOCKWAVE,:SNARL,:STRENGTH,:SUNNYDAY,:SURF,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:WILDCHARGE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Field],
		:Height => 9,
		:Weight => 147,
		:kind => "Loyal Dog",
		:dexentry => "It loyally follows its Trainer's orders. For ages, they have helped Trainers raise Pokémon.",
		:BattlerPlayerY => 21,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:STOUTLAND,:Level,32]
		]
	},

	:OnCreation => {},
},

:STOUTLAND => {
	"Normal Form" => {
		:name => "Stoutland",
		:dexnum => 508,
		:Type1 => :NORMAL,
		:BaseStats => [85, 110, 90, 45, 90, 80],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:INTIMIDATE, :SANDRUSH],
		:HiddenAbilities => :SCRAPPY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 225,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 3840,
		:preevo => {
			:species => :HERDIER,
			:form => 0
		},
		:Moveset => [
			[1,:ICEFANG],
			[1,:FIREFANG],
			[1,:THUNDERFANG],
			[1,:LEER],
			[1,:TACKLE],
			[1,:ODORSLEUTH],
			[1,:BITE],
			[5,:ODORSLEUTH],
			[8,:BITE],
			[12,:HELPINGHAND],
			[15,:TAKEDOWN],
			[20,:WORKUP],
			[24,:CRUNCH],
			[29,:ROAR],
			[36,:RETALIATE],
			[42,:REVERSAL],
			[51,:LASTRESORT],
			[59,:GIGAIMPACT],
			[63,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:CHARM,:CRUNCH,:DIG,:FIREFANG,:GIGAIMPACT,:HELPINGHAND,:HYPERBEAM,:HYPERVOICE,:ICEFANG,:IRONHEAD,:PAYBACK,:PLAYROUGH,:PSYCHICFANGS,:RAINDANCE,:RETALIATE,:REVERSAL,:ROCKSMASH,:ROCKTOMB,:SHADOWBALL,:SHOCKWAVE,:SNARL,:STOMPINGTANTRUM,:STRENGTH,:SUNNYDAY,:SUPERPOWER,:SURF,:THUNDER,:THUNDERBOLT,:THUNDERFANG,:THUNDERWAVE,:UPROAR,:WILDCHARGE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Field],
		:Height => 12,
		:Weight => 610,
		:kind => "Big-Hearted",
		:dexentry => "This extremely wise Pokémon excels at rescuing people stranded at sea or in the mountains.",
		:BattlerPlayerY => 16,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PURRLOIN => {
	"Normal Form" => {
		:name => "Purrloin",
		:dexnum => 509,
		:Type1 => :DARK,
		:BaseStats => [41, 50, 37, 50, 37, 66],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:LIMBER, :UNBURDEN],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 56,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:CHARM,:COPYCAT,:COVET,:ENCORE,:FAKETEARS,:FEINTATTACK,:FOULPLAY,:PAYDAY,:YAWN,],
		:Moveset => [
			[1,:SCRATCH],
			[3,:GROWL],
			[6,:ASSIST],
			[10,:SANDATTACK],
			[12,:FURYSWIPES],
			[15,:PURSUIT],
			[19,:TORMENT],
			[21,:FAKEOUT],
			[24,:HONECLAWS],
			[28,:ASSURANCE],
			[30,:SLASH],
			[33,:CAPTIVATE],
			[37,:NIGHTSLASH],
			[39,:SNATCH],
			[42,:NASTYPLOT],
			[46,:SUCKERPUNCH],
			[49,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:ASSURANCE,:BATONPASS,:CHARM,:CUT,:DARKPULSE,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:ENCORE,:FAKETEARS,:FOULPLAY,:GRASSKNOT,:GUNKSHOT,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASHOUT,:NASTYPLOT,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHUP,:RAINDANCE,:ROLEPLAY,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SNARL,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAUNT,:THIEF,:THUNDERWAVE,:TRICK,:UTURN,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Field],
		:Height => 4,
		:Weight => 101,
		:kind => "Devious",
		:dexentry => "Its cute act is a ruse. When victims let down their guard, they find their items taken. It attacks with sharp claws.",
		:BattlerPlayerY => 24,
		:BattlerEnemyY => 25,
		:BattlerAltitude => 0,
		:evolutions => [
			[:LIEPARD,:Level,20]
		]
	},

	:OnCreation => {},
},

:LIEPARD => {
	"Normal Form" => {
		:name => "Liepard",
		:dexnum => 510,
		:Type1 => :DARK,
		:BaseStats => [64, 88, 50, 88, 50, 106],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:LIMBER, :UNBURDEN],
		:HiddenAbilities => :PRANKSTER,
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 156,
		:CatchRate => 90,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PURRLOIN,
			:form => 0
		},
		:Moveset => [
			[1,:SCRATCH],
			[1,:GROWL],
			[1,:ASSIST],
			[1,:SANDATTACK],
			[3,:GROWL],
			[6,:ASSIST],
			[10,:SANDATTACK],
			[12,:FURYSWIPES],
			[15,:PURSUIT],
			[19,:TORMENT],
			[22,:FAKEOUT],
			[26,:HONECLAWS],
			[31,:ASSURANCE],
			[34,:SLASH],
			[38,:TAUNT],
			[43,:NIGHTSLASH],
			[47,:SNATCH],
			[50,:NASTYPLOT],
			[55,:SUCKERPUNCH],
			[58,:PLAYROUGH]],
		:compatiblemoves => [:AERIALACE,:ASSURANCE,:BATONPASS,:BURNINGJEALOUSY,:CHARM,:CUT,:DARKPULSE,:DREAMEATER,:ECHOEDVOICE,:EMBARGO,:ENCORE,:FAKETEARS,:FOULPLAY,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HYPERBEAM,:HYPERVOICE,:IRONTAIL,:KNOCKOFF,:LASERFOCUS,:LASHOUT,:NASTYPLOT,:PAYBACK,:PAYDAY,:PLAYROUGH,:PSYCHOCUT,:PSYCHUP,:RAINDANCE,:ROCKSMASH,:ROLEPLAY,:SCREECH,:SEEDBOMB,:SHADOWBALL,:SHADOWCLAW,:SKITTERSMACK,:SNARL,:SNATCH,:SPITE,:SUNNYDAY,:SWIFT,:TAUNT,:THIEF,:THROATCHOP,:THUNDERWAVE,:TRICK,:UTURN,],
		:moveexceptions => [],
		:Color => "Purple",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 375,
		:kind => "Cruel",
		:dexentry => "Stealthily, it sneaks up on its target, striking from behind before its victim has a chance to react.",
		:BattlerPlayerY => 17,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PANSAGE => {
	"Normal Form" => {
		:name => "Pansage",
		:dexnum => 511,
		:Type1 => :GRASS,
		:BaseStats => [50, 53, 48, 53, 48, 64],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:GLUTTONY, :OVERGROW],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:ASTONISH,:BULLETSEED,:COVET,:DISARMINGVOICE,:GRASSWHISTLE,:LEAFSTORM,:LOWKICK,:MAGICALLEAF,:NASTYPLOT,:ROLEPLAY,:SPIKYSHIELD,:TICKLE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:PLAYNICE],
			[4,:LEER],
			[7,:LICK],
			[10,:VINEWHIP],
			[13,:FURYSWIPES],
			[16,:LEECHSEED],
			[19,:BITE],
			[22,:SEEDBOMB],
			[25,:TORMENT],
			[28,:FLING],
			[31,:ACROBATICS],
			[34,:GRASSKNOT],
			[37,:RECYCLE],
			[40,:NATURALGIFT],
			[43,:CRUNCH]],
		:compatiblemoves => [:ACROBATICS,:COVET,:CUT,:DIG,:ENDEAVOR,:ENERGYBALL,:FLASH,:FLING,:FOCUSPUNCH,:GASTROACID,:GIGADRAIN,:GRASSKNOT,:GRASSPLEDGE,:GUNKSHOT,:HELPINGHAND,:HONECLAWS,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:NATUREPOWER,:PAYBACK,:RECYCLE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEEDBOMB,:SHADOWCLAW,:SOLARBEAM,:SUNNYDAY,:SUPERPOWER,:SYNTHESIS,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 105,
		:kind => "Grass Monkey",
		:dexentry => "It shares the leaf on its head with weary-looking Pokémon. These leaves are known to relieve stress.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 30,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SIMISAGE,:Item,:LEAFSTONE]
		]
	},

	:OnCreation => {},
},

:SIMISAGE => {
	"Normal Form" => {
		:name => "Simisage",
		:dexnum => 512,
		:Type1 => :GRASS,
		:BaseStats => [75, 98, 63, 98, 63, 101],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:GLUTTONY, :OVERGROW],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 174,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PANSAGE,
			:form => 0
		},
		:Moveset => [
			[1,:LEER],
			[1,:LICK],
			[1,:FURYSWIPES],
			[1,:SEEDBOMB]],
		:compatiblemoves => [:ACROBATICS,:BRICKBREAK,:BULLETSEED,:COVET,:CUT,:DIG,:ENDEAVOR,:ENERGYBALL,:FLASH,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GASTROACID,:GIGADRAIN,:GIGAIMPACT,:GRASSKNOT,:GRASSPLEDGE,:GUNKSHOT,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:NATUREPOWER,:PAYBACK,:POWERUPPUNCH,:RECYCLE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SEEDBOMB,:SHADOWCLAW,:SOLARBEAM,:SUNNYDAY,:SUPERPOWER,:SYNTHESIS,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:UPROAR,:WORKUP,:WORRYSEED,],
		:moveexceptions => [],
		:Color => "Green",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 305,
		:kind => "Thorn Monkey",
		:dexentry => "It attacks enemies with strikes of its thorn-covered tail. This Pokémon is wild tempered.",
		:BattlerPlayerY => 13,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PANSEAR => {
	"Normal Form" => {
		:name => "Pansear",
		:dexnum => 513,
		:Type1 => :FIRE,
		:BaseStats => [50, 53, 48, 53, 48, 64],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:GLUTTONY, :BLAZE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:ASTONISH,:BELCH,:COVET,:DISARMINGVOICE,:FIREPUNCH,:FIRESPIN,:FLAREBLITZ,:HEATWAVE,:LOWKICK,:NASTYPLOT,:ROLEPLAY,:SLEEPTALK,:TICKLE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:PLAYNICE],
			[4,:LEER],
			[7,:LICK],
			[10,:INCINERATE],
			[13,:FURYSWIPES],
			[16,:YAWN],
			[19,:BITE],
			[22,:FLAMEBURST],
			[25,:AMNESIA],
			[28,:FLING],
			[31,:ACROBATICS],
			[34,:FIREBLAST],
			[37,:RECYCLE],
			[40,:NATURALGIFT],
			[43,:CRUNCH]],
		:compatiblemoves => [:ACROBATICS,:COVET,:CUT,:DIG,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSPUNCH,:GASTROACID,:GRASSKNOT,:GUNKSHOT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:OVERHEAT,:PAYBACK,:RECYCLE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SHADOWCLAW,:SOLARBEAM,:SUNNYDAY,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 110,
		:kind => "High Temp",
		:dexentry => "This Pokémon lives in caves in volcanoes. The fire within the tuft on its head can reach 600º F.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SIMISEAR,:Item,:FIRESTONE]
		]
	},

	:OnCreation => {},
},

:SIMISEAR => {
	"Normal Form" => {
		:name => "Simisear",
		:dexnum => 514,
		:Type1 => :FIRE,
		:BaseStats => [75, 98, 63, 98, 63, 101],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:GLUTTONY, :BLAZE],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 174,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PANSEAR,
			:form => 0
		},
		:Moveset => [
			[1,:LEER],
			[1,:LICK],
			[1,:FURYSWIPES],
			[1,:FLAMEBURST]],
		:compatiblemoves => [:ACROBATICS,:BODYSLAM,:BRICKBREAK,:COVET,:CUT,:DIG,:ENDEAVOR,:FIREBLAST,:FIREPLEDGE,:FIREPUNCH,:FIRESPIN,:FLAMECHARGE,:FLAMETHROWER,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GASTROACID,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HEATWAVE,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:MEGAPUNCH,:OVERHEAT,:PAYBACK,:POWERUPPUNCH,:RECYCLE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SHADOWCLAW,:SOLARBEAM,:SUNNYDAY,:SUPERPOWER,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:UPROAR,:WILLOWISP,:WORKUP,],
		:moveexceptions => [],
		:Color => "Red",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 280,
		:kind => "Ember",
		:dexentry => "A flame burns inside its body. It scatters embers from its head and tail to sear its opponents.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 23,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:PANPOUR => {
	"Normal Form" => {
		:name => "Panpour",
		:dexnum => 515,
		:Type1 => :WATER,
		:BaseStats => [50, 53, 48, 53, 48, 64],
		:EVs => [0, 0, 0, 0, 0, 1],
		:Abilities => [:GLUTTONY, :TORRENT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 63,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 5120,
		:EggMoves => [:AQUARING,:AQUATAIL,:ASTONISH,:COVET,:DISARMINGVOICE,:HYDROPUMP,:LOWKICK,:MUDSPORT,:NASTYPLOT,:ROLEPLAY,:TICKLE,],
		:Moveset => [
			[1,:SCRATCH],
			[1,:PLAYNICE],
			[4,:LEER],
			[7,:LICK],
			[10,:WATERGUN],
			[13,:FURYSWIPES],
			[16,:WATERSPORT],
			[19,:BITE],
			[22,:SCALD],
			[25,:TAUNT],
			[28,:FLING],
			[31,:ACROBATICS],
			[34,:BRINE],
			[37,:RECYCLE],
			[40,:NATURALGIFT],
			[43,:CRUNCH]],
		:compatiblemoves => [:ACROBATICS,:AQUATAIL,:BLIZZARD,:COVET,:CUT,:DIG,:DIVE,:ENDEAVOR,:FLING,:FOCUSPUNCH,:GASTROACID,:GRASSKNOT,:GUNKSHOT,:HAIL,:HELPINGHAND,:HONECLAWS,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:PAYBACK,:RAINDANCE,:RECYCLE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCALD,:SHADOWCLAW,:SURF,:TAUNT,:THIEF,:TORMENT,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 135,
		:kind => "Spray",
		:dexentry => "It does not thrive in dry environments. It keeps itself damp by shooting water stored in its head tuft from its tail.",
		:BattlerPlayerY => 26,
		:BattlerEnemyY => 28,
		:BattlerAltitude => 0,
		:evolutions => [
			[:SIMIPOUR,:Item,:WATERSTONE]
		]
	},

	:OnCreation => {},
},

:SIMIPOUR => {
	"Normal Form" => {
		:name => "Simipour",
		:dexnum => 516,
		:Type1 => :WATER,
		:BaseStats => [75, 98, 63, 98, 63, 101],
		:EVs => [0, 0, 0, 0, 0, 2],
		:Abilities => [:GLUTTONY, :TORRENT],
		:GrowthRate => :MediumFast,
		:GenderRatio => :FemEighth,
		:BaseEXP => 174,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 5120,
		:preevo => {
			:species => :PANPOUR,
			:form => 0
		},
		:Moveset => [
			[1,:LEER],
			[1,:LICK],
			[1,:FURYSWIPES],
			[1,:SCALD]],
		:compatiblemoves => [:ACROBATICS,:AQUATAIL,:BLIZZARD,:BODYSLAM,:BRICKBREAK,:COVET,:CUT,:DIG,:DIVE,:ENDEAVOR,:FLING,:FOCUSBLAST,:FOCUSPUNCH,:GASTROACID,:GIGAIMPACT,:GRASSKNOT,:GUNKSHOT,:HAIL,:HELPINGHAND,:HONECLAWS,:HYPERBEAM,:ICEBEAM,:ICEPUNCH,:ICYWIND,:IRONTAIL,:KNOCKOFF,:LOWKICK,:LOWSWEEP,:MEGAPUNCH,:PAYBACK,:POWERUPPUNCH,:RAINDANCE,:RECYCLE,:ROCKSLIDE,:ROCKSMASH,:ROCKTOMB,:ROLEPLAY,:SCALD,:SHADOWCLAW,:SUPERPOWER,:SURF,:TAUNT,:THIEF,:THROATCHOP,:TORMENT,:UPROAR,:WATERFALL,:WATERPLEDGE,:WATERPULSE,:WHIRLPOOL,:WORKUP,],
		:moveexceptions => [],
		:Color => "Blue",
		:EggGroups => [:Field],
		:Height => 10,
		:Weight => 290,
		:kind => "Geyser",
		:dexentry => "The high-pressure water expelled from its tail is so powerful, it can destroy a concrete wall.",
		:BattlerPlayerY => 18,
		:BattlerEnemyY => 22,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:MUNNA => {
	"Normal Form" => {
		:name => "Munna",
		:dexnum => 517,
		:Type1 => :PSYCHIC,
		:BaseStats => [76, 25, 45, 67, 55, 24],
		:EVs => [1, 0, 0, 0, 0, 0],
		:Abilities => [:FOREWARN, :SYNCHRONIZE],
		:HiddenAbilities => :TELEPATHY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 58,
		:CatchRate => 190,
		:Happiness => 70,
		:EggSteps => 2560,
		:EggMoves => [:BARRIER,:BATONPASS,:CURSE,:HEALINGWISH,:HELPINGHAND,:MAGICCOAT,:SECRETPOWER,:SLEEPTALK,:SONICBOOM,:SWIFT,],
		:Moveset => [
			[1,:PSYWAVE],
			[1,:DEFENSECURL],
			[5,:LUCKYCHANT],
			[7,:YAWN],
			[11,:PSYBEAM],
			[13,:IMPRISON],
			[17,:MOONLIGHT],
			[19,:HYPNOSIS],
			[23,:ZENHEADBUTT],
			[25,:SYNCHRONOISE],
			[29,:NIGHTMARE],
			[31,:FUTURESIGHT],
			[35,:CALMMIND],
			[37,:PSYCHIC],
			[41,:DREAMEATER],
			[43,:TELEKINESIS],
			[47,:STOREDPOWER]],
		:compatiblemoves => [:AFTERYOU,:ALLYSWITCH,:AMNESIA,:CALMMIND,:CHARGEBEAM,:DAZZLINGGLEAM,:ENERGYBALL,:EXPANDINGFORCE,:FLASH,:FUTURESIGHT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEALBELL,:HELPINGHAND,:IMPRISON,:LIGHTSCREEN,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROCKSLIDE,:ROCKTOMB,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STOREDPOWER,:SWIFT,:TELEKINESIS,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WONDERROOM,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Field],
		:Height => 6,
		:Weight => 233,
		:kind => "Dream Eater",
		:dexentry => "It eats the dreams of people and Pokémon. When it eats a pleasant dream, it expels pink-colored mist.",
		:BattlerPlayerY => 33,
		:BattlerEnemyY => 27,
		:BattlerAltitude => 10,
		:evolutions => [
			[:MUSHARNA,:Item,:MOONSTONE]
		]
	},

	:OnCreation => {},
},

:MUSHARNA => {
	"Normal Form" => {
		:name => "Musharna",
		:dexnum => 518,
		:Type1 => :PSYCHIC,
		:BaseStats => [116, 55, 85, 107, 95, 29],
		:EVs => [2, 0, 0, 0, 0, 0],
		:Abilities => [:FOREWARN, :SYNCHRONIZE],
		:HiddenAbilities => :TELEPATHY,
		:GrowthRate => :Fast,
		:GenderRatio => :FemHalf,
		:BaseEXP => 170,
		:CatchRate => 75,
		:Happiness => 70,
		:EggSteps => 2560,
		:preevo => {
			:species => :MUNNA,
			:form => 0
		},
		:Moveset => [
			[1,:PSYCHICTERRAIN],
			[1,:DEFENSECURL],
			[1,:LUCKYCHANT],
			[1,:PSYBEAM],
			[1,:HYPNOSIS]],
		:compatiblemoves => [:AFTERYOU,:ALLYSWITCH,:AMNESIA,:CALMMIND,:CHARGEBEAM,:DAZZLINGGLEAM,:ENERGYBALL,:EXPANDINGFORCE,:FLASH,:FUTURESIGHT,:GIGAIMPACT,:GRAVITY,:GUARDSWAP,:GYROBALL,:HEALBELL,:HELPINGHAND,:HYPERBEAM,:IMPRISON,:LIGHTSCREEN,:MISTYEXPLOSION,:NIGHTMARE,:PAINSPLIT,:POWERSWAP,:PSYCHIC,:PSYCHICTERRAIN,:PSYCHUP,:PSYSHOCK,:RAINDANCE,:REFLECT,:ROCKSLIDE,:ROCKTOMB,:SAFEGUARD,:SHADOWBALL,:SHOCKWAVE,:SIGNALBEAM,:SKILLSWAP,:STOREDPOWER,:SWIFT,:TELEKINESIS,:THUNDERWAVE,:TORMENT,:TRICK,:TRICKROOM,:WONDERROOM,:WORRYSEED,:ZENHEADBUTT,],
		:moveexceptions => [],
		:Color => "Pink",
		:EggGroups => [:Field],
		:Height => 11,
		:Weight => 605,
		:kind => "Drowsing",
		:dexentry => "With the mist from its forehead, it can create shapes of things from dreams it has eaten.",
		:BattlerPlayerY => 19,
		:BattlerEnemyY => 12,
		:BattlerAltitude => 10,
	},

	:OnCreation => {},
},

:PIDOVE => {
	"Normal Form" => {
		:name => "Pidove",
		:dexnum => 519,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [50, 55, 50, 36, 30, 43],
		:EVs => [0, 1, 0, 0, 0, 0],
		:Abilities => [:BIGPECKS, :SUPERLUCK],
		:HiddenAbilities => :RIVALRY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 53,
		:CatchRate => 255,
		:Happiness => 70,
		:EggSteps => 3840,
		:EggMoves => [:BESTOW,:HYPNOSIS,:LUCKYCHANT,:MORNINGSUN,:NIGHTSLASH,:STEELWING,:UPROAR,:WISH,],
		:Moveset => [
			[1,:GUST],
			[4,:GROWL],
			[8,:LEER],
			[11,:QUICKATTACK],
			[15,:AIRCUTTER],
			[18,:ROOST],
			[22,:DETECT],
			[25,:TAUNT],
			[29,:AIRSLASH],
			[32,:RAZORWIND],
			[36,:FEATHERDANCE],
			[39,:SWAGGER],
			[43,:FACADE],
			[46,:TAILWIND],
			[50,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:FOCUSENERGY,:HEATWAVE,:PLUCK,:RAINDANCE,:STEELWING,:SUNNYDAY,:SWIFT,:TAUNT,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Flying],
		:Height => 3,
		:Weight => 21,
		:kind => "Tiny Pigeon",
		:dexentry => "These Pokémon live in cities. They are accustomed to people. Flocks often gather in parks and plazas.",
		:BattlerPlayerY => 28,
		:BattlerEnemyY => 30,
		:BattlerAltitude => 0,
		:evolutions => [
			[:TRANQUILL,:Level,21]
		]
	},

	:OnCreation => {},
},

:TRANQUILL => {
	"Normal Form" => {
		:name => "Tranquill",
		:dexnum => 520,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [62, 77, 62, 50, 42, 65],
		:EVs => [0, 2, 0, 0, 0, 0],
		:Abilities => [:BIGPECKS, :SUPERLUCK],
		:HiddenAbilities => :RIVALRY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 125,
		:CatchRate => 120,
		:Happiness => 70,
		:EggSteps => 3840,
		:preevo => {
			:species => :PIDOVE,
			:form => 0
		},
		:Moveset => [
			[1,:GUST],
			[1,:GROWL],
			[1,:LEER],
			[1,:QUICKATTACK],
			[4,:GROWL],
			[8,:LEER],
			[11,:QUICKATTACK],
			[15,:AIRCUTTER],
			[18,:ROOST],
			[23,:DETECT],
			[27,:TAUNT],
			[32,:AIRSLASH],
			[36,:RAZORWIND],
			[41,:FEATHERDANCE],
			[45,:SWAGGER],
			[50,:FACADE],
			[54,:TAILWIND],
			[59,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:FOCUSENERGY,:HEATWAVE,:PLUCK,:RAINDANCE,:STEELWING,:SUNNYDAY,:SWIFT,:TAUNT,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Flying],
		:Height => 6,
		:Weight => 150,
		:kind => "Wild Pigeon",
		:dexentry => "Many people believe that, deep in the forest where Tranquill live, there is a peaceful place where there is no war.",
		:BattlerPlayerY => 22,
		:BattlerEnemyY => 29,
		:BattlerAltitude => 0,
		:evolutions => [
			[:UNFEZANT,:Level,32]
		]
	},

	:OnCreation => {},
},

:UNFEZANT => {
	"Normal Form" => {
		:name => "Unfezant",
		:dexnum => 521,
		:Type1 => :NORMAL,
		:Type2 => :FLYING,
		:BaseStats => [80, 115, 80, 65, 55, 93],
		:EVs => [0, 3, 0, 0, 0, 0],
		:Abilities => [:BIGPECKS, :SUPERLUCK],
		:HiddenAbilities => :RIVALRY,
		:GrowthRate => :MediumSlow,
		:GenderRatio => :FemHalf,
		:BaseEXP => 220,
		:CatchRate => 45,
		:Happiness => 70,
		:EggSteps => 3840,
		:preevo => {
			:species => :TRANQUILL,
			:form => 0
		},
		:Moveset => [
			[1,:GUST],
			[1,:GROWL],
			[1,:LEER],
			[1,:QUICKATTACK],
			[4,:GROWL],
			[8,:LEER],
			[11,:QUICKATTACK],
			[15,:AIRCUTTER],
			[18,:ROOST],
			[23,:DETECT],
			[27,:TAUNT],
			[33,:AIRSLASH],
			[38,:RAZORWIND],
			[44,:FEATHERDANCE],
			[49,:SWAGGER],
			[55,:FACADE],
			[60,:TAILWIND],
			[66,:SKYATTACK]],
		:compatiblemoves => [:AERIALACE,:AGILITY,:AIRSLASH,:BRAVEBIRD,:DUALWINGBEAT,:ECHOEDVOICE,:FLY,:FOCUSENERGY,:GIGAIMPACT,:HEATWAVE,:HURRICANE,:HYPERBEAM,:PLUCK,:PSYCHUP,:RAINDANCE,:STEELWING,:SUNNYDAY,:SWIFT,:TAUNT,:UPROAR,:UTURN,:WORKUP,],
		:moveexceptions => [],
		:Color => "Gray",
		:EggGroups => [:Flying],
		:Height => 12,
		:Weight => 290,
		:kind => "Proud",
		:dexentry => "Males have plumage on their heads. They will never let themselves feel close to anyone other than their Trainers.",
		:BattlerPlayerY => 14,
		:BattlerEnemyY => 21,
		:BattlerAltitude => 0,
	},

	:OnCreation => {},
},

:BLITZLE => {
	"Normal Form" => {
		:name => "Blitzle",
		:dexnum => 522,
		:Type1 => :ELECTRIC,
		:BaseStats => [45, 60, 32, 50, 32, 76